prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "5",
        "sequence_name": "sp|P68684|RS21_SALTY",
        "sequence_description": "30S ribosomal protein S21 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpsU PE=3 SV=2",
        "proteoform_id": "5",
        "prsm_number": "9",
        "prsm": [
            {
                "prsm_id": "30",
                "p_value": "8.25e-08",
                "e_value": "8.25e-10",
                "fdr": "0",
                "matched_fragment_number": "8",
                "matched_peak_number": "9",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_2/st_1_ms2.msalign",
                        "ms1_ids": "389",
                        "ms1_scans": "763",
                        "ids": "373",
                        "scans": "764",
                        "precursor_mono_mass": "8420.6764",
                        "precursor_charge": "15",
                        "precursor_mz": "562.3857",
                        "feature_inte": "4.3789e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "373",
                                "peak_id": "0",
                                "monoisotopic_mass": "7259.9965",
                                "monoisotopic_mz": "606.0070",
                                "intensity": "25966.66",
                                "charge": "12",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7259.0569",
                                        "ion_position": "10",
                                        "ion_display_position": "60",
                                        "ion_sort_name": "Y00060",
                                        "ion_left_position": "10",
                                        "mass_error": "-0.0627",
                                        "ppm": "-8.64"
                                    }
                                }
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "1",
                                "monoisotopic_mass": "7356.0425",
                                "monoisotopic_mz": "614.0108",
                                "intensity": "128517.37",
                                "charge": "12",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7356.1096",
                                        "ion_position": "9",
                                        "ion_display_position": "61",
                                        "ion_sort_name": "Y00061",
                                        "ion_left_position": "9",
                                        "mass_error": "-0.0671",
                                        "ppm": "-9.13"
                                    }
                                }
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "2",
                                "monoisotopic_mass": "6995.8925",
                                "monoisotopic_mz": "583.9983",
                                "intensity": "77396.21",
                                "charge": "12",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6996.9615",
                                        "ion_position": "12",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0667",
                                        "ppm": "-9.53"
                                    }
                                }
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "3",
                                "monoisotopic_mass": "2377.8834",
                                "monoisotopic_mz": "199.1642",
                                "intensity": "12675.92",
                                "charge": "12"
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "4",
                                "monoisotopic_mass": "7703.7572",
                                "monoisotopic_mz": "593.6040",
                                "intensity": "20604.82",
                                "charge": "13"
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "5",
                                "monoisotopic_mass": "1981.3372",
                                "monoisotopic_mz": "199.1410",
                                "intensity": "21630.96",
                                "charge": "10"
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "6",
                                "monoisotopic_mass": "7339.0141",
                                "monoisotopic_mz": "612.5918",
                                "intensity": "33788.05",
                                "charge": "12"
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "7",
                                "monoisotopic_mass": "4062.2267",
                                "monoisotopic_mz": "508.7856",
                                "intensity": "24326.37",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4062.2650",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "B00034",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0383",
                                        "ppm": "-9.42"
                                    }
                                }
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "8",
                                "monoisotopic_mass": "7313.0407",
                                "monoisotopic_mz": "610.4273",
                                "intensity": "19955.26",
                                "charge": "12"
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "9",
                                "monoisotopic_mass": "4340.3903",
                                "monoisotopic_mz": "621.0630",
                                "intensity": "50869.72",
                                "charge": "7"
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "10",
                                "monoisotopic_mass": "4358.3902",
                                "monoisotopic_mz": "623.6344",
                                "intensity": "16176.06",
                                "charge": "7"
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "11",
                                "monoisotopic_mass": "1423.7319",
                                "monoisotopic_mz": "712.8732",
                                "intensity": "17087.27",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1423.7460",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0141",
                                        "ppm": "-9.87"
                                    }
                                }
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "12",
                                "monoisotopic_mass": "2638.4984",
                                "monoisotopic_mz": "440.7570",
                                "intensity": "13445.71",
                                "charge": "6"
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "13",
                                "monoisotopic_mass": "4925.7785",
                                "monoisotopic_mz": "616.7296",
                                "intensity": "16838.18",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4925.8142",
                                        "ion_position": "30",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0357",
                                        "ppm": "-7.25"
                                    }
                                }
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "14",
                                "monoisotopic_mass": "2638.4915",
                                "monoisotopic_mz": "528.7056",
                                "intensity": "13469.18",
                                "charge": "5"
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "15",
                                "monoisotopic_mass": "1206.3592",
                                "monoisotopic_mz": "604.1869",
                                "intensity": "5772.99",
                                "charge": "2"
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "16",
                                "monoisotopic_mass": "1454.1360",
                                "monoisotopic_mz": "728.0753",
                                "intensity": "3341.07",
                                "charge": "2"
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "17",
                                "monoisotopic_mass": "4340.3966",
                                "monoisotopic_mz": "724.4067",
                                "intensity": "13785.62",
                                "charge": "6"
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "18",
                                "monoisotopic_mass": "3490.4438",
                                "monoisotopic_mz": "582.7479",
                                "intensity": "10222.67",
                                "charge": "6"
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "19",
                                "monoisotopic_mass": "1498.8194",
                                "monoisotopic_mz": "500.6137",
                                "intensity": "5991.23",
                                "charge": "3"
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "20",
                                "monoisotopic_mass": "1064.5896",
                                "monoisotopic_mz": "355.8705",
                                "intensity": "6236.99",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1064.5978",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "-0.0082",
                                        "ppm": "-7.72"
                                    }
                                }
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "21",
                                "monoisotopic_mass": "1423.7320",
                                "monoisotopic_mz": "475.5846",
                                "intensity": "4743.56",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1423.7460",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0140",
                                        "ppm": "-9.84"
                                    }
                                }
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "22",
                                "monoisotopic_mass": "4295.3662",
                                "monoisotopic_mz": "614.6310",
                                "intensity": "10053.69",
                                "charge": "7"
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "23",
                                "monoisotopic_mass": "1161.6416",
                                "monoisotopic_mz": "581.8281",
                                "intensity": "4004.15",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1161.6506",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "-0.0090",
                                        "ppm": "-7.75"
                                    }
                                }
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "24",
                                "monoisotopic_mass": "2575.9163",
                                "monoisotopic_mz": "199.1547",
                                "intensity": "12561.83",
                                "charge": "13"
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "25",
                                "monoisotopic_mass": "1220.9417",
                                "monoisotopic_mz": "611.4782",
                                "intensity": "4129.04",
                                "charge": "2"
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "26",
                                "monoisotopic_mass": "2460.3670",
                                "monoisotopic_mz": "616.0990",
                                "intensity": "5000.54",
                                "charge": "4"
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "27",
                                "monoisotopic_mass": "791.2460",
                                "monoisotopic_mz": "198.8188",
                                "intensity": "6082.20",
                                "charge": "4"
                            },
                            {
                                "spec_id": "373",
                                "peak_id": "28",
                                "monoisotopic_mass": "726.5666",
                                "monoisotopic_mz": "727.5739",
                                "intensity": "6625.18",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "5",
                    "proteoform_id": "5",
                    "sequence_name": "sp|P68684|RS21_SALTY",
                    "sequence_description": "30S ribosomal protein S21 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpsU PE=3 SV=2",
                    "proteoform_mass": "8420.7075",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "71",
                        "first_residue_position": "1",
                        "last_residue_position": "70",
                        "annotated_seq": "M.PVIKVRENEPFDVALRRFKRS(C)[Carbamidomethylation]EKAGVLAEVRRREFYEKPTTERKRAKASAVKRHAKKLARENARRTRLY.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "P"
                            },
                            {
                                "position": "2",
                                "acid": "V"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "V"
                            },
                            {
                                "position": "6",
                                "acid": "R"
                            },
                            {
                                "position": "7",
                                "acid": "E"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "E"
                            },
                            {
                                "position": "10",
                                "acid": "P"
                            },
                            {
                                "position": "11",
                                "acid": "F"
                            },
                            {
                                "position": "12",
                                "acid": "D"
                            },
                            {
                                "position": "13",
                                "acid": "V"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "R"
                            },
                            {
                                "position": "17",
                                "acid": "R"
                            },
                            {
                                "position": "18",
                                "acid": "F"
                            },
                            {
                                "position": "19",
                                "acid": "K"
                            },
                            {
                                "position": "20",
                                "acid": "R"
                            },
                            {
                                "position": "21",
                                "acid": "S"
                            },
                            {
                                "position": "22",
                                "acid": "C"
                            },
                            {
                                "position": "23",
                                "acid": "E"
                            },
                            {
                                "position": "24",
                                "acid": "K"
                            },
                            {
                                "position": "25",
                                "acid": "A"
                            },
                            {
                                "position": "26",
                                "acid": "G"
                            },
                            {
                                "position": "27",
                                "acid": "V"
                            },
                            {
                                "position": "28",
                                "acid": "L"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "R"
                            },
                            {
                                "position": "33",
                                "acid": "R"
                            },
                            {
                                "position": "34",
                                "acid": "R"
                            },
                            {
                                "position": "35",
                                "acid": "E"
                            },
                            {
                                "position": "36",
                                "acid": "F"
                            },
                            {
                                "position": "37",
                                "acid": "Y"
                            },
                            {
                                "position": "38",
                                "acid": "E"
                            },
                            {
                                "position": "39",
                                "acid": "K"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "T"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "E"
                            },
                            {
                                "position": "44",
                                "acid": "R"
                            },
                            {
                                "position": "45",
                                "acid": "K"
                            },
                            {
                                "position": "46",
                                "acid": "R"
                            },
                            {
                                "position": "47",
                                "acid": "A"
                            },
                            {
                                "position": "48",
                                "acid": "K"
                            },
                            {
                                "position": "49",
                                "acid": "A"
                            },
                            {
                                "position": "50",
                                "acid": "S"
                            },
                            {
                                "position": "51",
                                "acid": "A"
                            },
                            {
                                "position": "52",
                                "acid": "V"
                            },
                            {
                                "position": "53",
                                "acid": "K"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "H"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "K"
                            },
                            {
                                "position": "58",
                                "acid": "K"
                            },
                            {
                                "position": "59",
                                "acid": "L"
                            },
                            {
                                "position": "60",
                                "acid": "A"
                            },
                            {
                                "position": "61",
                                "acid": "R"
                            },
                            {
                                "position": "62",
                                "acid": "E"
                            },
                            {
                                "position": "63",
                                "acid": "N"
                            },
                            {
                                "position": "64",
                                "acid": "A"
                            },
                            {
                                "position": "65",
                                "acid": "R"
                            },
                            {
                                "position": "66",
                                "acid": "R"
                            },
                            {
                                "position": "67",
                                "acid": "T"
                            },
                            {
                                "position": "68",
                                "acid": "R"
                            },
                            {
                                "position": "69",
                                "acid": "L"
                            },
                            {
                                "position": "70",
                                "acid": "Y"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "9",
                                            "ion_display_position": "9",
                                            "spec_id": "373",
                                            "peak_id": "20",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "9",
                                            "ion_display_position": "61",
                                            "spec_id": "373",
                                            "peak_id": "1",
                                            "peak_charge": "12"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "10",
                                            "ion_display_position": "10",
                                            "spec_id": "373",
                                            "peak_id": "23",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "10",
                                            "ion_display_position": "60",
                                            "spec_id": "373",
                                            "peak_id": "0",
                                            "peak_charge": "12"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "373",
                                            "peak_id": "11",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "373",
                                            "peak_id": "21",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "12",
                                            "ion_display_position": "58",
                                            "spec_id": "373",
                                            "peak_id": "2",
                                            "peak_charge": "12"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "30",
                                        "ion_display_position": "40",
                                        "spec_id": "373",
                                        "peak_id": "13",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "spec_id": "373",
                                        "peak_id": "7",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": {
                                "left_pos": "22",
                                "right_pos": "23",
                                "anno": "C"
                            }
                        }
                    }
                }
            },
            {
                "prsm_id": "21",
                "p_value": "9.35e-08",
                "e_value": "9.35e-10",
                "fdr": "0",
                "matched_fragment_number": "11",
                "matched_peak_number": "13",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_2/st_1_ms2.msalign",
                        "ms1_ids": "360",
                        "ms1_scans": "705",
                        "ids": "344",
                        "scans": "706",
                        "precursor_mono_mass": "8420.6381",
                        "precursor_charge": "14",
                        "precursor_mz": "602.4814",
                        "feature_inte": "1.2933e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "344",
                                "peak_id": "0",
                                "monoisotopic_mass": "7819.7841",
                                "monoisotopic_mz": "602.5291",
                                "intensity": "7817.21",
                                "charge": "13"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "1",
                                "monoisotopic_mass": "6996.9036",
                                "monoisotopic_mz": "637.0894",
                                "intensity": "24696.00",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6996.9615",
                                        "ion_position": "12",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0579",
                                        "ppm": "-8.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "2",
                                "monoisotopic_mass": "7982.3333",
                                "monoisotopic_mz": "666.2017",
                                "intensity": "18007.75",
                                "charge": "12",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7983.4073",
                                        "ion_position": "4",
                                        "ion_display_position": "66",
                                        "ion_sort_name": "Y00066",
                                        "ion_left_position": "4",
                                        "mass_error": "-0.0716",
                                        "ppm": "-8.97"
                                    }
                                }
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "3",
                                "monoisotopic_mass": "8111.4523",
                                "monoisotopic_mz": "676.9616",
                                "intensity": "12178.00",
                                "charge": "12",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8111.5022",
                                        "ion_position": "3",
                                        "ion_display_position": "67",
                                        "ion_sort_name": "Y00067",
                                        "ion_left_position": "3",
                                        "mass_error": "-0.0500",
                                        "ppm": "-6.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "4",
                                "monoisotopic_mass": "4925.7746",
                                "monoisotopic_mz": "616.7291",
                                "intensity": "32504.71",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4925.8142",
                                        "ion_position": "30",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0396",
                                        "ppm": "-8.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "5",
                                "monoisotopic_mass": "4925.7722",
                                "monoisotopic_mz": "548.3153",
                                "intensity": "66956.08",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4925.8142",
                                        "ion_position": "30",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0420",
                                        "ppm": "-8.52"
                                    }
                                }
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "6",
                                "monoisotopic_mass": "4881.7480",
                                "monoisotopic_mz": "543.4237",
                                "intensity": "15471.60",
                                "charge": "9"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "7",
                                "monoisotopic_mass": "8223.5199",
                                "monoisotopic_mz": "633.5857",
                                "intensity": "34508.51",
                                "charge": "13",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8224.5863",
                                        "ion_position": "2",
                                        "ion_display_position": "68",
                                        "ion_sort_name": "Y00068",
                                        "ion_left_position": "2",
                                        "mass_error": "-0.0640",
                                        "ppm": "-7.78"
                                    }
                                }
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "8",
                                "monoisotopic_mass": "6979.8820",
                                "monoisotopic_mz": "635.5420",
                                "intensity": "15168.05",
                                "charge": "11"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "9",
                                "monoisotopic_mass": "6834.8477",
                                "monoisotopic_mz": "622.3571",
                                "intensity": "4460.48",
                                "charge": "11"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "10",
                                "monoisotopic_mass": "7965.3308",
                                "monoisotopic_mz": "664.7848",
                                "intensity": "7185.48",
                                "charge": "12"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "11",
                                "monoisotopic_mass": "4907.7499",
                                "monoisotopic_mz": "546.3128",
                                "intensity": "15708.90",
                                "charge": "9"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "12",
                                "monoisotopic_mass": "8094.3868",
                                "monoisotopic_mz": "675.5395",
                                "intensity": "9615.44",
                                "charge": "12"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "13",
                                "monoisotopic_mass": "3866.1091",
                                "monoisotopic_mz": "645.3588",
                                "intensity": "17358.27",
                                "charge": "6"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "14",
                                "monoisotopic_mass": "1783.1255",
                                "monoisotopic_mz": "199.1323",
                                "intensity": "4514.59",
                                "charge": "9"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "15",
                                "monoisotopic_mass": "4340.3959",
                                "monoisotopic_mz": "621.0638",
                                "intensity": "50539.07",
                                "charge": "7"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "16",
                                "monoisotopic_mass": "3298.7356",
                                "monoisotopic_mz": "825.6912",
                                "intensity": "10245.66",
                                "charge": "4"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "17",
                                "monoisotopic_mass": "2596.4775",
                                "monoisotopic_mz": "520.3028",
                                "intensity": "12303.70",
                                "charge": "5"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "18",
                                "monoisotopic_mass": "1981.2399",
                                "monoisotopic_mz": "199.1313",
                                "intensity": "2574.45",
                                "charge": "10"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "19",
                                "monoisotopic_mass": "8003.3827",
                                "monoisotopic_mz": "667.9558",
                                "intensity": "8396.36",
                                "charge": "12"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "20",
                                "monoisotopic_mass": "3494.8633",
                                "monoisotopic_mz": "699.9799",
                                "intensity": "38517.56",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3494.8933",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0299",
                                        "ppm": "-8.56"
                                    }
                                }
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "21",
                                "monoisotopic_mass": "7356.0487",
                                "monoisotopic_mz": "669.7390",
                                "intensity": "11807.09",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7356.1096",
                                        "ion_position": "9",
                                        "ion_display_position": "61",
                                        "ion_sort_name": "Y00061",
                                        "ion_left_position": "9",
                                        "mass_error": "-0.0609",
                                        "ppm": "-8.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "22",
                                "monoisotopic_mass": "2071.1290",
                                "monoisotopic_mz": "691.3836",
                                "intensity": "25813.44",
                                "charge": "3"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "23",
                                "monoisotopic_mass": "4358.4000",
                                "monoisotopic_mz": "623.6359",
                                "intensity": "21664.83",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4358.4425",
                                        "ion_position": "34",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "Y00036",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0424",
                                        "ppm": "-9.74"
                                    }
                                }
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "24",
                                "monoisotopic_mass": "4323.3757",
                                "monoisotopic_mz": "618.6324",
                                "intensity": "9805.23",
                                "charge": "7"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "25",
                                "monoisotopic_mass": "2638.4969",
                                "monoisotopic_mz": "528.7066",
                                "intensity": "43418.11",
                                "charge": "5"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "26",
                                "monoisotopic_mass": "1423.7337",
                                "monoisotopic_mz": "712.8741",
                                "intensity": "49749.36",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1423.7460",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0122",
                                        "ppm": "-8.59"
                                    }
                                }
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "27",
                                "monoisotopic_mass": "4323.3670",
                                "monoisotopic_mz": "721.5684",
                                "intensity": "9094.54",
                                "charge": "6"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "28",
                                "monoisotopic_mass": "8323.5647",
                                "monoisotopic_mz": "641.2815",
                                "intensity": "4668.79",
                                "charge": "13"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "29",
                                "monoisotopic_mass": "2638.4948",
                                "monoisotopic_mz": "440.7564",
                                "intensity": "7123.50",
                                "charge": "6"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "30",
                                "monoisotopic_mass": "4340.3921",
                                "monoisotopic_mz": "724.4060",
                                "intensity": "22497.84",
                                "charge": "6"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "31",
                                "monoisotopic_mass": "4358.4024",
                                "monoisotopic_mz": "727.4077",
                                "intensity": "19683.66",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4358.4425",
                                        "ion_position": "34",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "Y00036",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0400",
                                        "ppm": "-9.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "32",
                                "monoisotopic_mass": "986.4391",
                                "monoisotopic_mz": "987.4464",
                                "intensity": "3339.08",
                                "charge": "1"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "33",
                                "monoisotopic_mass": "1064.5878",
                                "monoisotopic_mz": "1065.5951",
                                "intensity": "2093.66",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1064.5978",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "-0.0100",
                                        "ppm": "-9.42"
                                    }
                                }
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "34",
                                "monoisotopic_mass": "1114.5283",
                                "monoisotopic_mz": "1115.5355",
                                "intensity": "3622.74",
                                "charge": "1"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "35",
                                "monoisotopic_mass": "1324.5534",
                                "monoisotopic_mz": "663.2840",
                                "intensity": "1595.33",
                                "charge": "2"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "36",
                                "monoisotopic_mass": "1227.6149",
                                "monoisotopic_mz": "1228.6222",
                                "intensity": "3030.44",
                                "charge": "1"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "37",
                                "monoisotopic_mass": "1387.7796",
                                "monoisotopic_mz": "694.8971",
                                "intensity": "1352.69",
                                "charge": "2"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "38",
                                "monoisotopic_mass": "525.3463",
                                "monoisotopic_mz": "263.6804",
                                "intensity": "3237.15",
                                "charge": "2"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "39",
                                "monoisotopic_mass": "4296.3678",
                                "monoisotopic_mz": "717.0686",
                                "intensity": "10685.92",
                                "charge": "6"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "40",
                                "monoisotopic_mass": "533.2917",
                                "monoisotopic_mz": "534.2989",
                                "intensity": "2567.05",
                                "charge": "1"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "41",
                                "monoisotopic_mass": "1307.0775",
                                "monoisotopic_mz": "654.5460",
                                "intensity": "1458.51",
                                "charge": "2"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "42",
                                "monoisotopic_mass": "2508.3972",
                                "monoisotopic_mz": "628.1066",
                                "intensity": "1998.46",
                                "charge": "4"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "43",
                                "monoisotopic_mass": "3824.0868",
                                "monoisotopic_mz": "638.3551",
                                "intensity": "5186.10",
                                "charge": "6"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "44",
                                "monoisotopic_mass": "7762.0543",
                                "monoisotopic_mz": "647.8451",
                                "intensity": "2580.31",
                                "charge": "12"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "45",
                                "monoisotopic_mass": "3624.9365",
                                "monoisotopic_mz": "605.1634",
                                "intensity": "2989.92",
                                "charge": "6"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "46",
                                "monoisotopic_mass": "2263.6033",
                                "monoisotopic_mz": "566.9081",
                                "intensity": "2599.02",
                                "charge": "4"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "47",
                                "monoisotopic_mass": "8181.4504",
                                "monoisotopic_mz": "630.3496",
                                "intensity": "6127.50",
                                "charge": "13"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "48",
                                "monoisotopic_mass": "4297.3679",
                                "monoisotopic_mz": "614.9170",
                                "intensity": "11834.85",
                                "charge": "7"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "49",
                                "monoisotopic_mass": "7109.9343",
                                "monoisotopic_mz": "647.3649",
                                "intensity": "5195.31",
                                "charge": "11"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "50",
                                "monoisotopic_mass": "2690.1482",
                                "monoisotopic_mz": "673.5443",
                                "intensity": "2448.47",
                                "charge": "4"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "51",
                                "monoisotopic_mass": "3752.0073",
                                "monoisotopic_mz": "626.3418",
                                "intensity": "4713.39",
                                "charge": "6"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "52",
                                "monoisotopic_mass": "2621.4804",
                                "monoisotopic_mz": "525.3034",
                                "intensity": "3229.88",
                                "charge": "5"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "53",
                                "monoisotopic_mass": "5283.0082",
                                "monoisotopic_mz": "529.3081",
                                "intensity": "9838.99",
                                "charge": "10"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "54",
                                "monoisotopic_mass": "1369.0506",
                                "monoisotopic_mz": "685.5326",
                                "intensity": "1407.82",
                                "charge": "2"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "55",
                                "monoisotopic_mass": "6994.7377",
                                "monoisotopic_mz": "700.4810",
                                "intensity": "5836.15",
                                "charge": "10"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "56",
                                "monoisotopic_mass": "1216.4308",
                                "monoisotopic_mz": "609.2227",
                                "intensity": "3891.92",
                                "charge": "2"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "57",
                                "monoisotopic_mass": "6147.5536",
                                "monoisotopic_mz": "684.0688",
                                "intensity": "3310.96",
                                "charge": "9"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "58",
                                "monoisotopic_mass": "4907.7473",
                                "monoisotopic_mz": "614.4757",
                                "intensity": "9168.42",
                                "charge": "8"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "59",
                                "monoisotopic_mass": "4177.3422",
                                "monoisotopic_mz": "697.2310",
                                "intensity": "3666.58",
                                "charge": "6"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "60",
                                "monoisotopic_mass": "1894.5900",
                                "monoisotopic_mz": "632.5373",
                                "intensity": "2670.63",
                                "charge": "3"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "61",
                                "monoisotopic_mass": "4082.2856",
                                "monoisotopic_mz": "681.3882",
                                "intensity": "3016.69",
                                "charge": "6"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "62",
                                "monoisotopic_mass": "4666.9991",
                                "monoisotopic_mz": "667.7214",
                                "intensity": "2342.39",
                                "charge": "7"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "63",
                                "monoisotopic_mass": "3907.1445",
                                "monoisotopic_mz": "652.1980",
                                "intensity": "2089.80",
                                "charge": "6"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "64",
                                "monoisotopic_mass": "5638.7269",
                                "monoisotopic_mz": "627.5325",
                                "intensity": "1643.92",
                                "charge": "9"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "65",
                                "monoisotopic_mass": "3662.0997",
                                "monoisotopic_mz": "611.3572",
                                "intensity": "8094.94",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3662.1306",
                                        "ion_position": "39",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "Y00031",
                                        "ion_left_position": "39",
                                        "mass_error": "-0.0309",
                                        "ppm": "-8.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "66",
                                "monoisotopic_mass": "8258.5625",
                                "monoisotopic_mz": "636.2813",
                                "intensity": "5349.76",
                                "charge": "13"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "67",
                                "monoisotopic_mass": "4271.1474",
                                "monoisotopic_mz": "611.1712",
                                "intensity": "8165.09",
                                "charge": "7"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "68",
                                "monoisotopic_mass": "6936.9018",
                                "monoisotopic_mz": "631.6347",
                                "intensity": "3412.66",
                                "charge": "11"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "69",
                                "monoisotopic_mass": "660.7092",
                                "monoisotopic_mz": "661.7164",
                                "intensity": "2156.14",
                                "charge": "1"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "70",
                                "monoisotopic_mass": "5661.7938",
                                "monoisotopic_mz": "630.0955",
                                "intensity": "1671.53",
                                "charge": "9"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "71",
                                "monoisotopic_mass": "5082.7117",
                                "monoisotopic_mz": "636.3462",
                                "intensity": "5846.32",
                                "charge": "8"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "72",
                                "monoisotopic_mass": "3681.5681",
                                "monoisotopic_mz": "614.6020",
                                "intensity": "5593.42",
                                "charge": "6"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "5",
                    "proteoform_id": "5",
                    "sequence_name": "sp|P68684|RS21_SALTY",
                    "sequence_description": "30S ribosomal protein S21 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpsU PE=3 SV=2",
                    "proteoform_mass": "8420.7075",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "71",
                        "first_residue_position": "1",
                        "last_residue_position": "70",
                        "annotated_seq": "M.PVIKVRENEPFDVALRRFKRS(C)[Carbamidomethylation]EKAGVLAEVRRREFYEKPTTERKRAKASAVKRHAKKLARENARRTRLY.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "P"
                            },
                            {
                                "position": "2",
                                "acid": "V"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "V"
                            },
                            {
                                "position": "6",
                                "acid": "R"
                            },
                            {
                                "position": "7",
                                "acid": "E"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "E"
                            },
                            {
                                "position": "10",
                                "acid": "P"
                            },
                            {
                                "position": "11",
                                "acid": "F"
                            },
                            {
                                "position": "12",
                                "acid": "D"
                            },
                            {
                                "position": "13",
                                "acid": "V"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "R"
                            },
                            {
                                "position": "17",
                                "acid": "R"
                            },
                            {
                                "position": "18",
                                "acid": "F"
                            },
                            {
                                "position": "19",
                                "acid": "K"
                            },
                            {
                                "position": "20",
                                "acid": "R"
                            },
                            {
                                "position": "21",
                                "acid": "S"
                            },
                            {
                                "position": "22",
                                "acid": "C"
                            },
                            {
                                "position": "23",
                                "acid": "E"
                            },
                            {
                                "position": "24",
                                "acid": "K"
                            },
                            {
                                "position": "25",
                                "acid": "A"
                            },
                            {
                                "position": "26",
                                "acid": "G"
                            },
                            {
                                "position": "27",
                                "acid": "V"
                            },
                            {
                                "position": "28",
                                "acid": "L"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "R"
                            },
                            {
                                "position": "33",
                                "acid": "R"
                            },
                            {
                                "position": "34",
                                "acid": "R"
                            },
                            {
                                "position": "35",
                                "acid": "E"
                            },
                            {
                                "position": "36",
                                "acid": "F"
                            },
                            {
                                "position": "37",
                                "acid": "Y"
                            },
                            {
                                "position": "38",
                                "acid": "E"
                            },
                            {
                                "position": "39",
                                "acid": "K"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "T"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "E"
                            },
                            {
                                "position": "44",
                                "acid": "R"
                            },
                            {
                                "position": "45",
                                "acid": "K"
                            },
                            {
                                "position": "46",
                                "acid": "R"
                            },
                            {
                                "position": "47",
                                "acid": "A"
                            },
                            {
                                "position": "48",
                                "acid": "K"
                            },
                            {
                                "position": "49",
                                "acid": "A"
                            },
                            {
                                "position": "50",
                                "acid": "S"
                            },
                            {
                                "position": "51",
                                "acid": "A"
                            },
                            {
                                "position": "52",
                                "acid": "V"
                            },
                            {
                                "position": "53",
                                "acid": "K"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "H"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "K"
                            },
                            {
                                "position": "58",
                                "acid": "K"
                            },
                            {
                                "position": "59",
                                "acid": "L"
                            },
                            {
                                "position": "60",
                                "acid": "A"
                            },
                            {
                                "position": "61",
                                "acid": "R"
                            },
                            {
                                "position": "62",
                                "acid": "E"
                            },
                            {
                                "position": "63",
                                "acid": "N"
                            },
                            {
                                "position": "64",
                                "acid": "A"
                            },
                            {
                                "position": "65",
                                "acid": "R"
                            },
                            {
                                "position": "66",
                                "acid": "R"
                            },
                            {
                                "position": "67",
                                "acid": "T"
                            },
                            {
                                "position": "68",
                                "acid": "R"
                            },
                            {
                                "position": "69",
                                "acid": "L"
                            },
                            {
                                "position": "70",
                                "acid": "Y"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "2",
                                        "ion_display_position": "68",
                                        "spec_id": "344",
                                        "peak_id": "7",
                                        "peak_charge": "13"
                                    }
                                }
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "3",
                                        "ion_display_position": "67",
                                        "spec_id": "344",
                                        "peak_id": "3",
                                        "peak_charge": "12"
                                    }
                                }
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "4",
                                        "ion_display_position": "66",
                                        "spec_id": "344",
                                        "peak_id": "2",
                                        "peak_charge": "12"
                                    }
                                }
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "9",
                                            "ion_display_position": "9",
                                            "spec_id": "344",
                                            "peak_id": "33",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "9",
                                            "ion_display_position": "61",
                                            "spec_id": "344",
                                            "peak_id": "21",
                                            "peak_charge": "11"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "344",
                                            "peak_id": "26",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "12",
                                            "ion_display_position": "58",
                                            "spec_id": "344",
                                            "peak_id": "1",
                                            "peak_charge": "11"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "30",
                                            "ion_display_position": "30",
                                            "spec_id": "344",
                                            "peak_id": "20",
                                            "peak_charge": "5"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "30",
                                            "ion_display_position": "40",
                                            "spec_id": "344",
                                            "peak_id": "5",
                                            "peak_charge": "9"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "30",
                                            "ion_display_position": "40",
                                            "spec_id": "344",
                                            "peak_id": "4",
                                            "peak_charge": "8"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "34",
                                            "ion_display_position": "36",
                                            "spec_id": "344",
                                            "peak_id": "23",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "34",
                                            "ion_display_position": "36",
                                            "spec_id": "344",
                                            "peak_id": "31",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "39",
                                        "ion_display_position": "31",
                                        "spec_id": "344",
                                        "peak_id": "65",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": {
                                "left_pos": "22",
                                "right_pos": "23",
                                "anno": "C"
                            }
                        }
                    }
                }
            },
            {
                "prsm_id": "26",
                "p_value": "9.51e-08",
                "e_value": "9.51e-10",
                "fdr": "0",
                "matched_fragment_number": "14",
                "matched_peak_number": "18",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_2/st_1_ms2.msalign",
                        "ms1_ids": "384",
                        "ms1_scans": "753",
                        "ids": "368",
                        "scans": "754",
                        "precursor_mono_mass": "8420.6725",
                        "precursor_charge": "15",
                        "precursor_mz": "562.3854",
                        "feature_inte": "1.1444e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "368",
                                "peak_id": "0",
                                "monoisotopic_mass": "7111.9268",
                                "monoisotopic_mz": "593.6678",
                                "intensity": "66570.84",
                                "charge": "12",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7111.9884",
                                        "ion_position": "11",
                                        "ion_display_position": "59",
                                        "ion_sort_name": "Y00059",
                                        "ion_left_position": "11",
                                        "mass_error": "-0.0617",
                                        "ppm": "-8.67"
                                    }
                                }
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "1",
                                "monoisotopic_mass": "7258.9897",
                                "monoisotopic_mz": "605.9231",
                                "intensity": "58925.93",
                                "charge": "12",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7259.0569",
                                        "ion_position": "10",
                                        "ion_display_position": "60",
                                        "ion_sort_name": "Y00060",
                                        "ion_left_position": "10",
                                        "mass_error": "-0.0671",
                                        "ppm": "-9.25"
                                    }
                                }
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "2",
                                "monoisotopic_mass": "8224.5103",
                                "monoisotopic_mz": "588.4723",
                                "intensity": "45292.34",
                                "charge": "14",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8224.5863",
                                        "ion_position": "2",
                                        "ion_display_position": "68",
                                        "ion_sort_name": "Y00068",
                                        "ion_left_position": "2",
                                        "mass_error": "-0.0759",
                                        "ppm": "-9.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "3",
                                "monoisotopic_mass": "6996.9007",
                                "monoisotopic_mz": "584.0823",
                                "intensity": "202780.54",
                                "charge": "12",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6996.9615",
                                        "ion_position": "12",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0608",
                                        "ppm": "-8.69"
                                    }
                                }
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "4",
                                "monoisotopic_mass": "7339.0163",
                                "monoisotopic_mz": "612.5920",
                                "intensity": "83776.88",
                                "charge": "12"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "5",
                                "monoisotopic_mass": "7356.0440",
                                "monoisotopic_mz": "614.0109",
                                "intensity": "391170.11",
                                "charge": "12",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7356.1096",
                                        "ion_position": "9",
                                        "ion_display_position": "61",
                                        "ion_sort_name": "Y00061",
                                        "ion_left_position": "9",
                                        "mass_error": "-0.0657",
                                        "ppm": "-8.93"
                                    }
                                }
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "6",
                                "monoisotopic_mass": "4925.7721",
                                "monoisotopic_mz": "616.7288",
                                "intensity": "95823.01",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4925.8142",
                                        "ion_position": "30",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0421",
                                        "ppm": "-8.54"
                                    }
                                }
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "7",
                                "monoisotopic_mass": "7312.0039",
                                "monoisotopic_mz": "610.3409",
                                "intensity": "70564.20",
                                "charge": "12"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "8",
                                "monoisotopic_mass": "4062.2285",
                                "monoisotopic_mz": "508.7858",
                                "intensity": "77991.81",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4062.2650",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "B00034",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0365",
                                        "ppm": "-9.00"
                                    }
                                }
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "9",
                                "monoisotopic_mass": "6996.9050",
                                "monoisotopic_mz": "637.0895",
                                "intensity": "26362.48",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6996.9615",
                                        "ion_position": "12",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0565",
                                        "ppm": "-8.08"
                                    }
                                }
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "10",
                                "monoisotopic_mass": "7904.2542",
                                "monoisotopic_mz": "609.0268",
                                "intensity": "19832.13",
                                "charge": "13"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "11",
                                "monoisotopic_mass": "4340.3929",
                                "monoisotopic_mz": "621.0634",
                                "intensity": "153362.21",
                                "charge": "7"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "12",
                                "monoisotopic_mass": "4358.4024",
                                "monoisotopic_mz": "727.4077",
                                "intensity": "48933.30",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4358.4425",
                                        "ion_position": "34",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "Y00036",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0400",
                                        "ppm": "-9.18"
                                    }
                                }
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "13",
                                "monoisotopic_mass": "8323.5989",
                                "monoisotopic_mz": "595.5501",
                                "intensity": "34054.69",
                                "charge": "14",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8323.6547",
                                        "ion_position": "1",
                                        "ion_display_position": "69",
                                        "ion_sort_name": "Y00069",
                                        "ion_left_position": "1",
                                        "mass_error": "-0.0558",
                                        "ppm": "-6.70"
                                    }
                                }
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "14",
                                "monoisotopic_mass": "2071.1269",
                                "monoisotopic_mz": "691.3829",
                                "intensity": "21627.71",
                                "charge": "3"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "15",
                                "monoisotopic_mass": "4322.3746",
                                "monoisotopic_mz": "618.4894",
                                "intensity": "33197.16",
                                "charge": "7"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "16",
                                "monoisotopic_mass": "1423.7340",
                                "monoisotopic_mz": "712.8743",
                                "intensity": "51157.53",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1423.7460",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0120",
                                        "ppm": "-8.42"
                                    }
                                }
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "17",
                                "monoisotopic_mass": "2638.4956",
                                "monoisotopic_mz": "528.7064",
                                "intensity": "33685.28",
                                "charge": "5"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "18",
                                "monoisotopic_mass": "2638.4992",
                                "monoisotopic_mz": "440.7571",
                                "intensity": "32780.81",
                                "charge": "6"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "19",
                                "monoisotopic_mass": "4340.3889",
                                "monoisotopic_mz": "724.4054",
                                "intensity": "59932.78",
                                "charge": "6"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "20",
                                "monoisotopic_mass": "4924.7667",
                                "monoisotopic_mz": "493.4840",
                                "intensity": "20576.07",
                                "charge": "10"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "21",
                                "monoisotopic_mass": "7214.8880",
                                "monoisotopic_mz": "656.9062",
                                "intensity": "20282.19",
                                "charge": "11"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "22",
                                "monoisotopic_mass": "2596.4766",
                                "monoisotopic_mz": "520.3026",
                                "intensity": "13581.87",
                                "charge": "5"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "23",
                                "monoisotopic_mass": "2997.6388",
                                "monoisotopic_mz": "500.6137",
                                "intensity": "35099.20",
                                "charge": "6"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "24",
                                "monoisotopic_mass": "6466.9622",
                                "monoisotopic_mz": "647.7035",
                                "intensity": "8267.10",
                                "charge": "10"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "25",
                                "monoisotopic_mass": "755.3877",
                                "monoisotopic_mz": "756.3950",
                                "intensity": "8394.94",
                                "charge": "1"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "26",
                                "monoisotopic_mass": "2301.9460",
                                "monoisotopic_mz": "576.4938",
                                "intensity": "5959.74",
                                "charge": "4"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "27",
                                "monoisotopic_mass": "2071.1350",
                                "monoisotopic_mz": "518.7910",
                                "intensity": "9119.08",
                                "charge": "4"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "28",
                                "monoisotopic_mass": "1423.7334",
                                "monoisotopic_mz": "475.5851",
                                "intensity": "18857.47",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1423.7460",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0125",
                                        "ppm": "-8.81"
                                    }
                                }
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "29",
                                "monoisotopic_mass": "1161.6422",
                                "monoisotopic_mz": "388.2213",
                                "intensity": "13825.77",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1161.6506",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "-0.0084",
                                        "ppm": "-7.24"
                                    }
                                }
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "30",
                                "monoisotopic_mass": "1263.6738",
                                "monoisotopic_mz": "422.2319",
                                "intensity": "16352.58",
                                "charge": "3"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "31",
                                "monoisotopic_mass": "1843.0558",
                                "monoisotopic_mz": "461.7712",
                                "intensity": "10307.64",
                                "charge": "4"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "32",
                                "monoisotopic_mass": "1064.5913",
                                "monoisotopic_mz": "355.8710",
                                "intensity": "15688.62",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1064.5978",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "-0.0066",
                                        "ppm": "-6.17"
                                    }
                                }
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "33",
                                "monoisotopic_mass": "1036.5950",
                                "monoisotopic_mz": "346.5389",
                                "intensity": "13213.88",
                                "charge": "3"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "34",
                                "monoisotopic_mass": "567.3678",
                                "monoisotopic_mz": "284.6912",
                                "intensity": "15008.83",
                                "charge": "2"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "35",
                                "monoisotopic_mass": "3618.0844",
                                "monoisotopic_mz": "604.0213",
                                "intensity": "22016.69",
                                "charge": "6"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "36",
                                "monoisotopic_mass": "7512.0449",
                                "monoisotopic_mz": "578.8569",
                                "intensity": "7737.52",
                                "charge": "13"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "37",
                                "monoisotopic_mass": "1982.1225",
                                "monoisotopic_mz": "661.7148",
                                "intensity": "10775.99",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1982.1398",
                                        "ion_position": "54",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "Y00016",
                                        "ion_left_position": "54",
                                        "mass_error": "-0.0173",
                                        "ppm": "-8.75"
                                    }
                                }
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "38",
                                "monoisotopic_mass": "4297.3584",
                                "monoisotopic_mz": "717.2337",
                                "intensity": "15715.83",
                                "charge": "6"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "39",
                                "monoisotopic_mass": "3747.1763",
                                "monoisotopic_mz": "625.5367",
                                "intensity": "7554.43",
                                "charge": "6"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "40",
                                "monoisotopic_mass": "5303.6882",
                                "monoisotopic_mz": "663.9683",
                                "intensity": "5855.65",
                                "charge": "8"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "41",
                                "monoisotopic_mass": "3951.4282",
                                "monoisotopic_mz": "659.5786",
                                "intensity": "6428.16",
                                "charge": "6"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "42",
                                "monoisotopic_mass": "865.4893",
                                "monoisotopic_mz": "433.7519",
                                "intensity": "5217.94",
                                "charge": "2"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "43",
                                "monoisotopic_mass": "2773.3258",
                                "monoisotopic_mz": "199.1020",
                                "intensity": "10976.88",
                                "charge": "14"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "44",
                                "monoisotopic_mass": "1876.1281",
                                "monoisotopic_mz": "1877.1353",
                                "intensity": "29626.63",
                                "charge": "1"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "45",
                                "monoisotopic_mass": "4357.3968",
                                "monoisotopic_mz": "623.4925",
                                "intensity": "47409.64",
                                "charge": "7"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "46",
                                "monoisotopic_mass": "2900.5888",
                                "monoisotopic_mz": "581.1250",
                                "intensity": "23326.77",
                                "charge": "5"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "47",
                                "monoisotopic_mass": "7299.8496",
                                "monoisotopic_mz": "562.5342",
                                "intensity": "14145.66",
                                "charge": "13"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "48",
                                "monoisotopic_mass": "7259.9898",
                                "monoisotopic_mz": "661.0064",
                                "intensity": "46581.61",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7259.0569",
                                        "ion_position": "10",
                                        "ion_display_position": "60",
                                        "ion_sort_name": "Y00060",
                                        "ion_left_position": "10",
                                        "mass_error": "-0.0694",
                                        "ppm": "-9.56"
                                    }
                                }
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "49",
                                "monoisotopic_mass": "3662.0993",
                                "monoisotopic_mz": "611.3572",
                                "intensity": "35798.64",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3662.1306",
                                        "ion_position": "39",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "Y00031",
                                        "ion_left_position": "39",
                                        "mass_error": "-0.0313",
                                        "ppm": "-8.55"
                                    }
                                }
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "50",
                                "monoisotopic_mass": "622.6235",
                                "monoisotopic_mz": "623.6308",
                                "intensity": "6172.81",
                                "charge": "1"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "51",
                                "monoisotopic_mass": "1738.9641",
                                "monoisotopic_mz": "580.6620",
                                "intensity": "7722.45",
                                "charge": "3"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "52",
                                "monoisotopic_mass": "699.3731",
                                "monoisotopic_mz": "700.3804",
                                "intensity": "6862.93",
                                "charge": "1"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "53",
                                "monoisotopic_mass": "2574.9883",
                                "monoisotopic_mz": "199.0833",
                                "intensity": "8400.62",
                                "charge": "13"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "54",
                                "monoisotopic_mass": "4967.8122",
                                "monoisotopic_mz": "621.9838",
                                "intensity": "5693.47",
                                "charge": "8"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "55",
                                "monoisotopic_mass": "3644.0806",
                                "monoisotopic_mz": "608.3540",
                                "intensity": "19497.96",
                                "charge": "6"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "56",
                                "monoisotopic_mass": "4296.3665",
                                "monoisotopic_mz": "614.7739",
                                "intensity": "32833.23",
                                "charge": "7"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "57",
                                "monoisotopic_mass": "3791.1897",
                                "monoisotopic_mz": "632.8722",
                                "intensity": "9453.17",
                                "charge": "6"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "58",
                                "monoisotopic_mass": "1982.1293",
                                "monoisotopic_mz": "496.5396",
                                "intensity": "8694.99",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1982.1398",
                                        "ion_position": "54",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "Y00016",
                                        "ion_left_position": "54",
                                        "mass_error": "-0.0105",
                                        "ppm": "-5.29"
                                    }
                                }
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "59",
                                "monoisotopic_mass": "3490.4478",
                                "monoisotopic_mz": "582.7486",
                                "intensity": "23323.51",
                                "charge": "6"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "60",
                                "monoisotopic_mass": "2327.2965",
                                "monoisotopic_mz": "582.8314",
                                "intensity": "10049.78",
                                "charge": "4"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "61",
                                "monoisotopic_mass": "2998.6513",
                                "monoisotopic_mz": "600.7375",
                                "intensity": "14204.19",
                                "charge": "5"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "62",
                                "monoisotopic_mass": "5238.9246",
                                "monoisotopic_mz": "583.1100",
                                "intensity": "17038.48",
                                "charge": "9"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "63",
                                "monoisotopic_mass": "6056.0022",
                                "monoisotopic_mz": "606.6075",
                                "intensity": "7306.22",
                                "charge": "10"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "64",
                                "monoisotopic_mass": "1291.3928",
                                "monoisotopic_mz": "646.7037",
                                "intensity": "4145.60",
                                "charge": "2"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "65",
                                "monoisotopic_mass": "4063.2452",
                                "monoisotopic_mz": "581.4709",
                                "intensity": "14837.74",
                                "charge": "7"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "66",
                                "monoisotopic_mass": "2581.1073",
                                "monoisotopic_mz": "646.2841",
                                "intensity": "7667.18",
                                "charge": "4"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "67",
                                "monoisotopic_mass": "1306.4225",
                                "monoisotopic_mz": "654.2185",
                                "intensity": "4580.26",
                                "charge": "2"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "68",
                                "monoisotopic_mass": "1277.7024",
                                "monoisotopic_mz": "639.8585",
                                "intensity": "4541.03",
                                "charge": "2"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "69",
                                "monoisotopic_mass": "4858.5585",
                                "monoisotopic_mz": "608.3271",
                                "intensity": "15145.43",
                                "charge": "8"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "70",
                                "monoisotopic_mass": "4271.1785",
                                "monoisotopic_mz": "611.1756",
                                "intensity": "11056.04",
                                "charge": "7"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "71",
                                "monoisotopic_mass": "3596.9888",
                                "monoisotopic_mz": "600.5054",
                                "intensity": "12148.10",
                                "charge": "6"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "72",
                                "monoisotopic_mass": "3037.9861",
                                "monoisotopic_mz": "608.6045",
                                "intensity": "13372.81",
                                "charge": "5"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "73",
                                "monoisotopic_mass": "1830.2513",
                                "monoisotopic_mz": "611.0911",
                                "intensity": "10822.39",
                                "charge": "3"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "74",
                                "monoisotopic_mass": "3723.3337",
                                "monoisotopic_mz": "621.5629",
                                "intensity": "5765.02",
                                "charge": "6"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "75",
                                "monoisotopic_mass": "5993.7616",
                                "monoisotopic_mz": "600.3834",
                                "intensity": "14786.47",
                                "charge": "10"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "76",
                                "monoisotopic_mass": "2806.5509",
                                "monoisotopic_mz": "562.3175",
                                "intensity": "13151.87",
                                "charge": "5"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "77",
                                "monoisotopic_mass": "3696.0188",
                                "monoisotopic_mz": "617.0104",
                                "intensity": "7857.88",
                                "charge": "6"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "78",
                                "monoisotopic_mass": "1210.3339",
                                "monoisotopic_mz": "606.1742",
                                "intensity": "10298.10",
                                "charge": "2"
                            },
                            {
                                "spec_id": "368",
                                "peak_id": "79",
                                "monoisotopic_mass": "4907.7351",
                                "monoisotopic_mz": "614.4742",
                                "intensity": "26341.70",
                                "charge": "8"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "5",
                    "proteoform_id": "5",
                    "sequence_name": "sp|P68684|RS21_SALTY",
                    "sequence_description": "30S ribosomal protein S21 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpsU PE=3 SV=2",
                    "proteoform_mass": "8420.7075",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "71",
                        "first_residue_position": "1",
                        "last_residue_position": "70",
                        "annotated_seq": "M.PVIKVRENEPFDVALRRFKRS(C)[Carbamidomethylation]EKAGVLAEVRRREFYEKPTTERKRAKASAVKRHAKKLARENARRTRLY.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "P"
                            },
                            {
                                "position": "2",
                                "acid": "V"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "V"
                            },
                            {
                                "position": "6",
                                "acid": "R"
                            },
                            {
                                "position": "7",
                                "acid": "E"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "E"
                            },
                            {
                                "position": "10",
                                "acid": "P"
                            },
                            {
                                "position": "11",
                                "acid": "F"
                            },
                            {
                                "position": "12",
                                "acid": "D"
                            },
                            {
                                "position": "13",
                                "acid": "V"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "R"
                            },
                            {
                                "position": "17",
                                "acid": "R"
                            },
                            {
                                "position": "18",
                                "acid": "F"
                            },
                            {
                                "position": "19",
                                "acid": "K"
                            },
                            {
                                "position": "20",
                                "acid": "R"
                            },
                            {
                                "position": "21",
                                "acid": "S"
                            },
                            {
                                "position": "22",
                                "acid": "C"
                            },
                            {
                                "position": "23",
                                "acid": "E"
                            },
                            {
                                "position": "24",
                                "acid": "K"
                            },
                            {
                                "position": "25",
                                "acid": "A"
                            },
                            {
                                "position": "26",
                                "acid": "G"
                            },
                            {
                                "position": "27",
                                "acid": "V"
                            },
                            {
                                "position": "28",
                                "acid": "L"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "R"
                            },
                            {
                                "position": "33",
                                "acid": "R"
                            },
                            {
                                "position": "34",
                                "acid": "R"
                            },
                            {
                                "position": "35",
                                "acid": "E"
                            },
                            {
                                "position": "36",
                                "acid": "F"
                            },
                            {
                                "position": "37",
                                "acid": "Y"
                            },
                            {
                                "position": "38",
                                "acid": "E"
                            },
                            {
                                "position": "39",
                                "acid": "K"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "T"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "E"
                            },
                            {
                                "position": "44",
                                "acid": "R"
                            },
                            {
                                "position": "45",
                                "acid": "K"
                            },
                            {
                                "position": "46",
                                "acid": "R"
                            },
                            {
                                "position": "47",
                                "acid": "A"
                            },
                            {
                                "position": "48",
                                "acid": "K"
                            },
                            {
                                "position": "49",
                                "acid": "A"
                            },
                            {
                                "position": "50",
                                "acid": "S"
                            },
                            {
                                "position": "51",
                                "acid": "A"
                            },
                            {
                                "position": "52",
                                "acid": "V"
                            },
                            {
                                "position": "53",
                                "acid": "K"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "H"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "K"
                            },
                            {
                                "position": "58",
                                "acid": "K"
                            },
                            {
                                "position": "59",
                                "acid": "L"
                            },
                            {
                                "position": "60",
                                "acid": "A"
                            },
                            {
                                "position": "61",
                                "acid": "R"
                            },
                            {
                                "position": "62",
                                "acid": "E"
                            },
                            {
                                "position": "63",
                                "acid": "N"
                            },
                            {
                                "position": "64",
                                "acid": "A"
                            },
                            {
                                "position": "65",
                                "acid": "R"
                            },
                            {
                                "position": "66",
                                "acid": "R"
                            },
                            {
                                "position": "67",
                                "acid": "T"
                            },
                            {
                                "position": "68",
                                "acid": "R"
                            },
                            {
                                "position": "69",
                                "acid": "L"
                            },
                            {
                                "position": "70",
                                "acid": "Y"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "1",
                                        "ion_display_position": "69",
                                        "spec_id": "368",
                                        "peak_id": "13",
                                        "peak_charge": "14"
                                    }
                                }
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "2",
                                        "ion_display_position": "68",
                                        "spec_id": "368",
                                        "peak_id": "2",
                                        "peak_charge": "14"
                                    }
                                }
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "9",
                                            "ion_display_position": "9",
                                            "spec_id": "368",
                                            "peak_id": "32",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "9",
                                            "ion_display_position": "61",
                                            "spec_id": "368",
                                            "peak_id": "5",
                                            "peak_charge": "12"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "10",
                                            "ion_display_position": "10",
                                            "spec_id": "368",
                                            "peak_id": "29",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "10",
                                            "ion_display_position": "60",
                                            "spec_id": "368",
                                            "peak_id": "48",
                                            "peak_charge": "11"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "10",
                                            "ion_display_position": "60",
                                            "spec_id": "368",
                                            "peak_id": "1",
                                            "peak_charge": "12"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "11",
                                        "ion_display_position": "59",
                                        "spec_id": "368",
                                        "peak_id": "0",
                                        "peak_charge": "12"
                                    }
                                }
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "368",
                                            "peak_id": "28",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "368",
                                            "peak_id": "16",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "12",
                                            "ion_display_position": "58",
                                            "spec_id": "368",
                                            "peak_id": "3",
                                            "peak_charge": "12"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "12",
                                            "ion_display_position": "58",
                                            "spec_id": "368",
                                            "peak_id": "9",
                                            "peak_charge": "11"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "30",
                                        "ion_display_position": "40",
                                        "spec_id": "368",
                                        "peak_id": "6",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "34",
                                            "ion_display_position": "34",
                                            "spec_id": "368",
                                            "peak_id": "8",
                                            "peak_charge": "8"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "34",
                                            "ion_display_position": "36",
                                            "spec_id": "368",
                                            "peak_id": "12",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "39",
                                        "ion_display_position": "31",
                                        "spec_id": "368",
                                        "peak_id": "49",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "54",
                                            "ion_display_position": "16",
                                            "spec_id": "368",
                                            "peak_id": "37",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "54",
                                            "ion_display_position": "16",
                                            "spec_id": "368",
                                            "peak_id": "58",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": {
                                "left_pos": "22",
                                "right_pos": "23",
                                "anno": "C"
                            }
                        }
                    }
                }
            },
            {
                "prsm_id": "22",
                "p_value": "2.47e-07",
                "e_value": "2.47e-09",
                "fdr": "0",
                "matched_fragment_number": "7",
                "matched_peak_number": "10",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_2/st_1_ms2.msalign",
                        "ms1_ids": "361",
                        "ms1_scans": "707",
                        "ids": "345",
                        "scans": "708",
                        "precursor_mono_mass": "8420.6381",
                        "precursor_charge": "16",
                        "precursor_mz": "527.2972",
                        "feature_inte": "1.2933e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "345",
                                "peak_id": "0",
                                "monoisotopic_mass": "6996.9001",
                                "monoisotopic_mz": "539.2304",
                                "intensity": "91633.12",
                                "charge": "13",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6996.9615",
                                        "ion_position": "12",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0614",
                                        "ppm": "-8.78"
                                    }
                                }
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "1",
                                "monoisotopic_mass": "7259.9891",
                                "monoisotopic_mz": "559.4680",
                                "intensity": "32942.41",
                                "charge": "13",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7259.0569",
                                        "ion_position": "10",
                                        "ion_display_position": "60",
                                        "ion_sort_name": "Y00060",
                                        "ion_left_position": "10",
                                        "mass_error": "-0.0701",
                                        "ppm": "-9.65"
                                    }
                                }
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "2",
                                "monoisotopic_mass": "4925.7703",
                                "monoisotopic_mz": "493.5843",
                                "intensity": "80839.66",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4925.8142",
                                        "ion_position": "30",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0439",
                                        "ppm": "-8.91"
                                    }
                                }
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "3",
                                "monoisotopic_mass": "7356.0387",
                                "monoisotopic_mz": "566.8564",
                                "intensity": "176959.02",
                                "charge": "13",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7356.1096",
                                        "ion_position": "9",
                                        "ion_display_position": "61",
                                        "ion_sort_name": "Y00061",
                                        "ion_left_position": "9",
                                        "mass_error": "-0.0709",
                                        "ppm": "-9.64"
                                    }
                                }
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "4",
                                "monoisotopic_mass": "7258.9883",
                                "monoisotopic_mz": "605.9230",
                                "intensity": "16807.73",
                                "charge": "12",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7259.0569",
                                        "ion_position": "10",
                                        "ion_display_position": "60",
                                        "ion_sort_name": "Y00060",
                                        "ion_left_position": "10",
                                        "mass_error": "-0.0686",
                                        "ppm": "-9.45"
                                    }
                                }
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "5",
                                "monoisotopic_mass": "7338.0120",
                                "monoisotopic_mz": "565.4697",
                                "intensity": "39146.23",
                                "charge": "13"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "6",
                                "monoisotopic_mass": "7565.0323",
                                "monoisotopic_mz": "582.9328",
                                "intensity": "5073.39",
                                "charge": "13"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "7",
                                "monoisotopic_mass": "6414.3530",
                                "monoisotopic_mz": "584.1303",
                                "intensity": "8880.80",
                                "charge": "11"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "8",
                                "monoisotopic_mass": "4925.7669",
                                "monoisotopic_mz": "548.3147",
                                "intensity": "64991.44",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4925.8142",
                                        "ion_position": "30",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0473",
                                        "ppm": "-9.60"
                                    }
                                }
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "9",
                                "monoisotopic_mass": "4340.3882",
                                "monoisotopic_mz": "621.0627",
                                "intensity": "47519.28",
                                "charge": "7"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "10",
                                "monoisotopic_mass": "4908.7480",
                                "monoisotopic_mz": "546.4237",
                                "intensity": "11880.57",
                                "charge": "9"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "11",
                                "monoisotopic_mass": "1423.7334",
                                "monoisotopic_mz": "712.8740",
                                "intensity": "10438.28",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1423.7460",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0126",
                                        "ppm": "-8.85"
                                    }
                                }
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "12",
                                "monoisotopic_mass": "4340.3883",
                                "monoisotopic_mz": "543.5558",
                                "intensity": "38621.12",
                                "charge": "8"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "13",
                                "monoisotopic_mass": "1064.5898",
                                "monoisotopic_mz": "355.8705",
                                "intensity": "11034.63",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1064.5978",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "-0.0080",
                                        "ppm": "-7.56"
                                    }
                                }
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "14",
                                "monoisotopic_mass": "1423.7326",
                                "monoisotopic_mz": "475.5848",
                                "intensity": "18187.20",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1423.7460",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0134",
                                        "ppm": "-9.39"
                                    }
                                }
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "15",
                                "monoisotopic_mass": "2638.4975",
                                "monoisotopic_mz": "440.7569",
                                "intensity": "20654.34",
                                "charge": "6"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "16",
                                "monoisotopic_mass": "1036.5932",
                                "monoisotopic_mz": "346.5383",
                                "intensity": "7009.69",
                                "charge": "3"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "17",
                                "monoisotopic_mass": "1221.0317",
                                "monoisotopic_mz": "611.5231",
                                "intensity": "4461.28",
                                "charge": "2"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "18",
                                "monoisotopic_mass": "3938.4607",
                                "monoisotopic_mz": "563.6445",
                                "intensity": "5127.85",
                                "charge": "7"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "19",
                                "monoisotopic_mass": "2179.5207",
                                "monoisotopic_mz": "199.1455",
                                "intensity": "5192.53",
                                "charge": "11"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "20",
                                "monoisotopic_mass": "1161.6414",
                                "monoisotopic_mz": "388.2211",
                                "intensity": "5401.72",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1161.6506",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "-0.0092",
                                        "ppm": "-7.94"
                                    }
                                }
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "21",
                                "monoisotopic_mass": "1064.5858",
                                "monoisotopic_mz": "533.3002",
                                "intensity": "3358.99",
                                "charge": "2"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "22",
                                "monoisotopic_mass": "2453.8654",
                                "monoisotopic_mz": "491.7803",
                                "intensity": "6224.03",
                                "charge": "5"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "23",
                                "monoisotopic_mass": "4057.8059",
                                "monoisotopic_mz": "580.6938",
                                "intensity": "4967.67",
                                "charge": "7"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "24",
                                "monoisotopic_mass": "4119.0908",
                                "monoisotopic_mz": "458.6840",
                                "intensity": "8655.84",
                                "charge": "9"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "25",
                                "monoisotopic_mass": "1464.8298",
                                "monoisotopic_mz": "489.2839",
                                "intensity": "2956.99",
                                "charge": "3"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "26",
                                "monoisotopic_mass": "3678.5190",
                                "monoisotopic_mz": "614.0938",
                                "intensity": "6009.51",
                                "charge": "6"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "27",
                                "monoisotopic_mass": "1747.9310",
                                "monoisotopic_mz": "583.6509",
                                "intensity": "8514.60",
                                "charge": "3"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "28",
                                "monoisotopic_mass": "1160.6439",
                                "monoisotopic_mz": "581.3292",
                                "intensity": "4098.98",
                                "charge": "2"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "29",
                                "monoisotopic_mass": "2911.8390",
                                "monoisotopic_mz": "583.3751",
                                "intensity": "4629.95",
                                "charge": "5"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "30",
                                "monoisotopic_mass": "3170.3641",
                                "monoisotopic_mz": "199.1550",
                                "intensity": "4874.70",
                                "charge": "16"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "31",
                                "monoisotopic_mass": "4882.7361",
                                "monoisotopic_mz": "543.5335",
                                "intensity": "9861.46",
                                "charge": "9"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "32",
                                "monoisotopic_mass": "537.2217",
                                "monoisotopic_mz": "538.2290",
                                "intensity": "4640.70",
                                "charge": "1"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "33",
                                "monoisotopic_mass": "4656.4926",
                                "monoisotopic_mz": "583.0688",
                                "intensity": "13364.48",
                                "charge": "8"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "34",
                                "monoisotopic_mass": "605.3378",
                                "monoisotopic_mz": "606.3451",
                                "intensity": "1856.95",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "5",
                    "proteoform_id": "5",
                    "sequence_name": "sp|P68684|RS21_SALTY",
                    "sequence_description": "30S ribosomal protein S21 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpsU PE=3 SV=2",
                    "proteoform_mass": "8420.7075",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "71",
                        "first_residue_position": "1",
                        "last_residue_position": "70",
                        "annotated_seq": "M.PVIKVRENEPFDVALRRFKRS(C)[Carbamidomethylation]EKAGVLAEVRRREFYEKPTTERKRAKASAVKRHAKKLARENARRTRLY.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "P"
                            },
                            {
                                "position": "2",
                                "acid": "V"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "V"
                            },
                            {
                                "position": "6",
                                "acid": "R"
                            },
                            {
                                "position": "7",
                                "acid": "E"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "E"
                            },
                            {
                                "position": "10",
                                "acid": "P"
                            },
                            {
                                "position": "11",
                                "acid": "F"
                            },
                            {
                                "position": "12",
                                "acid": "D"
                            },
                            {
                                "position": "13",
                                "acid": "V"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "R"
                            },
                            {
                                "position": "17",
                                "acid": "R"
                            },
                            {
                                "position": "18",
                                "acid": "F"
                            },
                            {
                                "position": "19",
                                "acid": "K"
                            },
                            {
                                "position": "20",
                                "acid": "R"
                            },
                            {
                                "position": "21",
                                "acid": "S"
                            },
                            {
                                "position": "22",
                                "acid": "C"
                            },
                            {
                                "position": "23",
                                "acid": "E"
                            },
                            {
                                "position": "24",
                                "acid": "K"
                            },
                            {
                                "position": "25",
                                "acid": "A"
                            },
                            {
                                "position": "26",
                                "acid": "G"
                            },
                            {
                                "position": "27",
                                "acid": "V"
                            },
                            {
                                "position": "28",
                                "acid": "L"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "R"
                            },
                            {
                                "position": "33",
                                "acid": "R"
                            },
                            {
                                "position": "34",
                                "acid": "R"
                            },
                            {
                                "position": "35",
                                "acid": "E"
                            },
                            {
                                "position": "36",
                                "acid": "F"
                            },
                            {
                                "position": "37",
                                "acid": "Y"
                            },
                            {
                                "position": "38",
                                "acid": "E"
                            },
                            {
                                "position": "39",
                                "acid": "K"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "T"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "E"
                            },
                            {
                                "position": "44",
                                "acid": "R"
                            },
                            {
                                "position": "45",
                                "acid": "K"
                            },
                            {
                                "position": "46",
                                "acid": "R"
                            },
                            {
                                "position": "47",
                                "acid": "A"
                            },
                            {
                                "position": "48",
                                "acid": "K"
                            },
                            {
                                "position": "49",
                                "acid": "A"
                            },
                            {
                                "position": "50",
                                "acid": "S"
                            },
                            {
                                "position": "51",
                                "acid": "A"
                            },
                            {
                                "position": "52",
                                "acid": "V"
                            },
                            {
                                "position": "53",
                                "acid": "K"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "H"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "K"
                            },
                            {
                                "position": "58",
                                "acid": "K"
                            },
                            {
                                "position": "59",
                                "acid": "L"
                            },
                            {
                                "position": "60",
                                "acid": "A"
                            },
                            {
                                "position": "61",
                                "acid": "R"
                            },
                            {
                                "position": "62",
                                "acid": "E"
                            },
                            {
                                "position": "63",
                                "acid": "N"
                            },
                            {
                                "position": "64",
                                "acid": "A"
                            },
                            {
                                "position": "65",
                                "acid": "R"
                            },
                            {
                                "position": "66",
                                "acid": "R"
                            },
                            {
                                "position": "67",
                                "acid": "T"
                            },
                            {
                                "position": "68",
                                "acid": "R"
                            },
                            {
                                "position": "69",
                                "acid": "L"
                            },
                            {
                                "position": "70",
                                "acid": "Y"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "9",
                                            "ion_display_position": "9",
                                            "spec_id": "345",
                                            "peak_id": "13",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "9",
                                            "ion_display_position": "61",
                                            "spec_id": "345",
                                            "peak_id": "3",
                                            "peak_charge": "13"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "10",
                                            "ion_display_position": "10",
                                            "spec_id": "345",
                                            "peak_id": "20",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "10",
                                            "ion_display_position": "60",
                                            "spec_id": "345",
                                            "peak_id": "1",
                                            "peak_charge": "13"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "10",
                                            "ion_display_position": "60",
                                            "spec_id": "345",
                                            "peak_id": "4",
                                            "peak_charge": "12"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "345",
                                            "peak_id": "14",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "345",
                                            "peak_id": "11",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "12",
                                            "ion_display_position": "58",
                                            "spec_id": "345",
                                            "peak_id": "0",
                                            "peak_charge": "13"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "30",
                                            "ion_display_position": "40",
                                            "spec_id": "345",
                                            "peak_id": "8",
                                            "peak_charge": "9"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "30",
                                            "ion_display_position": "40",
                                            "spec_id": "345",
                                            "peak_id": "2",
                                            "peak_charge": "10"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": {
                                "left_pos": "22",
                                "right_pos": "23",
                                "anno": "C"
                            }
                        }
                    }
                }
            },
            {
                "prsm_id": "24",
                "p_value": "2.79e-07",
                "e_value": "2.79e-09",
                "fdr": "0",
                "matched_fragment_number": "5",
                "matched_peak_number": "6",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_2/st_1_ms2.msalign",
                        "ms1_ids": "373",
                        "ms1_scans": "731",
                        "ids": "357",
                        "scans": "732",
                        "precursor_mono_mass": "8420.6578",
                        "precursor_charge": "14",
                        "precursor_mz": "602.4828",
                        "feature_inte": "1.7663e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "357",
                                "peak_id": "0",
                                "monoisotopic_mass": "8224.4977",
                                "monoisotopic_mz": "633.6609",
                                "intensity": "37260.20",
                                "charge": "13"
                            },
                            {
                                "spec_id": "357",
                                "peak_id": "1",
                                "monoisotopic_mass": "6996.8935",
                                "monoisotopic_mz": "637.0885",
                                "intensity": "25175.97",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6996.9615",
                                        "ion_position": "12",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0680",
                                        "ppm": "-9.71"
                                    }
                                }
                            },
                            {
                                "spec_id": "357",
                                "peak_id": "2",
                                "monoisotopic_mass": "4925.7675",
                                "monoisotopic_mz": "548.3148",
                                "intensity": "80648.12",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4925.8142",
                                        "ion_position": "30",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0467",
                                        "ppm": "-9.49"
                                    }
                                }
                            },
                            {
                                "spec_id": "357",
                                "peak_id": "3",
                                "monoisotopic_mass": "4925.7722",
                                "monoisotopic_mz": "616.7288",
                                "intensity": "31480.16",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4925.8142",
                                        "ion_position": "30",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0420",
                                        "ppm": "-8.52"
                                    }
                                }
                            },
                            {
                                "spec_id": "357",
                                "peak_id": "4",
                                "monoisotopic_mass": "1981.3311",
                                "monoisotopic_mz": "199.1404",
                                "intensity": "9706.49",
                                "charge": "10"
                            },
                            {
                                "spec_id": "357",
                                "peak_id": "5",
                                "monoisotopic_mass": "4340.3929",
                                "monoisotopic_mz": "621.0634",
                                "intensity": "64100.73",
                                "charge": "7"
                            },
                            {
                                "spec_id": "357",
                                "peak_id": "6",
                                "monoisotopic_mass": "2071.1279",
                                "monoisotopic_mz": "691.3832",
                                "intensity": "22716.16",
                                "charge": "3"
                            },
                            {
                                "spec_id": "357",
                                "peak_id": "7",
                                "monoisotopic_mass": "3494.8526",
                                "monoisotopic_mz": "699.9778",
                                "intensity": "33251.31",
                                "charge": "5"
                            },
                            {
                                "spec_id": "357",
                                "peak_id": "8",
                                "monoisotopic_mass": "4908.7561",
                                "monoisotopic_mz": "546.4246",
                                "intensity": "13298.43",
                                "charge": "9"
                            },
                            {
                                "spec_id": "357",
                                "peak_id": "9",
                                "monoisotopic_mass": "1609.7783",
                                "monoisotopic_mz": "805.8964",
                                "intensity": "15024.21",
                                "charge": "2"
                            },
                            {
                                "spec_id": "357",
                                "peak_id": "10",
                                "monoisotopic_mass": "2638.4932",
                                "monoisotopic_mz": "528.7059",
                                "intensity": "45630.45",
                                "charge": "5"
                            },
                            {
                                "spec_id": "357",
                                "peak_id": "11",
                                "monoisotopic_mass": "1423.7325",
                                "monoisotopic_mz": "712.8735",
                                "intensity": "63927.56",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1423.7460",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0134",
                                        "ppm": "-9.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "357",
                                "peak_id": "12",
                                "monoisotopic_mass": "4358.3983",
                                "monoisotopic_mz": "623.6356",
                                "intensity": "23236.93",
                                "charge": "7"
                            },
                            {
                                "spec_id": "357",
                                "peak_id": "13",
                                "monoisotopic_mass": "2596.4797",
                                "monoisotopic_mz": "520.3032",
                                "intensity": "6842.71",
                                "charge": "5"
                            },
                            {
                                "spec_id": "357",
                                "peak_id": "14",
                                "monoisotopic_mass": "7362.7021",
                                "monoisotopic_mz": "614.5658",
                                "intensity": "13792.34",
                                "charge": "12"
                            },
                            {
                                "spec_id": "357",
                                "peak_id": "15",
                                "monoisotopic_mass": "4340.4009",
                                "monoisotopic_mz": "724.4074",
                                "intensity": "21177.98",
                                "charge": "6"
                            },
                            {
                                "spec_id": "357",
                                "peak_id": "16",
                                "monoisotopic_mass": "3866.1128",
                                "monoisotopic_mz": "645.3594",
                                "intensity": "21054.94",
                                "charge": "6"
                            },
                            {
                                "spec_id": "357",
                                "peak_id": "17",
                                "monoisotopic_mass": "6977.8752",
                                "monoisotopic_mz": "635.3596",
                                "intensity": "15124.60",
                                "charge": "11"
                            },
                            {
                                "spec_id": "357",
                                "peak_id": "18",
                                "monoisotopic_mass": "7983.3359",
                                "monoisotopic_mz": "666.2853",
                                "intensity": "14061.63",
                                "charge": "12",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7983.4073",
                                        "ion_position": "4",
                                        "ion_display_position": "66",
                                        "ion_sort_name": "Y00066",
                                        "ion_left_position": "4",
                                        "mass_error": "-0.0713",
                                        "ppm": "-8.93"
                                    }
                                }
                            },
                            {
                                "spec_id": "357",
                                "peak_id": "19",
                                "monoisotopic_mass": "4358.4042",
                                "monoisotopic_mz": "727.4080",
                                "intensity": "21507.67",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4358.4425",
                                        "ion_position": "34",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "Y00036",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0382",
                                        "ppm": "-8.77"
                                    }
                                }
                            },
                            {
                                "spec_id": "357",
                                "peak_id": "20",
                                "monoisotopic_mass": "4297.3684",
                                "monoisotopic_mz": "614.9170",
                                "intensity": "15252.82",
                                "charge": "7"
                            },
                            {
                                "spec_id": "357",
                                "peak_id": "21",
                                "monoisotopic_mass": "1351.7501",
                                "monoisotopic_mz": "676.8823",
                                "intensity": "3877.68",
                                "charge": "2"
                            },
                            {
                                "spec_id": "357",
                                "peak_id": "22",
                                "monoisotopic_mass": "1337.4060",
                                "monoisotopic_mz": "669.7103",
                                "intensity": "4067.12",
                                "charge": "2"
                            },
                            {
                                "spec_id": "357",
                                "peak_id": "23",
                                "monoisotopic_mass": "1319.7515",
                                "monoisotopic_mz": "440.9244",
                                "intensity": "5598.35",
                                "charge": "3"
                            },
                            {
                                "spec_id": "357",
                                "peak_id": "24",
                                "monoisotopic_mass": "6346.7797",
                                "monoisotopic_mz": "635.6852",
                                "intensity": "6611.54",
                                "charge": "10"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "5",
                    "proteoform_id": "5",
                    "sequence_name": "sp|P68684|RS21_SALTY",
                    "sequence_description": "30S ribosomal protein S21 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpsU PE=3 SV=2",
                    "proteoform_mass": "8420.7075",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "71",
                        "first_residue_position": "1",
                        "last_residue_position": "70",
                        "annotated_seq": "M.PVIKVRENEPFDVALRRFKRS(C)[Carbamidomethylation]EKAGVLAEVRRREFYEKPTTERKRAKASAVKRHAKKLARENARRTRLY.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "P"
                            },
                            {
                                "position": "2",
                                "acid": "V"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "V"
                            },
                            {
                                "position": "6",
                                "acid": "R"
                            },
                            {
                                "position": "7",
                                "acid": "E"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "E"
                            },
                            {
                                "position": "10",
                                "acid": "P"
                            },
                            {
                                "position": "11",
                                "acid": "F"
                            },
                            {
                                "position": "12",
                                "acid": "D"
                            },
                            {
                                "position": "13",
                                "acid": "V"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "R"
                            },
                            {
                                "position": "17",
                                "acid": "R"
                            },
                            {
                                "position": "18",
                                "acid": "F"
                            },
                            {
                                "position": "19",
                                "acid": "K"
                            },
                            {
                                "position": "20",
                                "acid": "R"
                            },
                            {
                                "position": "21",
                                "acid": "S"
                            },
                            {
                                "position": "22",
                                "acid": "C"
                            },
                            {
                                "position": "23",
                                "acid": "E"
                            },
                            {
                                "position": "24",
                                "acid": "K"
                            },
                            {
                                "position": "25",
                                "acid": "A"
                            },
                            {
                                "position": "26",
                                "acid": "G"
                            },
                            {
                                "position": "27",
                                "acid": "V"
                            },
                            {
                                "position": "28",
                                "acid": "L"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "R"
                            },
                            {
                                "position": "33",
                                "acid": "R"
                            },
                            {
                                "position": "34",
                                "acid": "R"
                            },
                            {
                                "position": "35",
                                "acid": "E"
                            },
                            {
                                "position": "36",
                                "acid": "F"
                            },
                            {
                                "position": "37",
                                "acid": "Y"
                            },
                            {
                                "position": "38",
                                "acid": "E"
                            },
                            {
                                "position": "39",
                                "acid": "K"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "T"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "E"
                            },
                            {
                                "position": "44",
                                "acid": "R"
                            },
                            {
                                "position": "45",
                                "acid": "K"
                            },
                            {
                                "position": "46",
                                "acid": "R"
                            },
                            {
                                "position": "47",
                                "acid": "A"
                            },
                            {
                                "position": "48",
                                "acid": "K"
                            },
                            {
                                "position": "49",
                                "acid": "A"
                            },
                            {
                                "position": "50",
                                "acid": "S"
                            },
                            {
                                "position": "51",
                                "acid": "A"
                            },
                            {
                                "position": "52",
                                "acid": "V"
                            },
                            {
                                "position": "53",
                                "acid": "K"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "H"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "K"
                            },
                            {
                                "position": "58",
                                "acid": "K"
                            },
                            {
                                "position": "59",
                                "acid": "L"
                            },
                            {
                                "position": "60",
                                "acid": "A"
                            },
                            {
                                "position": "61",
                                "acid": "R"
                            },
                            {
                                "position": "62",
                                "acid": "E"
                            },
                            {
                                "position": "63",
                                "acid": "N"
                            },
                            {
                                "position": "64",
                                "acid": "A"
                            },
                            {
                                "position": "65",
                                "acid": "R"
                            },
                            {
                                "position": "66",
                                "acid": "R"
                            },
                            {
                                "position": "67",
                                "acid": "T"
                            },
                            {
                                "position": "68",
                                "acid": "R"
                            },
                            {
                                "position": "69",
                                "acid": "L"
                            },
                            {
                                "position": "70",
                                "acid": "Y"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "4",
                                        "ion_display_position": "66",
                                        "spec_id": "357",
                                        "peak_id": "18",
                                        "peak_charge": "12"
                                    }
                                }
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "357",
                                            "peak_id": "11",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "12",
                                            "ion_display_position": "58",
                                            "spec_id": "357",
                                            "peak_id": "1",
                                            "peak_charge": "11"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "30",
                                            "ion_display_position": "40",
                                            "spec_id": "357",
                                            "peak_id": "2",
                                            "peak_charge": "9"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "30",
                                            "ion_display_position": "40",
                                            "spec_id": "357",
                                            "peak_id": "3",
                                            "peak_charge": "8"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "34",
                                        "ion_display_position": "36",
                                        "spec_id": "357",
                                        "peak_id": "19",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": {
                                "left_pos": "22",
                                "right_pos": "23",
                                "anno": "C"
                            }
                        }
                    }
                }
            },
            {
                "prsm_id": "29",
                "p_value": "3.10e-07",
                "e_value": "3.10e-09",
                "fdr": "0",
                "matched_fragment_number": "8",
                "matched_peak_number": "10",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_2/st_1_ms2.msalign",
                        "ms1_ids": "388",
                        "ms1_scans": "761",
                        "ids": "372",
                        "scans": "762",
                        "precursor_mono_mass": "8420.6725",
                        "precursor_charge": "14",
                        "precursor_mz": "602.4839",
                        "feature_inte": "1.1444e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "372",
                                "peak_id": "0",
                                "monoisotopic_mass": "4925.7713",
                                "monoisotopic_mz": "548.3152",
                                "intensity": "63721.20",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4925.8142",
                                        "ion_position": "30",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0429",
                                        "ppm": "-8.71"
                                    }
                                }
                            },
                            {
                                "spec_id": "372",
                                "peak_id": "1",
                                "monoisotopic_mass": "6996.8888",
                                "monoisotopic_mz": "637.0881",
                                "intensity": "25319.41",
                                "charge": "11"
                            },
                            {
                                "spec_id": "372",
                                "peak_id": "2",
                                "monoisotopic_mass": "4925.7727",
                                "monoisotopic_mz": "616.7289",
                                "intensity": "28926.53",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4925.8142",
                                        "ion_position": "30",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0415",
                                        "ppm": "-8.42"
                                    }
                                }
                            },
                            {
                                "spec_id": "372",
                                "peak_id": "3",
                                "monoisotopic_mass": "7612.5135",
                                "monoisotopic_mz": "635.3834",
                                "intensity": "8740.14",
                                "charge": "12"
                            },
                            {
                                "spec_id": "372",
                                "peak_id": "4",
                                "monoisotopic_mass": "8224.5165",
                                "monoisotopic_mz": "633.6624",
                                "intensity": "30880.91",
                                "charge": "13",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8224.5863",
                                        "ion_position": "2",
                                        "ion_display_position": "68",
                                        "ion_sort_name": "Y00068",
                                        "ion_left_position": "2",
                                        "mass_error": "-0.0698",
                                        "ppm": "-8.49"
                                    }
                                }
                            },
                            {
                                "spec_id": "372",
                                "peak_id": "5",
                                "monoisotopic_mass": "4908.7352",
                                "monoisotopic_mz": "546.4223",
                                "intensity": "11289.98",
                                "charge": "9"
                            },
                            {
                                "spec_id": "372",
                                "peak_id": "6",
                                "monoisotopic_mass": "3494.8609",
                                "monoisotopic_mz": "699.9795",
                                "intensity": "30608.64",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3494.8933",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0324",
                                        "ppm": "-9.26"
                                    }
                                }
                            },
                            {
                                "spec_id": "372",
                                "peak_id": "7",
                                "monoisotopic_mass": "4340.3929",
                                "monoisotopic_mz": "621.0634",
                                "intensity": "54506.62",
                                "charge": "7"
                            },
                            {
                                "spec_id": "372",
                                "peak_id": "8",
                                "monoisotopic_mass": "2071.1273",
                                "monoisotopic_mz": "691.3830",
                                "intensity": "24483.09",
                                "charge": "3"
                            },
                            {
                                "spec_id": "372",
                                "peak_id": "9",
                                "monoisotopic_mass": "4358.4013",
                                "monoisotopic_mz": "623.6360",
                                "intensity": "21822.37",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4358.4425",
                                        "ion_position": "34",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "Y00036",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0412",
                                        "ppm": "-9.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "372",
                                "peak_id": "10",
                                "monoisotopic_mass": "1423.7336",
                                "monoisotopic_mz": "712.8741",
                                "intensity": "50361.11",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1423.7460",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0123",
                                        "ppm": "-8.67"
                                    }
                                }
                            },
                            {
                                "spec_id": "372",
                                "peak_id": "11",
                                "monoisotopic_mass": "2638.4963",
                                "monoisotopic_mz": "528.7065",
                                "intensity": "43480.89",
                                "charge": "5"
                            },
                            {
                                "spec_id": "372",
                                "peak_id": "12",
                                "monoisotopic_mass": "2596.4746",
                                "monoisotopic_mz": "520.3022",
                                "intensity": "10865.83",
                                "charge": "5"
                            },
                            {
                                "spec_id": "372",
                                "peak_id": "13",
                                "monoisotopic_mass": "4358.3995",
                                "monoisotopic_mz": "727.4072",
                                "intensity": "16832.82",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4358.4425",
                                        "ion_position": "34",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "Y00036",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0430",
                                        "ppm": "-9.86"
                                    }
                                }
                            },
                            {
                                "spec_id": "372",
                                "peak_id": "14",
                                "monoisotopic_mass": "4297.3679",
                                "monoisotopic_mz": "717.2353",
                                "intensity": "6948.95",
                                "charge": "6"
                            },
                            {
                                "spec_id": "372",
                                "peak_id": "15",
                                "monoisotopic_mass": "4340.3856",
                                "monoisotopic_mz": "724.4049",
                                "intensity": "19571.89",
                                "charge": "6"
                            },
                            {
                                "spec_id": "372",
                                "peak_id": "16",
                                "monoisotopic_mass": "7984.3394",
                                "monoisotopic_mz": "666.3689",
                                "intensity": "7810.26",
                                "charge": "12",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7983.4073",
                                        "ion_position": "4",
                                        "ion_display_position": "66",
                                        "ion_sort_name": "Y00066",
                                        "ion_left_position": "4",
                                        "mass_error": "-0.0702",
                                        "ppm": "-8.79"
                                    }
                                }
                            },
                            {
                                "spec_id": "372",
                                "peak_id": "17",
                                "monoisotopic_mass": "4881.7347",
                                "monoisotopic_mz": "611.2241",
                                "intensity": "6703.33",
                                "charge": "8"
                            },
                            {
                                "spec_id": "372",
                                "peak_id": "18",
                                "monoisotopic_mass": "3865.1035",
                                "monoisotopic_mz": "645.1912",
                                "intensity": "12350.30",
                                "charge": "6"
                            },
                            {
                                "spec_id": "372",
                                "peak_id": "19",
                                "monoisotopic_mass": "4881.7355",
                                "monoisotopic_mz": "543.4223",
                                "intensity": "13771.09",
                                "charge": "9"
                            },
                            {
                                "spec_id": "372",
                                "peak_id": "20",
                                "monoisotopic_mass": "3299.7506",
                                "monoisotopic_mz": "825.9449",
                                "intensity": "8094.13",
                                "charge": "4"
                            },
                            {
                                "spec_id": "372",
                                "peak_id": "21",
                                "monoisotopic_mass": "8111.4607",
                                "monoisotopic_mz": "676.9623",
                                "intensity": "12314.15",
                                "charge": "12",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8111.5022",
                                        "ion_position": "3",
                                        "ion_display_position": "67",
                                        "ion_sort_name": "Y00067",
                                        "ion_left_position": "3",
                                        "mass_error": "-0.0415",
                                        "ppm": "-5.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "372",
                                "peak_id": "22",
                                "monoisotopic_mass": "4315.3631",
                                "monoisotopic_mz": "720.2345",
                                "intensity": "3649.24",
                                "charge": "6"
                            },
                            {
                                "spec_id": "372",
                                "peak_id": "23",
                                "monoisotopic_mass": "4082.2991",
                                "monoisotopic_mz": "681.3905",
                                "intensity": "4422.78",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4082.3314",
                                        "ion_position": "36",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "Y00034",
                                        "ion_left_position": "36",
                                        "mass_error": "-0.0323",
                                        "ppm": "-7.91"
                                    }
                                }
                            },
                            {
                                "spec_id": "372",
                                "peak_id": "24",
                                "monoisotopic_mass": "1114.5391",
                                "monoisotopic_mz": "1115.5464",
                                "intensity": "3026.27",
                                "charge": "1"
                            },
                            {
                                "spec_id": "372",
                                "peak_id": "25",
                                "monoisotopic_mass": "1981.2141",
                                "monoisotopic_mz": "199.1287",
                                "intensity": "4470.41",
                                "charge": "10"
                            },
                            {
                                "spec_id": "372",
                                "peak_id": "26",
                                "monoisotopic_mass": "6323.3425",
                                "monoisotopic_mz": "633.3415",
                                "intensity": "10647.19",
                                "charge": "10"
                            },
                            {
                                "spec_id": "372",
                                "peak_id": "27",
                                "monoisotopic_mass": "4211.3121",
                                "monoisotopic_mz": "602.6233",
                                "intensity": "10554.76",
                                "charge": "7"
                            },
                            {
                                "spec_id": "372",
                                "peak_id": "28",
                                "monoisotopic_mass": "1784.0351",
                                "monoisotopic_mz": "199.2334",
                                "intensity": "5817.94",
                                "charge": "9"
                            },
                            {
                                "spec_id": "372",
                                "peak_id": "29",
                                "monoisotopic_mass": "4907.7356",
                                "monoisotopic_mz": "614.4742",
                                "intensity": "10473.33",
                                "charge": "8"
                            },
                            {
                                "spec_id": "372",
                                "peak_id": "30",
                                "monoisotopic_mass": "4296.3737",
                                "monoisotopic_mz": "614.7749",
                                "intensity": "8233.34",
                                "charge": "7"
                            },
                            {
                                "spec_id": "372",
                                "peak_id": "31",
                                "monoisotopic_mass": "4321.3667",
                                "monoisotopic_mz": "618.3454",
                                "intensity": "8776.72",
                                "charge": "7"
                            },
                            {
                                "spec_id": "372",
                                "peak_id": "32",
                                "monoisotopic_mass": "4412.8723",
                                "monoisotopic_mz": "631.4176",
                                "intensity": "5605.54",
                                "charge": "7"
                            },
                            {
                                "spec_id": "372",
                                "peak_id": "33",
                                "monoisotopic_mass": "6687.7797",
                                "monoisotopic_mz": "669.7853",
                                "intensity": "11648.62",
                                "charge": "10"
                            },
                            {
                                "spec_id": "372",
                                "peak_id": "34",
                                "monoisotopic_mass": "2575.1268",
                                "monoisotopic_mz": "199.0940",
                                "intensity": "3308.18",
                                "charge": "13"
                            },
                            {
                                "spec_id": "372",
                                "peak_id": "35",
                                "monoisotopic_mass": "593.4340",
                                "monoisotopic_mz": "198.8186",
                                "intensity": "3962.56",
                                "charge": "3"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "5",
                    "proteoform_id": "5",
                    "sequence_name": "sp|P68684|RS21_SALTY",
                    "sequence_description": "30S ribosomal protein S21 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpsU PE=3 SV=2",
                    "proteoform_mass": "8420.7075",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "71",
                        "first_residue_position": "1",
                        "last_residue_position": "70",
                        "annotated_seq": "M.PVIKVRENEPFDVALRRFKRS(C)[Carbamidomethylation]EKAGVLAEVRRREFYEKPTTERKRAKASAVKRHAKKLARENARRTRLY.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "P"
                            },
                            {
                                "position": "2",
                                "acid": "V"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "V"
                            },
                            {
                                "position": "6",
                                "acid": "R"
                            },
                            {
                                "position": "7",
                                "acid": "E"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "E"
                            },
                            {
                                "position": "10",
                                "acid": "P"
                            },
                            {
                                "position": "11",
                                "acid": "F"
                            },
                            {
                                "position": "12",
                                "acid": "D"
                            },
                            {
                                "position": "13",
                                "acid": "V"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "R"
                            },
                            {
                                "position": "17",
                                "acid": "R"
                            },
                            {
                                "position": "18",
                                "acid": "F"
                            },
                            {
                                "position": "19",
                                "acid": "K"
                            },
                            {
                                "position": "20",
                                "acid": "R"
                            },
                            {
                                "position": "21",
                                "acid": "S"
                            },
                            {
                                "position": "22",
                                "acid": "C"
                            },
                            {
                                "position": "23",
                                "acid": "E"
                            },
                            {
                                "position": "24",
                                "acid": "K"
                            },
                            {
                                "position": "25",
                                "acid": "A"
                            },
                            {
                                "position": "26",
                                "acid": "G"
                            },
                            {
                                "position": "27",
                                "acid": "V"
                            },
                            {
                                "position": "28",
                                "acid": "L"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "R"
                            },
                            {
                                "position": "33",
                                "acid": "R"
                            },
                            {
                                "position": "34",
                                "acid": "R"
                            },
                            {
                                "position": "35",
                                "acid": "E"
                            },
                            {
                                "position": "36",
                                "acid": "F"
                            },
                            {
                                "position": "37",
                                "acid": "Y"
                            },
                            {
                                "position": "38",
                                "acid": "E"
                            },
                            {
                                "position": "39",
                                "acid": "K"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "T"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "E"
                            },
                            {
                                "position": "44",
                                "acid": "R"
                            },
                            {
                                "position": "45",
                                "acid": "K"
                            },
                            {
                                "position": "46",
                                "acid": "R"
                            },
                            {
                                "position": "47",
                                "acid": "A"
                            },
                            {
                                "position": "48",
                                "acid": "K"
                            },
                            {
                                "position": "49",
                                "acid": "A"
                            },
                            {
                                "position": "50",
                                "acid": "S"
                            },
                            {
                                "position": "51",
                                "acid": "A"
                            },
                            {
                                "position": "52",
                                "acid": "V"
                            },
                            {
                                "position": "53",
                                "acid": "K"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "H"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "K"
                            },
                            {
                                "position": "58",
                                "acid": "K"
                            },
                            {
                                "position": "59",
                                "acid": "L"
                            },
                            {
                                "position": "60",
                                "acid": "A"
                            },
                            {
                                "position": "61",
                                "acid": "R"
                            },
                            {
                                "position": "62",
                                "acid": "E"
                            },
                            {
                                "position": "63",
                                "acid": "N"
                            },
                            {
                                "position": "64",
                                "acid": "A"
                            },
                            {
                                "position": "65",
                                "acid": "R"
                            },
                            {
                                "position": "66",
                                "acid": "R"
                            },
                            {
                                "position": "67",
                                "acid": "T"
                            },
                            {
                                "position": "68",
                                "acid": "R"
                            },
                            {
                                "position": "69",
                                "acid": "L"
                            },
                            {
                                "position": "70",
                                "acid": "Y"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "2",
                                        "ion_display_position": "68",
                                        "spec_id": "372",
                                        "peak_id": "4",
                                        "peak_charge": "13"
                                    }
                                }
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "3",
                                        "ion_display_position": "67",
                                        "spec_id": "372",
                                        "peak_id": "21",
                                        "peak_charge": "12"
                                    }
                                }
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "4",
                                        "ion_display_position": "66",
                                        "spec_id": "372",
                                        "peak_id": "16",
                                        "peak_charge": "12"
                                    }
                                }
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "spec_id": "372",
                                        "peak_id": "10",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "30",
                                            "ion_display_position": "30",
                                            "spec_id": "372",
                                            "peak_id": "6",
                                            "peak_charge": "5"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "30",
                                            "ion_display_position": "40",
                                            "spec_id": "372",
                                            "peak_id": "0",
                                            "peak_charge": "9"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "30",
                                            "ion_display_position": "40",
                                            "spec_id": "372",
                                            "peak_id": "2",
                                            "peak_charge": "8"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "34",
                                            "ion_display_position": "36",
                                            "spec_id": "372",
                                            "peak_id": "13",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "34",
                                            "ion_display_position": "36",
                                            "spec_id": "372",
                                            "peak_id": "9",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "36",
                                        "ion_display_position": "34",
                                        "spec_id": "372",
                                        "peak_id": "23",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": {
                                "left_pos": "22",
                                "right_pos": "23",
                                "anno": "C"
                            }
                        }
                    }
                }
            },
            {
                "prsm_id": "23",
                "p_value": "9.00e-07",
                "e_value": "9.00e-09",
                "fdr": "0",
                "matched_fragment_number": "13",
                "matched_peak_number": "17",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_2/st_1_ms2.msalign",
                        "ms1_ids": "369",
                        "ms1_scans": "723",
                        "ids": "353",
                        "scans": "724",
                        "precursor_mono_mass": "8420.6381",
                        "precursor_charge": "15",
                        "precursor_mz": "562.3832",
                        "feature_inte": "1.2933e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "353",
                                "peak_id": "0",
                                "monoisotopic_mass": "6996.9043",
                                "monoisotopic_mz": "584.0826",
                                "intensity": "120609.76",
                                "charge": "12",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6996.9615",
                                        "ion_position": "12",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0572",
                                        "ppm": "-8.17"
                                    }
                                }
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "1",
                                "monoisotopic_mass": "7111.9304",
                                "monoisotopic_mz": "593.6681",
                                "intensity": "36094.26",
                                "charge": "12",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7111.9884",
                                        "ion_position": "11",
                                        "ion_display_position": "59",
                                        "ion_sort_name": "Y00059",
                                        "ion_left_position": "11",
                                        "mass_error": "-0.0580",
                                        "ppm": "-8.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "2",
                                "monoisotopic_mass": "6996.8929",
                                "monoisotopic_mz": "637.0884",
                                "intensity": "22656.70",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6996.9615",
                                        "ion_position": "12",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0686",
                                        "ppm": "-9.81"
                                    }
                                }
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "3",
                                "monoisotopic_mass": "4925.7813",
                                "monoisotopic_mz": "493.5854",
                                "intensity": "14223.36",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4925.8142",
                                        "ion_position": "30",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0329",
                                        "ppm": "-6.68"
                                    }
                                }
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "4",
                                "monoisotopic_mass": "7258.9905",
                                "monoisotopic_mz": "605.9231",
                                "intensity": "38435.47",
                                "charge": "12",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7259.0569",
                                        "ion_position": "10",
                                        "ion_display_position": "60",
                                        "ion_sort_name": "Y00060",
                                        "ion_left_position": "10",
                                        "mass_error": "-0.0664",
                                        "ppm": "-9.15"
                                    }
                                }
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "5",
                                "monoisotopic_mass": "7356.0469",
                                "monoisotopic_mz": "614.0112",
                                "intensity": "194421.91",
                                "charge": "12",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7356.1096",
                                        "ion_position": "9",
                                        "ion_display_position": "61",
                                        "ion_sort_name": "Y00061",
                                        "ion_left_position": "9",
                                        "mass_error": "-0.0627",
                                        "ppm": "-8.53"
                                    }
                                }
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "6",
                                "monoisotopic_mass": "7313.0114",
                                "monoisotopic_mz": "610.4249",
                                "intensity": "34374.31",
                                "charge": "12"
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "7",
                                "monoisotopic_mass": "4062.2331",
                                "monoisotopic_mz": "508.7864",
                                "intensity": "35774.67",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4062.2650",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "B00034",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0319",
                                        "ppm": "-7.85"
                                    }
                                }
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "8",
                                "monoisotopic_mass": "4925.7721",
                                "monoisotopic_mz": "616.7288",
                                "intensity": "38395.98",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4925.8142",
                                        "ion_position": "30",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0421",
                                        "ppm": "-8.54"
                                    }
                                }
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "9",
                                "monoisotopic_mass": "4340.3920",
                                "monoisotopic_mz": "621.0633",
                                "intensity": "84478.15",
                                "charge": "7"
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "10",
                                "monoisotopic_mass": "7259.0049",
                                "monoisotopic_mz": "660.9168",
                                "intensity": "18597.34",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7259.0569",
                                        "ion_position": "10",
                                        "ion_display_position": "60",
                                        "ion_sort_name": "Y00060",
                                        "ion_left_position": "10",
                                        "mass_error": "-0.0520",
                                        "ppm": "-7.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "11",
                                "monoisotopic_mass": "2071.1295",
                                "monoisotopic_mz": "691.3838",
                                "intensity": "13032.61",
                                "charge": "3"
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "12",
                                "monoisotopic_mass": "7241.9483",
                                "monoisotopic_mz": "659.3662",
                                "intensity": "10849.02",
                                "charge": "11"
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "13",
                                "monoisotopic_mass": "1423.7346",
                                "monoisotopic_mz": "712.8746",
                                "intensity": "28374.38",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1423.7460",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0114",
                                        "ppm": "-7.99"
                                    }
                                }
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "14",
                                "monoisotopic_mass": "4323.3894",
                                "monoisotopic_mz": "618.6343",
                                "intensity": "11977.98",
                                "charge": "7"
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "15",
                                "monoisotopic_mass": "7338.0220",
                                "monoisotopic_mz": "612.5091",
                                "intensity": "37535.43",
                                "charge": "12"
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "16",
                                "monoisotopic_mass": "2638.4970",
                                "monoisotopic_mz": "440.7568",
                                "intensity": "18200.12",
                                "charge": "6"
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "17",
                                "monoisotopic_mass": "2997.6439",
                                "monoisotopic_mz": "500.6146",
                                "intensity": "19795.58",
                                "charge": "6"
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "18",
                                "monoisotopic_mass": "4358.4017",
                                "monoisotopic_mz": "727.4076",
                                "intensity": "21245.60",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4358.4425",
                                        "ion_position": "34",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "Y00036",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0408",
                                        "ppm": "-9.36"
                                    }
                                }
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "19",
                                "monoisotopic_mass": "868.4700",
                                "monoisotopic_mz": "869.4772",
                                "intensity": "6247.28",
                                "charge": "1"
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "20",
                                "monoisotopic_mass": "2638.4952",
                                "monoisotopic_mz": "528.7063",
                                "intensity": "14090.09",
                                "charge": "5"
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "21",
                                "monoisotopic_mass": "1423.7384",
                                "monoisotopic_mz": "475.5867",
                                "intensity": "8768.06",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1423.7460",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0076",
                                        "ppm": "-5.34"
                                    }
                                }
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "22",
                                "monoisotopic_mass": "7092.8651",
                                "monoisotopic_mz": "592.0794",
                                "intensity": "12869.28",
                                "charge": "12"
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "23",
                                "monoisotopic_mass": "1064.5897",
                                "monoisotopic_mz": "355.8705",
                                "intensity": "7400.12",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1064.5978",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "-0.0081",
                                        "ppm": "-7.64"
                                    }
                                }
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "24",
                                "monoisotopic_mass": "1036.5949",
                                "monoisotopic_mz": "346.5389",
                                "intensity": "6815.26",
                                "charge": "3"
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "25",
                                "monoisotopic_mass": "1213.1788",
                                "monoisotopic_mz": "607.5967",
                                "intensity": "3126.90",
                                "charge": "2"
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "26",
                                "monoisotopic_mass": "1982.1247",
                                "monoisotopic_mz": "661.7155",
                                "intensity": "5698.18",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1982.1398",
                                        "ion_position": "54",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "Y00016",
                                        "ion_left_position": "54",
                                        "mass_error": "-0.0151",
                                        "ppm": "-7.64"
                                    }
                                }
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "27",
                                "monoisotopic_mass": "1161.6418",
                                "monoisotopic_mz": "388.2212",
                                "intensity": "4297.20",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1161.6506",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "-0.0088",
                                        "ppm": "-7.55"
                                    }
                                }
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "28",
                                "monoisotopic_mass": "567.3678",
                                "monoisotopic_mz": "284.6912",
                                "intensity": "8556.06",
                                "charge": "2"
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "29",
                                "monoisotopic_mass": "4339.3858",
                                "monoisotopic_mz": "724.2382",
                                "intensity": "28454.89",
                                "charge": "6"
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "30",
                                "monoisotopic_mass": "6980.8848",
                                "monoisotopic_mz": "582.7477",
                                "intensity": "20716.58",
                                "charge": "12"
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "31",
                                "monoisotopic_mass": "7859.0322",
                                "monoisotopic_mz": "562.3667",
                                "intensity": "24348.13",
                                "charge": "14"
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "32",
                                "monoisotopic_mass": "8064.0359",
                                "monoisotopic_mz": "621.3177",
                                "intensity": "14886.10",
                                "charge": "13"
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "33",
                                "monoisotopic_mass": "6373.1299",
                                "monoisotopic_mz": "580.3827",
                                "intensity": "7817.62",
                                "charge": "11"
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "34",
                                "monoisotopic_mass": "2432.0012",
                                "monoisotopic_mz": "609.0076",
                                "intensity": "5236.49",
                                "charge": "4"
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "35",
                                "monoisotopic_mass": "2996.6385",
                                "monoisotopic_mz": "600.3350",
                                "intensity": "6521.55",
                                "charge": "5"
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "36",
                                "monoisotopic_mass": "1360.7641",
                                "monoisotopic_mz": "681.3893",
                                "intensity": "3951.22",
                                "charge": "2"
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "37",
                                "monoisotopic_mass": "4357.3930",
                                "monoisotopic_mz": "623.4920",
                                "intensity": "27203.06",
                                "charge": "7"
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "38",
                                "monoisotopic_mass": "4161.3221",
                                "monoisotopic_mz": "595.4819",
                                "intensity": "5553.34",
                                "charge": "7"
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "39",
                                "monoisotopic_mass": "8122.4686",
                                "monoisotopic_mz": "581.1836",
                                "intensity": "11497.69",
                                "charge": "14"
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "40",
                                "monoisotopic_mass": "3662.1018",
                                "monoisotopic_mz": "611.3576",
                                "intensity": "21123.51",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3662.1306",
                                        "ion_position": "39",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "Y00031",
                                        "ion_left_position": "39",
                                        "mass_error": "-0.0287",
                                        "ppm": "-7.85"
                                    }
                                }
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "41",
                                "monoisotopic_mass": "1441.4601",
                                "monoisotopic_mz": "721.7373",
                                "intensity": "7036.32",
                                "charge": "2"
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "42",
                                "monoisotopic_mass": "5929.2890",
                                "monoisotopic_mz": "593.9362",
                                "intensity": "9100.22",
                                "charge": "10"
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "43",
                                "monoisotopic_mass": "4112.2627",
                                "monoisotopic_mz": "588.4734",
                                "intensity": "11873.81",
                                "charge": "7"
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "44",
                                "monoisotopic_mass": "4296.3771",
                                "monoisotopic_mz": "614.7754",
                                "intensity": "18082.51",
                                "charge": "7"
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "45",
                                "monoisotopic_mass": "1981.1258",
                                "monoisotopic_mz": "496.2887",
                                "intensity": "5146.03",
                                "charge": "4"
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "46",
                                "monoisotopic_mass": "1264.0654",
                                "monoisotopic_mz": "633.0400",
                                "intensity": "5948.40",
                                "charge": "2"
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "47",
                                "monoisotopic_mass": "4295.3756",
                                "monoisotopic_mz": "716.9032",
                                "intensity": "9013.07",
                                "charge": "6"
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "48",
                                "monoisotopic_mass": "2246.3716",
                                "monoisotopic_mz": "562.6002",
                                "intensity": "9125.65",
                                "charge": "4"
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "49",
                                "monoisotopic_mass": "587.8226",
                                "monoisotopic_mz": "588.8299",
                                "intensity": "6538.77",
                                "charge": "1"
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "50",
                                "monoisotopic_mass": "5466.1222",
                                "monoisotopic_mz": "608.3542",
                                "intensity": "4307.51",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5466.1050",
                                        "ion_position": "24",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "24",
                                        "mass_error": "0.0172",
                                        "ppm": "3.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "51",
                                "monoisotopic_mass": "5521.7192",
                                "monoisotopic_mz": "614.5316",
                                "intensity": "19789.56",
                                "charge": "9"
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "52",
                                "monoisotopic_mass": "1160.6383",
                                "monoisotopic_mz": "581.3264",
                                "intensity": "6151.25",
                                "charge": "2"
                            },
                            {
                                "spec_id": "353",
                                "peak_id": "53",
                                "monoisotopic_mass": "613.1721",
                                "monoisotopic_mz": "614.1794",
                                "intensity": "11587.04",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "5",
                    "proteoform_id": "5",
                    "sequence_name": "sp|P68684|RS21_SALTY",
                    "sequence_description": "30S ribosomal protein S21 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpsU PE=3 SV=2",
                    "proteoform_mass": "8420.7075",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "71",
                        "first_residue_position": "1",
                        "last_residue_position": "70",
                        "annotated_seq": "M.PVIKVRENEPFDVALRRFKRS(C)[Carbamidomethylation]EKAGVLAEVRRREFYEKPTTERKRAKASAVKRHAKKLARENARRTRLY.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "P"
                            },
                            {
                                "position": "2",
                                "acid": "V"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "V"
                            },
                            {
                                "position": "6",
                                "acid": "R"
                            },
                            {
                                "position": "7",
                                "acid": "E"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "E"
                            },
                            {
                                "position": "10",
                                "acid": "P"
                            },
                            {
                                "position": "11",
                                "acid": "F"
                            },
                            {
                                "position": "12",
                                "acid": "D"
                            },
                            {
                                "position": "13",
                                "acid": "V"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "R"
                            },
                            {
                                "position": "17",
                                "acid": "R"
                            },
                            {
                                "position": "18",
                                "acid": "F"
                            },
                            {
                                "position": "19",
                                "acid": "K"
                            },
                            {
                                "position": "20",
                                "acid": "R"
                            },
                            {
                                "position": "21",
                                "acid": "S"
                            },
                            {
                                "position": "22",
                                "acid": "C"
                            },
                            {
                                "position": "23",
                                "acid": "E"
                            },
                            {
                                "position": "24",
                                "acid": "K"
                            },
                            {
                                "position": "25",
                                "acid": "A"
                            },
                            {
                                "position": "26",
                                "acid": "G"
                            },
                            {
                                "position": "27",
                                "acid": "V"
                            },
                            {
                                "position": "28",
                                "acid": "L"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "R"
                            },
                            {
                                "position": "33",
                                "acid": "R"
                            },
                            {
                                "position": "34",
                                "acid": "R"
                            },
                            {
                                "position": "35",
                                "acid": "E"
                            },
                            {
                                "position": "36",
                                "acid": "F"
                            },
                            {
                                "position": "37",
                                "acid": "Y"
                            },
                            {
                                "position": "38",
                                "acid": "E"
                            },
                            {
                                "position": "39",
                                "acid": "K"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "T"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "E"
                            },
                            {
                                "position": "44",
                                "acid": "R"
                            },
                            {
                                "position": "45",
                                "acid": "K"
                            },
                            {
                                "position": "46",
                                "acid": "R"
                            },
                            {
                                "position": "47",
                                "acid": "A"
                            },
                            {
                                "position": "48",
                                "acid": "K"
                            },
                            {
                                "position": "49",
                                "acid": "A"
                            },
                            {
                                "position": "50",
                                "acid": "S"
                            },
                            {
                                "position": "51",
                                "acid": "A"
                            },
                            {
                                "position": "52",
                                "acid": "V"
                            },
                            {
                                "position": "53",
                                "acid": "K"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "H"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "K"
                            },
                            {
                                "position": "58",
                                "acid": "K"
                            },
                            {
                                "position": "59",
                                "acid": "L"
                            },
                            {
                                "position": "60",
                                "acid": "A"
                            },
                            {
                                "position": "61",
                                "acid": "R"
                            },
                            {
                                "position": "62",
                                "acid": "E"
                            },
                            {
                                "position": "63",
                                "acid": "N"
                            },
                            {
                                "position": "64",
                                "acid": "A"
                            },
                            {
                                "position": "65",
                                "acid": "R"
                            },
                            {
                                "position": "66",
                                "acid": "R"
                            },
                            {
                                "position": "67",
                                "acid": "T"
                            },
                            {
                                "position": "68",
                                "acid": "R"
                            },
                            {
                                "position": "69",
                                "acid": "L"
                            },
                            {
                                "position": "70",
                                "acid": "Y"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "9",
                                            "ion_display_position": "9",
                                            "spec_id": "353",
                                            "peak_id": "23",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "9",
                                            "ion_display_position": "61",
                                            "spec_id": "353",
                                            "peak_id": "5",
                                            "peak_charge": "12"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "10",
                                            "ion_display_position": "10",
                                            "spec_id": "353",
                                            "peak_id": "27",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "10",
                                            "ion_display_position": "60",
                                            "spec_id": "353",
                                            "peak_id": "4",
                                            "peak_charge": "12"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "10",
                                            "ion_display_position": "60",
                                            "spec_id": "353",
                                            "peak_id": "10",
                                            "peak_charge": "11"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "11",
                                        "ion_display_position": "59",
                                        "spec_id": "353",
                                        "peak_id": "1",
                                        "peak_charge": "12"
                                    }
                                }
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "353",
                                            "peak_id": "13",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "353",
                                            "peak_id": "21",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "12",
                                            "ion_display_position": "58",
                                            "spec_id": "353",
                                            "peak_id": "2",
                                            "peak_charge": "11"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "12",
                                            "ion_display_position": "58",
                                            "spec_id": "353",
                                            "peak_id": "0",
                                            "peak_charge": "12"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "24",
                                        "ion_display_position": "46",
                                        "spec_id": "353",
                                        "peak_id": "50",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "30",
                                            "ion_display_position": "40",
                                            "spec_id": "353",
                                            "peak_id": "8",
                                            "peak_charge": "8"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "30",
                                            "ion_display_position": "40",
                                            "spec_id": "353",
                                            "peak_id": "3",
                                            "peak_charge": "10"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "34",
                                            "ion_display_position": "34",
                                            "spec_id": "353",
                                            "peak_id": "7",
                                            "peak_charge": "8"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "34",
                                            "ion_display_position": "36",
                                            "spec_id": "353",
                                            "peak_id": "18",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "39",
                                        "ion_display_position": "31",
                                        "spec_id": "353",
                                        "peak_id": "40",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "54",
                                        "ion_display_position": "16",
                                        "spec_id": "353",
                                        "peak_id": "26",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": {
                                "left_pos": "22",
                                "right_pos": "23",
                                "anno": "C"
                            }
                        }
                    }
                }
            },
            {
                "prsm_id": "28",
                "p_value": "6.53e-06",
                "e_value": "6.53e-08",
                "fdr": "0",
                "matched_fragment_number": "9",
                "matched_peak_number": "12",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_2/st_1_ms2.msalign",
                        "ms1_ids": "387",
                        "ms1_scans": "759",
                        "ids": "371",
                        "scans": "760",
                        "precursor_mono_mass": "8420.6725",
                        "precursor_charge": "16",
                        "precursor_mz": "527.2993",
                        "feature_inte": "1.1444e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "371",
                                "peak_id": "0",
                                "monoisotopic_mass": "6996.8921",
                                "monoisotopic_mz": "539.2297",
                                "intensity": "60149.99",
                                "charge": "13",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6996.9615",
                                        "ion_position": "12",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0694",
                                        "ppm": "-9.92"
                                    }
                                }
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "1",
                                "monoisotopic_mass": "7338.0146",
                                "monoisotopic_mz": "565.4699",
                                "intensity": "19682.17",
                                "charge": "13"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "2",
                                "monoisotopic_mass": "4925.7691",
                                "monoisotopic_mz": "493.5842",
                                "intensity": "35809.16",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4925.8142",
                                        "ion_position": "30",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0451",
                                        "ppm": "-9.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "3",
                                "monoisotopic_mass": "7258.9949",
                                "monoisotopic_mz": "605.9235",
                                "intensity": "9303.59",
                                "charge": "12",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7259.0569",
                                        "ion_position": "10",
                                        "ion_display_position": "60",
                                        "ion_sort_name": "Y00060",
                                        "ion_left_position": "10",
                                        "mass_error": "-0.0620",
                                        "ppm": "-8.54"
                                    }
                                }
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "4",
                                "monoisotopic_mass": "7356.0348",
                                "monoisotopic_mz": "566.8561",
                                "intensity": "95133.81",
                                "charge": "13"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "5",
                                "monoisotopic_mass": "2179.4984",
                                "monoisotopic_mz": "199.1435",
                                "intensity": "2249.39",
                                "charge": "11"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "6",
                                "monoisotopic_mass": "3662.1001",
                                "monoisotopic_mz": "458.7698",
                                "intensity": "4199.22",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3662.1306",
                                        "ion_position": "39",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "Y00031",
                                        "ion_left_position": "39",
                                        "mass_error": "-0.0305",
                                        "ppm": "-8.32"
                                    }
                                }
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "7",
                                "monoisotopic_mass": "7259.0336",
                                "monoisotopic_mz": "559.3945",
                                "intensity": "12444.74",
                                "charge": "13",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7259.0569",
                                        "ion_position": "10",
                                        "ion_display_position": "60",
                                        "ion_sort_name": "Y00060",
                                        "ion_left_position": "10",
                                        "mass_error": "-0.0233",
                                        "ppm": "-3.20"
                                    }
                                }
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "8",
                                "monoisotopic_mass": "7311.0201",
                                "monoisotopic_mz": "563.3934",
                                "intensity": "6627.84",
                                "charge": "13"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "9",
                                "monoisotopic_mass": "4925.7653",
                                "monoisotopic_mz": "548.3145",
                                "intensity": "34687.89",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4925.8142",
                                        "ion_position": "30",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0489",
                                        "ppm": "-9.94"
                                    }
                                }
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "10",
                                "monoisotopic_mass": "6951.9057",
                                "monoisotopic_mz": "535.7693",
                                "intensity": "3701.54",
                                "charge": "13"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "11",
                                "monoisotopic_mass": "4907.7454",
                                "monoisotopic_mz": "491.7818",
                                "intensity": "7592.86",
                                "charge": "10"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "12",
                                "monoisotopic_mass": "7767.5358",
                                "monoisotopic_mz": "555.8313",
                                "intensity": "2796.38",
                                "charge": "14"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "13",
                                "monoisotopic_mass": "6979.8611",
                                "monoisotopic_mz": "537.9197",
                                "intensity": "8329.73",
                                "charge": "13"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "14",
                                "monoisotopic_mass": "7175.7456",
                                "monoisotopic_mz": "598.9861",
                                "intensity": "1595.57",
                                "charge": "12"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "15",
                                "monoisotopic_mass": "6660.4415",
                                "monoisotopic_mz": "556.0441",
                                "intensity": "1486.05",
                                "charge": "12"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "16",
                                "monoisotopic_mass": "6640.3780",
                                "monoisotopic_mz": "554.3721",
                                "intensity": "5307.44",
                                "charge": "12"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "17",
                                "monoisotopic_mass": "4864.7366",
                                "monoisotopic_mz": "541.5336",
                                "intensity": "2272.25",
                                "charge": "9"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "18",
                                "monoisotopic_mass": "3662.0963",
                                "monoisotopic_mz": "611.3567",
                                "intensity": "4734.24",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3662.1306",
                                        "ion_position": "39",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "Y00031",
                                        "ion_left_position": "39",
                                        "mass_error": "-0.0342",
                                        "ppm": "-9.35"
                                    }
                                }
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "19",
                                "monoisotopic_mass": "7112.9020",
                                "monoisotopic_mz": "593.7491",
                                "intensity": "3851.50",
                                "charge": "12"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "20",
                                "monoisotopic_mass": "4926.7619",
                                "monoisotopic_mz": "616.8525",
                                "intensity": "1918.49",
                                "charge": "8"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "21",
                                "monoisotopic_mass": "1423.7320",
                                "monoisotopic_mz": "712.8733",
                                "intensity": "5326.60",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1423.7460",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0139",
                                        "ppm": "-9.79"
                                    }
                                }
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "22",
                                "monoisotopic_mass": "4340.3873",
                                "monoisotopic_mz": "621.0626",
                                "intensity": "19450.01",
                                "charge": "7"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "23",
                                "monoisotopic_mass": "2638.4946",
                                "monoisotopic_mz": "440.7564",
                                "intensity": "9773.26",
                                "charge": "6"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "24",
                                "monoisotopic_mass": "4340.3903",
                                "monoisotopic_mz": "543.5561",
                                "intensity": "19182.04",
                                "charge": "8"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "25",
                                "monoisotopic_mass": "2377.8603",
                                "monoisotopic_mz": "199.1623",
                                "intensity": "2070.43",
                                "charge": "12"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "26",
                                "monoisotopic_mass": "4323.3654",
                                "monoisotopic_mz": "618.6309",
                                "intensity": "6561.63",
                                "charge": "7"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "27",
                                "monoisotopic_mass": "4907.7433",
                                "monoisotopic_mz": "546.3121",
                                "intensity": "11134.64",
                                "charge": "9"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "28",
                                "monoisotopic_mass": "5238.9244",
                                "monoisotopic_mz": "583.1100",
                                "intensity": "4485.14",
                                "charge": "9"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "29",
                                "monoisotopic_mass": "6995.8552",
                                "monoisotopic_mz": "583.9952",
                                "intensity": "7420.98",
                                "charge": "12"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "30",
                                "monoisotopic_mass": "1064.5887",
                                "monoisotopic_mz": "355.8702",
                                "intensity": "4891.90",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1064.5978",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "-0.0091",
                                        "ppm": "-8.58"
                                    }
                                }
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "31",
                                "monoisotopic_mass": "1843.0588",
                                "monoisotopic_mz": "461.7720",
                                "intensity": "2059.82",
                                "charge": "4"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "32",
                                "monoisotopic_mass": "1263.6672",
                                "monoisotopic_mz": "422.2297",
                                "intensity": "1221.11",
                                "charge": "3"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "33",
                                "monoisotopic_mass": "1036.5941",
                                "monoisotopic_mz": "346.5386",
                                "intensity": "4282.32",
                                "charge": "3"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "34",
                                "monoisotopic_mass": "1161.6412",
                                "monoisotopic_mz": "388.2210",
                                "intensity": "2260.27",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1161.6506",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "-0.0094",
                                        "ppm": "-8.10"
                                    }
                                }
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "35",
                                "monoisotopic_mass": "1405.7154",
                                "monoisotopic_mz": "703.8650",
                                "intensity": "1418.53",
                                "charge": "2"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "36",
                                "monoisotopic_mass": "3494.8559",
                                "monoisotopic_mz": "583.4833",
                                "intensity": "3087.76",
                                "charge": "6"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "37",
                                "monoisotopic_mass": "1236.6937",
                                "monoisotopic_mz": "619.3541",
                                "intensity": "911.76",
                                "charge": "2"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "38",
                                "monoisotopic_mass": "6978.8637",
                                "monoisotopic_mz": "582.5792",
                                "intensity": "3441.17",
                                "charge": "12"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "39",
                                "monoisotopic_mass": "2900.5870",
                                "monoisotopic_mz": "581.1247",
                                "intensity": "2491.38",
                                "charge": "5"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "40",
                                "monoisotopic_mass": "1161.6383",
                                "monoisotopic_mz": "581.8264",
                                "intensity": "2888.47",
                                "charge": "2"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "41",
                                "monoisotopic_mass": "4296.3656",
                                "monoisotopic_mz": "614.7738",
                                "intensity": "4839.86",
                                "charge": "7"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "42",
                                "monoisotopic_mass": "2900.5959",
                                "monoisotopic_mz": "484.4399",
                                "intensity": "2590.31",
                                "charge": "6"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "43",
                                "monoisotopic_mass": "2430.2703",
                                "monoisotopic_mz": "608.5748",
                                "intensity": "3451.99",
                                "charge": "4"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "44",
                                "monoisotopic_mass": "1729.9769",
                                "monoisotopic_mz": "433.5015",
                                "intensity": "3593.83",
                                "charge": "4"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "45",
                                "monoisotopic_mass": "1298.7357",
                                "monoisotopic_mz": "433.9192",
                                "intensity": "1710.63",
                                "charge": "3"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "46",
                                "monoisotopic_mass": "4775.5780",
                                "monoisotopic_mz": "597.9545",
                                "intensity": "2019.55",
                                "charge": "8"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "47",
                                "monoisotopic_mass": "2637.4957",
                                "monoisotopic_mz": "528.5064",
                                "intensity": "2964.70",
                                "charge": "5"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "48",
                                "monoisotopic_mass": "532.2946",
                                "monoisotopic_mz": "533.3019",
                                "intensity": "1930.72",
                                "charge": "1"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "49",
                                "monoisotopic_mass": "4358.4025",
                                "monoisotopic_mz": "623.6362",
                                "intensity": "7479.64",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4358.4425",
                                        "ion_position": "34",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "Y00036",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0399",
                                        "ppm": "-9.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "50",
                                "monoisotopic_mass": "5125.8850",
                                "monoisotopic_mz": "570.5501",
                                "intensity": "1679.11",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5125.8939",
                                        "ion_position": "28",
                                        "ion_display_position": "42",
                                        "ion_sort_name": "Y00042",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0089",
                                        "ppm": "-1.73"
                                    }
                                }
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "51",
                                "monoisotopic_mass": "3474.9248",
                                "monoisotopic_mz": "580.1614",
                                "intensity": "2096.97",
                                "charge": "6"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "52",
                                "monoisotopic_mass": "1172.6480",
                                "monoisotopic_mz": "587.3313",
                                "intensity": "1640.21",
                                "charge": "2"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "53",
                                "monoisotopic_mass": "2455.2265",
                                "monoisotopic_mz": "614.8139",
                                "intensity": "3359.07",
                                "charge": "4"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "54",
                                "monoisotopic_mass": "1139.3012",
                                "monoisotopic_mz": "570.6579",
                                "intensity": "2300.33",
                                "charge": "2"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "55",
                                "monoisotopic_mass": "4359.4153",
                                "monoisotopic_mz": "545.9342",
                                "intensity": "1815.72",
                                "charge": "8"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "56",
                                "monoisotopic_mass": "1839.5064",
                                "monoisotopic_mz": "614.1761",
                                "intensity": "1873.48",
                                "charge": "3"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "57",
                                "monoisotopic_mass": "1628.9214",
                                "monoisotopic_mz": "543.9811",
                                "intensity": "1903.51",
                                "charge": "3"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "58",
                                "monoisotopic_mass": "3352.9928",
                                "monoisotopic_mz": "559.8394",
                                "intensity": "2407.26",
                                "charge": "6"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "59",
                                "monoisotopic_mass": "3379.1464",
                                "monoisotopic_mz": "564.1983",
                                "intensity": "2201.87",
                                "charge": "6"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "60",
                                "monoisotopic_mass": "3863.6649",
                                "monoisotopic_mz": "552.9594",
                                "intensity": "1713.57",
                                "charge": "7"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "61",
                                "monoisotopic_mass": "4881.7553",
                                "monoisotopic_mz": "543.4245",
                                "intensity": "2787.79",
                                "charge": "9"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "62",
                                "monoisotopic_mass": "3368.2279",
                                "monoisotopic_mz": "562.3786",
                                "intensity": "1341.76",
                                "charge": "6"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "63",
                                "monoisotopic_mass": "4490.9587",
                                "monoisotopic_mz": "562.3771",
                                "intensity": "1147.27",
                                "charge": "8"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "64",
                                "monoisotopic_mass": "1199.4968",
                                "monoisotopic_mz": "600.7557",
                                "intensity": "1358.89",
                                "charge": "2"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "65",
                                "monoisotopic_mass": "3679.5459",
                                "monoisotopic_mz": "614.2649",
                                "intensity": "2110.58",
                                "charge": "6"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "66",
                                "monoisotopic_mass": "2398.3199",
                                "monoisotopic_mz": "600.5873",
                                "intensity": "1919.20",
                                "charge": "4"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "67",
                                "monoisotopic_mass": "5801.4624",
                                "monoisotopic_mz": "581.1535",
                                "intensity": "2233.09",
                                "charge": "10"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "68",
                                "monoisotopic_mass": "985.1538",
                                "monoisotopic_mz": "493.5842",
                                "intensity": "7034.84",
                                "charge": "2"
                            },
                            {
                                "spec_id": "371",
                                "peak_id": "69",
                                "monoisotopic_mass": "1185.6528",
                                "monoisotopic_mz": "593.8337",
                                "intensity": "1375.86",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "5",
                    "proteoform_id": "5",
                    "sequence_name": "sp|P68684|RS21_SALTY",
                    "sequence_description": "30S ribosomal protein S21 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpsU PE=3 SV=2",
                    "proteoform_mass": "8420.7075",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "71",
                        "first_residue_position": "1",
                        "last_residue_position": "70",
                        "annotated_seq": "M.PVIKVRENEPFDVALRRFKRS(C)[Carbamidomethylation]EKAGVLAEVRRREFYEKPTTERKRAKASAVKRHAKKLARENARRTRLY.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "P"
                            },
                            {
                                "position": "2",
                                "acid": "V"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "V"
                            },
                            {
                                "position": "6",
                                "acid": "R"
                            },
                            {
                                "position": "7",
                                "acid": "E"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "E"
                            },
                            {
                                "position": "10",
                                "acid": "P"
                            },
                            {
                                "position": "11",
                                "acid": "F"
                            },
                            {
                                "position": "12",
                                "acid": "D"
                            },
                            {
                                "position": "13",
                                "acid": "V"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "R"
                            },
                            {
                                "position": "17",
                                "acid": "R"
                            },
                            {
                                "position": "18",
                                "acid": "F"
                            },
                            {
                                "position": "19",
                                "acid": "K"
                            },
                            {
                                "position": "20",
                                "acid": "R"
                            },
                            {
                                "position": "21",
                                "acid": "S"
                            },
                            {
                                "position": "22",
                                "acid": "C"
                            },
                            {
                                "position": "23",
                                "acid": "E"
                            },
                            {
                                "position": "24",
                                "acid": "K"
                            },
                            {
                                "position": "25",
                                "acid": "A"
                            },
                            {
                                "position": "26",
                                "acid": "G"
                            },
                            {
                                "position": "27",
                                "acid": "V"
                            },
                            {
                                "position": "28",
                                "acid": "L"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "R"
                            },
                            {
                                "position": "33",
                                "acid": "R"
                            },
                            {
                                "position": "34",
                                "acid": "R"
                            },
                            {
                                "position": "35",
                                "acid": "E"
                            },
                            {
                                "position": "36",
                                "acid": "F"
                            },
                            {
                                "position": "37",
                                "acid": "Y"
                            },
                            {
                                "position": "38",
                                "acid": "E"
                            },
                            {
                                "position": "39",
                                "acid": "K"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "T"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "E"
                            },
                            {
                                "position": "44",
                                "acid": "R"
                            },
                            {
                                "position": "45",
                                "acid": "K"
                            },
                            {
                                "position": "46",
                                "acid": "R"
                            },
                            {
                                "position": "47",
                                "acid": "A"
                            },
                            {
                                "position": "48",
                                "acid": "K"
                            },
                            {
                                "position": "49",
                                "acid": "A"
                            },
                            {
                                "position": "50",
                                "acid": "S"
                            },
                            {
                                "position": "51",
                                "acid": "A"
                            },
                            {
                                "position": "52",
                                "acid": "V"
                            },
                            {
                                "position": "53",
                                "acid": "K"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "H"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "K"
                            },
                            {
                                "position": "58",
                                "acid": "K"
                            },
                            {
                                "position": "59",
                                "acid": "L"
                            },
                            {
                                "position": "60",
                                "acid": "A"
                            },
                            {
                                "position": "61",
                                "acid": "R"
                            },
                            {
                                "position": "62",
                                "acid": "E"
                            },
                            {
                                "position": "63",
                                "acid": "N"
                            },
                            {
                                "position": "64",
                                "acid": "A"
                            },
                            {
                                "position": "65",
                                "acid": "R"
                            },
                            {
                                "position": "66",
                                "acid": "R"
                            },
                            {
                                "position": "67",
                                "acid": "T"
                            },
                            {
                                "position": "68",
                                "acid": "R"
                            },
                            {
                                "position": "69",
                                "acid": "L"
                            },
                            {
                                "position": "70",
                                "acid": "Y"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "spec_id": "371",
                                        "peak_id": "30",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "10",
                                            "ion_display_position": "10",
                                            "spec_id": "371",
                                            "peak_id": "34",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "10",
                                            "ion_display_position": "60",
                                            "spec_id": "371",
                                            "peak_id": "3",
                                            "peak_charge": "12"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "10",
                                            "ion_display_position": "60",
                                            "spec_id": "371",
                                            "peak_id": "7",
                                            "peak_charge": "13"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "371",
                                            "peak_id": "21",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "12",
                                            "ion_display_position": "58",
                                            "spec_id": "371",
                                            "peak_id": "0",
                                            "peak_charge": "13"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "28",
                                        "ion_display_position": "42",
                                        "spec_id": "371",
                                        "peak_id": "50",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "30",
                                            "ion_display_position": "40",
                                            "spec_id": "371",
                                            "peak_id": "9",
                                            "peak_charge": "9"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "30",
                                            "ion_display_position": "40",
                                            "spec_id": "371",
                                            "peak_id": "2",
                                            "peak_charge": "10"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "34",
                                        "ion_display_position": "36",
                                        "spec_id": "371",
                                        "peak_id": "49",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "39",
                                            "ion_display_position": "31",
                                            "spec_id": "371",
                                            "peak_id": "18",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "39",
                                            "ion_display_position": "31",
                                            "spec_id": "371",
                                            "peak_id": "6",
                                            "peak_charge": "8"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": {
                                "left_pos": "22",
                                "right_pos": "23",
                                "anno": "C"
                            }
                        }
                    }
                }
            },
            {
                "prsm_id": "25",
                "p_value": "8.47e-05",
                "e_value": "8.47e-07",
                "fdr": "0",
                "matched_fragment_number": "4",
                "matched_peak_number": "5",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_2/st_1_ms2.msalign",
                        "ms1_ids": "376",
                        "ms1_scans": "737",
                        "ids": "360",
                        "scans": "738",
                        "precursor_mono_mass": "8420.6578",
                        "precursor_charge": "16",
                        "precursor_mz": "527.2984",
                        "feature_inte": "1.7663e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "360",
                                "peak_id": "0",
                                "monoisotopic_mass": "6996.8945",
                                "monoisotopic_mz": "539.2299",
                                "intensity": "128712.42",
                                "charge": "13",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6996.9615",
                                        "ion_position": "12",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0670",
                                        "ppm": "-9.58"
                                    }
                                }
                            },
                            {
                                "spec_id": "360",
                                "peak_id": "1",
                                "monoisotopic_mass": "6654.7496",
                                "monoisotopic_mz": "605.9845",
                                "intensity": "19291.61",
                                "charge": "11"
                            },
                            {
                                "spec_id": "360",
                                "peak_id": "2",
                                "monoisotopic_mass": "7355.0332",
                                "monoisotopic_mz": "566.7791",
                                "intensity": "206596.54",
                                "charge": "13"
                            },
                            {
                                "spec_id": "360",
                                "peak_id": "3",
                                "monoisotopic_mass": "7337.9979",
                                "monoisotopic_mz": "565.4687",
                                "intensity": "45310.28",
                                "charge": "13"
                            },
                            {
                                "spec_id": "360",
                                "peak_id": "4",
                                "monoisotopic_mass": "4924.7681",
                                "monoisotopic_mz": "493.4841",
                                "intensity": "92249.62",
                                "charge": "10"
                            },
                            {
                                "spec_id": "360",
                                "peak_id": "5",
                                "monoisotopic_mass": "4925.7679",
                                "monoisotopic_mz": "548.3148",
                                "intensity": "96421.17",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4925.8142",
                                        "ion_position": "30",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0463",
                                        "ppm": "-9.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "360",
                                "peak_id": "6",
                                "monoisotopic_mass": "4907.7433",
                                "monoisotopic_mz": "546.3121",
                                "intensity": "12297.51",
                                "charge": "9"
                            },
                            {
                                "spec_id": "360",
                                "peak_id": "7",
                                "monoisotopic_mass": "3662.0898",
                                "monoisotopic_mz": "458.7685",
                                "intensity": "9426.64",
                                "charge": "8"
                            },
                            {
                                "spec_id": "360",
                                "peak_id": "8",
                                "monoisotopic_mass": "4340.3920",
                                "monoisotopic_mz": "621.0633",
                                "intensity": "52674.63",
                                "charge": "7"
                            },
                            {
                                "spec_id": "360",
                                "peak_id": "9",
                                "monoisotopic_mass": "4358.3979",
                                "monoisotopic_mz": "623.6355",
                                "intensity": "12637.42",
                                "charge": "7"
                            },
                            {
                                "spec_id": "360",
                                "peak_id": "10",
                                "monoisotopic_mass": "1423.7334",
                                "monoisotopic_mz": "475.5851",
                                "intensity": "20831.40",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1423.7460",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0125",
                                        "ppm": "-8.81"
                                    }
                                }
                            },
                            {
                                "spec_id": "360",
                                "peak_id": "11",
                                "monoisotopic_mass": "4340.3883",
                                "monoisotopic_mz": "543.5558",
                                "intensity": "47301.30",
                                "charge": "8"
                            },
                            {
                                "spec_id": "360",
                                "peak_id": "12",
                                "monoisotopic_mass": "7598.6241",
                                "monoisotopic_mz": "543.7661",
                                "intensity": "9215.39",
                                "charge": "14"
                            },
                            {
                                "spec_id": "360",
                                "peak_id": "13",
                                "monoisotopic_mass": "1036.5948",
                                "monoisotopic_mz": "346.5389",
                                "intensity": "8245.72",
                                "charge": "3"
                            },
                            {
                                "spec_id": "360",
                                "peak_id": "14",
                                "monoisotopic_mass": "1064.5896",
                                "monoisotopic_mz": "355.8705",
                                "intensity": "12003.23",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1064.5978",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "-0.0082",
                                        "ppm": "-7.72"
                                    }
                                }
                            },
                            {
                                "spec_id": "360",
                                "peak_id": "15",
                                "monoisotopic_mass": "7260.9345",
                                "monoisotopic_mz": "559.5407",
                                "intensity": "9695.49",
                                "charge": "13"
                            },
                            {
                                "spec_id": "360",
                                "peak_id": "16",
                                "monoisotopic_mass": "881.5059",
                                "monoisotopic_mz": "441.7603",
                                "intensity": "5513.83",
                                "charge": "2"
                            },
                            {
                                "spec_id": "360",
                                "peak_id": "17",
                                "monoisotopic_mass": "865.4886",
                                "monoisotopic_mz": "433.7516",
                                "intensity": "7044.75",
                                "charge": "2"
                            },
                            {
                                "spec_id": "360",
                                "peak_id": "18",
                                "monoisotopic_mass": "6404.0197",
                                "monoisotopic_mz": "583.1909",
                                "intensity": "14013.99",
                                "charge": "11"
                            },
                            {
                                "spec_id": "360",
                                "peak_id": "19",
                                "monoisotopic_mass": "6995.8990",
                                "monoisotopic_mz": "583.9989",
                                "intensity": "27297.30",
                                "charge": "12",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6996.9615",
                                        "ion_position": "12",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0601",
                                        "ppm": "-8.59"
                                    }
                                }
                            },
                            {
                                "spec_id": "360",
                                "peak_id": "20",
                                "monoisotopic_mass": "3618.0767",
                                "monoisotopic_mz": "604.0201",
                                "intensity": "7159.56",
                                "charge": "6"
                            },
                            {
                                "spec_id": "360",
                                "peak_id": "21",
                                "monoisotopic_mass": "2179.4940",
                                "monoisotopic_mz": "199.1431",
                                "intensity": "8284.25",
                                "charge": "11"
                            },
                            {
                                "spec_id": "360",
                                "peak_id": "22",
                                "monoisotopic_mass": "1161.6366",
                                "monoisotopic_mz": "388.2195",
                                "intensity": "6221.67",
                                "charge": "3"
                            },
                            {
                                "spec_id": "360",
                                "peak_id": "23",
                                "monoisotopic_mass": "2637.4897",
                                "monoisotopic_mz": "440.5889",
                                "intensity": "24604.32",
                                "charge": "6"
                            },
                            {
                                "spec_id": "360",
                                "peak_id": "24",
                                "monoisotopic_mass": "5965.0389",
                                "monoisotopic_mz": "543.2835",
                                "intensity": "11440.74",
                                "charge": "11"
                            },
                            {
                                "spec_id": "360",
                                "peak_id": "25",
                                "monoisotopic_mass": "2774.5711",
                                "monoisotopic_mz": "199.1909",
                                "intensity": "7883.56",
                                "charge": "14"
                            },
                            {
                                "spec_id": "360",
                                "peak_id": "26",
                                "monoisotopic_mass": "537.2964",
                                "monoisotopic_mz": "538.3036",
                                "intensity": "9827.94",
                                "charge": "1"
                            },
                            {
                                "spec_id": "360",
                                "peak_id": "27",
                                "monoisotopic_mass": "1164.6499",
                                "monoisotopic_mz": "583.3322",
                                "intensity": "5633.81",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "5",
                    "proteoform_id": "5",
                    "sequence_name": "sp|P68684|RS21_SALTY",
                    "sequence_description": "30S ribosomal protein S21 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpsU PE=3 SV=2",
                    "proteoform_mass": "8420.7075",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "71",
                        "first_residue_position": "1",
                        "last_residue_position": "70",
                        "annotated_seq": "M.PVIKVRENEPFDVALRRFKRS(C)[Carbamidomethylation]EKAGVLAEVRRREFYEKPTTERKRAKASAVKRHAKKLARENARRTRLY.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "P"
                            },
                            {
                                "position": "2",
                                "acid": "V"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "V"
                            },
                            {
                                "position": "6",
                                "acid": "R"
                            },
                            {
                                "position": "7",
                                "acid": "E"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "E"
                            },
                            {
                                "position": "10",
                                "acid": "P"
                            },
                            {
                                "position": "11",
                                "acid": "F"
                            },
                            {
                                "position": "12",
                                "acid": "D"
                            },
                            {
                                "position": "13",
                                "acid": "V"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "R"
                            },
                            {
                                "position": "17",
                                "acid": "R"
                            },
                            {
                                "position": "18",
                                "acid": "F"
                            },
                            {
                                "position": "19",
                                "acid": "K"
                            },
                            {
                                "position": "20",
                                "acid": "R"
                            },
                            {
                                "position": "21",
                                "acid": "S"
                            },
                            {
                                "position": "22",
                                "acid": "C"
                            },
                            {
                                "position": "23",
                                "acid": "E"
                            },
                            {
                                "position": "24",
                                "acid": "K"
                            },
                            {
                                "position": "25",
                                "acid": "A"
                            },
                            {
                                "position": "26",
                                "acid": "G"
                            },
                            {
                                "position": "27",
                                "acid": "V"
                            },
                            {
                                "position": "28",
                                "acid": "L"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "R"
                            },
                            {
                                "position": "33",
                                "acid": "R"
                            },
                            {
                                "position": "34",
                                "acid": "R"
                            },
                            {
                                "position": "35",
                                "acid": "E"
                            },
                            {
                                "position": "36",
                                "acid": "F"
                            },
                            {
                                "position": "37",
                                "acid": "Y"
                            },
                            {
                                "position": "38",
                                "acid": "E"
                            },
                            {
                                "position": "39",
                                "acid": "K"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "T"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "E"
                            },
                            {
                                "position": "44",
                                "acid": "R"
                            },
                            {
                                "position": "45",
                                "acid": "K"
                            },
                            {
                                "position": "46",
                                "acid": "R"
                            },
                            {
                                "position": "47",
                                "acid": "A"
                            },
                            {
                                "position": "48",
                                "acid": "K"
                            },
                            {
                                "position": "49",
                                "acid": "A"
                            },
                            {
                                "position": "50",
                                "acid": "S"
                            },
                            {
                                "position": "51",
                                "acid": "A"
                            },
                            {
                                "position": "52",
                                "acid": "V"
                            },
                            {
                                "position": "53",
                                "acid": "K"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "H"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "K"
                            },
                            {
                                "position": "58",
                                "acid": "K"
                            },
                            {
                                "position": "59",
                                "acid": "L"
                            },
                            {
                                "position": "60",
                                "acid": "A"
                            },
                            {
                                "position": "61",
                                "acid": "R"
                            },
                            {
                                "position": "62",
                                "acid": "E"
                            },
                            {
                                "position": "63",
                                "acid": "N"
                            },
                            {
                                "position": "64",
                                "acid": "A"
                            },
                            {
                                "position": "65",
                                "acid": "R"
                            },
                            {
                                "position": "66",
                                "acid": "R"
                            },
                            {
                                "position": "67",
                                "acid": "T"
                            },
                            {
                                "position": "68",
                                "acid": "R"
                            },
                            {
                                "position": "69",
                                "acid": "L"
                            },
                            {
                                "position": "70",
                                "acid": "Y"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "spec_id": "360",
                                        "peak_id": "14",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "360",
                                            "peak_id": "10",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "12",
                                            "ion_display_position": "58",
                                            "spec_id": "360",
                                            "peak_id": "0",
                                            "peak_charge": "13"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "12",
                                            "ion_display_position": "58",
                                            "spec_id": "360",
                                            "peak_id": "19",
                                            "peak_charge": "12"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "30",
                                        "ion_display_position": "40",
                                        "spec_id": "360",
                                        "peak_id": "5",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": {
                                "left_pos": "22",
                                "right_pos": "23",
                                "anno": "C"
                            }
                        }
                    }
                }
            }
        ]
    }
}
