prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "10",
        "sequence_name": "sp|P0A2A5|RL28_SALTY",
        "sequence_description": "50S ribosomal protein L28 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmB PE=3 SV=2",
        "proteoform_id": "10",
        "prsm_number": "6",
        "prsm": [
            {
                "prsm_id": "45",
                "p_value": "1.94e-07",
                "e_value": "1.94e-09",
                "fdr": "0",
                "matched_fragment_number": "8",
                "matched_peak_number": "9",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_2/st_1_ms2.msalign",
                        "ms1_ids": "447",
                        "ms1_scans": "879",
                        "ids": "431",
                        "scans": "880",
                        "precursor_mono_mass": "8970.8235",
                        "precursor_charge": "15",
                        "precursor_mz": "599.0622",
                        "feature_inte": "1.2543e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "431",
                                "peak_id": "0",
                                "monoisotopic_mass": "8223.4170",
                                "monoisotopic_mz": "633.5778",
                                "intensity": "9347.90",
                                "charge": "13"
                            },
                            {
                                "spec_id": "431",
                                "peak_id": "1",
                                "monoisotopic_mass": "8340.5050",
                                "monoisotopic_mz": "642.5846",
                                "intensity": "9431.15",
                                "charge": "13"
                            },
                            {
                                "spec_id": "431",
                                "peak_id": "2",
                                "monoisotopic_mass": "8241.4411",
                                "monoisotopic_mz": "634.9643",
                                "intensity": "37093.53",
                                "charge": "13",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8241.5216",
                                        "ion_position": "6",
                                        "ion_display_position": "71",
                                        "ion_sort_name": "Y00071",
                                        "ion_left_position": "6",
                                        "mass_error": "-0.0805",
                                        "ppm": "-9.77"
                                    }
                                }
                            },
                            {
                                "spec_id": "431",
                                "peak_id": "3",
                                "monoisotopic_mass": "8451.5701",
                                "monoisotopic_mz": "651.1281",
                                "intensity": "2570.75",
                                "charge": "13"
                            },
                            {
                                "spec_id": "431",
                                "peak_id": "4",
                                "monoisotopic_mass": "6893.6316",
                                "monoisotopic_mz": "627.7011",
                                "intensity": "9442.25",
                                "charge": "11"
                            },
                            {
                                "spec_id": "431",
                                "peak_id": "5",
                                "monoisotopic_mass": "6165.3080",
                                "monoisotopic_mz": "686.0415",
                                "intensity": "11995.72",
                                "charge": "9"
                            },
                            {
                                "spec_id": "431",
                                "peak_id": "6",
                                "monoisotopic_mass": "8077.3698",
                                "monoisotopic_mz": "674.1214",
                                "intensity": "4854.26",
                                "charge": "12"
                            },
                            {
                                "spec_id": "431",
                                "peak_id": "7",
                                "monoisotopic_mass": "1819.9639",
                                "monoisotopic_mz": "607.6619",
                                "intensity": "1709.82",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1819.9792",
                                        "ion_position": "61",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "Y00016",
                                        "ion_left_position": "61",
                                        "mass_error": "-0.0153",
                                        "ppm": "-8.40"
                                    }
                                }
                            },
                            {
                                "spec_id": "431",
                                "peak_id": "8",
                                "monoisotopic_mass": "7762.1818",
                                "monoisotopic_mz": "706.6602",
                                "intensity": "1798.85",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7763.2499",
                                        "ion_position": "67",
                                        "ion_display_position": "67",
                                        "ion_sort_name": "B00067",
                                        "ion_left_position": "67",
                                        "mass_error": "-0.0657",
                                        "ppm": "-8.46"
                                    }
                                }
                            },
                            {
                                "spec_id": "431",
                                "peak_id": "9",
                                "monoisotopic_mass": "2076.1496",
                                "monoisotopic_mz": "520.0447",
                                "intensity": "11107.65",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2076.1691",
                                        "ion_position": "59",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "Y00018",
                                        "ion_left_position": "59",
                                        "mass_error": "-0.0195",
                                        "ppm": "-9.39"
                                    }
                                }
                            },
                            {
                                "spec_id": "431",
                                "peak_id": "10",
                                "monoisotopic_mass": "8241.4505",
                                "monoisotopic_mz": "687.7948",
                                "intensity": "3492.15",
                                "charge": "12",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8241.5216",
                                        "ion_position": "6",
                                        "ion_display_position": "71",
                                        "ion_sort_name": "Y00071",
                                        "ion_left_position": "6",
                                        "mass_error": "-0.0711",
                                        "ppm": "-8.63"
                                    }
                                }
                            },
                            {
                                "spec_id": "431",
                                "peak_id": "11",
                                "monoisotopic_mass": "1971.1387",
                                "monoisotopic_mz": "658.0535",
                                "intensity": "10921.14",
                                "charge": "3"
                            },
                            {
                                "spec_id": "431",
                                "peak_id": "12",
                                "monoisotopic_mass": "2376.8684",
                                "monoisotopic_mz": "199.0796",
                                "intensity": "1773.74",
                                "charge": "12"
                            },
                            {
                                "spec_id": "431",
                                "peak_id": "13",
                                "monoisotopic_mass": "630.2851",
                                "monoisotopic_mz": "631.2924",
                                "intensity": "5517.01",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "630.2908",
                                        "ion_position": "5",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "B00005",
                                        "ion_left_position": "5",
                                        "mass_error": "-0.0057",
                                        "ppm": "-9.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "431",
                                "peak_id": "14",
                                "monoisotopic_mass": "991.5482",
                                "monoisotopic_mz": "331.5233",
                                "intensity": "7187.05",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "991.5563",
                                        "ion_position": "69",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "69",
                                        "mass_error": "-0.0081",
                                        "ppm": "-8.17"
                                    }
                                }
                            },
                            {
                                "spec_id": "431",
                                "peak_id": "15",
                                "monoisotopic_mass": "1320.7019",
                                "monoisotopic_mz": "661.3582",
                                "intensity": "4508.51",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1320.7150",
                                        "ion_position": "66",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "66",
                                        "mass_error": "-0.0131",
                                        "ppm": "-9.93"
                                    }
                                }
                            },
                            {
                                "spec_id": "431",
                                "peak_id": "16",
                                "monoisotopic_mass": "8138.3891",
                                "monoisotopic_mz": "627.0372",
                                "intensity": "2777.43",
                                "charge": "13"
                            },
                            {
                                "spec_id": "431",
                                "peak_id": "17",
                                "monoisotopic_mass": "4047.2799",
                                "monoisotopic_mz": "675.5539",
                                "intensity": "2512.82",
                                "charge": "6"
                            },
                            {
                                "spec_id": "431",
                                "peak_id": "18",
                                "monoisotopic_mass": "1207.6197",
                                "monoisotopic_mz": "604.8171",
                                "intensity": "1342.34",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1207.6309",
                                        "ion_position": "67",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "67",
                                        "mass_error": "-0.0112",
                                        "ppm": "-9.29"
                                    }
                                }
                            },
                            {
                                "spec_id": "431",
                                "peak_id": "19",
                                "monoisotopic_mass": "2576.3319",
                                "monoisotopic_mz": "199.1866",
                                "intensity": "1953.22",
                                "charge": "13"
                            },
                            {
                                "spec_id": "431",
                                "peak_id": "20",
                                "monoisotopic_mass": "1419.7680",
                                "monoisotopic_mz": "710.8913",
                                "intensity": "1461.96",
                                "charge": "2"
                            },
                            {
                                "spec_id": "431",
                                "peak_id": "21",
                                "monoisotopic_mass": "4404.3734",
                                "monoisotopic_mz": "630.2035",
                                "intensity": "3296.64",
                                "charge": "7"
                            },
                            {
                                "spec_id": "431",
                                "peak_id": "22",
                                "monoisotopic_mass": "8391.1579",
                                "monoisotopic_mz": "700.2704",
                                "intensity": "1457.78",
                                "charge": "12"
                            },
                            {
                                "spec_id": "431",
                                "peak_id": "23",
                                "monoisotopic_mass": "700.3930",
                                "monoisotopic_mz": "351.2038",
                                "intensity": "1099.40",
                                "charge": "2"
                            },
                            {
                                "spec_id": "431",
                                "peak_id": "24",
                                "monoisotopic_mass": "828.4861",
                                "monoisotopic_mz": "415.2503",
                                "intensity": "1846.12",
                                "charge": "2"
                            },
                            {
                                "spec_id": "431",
                                "peak_id": "25",
                                "monoisotopic_mass": "1942.1191",
                                "monoisotopic_mz": "648.3803",
                                "intensity": "2156.29",
                                "charge": "3"
                            },
                            {
                                "spec_id": "431",
                                "peak_id": "26",
                                "monoisotopic_mass": "1981.3325",
                                "monoisotopic_mz": "199.1405",
                                "intensity": "1724.74",
                                "charge": "10"
                            },
                            {
                                "spec_id": "431",
                                "peak_id": "27",
                                "monoisotopic_mass": "6146.2813",
                                "monoisotopic_mz": "683.9274",
                                "intensity": "2440.12",
                                "charge": "9"
                            },
                            {
                                "spec_id": "431",
                                "peak_id": "28",
                                "monoisotopic_mass": "2731.8222",
                                "monoisotopic_mz": "683.9628",
                                "intensity": "1536.22",
                                "charge": "4"
                            },
                            {
                                "spec_id": "431",
                                "peak_id": "29",
                                "monoisotopic_mass": "1365.2762",
                                "monoisotopic_mz": "683.6454",
                                "intensity": "1033.08",
                                "charge": "2"
                            },
                            {
                                "spec_id": "431",
                                "peak_id": "30",
                                "monoisotopic_mass": "7230.8644",
                                "monoisotopic_mz": "724.0937",
                                "intensity": "1543.20",
                                "charge": "10"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "10",
                    "proteoform_id": "10",
                    "sequence_name": "sp|P0A2A5|RL28_SALTY",
                    "sequence_description": "50S ribosomal protein L28 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmB PE=3 SV=2",
                    "proteoform_mass": "8970.8808",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "78",
                        "first_residue_position": "1",
                        "last_residue_position": "77",
                        "annotated_seq": "M.SRV(C)[Carbamidomethylation]QVTGKRPVTGNNRSHALNATKRRFLPNLHSHRFWVESEKRFVTLRVSAKGMRIIDKKGIETVLSELRARGEKY.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "R"
                            },
                            {
                                "position": "3",
                                "acid": "V"
                            },
                            {
                                "position": "4",
                                "acid": "C"
                            },
                            {
                                "position": "5",
                                "acid": "Q"
                            },
                            {
                                "position": "6",
                                "acid": "V"
                            },
                            {
                                "position": "7",
                                "acid": "T"
                            },
                            {
                                "position": "8",
                                "acid": "G"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "R"
                            },
                            {
                                "position": "11",
                                "acid": "P"
                            },
                            {
                                "position": "12",
                                "acid": "V"
                            },
                            {
                                "position": "13",
                                "acid": "T"
                            },
                            {
                                "position": "14",
                                "acid": "G"
                            },
                            {
                                "position": "15",
                                "acid": "N"
                            },
                            {
                                "position": "16",
                                "acid": "N"
                            },
                            {
                                "position": "17",
                                "acid": "R"
                            },
                            {
                                "position": "18",
                                "acid": "S"
                            },
                            {
                                "position": "19",
                                "acid": "H"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "L"
                            },
                            {
                                "position": "22",
                                "acid": "N"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "K"
                            },
                            {
                                "position": "26",
                                "acid": "R"
                            },
                            {
                                "position": "27",
                                "acid": "R"
                            },
                            {
                                "position": "28",
                                "acid": "F"
                            },
                            {
                                "position": "29",
                                "acid": "L"
                            },
                            {
                                "position": "30",
                                "acid": "P"
                            },
                            {
                                "position": "31",
                                "acid": "N"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "H"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "H"
                            },
                            {
                                "position": "36",
                                "acid": "R"
                            },
                            {
                                "position": "37",
                                "acid": "F"
                            },
                            {
                                "position": "38",
                                "acid": "W"
                            },
                            {
                                "position": "39",
                                "acid": "V"
                            },
                            {
                                "position": "40",
                                "acid": "E"
                            },
                            {
                                "position": "41",
                                "acid": "S"
                            },
                            {
                                "position": "42",
                                "acid": "E"
                            },
                            {
                                "position": "43",
                                "acid": "K"
                            },
                            {
                                "position": "44",
                                "acid": "R"
                            },
                            {
                                "position": "45",
                                "acid": "F"
                            },
                            {
                                "position": "46",
                                "acid": "V"
                            },
                            {
                                "position": "47",
                                "acid": "T"
                            },
                            {
                                "position": "48",
                                "acid": "L"
                            },
                            {
                                "position": "49",
                                "acid": "R"
                            },
                            {
                                "position": "50",
                                "acid": "V"
                            },
                            {
                                "position": "51",
                                "acid": "S"
                            },
                            {
                                "position": "52",
                                "acid": "A"
                            },
                            {
                                "position": "53",
                                "acid": "K"
                            },
                            {
                                "position": "54",
                                "acid": "G"
                            },
                            {
                                "position": "55",
                                "acid": "M"
                            },
                            {
                                "position": "56",
                                "acid": "R"
                            },
                            {
                                "position": "57",
                                "acid": "I"
                            },
                            {
                                "position": "58",
                                "acid": "I"
                            },
                            {
                                "position": "59",
                                "acid": "D"
                            },
                            {
                                "position": "60",
                                "acid": "K"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "G"
                            },
                            {
                                "position": "63",
                                "acid": "I"
                            },
                            {
                                "position": "64",
                                "acid": "E"
                            },
                            {
                                "position": "65",
                                "acid": "T"
                            },
                            {
                                "position": "66",
                                "acid": "V"
                            },
                            {
                                "position": "67",
                                "acid": "L"
                            },
                            {
                                "position": "68",
                                "acid": "S"
                            },
                            {
                                "position": "69",
                                "acid": "E"
                            },
                            {
                                "position": "70",
                                "acid": "L"
                            },
                            {
                                "position": "71",
                                "acid": "R"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "R"
                            },
                            {
                                "position": "74",
                                "acid": "G"
                            },
                            {
                                "position": "75",
                                "acid": "E"
                            },
                            {
                                "position": "76",
                                "acid": "K"
                            },
                            {
                                "position": "77",
                                "acid": "Y"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "5",
                                        "ion_display_position": "5",
                                        "spec_id": "431",
                                        "peak_id": "13",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "6",
                                            "ion_display_position": "71",
                                            "spec_id": "431",
                                            "peak_id": "2",
                                            "peak_charge": "13"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "6",
                                            "ion_display_position": "71",
                                            "spec_id": "431",
                                            "peak_id": "10",
                                            "peak_charge": "12"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "59",
                                        "ion_display_position": "18",
                                        "spec_id": "431",
                                        "peak_id": "9",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "61",
                                        "ion_display_position": "16",
                                        "spec_id": "431",
                                        "peak_id": "7",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "66",
                                        "ion_display_position": "11",
                                        "spec_id": "431",
                                        "peak_id": "15",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "67",
                                            "ion_display_position": "10",
                                            "spec_id": "431",
                                            "peak_id": "18",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "67",
                                            "ion_display_position": "67",
                                            "spec_id": "431",
                                            "peak_id": "8",
                                            "peak_charge": "11"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "69",
                                        "ion_display_position": "8",
                                        "spec_id": "431",
                                        "peak_id": "14",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": {
                                "left_pos": "4",
                                "right_pos": "5",
                                "anno": "C"
                            }
                        }
                    }
                }
            },
            {
                "prsm_id": "44",
                "p_value": "8.05e-07",
                "e_value": "8.05e-09",
                "fdr": "0",
                "matched_fragment_number": "8",
                "matched_peak_number": "10",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_2/st_1_ms2.msalign",
                        "ms1_ids": "446",
                        "ms1_scans": "877",
                        "ids": "430",
                        "scans": "878",
                        "precursor_mono_mass": "8970.8235",
                        "precursor_charge": "16",
                        "precursor_mz": "561.6837",
                        "feature_inte": "1.2543e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "430",
                                "peak_id": "0",
                                "monoisotopic_mass": "8241.4464",
                                "monoisotopic_mz": "589.6820",
                                "intensity": "26477.84",
                                "charge": "14",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8241.5216",
                                        "ion_position": "6",
                                        "ion_display_position": "71",
                                        "ion_sort_name": "Y00071",
                                        "ion_left_position": "6",
                                        "mass_error": "-0.0753",
                                        "ppm": "-9.13"
                                    }
                                }
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "1",
                                "monoisotopic_mass": "8197.3998",
                                "monoisotopic_mz": "586.5358",
                                "intensity": "3229.41",
                                "charge": "14"
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "2",
                                "monoisotopic_mass": "7551.0197",
                                "monoisotopic_mz": "630.2589",
                                "intensity": "21621.07",
                                "charge": "12"
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "3",
                                "monoisotopic_mass": "7532.0013",
                                "monoisotopic_mz": "628.6741",
                                "intensity": "12563.44",
                                "charge": "12"
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "4",
                                "monoisotopic_mass": "8340.5153",
                                "monoisotopic_mz": "596.7584",
                                "intensity": "7262.61",
                                "charge": "14",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8340.5900",
                                        "ion_position": "5",
                                        "ion_display_position": "72",
                                        "ion_sort_name": "Y00072",
                                        "ion_left_position": "5",
                                        "mass_error": "-0.0747",
                                        "ppm": "-8.96"
                                    }
                                }
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "5",
                                "monoisotopic_mass": "2179.6724",
                                "monoisotopic_mz": "199.1593",
                                "intensity": "1807.15",
                                "charge": "11"
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "6",
                                "monoisotopic_mass": "7356.0296",
                                "monoisotopic_mz": "614.0097",
                                "intensity": "5519.28",
                                "charge": "12"
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "7",
                                "monoisotopic_mass": "7449.9855",
                                "monoisotopic_mz": "621.8394",
                                "intensity": "2424.11",
                                "charge": "12",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7450.0497",
                                        "ion_position": "64",
                                        "ion_display_position": "64",
                                        "ion_sort_name": "B00064",
                                        "ion_left_position": "64",
                                        "mass_error": "-0.0642",
                                        "ppm": "-8.62"
                                    }
                                }
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "8",
                                "monoisotopic_mass": "7550.1130",
                                "monoisotopic_mz": "687.3812",
                                "intensity": "2888.06",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7551.0974",
                                        "ion_position": "65",
                                        "ion_display_position": "65",
                                        "ion_sort_name": "B00065",
                                        "ion_left_position": "65",
                                        "mass_error": "0.0179",
                                        "ppm": "2.37"
                                    }
                                }
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "9",
                                "monoisotopic_mass": "6821.6733",
                                "monoisotopic_mz": "683.1746",
                                "intensity": "6794.08",
                                "charge": "10"
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "10",
                                "monoisotopic_mass": "1981.2916",
                                "monoisotopic_mz": "199.1364",
                                "intensity": "2214.76",
                                "charge": "10"
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "11",
                                "monoisotopic_mass": "7558.6688",
                                "monoisotopic_mz": "582.4433",
                                "intensity": "3059.08",
                                "charge": "13"
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "12",
                                "monoisotopic_mass": "7585.5092",
                                "monoisotopic_mz": "690.5990",
                                "intensity": "2204.49",
                                "charge": "11"
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "13",
                                "monoisotopic_mass": "1320.7033",
                                "monoisotopic_mz": "441.2417",
                                "intensity": "24187.11",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1320.7150",
                                        "ion_position": "66",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "66",
                                        "mass_error": "-0.0117",
                                        "ppm": "-8.88"
                                    }
                                }
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "14",
                                "monoisotopic_mass": "4030.2578",
                                "monoisotopic_mz": "504.7895",
                                "intensity": "1589.34",
                                "charge": "8"
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "15",
                                "monoisotopic_mass": "1320.7009",
                                "monoisotopic_mz": "661.3577",
                                "intensity": "3663.05",
                                "charge": "2"
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "16",
                                "monoisotopic_mass": "1207.6214",
                                "monoisotopic_mz": "403.5477",
                                "intensity": "4153.07",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1207.6309",
                                        "ion_position": "67",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "67",
                                        "mass_error": "-0.0096",
                                        "ppm": "-7.93"
                                    }
                                }
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "17",
                                "monoisotopic_mass": "991.5480",
                                "monoisotopic_mz": "331.5233",
                                "intensity": "5563.39",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "991.5563",
                                        "ion_position": "69",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "69",
                                        "mass_error": "-0.0083",
                                        "ppm": "-8.35"
                                    }
                                }
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "18",
                                "monoisotopic_mass": "8140.5640",
                                "monoisotopic_mz": "627.2045",
                                "intensity": "3891.20",
                                "charge": "13"
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "19",
                                "monoisotopic_mass": "630.2852",
                                "monoisotopic_mz": "631.2925",
                                "intensity": "3364.86",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "630.2908",
                                        "ion_position": "5",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "B00005",
                                        "ion_left_position": "5",
                                        "mass_error": "-0.0056",
                                        "ppm": "-8.85"
                                    }
                                }
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "20",
                                "monoisotopic_mass": "2626.2099",
                                "monoisotopic_mz": "657.5598",
                                "intensity": "2992.12",
                                "charge": "4"
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "21",
                                "monoisotopic_mass": "1139.6335",
                                "monoisotopic_mz": "570.8240",
                                "intensity": "1836.72",
                                "charge": "2"
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "22",
                                "monoisotopic_mass": "4047.2846",
                                "monoisotopic_mz": "579.1908",
                                "intensity": "6242.80",
                                "charge": "7"
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "23",
                                "monoisotopic_mass": "991.5484",
                                "monoisotopic_mz": "496.7815",
                                "intensity": "1240.79",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "991.5563",
                                        "ion_position": "69",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "69",
                                        "mass_error": "-0.0079",
                                        "ppm": "-7.94"
                                    }
                                }
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "24",
                                "monoisotopic_mass": "1303.6712",
                                "monoisotopic_mz": "435.5643",
                                "intensity": "912.62",
                                "charge": "3"
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "25",
                                "monoisotopic_mass": "1338.3259",
                                "monoisotopic_mz": "670.1702",
                                "intensity": "767.40",
                                "charge": "2"
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "26",
                                "monoisotopic_mass": "828.4849",
                                "monoisotopic_mz": "415.2497",
                                "intensity": "1093.69",
                                "charge": "2"
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "27",
                                "monoisotopic_mass": "6202.2482",
                                "monoisotopic_mz": "621.2321",
                                "intensity": "2234.59",
                                "charge": "10"
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "28",
                                "monoisotopic_mass": "6802.6686",
                                "monoisotopic_mz": "681.2741",
                                "intensity": "4226.51",
                                "charge": "10"
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "29",
                                "monoisotopic_mass": "6165.3030",
                                "monoisotopic_mz": "617.5376",
                                "intensity": "3480.81",
                                "charge": "10"
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "30",
                                "monoisotopic_mass": "2747.0183",
                                "monoisotopic_mz": "687.7619",
                                "intensity": "2680.71",
                                "charge": "4"
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "31",
                                "monoisotopic_mass": "1971.1382",
                                "monoisotopic_mz": "658.0533",
                                "intensity": "3522.43",
                                "charge": "3"
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "32",
                                "monoisotopic_mass": "2023.6395",
                                "monoisotopic_mz": "506.9172",
                                "intensity": "3296.68",
                                "charge": "4"
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "33",
                                "monoisotopic_mass": "8346.0986",
                                "monoisotopic_mz": "696.5155",
                                "intensity": "3429.61",
                                "charge": "12"
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "34",
                                "monoisotopic_mass": "6099.6771",
                                "monoisotopic_mz": "678.7492",
                                "intensity": "1724.30",
                                "charge": "9"
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "35",
                                "monoisotopic_mass": "2500.3140",
                                "monoisotopic_mz": "626.0858",
                                "intensity": "1146.95",
                                "charge": "4"
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "36",
                                "monoisotopic_mass": "672.9199",
                                "monoisotopic_mz": "673.9272",
                                "intensity": "1952.24",
                                "charge": "1"
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "37",
                                "monoisotopic_mass": "8223.4226",
                                "monoisotopic_mz": "588.3946",
                                "intensity": "6994.73",
                                "charge": "14"
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "38",
                                "monoisotopic_mass": "4742.6922",
                                "monoisotopic_mz": "678.5347",
                                "intensity": "2162.74",
                                "charge": "7"
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "39",
                                "monoisotopic_mass": "6165.3134",
                                "monoisotopic_mz": "686.0421",
                                "intensity": "4672.39",
                                "charge": "9"
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "40",
                                "monoisotopic_mass": "8451.5745",
                                "monoisotopic_mz": "604.6912",
                                "intensity": "2691.73",
                                "charge": "14"
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "41",
                                "monoisotopic_mass": "7036.3848",
                                "monoisotopic_mz": "587.3727",
                                "intensity": "1067.88",
                                "charge": "12"
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "42",
                                "monoisotopic_mass": "3498.4224",
                                "monoisotopic_mz": "584.0777",
                                "intensity": "1736.74",
                                "charge": "6"
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "43",
                                "monoisotopic_mass": "4227.2744",
                                "monoisotopic_mz": "604.9036",
                                "intensity": "1469.67",
                                "charge": "7"
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "44",
                                "monoisotopic_mass": "1207.6208",
                                "monoisotopic_mz": "604.8177",
                                "intensity": "3018.72",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1207.6309",
                                        "ion_position": "67",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "67",
                                        "mass_error": "-0.0101",
                                        "ppm": "-8.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "45",
                                "monoisotopic_mass": "4048.1079",
                                "monoisotopic_mz": "675.6919",
                                "intensity": "1516.18",
                                "charge": "6"
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "46",
                                "monoisotopic_mass": "2075.1458",
                                "monoisotopic_mz": "519.7937",
                                "intensity": "3288.77",
                                "charge": "4"
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "47",
                                "monoisotopic_mass": "3761.5438",
                                "monoisotopic_mz": "627.9312",
                                "intensity": "2923.38",
                                "charge": "6"
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "48",
                                "monoisotopic_mass": "1379.1334",
                                "monoisotopic_mz": "690.5740",
                                "intensity": "967.06",
                                "charge": "2"
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "49",
                                "monoisotopic_mass": "1254.6644",
                                "monoisotopic_mz": "628.3395",
                                "intensity": "3437.66",
                                "charge": "2"
                            },
                            {
                                "spec_id": "430",
                                "peak_id": "50",
                                "monoisotopic_mass": "5012.6837",
                                "monoisotopic_mz": "627.5927",
                                "intensity": "3005.59",
                                "charge": "8"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "10",
                    "proteoform_id": "10",
                    "sequence_name": "sp|P0A2A5|RL28_SALTY",
                    "sequence_description": "50S ribosomal protein L28 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmB PE=3 SV=2",
                    "proteoform_mass": "8970.8808",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "78",
                        "first_residue_position": "1",
                        "last_residue_position": "77",
                        "annotated_seq": "M.SRV(C)[Carbamidomethylation]QVTGKRPVTGNNRSHALNATKRRFLPNLHSHRFWVESEKRFVTLRVSAKGMRIIDKKGIETVLSELRARGEKY.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "R"
                            },
                            {
                                "position": "3",
                                "acid": "V"
                            },
                            {
                                "position": "4",
                                "acid": "C"
                            },
                            {
                                "position": "5",
                                "acid": "Q"
                            },
                            {
                                "position": "6",
                                "acid": "V"
                            },
                            {
                                "position": "7",
                                "acid": "T"
                            },
                            {
                                "position": "8",
                                "acid": "G"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "R"
                            },
                            {
                                "position": "11",
                                "acid": "P"
                            },
                            {
                                "position": "12",
                                "acid": "V"
                            },
                            {
                                "position": "13",
                                "acid": "T"
                            },
                            {
                                "position": "14",
                                "acid": "G"
                            },
                            {
                                "position": "15",
                                "acid": "N"
                            },
                            {
                                "position": "16",
                                "acid": "N"
                            },
                            {
                                "position": "17",
                                "acid": "R"
                            },
                            {
                                "position": "18",
                                "acid": "S"
                            },
                            {
                                "position": "19",
                                "acid": "H"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "L"
                            },
                            {
                                "position": "22",
                                "acid": "N"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "K"
                            },
                            {
                                "position": "26",
                                "acid": "R"
                            },
                            {
                                "position": "27",
                                "acid": "R"
                            },
                            {
                                "position": "28",
                                "acid": "F"
                            },
                            {
                                "position": "29",
                                "acid": "L"
                            },
                            {
                                "position": "30",
                                "acid": "P"
                            },
                            {
                                "position": "31",
                                "acid": "N"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "H"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "H"
                            },
                            {
                                "position": "36",
                                "acid": "R"
                            },
                            {
                                "position": "37",
                                "acid": "F"
                            },
                            {
                                "position": "38",
                                "acid": "W"
                            },
                            {
                                "position": "39",
                                "acid": "V"
                            },
                            {
                                "position": "40",
                                "acid": "E"
                            },
                            {
                                "position": "41",
                                "acid": "S"
                            },
                            {
                                "position": "42",
                                "acid": "E"
                            },
                            {
                                "position": "43",
                                "acid": "K"
                            },
                            {
                                "position": "44",
                                "acid": "R"
                            },
                            {
                                "position": "45",
                                "acid": "F"
                            },
                            {
                                "position": "46",
                                "acid": "V"
                            },
                            {
                                "position": "47",
                                "acid": "T"
                            },
                            {
                                "position": "48",
                                "acid": "L"
                            },
                            {
                                "position": "49",
                                "acid": "R"
                            },
                            {
                                "position": "50",
                                "acid": "V"
                            },
                            {
                                "position": "51",
                                "acid": "S"
                            },
                            {
                                "position": "52",
                                "acid": "A"
                            },
                            {
                                "position": "53",
                                "acid": "K"
                            },
                            {
                                "position": "54",
                                "acid": "G"
                            },
                            {
                                "position": "55",
                                "acid": "M"
                            },
                            {
                                "position": "56",
                                "acid": "R"
                            },
                            {
                                "position": "57",
                                "acid": "I"
                            },
                            {
                                "position": "58",
                                "acid": "I"
                            },
                            {
                                "position": "59",
                                "acid": "D"
                            },
                            {
                                "position": "60",
                                "acid": "K"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "G"
                            },
                            {
                                "position": "63",
                                "acid": "I"
                            },
                            {
                                "position": "64",
                                "acid": "E"
                            },
                            {
                                "position": "65",
                                "acid": "T"
                            },
                            {
                                "position": "66",
                                "acid": "V"
                            },
                            {
                                "position": "67",
                                "acid": "L"
                            },
                            {
                                "position": "68",
                                "acid": "S"
                            },
                            {
                                "position": "69",
                                "acid": "E"
                            },
                            {
                                "position": "70",
                                "acid": "L"
                            },
                            {
                                "position": "71",
                                "acid": "R"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "R"
                            },
                            {
                                "position": "74",
                                "acid": "G"
                            },
                            {
                                "position": "75",
                                "acid": "E"
                            },
                            {
                                "position": "76",
                                "acid": "K"
                            },
                            {
                                "position": "77",
                                "acid": "Y"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "5",
                                            "ion_display_position": "5",
                                            "spec_id": "430",
                                            "peak_id": "19",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "5",
                                            "ion_display_position": "72",
                                            "spec_id": "430",
                                            "peak_id": "4",
                                            "peak_charge": "14"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "6",
                                        "ion_display_position": "71",
                                        "spec_id": "430",
                                        "peak_id": "0",
                                        "peak_charge": "14"
                                    }
                                }
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "64",
                                        "ion_display_position": "64",
                                        "spec_id": "430",
                                        "peak_id": "7",
                                        "peak_charge": "12"
                                    }
                                }
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "65",
                                        "ion_display_position": "65",
                                        "spec_id": "430",
                                        "peak_id": "8",
                                        "peak_charge": "11"
                                    }
                                }
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "66",
                                        "ion_display_position": "11",
                                        "spec_id": "430",
                                        "peak_id": "13",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "67",
                                            "ion_display_position": "10",
                                            "spec_id": "430",
                                            "peak_id": "44",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "67",
                                            "ion_display_position": "10",
                                            "spec_id": "430",
                                            "peak_id": "16",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "69",
                                            "ion_display_position": "8",
                                            "spec_id": "430",
                                            "peak_id": "17",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "69",
                                            "ion_display_position": "8",
                                            "spec_id": "430",
                                            "peak_id": "23",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": {
                                "left_pos": "4",
                                "right_pos": "5",
                                "anno": "C"
                            }
                        }
                    }
                }
            },
            {
                "prsm_id": "38",
                "p_value": "1.99e-06",
                "e_value": "1.99e-08",
                "fdr": "0",
                "matched_fragment_number": "13",
                "matched_peak_number": "14",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_2/st_1_ms2.msalign",
                        "ms1_ids": "431",
                        "ms1_scans": "847",
                        "ids": "415",
                        "scans": "848",
                        "precursor_mono_mass": "8970.8235",
                        "precursor_charge": "15",
                        "precursor_mz": "599.0622",
                        "feature_inte": "1.2543e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "415",
                                "peak_id": "0",
                                "monoisotopic_mass": "8340.5225",
                                "monoisotopic_mz": "642.5859",
                                "intensity": "319206.81",
                                "charge": "13",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8340.5900",
                                        "ion_position": "5",
                                        "ion_display_position": "72",
                                        "ion_sort_name": "Y00072",
                                        "ion_left_position": "5",
                                        "mass_error": "-0.0676",
                                        "ppm": "-8.10"
                                    }
                                }
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "1",
                                "monoisotopic_mass": "6894.6494",
                                "monoisotopic_mz": "627.7936",
                                "intensity": "396516.92",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6894.7117",
                                        "ion_position": "59",
                                        "ion_display_position": "59",
                                        "ion_sort_name": "B00059",
                                        "ion_left_position": "59",
                                        "mass_error": "-0.0622",
                                        "ppm": "-9.03"
                                    }
                                }
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "2",
                                "monoisotopic_mass": "8241.4499",
                                "monoisotopic_mz": "634.9650",
                                "intensity": "1668537.42",
                                "charge": "13",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8241.5216",
                                        "ion_position": "6",
                                        "ion_display_position": "71",
                                        "ion_sort_name": "Y00071",
                                        "ion_left_position": "6",
                                        "mass_error": "-0.0718",
                                        "ppm": "-8.71"
                                    }
                                }
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "3",
                                "monoisotopic_mass": "8223.4132",
                                "monoisotopic_mz": "633.5775",
                                "intensity": "259528.45",
                                "charge": "13"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "4",
                                "monoisotopic_mass": "8124.3977",
                                "monoisotopic_mz": "625.9609",
                                "intensity": "83913.30",
                                "charge": "13"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "5",
                                "monoisotopic_mass": "8078.3944",
                                "monoisotopic_mz": "674.2068",
                                "intensity": "247018.70",
                                "charge": "12"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "6",
                                "monoisotopic_mass": "8139.3817",
                                "monoisotopic_mz": "627.1136",
                                "intensity": "273841.41",
                                "charge": "13"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "7",
                                "monoisotopic_mass": "2179.5526",
                                "monoisotopic_mz": "199.1484",
                                "intensity": "48525.90",
                                "charge": "11"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "8",
                                "monoisotopic_mass": "1649.8601",
                                "monoisotopic_mz": "825.9373",
                                "intensity": "106918.32",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1649.8737",
                                        "ion_position": "63",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "63",
                                        "mass_error": "-0.0136",
                                        "ppm": "-8.25"
                                    }
                                }
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "9",
                                "monoisotopic_mass": "8140.4141",
                                "monoisotopic_mz": "679.3751",
                                "intensity": "171358.55",
                                "charge": "12",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8140.4739",
                                        "ion_position": "7",
                                        "ion_display_position": "70",
                                        "ion_sort_name": "Y00070",
                                        "ion_left_position": "7",
                                        "mass_error": "-0.0599",
                                        "ppm": "-7.35"
                                    }
                                }
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "10",
                                "monoisotopic_mass": "1971.1395",
                                "monoisotopic_mz": "658.0538",
                                "intensity": "425916.90",
                                "charge": "3"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "11",
                                "monoisotopic_mass": "3884.2274",
                                "monoisotopic_mz": "648.3785",
                                "intensity": "122238.47",
                                "charge": "6"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "12",
                                "monoisotopic_mass": "6165.3063",
                                "monoisotopic_mz": "686.0413",
                                "intensity": "547892.64",
                                "charge": "9"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "13",
                                "monoisotopic_mass": "2076.1528",
                                "monoisotopic_mz": "520.0455",
                                "intensity": "417603.16",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2076.1691",
                                        "ion_position": "59",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "Y00018",
                                        "ion_left_position": "59",
                                        "mass_error": "-0.0163",
                                        "ppm": "-7.86"
                                    }
                                }
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "14",
                                "monoisotopic_mass": "8451.5336",
                                "monoisotopic_mz": "651.1252",
                                "intensity": "113656.73",
                                "charge": "13"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "15",
                                "monoisotopic_mass": "1320.7044",
                                "monoisotopic_mz": "661.3595",
                                "intensity": "271460.04",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1320.7150",
                                        "ion_position": "66",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "66",
                                        "mass_error": "-0.0106",
                                        "ppm": "-7.99"
                                    }
                                }
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "16",
                                "monoisotopic_mass": "4263.3630",
                                "monoisotopic_mz": "610.0591",
                                "intensity": "51417.84",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4263.4002",
                                        "ion_position": "40",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "Y00037",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0372",
                                        "ppm": "-8.72"
                                    }
                                }
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "17",
                                "monoisotopic_mass": "8198.4241",
                                "monoisotopic_mz": "631.6553",
                                "intensity": "175188.59",
                                "charge": "13"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "18",
                                "monoisotopic_mass": "2059.1221",
                                "monoisotopic_mz": "515.7878",
                                "intensity": "72374.75",
                                "charge": "4"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "19",
                                "monoisotopic_mass": "3055.7463",
                                "monoisotopic_mz": "764.9439",
                                "intensity": "60560.66",
                                "charge": "4"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "20",
                                "monoisotopic_mass": "4777.4675",
                                "monoisotopic_mz": "683.5026",
                                "intensity": "72674.45",
                                "charge": "7"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "21",
                                "monoisotopic_mass": "1207.6239",
                                "monoisotopic_mz": "604.8192",
                                "intensity": "69526.29",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1207.6309",
                                        "ion_position": "67",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "67",
                                        "mass_error": "-0.0071",
                                        "ppm": "-5.85"
                                    }
                                }
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "22",
                                "monoisotopic_mass": "991.5487",
                                "monoisotopic_mz": "331.5235",
                                "intensity": "187328.28",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "991.5563",
                                        "ion_position": "69",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "69",
                                        "mass_error": "-0.0076",
                                        "ppm": "-7.71"
                                    }
                                }
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "23",
                                "monoisotopic_mass": "502.2289",
                                "monoisotopic_mz": "503.2361",
                                "intensity": "61265.34",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "502.2322",
                                        "ion_position": "4",
                                        "ion_display_position": "4",
                                        "ion_sort_name": "B00004",
                                        "ion_left_position": "4",
                                        "mass_error": "-0.0033",
                                        "ppm": "-6.64"
                                    }
                                }
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "24",
                                "monoisotopic_mass": "4047.1132",
                                "monoisotopic_mz": "810.4299",
                                "intensity": "80917.60",
                                "charge": "5"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "25",
                                "monoisotopic_mass": "630.2861",
                                "monoisotopic_mz": "631.2933",
                                "intensity": "196466.11",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "630.2908",
                                        "ion_position": "5",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "B00005",
                                        "ion_left_position": "5",
                                        "mass_error": "-0.0047",
                                        "ppm": "-7.49"
                                    }
                                }
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "26",
                                "monoisotopic_mass": "1520.8263",
                                "monoisotopic_mz": "761.4204",
                                "intensity": "85376.08",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1520.8311",
                                        "ion_position": "64",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "64",
                                        "mass_error": "-0.0048",
                                        "ppm": "-3.15"
                                    }
                                }
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "27",
                                "monoisotopic_mass": "6165.2861",
                                "monoisotopic_mz": "771.6680",
                                "intensity": "72703.61",
                                "charge": "8"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "28",
                                "monoisotopic_mass": "7056.9978",
                                "monoisotopic_mz": "706.7071",
                                "intensity": "129867.49",
                                "charge": "10"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "29",
                                "monoisotopic_mass": "810.4759",
                                "monoisotopic_mz": "406.2452",
                                "intensity": "39905.90",
                                "charge": "2"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "30",
                                "monoisotopic_mass": "7249.9073",
                                "monoisotopic_mz": "725.9980",
                                "intensity": "144875.15",
                                "charge": "10"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "31",
                                "monoisotopic_mass": "1413.3572",
                                "monoisotopic_mz": "707.6859",
                                "intensity": "24972.87",
                                "charge": "2"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "32",
                                "monoisotopic_mass": "991.5488",
                                "monoisotopic_mz": "496.7817",
                                "intensity": "65049.95",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "991.5563",
                                        "ion_position": "69",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "69",
                                        "mass_error": "-0.0075",
                                        "ppm": "-7.58"
                                    }
                                }
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "33",
                                "monoisotopic_mass": "828.4864",
                                "monoisotopic_mz": "415.2505",
                                "intensity": "53863.50",
                                "charge": "2"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "34",
                                "monoisotopic_mass": "2099.2285",
                                "monoisotopic_mz": "700.7501",
                                "intensity": "76087.08",
                                "charge": "3"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "35",
                                "monoisotopic_mass": "709.8845",
                                "monoisotopic_mz": "710.8918",
                                "intensity": "34605.89",
                                "charge": "1"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "36",
                                "monoisotopic_mass": "3977.0883",
                                "monoisotopic_mz": "796.4249",
                                "intensity": "67944.96",
                                "charge": "5"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "37",
                                "monoisotopic_mass": "1302.6737",
                                "monoisotopic_mz": "652.3441",
                                "intensity": "81874.43",
                                "charge": "2"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "38",
                                "monoisotopic_mass": "3866.2179",
                                "monoisotopic_mz": "645.3769",
                                "intensity": "52134.24",
                                "charge": "6"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "39",
                                "monoisotopic_mass": "1469.7942",
                                "monoisotopic_mz": "735.9044",
                                "intensity": "30872.04",
                                "charge": "2"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "40",
                                "monoisotopic_mass": "696.7112",
                                "monoisotopic_mz": "697.7184",
                                "intensity": "43354.39",
                                "charge": "1"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "41",
                                "monoisotopic_mass": "6147.2754",
                                "monoisotopic_mz": "684.0379",
                                "intensity": "74050.92",
                                "charge": "9"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "42",
                                "monoisotopic_mass": "6121.1887",
                                "monoisotopic_mz": "681.1393",
                                "intensity": "46289.12",
                                "charge": "9"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "43",
                                "monoisotopic_mass": "700.3931",
                                "monoisotopic_mz": "351.2038",
                                "intensity": "44969.74",
                                "charge": "2"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "44",
                                "monoisotopic_mass": "7831.1890",
                                "monoisotopic_mz": "712.9336",
                                "intensity": "93433.31",
                                "charge": "11"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "45",
                                "monoisotopic_mass": "4806.1135",
                                "monoisotopic_mz": "687.5949",
                                "intensity": "59181.54",
                                "charge": "7"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "46",
                                "monoisotopic_mass": "2688.8030",
                                "monoisotopic_mz": "673.2080",
                                "intensity": "43090.97",
                                "charge": "4"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "47",
                                "monoisotopic_mass": "677.3672",
                                "monoisotopic_mz": "678.3745",
                                "intensity": "40994.89",
                                "charge": "1"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "48",
                                "monoisotopic_mass": "1947.0548",
                                "monoisotopic_mz": "650.0256",
                                "intensity": "99059.59",
                                "charge": "3"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "49",
                                "monoisotopic_mass": "2747.8292",
                                "monoisotopic_mz": "687.9646",
                                "intensity": "70207.82",
                                "charge": "4"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "50",
                                "monoisotopic_mass": "4871.3982",
                                "monoisotopic_mz": "696.9213",
                                "intensity": "48381.21",
                                "charge": "7"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "51",
                                "monoisotopic_mass": "5202.7938",
                                "monoisotopic_mz": "651.3565",
                                "intensity": "88370.60",
                                "charge": "8"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "52",
                                "monoisotopic_mass": "1345.1300",
                                "monoisotopic_mz": "673.5723",
                                "intensity": "30141.80",
                                "charge": "2"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "53",
                                "monoisotopic_mass": "4706.4442",
                                "monoisotopic_mz": "673.3564",
                                "intensity": "95003.68",
                                "charge": "7"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "54",
                                "monoisotopic_mass": "8808.7359",
                                "monoisotopic_mz": "630.2027",
                                "intensity": "87589.30",
                                "charge": "14"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "55",
                                "monoisotopic_mass": "4194.1553",
                                "monoisotopic_mz": "700.0332",
                                "intensity": "59176.01",
                                "charge": "6"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "56",
                                "monoisotopic_mass": "3776.7474",
                                "monoisotopic_mz": "630.4652",
                                "intensity": "50168.13",
                                "charge": "6"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "57",
                                "monoisotopic_mass": "2783.4254",
                                "monoisotopic_mz": "696.8636",
                                "intensity": "38902.24",
                                "charge": "4"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "58",
                                "monoisotopic_mass": "2575.8197",
                                "monoisotopic_mz": "199.1473",
                                "intensity": "35750.56",
                                "charge": "13"
                            },
                            {
                                "spec_id": "415",
                                "peak_id": "59",
                                "monoisotopic_mass": "1450.3789",
                                "monoisotopic_mz": "726.1967",
                                "intensity": "41058.30",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "10",
                    "proteoform_id": "10",
                    "sequence_name": "sp|P0A2A5|RL28_SALTY",
                    "sequence_description": "50S ribosomal protein L28 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmB PE=3 SV=2",
                    "proteoform_mass": "8970.8808",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "78",
                        "first_residue_position": "1",
                        "last_residue_position": "77",
                        "annotated_seq": "M.SRV(C)[Carbamidomethylation]QVTGKRPVTGNNRSHALNATKRRFLPNLHSHRFWVESEKRFVTLRVSAKGMRIIDKKGIETVLSELRARGEKY.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "R"
                            },
                            {
                                "position": "3",
                                "acid": "V"
                            },
                            {
                                "position": "4",
                                "acid": "C"
                            },
                            {
                                "position": "5",
                                "acid": "Q"
                            },
                            {
                                "position": "6",
                                "acid": "V"
                            },
                            {
                                "position": "7",
                                "acid": "T"
                            },
                            {
                                "position": "8",
                                "acid": "G"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "R"
                            },
                            {
                                "position": "11",
                                "acid": "P"
                            },
                            {
                                "position": "12",
                                "acid": "V"
                            },
                            {
                                "position": "13",
                                "acid": "T"
                            },
                            {
                                "position": "14",
                                "acid": "G"
                            },
                            {
                                "position": "15",
                                "acid": "N"
                            },
                            {
                                "position": "16",
                                "acid": "N"
                            },
                            {
                                "position": "17",
                                "acid": "R"
                            },
                            {
                                "position": "18",
                                "acid": "S"
                            },
                            {
                                "position": "19",
                                "acid": "H"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "L"
                            },
                            {
                                "position": "22",
                                "acid": "N"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "K"
                            },
                            {
                                "position": "26",
                                "acid": "R"
                            },
                            {
                                "position": "27",
                                "acid": "R"
                            },
                            {
                                "position": "28",
                                "acid": "F"
                            },
                            {
                                "position": "29",
                                "acid": "L"
                            },
                            {
                                "position": "30",
                                "acid": "P"
                            },
                            {
                                "position": "31",
                                "acid": "N"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "H"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "H"
                            },
                            {
                                "position": "36",
                                "acid": "R"
                            },
                            {
                                "position": "37",
                                "acid": "F"
                            },
                            {
                                "position": "38",
                                "acid": "W"
                            },
                            {
                                "position": "39",
                                "acid": "V"
                            },
                            {
                                "position": "40",
                                "acid": "E"
                            },
                            {
                                "position": "41",
                                "acid": "S"
                            },
                            {
                                "position": "42",
                                "acid": "E"
                            },
                            {
                                "position": "43",
                                "acid": "K"
                            },
                            {
                                "position": "44",
                                "acid": "R"
                            },
                            {
                                "position": "45",
                                "acid": "F"
                            },
                            {
                                "position": "46",
                                "acid": "V"
                            },
                            {
                                "position": "47",
                                "acid": "T"
                            },
                            {
                                "position": "48",
                                "acid": "L"
                            },
                            {
                                "position": "49",
                                "acid": "R"
                            },
                            {
                                "position": "50",
                                "acid": "V"
                            },
                            {
                                "position": "51",
                                "acid": "S"
                            },
                            {
                                "position": "52",
                                "acid": "A"
                            },
                            {
                                "position": "53",
                                "acid": "K"
                            },
                            {
                                "position": "54",
                                "acid": "G"
                            },
                            {
                                "position": "55",
                                "acid": "M"
                            },
                            {
                                "position": "56",
                                "acid": "R"
                            },
                            {
                                "position": "57",
                                "acid": "I"
                            },
                            {
                                "position": "58",
                                "acid": "I"
                            },
                            {
                                "position": "59",
                                "acid": "D"
                            },
                            {
                                "position": "60",
                                "acid": "K"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "G"
                            },
                            {
                                "position": "63",
                                "acid": "I"
                            },
                            {
                                "position": "64",
                                "acid": "E"
                            },
                            {
                                "position": "65",
                                "acid": "T"
                            },
                            {
                                "position": "66",
                                "acid": "V"
                            },
                            {
                                "position": "67",
                                "acid": "L"
                            },
                            {
                                "position": "68",
                                "acid": "S"
                            },
                            {
                                "position": "69",
                                "acid": "E"
                            },
                            {
                                "position": "70",
                                "acid": "L"
                            },
                            {
                                "position": "71",
                                "acid": "R"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "R"
                            },
                            {
                                "position": "74",
                                "acid": "G"
                            },
                            {
                                "position": "75",
                                "acid": "E"
                            },
                            {
                                "position": "76",
                                "acid": "K"
                            },
                            {
                                "position": "77",
                                "acid": "Y"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "4",
                                        "ion_display_position": "4",
                                        "spec_id": "415",
                                        "peak_id": "23",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "5",
                                            "ion_display_position": "5",
                                            "spec_id": "415",
                                            "peak_id": "25",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "5",
                                            "ion_display_position": "72",
                                            "spec_id": "415",
                                            "peak_id": "0",
                                            "peak_charge": "13"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "6",
                                        "ion_display_position": "71",
                                        "spec_id": "415",
                                        "peak_id": "2",
                                        "peak_charge": "13"
                                    }
                                }
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "7",
                                        "ion_display_position": "70",
                                        "spec_id": "415",
                                        "peak_id": "9",
                                        "peak_charge": "12"
                                    }
                                }
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "40",
                                        "ion_display_position": "37",
                                        "spec_id": "415",
                                        "peak_id": "16",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "59",
                                            "ion_display_position": "18",
                                            "spec_id": "415",
                                            "peak_id": "13",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "59",
                                            "ion_display_position": "59",
                                            "spec_id": "415",
                                            "peak_id": "1",
                                            "peak_charge": "11"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "63",
                                        "ion_display_position": "14",
                                        "spec_id": "415",
                                        "peak_id": "8",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "64",
                                        "ion_display_position": "13",
                                        "spec_id": "415",
                                        "peak_id": "26",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "66",
                                        "ion_display_position": "11",
                                        "spec_id": "415",
                                        "peak_id": "15",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "67",
                                        "ion_display_position": "10",
                                        "spec_id": "415",
                                        "peak_id": "21",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "69",
                                            "ion_display_position": "8",
                                            "spec_id": "415",
                                            "peak_id": "22",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "69",
                                            "ion_display_position": "8",
                                            "spec_id": "415",
                                            "peak_id": "32",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": {
                                "left_pos": "4",
                                "right_pos": "5",
                                "anno": "C"
                            }
                        }
                    }
                }
            },
            {
                "prsm_id": "37",
                "p_value": "8.30e-06",
                "e_value": "4.15e-08",
                "fdr": "0",
                "matched_fragment_number": "8",
                "matched_peak_number": "10",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_2/st_1_ms2.msalign",
                        "ms1_ids": "430",
                        "ms1_scans": "845",
                        "ids": "414",
                        "scans": "846",
                        "precursor_mono_mass": "8970.8235",
                        "precursor_charge": "16",
                        "precursor_mz": "561.6837",
                        "feature_inte": "1.2543e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "414",
                                "peak_id": "0",
                                "monoisotopic_mass": "7533.0190",
                                "monoisotopic_mz": "628.7589",
                                "intensity": "72909.07",
                                "charge": "12"
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "1",
                                "monoisotopic_mass": "7551.0205",
                                "monoisotopic_mz": "630.2590",
                                "intensity": "182687.19",
                                "charge": "12"
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "2",
                                "monoisotopic_mass": "8241.4438",
                                "monoisotopic_mz": "589.6818",
                                "intensity": "212478.00",
                                "charge": "14",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8241.5216",
                                        "ion_position": "6",
                                        "ion_display_position": "71",
                                        "ion_sort_name": "Y00071",
                                        "ion_left_position": "6",
                                        "mass_error": "-0.0778",
                                        "ppm": "-9.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "3",
                                "monoisotopic_mass": "4047.2822",
                                "monoisotopic_mz": "506.9175",
                                "intensity": "46057.80",
                                "charge": "8"
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "4",
                                "monoisotopic_mass": "8379.8963",
                                "monoisotopic_mz": "599.5713",
                                "intensity": "46806.82",
                                "charge": "14"
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "5",
                                "monoisotopic_mass": "8223.4149",
                                "monoisotopic_mz": "588.3941",
                                "intensity": "46179.38",
                                "charge": "14"
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "6",
                                "monoisotopic_mass": "7549.9774",
                                "monoisotopic_mz": "687.3689",
                                "intensity": "31556.06",
                                "charge": "11"
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "7",
                                "monoisotopic_mass": "4030.2597",
                                "monoisotopic_mz": "504.7897",
                                "intensity": "17676.64",
                                "charge": "8"
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "8",
                                "monoisotopic_mass": "6803.6515",
                                "monoisotopic_mz": "681.3724",
                                "intensity": "46836.67",
                                "charge": "10"
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "9",
                                "monoisotopic_mass": "8138.3621",
                                "monoisotopic_mz": "627.0351",
                                "intensity": "20769.27",
                                "charge": "13"
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "10",
                                "monoisotopic_mass": "7650.0596",
                                "monoisotopic_mz": "696.4672",
                                "intensity": "20332.70",
                                "charge": "11"
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "11",
                                "monoisotopic_mass": "1320.7010",
                                "monoisotopic_mz": "661.3578",
                                "intensity": "30245.12",
                                "charge": "2"
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "12",
                                "monoisotopic_mass": "1320.7032",
                                "monoisotopic_mz": "441.2417",
                                "intensity": "186479.74",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1320.7150",
                                        "ion_position": "66",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "66",
                                        "mass_error": "-0.0118",
                                        "ppm": "-8.95"
                                    }
                                }
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "13",
                                "monoisotopic_mass": "7980.3008",
                                "monoisotopic_mz": "614.8766",
                                "intensity": "15977.71",
                                "charge": "13",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7979.3245",
                                        "ion_position": "69",
                                        "ion_display_position": "69",
                                        "ion_sort_name": "B00069",
                                        "ion_left_position": "69",
                                        "mass_error": "-0.0261",
                                        "ppm": "-3.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "14",
                                "monoisotopic_mass": "4707.4448",
                                "monoisotopic_mz": "673.4994",
                                "intensity": "16584.32",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4707.4806",
                                        "ion_position": "40",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "B00040",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0358",
                                        "ppm": "-7.62"
                                    }
                                }
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "15",
                                "monoisotopic_mass": "1207.6196",
                                "monoisotopic_mz": "403.5471",
                                "intensity": "34748.96",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1207.6309",
                                        "ion_position": "67",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "67",
                                        "mass_error": "-0.0113",
                                        "ppm": "-9.37"
                                    }
                                }
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "16",
                                "monoisotopic_mass": "2076.1472",
                                "monoisotopic_mz": "520.0441",
                                "intensity": "32942.87",
                                "charge": "4"
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "17",
                                "monoisotopic_mass": "991.5483",
                                "monoisotopic_mz": "331.5234",
                                "intensity": "35465.91",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "991.5563",
                                        "ion_position": "69",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "69",
                                        "mass_error": "-0.0080",
                                        "ppm": "-8.08"
                                    }
                                }
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "18",
                                "monoisotopic_mass": "630.2850",
                                "monoisotopic_mz": "631.2922",
                                "intensity": "33773.52",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "630.2908",
                                        "ion_position": "5",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "B00005",
                                        "ion_left_position": "5",
                                        "mass_error": "-0.0058",
                                        "ppm": "-9.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "19",
                                "monoisotopic_mass": "6895.6243",
                                "monoisotopic_mz": "627.8822",
                                "intensity": "63620.50",
                                "charge": "11"
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "20",
                                "monoisotopic_mass": "1971.1375",
                                "monoisotopic_mz": "658.0531",
                                "intensity": "31979.34",
                                "charge": "3"
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "21",
                                "monoisotopic_mass": "991.5467",
                                "monoisotopic_mz": "496.7806",
                                "intensity": "11092.02",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "991.5563",
                                        "ion_position": "69",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "69",
                                        "mass_error": "-0.0096",
                                        "ppm": "-9.66"
                                    }
                                }
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "22",
                                "monoisotopic_mass": "1139.6295",
                                "monoisotopic_mz": "570.8220",
                                "intensity": "15484.25",
                                "charge": "2"
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "23",
                                "monoisotopic_mass": "6821.6796",
                                "monoisotopic_mz": "683.1752",
                                "intensity": "50441.69",
                                "charge": "10"
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "24",
                                "monoisotopic_mass": "1782.2547",
                                "monoisotopic_mz": "199.0356",
                                "intensity": "15292.98",
                                "charge": "9"
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "25",
                                "monoisotopic_mass": "7623.0602",
                                "monoisotopic_mz": "587.3965",
                                "intensity": "26824.11",
                                "charge": "13"
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "26",
                                "monoisotopic_mass": "1380.1250",
                                "monoisotopic_mz": "691.0698",
                                "intensity": "9127.42",
                                "charge": "2"
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "27",
                                "monoisotopic_mass": "8451.5420",
                                "monoisotopic_mz": "604.6888",
                                "intensity": "57405.32",
                                "charge": "14"
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "28",
                                "monoisotopic_mass": "7558.6910",
                                "monoisotopic_mz": "582.4450",
                                "intensity": "14802.39",
                                "charge": "13"
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "29",
                                "monoisotopic_mass": "703.7794",
                                "monoisotopic_mz": "704.7867",
                                "intensity": "7725.63",
                                "charge": "1"
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "30",
                                "monoisotopic_mass": "4048.2985",
                                "monoisotopic_mz": "579.3356",
                                "intensity": "52310.38",
                                "charge": "7"
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "31",
                                "monoisotopic_mass": "2710.2683",
                                "monoisotopic_mz": "678.5743",
                                "intensity": "18812.05",
                                "charge": "4"
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "32",
                                "monoisotopic_mass": "2501.3394",
                                "monoisotopic_mz": "626.3421",
                                "intensity": "24825.82",
                                "charge": "4"
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "33",
                                "monoisotopic_mass": "5592.2705",
                                "monoisotopic_mz": "622.3707",
                                "intensity": "8128.04",
                                "charge": "9"
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "34",
                                "monoisotopic_mass": "1157.6424",
                                "monoisotopic_mz": "579.8285",
                                "intensity": "26862.48",
                                "charge": "2"
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "35",
                                "monoisotopic_mass": "4691.9011",
                                "monoisotopic_mz": "671.2789",
                                "intensity": "15936.54",
                                "charge": "7"
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "36",
                                "monoisotopic_mass": "4170.2362",
                                "monoisotopic_mz": "596.7553",
                                "intensity": "28804.13",
                                "charge": "7"
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "37",
                                "monoisotopic_mass": "3594.5960",
                                "monoisotopic_mz": "600.1066",
                                "intensity": "11880.34",
                                "charge": "6"
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "38",
                                "monoisotopic_mass": "2908.4358",
                                "monoisotopic_mz": "582.6944",
                                "intensity": "14804.45",
                                "charge": "5"
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "39",
                                "monoisotopic_mass": "1233.6578",
                                "monoisotopic_mz": "617.8362",
                                "intensity": "10720.33",
                                "charge": "2"
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "40",
                                "monoisotopic_mass": "3081.6550",
                                "monoisotopic_mz": "617.3383",
                                "intensity": "25087.94",
                                "charge": "5"
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "41",
                                "monoisotopic_mass": "598.7229",
                                "monoisotopic_mz": "599.7301",
                                "intensity": "4619.53",
                                "charge": "1"
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "42",
                                "monoisotopic_mass": "585.2367",
                                "monoisotopic_mz": "586.2440",
                                "intensity": "10719.09",
                                "charge": "1"
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "43",
                                "monoisotopic_mass": "1178.6415",
                                "monoisotopic_mz": "590.3280",
                                "intensity": "6276.45",
                                "charge": "2"
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "44",
                                "monoisotopic_mass": "5480.0362",
                                "monoisotopic_mz": "686.0118",
                                "intensity": "24296.81",
                                "charge": "8"
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "45",
                                "monoisotopic_mass": "2978.8940",
                                "monoisotopic_mz": "596.7861",
                                "intensity": "20685.35",
                                "charge": "5"
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "46",
                                "monoisotopic_mass": "4793.6212",
                                "monoisotopic_mz": "685.8103",
                                "intensity": "11921.52",
                                "charge": "7"
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "47",
                                "monoisotopic_mass": "1207.6206",
                                "monoisotopic_mz": "604.8176",
                                "intensity": "20679.77",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1207.6309",
                                        "ion_position": "67",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "67",
                                        "mass_error": "-0.0104",
                                        "ppm": "-8.57"
                                    }
                                }
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "48",
                                "monoisotopic_mass": "5012.0057",
                                "monoisotopic_mz": "627.5080",
                                "intensity": "18080.19",
                                "charge": "8"
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "49",
                                "monoisotopic_mass": "8789.8051",
                                "monoisotopic_mz": "586.9943",
                                "intensity": "7209.08",
                                "charge": "15",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8789.8069",
                                        "ion_position": "76",
                                        "ion_display_position": "76",
                                        "ion_sort_name": "B00076",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0018",
                                        "ppm": "-0.21"
                                    }
                                }
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "50",
                                "monoisotopic_mass": "680.6684",
                                "monoisotopic_mz": "681.6757",
                                "intensity": "4241.13",
                                "charge": "1"
                            },
                            {
                                "spec_id": "414",
                                "peak_id": "51",
                                "monoisotopic_mass": "1387.4236",
                                "monoisotopic_mz": "199.2106",
                                "intensity": "4393.10",
                                "charge": "7"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "10",
                    "proteoform_id": "10",
                    "sequence_name": "sp|P0A2A5|RL28_SALTY",
                    "sequence_description": "50S ribosomal protein L28 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmB PE=3 SV=2",
                    "proteoform_mass": "8970.8808",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "78",
                        "first_residue_position": "1",
                        "last_residue_position": "77",
                        "annotated_seq": "M.SRV(C)[Carbamidomethylation]QVTGKRPVTGNNRSHALNATKRRFLPNLHSHRFWVESEKRFVTLRVSAKGMRIIDKKGIETVLSELRARGEKY.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "R"
                            },
                            {
                                "position": "3",
                                "acid": "V"
                            },
                            {
                                "position": "4",
                                "acid": "C"
                            },
                            {
                                "position": "5",
                                "acid": "Q"
                            },
                            {
                                "position": "6",
                                "acid": "V"
                            },
                            {
                                "position": "7",
                                "acid": "T"
                            },
                            {
                                "position": "8",
                                "acid": "G"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "R"
                            },
                            {
                                "position": "11",
                                "acid": "P"
                            },
                            {
                                "position": "12",
                                "acid": "V"
                            },
                            {
                                "position": "13",
                                "acid": "T"
                            },
                            {
                                "position": "14",
                                "acid": "G"
                            },
                            {
                                "position": "15",
                                "acid": "N"
                            },
                            {
                                "position": "16",
                                "acid": "N"
                            },
                            {
                                "position": "17",
                                "acid": "R"
                            },
                            {
                                "position": "18",
                                "acid": "S"
                            },
                            {
                                "position": "19",
                                "acid": "H"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "L"
                            },
                            {
                                "position": "22",
                                "acid": "N"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "K"
                            },
                            {
                                "position": "26",
                                "acid": "R"
                            },
                            {
                                "position": "27",
                                "acid": "R"
                            },
                            {
                                "position": "28",
                                "acid": "F"
                            },
                            {
                                "position": "29",
                                "acid": "L"
                            },
                            {
                                "position": "30",
                                "acid": "P"
                            },
                            {
                                "position": "31",
                                "acid": "N"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "H"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "H"
                            },
                            {
                                "position": "36",
                                "acid": "R"
                            },
                            {
                                "position": "37",
                                "acid": "F"
                            },
                            {
                                "position": "38",
                                "acid": "W"
                            },
                            {
                                "position": "39",
                                "acid": "V"
                            },
                            {
                                "position": "40",
                                "acid": "E"
                            },
                            {
                                "position": "41",
                                "acid": "S"
                            },
                            {
                                "position": "42",
                                "acid": "E"
                            },
                            {
                                "position": "43",
                                "acid": "K"
                            },
                            {
                                "position": "44",
                                "acid": "R"
                            },
                            {
                                "position": "45",
                                "acid": "F"
                            },
                            {
                                "position": "46",
                                "acid": "V"
                            },
                            {
                                "position": "47",
                                "acid": "T"
                            },
                            {
                                "position": "48",
                                "acid": "L"
                            },
                            {
                                "position": "49",
                                "acid": "R"
                            },
                            {
                                "position": "50",
                                "acid": "V"
                            },
                            {
                                "position": "51",
                                "acid": "S"
                            },
                            {
                                "position": "52",
                                "acid": "A"
                            },
                            {
                                "position": "53",
                                "acid": "K"
                            },
                            {
                                "position": "54",
                                "acid": "G"
                            },
                            {
                                "position": "55",
                                "acid": "M"
                            },
                            {
                                "position": "56",
                                "acid": "R"
                            },
                            {
                                "position": "57",
                                "acid": "I"
                            },
                            {
                                "position": "58",
                                "acid": "I"
                            },
                            {
                                "position": "59",
                                "acid": "D"
                            },
                            {
                                "position": "60",
                                "acid": "K"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "G"
                            },
                            {
                                "position": "63",
                                "acid": "I"
                            },
                            {
                                "position": "64",
                                "acid": "E"
                            },
                            {
                                "position": "65",
                                "acid": "T"
                            },
                            {
                                "position": "66",
                                "acid": "V"
                            },
                            {
                                "position": "67",
                                "acid": "L"
                            },
                            {
                                "position": "68",
                                "acid": "S"
                            },
                            {
                                "position": "69",
                                "acid": "E"
                            },
                            {
                                "position": "70",
                                "acid": "L"
                            },
                            {
                                "position": "71",
                                "acid": "R"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "R"
                            },
                            {
                                "position": "74",
                                "acid": "G"
                            },
                            {
                                "position": "75",
                                "acid": "E"
                            },
                            {
                                "position": "76",
                                "acid": "K"
                            },
                            {
                                "position": "77",
                                "acid": "Y"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "5",
                                        "ion_display_position": "5",
                                        "spec_id": "414",
                                        "peak_id": "18",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "6",
                                        "ion_display_position": "71",
                                        "spec_id": "414",
                                        "peak_id": "2",
                                        "peak_charge": "14"
                                    }
                                }
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "40",
                                        "ion_display_position": "40",
                                        "spec_id": "414",
                                        "peak_id": "14",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "66",
                                        "ion_display_position": "11",
                                        "spec_id": "414",
                                        "peak_id": "12",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "67",
                                            "ion_display_position": "10",
                                            "spec_id": "414",
                                            "peak_id": "15",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "67",
                                            "ion_display_position": "10",
                                            "spec_id": "414",
                                            "peak_id": "47",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "69",
                                            "ion_display_position": "8",
                                            "spec_id": "414",
                                            "peak_id": "21",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "69",
                                            "ion_display_position": "8",
                                            "spec_id": "414",
                                            "peak_id": "17",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "69",
                                            "ion_display_position": "69",
                                            "spec_id": "414",
                                            "peak_id": "13",
                                            "peak_charge": "13"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "76",
                                        "ion_display_position": "76",
                                        "spec_id": "414",
                                        "peak_id": "49",
                                        "peak_charge": "15"
                                    }
                                }
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": {
                                "left_pos": "4",
                                "right_pos": "5",
                                "anno": "C"
                            }
                        }
                    }
                }
            },
            {
                "prsm_id": "42",
                "p_value": "1.10e-05",
                "e_value": "5.51e-08",
                "fdr": "0",
                "matched_fragment_number": "13",
                "matched_peak_number": "14",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_2/st_1_ms2.msalign",
                        "ms1_ids": "444",
                        "ms1_scans": "873",
                        "ids": "428",
                        "scans": "874",
                        "precursor_mono_mass": "8970.8235",
                        "precursor_charge": "15",
                        "precursor_mz": "599.0622",
                        "feature_inte": "1.2543e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "428",
                                "peak_id": "0",
                                "monoisotopic_mass": "8241.4459",
                                "monoisotopic_mz": "634.9647",
                                "intensity": "317047.25",
                                "charge": "13",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8241.5216",
                                        "ion_position": "6",
                                        "ion_display_position": "71",
                                        "ion_sort_name": "Y00071",
                                        "ion_left_position": "6",
                                        "mass_error": "-0.0757",
                                        "ppm": "-9.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "1",
                                "monoisotopic_mass": "8223.4352",
                                "monoisotopic_mz": "633.5792",
                                "intensity": "49039.37",
                                "charge": "13"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "2",
                                "monoisotopic_mass": "8450.5471",
                                "monoisotopic_mz": "651.0494",
                                "intensity": "28763.10",
                                "charge": "13"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "3",
                                "monoisotopic_mass": "8340.5050",
                                "monoisotopic_mz": "642.5846",
                                "intensity": "66469.97",
                                "charge": "13"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "4",
                                "monoisotopic_mass": "8207.3790",
                                "monoisotopic_mz": "632.3441",
                                "intensity": "13431.93",
                                "charge": "13"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "5",
                                "monoisotopic_mass": "8791.6657",
                                "monoisotopic_mz": "628.9834",
                                "intensity": "14906.16",
                                "charge": "14"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "6",
                                "monoisotopic_mass": "8807.7319",
                                "monoisotopic_mz": "630.1310",
                                "intensity": "24532.67",
                                "charge": "14"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "7",
                                "monoisotopic_mass": "7831.1849",
                                "monoisotopic_mz": "712.9332",
                                "intensity": "10380.20",
                                "charge": "11"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "8",
                                "monoisotopic_mass": "8125.2697",
                                "monoisotopic_mz": "626.0280",
                                "intensity": "27478.92",
                                "charge": "13"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "9",
                                "monoisotopic_mass": "1649.8591",
                                "monoisotopic_mz": "825.9368",
                                "intensity": "16308.85",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1649.8737",
                                        "ion_position": "63",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "63",
                                        "mass_error": "-0.0146",
                                        "ppm": "-8.84"
                                    }
                                }
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "10",
                                "monoisotopic_mass": "7250.9025",
                                "monoisotopic_mz": "726.0975",
                                "intensity": "25354.52",
                                "charge": "10"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "11",
                                "monoisotopic_mass": "6165.3090",
                                "monoisotopic_mz": "686.0416",
                                "intensity": "91263.91",
                                "charge": "9"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "12",
                                "monoisotopic_mass": "2076.1511",
                                "monoisotopic_mz": "520.0451",
                                "intensity": "92402.69",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2076.1691",
                                        "ion_position": "59",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "Y00018",
                                        "ion_left_position": "59",
                                        "mass_error": "-0.0180",
                                        "ppm": "-8.68"
                                    }
                                }
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "13",
                                "monoisotopic_mass": "6894.6528",
                                "monoisotopic_mz": "627.7939",
                                "intensity": "65214.93",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6894.7117",
                                        "ion_position": "59",
                                        "ion_display_position": "59",
                                        "ion_sort_name": "B00059",
                                        "ion_left_position": "59",
                                        "mass_error": "-0.0589",
                                        "ppm": "-8.54"
                                    }
                                }
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "14",
                                "monoisotopic_mass": "2099.2252",
                                "monoisotopic_mz": "700.7490",
                                "intensity": "10876.18",
                                "charge": "3"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "15",
                                "monoisotopic_mass": "7062.0174",
                                "monoisotopic_mz": "643.0089",
                                "intensity": "21100.42",
                                "charge": "11"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "16",
                                "monoisotopic_mass": "1971.1404",
                                "monoisotopic_mz": "658.0541",
                                "intensity": "63179.34",
                                "charge": "3"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "17",
                                "monoisotopic_mass": "2227.3296",
                                "monoisotopic_mz": "557.8397",
                                "intensity": "10150.55",
                                "charge": "4"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "18",
                                "monoisotopic_mass": "1320.7012",
                                "monoisotopic_mz": "661.3579",
                                "intensity": "35812.89",
                                "charge": "2"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "19",
                                "monoisotopic_mass": "991.5488",
                                "monoisotopic_mz": "331.5235",
                                "intensity": "41720.79",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "991.5563",
                                        "ion_position": "69",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "69",
                                        "mass_error": "-0.0076",
                                        "ppm": "-7.62"
                                    }
                                }
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "20",
                                "monoisotopic_mass": "7762.1819",
                                "monoisotopic_mz": "706.6602",
                                "intensity": "25909.99",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7763.2499",
                                        "ion_position": "67",
                                        "ion_display_position": "67",
                                        "ion_sort_name": "B00067",
                                        "ion_left_position": "67",
                                        "mass_error": "-0.0656",
                                        "ppm": "-8.45"
                                    }
                                }
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "21",
                                "monoisotopic_mass": "2972.1887",
                                "monoisotopic_mz": "199.1532",
                                "intensity": "9465.47",
                                "charge": "15"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "22",
                                "monoisotopic_mass": "8140.3862",
                                "monoisotopic_mz": "627.1908",
                                "intensity": "52523.75",
                                "charge": "13"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "23",
                                "monoisotopic_mass": "6375.4038",
                                "monoisotopic_mz": "709.3855",
                                "intensity": "16164.32",
                                "charge": "9"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "24",
                                "monoisotopic_mass": "1520.8174",
                                "monoisotopic_mz": "761.4160",
                                "intensity": "15262.16",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1520.8311",
                                        "ion_position": "64",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "64",
                                        "mass_error": "-0.0137",
                                        "ppm": "-9.03"
                                    }
                                }
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "25",
                                "monoisotopic_mass": "2378.0532",
                                "monoisotopic_mz": "199.1784",
                                "intensity": "6835.59",
                                "charge": "12"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "26",
                                "monoisotopic_mass": "6065.2152",
                                "monoisotopic_mz": "674.9201",
                                "intensity": "15121.51",
                                "charge": "9"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "27",
                                "monoisotopic_mass": "3883.2244",
                                "monoisotopic_mz": "648.2113",
                                "intensity": "17603.60",
                                "charge": "6"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "28",
                                "monoisotopic_mass": "991.5481",
                                "monoisotopic_mz": "496.7813",
                                "intensity": "12435.32",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "991.5563",
                                        "ion_position": "69",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "69",
                                        "mass_error": "-0.0082",
                                        "ppm": "-8.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "29",
                                "monoisotopic_mass": "1948.0565",
                                "monoisotopic_mz": "650.3594",
                                "intensity": "14103.09",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1948.0742",
                                        "ion_position": "60",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "Y00017",
                                        "ion_left_position": "60",
                                        "mass_error": "-0.0177",
                                        "ppm": "-9.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "30",
                                "monoisotopic_mass": "2048.7625",
                                "monoisotopic_mz": "683.9281",
                                "intensity": "16184.22",
                                "charge": "3"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "31",
                                "monoisotopic_mass": "828.4886",
                                "monoisotopic_mz": "415.2516",
                                "intensity": "10226.38",
                                "charge": "2"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "32",
                                "monoisotopic_mass": "630.2850",
                                "monoisotopic_mz": "631.2922",
                                "intensity": "27789.51",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "630.2908",
                                        "ion_position": "5",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "B00005",
                                        "ion_left_position": "5",
                                        "mass_error": "-0.0058",
                                        "ppm": "-9.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "33",
                                "monoisotopic_mass": "8734.5494",
                                "monoisotopic_mz": "672.8957",
                                "intensity": "23312.78",
                                "charge": "13"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "34",
                                "monoisotopic_mass": "4707.4469",
                                "monoisotopic_mz": "673.4997",
                                "intensity": "21940.43",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4707.4806",
                                        "ion_position": "40",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "B00040",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0337",
                                        "ppm": "-7.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "35",
                                "monoisotopic_mass": "1232.8241",
                                "monoisotopic_mz": "617.4193",
                                "intensity": "4885.58",
                                "charge": "2"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "36",
                                "monoisotopic_mass": "3783.7388",
                                "monoisotopic_mz": "631.6304",
                                "intensity": "17241.25",
                                "charge": "6"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "37",
                                "monoisotopic_mass": "1207.6209",
                                "monoisotopic_mz": "604.8178",
                                "intensity": "12680.58",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1207.6309",
                                        "ion_position": "67",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "67",
                                        "mass_error": "-0.0100",
                                        "ppm": "-8.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "38",
                                "monoisotopic_mass": "7850.2288",
                                "monoisotopic_mz": "714.6644",
                                "intensity": "10545.02",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7850.2819",
                                        "ion_position": "68",
                                        "ion_display_position": "68",
                                        "ion_sort_name": "B00068",
                                        "ion_left_position": "68",
                                        "mass_error": "-0.0531",
                                        "ppm": "-6.76"
                                    }
                                }
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "39",
                                "monoisotopic_mass": "700.3930",
                                "monoisotopic_mz": "351.2038",
                                "intensity": "6289.41",
                                "charge": "2"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "40",
                                "monoisotopic_mass": "2020.3489",
                                "monoisotopic_mz": "674.4569",
                                "intensity": "20604.79",
                                "charge": "3"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "41",
                                "monoisotopic_mass": "6124.2914",
                                "monoisotopic_mz": "681.4841",
                                "intensity": "10124.78",
                                "charge": "9"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "42",
                                "monoisotopic_mass": "6960.8414",
                                "monoisotopic_mz": "697.0914",
                                "intensity": "15261.02",
                                "charge": "10"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "43",
                                "monoisotopic_mass": "4194.1638",
                                "monoisotopic_mz": "700.0346",
                                "intensity": "14328.02",
                                "charge": "6"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "44",
                                "monoisotopic_mass": "2714.1308",
                                "monoisotopic_mz": "679.5400",
                                "intensity": "15501.71",
                                "charge": "4"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "45",
                                "monoisotopic_mass": "6064.2491",
                                "monoisotopic_mz": "759.0384",
                                "intensity": "9758.64",
                                "charge": "8"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "46",
                                "monoisotopic_mass": "2784.0539",
                                "monoisotopic_mz": "697.0208",
                                "intensity": "6916.94",
                                "charge": "4"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "47",
                                "monoisotopic_mass": "2518.1938",
                                "monoisotopic_mz": "630.5557",
                                "intensity": "9553.76",
                                "charge": "4"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "48",
                                "monoisotopic_mass": "5986.9423",
                                "monoisotopic_mz": "666.2231",
                                "intensity": "11361.02",
                                "charge": "9"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "49",
                                "monoisotopic_mass": "3805.9026",
                                "monoisotopic_mz": "635.3244",
                                "intensity": "48045.56",
                                "charge": "6"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "50",
                                "monoisotopic_mass": "1419.7715",
                                "monoisotopic_mz": "710.8930",
                                "intensity": "7200.47",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1419.7834",
                                        "ion_position": "65",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "Y00012",
                                        "ion_left_position": "65",
                                        "mass_error": "-0.0120",
                                        "ppm": "-8.42"
                                    }
                                }
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "51",
                                "monoisotopic_mass": "1365.2766",
                                "monoisotopic_mz": "683.6456",
                                "intensity": "4576.33",
                                "charge": "2"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "52",
                                "monoisotopic_mass": "7538.8491",
                                "monoisotopic_mz": "686.3572",
                                "intensity": "8030.13",
                                "charge": "11"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "53",
                                "monoisotopic_mass": "1300.7019",
                                "monoisotopic_mz": "651.3582",
                                "intensity": "14218.46",
                                "charge": "2"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "54",
                                "monoisotopic_mass": "2747.1531",
                                "monoisotopic_mz": "687.7955",
                                "intensity": "7326.77",
                                "charge": "4"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "55",
                                "monoisotopic_mass": "1450.1769",
                                "monoisotopic_mz": "726.0957",
                                "intensity": "5434.00",
                                "charge": "2"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "56",
                                "monoisotopic_mass": "6724.7808",
                                "monoisotopic_mz": "673.4854",
                                "intensity": "6074.68",
                                "charge": "10"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "57",
                                "monoisotopic_mass": "1349.4341",
                                "monoisotopic_mz": "675.7243",
                                "intensity": "7383.23",
                                "charge": "2"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "58",
                                "monoisotopic_mass": "4039.1965",
                                "monoisotopic_mz": "674.2067",
                                "intensity": "12374.40",
                                "charge": "6"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "59",
                                "monoisotopic_mass": "2060.6137",
                                "monoisotopic_mz": "687.8785",
                                "intensity": "8498.04",
                                "charge": "3"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "60",
                                "monoisotopic_mass": "1392.2015",
                                "monoisotopic_mz": "697.1080",
                                "intensity": "4649.33",
                                "charge": "2"
                            },
                            {
                                "spec_id": "428",
                                "peak_id": "61",
                                "monoisotopic_mass": "2034.8514",
                                "monoisotopic_mz": "679.2911",
                                "intensity": "14646.63",
                                "charge": "3"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "10",
                    "proteoform_id": "10",
                    "sequence_name": "sp|P0A2A5|RL28_SALTY",
                    "sequence_description": "50S ribosomal protein L28 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmB PE=3 SV=2",
                    "proteoform_mass": "8970.8808",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "78",
                        "first_residue_position": "1",
                        "last_residue_position": "77",
                        "annotated_seq": "M.SRV(C)[Carbamidomethylation]QVTGKRPVTGNNRSHALNATKRRFLPNLHSHRFWVESEKRFVTLRVSAKGMRIIDKKGIETVLSELRARGEKY.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "R"
                            },
                            {
                                "position": "3",
                                "acid": "V"
                            },
                            {
                                "position": "4",
                                "acid": "C"
                            },
                            {
                                "position": "5",
                                "acid": "Q"
                            },
                            {
                                "position": "6",
                                "acid": "V"
                            },
                            {
                                "position": "7",
                                "acid": "T"
                            },
                            {
                                "position": "8",
                                "acid": "G"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "R"
                            },
                            {
                                "position": "11",
                                "acid": "P"
                            },
                            {
                                "position": "12",
                                "acid": "V"
                            },
                            {
                                "position": "13",
                                "acid": "T"
                            },
                            {
                                "position": "14",
                                "acid": "G"
                            },
                            {
                                "position": "15",
                                "acid": "N"
                            },
                            {
                                "position": "16",
                                "acid": "N"
                            },
                            {
                                "position": "17",
                                "acid": "R"
                            },
                            {
                                "position": "18",
                                "acid": "S"
                            },
                            {
                                "position": "19",
                                "acid": "H"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "L"
                            },
                            {
                                "position": "22",
                                "acid": "N"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "K"
                            },
                            {
                                "position": "26",
                                "acid": "R"
                            },
                            {
                                "position": "27",
                                "acid": "R"
                            },
                            {
                                "position": "28",
                                "acid": "F"
                            },
                            {
                                "position": "29",
                                "acid": "L"
                            },
                            {
                                "position": "30",
                                "acid": "P"
                            },
                            {
                                "position": "31",
                                "acid": "N"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "H"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "H"
                            },
                            {
                                "position": "36",
                                "acid": "R"
                            },
                            {
                                "position": "37",
                                "acid": "F"
                            },
                            {
                                "position": "38",
                                "acid": "W"
                            },
                            {
                                "position": "39",
                                "acid": "V"
                            },
                            {
                                "position": "40",
                                "acid": "E"
                            },
                            {
                                "position": "41",
                                "acid": "S"
                            },
                            {
                                "position": "42",
                                "acid": "E"
                            },
                            {
                                "position": "43",
                                "acid": "K"
                            },
                            {
                                "position": "44",
                                "acid": "R"
                            },
                            {
                                "position": "45",
                                "acid": "F"
                            },
                            {
                                "position": "46",
                                "acid": "V"
                            },
                            {
                                "position": "47",
                                "acid": "T"
                            },
                            {
                                "position": "48",
                                "acid": "L"
                            },
                            {
                                "position": "49",
                                "acid": "R"
                            },
                            {
                                "position": "50",
                                "acid": "V"
                            },
                            {
                                "position": "51",
                                "acid": "S"
                            },
                            {
                                "position": "52",
                                "acid": "A"
                            },
                            {
                                "position": "53",
                                "acid": "K"
                            },
                            {
                                "position": "54",
                                "acid": "G"
                            },
                            {
                                "position": "55",
                                "acid": "M"
                            },
                            {
                                "position": "56",
                                "acid": "R"
                            },
                            {
                                "position": "57",
                                "acid": "I"
                            },
                            {
                                "position": "58",
                                "acid": "I"
                            },
                            {
                                "position": "59",
                                "acid": "D"
                            },
                            {
                                "position": "60",
                                "acid": "K"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "G"
                            },
                            {
                                "position": "63",
                                "acid": "I"
                            },
                            {
                                "position": "64",
                                "acid": "E"
                            },
                            {
                                "position": "65",
                                "acid": "T"
                            },
                            {
                                "position": "66",
                                "acid": "V"
                            },
                            {
                                "position": "67",
                                "acid": "L"
                            },
                            {
                                "position": "68",
                                "acid": "S"
                            },
                            {
                                "position": "69",
                                "acid": "E"
                            },
                            {
                                "position": "70",
                                "acid": "L"
                            },
                            {
                                "position": "71",
                                "acid": "R"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "R"
                            },
                            {
                                "position": "74",
                                "acid": "G"
                            },
                            {
                                "position": "75",
                                "acid": "E"
                            },
                            {
                                "position": "76",
                                "acid": "K"
                            },
                            {
                                "position": "77",
                                "acid": "Y"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "5",
                                        "ion_display_position": "5",
                                        "spec_id": "428",
                                        "peak_id": "32",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "6",
                                        "ion_display_position": "71",
                                        "spec_id": "428",
                                        "peak_id": "0",
                                        "peak_charge": "13"
                                    }
                                }
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "40",
                                        "ion_display_position": "40",
                                        "spec_id": "428",
                                        "peak_id": "34",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "59",
                                            "ion_display_position": "18",
                                            "spec_id": "428",
                                            "peak_id": "12",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "59",
                                            "ion_display_position": "59",
                                            "spec_id": "428",
                                            "peak_id": "13",
                                            "peak_charge": "11"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "60",
                                        "ion_display_position": "17",
                                        "spec_id": "428",
                                        "peak_id": "29",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "63",
                                        "ion_display_position": "14",
                                        "spec_id": "428",
                                        "peak_id": "9",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "64",
                                        "ion_display_position": "13",
                                        "spec_id": "428",
                                        "peak_id": "24",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "65",
                                        "ion_display_position": "12",
                                        "spec_id": "428",
                                        "peak_id": "50",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "67",
                                            "ion_display_position": "10",
                                            "spec_id": "428",
                                            "peak_id": "37",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "67",
                                            "ion_display_position": "67",
                                            "spec_id": "428",
                                            "peak_id": "20",
                                            "peak_charge": "11"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "68",
                                        "ion_display_position": "68",
                                        "spec_id": "428",
                                        "peak_id": "38",
                                        "peak_charge": "11"
                                    }
                                }
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "69",
                                            "ion_display_position": "8",
                                            "spec_id": "428",
                                            "peak_id": "28",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "69",
                                            "ion_display_position": "8",
                                            "spec_id": "428",
                                            "peak_id": "19",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": {
                                "left_pos": "4",
                                "right_pos": "5",
                                "anno": "C"
                            }
                        }
                    }
                }
            },
            {
                "prsm_id": "39",
                "p_value": "1.16e-04",
                "e_value": "5.82e-07",
                "fdr": "0",
                "matched_fragment_number": "8",
                "matched_peak_number": "11",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_2/st_1_ms2.msalign",
                        "ms1_ids": "432",
                        "ms1_scans": "849",
                        "ids": "416",
                        "scans": "850",
                        "precursor_mono_mass": "8970.8235",
                        "precursor_charge": "17",
                        "precursor_mz": "528.7028",
                        "feature_inte": "1.2543e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "416",
                                "peak_id": "0",
                                "monoisotopic_mass": "8451.5497",
                                "monoisotopic_mz": "564.4439",
                                "intensity": "45117.66",
                                "charge": "15"
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "1",
                                "monoisotopic_mass": "8340.4999",
                                "monoisotopic_mz": "557.0406",
                                "intensity": "62206.12",
                                "charge": "15"
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "2",
                                "monoisotopic_mass": "7551.0308",
                                "monoisotopic_mz": "581.8558",
                                "intensity": "256522.60",
                                "charge": "13",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7551.0974",
                                        "ion_position": "65",
                                        "ion_display_position": "65",
                                        "ion_sort_name": "B00065",
                                        "ion_left_position": "65",
                                        "mass_error": "-0.0666",
                                        "ppm": "-8.83"
                                    }
                                }
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "3",
                                "monoisotopic_mass": "8223.4286",
                                "monoisotopic_mz": "549.2358",
                                "intensity": "25257.20",
                                "charge": "15"
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "4",
                                "monoisotopic_mass": "7448.9575",
                                "monoisotopic_mz": "621.7537",
                                "intensity": "47865.83",
                                "charge": "12"
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "5",
                                "monoisotopic_mass": "8240.4456",
                                "monoisotopic_mz": "550.3703",
                                "intensity": "97643.32",
                                "charge": "15",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8241.5216",
                                        "ion_position": "6",
                                        "ion_display_position": "71",
                                        "ion_sort_name": "Y00071",
                                        "ion_left_position": "6",
                                        "mass_error": "-0.0737",
                                        "ppm": "-8.94"
                                    }
                                }
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "6",
                                "monoisotopic_mass": "7550.0471",
                                "monoisotopic_mz": "540.2964",
                                "intensity": "22065.67",
                                "charge": "14",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7551.0974",
                                        "ion_position": "65",
                                        "ion_display_position": "65",
                                        "ion_sort_name": "B00065",
                                        "ion_left_position": "65",
                                        "mass_error": "-0.0480",
                                        "ppm": "-6.35"
                                    }
                                }
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "7",
                                "monoisotopic_mass": "6821.6771",
                                "monoisotopic_mz": "621.1597",
                                "intensity": "64543.06",
                                "charge": "11"
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "8",
                                "monoisotopic_mass": "7533.0161",
                                "monoisotopic_mz": "580.4701",
                                "intensity": "104232.42",
                                "charge": "13"
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "9",
                                "monoisotopic_mass": "7505.0248",
                                "monoisotopic_mz": "578.3169",
                                "intensity": "37148.01",
                                "charge": "13"
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "10",
                                "monoisotopic_mass": "7621.1125",
                                "monoisotopic_mz": "545.3725",
                                "intensity": "53877.59",
                                "charge": "14"
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "11",
                                "monoisotopic_mass": "2179.7159",
                                "monoisotopic_mz": "199.1633",
                                "intensity": "22576.98",
                                "charge": "11"
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "12",
                                "monoisotopic_mass": "1320.7039",
                                "monoisotopic_mz": "441.2419",
                                "intensity": "410525.96",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1320.7150",
                                        "ion_position": "66",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "66",
                                        "mass_error": "-0.0111",
                                        "ppm": "-8.40"
                                    }
                                }
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "13",
                                "monoisotopic_mass": "8718.2365",
                                "monoisotopic_mz": "582.2230",
                                "intensity": "35623.96",
                                "charge": "15"
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "14",
                                "monoisotopic_mass": "6183.8629",
                                "monoisotopic_mz": "619.3936",
                                "intensity": "42222.84",
                                "charge": "10"
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "15",
                                "monoisotopic_mass": "6164.2944",
                                "monoisotopic_mz": "617.4367",
                                "intensity": "40126.42",
                                "charge": "10"
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "16",
                                "monoisotopic_mass": "1207.6212",
                                "monoisotopic_mz": "403.5477",
                                "intensity": "61424.68",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1207.6309",
                                        "ion_position": "67",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "67",
                                        "mass_error": "-0.0098",
                                        "ppm": "-8.08"
                                    }
                                }
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "17",
                                "monoisotopic_mass": "630.2849",
                                "monoisotopic_mz": "631.2922",
                                "intensity": "22177.00",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "630.2908",
                                        "ion_position": "5",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "B00005",
                                        "ion_left_position": "5",
                                        "mass_error": "-0.0059",
                                        "ppm": "-9.33"
                                    }
                                }
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "18",
                                "monoisotopic_mass": "1320.6998",
                                "monoisotopic_mz": "661.3572",
                                "intensity": "22167.43",
                                "charge": "2"
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "19",
                                "monoisotopic_mass": "991.5481",
                                "monoisotopic_mz": "331.5233",
                                "intensity": "49165.86",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "991.5563",
                                        "ion_position": "69",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "69",
                                        "mass_error": "-0.0082",
                                        "ppm": "-8.26"
                                    }
                                }
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "20",
                                "monoisotopic_mass": "5639.5582",
                                "monoisotopic_mz": "627.6249",
                                "intensity": "15849.07",
                                "charge": "9"
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "21",
                                "monoisotopic_mass": "6774.6465",
                                "monoisotopic_mz": "616.8842",
                                "intensity": "29135.52",
                                "charge": "11"
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "22",
                                "monoisotopic_mass": "6894.6308",
                                "monoisotopic_mz": "575.5598",
                                "intensity": "73734.36",
                                "charge": "12"
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "23",
                                "monoisotopic_mass": "1207.6205",
                                "monoisotopic_mz": "604.8175",
                                "intensity": "30578.52",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1207.6309",
                                        "ion_position": "67",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "67",
                                        "mass_error": "-0.0105",
                                        "ppm": "-8.67"
                                    }
                                }
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "24",
                                "monoisotopic_mass": "1419.7716",
                                "monoisotopic_mz": "474.2645",
                                "intensity": "11746.67",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1419.7834",
                                        "ion_position": "65",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "Y00012",
                                        "ion_left_position": "65",
                                        "mass_error": "-0.0118",
                                        "ppm": "-8.34"
                                    }
                                }
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "25",
                                "monoisotopic_mass": "991.5478",
                                "monoisotopic_mz": "496.7812",
                                "intensity": "10998.63",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "991.5563",
                                        "ion_position": "69",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "69",
                                        "mass_error": "-0.0086",
                                        "ppm": "-8.63"
                                    }
                                }
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "26",
                                "monoisotopic_mass": "1303.6770",
                                "monoisotopic_mz": "435.5663",
                                "intensity": "9204.15",
                                "charge": "3"
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "27",
                                "monoisotopic_mass": "3532.1168",
                                "monoisotopic_mz": "589.6934",
                                "intensity": "13256.10",
                                "charge": "6"
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "28",
                                "monoisotopic_mass": "1139.6291",
                                "monoisotopic_mz": "570.8218",
                                "intensity": "31704.24",
                                "charge": "2"
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "29",
                                "monoisotopic_mass": "7504.3292",
                                "monoisotopic_mz": "683.2190",
                                "intensity": "16914.33",
                                "charge": "11"
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "30",
                                "monoisotopic_mass": "4707.4285",
                                "monoisotopic_mz": "673.4971",
                                "intensity": "16771.06",
                                "charge": "7"
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "31",
                                "monoisotopic_mass": "2576.0918",
                                "monoisotopic_mz": "199.1682",
                                "intensity": "22918.45",
                                "charge": "13"
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "32",
                                "monoisotopic_mass": "4438.8734",
                                "monoisotopic_mz": "555.8665",
                                "intensity": "13169.13",
                                "charge": "8"
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "33",
                                "monoisotopic_mass": "1348.4966",
                                "monoisotopic_mz": "675.2556",
                                "intensity": "8630.00",
                                "charge": "2"
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "34",
                                "monoisotopic_mass": "6895.6216",
                                "monoisotopic_mz": "627.8820",
                                "intensity": "22524.15",
                                "charge": "11"
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "35",
                                "monoisotopic_mass": "6720.6219",
                                "monoisotopic_mz": "611.9729",
                                "intensity": "13240.92",
                                "charge": "11"
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "36",
                                "monoisotopic_mass": "2910.2260",
                                "monoisotopic_mz": "583.0525",
                                "intensity": "16534.90",
                                "charge": "5"
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "37",
                                "monoisotopic_mass": "4794.4667",
                                "monoisotopic_mz": "600.3156",
                                "intensity": "18483.96",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4794.5127",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "-0.0460",
                                        "ppm": "-9.60"
                                    }
                                }
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "38",
                                "monoisotopic_mass": "8093.5252",
                                "monoisotopic_mz": "579.1162",
                                "intensity": "25718.43",
                                "charge": "14"
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "39",
                                "monoisotopic_mass": "7450.9753",
                                "monoisotopic_mz": "574.1592",
                                "intensity": "13278.85",
                                "charge": "13"
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "40",
                                "monoisotopic_mass": "1254.4910",
                                "monoisotopic_mz": "628.2528",
                                "intensity": "5668.99",
                                "charge": "2"
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "41",
                                "monoisotopic_mass": "1157.6435",
                                "monoisotopic_mz": "579.8290",
                                "intensity": "29782.75",
                                "charge": "2"
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "42",
                                "monoisotopic_mass": "990.7080",
                                "monoisotopic_mz": "199.1489",
                                "intensity": "10151.74",
                                "charge": "5"
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "43",
                                "monoisotopic_mass": "4009.5980",
                                "monoisotopic_mz": "573.8070",
                                "intensity": "13877.69",
                                "charge": "7"
                            },
                            {
                                "spec_id": "416",
                                "peak_id": "44",
                                "monoisotopic_mass": "617.7890",
                                "monoisotopic_mz": "618.7963",
                                "intensity": "6636.15",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "10",
                    "proteoform_id": "10",
                    "sequence_name": "sp|P0A2A5|RL28_SALTY",
                    "sequence_description": "50S ribosomal protein L28 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmB PE=3 SV=2",
                    "proteoform_mass": "8970.8808",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "78",
                        "first_residue_position": "1",
                        "last_residue_position": "77",
                        "annotated_seq": "M.SRV(C)[Carbamidomethylation]QVTGKRPVTGNNRSHALNATKRRFLPNLHSHRFWVESEKRFVTLRVSAKGMRIIDKKGIETVLSELRARGEKY.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "R"
                            },
                            {
                                "position": "3",
                                "acid": "V"
                            },
                            {
                                "position": "4",
                                "acid": "C"
                            },
                            {
                                "position": "5",
                                "acid": "Q"
                            },
                            {
                                "position": "6",
                                "acid": "V"
                            },
                            {
                                "position": "7",
                                "acid": "T"
                            },
                            {
                                "position": "8",
                                "acid": "G"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "R"
                            },
                            {
                                "position": "11",
                                "acid": "P"
                            },
                            {
                                "position": "12",
                                "acid": "V"
                            },
                            {
                                "position": "13",
                                "acid": "T"
                            },
                            {
                                "position": "14",
                                "acid": "G"
                            },
                            {
                                "position": "15",
                                "acid": "N"
                            },
                            {
                                "position": "16",
                                "acid": "N"
                            },
                            {
                                "position": "17",
                                "acid": "R"
                            },
                            {
                                "position": "18",
                                "acid": "S"
                            },
                            {
                                "position": "19",
                                "acid": "H"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "L"
                            },
                            {
                                "position": "22",
                                "acid": "N"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "K"
                            },
                            {
                                "position": "26",
                                "acid": "R"
                            },
                            {
                                "position": "27",
                                "acid": "R"
                            },
                            {
                                "position": "28",
                                "acid": "F"
                            },
                            {
                                "position": "29",
                                "acid": "L"
                            },
                            {
                                "position": "30",
                                "acid": "P"
                            },
                            {
                                "position": "31",
                                "acid": "N"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "H"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "H"
                            },
                            {
                                "position": "36",
                                "acid": "R"
                            },
                            {
                                "position": "37",
                                "acid": "F"
                            },
                            {
                                "position": "38",
                                "acid": "W"
                            },
                            {
                                "position": "39",
                                "acid": "V"
                            },
                            {
                                "position": "40",
                                "acid": "E"
                            },
                            {
                                "position": "41",
                                "acid": "S"
                            },
                            {
                                "position": "42",
                                "acid": "E"
                            },
                            {
                                "position": "43",
                                "acid": "K"
                            },
                            {
                                "position": "44",
                                "acid": "R"
                            },
                            {
                                "position": "45",
                                "acid": "F"
                            },
                            {
                                "position": "46",
                                "acid": "V"
                            },
                            {
                                "position": "47",
                                "acid": "T"
                            },
                            {
                                "position": "48",
                                "acid": "L"
                            },
                            {
                                "position": "49",
                                "acid": "R"
                            },
                            {
                                "position": "50",
                                "acid": "V"
                            },
                            {
                                "position": "51",
                                "acid": "S"
                            },
                            {
                                "position": "52",
                                "acid": "A"
                            },
                            {
                                "position": "53",
                                "acid": "K"
                            },
                            {
                                "position": "54",
                                "acid": "G"
                            },
                            {
                                "position": "55",
                                "acid": "M"
                            },
                            {
                                "position": "56",
                                "acid": "R"
                            },
                            {
                                "position": "57",
                                "acid": "I"
                            },
                            {
                                "position": "58",
                                "acid": "I"
                            },
                            {
                                "position": "59",
                                "acid": "D"
                            },
                            {
                                "position": "60",
                                "acid": "K"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "G"
                            },
                            {
                                "position": "63",
                                "acid": "I"
                            },
                            {
                                "position": "64",
                                "acid": "E"
                            },
                            {
                                "position": "65",
                                "acid": "T"
                            },
                            {
                                "position": "66",
                                "acid": "V"
                            },
                            {
                                "position": "67",
                                "acid": "L"
                            },
                            {
                                "position": "68",
                                "acid": "S"
                            },
                            {
                                "position": "69",
                                "acid": "E"
                            },
                            {
                                "position": "70",
                                "acid": "L"
                            },
                            {
                                "position": "71",
                                "acid": "R"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "R"
                            },
                            {
                                "position": "74",
                                "acid": "G"
                            },
                            {
                                "position": "75",
                                "acid": "E"
                            },
                            {
                                "position": "76",
                                "acid": "K"
                            },
                            {
                                "position": "77",
                                "acid": "Y"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "5",
                                        "ion_display_position": "5",
                                        "spec_id": "416",
                                        "peak_id": "17",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "6",
                                        "ion_display_position": "71",
                                        "spec_id": "416",
                                        "peak_id": "5",
                                        "peak_charge": "15"
                                    }
                                }
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "spec_id": "416",
                                        "peak_id": "37",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "65",
                                            "ion_display_position": "12",
                                            "spec_id": "416",
                                            "peak_id": "24",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "65",
                                            "ion_display_position": "65",
                                            "spec_id": "416",
                                            "peak_id": "2",
                                            "peak_charge": "13"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "65",
                                            "ion_display_position": "65",
                                            "spec_id": "416",
                                            "peak_id": "6",
                                            "peak_charge": "14"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "66",
                                        "ion_display_position": "11",
                                        "spec_id": "416",
                                        "peak_id": "12",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "67",
                                            "ion_display_position": "10",
                                            "spec_id": "416",
                                            "peak_id": "23",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "67",
                                            "ion_display_position": "10",
                                            "spec_id": "416",
                                            "peak_id": "16",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "69",
                                            "ion_display_position": "8",
                                            "spec_id": "416",
                                            "peak_id": "25",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "69",
                                            "ion_display_position": "8",
                                            "spec_id": "416",
                                            "peak_id": "19",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": {
                                "left_pos": "4",
                                "right_pos": "5",
                                "anno": "C"
                            }
                        }
                    }
                }
            }
        ]
    }
}
