prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "3",
        "sequence_name": "sp|P0A7Q8|RL36_SALTY",
        "sequence_description": "50S ribosomal protein L36 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmJ PE=3 SV=1",
        "proteoform_id": "4",
        "prsm_number": "3",
        "prsm": [
            {
                "prsm_id": "0",
                "p_value": "4.01e-14",
                "e_value": "4.01e-14",
                "fdr": "0",
                "matched_fragment_number": "17",
                "matched_peak_number": "19",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                        "ms1_ids": "172",
                        "ms1_scans": "330",
                        "ids": "157",
                        "scans": "331",
                        "precursor_mono_mass": "4532.4737",
                        "precursor_charge": "8",
                        "precursor_mz": "567.5665",
                        "feature_inte": "9.8091e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "157",
                                "peak_id": "0",
                                "monoisotopic_mass": "4256.3156",
                                "monoisotopic_mz": "609.0524",
                                "intensity": "160487.24",
                                "charge": "7"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "1",
                                "monoisotopic_mass": "4401.4327",
                                "monoisotopic_mz": "629.7834",
                                "intensity": "2300854.92",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4401.4736",
                                        "ion_position": "1",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "Y00037",
                                        "ion_left_position": "1",
                                        "mass_error": "-0.0410",
                                        "ppm": "-9.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "2",
                                "monoisotopic_mass": "4273.3379",
                                "monoisotopic_mz": "611.4841",
                                "intensity": "1896920.75",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4273.3787",
                                        "ion_position": "2",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "Y00036",
                                        "ion_left_position": "2",
                                        "mass_error": "-0.0408",
                                        "ppm": "-9.55"
                                    }
                                }
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "3",
                                "monoisotopic_mass": "3554.9265",
                                "monoisotopic_mz": "711.9926",
                                "intensity": "804916.06",
                                "charge": "5"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "4",
                                "monoisotopic_mass": "3632.9370",
                                "monoisotopic_mz": "727.5947",
                                "intensity": "395123.16",
                                "charge": "5"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "5",
                                "monoisotopic_mass": "3424.8895",
                                "monoisotopic_mz": "857.2296",
                                "intensity": "598546.66",
                                "charge": "4"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "6",
                                "monoisotopic_mass": "3406.8587",
                                "monoisotopic_mz": "852.7220",
                                "intensity": "190415.85",
                                "charge": "4"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "7",
                                "monoisotopic_mass": "3336.8385",
                                "monoisotopic_mz": "668.3750",
                                "intensity": "400238.47",
                                "charge": "5"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "8",
                                "monoisotopic_mass": "3768.0836",
                                "monoisotopic_mz": "629.0212",
                                "intensity": "199624.49",
                                "charge": "6"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "9",
                                "monoisotopic_mass": "752.3976",
                                "monoisotopic_mz": "753.4048",
                                "intensity": "470945.40",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "752.4042",
                                        "ion_position": "32",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "32",
                                        "mass_error": "-0.0066",
                                        "ppm": "-8.77"
                                    }
                                }
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "10",
                                "monoisotopic_mass": "2527.3007",
                                "monoisotopic_mz": "843.4408",
                                "intensity": "191060.24",
                                "charge": "3"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "11",
                                "monoisotopic_mass": "2062.1037",
                                "monoisotopic_mz": "688.3752",
                                "intensity": "165668.93",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2062.1218",
                                        "ion_position": "20",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "Y00018",
                                        "ion_left_position": "20",
                                        "mass_error": "-0.0181",
                                        "ppm": "-8.78"
                                    }
                                }
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "12",
                                "monoisotopic_mass": "3354.8484",
                                "monoisotopic_mz": "671.9770",
                                "intensity": "576322.99",
                                "charge": "5"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "13",
                                "monoisotopic_mass": "4384.4082",
                                "monoisotopic_mz": "627.3513",
                                "intensity": "726018.17",
                                "charge": "7"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "14",
                                "monoisotopic_mass": "3308.8454",
                                "monoisotopic_mz": "662.7764",
                                "intensity": "143721.69",
                                "charge": "5"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "15",
                                "monoisotopic_mass": "3267.8215",
                                "monoisotopic_mz": "654.5716",
                                "intensity": "208679.81",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3267.8505",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "B00027",
                                        "ion_left_position": "27",
                                        "mass_error": "-0.0290",
                                        "ppm": "-8.87"
                                    }
                                }
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "16",
                                "monoisotopic_mass": "3504.8487",
                                "monoisotopic_mz": "701.9770",
                                "intensity": "551135.60",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3504.8817",
                                        "ion_position": "9",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "Y00029",
                                        "ion_left_position": "9",
                                        "mass_error": "-0.0330",
                                        "ppm": "-9.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "17",
                                "monoisotopic_mass": "2655.4022",
                                "monoisotopic_mz": "886.1413",
                                "intensity": "186445.73",
                                "charge": "3"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "18",
                                "monoisotopic_mass": "615.3404",
                                "monoisotopic_mz": "616.3477",
                                "intensity": "565026.75",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "615.3453",
                                        "ion_position": "33",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "Y00005",
                                        "ion_left_position": "33",
                                        "mass_error": "-0.0049",
                                        "ppm": "-7.93"
                                    }
                                }
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "19",
                                "monoisotopic_mass": "3632.9408",
                                "monoisotopic_mz": "606.4974",
                                "intensity": "277590.87",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3632.9766",
                                        "ion_position": "8",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "Y00030",
                                        "ion_left_position": "8",
                                        "mass_error": "-0.0358",
                                        "ppm": "-9.86"
                                    }
                                }
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "20",
                                "monoisotopic_mass": "3407.8702",
                                "monoisotopic_mz": "682.5813",
                                "intensity": "265068.76",
                                "charge": "5"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "21",
                                "monoisotopic_mass": "3295.7860",
                                "monoisotopic_mz": "660.1645",
                                "intensity": "168313.50",
                                "charge": "5"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "22",
                                "monoisotopic_mass": "1859.0035",
                                "monoisotopic_mz": "620.6751",
                                "intensity": "103523.43",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1859.0168",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "B00015",
                                        "ion_left_position": "15",
                                        "mass_error": "-0.0133",
                                        "ppm": "-7.17"
                                    }
                                }
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "23",
                                "monoisotopic_mass": "3425.8869",
                                "monoisotopic_mz": "686.1847",
                                "intensity": "933166.19",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3425.9196",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "-0.0327",
                                        "ppm": "-9.56"
                                    }
                                }
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "24",
                                "monoisotopic_mass": "3354.8516",
                                "monoisotopic_mz": "839.7202",
                                "intensity": "172995.38",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3354.8825",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0310",
                                        "ppm": "-9.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "25",
                                "monoisotopic_mass": "771.4331",
                                "monoisotopic_mz": "772.4404",
                                "intensity": "51889.22",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "771.4425",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "B00007",
                                        "ion_left_position": "7",
                                        "mass_error": "-0.0094",
                                        "ppm": "-12.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "26",
                                "monoisotopic_mass": "977.5431",
                                "monoisotopic_mz": "489.7788",
                                "intensity": "1426250.04",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "977.5519",
                                        "ion_position": "30",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0088",
                                        "ppm": "-8.97"
                                    }
                                }
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "27",
                                "monoisotopic_mass": "4046.2348",
                                "monoisotopic_mz": "579.0408",
                                "intensity": "61404.92",
                                "charge": "7"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "28",
                                "monoisotopic_mass": "3166.7651",
                                "monoisotopic_mz": "792.6986",
                                "intensity": "160582.07",
                                "charge": "4"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "29",
                                "monoisotopic_mass": "2673.4729",
                                "monoisotopic_mz": "669.3755",
                                "intensity": "272942.90",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2673.4973",
                                        "ion_position": "15",
                                        "ion_display_position": "23",
                                        "ion_sort_name": "Y00023",
                                        "ion_left_position": "15",
                                        "mass_error": "-0.0244",
                                        "ppm": "-9.13"
                                    }
                                }
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "30",
                                "monoisotopic_mass": "3336.8389",
                                "monoisotopic_mz": "835.2170",
                                "intensity": "180999.44",
                                "charge": "4"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "31",
                                "monoisotopic_mass": "752.3977",
                                "monoisotopic_mz": "377.2061",
                                "intensity": "603323.47",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "752.4042",
                                        "ion_position": "32",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "32",
                                        "mass_error": "-0.0064",
                                        "ppm": "-8.55"
                                    }
                                }
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "32",
                                "monoisotopic_mass": "3295.7849",
                                "monoisotopic_mz": "824.9535",
                                "intensity": "245196.09",
                                "charge": "4"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "33",
                                "monoisotopic_mass": "487.2461",
                                "monoisotopic_mz": "488.2534",
                                "intensity": "416110.11",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "487.2503",
                                        "ion_position": "34",
                                        "ion_display_position": "4",
                                        "ion_sort_name": "Y00004",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0042",
                                        "ppm": "-8.59"
                                    }
                                }
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "34",
                                "monoisotopic_mass": "3487.8283",
                                "monoisotopic_mz": "698.5729",
                                "intensity": "61299.18",
                                "charge": "5"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "35",
                                "monoisotopic_mass": "3177.8104",
                                "monoisotopic_mz": "636.5694",
                                "intensity": "105156.10",
                                "charge": "5"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "36",
                                "monoisotopic_mass": "977.5435",
                                "monoisotopic_mz": "326.8551",
                                "intensity": "109213.96",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "977.5519",
                                        "ion_position": "30",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0084",
                                        "ppm": "-8.61"
                                    }
                                }
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "37",
                                "monoisotopic_mass": "3554.9298",
                                "monoisotopic_mz": "889.7397",
                                "intensity": "121031.33",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3554.9622",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0324",
                                        "ppm": "-9.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "38",
                                "monoisotopic_mass": "768.4892",
                                "monoisotopic_mz": "385.2519",
                                "intensity": "51742.00",
                                "charge": "2"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "39",
                                "monoisotopic_mass": "2560.3896",
                                "monoisotopic_mz": "641.1047",
                                "intensity": "193287.06",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2560.4132",
                                        "ion_position": "16",
                                        "ion_display_position": "22",
                                        "ion_sort_name": "Y00022",
                                        "ion_left_position": "16",
                                        "mass_error": "-0.0236",
                                        "ppm": "-9.22"
                                    }
                                }
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "40",
                                "monoisotopic_mass": "1582.8482",
                                "monoisotopic_mz": "792.4314",
                                "intensity": "61814.31",
                                "charge": "2"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "41",
                                "monoisotopic_mass": "3899.1348",
                                "monoisotopic_mz": "650.8631",
                                "intensity": "129476.23",
                                "charge": "6"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "42",
                                "monoisotopic_mass": "4367.3773",
                                "monoisotopic_mz": "624.9183",
                                "intensity": "129839.19",
                                "charge": "7"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "43",
                                "monoisotopic_mass": "1234.6891",
                                "monoisotopic_mz": "618.3518",
                                "intensity": "25187.76",
                                "charge": "2"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "44",
                                "monoisotopic_mass": "2999.5765",
                                "monoisotopic_mz": "750.9014",
                                "intensity": "64375.92",
                                "charge": "4"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "45",
                                "monoisotopic_mass": "2176.1302",
                                "monoisotopic_mz": "726.3840",
                                "intensity": "103218.76",
                                "charge": "3"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "46",
                                "monoisotopic_mass": "1264.6439",
                                "monoisotopic_mz": "633.3292",
                                "intensity": "33129.61",
                                "charge": "2"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "47",
                                "monoisotopic_mass": "3614.9016",
                                "monoisotopic_mz": "603.4909",
                                "intensity": "72985.94",
                                "charge": "6"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "48",
                                "monoisotopic_mass": "848.4657",
                                "monoisotopic_mz": "849.4730",
                                "intensity": "64127.02",
                                "charge": "1"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "49",
                                "monoisotopic_mass": "640.3962",
                                "monoisotopic_mz": "641.4034",
                                "intensity": "128542.67",
                                "charge": "1"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "50",
                                "monoisotopic_mass": "3245.8353",
                                "monoisotopic_mz": "650.1743",
                                "intensity": "81539.31",
                                "charge": "5"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "51",
                                "monoisotopic_mass": "1213.6657",
                                "monoisotopic_mz": "607.8401",
                                "intensity": "62627.99",
                                "charge": "2"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "52",
                                "monoisotopic_mass": "1386.7575",
                                "monoisotopic_mz": "199.1155",
                                "intensity": "32138.72",
                                "charge": "7"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "53",
                                "monoisotopic_mass": "685.1734",
                                "monoisotopic_mz": "686.1807",
                                "intensity": "95396.12",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "3",
                    "proteoform_id": "4",
                    "sequence_name": "sp|P0A7Q8|RL36_SALTY",
                    "sequence_description": "50S ribosomal protein L36 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmJ PE=3 SV=1",
                    "proteoform_mass": "4532.5141",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "38",
                        "first_residue_position": "0",
                        "last_residue_position": "37",
                        "annotated_seq": ".MKVRASVKKL(C)[Carbamidomethylation]RN(C)[Carbamidomethylation]KIVKRDGVIRVI(C)[Carbamidomethylation]SAEPKHKQRQG.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "K"
                            },
                            {
                                "position": "2",
                                "acid": "V"
                            },
                            {
                                "position": "3",
                                "acid": "R"
                            },
                            {
                                "position": "4",
                                "acid": "A"
                            },
                            {
                                "position": "5",
                                "acid": "S"
                            },
                            {
                                "position": "6",
                                "acid": "V"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "L"
                            },
                            {
                                "position": "10",
                                "acid": "C"
                            },
                            {
                                "position": "11",
                                "acid": "R"
                            },
                            {
                                "position": "12",
                                "acid": "N"
                            },
                            {
                                "position": "13",
                                "acid": "C"
                            },
                            {
                                "position": "14",
                                "acid": "K"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "V"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "R"
                            },
                            {
                                "position": "19",
                                "acid": "D"
                            },
                            {
                                "position": "20",
                                "acid": "G"
                            },
                            {
                                "position": "21",
                                "acid": "V"
                            },
                            {
                                "position": "22",
                                "acid": "I"
                            },
                            {
                                "position": "23",
                                "acid": "R"
                            },
                            {
                                "position": "24",
                                "acid": "V"
                            },
                            {
                                "position": "25",
                                "acid": "I"
                            },
                            {
                                "position": "26",
                                "acid": "C"
                            },
                            {
                                "position": "27",
                                "acid": "S"
                            },
                            {
                                "position": "28",
                                "acid": "A"
                            },
                            {
                                "position": "29",
                                "acid": "E"
                            },
                            {
                                "position": "30",
                                "acid": "P"
                            },
                            {
                                "position": "31",
                                "acid": "K"
                            },
                            {
                                "position": "32",
                                "acid": "H"
                            },
                            {
                                "position": "33",
                                "acid": "K"
                            },
                            {
                                "position": "34",
                                "acid": "Q"
                            },
                            {
                                "position": "35",
                                "acid": "R"
                            },
                            {
                                "position": "36",
                                "acid": "Q"
                            },
                            {
                                "position": "37",
                                "acid": "G"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "1",
                                        "ion_display_position": "37",
                                        "spec_id": "157",
                                        "peak_id": "1",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "2",
                                        "ion_display_position": "36",
                                        "spec_id": "157",
                                        "peak_id": "2",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "spec_id": "157",
                                        "peak_id": "25",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "8",
                                        "ion_display_position": "30",
                                        "spec_id": "157",
                                        "peak_id": "19",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "9",
                                        "ion_display_position": "29",
                                        "spec_id": "157",
                                        "peak_id": "16",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "15",
                                            "ion_display_position": "15",
                                            "spec_id": "157",
                                            "peak_id": "22",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "15",
                                            "ion_display_position": "23",
                                            "spec_id": "157",
                                            "peak_id": "29",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "16",
                                        "ion_display_position": "22",
                                        "spec_id": "157",
                                        "peak_id": "39",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "20",
                                        "ion_display_position": "18",
                                        "spec_id": "157",
                                        "peak_id": "11",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "spec_id": "157",
                                        "peak_id": "15",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "157",
                                        "peak_id": "24",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "spec_id": "157",
                                        "peak_id": "23",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "30",
                                            "ion_display_position": "8",
                                            "spec_id": "157",
                                            "peak_id": "26",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "30",
                                            "ion_display_position": "8",
                                            "spec_id": "157",
                                            "peak_id": "36",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "30",
                                            "ion_display_position": "30",
                                            "spec_id": "157",
                                            "peak_id": "37",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "32",
                                            "ion_display_position": "6",
                                            "spec_id": "157",
                                            "peak_id": "9",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "32",
                                            "ion_display_position": "6",
                                            "spec_id": "157",
                                            "peak_id": "31",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "33",
                                        "ion_display_position": "5",
                                        "spec_id": "157",
                                        "peak_id": "18",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "34",
                                        "ion_display_position": "4",
                                        "spec_id": "157",
                                        "peak_id": "33",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": [
                                {
                                    "left_pos": "10",
                                    "right_pos": "11",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "13",
                                    "right_pos": "14",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "26",
                                    "right_pos": "27",
                                    "anno": "C"
                                }
                            ]
                        }
                    }
                }
            },
            {
                "prsm_id": "2",
                "p_value": "1.61e-11",
                "e_value": "1.61e-11",
                "fdr": "0",
                "matched_fragment_number": "13",
                "matched_peak_number": "17",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                        "ms1_ids": "175",
                        "ms1_scans": "336",
                        "ids": "160",
                        "scans": "337",
                        "precursor_mono_mass": "4532.4737",
                        "precursor_charge": "8",
                        "precursor_mz": "567.5665",
                        "feature_inte": "9.8091e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "160",
                                "peak_id": "0",
                                "monoisotopic_mass": "3354.8524",
                                "monoisotopic_mz": "839.7204",
                                "intensity": "366356.03",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-3.0464431981e-02",
                                        "theoretical_mass": "3354.8521",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "0.0003",
                                        "ppm": "0.10"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "1",
                                "monoisotopic_mass": "4384.4031",
                                "monoisotopic_mz": "627.3506",
                                "intensity": "1058548.32",
                                "charge": "7"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "2",
                                "monoisotopic_mass": "3555.9315",
                                "monoisotopic_mz": "889.9901",
                                "intensity": "251659.20",
                                "charge": "4"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "3",
                                "monoisotopic_mass": "4401.4301",
                                "monoisotopic_mz": "629.7830",
                                "intensity": "4198343.15",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-3.0464431981e-02",
                                        "theoretical_mass": "4401.4432",
                                        "ion_position": "1",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "Y00037",
                                        "ion_left_position": "1",
                                        "mass_error": "-0.0131",
                                        "ppm": "-2.97"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "4",
                                "monoisotopic_mass": "3554.9247",
                                "monoisotopic_mz": "711.9922",
                                "intensity": "1251123.77",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-3.0464431981e-02",
                                        "theoretical_mass": "3554.9318",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0071",
                                        "ppm": "-2.00"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "5",
                                "monoisotopic_mass": "3336.8363",
                                "monoisotopic_mz": "835.2163",
                                "intensity": "359299.85",
                                "charge": "4"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "6",
                                "monoisotopic_mass": "3632.9445",
                                "monoisotopic_mz": "606.4980",
                                "intensity": "380658.61",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-3.0464431981e-02",
                                        "theoretical_mass": "3632.9462",
                                        "ion_position": "8",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "Y00030",
                                        "ion_left_position": "8",
                                        "mass_error": "-0.0017",
                                        "ppm": "-0.46"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "7",
                                "monoisotopic_mass": "2062.1011",
                                "monoisotopic_mz": "688.3743",
                                "intensity": "195996.50",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-3.0464431981e-02",
                                        "theoretical_mass": "2062.0913",
                                        "ion_position": "20",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "Y00018",
                                        "ion_left_position": "20",
                                        "mass_error": "0.0098",
                                        "ppm": "4.74"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "8",
                                "monoisotopic_mass": "3424.8900",
                                "monoisotopic_mz": "857.2298",
                                "intensity": "823405.30",
                                "charge": "4"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "9",
                                "monoisotopic_mass": "3267.8218",
                                "monoisotopic_mz": "654.5716",
                                "intensity": "308943.44",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-3.0464431981e-02",
                                        "theoretical_mass": "3267.8200",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "B00027",
                                        "ion_left_position": "27",
                                        "mass_error": "0.0018",
                                        "ppm": "0.55"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "10",
                                "monoisotopic_mass": "3632.9355",
                                "monoisotopic_mz": "727.5944",
                                "intensity": "498561.40",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-3.0464431981e-02",
                                        "theoretical_mass": "3632.9462",
                                        "ion_position": "8",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "Y00030",
                                        "ion_left_position": "8",
                                        "mass_error": "-0.0106",
                                        "ppm": "-2.93"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "11",
                                "monoisotopic_mass": "4273.3374",
                                "monoisotopic_mz": "611.4841",
                                "intensity": "3113557.67",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-3.0464431981e-02",
                                        "theoretical_mass": "4273.3482",
                                        "ion_position": "2",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "Y00036",
                                        "ion_left_position": "2",
                                        "mass_error": "-0.0108",
                                        "ppm": "-2.52"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "12",
                                "monoisotopic_mass": "3354.8487",
                                "monoisotopic_mz": "671.9770",
                                "intensity": "933423.52",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-3.0464431981e-02",
                                        "theoretical_mass": "3354.8521",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0034",
                                        "ppm": "-1.00"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "13",
                                "monoisotopic_mass": "2177.1203",
                                "monoisotopic_mz": "726.7140",
                                "intensity": "101843.52",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-3.0464431981e-02",
                                        "theoretical_mass": "2177.1183",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "Y00019",
                                        "ion_left_position": "19",
                                        "mass_error": "0.0020",
                                        "ppm": "0.92"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "14",
                                "monoisotopic_mass": "752.3971",
                                "monoisotopic_mz": "753.4044",
                                "intensity": "577405.52",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "752.4042",
                                        "ion_position": "32",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "32",
                                        "mass_error": "-0.0071",
                                        "ppm": "-9.42"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "15",
                                "monoisotopic_mass": "1858.9953",
                                "monoisotopic_mz": "620.6724",
                                "intensity": "185865.94",
                                "charge": "3"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "16",
                                "monoisotopic_mass": "3768.0748",
                                "monoisotopic_mz": "629.0197",
                                "intensity": "195378.50",
                                "charge": "6"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "17",
                                "monoisotopic_mass": "615.3400",
                                "monoisotopic_mz": "616.3473",
                                "intensity": "766599.25",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "615.3453",
                                        "ion_position": "33",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "Y00005",
                                        "ion_left_position": "33",
                                        "mass_error": "-0.0052",
                                        "ppm": "-8.53"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "18",
                                "monoisotopic_mass": "3336.8418",
                                "monoisotopic_mz": "668.3756",
                                "intensity": "541735.35",
                                "charge": "5"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "19",
                                "monoisotopic_mass": "1194.1198",
                                "monoisotopic_mz": "299.5372",
                                "intensity": "55925.82",
                                "charge": "4"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "20",
                                "monoisotopic_mass": "4256.3087",
                                "monoisotopic_mz": "609.0514",
                                "intensity": "335465.52",
                                "charge": "7"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "21",
                                "monoisotopic_mass": "1354.7359",
                                "monoisotopic_mz": "339.6913",
                                "intensity": "56701.23",
                                "charge": "4"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "22",
                                "monoisotopic_mass": "3407.8687",
                                "monoisotopic_mz": "682.5810",
                                "intensity": "469567.71",
                                "charge": "5"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "23",
                                "monoisotopic_mass": "977.5428",
                                "monoisotopic_mz": "489.7787",
                                "intensity": "2160503.75",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "977.5519",
                                        "ion_position": "30",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0091",
                                        "ppm": "-9.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "24",
                                "monoisotopic_mass": "3425.8835",
                                "monoisotopic_mz": "686.1840",
                                "intensity": "1619530.26",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-3.0464431981e-02",
                                        "theoretical_mass": "3425.8892",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "-0.0056",
                                        "ppm": "-1.64"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "25",
                                "monoisotopic_mass": "2674.4675",
                                "monoisotopic_mz": "669.6242",
                                "intensity": "287416.18",
                                "charge": "4"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "26",
                                "monoisotopic_mass": "3166.7717",
                                "monoisotopic_mz": "792.7002",
                                "intensity": "178323.23",
                                "charge": "4"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "27",
                                "monoisotopic_mass": "752.3976",
                                "monoisotopic_mz": "377.2061",
                                "intensity": "903082.61",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "752.4042",
                                        "ion_position": "32",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "32",
                                        "mass_error": "-0.0066",
                                        "ppm": "-8.78"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "28",
                                "monoisotopic_mass": "977.5433",
                                "monoisotopic_mz": "326.8550",
                                "intensity": "173492.58",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "977.5519",
                                        "ion_position": "30",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0086",
                                        "ppm": "-8.79"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "29",
                                "monoisotopic_mass": "3296.7981",
                                "monoisotopic_mz": "660.3669",
                                "intensity": "209385.75",
                                "charge": "5"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "30",
                                "monoisotopic_mass": "1300.7052",
                                "monoisotopic_mz": "651.3599",
                                "intensity": "95668.09",
                                "charge": "2"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "31",
                                "monoisotopic_mass": "2560.3869",
                                "monoisotopic_mz": "641.1040",
                                "intensity": "326128.94",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-3.0464431981e-02",
                                        "theoretical_mass": "2560.3828",
                                        "ion_position": "16",
                                        "ion_display_position": "22",
                                        "ion_sort_name": "Y00022",
                                        "ion_left_position": "16",
                                        "mass_error": "0.0042",
                                        "ppm": "1.63"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "32",
                                "monoisotopic_mass": "3616.9264",
                                "monoisotopic_mz": "603.8283",
                                "intensity": "94151.58",
                                "charge": "6"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "33",
                                "monoisotopic_mass": "3503.8442",
                                "monoisotopic_mz": "701.7761",
                                "intensity": "765480.83",
                                "charge": "5"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "34",
                                "monoisotopic_mass": "629.6355",
                                "monoisotopic_mz": "630.6428",
                                "intensity": "262117.91",
                                "charge": "1"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "35",
                                "monoisotopic_mass": "3244.8203",
                                "monoisotopic_mz": "649.9713",
                                "intensity": "223384.58",
                                "charge": "5"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "36",
                                "monoisotopic_mass": "960.5369",
                                "monoisotopic_mz": "481.2757",
                                "intensity": "80175.81",
                                "charge": "2"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "37",
                                "monoisotopic_mass": "4366.3835",
                                "monoisotopic_mz": "624.7763",
                                "intensity": "136843.07",
                                "charge": "7"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "38",
                                "monoisotopic_mass": "3396.8884",
                                "monoisotopic_mz": "850.2294",
                                "intensity": "183219.77",
                                "charge": "4"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "39",
                                "monoisotopic_mass": "2672.4673",
                                "monoisotopic_mz": "535.5007",
                                "intensity": "149008.30",
                                "charge": "5"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "40",
                                "monoisotopic_mass": "3486.8322",
                                "monoisotopic_mz": "698.3737",
                                "intensity": "99723.02",
                                "charge": "5"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "41",
                                "monoisotopic_mass": "4017.1495",
                                "monoisotopic_mz": "670.5322",
                                "intensity": "89927.81",
                                "charge": "6"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "42",
                                "monoisotopic_mass": "2527.2945",
                                "monoisotopic_mz": "843.4388",
                                "intensity": "194027.67",
                                "charge": "3"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "43",
                                "monoisotopic_mass": "653.7655",
                                "monoisotopic_mz": "654.7728",
                                "intensity": "40268.85",
                                "charge": "1"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "44",
                                "monoisotopic_mass": "2654.3958",
                                "monoisotopic_mz": "885.8059",
                                "intensity": "194557.64",
                                "charge": "3"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "45",
                                "monoisotopic_mass": "851.7181",
                                "monoisotopic_mz": "852.7253",
                                "intensity": "71447.58",
                                "charge": "1"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "46",
                                "monoisotopic_mass": "685.7803",
                                "monoisotopic_mz": "686.7876",
                                "intensity": "201635.52",
                                "charge": "1"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "47",
                                "monoisotopic_mass": "670.9701",
                                "monoisotopic_mz": "671.9774",
                                "intensity": "55431.90",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "3",
                    "proteoform_id": "4",
                    "sequence_name": "sp|P0A7Q8|RL36_SALTY",
                    "sequence_description": "50S ribosomal protein L36 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmJ PE=3 SV=1",
                    "proteoform_mass": "4532.4837",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "38",
                        "first_residue_position": "0",
                        "last_residue_position": "37",
                        "annotated_seq": ".MKVRASVKKL(C)[Carbamidomethylation]RN(C)[Carbamidomethylation]KIVKRD(GVIRVI(C)[Carbamidomethylation])[-0.0305]SAEPKHKQRQG.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "K"
                            },
                            {
                                "position": "2",
                                "acid": "V"
                            },
                            {
                                "position": "3",
                                "acid": "R"
                            },
                            {
                                "position": "4",
                                "acid": "A"
                            },
                            {
                                "position": "5",
                                "acid": "S"
                            },
                            {
                                "position": "6",
                                "acid": "V"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "L"
                            },
                            {
                                "position": "10",
                                "acid": "C"
                            },
                            {
                                "position": "11",
                                "acid": "R"
                            },
                            {
                                "position": "12",
                                "acid": "N"
                            },
                            {
                                "position": "13",
                                "acid": "C"
                            },
                            {
                                "position": "14",
                                "acid": "K"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "V"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "R"
                            },
                            {
                                "position": "19",
                                "acid": "D"
                            },
                            {
                                "position": "20",
                                "acid": "G"
                            },
                            {
                                "position": "21",
                                "acid": "V"
                            },
                            {
                                "position": "22",
                                "acid": "I"
                            },
                            {
                                "position": "23",
                                "acid": "R"
                            },
                            {
                                "position": "24",
                                "acid": "V"
                            },
                            {
                                "position": "25",
                                "acid": "I"
                            },
                            {
                                "position": "26",
                                "acid": "C"
                            },
                            {
                                "position": "27",
                                "acid": "S"
                            },
                            {
                                "position": "28",
                                "acid": "A"
                            },
                            {
                                "position": "29",
                                "acid": "E"
                            },
                            {
                                "position": "30",
                                "acid": "P"
                            },
                            {
                                "position": "31",
                                "acid": "K"
                            },
                            {
                                "position": "32",
                                "acid": "H"
                            },
                            {
                                "position": "33",
                                "acid": "K"
                            },
                            {
                                "position": "34",
                                "acid": "Q"
                            },
                            {
                                "position": "35",
                                "acid": "R"
                            },
                            {
                                "position": "36",
                                "acid": "Q"
                            },
                            {
                                "position": "37",
                                "acid": "G"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "1",
                                        "ion_display_position": "37",
                                        "spec_id": "160",
                                        "peak_id": "3",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "2",
                                        "ion_display_position": "36",
                                        "spec_id": "160",
                                        "peak_id": "11",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "8",
                                            "ion_display_position": "30",
                                            "spec_id": "160",
                                            "peak_id": "10",
                                            "peak_charge": "5"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "8",
                                            "ion_display_position": "30",
                                            "spec_id": "160",
                                            "peak_id": "6",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "16",
                                        "ion_display_position": "22",
                                        "spec_id": "160",
                                        "peak_id": "31",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "spec_id": "160",
                                        "peak_id": "13",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "20",
                                        "ion_display_position": "18",
                                        "spec_id": "160",
                                        "peak_id": "7",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "spec_id": "160",
                                        "peak_id": "9",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "28",
                                            "ion_display_position": "28",
                                            "spec_id": "160",
                                            "peak_id": "12",
                                            "peak_charge": "5"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "28",
                                            "ion_display_position": "28",
                                            "spec_id": "160",
                                            "peak_id": "0",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "spec_id": "160",
                                        "peak_id": "24",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "30",
                                            "ion_display_position": "8",
                                            "spec_id": "160",
                                            "peak_id": "23",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "30",
                                            "ion_display_position": "8",
                                            "spec_id": "160",
                                            "peak_id": "28",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "30",
                                            "ion_display_position": "30",
                                            "spec_id": "160",
                                            "peak_id": "4",
                                            "peak_charge": "5"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "32",
                                            "ion_display_position": "6",
                                            "spec_id": "160",
                                            "peak_id": "14",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "32",
                                            "ion_display_position": "6",
                                            "spec_id": "160",
                                            "peak_id": "27",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "33",
                                        "ion_display_position": "5",
                                        "spec_id": "160",
                                        "peak_id": "17",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": [
                                {
                                    "left_pos": "10",
                                    "right_pos": "11",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "13",
                                    "right_pos": "14",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "26",
                                    "right_pos": "27",
                                    "anno": "C"
                                }
                            ]
                        },
                        "mass_shift": {
                            "id": "0",
                            "left_position": "20",
                            "right_position": "27",
                            "shift": "-3.0464431981e-02",
                            "anno": "-0.0305",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "1",
                "p_value": "3.26e-09",
                "e_value": "3.26e-09",
                "fdr": "0",
                "matched_fragment_number": "10",
                "matched_peak_number": "13",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                        "ms1_ids": "173",
                        "ms1_scans": "332",
                        "ids": "158",
                        "scans": "333",
                        "precursor_mono_mass": "4532.4737",
                        "precursor_charge": "9",
                        "precursor_mz": "504.6155",
                        "feature_inte": "9.8091e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "158",
                                "peak_id": "0",
                                "monoisotopic_mass": "4384.4020",
                                "monoisotopic_mz": "549.0575",
                                "intensity": "1247462.32",
                                "charge": "8"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "1",
                                "monoisotopic_mass": "4401.4289",
                                "monoisotopic_mz": "551.1859",
                                "intensity": "712796.43",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-3.5464431981e-02",
                                        "theoretical_mass": "4401.4382",
                                        "ion_position": "1",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "Y00037",
                                        "ion_left_position": "1",
                                        "mass_error": "-0.0093",
                                        "ppm": "-2.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "2",
                                "monoisotopic_mass": "4273.3380",
                                "monoisotopic_mz": "535.1745",
                                "intensity": "1020521.30",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-3.5464431981e-02",
                                        "theoretical_mass": "4273.3432",
                                        "ion_position": "2",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "Y00036",
                                        "ion_left_position": "2",
                                        "mass_error": "-0.0053",
                                        "ppm": "-1.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "3",
                                "monoisotopic_mass": "1782.9766",
                                "monoisotopic_mz": "199.1158",
                                "intensity": "274330.21",
                                "charge": "9"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "4",
                                "monoisotopic_mass": "3354.8490",
                                "monoisotopic_mz": "671.9771",
                                "intensity": "1227614.89",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-3.5464431981e-02",
                                        "theoretical_mass": "3354.8471",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "0.0020",
                                        "ppm": "0.58"
                                    }
                                }
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "5",
                                "monoisotopic_mass": "3504.8461",
                                "monoisotopic_mz": "585.1483",
                                "intensity": "379329.18",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-3.5464431981e-02",
                                        "theoretical_mass": "3504.8462",
                                        "ion_position": "9",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "Y00029",
                                        "ion_left_position": "9",
                                        "mass_error": "-0.0001",
                                        "ppm": "-0.03"
                                    }
                                }
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "6",
                                "monoisotopic_mass": "3245.8247",
                                "monoisotopic_mz": "650.1722",
                                "intensity": "263251.79",
                                "charge": "5"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "7",
                                "monoisotopic_mass": "3425.8848",
                                "monoisotopic_mz": "686.1842",
                                "intensity": "1489383.25",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-3.5464431981e-02",
                                        "theoretical_mass": "3425.8842",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0006",
                                        "ppm": "0.17"
                                    }
                                }
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "8",
                                "monoisotopic_mass": "4367.3864",
                                "monoisotopic_mz": "546.9306",
                                "intensity": "139062.18",
                                "charge": "8"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "9",
                                "monoisotopic_mass": "752.3971",
                                "monoisotopic_mz": "753.4044",
                                "intensity": "362750.12",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "752.4042",
                                        "ion_position": "32",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "32",
                                        "mass_error": "-0.0071",
                                        "ppm": "-9.42"
                                    }
                                }
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "10",
                                "monoisotopic_mass": "3176.8074",
                                "monoisotopic_mz": "636.3688",
                                "intensity": "272771.04",
                                "charge": "5"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "11",
                                "monoisotopic_mass": "3267.8069",
                                "monoisotopic_mz": "545.6418",
                                "intensity": "162393.31",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-3.5464431981e-02",
                                        "theoretical_mass": "3267.8150",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "B00027",
                                        "ion_left_position": "27",
                                        "mass_error": "-0.0082",
                                        "ppm": "-2.50"
                                    }
                                }
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "12",
                                "monoisotopic_mass": "3899.1144",
                                "monoisotopic_mz": "558.0236",
                                "intensity": "83147.39",
                                "charge": "7"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "13",
                                "monoisotopic_mass": "3267.8229",
                                "monoisotopic_mz": "654.5719",
                                "intensity": "552144.15",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-3.5464431981e-02",
                                        "theoretical_mass": "3267.8150",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "B00027",
                                        "ion_left_position": "27",
                                        "mass_error": "0.0078",
                                        "ppm": "2.40"
                                    }
                                }
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "14",
                                "monoisotopic_mass": "3245.8346",
                                "monoisotopic_mz": "541.9797",
                                "intensity": "259289.72",
                                "charge": "6"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "15",
                                "monoisotopic_mass": "3337.8406",
                                "monoisotopic_mz": "835.4674",
                                "intensity": "188334.51",
                                "charge": "4"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "16",
                                "monoisotopic_mass": "977.5432",
                                "monoisotopic_mz": "326.8550",
                                "intensity": "1869212.03",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "977.5519",
                                        "ion_position": "30",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0087",
                                        "ppm": "-8.90"
                                    }
                                }
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "17",
                                "monoisotopic_mass": "752.3974",
                                "monoisotopic_mz": "377.2060",
                                "intensity": "645633.96",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "752.4042",
                                        "ion_position": "32",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "32",
                                        "mass_error": "-0.0067",
                                        "ppm": "-8.96"
                                    }
                                }
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "18",
                                "monoisotopic_mass": "861.4527",
                                "monoisotopic_mz": "862.4600",
                                "intensity": "58991.98",
                                "charge": "1"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "19",
                                "monoisotopic_mass": "615.3402",
                                "monoisotopic_mz": "616.3475",
                                "intensity": "287429.09",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "615.3453",
                                        "ion_position": "33",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "Y00005",
                                        "ion_left_position": "33",
                                        "mass_error": "-0.0051",
                                        "ppm": "-8.22"
                                    }
                                }
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "20",
                                "monoisotopic_mass": "880.4910",
                                "monoisotopic_mz": "441.2528",
                                "intensity": "174573.48",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "880.4991",
                                        "ion_position": "31",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "31",
                                        "mass_error": "-0.0081",
                                        "ppm": "-9.24"
                                    }
                                }
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "21",
                                "monoisotopic_mass": "960.5159",
                                "monoisotopic_mz": "321.1793",
                                "intensity": "73239.98",
                                "charge": "3"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "22",
                                "monoisotopic_mass": "615.3399",
                                "monoisotopic_mz": "308.6772",
                                "intensity": "167469.84",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "615.3453",
                                        "ion_position": "33",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "Y00005",
                                        "ion_left_position": "33",
                                        "mass_error": "-0.0053",
                                        "ppm": "-8.64"
                                    }
                                }
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "23",
                                "monoisotopic_mass": "3327.8575",
                                "monoisotopic_mz": "555.6502",
                                "intensity": "85849.59",
                                "charge": "6"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "24",
                                "monoisotopic_mass": "1088.5731",
                                "monoisotopic_mz": "545.2938",
                                "intensity": "220139.11",
                                "charge": "2"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "25",
                                "monoisotopic_mass": "3108.7955",
                                "monoisotopic_mz": "622.7664",
                                "intensity": "120795.75",
                                "charge": "5"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "26",
                                "monoisotopic_mass": "3176.7994",
                                "monoisotopic_mz": "530.4738",
                                "intensity": "119520.83",
                                "charge": "6"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "27",
                                "monoisotopic_mass": "640.3968",
                                "monoisotopic_mz": "641.4041",
                                "intensity": "92539.02",
                                "charge": "1"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "28",
                                "monoisotopic_mass": "3556.9316",
                                "monoisotopic_mz": "593.8292",
                                "intensity": "78929.94",
                                "charge": "6"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "29",
                                "monoisotopic_mass": "658.3643",
                                "monoisotopic_mz": "659.3716",
                                "intensity": "71847.35",
                                "charge": "1"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "30",
                                "monoisotopic_mass": "1186.6452",
                                "monoisotopic_mz": "594.3299",
                                "intensity": "25940.40",
                                "charge": "2"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "31",
                                "monoisotopic_mass": "3406.8719",
                                "monoisotopic_mz": "682.3816",
                                "intensity": "440088.75",
                                "charge": "5"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "32",
                                "monoisotopic_mass": "3007.6752",
                                "monoisotopic_mz": "602.5423",
                                "intensity": "96467.89",
                                "charge": "5"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "33",
                                "monoisotopic_mass": "3336.8340",
                                "monoisotopic_mz": "668.3741",
                                "intensity": "761138.69",
                                "charge": "5"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "34",
                                "monoisotopic_mass": "3222.8137",
                                "monoisotopic_mz": "645.5700",
                                "intensity": "116743.09",
                                "charge": "5"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "35",
                                "monoisotopic_mass": "469.2348",
                                "monoisotopic_mz": "470.2420",
                                "intensity": "135871.79",
                                "charge": "1"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "36",
                                "monoisotopic_mass": "538.9560",
                                "monoisotopic_mz": "539.9633",
                                "intensity": "79874.00",
                                "charge": "1"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "37",
                                "monoisotopic_mass": "685.7804",
                                "monoisotopic_mz": "686.7877",
                                "intensity": "132195.27",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "3",
                    "proteoform_id": "4",
                    "sequence_name": "sp|P0A7Q8|RL36_SALTY",
                    "sequence_description": "50S ribosomal protein L36 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmJ PE=3 SV=1",
                    "proteoform_mass": "4532.4787",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "38",
                        "first_residue_position": "0",
                        "last_residue_position": "37",
                        "annotated_seq": ".MKVRASVKK(L(C)[Carbamidomethylation]RN(C)[Carbamidomethylation]KIVKRDGVIRVI(C)[Carbamidomethylation])[-0.0355]SAEPKHKQRQG.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "K"
                            },
                            {
                                "position": "2",
                                "acid": "V"
                            },
                            {
                                "position": "3",
                                "acid": "R"
                            },
                            {
                                "position": "4",
                                "acid": "A"
                            },
                            {
                                "position": "5",
                                "acid": "S"
                            },
                            {
                                "position": "6",
                                "acid": "V"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "L"
                            },
                            {
                                "position": "10",
                                "acid": "C"
                            },
                            {
                                "position": "11",
                                "acid": "R"
                            },
                            {
                                "position": "12",
                                "acid": "N"
                            },
                            {
                                "position": "13",
                                "acid": "C"
                            },
                            {
                                "position": "14",
                                "acid": "K"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "V"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "R"
                            },
                            {
                                "position": "19",
                                "acid": "D"
                            },
                            {
                                "position": "20",
                                "acid": "G"
                            },
                            {
                                "position": "21",
                                "acid": "V"
                            },
                            {
                                "position": "22",
                                "acid": "I"
                            },
                            {
                                "position": "23",
                                "acid": "R"
                            },
                            {
                                "position": "24",
                                "acid": "V"
                            },
                            {
                                "position": "25",
                                "acid": "I"
                            },
                            {
                                "position": "26",
                                "acid": "C"
                            },
                            {
                                "position": "27",
                                "acid": "S"
                            },
                            {
                                "position": "28",
                                "acid": "A"
                            },
                            {
                                "position": "29",
                                "acid": "E"
                            },
                            {
                                "position": "30",
                                "acid": "P"
                            },
                            {
                                "position": "31",
                                "acid": "K"
                            },
                            {
                                "position": "32",
                                "acid": "H"
                            },
                            {
                                "position": "33",
                                "acid": "K"
                            },
                            {
                                "position": "34",
                                "acid": "Q"
                            },
                            {
                                "position": "35",
                                "acid": "R"
                            },
                            {
                                "position": "36",
                                "acid": "Q"
                            },
                            {
                                "position": "37",
                                "acid": "G"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "1",
                                        "ion_display_position": "37",
                                        "spec_id": "158",
                                        "peak_id": "1",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "2",
                                        "ion_display_position": "36",
                                        "spec_id": "158",
                                        "peak_id": "2",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "9",
                                        "ion_display_position": "29",
                                        "spec_id": "158",
                                        "peak_id": "5",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "27",
                                            "ion_display_position": "27",
                                            "spec_id": "158",
                                            "peak_id": "11",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "27",
                                            "ion_display_position": "27",
                                            "spec_id": "158",
                                            "peak_id": "13",
                                            "peak_charge": "5"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "158",
                                        "peak_id": "4",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "spec_id": "158",
                                        "peak_id": "7",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "30",
                                        "ion_display_position": "8",
                                        "spec_id": "158",
                                        "peak_id": "16",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "31",
                                        "ion_display_position": "7",
                                        "spec_id": "158",
                                        "peak_id": "20",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "32",
                                            "ion_display_position": "6",
                                            "spec_id": "158",
                                            "peak_id": "9",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "32",
                                            "ion_display_position": "6",
                                            "spec_id": "158",
                                            "peak_id": "17",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "33",
                                            "ion_display_position": "5",
                                            "spec_id": "158",
                                            "peak_id": "22",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "33",
                                            "ion_display_position": "5",
                                            "spec_id": "158",
                                            "peak_id": "19",
                                            "peak_charge": "1"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": [
                                {
                                    "left_pos": "10",
                                    "right_pos": "11",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "13",
                                    "right_pos": "14",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "26",
                                    "right_pos": "27",
                                    "anno": "C"
                                }
                            ]
                        },
                        "mass_shift": {
                            "id": "0",
                            "left_position": "9",
                            "right_position": "27",
                            "shift": "-3.5464431981e-02",
                            "anno": "-0.0355",
                            "shift_type": "unexpected"
                        }
                    }
                }
            }
        ]
    }
}
