prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "20",
        "sequence_name": "sp|P66131|RL27_SALTY",
        "sequence_description": "50S ribosomal protein L27 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmA PE=3 SV=2",
        "proteoform_id": "30",
        "prsm_number": "5",
        "prsm": [
            {
                "prsm_id": "39",
                "p_value": "2.29e-06",
                "e_value": "2.29e-06",
                "fdr": "0",
                "matched_fragment_number": "11",
                "matched_peak_number": "12",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                        "ms1_ids": "304",
                        "ms1_scans": "593",
                        "ids": "288",
                        "scans": "594",
                        "precursor_mono_mass": "9044.8266",
                        "precursor_charge": "17",
                        "precursor_mz": "533.0559",
                        "feature_inte": "3.3095e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "288",
                                "peak_id": "0",
                                "monoisotopic_mass": "8826.7181",
                                "monoisotopic_mz": "589.4551",
                                "intensity": "161836.48",
                                "charge": "15"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "1",
                                "monoisotopic_mass": "8897.7652",
                                "monoisotopic_mz": "557.1176",
                                "intensity": "129569.44",
                                "charge": "16",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8897.8458",
                                        "ion_position": "83",
                                        "ion_display_position": "83",
                                        "ion_sort_name": "B00083",
                                        "ion_left_position": "83",
                                        "mass_error": "-0.0806",
                                        "ppm": "-9.06"
                                    }
                                }
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "2",
                                "monoisotopic_mass": "8868.7683",
                                "monoisotopic_mz": "555.3053",
                                "intensity": "80864.56",
                                "charge": "16"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "3",
                                "monoisotopic_mass": "8727.6544",
                                "monoisotopic_mz": "582.8509",
                                "intensity": "147287.41",
                                "charge": "15",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8727.7403",
                                        "ion_position": "81",
                                        "ion_display_position": "81",
                                        "ion_sort_name": "B00081",
                                        "ion_left_position": "81",
                                        "mass_error": "-0.0859",
                                        "ppm": "-9.84"
                                    }
                                }
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "4",
                                "monoisotopic_mass": "8826.7408",
                                "monoisotopic_mz": "552.6786",
                                "intensity": "51736.45",
                                "charge": "16",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8826.8087",
                                        "ion_position": "82",
                                        "ion_display_position": "82",
                                        "ion_sort_name": "B00082",
                                        "ion_left_position": "82",
                                        "mass_error": "-0.0679",
                                        "ppm": "-7.69"
                                    }
                                }
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "5",
                                "monoisotopic_mass": "8798.7130",
                                "monoisotopic_mz": "587.5881",
                                "intensity": "109917.89",
                                "charge": "15"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "6",
                                "monoisotopic_mass": "8770.6988",
                                "monoisotopic_mz": "585.7205",
                                "intensity": "121498.11",
                                "charge": "15"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "7",
                                "monoisotopic_mass": "8754.6066",
                                "monoisotopic_mz": "584.6477",
                                "intensity": "17096.31",
                                "charge": "15"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "8",
                                "monoisotopic_mass": "8727.6464",
                                "monoisotopic_mz": "624.4106",
                                "intensity": "90676.85",
                                "charge": "14"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "9",
                                "monoisotopic_mass": "5127.7434",
                                "monoisotopic_mz": "570.7565",
                                "intensity": "204728.98",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5127.7892",
                                        "ion_position": "49",
                                        "ion_display_position": "49",
                                        "ion_sort_name": "B00049",
                                        "ion_left_position": "49",
                                        "mass_error": "-0.0458",
                                        "ppm": "-8.93"
                                    }
                                }
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "10",
                                "monoisotopic_mass": "5924.1641",
                                "monoisotopic_mz": "593.4237",
                                "intensity": "52547.51",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5924.2224",
                                        "ion_position": "30",
                                        "ion_display_position": "54",
                                        "ion_sort_name": "Y00054",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0583",
                                        "ppm": "-9.84"
                                    }
                                }
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "11",
                                "monoisotopic_mass": "5605.9933",
                                "monoisotopic_mz": "701.7564",
                                "intensity": "26789.11",
                                "charge": "8"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "12",
                                "monoisotopic_mass": "2179.5080",
                                "monoisotopic_mz": "199.1444",
                                "intensity": "12820.37",
                                "charge": "11"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "13",
                                "monoisotopic_mass": "5493.9318",
                                "monoisotopic_mz": "687.7487",
                                "intensity": "32792.64",
                                "charge": "8"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "14",
                                "monoisotopic_mass": "5706.0757",
                                "monoisotopic_mz": "635.0157",
                                "intensity": "65197.17",
                                "charge": "9"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "15",
                                "monoisotopic_mass": "3092.6529",
                                "monoisotopic_mz": "442.8148",
                                "intensity": "17494.50",
                                "charge": "7"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "16",
                                "monoisotopic_mass": "3021.5756",
                                "monoisotopic_mz": "432.6609",
                                "intensity": "13026.89",
                                "charge": "7"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "17",
                                "monoisotopic_mass": "5592.9917",
                                "monoisotopic_mz": "622.4508",
                                "intensity": "55277.38",
                                "charge": "9"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "18",
                                "monoisotopic_mass": "8196.7760",
                                "monoisotopic_mz": "586.4913",
                                "intensity": "54756.93",
                                "charge": "14"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "19",
                                "monoisotopic_mass": "5593.0000",
                                "monoisotopic_mz": "700.1323",
                                "intensity": "29335.07",
                                "charge": "8"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "20",
                                "monoisotopic_mass": "3818.0107",
                                "monoisotopic_mz": "546.4374",
                                "intensity": "42862.77",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3818.0414",
                                        "ion_position": "50",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "Y00034",
                                        "ion_left_position": "50",
                                        "mass_error": "-0.0307",
                                        "ppm": "-8.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "21",
                                "monoisotopic_mass": "2950.5452",
                                "monoisotopic_mz": "591.1163",
                                "intensity": "27400.53",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2950.5710",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0258",
                                        "ppm": "-8.75"
                                    }
                                }
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "22",
                                "monoisotopic_mass": "3021.5801",
                                "monoisotopic_mz": "605.3233",
                                "intensity": "163067.28",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3021.6081",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "-0.0281",
                                        "ppm": "-9.29"
                                    }
                                }
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "23",
                                "monoisotopic_mass": "6653.5022",
                                "monoisotopic_mz": "605.8711",
                                "intensity": "43625.05",
                                "charge": "11"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "24",
                                "monoisotopic_mass": "5906.1459",
                                "monoisotopic_mz": "591.6219",
                                "intensity": "10485.91",
                                "charge": "10"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "25",
                                "monoisotopic_mass": "3120.6572",
                                "monoisotopic_mz": "625.1387",
                                "intensity": "31384.40",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3120.6765",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0194",
                                        "ppm": "-6.20"
                                    }
                                }
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "26",
                                "monoisotopic_mass": "8710.6189",
                                "monoisotopic_mz": "623.1943",
                                "intensity": "15906.18",
                                "charge": "14"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "27",
                                "monoisotopic_mass": "5664.0322",
                                "monoisotopic_mz": "630.3442",
                                "intensity": "43407.15",
                                "charge": "9"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "28",
                                "monoisotopic_mass": "3021.5802",
                                "monoisotopic_mz": "504.6040",
                                "intensity": "128249.53",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3021.6081",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "-0.0280",
                                        "ppm": "-9.26"
                                    }
                                }
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "29",
                                "monoisotopic_mass": "5565.9993",
                                "monoisotopic_mz": "619.4516",
                                "intensity": "16907.59",
                                "charge": "9"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "30",
                                "monoisotopic_mass": "3599.9072",
                                "monoisotopic_mz": "600.9918",
                                "intensity": "19487.19",
                                "charge": "6"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "31",
                                "monoisotopic_mass": "8709.6406",
                                "monoisotopic_mz": "581.6500",
                                "intensity": "57516.83",
                                "charge": "15",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8708.7080",
                                        "ion_position": "3",
                                        "ion_display_position": "81",
                                        "ion_sort_name": "Y00081",
                                        "ion_left_position": "3",
                                        "mass_error": "-0.0697",
                                        "ppm": "-8.01"
                                    }
                                }
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "32",
                                "monoisotopic_mass": "5777.1227",
                                "monoisotopic_mz": "642.9098",
                                "intensity": "68137.32",
                                "charge": "9"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "33",
                                "monoisotopic_mass": "5564.9587",
                                "monoisotopic_mz": "696.6271",
                                "intensity": "23744.05",
                                "charge": "8"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "34",
                                "monoisotopic_mass": "7433.2372",
                                "monoisotopic_mz": "620.4437",
                                "intensity": "5961.07",
                                "charge": "12"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "35",
                                "monoisotopic_mass": "5688.0828",
                                "monoisotopic_mz": "633.0165",
                                "intensity": "13319.85",
                                "charge": "9"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "36",
                                "monoisotopic_mass": "7588.5669",
                                "monoisotopic_mz": "633.3879",
                                "intensity": "11198.84",
                                "charge": "12"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "37",
                                "monoisotopic_mass": "8683.5562",
                                "monoisotopic_mz": "621.2613",
                                "intensity": "19252.23",
                                "charge": "14"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "38",
                                "monoisotopic_mass": "2949.5440",
                                "monoisotopic_mz": "492.5980",
                                "intensity": "15693.97",
                                "charge": "6"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "39",
                                "monoisotopic_mass": "3670.9594",
                                "monoisotopic_mz": "612.8338",
                                "intensity": "18881.58",
                                "charge": "6"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "40",
                                "monoisotopic_mass": "2219.9382",
                                "monoisotopic_mz": "555.9918",
                                "intensity": "10186.46",
                                "charge": "4"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "41",
                                "monoisotopic_mass": "7445.7689",
                                "monoisotopic_mz": "621.4880",
                                "intensity": "7773.95",
                                "charge": "12"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "42",
                                "monoisotopic_mass": "579.1754",
                                "monoisotopic_mz": "580.1827",
                                "intensity": "15249.00",
                                "charge": "1"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "43",
                                "monoisotopic_mass": "4111.1216",
                                "monoisotopic_mz": "588.3104",
                                "intensity": "18831.18",
                                "charge": "7"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "44",
                                "monoisotopic_mass": "4398.8655",
                                "monoisotopic_mz": "550.8655",
                                "intensity": "15261.73",
                                "charge": "8"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "45",
                                "monoisotopic_mass": "1762.1506",
                                "monoisotopic_mz": "588.3908",
                                "intensity": "8713.06",
                                "charge": "3"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "46",
                                "monoisotopic_mass": "3003.5825",
                                "monoisotopic_mz": "601.7238",
                                "intensity": "13918.37",
                                "charge": "5"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "47",
                                "monoisotopic_mass": "6350.3511",
                                "monoisotopic_mz": "578.3119",
                                "intensity": "18324.50",
                                "charge": "11"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "48",
                                "monoisotopic_mass": "5875.4566",
                                "monoisotopic_mz": "588.5529",
                                "intensity": "6794.77",
                                "charge": "10"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "49",
                                "monoisotopic_mass": "2377.6379",
                                "monoisotopic_mz": "199.1438",
                                "intensity": "6282.67",
                                "charge": "12"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "50",
                                "monoisotopic_mass": "4334.3324",
                                "monoisotopic_mz": "620.1976",
                                "intensity": "7052.63",
                                "charge": "7"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "51",
                                "monoisotopic_mass": "553.3597",
                                "monoisotopic_mz": "554.3669",
                                "intensity": "8453.00",
                                "charge": "1"
                            },
                            {
                                "spec_id": "288",
                                "peak_id": "52",
                                "monoisotopic_mass": "5810.0899",
                                "monoisotopic_mz": "582.0163",
                                "intensity": "12881.51",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5811.1384",
                                        "ion_position": "31",
                                        "ion_display_position": "53",
                                        "ion_sort_name": "Y00053",
                                        "ion_left_position": "31",
                                        "mass_error": "-0.0461",
                                        "ppm": "-7.94"
                                    }
                                }
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "20",
                    "proteoform_id": "30",
                    "sequence_name": "sp|P66131|RL27_SALTY",
                    "sequence_description": "50S ribosomal protein L27 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmA PE=3 SV=2",
                    "proteoform_mass": "9044.8990",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "85",
                        "first_residue_position": "1",
                        "last_residue_position": "84",
                        "annotated_seq": "M.AHKKAGGSTRNGRDSEAKRLGVKRFGGEAVLAGSIIVRQRGTKFHAGTNVG(C)[Carbamidomethylation]GRDHTLFAKADGKVKFEVKGPKNRKYISIVAE.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "H"
                            },
                            {
                                "position": "3",
                                "acid": "K"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "A"
                            },
                            {
                                "position": "6",
                                "acid": "G"
                            },
                            {
                                "position": "7",
                                "acid": "G"
                            },
                            {
                                "position": "8",
                                "acid": "S"
                            },
                            {
                                "position": "9",
                                "acid": "T"
                            },
                            {
                                "position": "10",
                                "acid": "R"
                            },
                            {
                                "position": "11",
                                "acid": "N"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "R"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "S"
                            },
                            {
                                "position": "16",
                                "acid": "E"
                            },
                            {
                                "position": "17",
                                "acid": "A"
                            },
                            {
                                "position": "18",
                                "acid": "K"
                            },
                            {
                                "position": "19",
                                "acid": "R"
                            },
                            {
                                "position": "20",
                                "acid": "L"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "V"
                            },
                            {
                                "position": "23",
                                "acid": "K"
                            },
                            {
                                "position": "24",
                                "acid": "R"
                            },
                            {
                                "position": "25",
                                "acid": "F"
                            },
                            {
                                "position": "26",
                                "acid": "G"
                            },
                            {
                                "position": "27",
                                "acid": "G"
                            },
                            {
                                "position": "28",
                                "acid": "E"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "V"
                            },
                            {
                                "position": "31",
                                "acid": "L"
                            },
                            {
                                "position": "32",
                                "acid": "A"
                            },
                            {
                                "position": "33",
                                "acid": "G"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "I"
                            },
                            {
                                "position": "36",
                                "acid": "I"
                            },
                            {
                                "position": "37",
                                "acid": "V"
                            },
                            {
                                "position": "38",
                                "acid": "R"
                            },
                            {
                                "position": "39",
                                "acid": "Q"
                            },
                            {
                                "position": "40",
                                "acid": "R"
                            },
                            {
                                "position": "41",
                                "acid": "G"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "K"
                            },
                            {
                                "position": "44",
                                "acid": "F"
                            },
                            {
                                "position": "45",
                                "acid": "H"
                            },
                            {
                                "position": "46",
                                "acid": "A"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "N"
                            },
                            {
                                "position": "50",
                                "acid": "V"
                            },
                            {
                                "position": "51",
                                "acid": "G"
                            },
                            {
                                "position": "52",
                                "acid": "C"
                            },
                            {
                                "position": "53",
                                "acid": "G"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "D"
                            },
                            {
                                "position": "56",
                                "acid": "H"
                            },
                            {
                                "position": "57",
                                "acid": "T"
                            },
                            {
                                "position": "58",
                                "acid": "L"
                            },
                            {
                                "position": "59",
                                "acid": "F"
                            },
                            {
                                "position": "60",
                                "acid": "A"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "A"
                            },
                            {
                                "position": "63",
                                "acid": "D"
                            },
                            {
                                "position": "64",
                                "acid": "G"
                            },
                            {
                                "position": "65",
                                "acid": "K"
                            },
                            {
                                "position": "66",
                                "acid": "V"
                            },
                            {
                                "position": "67",
                                "acid": "K"
                            },
                            {
                                "position": "68",
                                "acid": "F"
                            },
                            {
                                "position": "69",
                                "acid": "E"
                            },
                            {
                                "position": "70",
                                "acid": "V"
                            },
                            {
                                "position": "71",
                                "acid": "K"
                            },
                            {
                                "position": "72",
                                "acid": "G"
                            },
                            {
                                "position": "73",
                                "acid": "P"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "N"
                            },
                            {
                                "position": "76",
                                "acid": "R"
                            },
                            {
                                "position": "77",
                                "acid": "K"
                            },
                            {
                                "position": "78",
                                "acid": "Y"
                            },
                            {
                                "position": "79",
                                "acid": "I"
                            },
                            {
                                "position": "80",
                                "acid": "S"
                            },
                            {
                                "position": "81",
                                "acid": "I"
                            },
                            {
                                "position": "82",
                                "acid": "V"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "E"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "3",
                                        "ion_display_position": "81",
                                        "spec_id": "288",
                                        "peak_id": "31",
                                        "peak_charge": "15"
                                    }
                                }
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "288",
                                        "peak_id": "21",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "29",
                                            "ion_display_position": "29",
                                            "spec_id": "288",
                                            "peak_id": "22",
                                            "peak_charge": "5"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "29",
                                            "ion_display_position": "29",
                                            "spec_id": "288",
                                            "peak_id": "28",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "30",
                                            "ion_display_position": "30",
                                            "spec_id": "288",
                                            "peak_id": "25",
                                            "peak_charge": "5"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "30",
                                            "ion_display_position": "54",
                                            "spec_id": "288",
                                            "peak_id": "10",
                                            "peak_charge": "10"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "31",
                                        "ion_display_position": "53",
                                        "spec_id": "288",
                                        "peak_id": "52",
                                        "peak_charge": "10"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "49",
                                        "ion_display_position": "49",
                                        "spec_id": "288",
                                        "peak_id": "9",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "50",
                                        "ion_display_position": "34",
                                        "spec_id": "288",
                                        "peak_id": "20",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "81",
                                        "ion_display_position": "81",
                                        "spec_id": "288",
                                        "peak_id": "3",
                                        "peak_charge": "15"
                                    }
                                }
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "82",
                                        "ion_display_position": "82",
                                        "spec_id": "288",
                                        "peak_id": "4",
                                        "peak_charge": "16"
                                    }
                                }
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "83",
                                        "ion_display_position": "83",
                                        "spec_id": "288",
                                        "peak_id": "1",
                                        "peak_charge": "16"
                                    }
                                }
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": {
                                "left_pos": "52",
                                "right_pos": "53",
                                "anno": "C"
                            }
                        }
                    }
                }
            },
            {
                "prsm_id": "40",
                "p_value": "1.49e-04",
                "e_value": "1.49e-04",
                "fdr": "0",
                "matched_fragment_number": "10",
                "matched_peak_number": "13",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                        "ms1_ids": "311",
                        "ms1_scans": "607",
                        "ids": "295",
                        "scans": "608",
                        "precursor_mono_mass": "9044.8266",
                        "precursor_charge": "17",
                        "precursor_mz": "533.0559",
                        "feature_inte": "3.3095e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "295",
                                "peak_id": "0",
                                "monoisotopic_mass": "8869.7619",
                                "monoisotopic_mz": "555.3674",
                                "intensity": "38549.26",
                                "charge": "16"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "1",
                                "monoisotopic_mass": "8825.7199",
                                "monoisotopic_mz": "552.6148",
                                "intensity": "16027.01",
                                "charge": "16",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-1.0546949926",
                                        "theoretical_mass": "8825.7540",
                                        "ion_position": "82",
                                        "ion_display_position": "82",
                                        "ion_sort_name": "B00082",
                                        "ion_left_position": "82",
                                        "mass_error": "-0.0341",
                                        "ppm": "-3.87"
                                    }
                                }
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "2",
                                "monoisotopic_mass": "8825.7075",
                                "monoisotopic_mz": "589.3878",
                                "intensity": "73281.41",
                                "charge": "15",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-1.0546949926",
                                        "theoretical_mass": "8825.7540",
                                        "ion_position": "82",
                                        "ion_display_position": "82",
                                        "ion_sort_name": "B00082",
                                        "ion_left_position": "82",
                                        "mass_error": "-0.0465",
                                        "ppm": "-5.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "3",
                                "monoisotopic_mass": "8752.6720",
                                "monoisotopic_mz": "584.5187",
                                "intensity": "23924.47",
                                "charge": "15"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "4",
                                "monoisotopic_mass": "8798.6827",
                                "monoisotopic_mz": "587.5861",
                                "intensity": "61504.54",
                                "charge": "15"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "5",
                                "monoisotopic_mass": "8727.6481",
                                "monoisotopic_mz": "582.8505",
                                "intensity": "63293.63",
                                "charge": "15",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-1.0546949926",
                                        "theoretical_mass": "8726.6856",
                                        "ion_position": "81",
                                        "ion_display_position": "81",
                                        "ion_sort_name": "B00081",
                                        "ion_left_position": "81",
                                        "mass_error": "-0.0398",
                                        "ppm": "-4.56"
                                    }
                                }
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "6",
                                "monoisotopic_mass": "1981.2893",
                                "monoisotopic_mz": "199.1362",
                                "intensity": "6089.88",
                                "charge": "10"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "7",
                                "monoisotopic_mass": "8769.6772",
                                "monoisotopic_mz": "585.6524",
                                "intensity": "51184.45",
                                "charge": "15"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "8",
                                "monoisotopic_mass": "8727.6446",
                                "monoisotopic_mz": "624.4105",
                                "intensity": "38497.09",
                                "charge": "14",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-1.0546949926",
                                        "theoretical_mass": "8726.6856",
                                        "ion_position": "81",
                                        "ion_display_position": "81",
                                        "ion_sort_name": "B00081",
                                        "ion_left_position": "81",
                                        "mass_error": "-0.0434",
                                        "ppm": "-4.97"
                                    }
                                }
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "9",
                                "monoisotopic_mass": "2179.5684",
                                "monoisotopic_mz": "199.1499",
                                "intensity": "6809.72",
                                "charge": "11"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "10",
                                "monoisotopic_mass": "5127.7357",
                                "monoisotopic_mz": "570.7557",
                                "intensity": "88231.01",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-1.0546949926",
                                        "theoretical_mass": "5126.7345",
                                        "ion_position": "49",
                                        "ion_display_position": "49",
                                        "ion_sort_name": "B00049",
                                        "ion_left_position": "49",
                                        "mass_error": "-0.0011",
                                        "ppm": "-0.22"
                                    }
                                }
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "11",
                                "monoisotopic_mass": "7343.8166",
                                "monoisotopic_mz": "612.9920",
                                "intensity": "8090.54",
                                "charge": "12",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-1.0546949926",
                                        "theoretical_mass": "7342.8505",
                                        "ion_position": "69",
                                        "ion_display_position": "69",
                                        "ion_sort_name": "B00069",
                                        "ion_left_position": "69",
                                        "mass_error": "-0.0363",
                                        "ppm": "-4.95"
                                    }
                                }
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "12",
                                "monoisotopic_mass": "5777.1087",
                                "monoisotopic_mz": "642.9082",
                                "intensity": "30753.39",
                                "charge": "9"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "13",
                                "monoisotopic_mass": "5664.0343",
                                "monoisotopic_mz": "630.3444",
                                "intensity": "19562.32",
                                "charge": "9"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "14",
                                "monoisotopic_mass": "8195.8438",
                                "monoisotopic_mz": "586.4247",
                                "intensity": "25463.36",
                                "charge": "14"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "15",
                                "monoisotopic_mass": "8710.5863",
                                "monoisotopic_mz": "581.7130",
                                "intensity": "27978.68",
                                "charge": "15"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "16",
                                "monoisotopic_mass": "3092.6563",
                                "monoisotopic_mz": "442.8153",
                                "intensity": "11833.71",
                                "charge": "7"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "17",
                                "monoisotopic_mass": "5593.9957",
                                "monoisotopic_mz": "622.5624",
                                "intensity": "28720.84",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-1.0546949926",
                                        "theoretical_mass": "5594.9931",
                                        "ion_position": "34",
                                        "ion_display_position": "50",
                                        "ion_sort_name": "Y00050",
                                        "ion_left_position": "34",
                                        "mass_error": "0.0050",
                                        "ppm": "0.90"
                                    }
                                }
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "18",
                                "monoisotopic_mass": "3599.9159",
                                "monoisotopic_mz": "600.9933",
                                "intensity": "11538.40",
                                "charge": "6"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "19",
                                "monoisotopic_mass": "3021.5782",
                                "monoisotopic_mz": "605.3229",
                                "intensity": "71496.56",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3021.6081",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "-0.0299",
                                        "ppm": "-9.90"
                                    }
                                }
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "20",
                                "monoisotopic_mass": "4389.8459",
                                "monoisotopic_mz": "549.7380",
                                "intensity": "5403.85",
                                "charge": "8"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "21",
                                "monoisotopic_mass": "1884.8816",
                                "monoisotopic_mz": "629.3011",
                                "intensity": "13642.78",
                                "charge": "3"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "22",
                                "monoisotopic_mass": "6741.2632",
                                "monoisotopic_mz": "562.7792",
                                "intensity": "4930.15",
                                "charge": "12"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "23",
                                "monoisotopic_mass": "3021.5780",
                                "monoisotopic_mz": "504.6036",
                                "intensity": "57029.16",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3021.6081",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "-0.0302",
                                        "ppm": "-9.98"
                                    }
                                }
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "24",
                                "monoisotopic_mass": "5923.1758",
                                "monoisotopic_mz": "593.3249",
                                "intensity": "12322.60",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-1.0546949926",
                                        "theoretical_mass": "5923.1677",
                                        "ion_position": "30",
                                        "ion_display_position": "54",
                                        "ion_sort_name": "Y00054",
                                        "ion_left_position": "30",
                                        "mass_error": "0.0081",
                                        "ppm": "1.37"
                                    }
                                }
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "25",
                                "monoisotopic_mass": "3021.5708",
                                "monoisotopic_mz": "432.6603",
                                "intensity": "6263.68",
                                "charge": "7"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "26",
                                "monoisotopic_mass": "3818.0051",
                                "monoisotopic_mz": "546.4366",
                                "intensity": "5107.04",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3818.0414",
                                        "ion_position": "50",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "Y00034",
                                        "ion_left_position": "50",
                                        "mass_error": "-0.0363",
                                        "ppm": "-9.50"
                                    }
                                }
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "27",
                                "monoisotopic_mass": "3120.6447",
                                "monoisotopic_mz": "625.1362",
                                "intensity": "14052.50",
                                "charge": "5"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "28",
                                "monoisotopic_mass": "4087.7238",
                                "monoisotopic_mz": "584.9678",
                                "intensity": "5629.06",
                                "charge": "7"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "29",
                                "monoisotopic_mass": "8685.6267",
                                "monoisotopic_mz": "621.4092",
                                "intensity": "11397.32",
                                "charge": "14"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "30",
                                "monoisotopic_mass": "5592.9919",
                                "monoisotopic_mz": "700.1313",
                                "intensity": "14490.75",
                                "charge": "8"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "31",
                                "monoisotopic_mass": "1125.7951",
                                "monoisotopic_mz": "563.9048",
                                "intensity": "3844.52",
                                "charge": "2"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "32",
                                "monoisotopic_mass": "7528.5781",
                                "monoisotopic_mz": "580.1287",
                                "intensity": "5108.02",
                                "charge": "13"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "33",
                                "monoisotopic_mass": "2993.5864",
                                "monoisotopic_mz": "499.9384",
                                "intensity": "11149.62",
                                "charge": "6"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "34",
                                "monoisotopic_mass": "1493.7714",
                                "monoisotopic_mz": "498.9311",
                                "intensity": "3780.86",
                                "charge": "3"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "35",
                                "monoisotopic_mass": "2949.5347",
                                "monoisotopic_mz": "492.5964",
                                "intensity": "5616.24",
                                "charge": "6"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "36",
                                "monoisotopic_mass": "8088.9226",
                                "monoisotopic_mz": "623.2321",
                                "intensity": "10641.00",
                                "charge": "13"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "37",
                                "monoisotopic_mass": "3675.0331",
                                "monoisotopic_mz": "613.5128",
                                "intensity": "4849.56",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3675.0193",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "B00036",
                                        "ion_left_position": "36",
                                        "mass_error": "0.0137",
                                        "ppm": "3.74"
                                    }
                                }
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "38",
                                "monoisotopic_mass": "1096.7124",
                                "monoisotopic_mz": "549.3635",
                                "intensity": "3764.43",
                                "charge": "2"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "39",
                                "monoisotopic_mass": "1902.8891",
                                "monoisotopic_mz": "635.3036",
                                "intensity": "17547.60",
                                "charge": "3"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "40",
                                "monoisotopic_mass": "3541.0450",
                                "monoisotopic_mz": "591.1814",
                                "intensity": "5385.16",
                                "charge": "6"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "41",
                                "monoisotopic_mass": "4427.3845",
                                "monoisotopic_mz": "554.4303",
                                "intensity": "9956.65",
                                "charge": "8"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "42",
                                "monoisotopic_mass": "2900.2177",
                                "monoisotopic_mz": "581.0508",
                                "intensity": "14639.10",
                                "charge": "5"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "43",
                                "monoisotopic_mass": "4624.3967",
                                "monoisotopic_mz": "579.0569",
                                "intensity": "5807.91",
                                "charge": "8"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "44",
                                "monoisotopic_mass": "2853.5293",
                                "monoisotopic_mz": "714.3896",
                                "intensity": "7320.00",
                                "charge": "4"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "45",
                                "monoisotopic_mass": "556.3598",
                                "monoisotopic_mz": "557.3671",
                                "intensity": "9842.44",
                                "charge": "1"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "46",
                                "monoisotopic_mass": "5705.0673",
                                "monoisotopic_mz": "634.9036",
                                "intensity": "38111.89",
                                "charge": "9"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "47",
                                "monoisotopic_mass": "4111.4445",
                                "monoisotopic_mz": "588.3565",
                                "intensity": "6568.71",
                                "charge": "7"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "48",
                                "monoisotopic_mass": "1062.9931",
                                "monoisotopic_mz": "532.5038",
                                "intensity": "4416.99",
                                "charge": "2"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "49",
                                "monoisotopic_mass": "1158.2196",
                                "monoisotopic_mz": "580.1171",
                                "intensity": "4442.11",
                                "charge": "2"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "50",
                                "monoisotopic_mass": "2454.6565",
                                "monoisotopic_mz": "614.6714",
                                "intensity": "3895.98",
                                "charge": "4"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "51",
                                "monoisotopic_mass": "5809.0888",
                                "monoisotopic_mz": "581.9162",
                                "intensity": "4958.01",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-1.0546949926",
                                        "theoretical_mass": "5810.0837",
                                        "ion_position": "31",
                                        "ion_display_position": "53",
                                        "ion_sort_name": "Y00053",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0075",
                                        "ppm": "1.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "52",
                                "monoisotopic_mass": "1420.2715",
                                "monoisotopic_mz": "711.1430",
                                "intensity": "3020.93",
                                "charge": "2"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "53",
                                "monoisotopic_mass": "1668.7031",
                                "monoisotopic_mz": "557.2416",
                                "intensity": "5096.73",
                                "charge": "3"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "54",
                                "monoisotopic_mass": "2839.0240",
                                "monoisotopic_mz": "710.7633",
                                "intensity": "7829.78",
                                "charge": "4"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "55",
                                "monoisotopic_mass": "1754.3466",
                                "monoisotopic_mz": "585.7895",
                                "intensity": "6027.96",
                                "charge": "3"
                            },
                            {
                                "spec_id": "295",
                                "peak_id": "56",
                                "monoisotopic_mass": "1246.6697",
                                "monoisotopic_mz": "624.3421",
                                "intensity": "4007.37",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "20",
                    "proteoform_id": "30",
                    "sequence_name": "sp|P66131|RL27_SALTY",
                    "sequence_description": "50S ribosomal protein L27 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmA PE=3 SV=2",
                    "proteoform_mass": "9043.8443",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "85",
                        "first_residue_position": "1",
                        "last_residue_position": "84",
                        "annotated_seq": "M.AHKKAGGSTRNGRDSEAKRLGVKRFGGEAVLAGSII(VRQRGTKFHAGTN)[-1.0547]VG(C)[Carbamidomethylation]GRDHTLFAKADGKVKFEVKGPKNRKYISIVAE.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "H"
                            },
                            {
                                "position": "3",
                                "acid": "K"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "A"
                            },
                            {
                                "position": "6",
                                "acid": "G"
                            },
                            {
                                "position": "7",
                                "acid": "G"
                            },
                            {
                                "position": "8",
                                "acid": "S"
                            },
                            {
                                "position": "9",
                                "acid": "T"
                            },
                            {
                                "position": "10",
                                "acid": "R"
                            },
                            {
                                "position": "11",
                                "acid": "N"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "R"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "S"
                            },
                            {
                                "position": "16",
                                "acid": "E"
                            },
                            {
                                "position": "17",
                                "acid": "A"
                            },
                            {
                                "position": "18",
                                "acid": "K"
                            },
                            {
                                "position": "19",
                                "acid": "R"
                            },
                            {
                                "position": "20",
                                "acid": "L"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "V"
                            },
                            {
                                "position": "23",
                                "acid": "K"
                            },
                            {
                                "position": "24",
                                "acid": "R"
                            },
                            {
                                "position": "25",
                                "acid": "F"
                            },
                            {
                                "position": "26",
                                "acid": "G"
                            },
                            {
                                "position": "27",
                                "acid": "G"
                            },
                            {
                                "position": "28",
                                "acid": "E"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "V"
                            },
                            {
                                "position": "31",
                                "acid": "L"
                            },
                            {
                                "position": "32",
                                "acid": "A"
                            },
                            {
                                "position": "33",
                                "acid": "G"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "I"
                            },
                            {
                                "position": "36",
                                "acid": "I"
                            },
                            {
                                "position": "37",
                                "acid": "V"
                            },
                            {
                                "position": "38",
                                "acid": "R"
                            },
                            {
                                "position": "39",
                                "acid": "Q"
                            },
                            {
                                "position": "40",
                                "acid": "R"
                            },
                            {
                                "position": "41",
                                "acid": "G"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "K"
                            },
                            {
                                "position": "44",
                                "acid": "F"
                            },
                            {
                                "position": "45",
                                "acid": "H"
                            },
                            {
                                "position": "46",
                                "acid": "A"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "N"
                            },
                            {
                                "position": "50",
                                "acid": "V"
                            },
                            {
                                "position": "51",
                                "acid": "G"
                            },
                            {
                                "position": "52",
                                "acid": "C"
                            },
                            {
                                "position": "53",
                                "acid": "G"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "D"
                            },
                            {
                                "position": "56",
                                "acid": "H"
                            },
                            {
                                "position": "57",
                                "acid": "T"
                            },
                            {
                                "position": "58",
                                "acid": "L"
                            },
                            {
                                "position": "59",
                                "acid": "F"
                            },
                            {
                                "position": "60",
                                "acid": "A"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "A"
                            },
                            {
                                "position": "63",
                                "acid": "D"
                            },
                            {
                                "position": "64",
                                "acid": "G"
                            },
                            {
                                "position": "65",
                                "acid": "K"
                            },
                            {
                                "position": "66",
                                "acid": "V"
                            },
                            {
                                "position": "67",
                                "acid": "K"
                            },
                            {
                                "position": "68",
                                "acid": "F"
                            },
                            {
                                "position": "69",
                                "acid": "E"
                            },
                            {
                                "position": "70",
                                "acid": "V"
                            },
                            {
                                "position": "71",
                                "acid": "K"
                            },
                            {
                                "position": "72",
                                "acid": "G"
                            },
                            {
                                "position": "73",
                                "acid": "P"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "N"
                            },
                            {
                                "position": "76",
                                "acid": "R"
                            },
                            {
                                "position": "77",
                                "acid": "K"
                            },
                            {
                                "position": "78",
                                "acid": "Y"
                            },
                            {
                                "position": "79",
                                "acid": "I"
                            },
                            {
                                "position": "80",
                                "acid": "S"
                            },
                            {
                                "position": "81",
                                "acid": "I"
                            },
                            {
                                "position": "82",
                                "acid": "V"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "E"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "29",
                                            "ion_display_position": "29",
                                            "spec_id": "295",
                                            "peak_id": "23",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "29",
                                            "ion_display_position": "29",
                                            "spec_id": "295",
                                            "peak_id": "19",
                                            "peak_charge": "5"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "30",
                                        "ion_display_position": "54",
                                        "spec_id": "295",
                                        "peak_id": "24",
                                        "peak_charge": "10"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "31",
                                        "ion_display_position": "53",
                                        "spec_id": "295",
                                        "peak_id": "51",
                                        "peak_charge": "10"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "34",
                                        "ion_display_position": "50",
                                        "spec_id": "295",
                                        "peak_id": "17",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "spec_id": "295",
                                        "peak_id": "37",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "49",
                                        "ion_display_position": "49",
                                        "spec_id": "295",
                                        "peak_id": "10",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "50",
                                        "ion_display_position": "34",
                                        "spec_id": "295",
                                        "peak_id": "26",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "69",
                                        "ion_display_position": "69",
                                        "spec_id": "295",
                                        "peak_id": "11",
                                        "peak_charge": "12"
                                    }
                                }
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "81",
                                            "ion_display_position": "81",
                                            "spec_id": "295",
                                            "peak_id": "8",
                                            "peak_charge": "14"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "81",
                                            "ion_display_position": "81",
                                            "spec_id": "295",
                                            "peak_id": "5",
                                            "peak_charge": "15"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "82",
                                            "ion_display_position": "82",
                                            "spec_id": "295",
                                            "peak_id": "2",
                                            "peak_charge": "15"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "82",
                                            "ion_display_position": "82",
                                            "spec_id": "295",
                                            "peak_id": "1",
                                            "peak_charge": "16"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": {
                                "left_pos": "52",
                                "right_pos": "53",
                                "anno": "C"
                            }
                        },
                        "mass_shift": {
                            "id": "0",
                            "left_position": "37",
                            "right_position": "50",
                            "shift": "-1.0546949926",
                            "anno": "-1.0547",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "38",
                "p_value": "1.25e-03",
                "e_value": "1.25e-03",
                "fdr": "0",
                "matched_fragment_number": "11",
                "matched_peak_number": "16",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                        "ms1_ids": "298",
                        "ms1_scans": "581",
                        "ids": "282",
                        "scans": "582",
                        "precursor_mono_mass": "9044.8031",
                        "precursor_charge": "16",
                        "precursor_mz": "566.3075",
                        "feature_inte": "3.9675e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "282",
                                "peak_id": "0",
                                "monoisotopic_mass": "8826.7118",
                                "monoisotopic_mz": "631.4867",
                                "intensity": "610009.65",
                                "charge": "14",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-1.0531849926",
                                        "theoretical_mass": "8825.7555",
                                        "ion_position": "82",
                                        "ion_display_position": "82",
                                        "ion_sort_name": "B00082",
                                        "ion_left_position": "82",
                                        "mass_error": "-0.0460",
                                        "ppm": "-5.21"
                                    }
                                }
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "1",
                                "monoisotopic_mass": "8798.6939",
                                "monoisotopic_mz": "629.4854",
                                "intensity": "524068.48",
                                "charge": "14"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "2",
                                "monoisotopic_mass": "8897.7601",
                                "monoisotopic_mz": "594.1913",
                                "intensity": "407683.75",
                                "charge": "15",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-1.0531849926",
                                        "theoretical_mass": "8896.7926",
                                        "ion_position": "83",
                                        "ion_display_position": "83",
                                        "ion_sort_name": "B00083",
                                        "ion_left_position": "83",
                                        "mass_error": "-0.0349",
                                        "ppm": "-3.92"
                                    }
                                }
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "3",
                                "monoisotopic_mass": "8826.7272",
                                "monoisotopic_mz": "589.4558",
                                "intensity": "438120.84",
                                "charge": "15",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-1.0531849926",
                                        "theoretical_mass": "8825.7555",
                                        "ion_position": "82",
                                        "ion_display_position": "82",
                                        "ion_sort_name": "B00082",
                                        "ion_left_position": "82",
                                        "mass_error": "-0.0306",
                                        "ppm": "-3.47"
                                    }
                                }
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "4",
                                "monoisotopic_mass": "8727.6532",
                                "monoisotopic_mz": "624.4111",
                                "intensity": "723587.06",
                                "charge": "14",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-1.0531849926",
                                        "theoretical_mass": "8726.6871",
                                        "ion_position": "81",
                                        "ion_display_position": "81",
                                        "ion_sort_name": "B00081",
                                        "ion_left_position": "81",
                                        "mass_error": "-0.0363",
                                        "ppm": "-4.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "5",
                                "monoisotopic_mass": "8798.7277",
                                "monoisotopic_mz": "587.5891",
                                "intensity": "206732.61",
                                "charge": "15"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "6",
                                "monoisotopic_mass": "8699.6687",
                                "monoisotopic_mz": "580.9852",
                                "intensity": "64783.02",
                                "charge": "15"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "7",
                                "monoisotopic_mass": "8780.6752",
                                "monoisotopic_mz": "628.1984",
                                "intensity": "237170.52",
                                "charge": "14"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "8",
                                "monoisotopic_mass": "8727.6516",
                                "monoisotopic_mz": "672.3651",
                                "intensity": "85169.56",
                                "charge": "13",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-1.0531849926",
                                        "theoretical_mass": "8726.6871",
                                        "ion_position": "81",
                                        "ion_display_position": "81",
                                        "ion_sort_name": "B00081",
                                        "ion_left_position": "81",
                                        "mass_error": "-0.0378",
                                        "ppm": "-4.33"
                                    }
                                }
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "9",
                                "monoisotopic_mass": "8869.7661",
                                "monoisotopic_mz": "592.3250",
                                "intensity": "228834.71",
                                "charge": "15"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "10",
                                "monoisotopic_mass": "8710.6505",
                                "monoisotopic_mz": "623.1966",
                                "intensity": "233282.92",
                                "charge": "14"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "11",
                                "monoisotopic_mass": "8851.7606",
                                "monoisotopic_mz": "591.1247",
                                "intensity": "53724.35",
                                "charge": "15"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "12",
                                "monoisotopic_mass": "6655.4619",
                                "monoisotopic_mz": "606.0493",
                                "intensity": "89381.89",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-1.0531849926",
                                        "theoretical_mass": "6654.4612",
                                        "ion_position": "63",
                                        "ion_display_position": "63",
                                        "ion_sort_name": "B00063",
                                        "ion_left_position": "63",
                                        "mass_error": "-0.0017",
                                        "ppm": "-0.25"
                                    }
                                }
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "13",
                                "monoisotopic_mass": "5127.7400",
                                "monoisotopic_mz": "641.9748",
                                "intensity": "147260.26",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-1.0531849926",
                                        "theoretical_mass": "5126.7360",
                                        "ion_position": "49",
                                        "ion_display_position": "49",
                                        "ion_sort_name": "B00049",
                                        "ion_left_position": "49",
                                        "mass_error": "0.0016",
                                        "ppm": "0.32"
                                    }
                                }
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "14",
                                "monoisotopic_mass": "5592.9947",
                                "monoisotopic_mz": "700.1316",
                                "intensity": "140192.28",
                                "charge": "8"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "15",
                                "monoisotopic_mass": "7955.1921",
                                "monoisotopic_mz": "612.9451",
                                "intensity": "64397.48",
                                "charge": "13"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "16",
                                "monoisotopic_mass": "8781.7226",
                                "monoisotopic_mz": "586.4555",
                                "intensity": "76187.35",
                                "charge": "15"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "17",
                                "monoisotopic_mass": "7938.7727",
                                "monoisotopic_mz": "611.6821",
                                "intensity": "16449.06",
                                "charge": "13"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "18",
                                "monoisotopic_mass": "8685.6156",
                                "monoisotopic_mz": "621.4084",
                                "intensity": "102969.96",
                                "charge": "14"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "19",
                                "monoisotopic_mass": "5777.1143",
                                "monoisotopic_mz": "723.1466",
                                "intensity": "150731.32",
                                "charge": "8"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "20",
                                "monoisotopic_mass": "5706.0807",
                                "monoisotopic_mz": "714.2674",
                                "intensity": "98922.90",
                                "charge": "8"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "21",
                                "monoisotopic_mass": "5924.1581",
                                "monoisotopic_mz": "659.2471",
                                "intensity": "73707.27",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-1.0531849926",
                                        "theoretical_mass": "5923.1692",
                                        "ion_position": "30",
                                        "ion_display_position": "54",
                                        "ion_sort_name": "Y00054",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0135",
                                        "ppm": "-2.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "22",
                                "monoisotopic_mass": "3092.6503",
                                "monoisotopic_mz": "442.8145",
                                "intensity": "23624.70",
                                "charge": "7"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "23",
                                "monoisotopic_mass": "8684.5899",
                                "monoisotopic_mz": "669.0527",
                                "intensity": "48496.45",
                                "charge": "13"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "24",
                                "monoisotopic_mass": "8683.6631",
                                "monoisotopic_mz": "579.9182",
                                "intensity": "17040.22",
                                "charge": "15"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "25",
                                "monoisotopic_mass": "8769.6771",
                                "monoisotopic_mz": "627.4128",
                                "intensity": "152495.93",
                                "charge": "14"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "26",
                                "monoisotopic_mass": "5811.0729",
                                "monoisotopic_mz": "646.6820",
                                "intensity": "54274.25",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-1.0531849926",
                                        "theoretical_mass": "5810.0852",
                                        "ion_position": "31",
                                        "ion_display_position": "53",
                                        "ion_sort_name": "Y00053",
                                        "ion_left_position": "31",
                                        "mass_error": "-0.0146",
                                        "ppm": "-2.52"
                                    }
                                }
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "27",
                                "monoisotopic_mass": "8169.7399",
                                "monoisotopic_mz": "584.5601",
                                "intensity": "38443.37",
                                "charge": "14"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "28",
                                "monoisotopic_mass": "3021.5788",
                                "monoisotopic_mz": "605.3230",
                                "intensity": "178422.75",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3021.6081",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "-0.0293",
                                        "ppm": "-9.70"
                                    }
                                }
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "29",
                                "monoisotopic_mass": "3021.5803",
                                "monoisotopic_mz": "504.6040",
                                "intensity": "241819.48",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3021.6081",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "-0.0278",
                                        "ppm": "-9.20"
                                    }
                                }
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "30",
                                "monoisotopic_mass": "1981.3583",
                                "monoisotopic_mz": "199.1431",
                                "intensity": "12444.96",
                                "charge": "10"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "31",
                                "monoisotopic_mass": "8810.7098",
                                "monoisotopic_mz": "630.3437",
                                "intensity": "77014.24",
                                "charge": "14"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "32",
                                "monoisotopic_mass": "3599.9130",
                                "monoisotopic_mz": "600.9928",
                                "intensity": "23391.49",
                                "charge": "6"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "33",
                                "monoisotopic_mass": "4783.5940",
                                "monoisotopic_mz": "598.9565",
                                "intensity": "28529.51",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-1.0531849926",
                                        "theoretical_mass": "4783.5868",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "B00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0072",
                                        "ppm": "1.51"
                                    }
                                }
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "34",
                                "monoisotopic_mass": "4317.2951",
                                "monoisotopic_mz": "617.7637",
                                "intensity": "13970.20",
                                "charge": "7"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "35",
                                "monoisotopic_mass": "5777.1220",
                                "monoisotopic_mz": "642.9097",
                                "intensity": "44661.89",
                                "charge": "9"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "36",
                                "monoisotopic_mass": "5522.0051",
                                "monoisotopic_mz": "691.2579",
                                "intensity": "24463.89",
                                "charge": "8"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "37",
                                "monoisotopic_mass": "8653.6277",
                                "monoisotopic_mz": "619.1235",
                                "intensity": "38752.02",
                                "charge": "14"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "38",
                                "monoisotopic_mass": "3091.6543",
                                "monoisotopic_mz": "516.2830",
                                "intensity": "18324.30",
                                "charge": "6"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "39",
                                "monoisotopic_mass": "8809.7343",
                                "monoisotopic_mz": "588.3229",
                                "intensity": "89590.05",
                                "charge": "15"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "40",
                                "monoisotopic_mass": "5664.0310",
                                "monoisotopic_mz": "709.0111",
                                "intensity": "120216.67",
                                "charge": "8"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "41",
                                "monoisotopic_mass": "8739.6639",
                                "monoisotopic_mz": "625.2690",
                                "intensity": "47540.86",
                                "charge": "14"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "42",
                                "monoisotopic_mass": "8880.7719",
                                "monoisotopic_mz": "593.0587",
                                "intensity": "69180.63",
                                "charge": "15"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "43",
                                "monoisotopic_mass": "1302.8813",
                                "monoisotopic_mz": "652.4479",
                                "intensity": "16737.39",
                                "charge": "2"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "44",
                                "monoisotopic_mass": "8624.6031",
                                "monoisotopic_mz": "617.0504",
                                "intensity": "28164.19",
                                "charge": "14"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "45",
                                "monoisotopic_mass": "1350.6162",
                                "monoisotopic_mz": "676.3154",
                                "intensity": "5384.36",
                                "charge": "2"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "46",
                                "monoisotopic_mass": "1838.4832",
                                "monoisotopic_mz": "613.8350",
                                "intensity": "7194.32",
                                "charge": "3"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "47",
                                "monoisotopic_mass": "7863.7627",
                                "monoisotopic_mz": "656.3208",
                                "intensity": "11518.83",
                                "charge": "12"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "48",
                                "monoisotopic_mass": "4092.8538",
                                "monoisotopic_mz": "585.7007",
                                "intensity": "47183.69",
                                "charge": "7"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "49",
                                "monoisotopic_mass": "699.8771",
                                "monoisotopic_mz": "700.8843",
                                "intensity": "6836.57",
                                "charge": "1"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "50",
                                "monoisotopic_mass": "5127.7562",
                                "monoisotopic_mz": "570.7580",
                                "intensity": "20571.58",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-1.0531849926",
                                        "theoretical_mass": "5126.7360",
                                        "ion_position": "49",
                                        "ion_display_position": "49",
                                        "ion_sort_name": "B00049",
                                        "ion_left_position": "49",
                                        "mass_error": "0.0178",
                                        "ppm": "3.48"
                                    }
                                }
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "51",
                                "monoisotopic_mass": "5226.8340",
                                "monoisotopic_mz": "581.7666",
                                "intensity": "27693.27",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-1.0531849926",
                                        "theoretical_mass": "5225.8044",
                                        "ion_position": "50",
                                        "ion_display_position": "50",
                                        "ion_sort_name": "B00050",
                                        "ion_left_position": "50",
                                        "mass_error": "0.0272",
                                        "ppm": "5.21"
                                    }
                                }
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "52",
                                "monoisotopic_mass": "6655.5245",
                                "monoisotopic_mz": "666.5597",
                                "intensity": "18253.02",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-1.0531849926",
                                        "theoretical_mass": "6654.4612",
                                        "ion_position": "63",
                                        "ion_display_position": "63",
                                        "ion_sort_name": "B00063",
                                        "ion_left_position": "63",
                                        "mass_error": "0.0609",
                                        "ppm": "9.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "53",
                                "monoisotopic_mass": "3818.0055",
                                "monoisotopic_mz": "637.3415",
                                "intensity": "9458.57",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3818.0414",
                                        "ion_position": "50",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "Y00034",
                                        "ion_left_position": "50",
                                        "mass_error": "-0.0359",
                                        "ppm": "-9.40"
                                    }
                                }
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "54",
                                "monoisotopic_mass": "722.1405",
                                "monoisotopic_mz": "723.1478",
                                "intensity": "9007.40",
                                "charge": "1"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "55",
                                "monoisotopic_mass": "2992.5802",
                                "monoisotopic_mz": "499.7707",
                                "intensity": "14722.17",
                                "charge": "6"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "56",
                                "monoisotopic_mass": "1482.8905",
                                "monoisotopic_mz": "495.3041",
                                "intensity": "11021.93",
                                "charge": "3"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "57",
                                "monoisotopic_mass": "8596.5399",
                                "monoisotopic_mz": "615.0458",
                                "intensity": "30319.11",
                                "charge": "14"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "58",
                                "monoisotopic_mass": "3119.6437",
                                "monoisotopic_mz": "520.9479",
                                "intensity": "70006.60",
                                "charge": "6"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "59",
                                "monoisotopic_mass": "2908.8860",
                                "monoisotopic_mz": "582.7845",
                                "intensity": "29932.45",
                                "charge": "5"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "60",
                                "monoisotopic_mass": "2497.9167",
                                "monoisotopic_mz": "625.4865",
                                "intensity": "28095.05",
                                "charge": "4"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "61",
                                "monoisotopic_mass": "1222.1391",
                                "monoisotopic_mz": "612.0768",
                                "intensity": "4822.38",
                                "charge": "2"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "62",
                                "monoisotopic_mass": "7999.4426",
                                "monoisotopic_mz": "667.6275",
                                "intensity": "16866.83",
                                "charge": "12"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "63",
                                "monoisotopic_mass": "5992.0947",
                                "monoisotopic_mz": "600.2167",
                                "intensity": "16970.30",
                                "charge": "10"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "64",
                                "monoisotopic_mass": "2377.9497",
                                "monoisotopic_mz": "199.1698",
                                "intensity": "11678.65",
                                "charge": "12"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "65",
                                "monoisotopic_mass": "1062.8991",
                                "monoisotopic_mz": "532.4568",
                                "intensity": "6915.10",
                                "charge": "2"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "66",
                                "monoisotopic_mass": "4380.3399",
                                "monoisotopic_mz": "626.7701",
                                "intensity": "34997.09",
                                "charge": "7"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "67",
                                "monoisotopic_mass": "7616.2543",
                                "monoisotopic_mz": "586.8730",
                                "intensity": "10608.96",
                                "charge": "13"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "68",
                                "monoisotopic_mass": "3805.1588",
                                "monoisotopic_mz": "635.2004",
                                "intensity": "11807.84",
                                "charge": "6"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "69",
                                "monoisotopic_mass": "619.4722",
                                "monoisotopic_mz": "620.4795",
                                "intensity": "20064.98",
                                "charge": "1"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "70",
                                "monoisotopic_mass": "991.0994",
                                "monoisotopic_mz": "199.2272",
                                "intensity": "8916.12",
                                "charge": "5"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "71",
                                "monoisotopic_mass": "1161.8250",
                                "monoisotopic_mz": "581.9198",
                                "intensity": "10581.87",
                                "charge": "2"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "72",
                                "monoisotopic_mass": "4959.5842",
                                "monoisotopic_mz": "620.9553",
                                "intensity": "8864.17",
                                "charge": "8"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "73",
                                "monoisotopic_mass": "1257.9603",
                                "monoisotopic_mz": "629.9874",
                                "intensity": "48442.50",
                                "charge": "2"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "74",
                                "monoisotopic_mass": "2515.1987",
                                "monoisotopic_mz": "629.8070",
                                "intensity": "23654.24",
                                "charge": "4"
                            },
                            {
                                "spec_id": "282",
                                "peak_id": "75",
                                "monoisotopic_mass": "1893.2398",
                                "monoisotopic_mz": "632.0872",
                                "intensity": "11161.42",
                                "charge": "3"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "20",
                    "proteoform_id": "30",
                    "sequence_name": "sp|P66131|RL27_SALTY",
                    "sequence_description": "50S ribosomal protein L27 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmA PE=3 SV=2",
                    "proteoform_mass": "9043.8458",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "85",
                        "first_residue_position": "1",
                        "last_residue_position": "84",
                        "annotated_seq": "M.AHKKAGGSTRNGRDSEAKRLGVKRFGGEAVL(AGSIIVRQRGTKFH)[-1.0532]AGTNVG(C)[Carbamidomethylation]GRDHTLFAKADGKVKFEVKGPKNRKYISIVAE.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "H"
                            },
                            {
                                "position": "3",
                                "acid": "K"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "A"
                            },
                            {
                                "position": "6",
                                "acid": "G"
                            },
                            {
                                "position": "7",
                                "acid": "G"
                            },
                            {
                                "position": "8",
                                "acid": "S"
                            },
                            {
                                "position": "9",
                                "acid": "T"
                            },
                            {
                                "position": "10",
                                "acid": "R"
                            },
                            {
                                "position": "11",
                                "acid": "N"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "R"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "S"
                            },
                            {
                                "position": "16",
                                "acid": "E"
                            },
                            {
                                "position": "17",
                                "acid": "A"
                            },
                            {
                                "position": "18",
                                "acid": "K"
                            },
                            {
                                "position": "19",
                                "acid": "R"
                            },
                            {
                                "position": "20",
                                "acid": "L"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "V"
                            },
                            {
                                "position": "23",
                                "acid": "K"
                            },
                            {
                                "position": "24",
                                "acid": "R"
                            },
                            {
                                "position": "25",
                                "acid": "F"
                            },
                            {
                                "position": "26",
                                "acid": "G"
                            },
                            {
                                "position": "27",
                                "acid": "G"
                            },
                            {
                                "position": "28",
                                "acid": "E"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "V"
                            },
                            {
                                "position": "31",
                                "acid": "L"
                            },
                            {
                                "position": "32",
                                "acid": "A"
                            },
                            {
                                "position": "33",
                                "acid": "G"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "I"
                            },
                            {
                                "position": "36",
                                "acid": "I"
                            },
                            {
                                "position": "37",
                                "acid": "V"
                            },
                            {
                                "position": "38",
                                "acid": "R"
                            },
                            {
                                "position": "39",
                                "acid": "Q"
                            },
                            {
                                "position": "40",
                                "acid": "R"
                            },
                            {
                                "position": "41",
                                "acid": "G"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "K"
                            },
                            {
                                "position": "44",
                                "acid": "F"
                            },
                            {
                                "position": "45",
                                "acid": "H"
                            },
                            {
                                "position": "46",
                                "acid": "A"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "N"
                            },
                            {
                                "position": "50",
                                "acid": "V"
                            },
                            {
                                "position": "51",
                                "acid": "G"
                            },
                            {
                                "position": "52",
                                "acid": "C"
                            },
                            {
                                "position": "53",
                                "acid": "G"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "D"
                            },
                            {
                                "position": "56",
                                "acid": "H"
                            },
                            {
                                "position": "57",
                                "acid": "T"
                            },
                            {
                                "position": "58",
                                "acid": "L"
                            },
                            {
                                "position": "59",
                                "acid": "F"
                            },
                            {
                                "position": "60",
                                "acid": "A"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "A"
                            },
                            {
                                "position": "63",
                                "acid": "D"
                            },
                            {
                                "position": "64",
                                "acid": "G"
                            },
                            {
                                "position": "65",
                                "acid": "K"
                            },
                            {
                                "position": "66",
                                "acid": "V"
                            },
                            {
                                "position": "67",
                                "acid": "K"
                            },
                            {
                                "position": "68",
                                "acid": "F"
                            },
                            {
                                "position": "69",
                                "acid": "E"
                            },
                            {
                                "position": "70",
                                "acid": "V"
                            },
                            {
                                "position": "71",
                                "acid": "K"
                            },
                            {
                                "position": "72",
                                "acid": "G"
                            },
                            {
                                "position": "73",
                                "acid": "P"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "N"
                            },
                            {
                                "position": "76",
                                "acid": "R"
                            },
                            {
                                "position": "77",
                                "acid": "K"
                            },
                            {
                                "position": "78",
                                "acid": "Y"
                            },
                            {
                                "position": "79",
                                "acid": "I"
                            },
                            {
                                "position": "80",
                                "acid": "S"
                            },
                            {
                                "position": "81",
                                "acid": "I"
                            },
                            {
                                "position": "82",
                                "acid": "V"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "E"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "29",
                                            "ion_display_position": "29",
                                            "spec_id": "282",
                                            "peak_id": "28",
                                            "peak_charge": "5"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "29",
                                            "ion_display_position": "29",
                                            "spec_id": "282",
                                            "peak_id": "29",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "30",
                                        "ion_display_position": "54",
                                        "spec_id": "282",
                                        "peak_id": "21",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "31",
                                        "ion_display_position": "53",
                                        "spec_id": "282",
                                        "peak_id": "26",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "282",
                                        "peak_id": "33",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "49",
                                            "ion_display_position": "49",
                                            "spec_id": "282",
                                            "peak_id": "13",
                                            "peak_charge": "8"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "49",
                                            "ion_display_position": "49",
                                            "spec_id": "282",
                                            "peak_id": "50",
                                            "peak_charge": "9"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "50",
                                            "ion_display_position": "34",
                                            "spec_id": "282",
                                            "peak_id": "53",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "50",
                                            "ion_display_position": "50",
                                            "spec_id": "282",
                                            "peak_id": "51",
                                            "peak_charge": "9"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "63",
                                            "ion_display_position": "63",
                                            "spec_id": "282",
                                            "peak_id": "12",
                                            "peak_charge": "11"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "63",
                                            "ion_display_position": "63",
                                            "spec_id": "282",
                                            "peak_id": "52",
                                            "peak_charge": "10"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "81",
                                            "ion_display_position": "81",
                                            "spec_id": "282",
                                            "peak_id": "8",
                                            "peak_charge": "13"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "81",
                                            "ion_display_position": "81",
                                            "spec_id": "282",
                                            "peak_id": "4",
                                            "peak_charge": "14"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "82",
                                            "ion_display_position": "82",
                                            "spec_id": "282",
                                            "peak_id": "0",
                                            "peak_charge": "14"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "82",
                                            "ion_display_position": "82",
                                            "spec_id": "282",
                                            "peak_id": "3",
                                            "peak_charge": "15"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "83",
                                        "ion_display_position": "83",
                                        "spec_id": "282",
                                        "peak_id": "2",
                                        "peak_charge": "15"
                                    }
                                }
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": {
                                "left_pos": "52",
                                "right_pos": "53",
                                "anno": "C"
                            }
                        },
                        "mass_shift": {
                            "id": "0",
                            "left_position": "32",
                            "right_position": "46",
                            "shift": "-1.0531849926",
                            "anno": "-1.0532",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "37",
                "p_value": "0.18",
                "e_value": "0.20",
                "fdr": "0",
                "matched_fragment_number": "6",
                "matched_peak_number": "9",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                        "ms1_ids": "297",
                        "ms1_scans": "579",
                        "ids": "281",
                        "scans": "580",
                        "precursor_mono_mass": "9044.8031",
                        "precursor_charge": "15",
                        "precursor_mz": "603.9942",
                        "feature_inte": "3.9675e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "281",
                                "peak_id": "0",
                                "monoisotopic_mass": "8781.6599",
                                "monoisotopic_mz": "676.5196",
                                "intensity": "110917.25",
                                "charge": "13"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "1",
                                "monoisotopic_mass": "8826.7281",
                                "monoisotopic_mz": "631.4879",
                                "intensity": "1224198.00",
                                "charge": "14",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-131.1213300812",
                                        "theoretical_mass": "8826.7278",
                                        "ion_position": "83",
                                        "ion_display_position": "83",
                                        "ion_sort_name": "B00083",
                                        "ion_left_position": "83",
                                        "mass_error": "0.0002",
                                        "ppm": "0.03"
                                    }
                                }
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "2",
                                "monoisotopic_mass": "8897.7586",
                                "monoisotopic_mz": "636.5615",
                                "intensity": "1399737.70",
                                "charge": "14",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-131.1213300812",
                                        "theoretical_mass": "8897.7650",
                                        "ion_position": "84",
                                        "ion_display_position": "84",
                                        "ion_sort_name": "B00084",
                                        "ion_left_position": "84",
                                        "mass_error": "-0.0064",
                                        "ppm": "-0.72"
                                    }
                                }
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "3",
                                "monoisotopic_mass": "8912.7592",
                                "monoisotopic_mz": "637.6329",
                                "intensity": "101688.27",
                                "charge": "14",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-131.1213300812",
                                        "theoretical_mass": "8913.7776",
                                        "ion_position": "1",
                                        "ion_display_position": "84",
                                        "ion_sort_name": "Y00084",
                                        "ion_left_position": "1",
                                        "mass_error": "-0.0161",
                                        "ppm": "-1.80"
                                    }
                                }
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "4",
                                "monoisotopic_mass": "8727.6447",
                                "monoisotopic_mz": "672.3646",
                                "intensity": "423252.01",
                                "charge": "13",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-131.1213300812",
                                        "theoretical_mass": "8727.6594",
                                        "ion_position": "82",
                                        "ion_display_position": "82",
                                        "ion_sort_name": "B00082",
                                        "ion_left_position": "82",
                                        "mass_error": "-0.0147",
                                        "ppm": "-1.69"
                                    }
                                }
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "5",
                                "monoisotopic_mass": "8727.6651",
                                "monoisotopic_mz": "624.4119",
                                "intensity": "152922.03",
                                "charge": "14",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-131.1213300812",
                                        "theoretical_mass": "8727.6594",
                                        "ion_position": "82",
                                        "ion_display_position": "82",
                                        "ion_sort_name": "B00082",
                                        "ion_left_position": "82",
                                        "mass_error": "0.0057",
                                        "ppm": "0.65"
                                    }
                                }
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "6",
                                "monoisotopic_mass": "8797.6843",
                                "monoisotopic_mz": "677.7522",
                                "intensity": "342967.47",
                                "charge": "13"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "7",
                                "monoisotopic_mass": "8825.7108",
                                "monoisotopic_mz": "679.9081",
                                "intensity": "343255.23",
                                "charge": "13",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-131.1213300812",
                                        "theoretical_mass": "8826.7278",
                                        "ion_position": "83",
                                        "ion_display_position": "83",
                                        "ion_sort_name": "B00083",
                                        "ion_left_position": "83",
                                        "mass_error": "-0.0147",
                                        "ppm": "-1.67"
                                    }
                                }
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "8",
                                "monoisotopic_mass": "1981.2927",
                                "monoisotopic_mz": "199.1365",
                                "intensity": "14426.72",
                                "charge": "10"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "9",
                                "monoisotopic_mass": "7140.8986",
                                "monoisotopic_mz": "650.1799",
                                "intensity": "22658.05",
                                "charge": "11"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "10",
                                "monoisotopic_mass": "8879.7408",
                                "monoisotopic_mz": "635.2745",
                                "intensity": "286559.00",
                                "charge": "14"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "11",
                                "monoisotopic_mass": "8797.7172",
                                "monoisotopic_mz": "629.4156",
                                "intensity": "245470.38",
                                "charge": "14"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "12",
                                "monoisotopic_mass": "8708.6434",
                                "monoisotopic_mz": "670.9029",
                                "intensity": "128076.25",
                                "charge": "13",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8708.7080",
                                        "ion_position": "4",
                                        "ion_display_position": "81",
                                        "ion_sort_name": "Y00081",
                                        "ion_left_position": "4",
                                        "mass_error": "-0.0646",
                                        "ppm": "-7.42"
                                    }
                                }
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "13",
                                "monoisotopic_mass": "8781.7083",
                                "monoisotopic_mz": "628.2722",
                                "intensity": "92130.81",
                                "charge": "14"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "14",
                                "monoisotopic_mass": "6654.4419",
                                "monoisotopic_mz": "666.4515",
                                "intensity": "77308.99",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-131.1213300812",
                                        "theoretical_mass": "6655.4336",
                                        "ion_position": "64",
                                        "ion_display_position": "64",
                                        "ion_sort_name": "B00064",
                                        "ion_left_position": "64",
                                        "mass_error": "0.0107",
                                        "ppm": "1.61"
                                    }
                                }
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "15",
                                "monoisotopic_mass": "8810.6952",
                                "monoisotopic_mz": "630.3426",
                                "intensity": "234875.43",
                                "charge": "14"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "16",
                                "monoisotopic_mass": "6463.4294",
                                "monoisotopic_mz": "647.3502",
                                "intensity": "91904.71",
                                "charge": "10"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "17",
                                "monoisotopic_mass": "2563.8659",
                                "monoisotopic_mz": "641.9738",
                                "intensity": "35797.20",
                                "charge": "4"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "18",
                                "monoisotopic_mass": "6351.3357",
                                "monoisotopic_mz": "636.1408",
                                "intensity": "209530.39",
                                "charge": "10"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "19",
                                "monoisotopic_mass": "4718.9792",
                                "monoisotopic_mz": "675.1472",
                                "intensity": "21180.22",
                                "charge": "7"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "20",
                                "monoisotopic_mass": "8689.6046",
                                "monoisotopic_mz": "669.4384",
                                "intensity": "37428.90",
                                "charge": "13"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "21",
                                "monoisotopic_mass": "8708.6236",
                                "monoisotopic_mz": "623.0518",
                                "intensity": "43246.43",
                                "charge": "14",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8708.7080",
                                        "ion_position": "4",
                                        "ion_display_position": "81",
                                        "ion_sort_name": "Y00081",
                                        "ion_left_position": "4",
                                        "mass_error": "-0.0843",
                                        "ppm": "-9.68"
                                    }
                                }
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "22",
                                "monoisotopic_mass": "5001.8283",
                                "monoisotopic_mz": "626.2358",
                                "intensity": "20085.50",
                                "charge": "8"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "23",
                                "monoisotopic_mass": "7870.2446",
                                "monoisotopic_mz": "656.8610",
                                "intensity": "14648.90",
                                "charge": "12"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "24",
                                "monoisotopic_mass": "651.3497",
                                "monoisotopic_mz": "652.3569",
                                "intensity": "13020.75",
                                "charge": "1"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "25",
                                "monoisotopic_mass": "5822.2081",
                                "monoisotopic_mz": "647.9193",
                                "intensity": "21207.48",
                                "charge": "9"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "26",
                                "monoisotopic_mass": "5764.7614",
                                "monoisotopic_mz": "721.6025",
                                "intensity": "22331.00",
                                "charge": "8"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "27",
                                "monoisotopic_mass": "7491.4611",
                                "monoisotopic_mz": "625.2957",
                                "intensity": "23558.50",
                                "charge": "12"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "28",
                                "monoisotopic_mass": "5588.9845",
                                "monoisotopic_mz": "622.0056",
                                "intensity": "46300.33",
                                "charge": "9"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "29",
                                "monoisotopic_mass": "2487.2584",
                                "monoisotopic_mz": "622.8219",
                                "intensity": "9538.09",
                                "charge": "4"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "30",
                                "monoisotopic_mass": "8853.7326",
                                "monoisotopic_mz": "633.4167",
                                "intensity": "93699.84",
                                "charge": "14"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "31",
                                "monoisotopic_mass": "1326.7154",
                                "monoisotopic_mz": "664.3650",
                                "intensity": "12217.54",
                                "charge": "2"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "32",
                                "monoisotopic_mass": "1356.7221",
                                "monoisotopic_mz": "679.3683",
                                "intensity": "13577.30",
                                "charge": "2"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "33",
                                "monoisotopic_mass": "7518.1695",
                                "monoisotopic_mz": "627.5214",
                                "intensity": "28951.85",
                                "charge": "12"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "34",
                                "monoisotopic_mass": "1311.4238",
                                "monoisotopic_mz": "656.7192",
                                "intensity": "10698.79",
                                "charge": "2"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "35",
                                "monoisotopic_mass": "4047.4469",
                                "monoisotopic_mz": "675.5818",
                                "intensity": "53541.41",
                                "charge": "6"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "36",
                                "monoisotopic_mass": "7225.8952",
                                "monoisotopic_mz": "723.5968",
                                "intensity": "36436.86",
                                "charge": "10"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "37",
                                "monoisotopic_mass": "3120.6578",
                                "monoisotopic_mz": "625.1388",
                                "intensity": "35982.84",
                                "charge": "5"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "38",
                                "monoisotopic_mass": "1446.3887",
                                "monoisotopic_mz": "724.2016",
                                "intensity": "9882.73",
                                "charge": "2"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "39",
                                "monoisotopic_mass": "5644.2813",
                                "monoisotopic_mz": "706.5424",
                                "intensity": "40711.46",
                                "charge": "8"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "40",
                                "monoisotopic_mass": "593.4172",
                                "monoisotopic_mz": "198.8130",
                                "intensity": "14931.31",
                                "charge": "3"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "41",
                                "monoisotopic_mass": "622.4759",
                                "monoisotopic_mz": "623.4832",
                                "intensity": "25137.54",
                                "charge": "1"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "42",
                                "monoisotopic_mass": "4742.7063",
                                "monoisotopic_mz": "678.5367",
                                "intensity": "39788.20",
                                "charge": "7"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "43",
                                "monoisotopic_mass": "4420.3705",
                                "monoisotopic_mz": "632.4888",
                                "intensity": "47287.15",
                                "charge": "7"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "44",
                                "monoisotopic_mass": "2676.0391",
                                "monoisotopic_mz": "670.0171",
                                "intensity": "26835.24",
                                "charge": "4"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "45",
                                "monoisotopic_mass": "4434.8721",
                                "monoisotopic_mz": "634.5604",
                                "intensity": "79676.85",
                                "charge": "7"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "46",
                                "monoisotopic_mass": "3477.8777",
                                "monoisotopic_mz": "696.5828",
                                "intensity": "34202.12",
                                "charge": "5"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "47",
                                "monoisotopic_mass": "3336.9222",
                                "monoisotopic_mz": "668.3917",
                                "intensity": "32580.23",
                                "charge": "5"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "48",
                                "monoisotopic_mass": "7763.9691",
                                "monoisotopic_mz": "706.8226",
                                "intensity": "42520.50",
                                "charge": "11"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "49",
                                "monoisotopic_mass": "4005.2986",
                                "monoisotopic_mz": "668.5570",
                                "intensity": "29323.25",
                                "charge": "6"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "50",
                                "monoisotopic_mass": "4385.8591",
                                "monoisotopic_mz": "627.5586",
                                "intensity": "20990.68",
                                "charge": "7"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "51",
                                "monoisotopic_mass": "5420.2647",
                                "monoisotopic_mz": "678.5404",
                                "intensity": "12080.41",
                                "charge": "8"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "52",
                                "monoisotopic_mass": "3797.6339",
                                "monoisotopic_mz": "633.9463",
                                "intensity": "19238.99",
                                "charge": "6"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "53",
                                "monoisotopic_mass": "2516.9170",
                                "monoisotopic_mz": "630.2365",
                                "intensity": "80773.44",
                                "charge": "4"
                            },
                            {
                                "spec_id": "281",
                                "peak_id": "54",
                                "monoisotopic_mass": "1411.7696",
                                "monoisotopic_mz": "706.8921",
                                "intensity": "14172.11",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "20",
                    "proteoform_id": "30",
                    "sequence_name": "sp|P66131|RL27_SALTY",
                    "sequence_description": "50S ribosomal protein L27 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmA PE=3 SV=2",
                    "proteoform_mass": "9044.8181",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "85",
                        "first_residue_position": "0",
                        "last_residue_position": "84",
                        "annotated_seq": ".M(AHK)[-131.1213]KAGGSTRNGRDSEAKRLGVKRFGGEAVLAGSIIVRQRGTKFHAGTNVG(C)[Carbamidomethylation]GRDHTLFAKADGKVKFEVKGPKNRKYISIVAE.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "H"
                            },
                            {
                                "position": "3",
                                "acid": "K"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "A"
                            },
                            {
                                "position": "6",
                                "acid": "G"
                            },
                            {
                                "position": "7",
                                "acid": "G"
                            },
                            {
                                "position": "8",
                                "acid": "S"
                            },
                            {
                                "position": "9",
                                "acid": "T"
                            },
                            {
                                "position": "10",
                                "acid": "R"
                            },
                            {
                                "position": "11",
                                "acid": "N"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "R"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "S"
                            },
                            {
                                "position": "16",
                                "acid": "E"
                            },
                            {
                                "position": "17",
                                "acid": "A"
                            },
                            {
                                "position": "18",
                                "acid": "K"
                            },
                            {
                                "position": "19",
                                "acid": "R"
                            },
                            {
                                "position": "20",
                                "acid": "L"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "V"
                            },
                            {
                                "position": "23",
                                "acid": "K"
                            },
                            {
                                "position": "24",
                                "acid": "R"
                            },
                            {
                                "position": "25",
                                "acid": "F"
                            },
                            {
                                "position": "26",
                                "acid": "G"
                            },
                            {
                                "position": "27",
                                "acid": "G"
                            },
                            {
                                "position": "28",
                                "acid": "E"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "V"
                            },
                            {
                                "position": "31",
                                "acid": "L"
                            },
                            {
                                "position": "32",
                                "acid": "A"
                            },
                            {
                                "position": "33",
                                "acid": "G"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "I"
                            },
                            {
                                "position": "36",
                                "acid": "I"
                            },
                            {
                                "position": "37",
                                "acid": "V"
                            },
                            {
                                "position": "38",
                                "acid": "R"
                            },
                            {
                                "position": "39",
                                "acid": "Q"
                            },
                            {
                                "position": "40",
                                "acid": "R"
                            },
                            {
                                "position": "41",
                                "acid": "G"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "K"
                            },
                            {
                                "position": "44",
                                "acid": "F"
                            },
                            {
                                "position": "45",
                                "acid": "H"
                            },
                            {
                                "position": "46",
                                "acid": "A"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "N"
                            },
                            {
                                "position": "50",
                                "acid": "V"
                            },
                            {
                                "position": "51",
                                "acid": "G"
                            },
                            {
                                "position": "52",
                                "acid": "C"
                            },
                            {
                                "position": "53",
                                "acid": "G"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "D"
                            },
                            {
                                "position": "56",
                                "acid": "H"
                            },
                            {
                                "position": "57",
                                "acid": "T"
                            },
                            {
                                "position": "58",
                                "acid": "L"
                            },
                            {
                                "position": "59",
                                "acid": "F"
                            },
                            {
                                "position": "60",
                                "acid": "A"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "A"
                            },
                            {
                                "position": "63",
                                "acid": "D"
                            },
                            {
                                "position": "64",
                                "acid": "G"
                            },
                            {
                                "position": "65",
                                "acid": "K"
                            },
                            {
                                "position": "66",
                                "acid": "V"
                            },
                            {
                                "position": "67",
                                "acid": "K"
                            },
                            {
                                "position": "68",
                                "acid": "F"
                            },
                            {
                                "position": "69",
                                "acid": "E"
                            },
                            {
                                "position": "70",
                                "acid": "V"
                            },
                            {
                                "position": "71",
                                "acid": "K"
                            },
                            {
                                "position": "72",
                                "acid": "G"
                            },
                            {
                                "position": "73",
                                "acid": "P"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "N"
                            },
                            {
                                "position": "76",
                                "acid": "R"
                            },
                            {
                                "position": "77",
                                "acid": "K"
                            },
                            {
                                "position": "78",
                                "acid": "Y"
                            },
                            {
                                "position": "79",
                                "acid": "I"
                            },
                            {
                                "position": "80",
                                "acid": "S"
                            },
                            {
                                "position": "81",
                                "acid": "I"
                            },
                            {
                                "position": "82",
                                "acid": "V"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "E"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "1",
                                        "ion_display_position": "84",
                                        "spec_id": "281",
                                        "peak_id": "3",
                                        "peak_charge": "14"
                                    }
                                }
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "4",
                                            "ion_display_position": "81",
                                            "spec_id": "281",
                                            "peak_id": "21",
                                            "peak_charge": "14"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "4",
                                            "ion_display_position": "81",
                                            "spec_id": "281",
                                            "peak_id": "12",
                                            "peak_charge": "13"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "64",
                                        "ion_display_position": "64",
                                        "spec_id": "281",
                                        "peak_id": "14",
                                        "peak_charge": "10"
                                    }
                                }
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "82",
                                            "ion_display_position": "82",
                                            "spec_id": "281",
                                            "peak_id": "4",
                                            "peak_charge": "13"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "82",
                                            "ion_display_position": "82",
                                            "spec_id": "281",
                                            "peak_id": "5",
                                            "peak_charge": "14"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "83",
                                            "ion_display_position": "83",
                                            "spec_id": "281",
                                            "peak_id": "7",
                                            "peak_charge": "13"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "83",
                                            "ion_display_position": "83",
                                            "spec_id": "281",
                                            "peak_id": "1",
                                            "peak_charge": "14"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "84",
                                        "ion_display_position": "84",
                                        "spec_id": "281",
                                        "peak_id": "2",
                                        "peak_charge": "14"
                                    }
                                }
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": {
                                "left_pos": "52",
                                "right_pos": "53",
                                "anno": "C"
                            }
                        },
                        "mass_shift": {
                            "id": "0",
                            "left_position": "1",
                            "right_position": "4",
                            "shift": "-131.1213300812",
                            "anno": "-131.1213",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "43",
                "p_value": "0.32",
                "e_value": "0.39",
                "fdr": "8.40e-03",
                "matched_fragment_number": "6",
                "matched_peak_number": "5",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                        "ms1_ids": "314",
                        "ms1_scans": "613",
                        "ids": "298",
                        "scans": "614",
                        "precursor_mono_mass": "9044.8266",
                        "precursor_charge": "15",
                        "precursor_mz": "603.9957",
                        "feature_inte": "3.3095e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "298",
                                "peak_id": "0",
                                "monoisotopic_mass": "8897.7560",
                                "monoisotopic_mz": "636.5613",
                                "intensity": "277451.14",
                                "charge": "14",
                                "matched_ions_num": "2",
                                "matched_ions": {
                                    "matched_ion": [
                                        {
                                            "ion_type": "Y",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "8897.7460",
                                            "ion_position": "1",
                                            "ion_display_position": "76",
                                            "ion_sort_name": "Y00076",
                                            "ion_left_position": "1",
                                            "mass_error": "0.0100",
                                            "ppm": "1.12"
                                        },
                                        {
                                            "ion_type": "B",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "8898.7089",
                                            "ion_position": "76",
                                            "ion_display_position": "76",
                                            "ion_sort_name": "B00076",
                                            "ion_left_position": "76",
                                            "mass_error": "0.0494",
                                            "ppm": "5.56"
                                        }
                                    ]
                                }
                            },
                            {
                                "spec_id": "298",
                                "peak_id": "1",
                                "monoisotopic_mass": "8826.7281",
                                "monoisotopic_mz": "631.4879",
                                "intensity": "190541.34",
                                "charge": "14",
                                "matched_ions_num": "2",
                                "matched_ions": {
                                    "matched_ion": [
                                        {
                                            "ion_type": "Y",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "8826.7089",
                                            "ion_position": "2",
                                            "ion_display_position": "75",
                                            "ion_sort_name": "Y00075",
                                            "ion_left_position": "2",
                                            "mass_error": "0.0191",
                                            "ppm": "2.17"
                                        },
                                        {
                                            "ion_type": "B",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "8827.6718",
                                            "ion_position": "75",
                                            "ion_display_position": "75",
                                            "ion_sort_name": "B00075",
                                            "ion_left_position": "75",
                                            "mass_error": "0.0586",
                                            "ppm": "6.64"
                                        }
                                    ]
                                }
                            },
                            {
                                "spec_id": "298",
                                "peak_id": "2",
                                "monoisotopic_mass": "8809.7083",
                                "monoisotopic_mz": "630.2722",
                                "intensity": "46765.93",
                                "charge": "14"
                            },
                            {
                                "spec_id": "298",
                                "peak_id": "3",
                                "monoisotopic_mass": "8711.6423",
                                "monoisotopic_mz": "671.1336",
                                "intensity": "47529.50",
                                "charge": "13",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8711.6820",
                                        "ion_position": "3",
                                        "ion_display_position": "74",
                                        "ion_sort_name": "Y00074",
                                        "ion_left_position": "3",
                                        "mass_error": "-0.0397",
                                        "ppm": "-4.56"
                                    }
                                }
                            },
                            {
                                "spec_id": "298",
                                "peak_id": "4",
                                "monoisotopic_mass": "8727.6653",
                                "monoisotopic_mz": "672.3661",
                                "intensity": "51199.63",
                                "charge": "13",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8728.6034",
                                        "ion_position": "74",
                                        "ion_display_position": "74",
                                        "ion_sort_name": "B00074",
                                        "ion_left_position": "74",
                                        "mass_error": "0.0643",
                                        "ppm": "7.37"
                                    }
                                }
                            },
                            {
                                "spec_id": "298",
                                "peak_id": "5",
                                "monoisotopic_mass": "2179.5791",
                                "monoisotopic_mz": "199.1508",
                                "intensity": "17911.81",
                                "charge": "11"
                            },
                            {
                                "spec_id": "298",
                                "peak_id": "6",
                                "monoisotopic_mass": "1245.3780",
                                "monoisotopic_mz": "623.6963",
                                "intensity": "9174.86",
                                "charge": "2"
                            },
                            {
                                "spec_id": "298",
                                "peak_id": "7",
                                "monoisotopic_mass": "6351.3449",
                                "monoisotopic_mz": "636.1418",
                                "intensity": "38910.13",
                                "charge": "10"
                            },
                            {
                                "spec_id": "298",
                                "peak_id": "8",
                                "monoisotopic_mass": "1981.2855",
                                "monoisotopic_mz": "199.1358",
                                "intensity": "14276.74",
                                "charge": "10"
                            },
                            {
                                "spec_id": "298",
                                "peak_id": "9",
                                "monoisotopic_mass": "8826.6963",
                                "monoisotopic_mz": "679.9839",
                                "intensity": "51101.25",
                                "charge": "13",
                                "matched_ions_num": "2",
                                "matched_ions": {
                                    "matched_ion": [
                                        {
                                            "ion_type": "Y",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "8826.7089",
                                            "ion_position": "2",
                                            "ion_display_position": "75",
                                            "ion_sort_name": "Y00075",
                                            "ion_left_position": "2",
                                            "mass_error": "-0.0127",
                                            "ppm": "-1.44"
                                        },
                                        {
                                            "ion_type": "B",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "8827.6718",
                                            "ion_position": "75",
                                            "ion_display_position": "75",
                                            "ion_sort_name": "B00075",
                                            "ion_left_position": "75",
                                            "mass_error": "0.0268",
                                            "ppm": "3.04"
                                        }
                                    ]
                                }
                            },
                            {
                                "spec_id": "298",
                                "peak_id": "10",
                                "monoisotopic_mass": "4440.3849",
                                "monoisotopic_mz": "635.3480",
                                "intensity": "34732.74",
                                "charge": "7"
                            },
                            {
                                "spec_id": "298",
                                "peak_id": "11",
                                "monoisotopic_mass": "2971.7531",
                                "monoisotopic_mz": "199.1241",
                                "intensity": "15909.50",
                                "charge": "15"
                            },
                            {
                                "spec_id": "298",
                                "peak_id": "12",
                                "monoisotopic_mass": "628.7677",
                                "monoisotopic_mz": "629.7750",
                                "intensity": "22078.87",
                                "charge": "1"
                            },
                            {
                                "spec_id": "298",
                                "peak_id": "13",
                                "monoisotopic_mass": "677.1273",
                                "monoisotopic_mz": "678.1346",
                                "intensity": "10812.72",
                                "charge": "1"
                            },
                            {
                                "spec_id": "298",
                                "peak_id": "14",
                                "monoisotopic_mass": "2034.0831",
                                "monoisotopic_mz": "509.5281",
                                "intensity": "19464.44",
                                "charge": "4"
                            },
                            {
                                "spec_id": "298",
                                "peak_id": "15",
                                "monoisotopic_mass": "1257.6744",
                                "monoisotopic_mz": "629.8445",
                                "intensity": "9283.59",
                                "charge": "2"
                            },
                            {
                                "spec_id": "298",
                                "peak_id": "16",
                                "monoisotopic_mass": "4389.8457",
                                "monoisotopic_mz": "628.1281",
                                "intensity": "15847.36",
                                "charge": "7"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "29",
                    "proteoform_id": "30",
                    "sequence_name": "tr|Q8ZK46|Q8ZK46_SALTY",
                    "sequence_description": "Putative cytoplasmic protein OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=STM4442 PE=4 SV=1",
                    "proteoform_mass": "9044.8145",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "100",
                        "first_residue_position": "22",
                        "last_residue_position": "98",
                        "annotated_seq": "A.FADALNHVQSAVMRESPYILLRIEPQDVRIVQAHESVRKEAFLFFFLRRERRTYSVELDVTVNVTAINLDRVDFVAK.R",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "M"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "E"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "F"
                            },
                            {
                                "position": "6",
                                "acid": "T"
                            },
                            {
                                "position": "7",
                                "acid": "T"
                            },
                            {
                                "position": "8",
                                "acid": "T"
                            },
                            {
                                "position": "9",
                                "acid": "V"
                            },
                            {
                                "position": "10",
                                "acid": "R"
                            },
                            {
                                "position": "11",
                                "acid": "V"
                            },
                            {
                                "position": "12",
                                "acid": "K"
                            },
                            {
                                "position": "13",
                                "acid": "G"
                            },
                            {
                                "position": "14",
                                "acid": "K"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "D"
                            },
                            {
                                "position": "17",
                                "acid": "A"
                            },
                            {
                                "position": "18",
                                "acid": "K"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "R"
                            },
                            {
                                "position": "21",
                                "acid": "A"
                            },
                            {
                                "position": "22",
                                "acid": "F"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "D"
                            },
                            {
                                "position": "25",
                                "acid": "A"
                            },
                            {
                                "position": "26",
                                "acid": "L"
                            },
                            {
                                "position": "27",
                                "acid": "N"
                            },
                            {
                                "position": "28",
                                "acid": "H"
                            },
                            {
                                "position": "29",
                                "acid": "V"
                            },
                            {
                                "position": "30",
                                "acid": "Q"
                            },
                            {
                                "position": "31",
                                "acid": "S"
                            },
                            {
                                "position": "32",
                                "acid": "A"
                            },
                            {
                                "position": "33",
                                "acid": "V"
                            },
                            {
                                "position": "34",
                                "acid": "M"
                            },
                            {
                                "position": "35",
                                "acid": "R"
                            },
                            {
                                "position": "36",
                                "acid": "E"
                            },
                            {
                                "position": "37",
                                "acid": "S"
                            },
                            {
                                "position": "38",
                                "acid": "P"
                            },
                            {
                                "position": "39",
                                "acid": "Y"
                            },
                            {
                                "position": "40",
                                "acid": "I"
                            },
                            {
                                "position": "41",
                                "acid": "L"
                            },
                            {
                                "position": "42",
                                "acid": "L"
                            },
                            {
                                "position": "43",
                                "acid": "R"
                            },
                            {
                                "position": "44",
                                "acid": "I"
                            },
                            {
                                "position": "45",
                                "acid": "E"
                            },
                            {
                                "position": "46",
                                "acid": "P"
                            },
                            {
                                "position": "47",
                                "acid": "Q"
                            },
                            {
                                "position": "48",
                                "acid": "D"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "R"
                            },
                            {
                                "position": "51",
                                "acid": "I"
                            },
                            {
                                "position": "52",
                                "acid": "V"
                            },
                            {
                                "position": "53",
                                "acid": "Q"
                            },
                            {
                                "position": "54",
                                "acid": "A"
                            },
                            {
                                "position": "55",
                                "acid": "H"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "S"
                            },
                            {
                                "position": "58",
                                "acid": "V"
                            },
                            {
                                "position": "59",
                                "acid": "R"
                            },
                            {
                                "position": "60",
                                "acid": "K"
                            },
                            {
                                "position": "61",
                                "acid": "E"
                            },
                            {
                                "position": "62",
                                "acid": "A"
                            },
                            {
                                "position": "63",
                                "acid": "F"
                            },
                            {
                                "position": "64",
                                "acid": "L"
                            },
                            {
                                "position": "65",
                                "acid": "F"
                            },
                            {
                                "position": "66",
                                "acid": "F"
                            },
                            {
                                "position": "67",
                                "acid": "F"
                            },
                            {
                                "position": "68",
                                "acid": "L"
                            },
                            {
                                "position": "69",
                                "acid": "R"
                            },
                            {
                                "position": "70",
                                "acid": "R"
                            },
                            {
                                "position": "71",
                                "acid": "E"
                            },
                            {
                                "position": "72",
                                "acid": "R"
                            },
                            {
                                "position": "73",
                                "acid": "R"
                            },
                            {
                                "position": "74",
                                "acid": "T"
                            },
                            {
                                "position": "75",
                                "acid": "Y"
                            },
                            {
                                "position": "76",
                                "acid": "S"
                            },
                            {
                                "position": "77",
                                "acid": "V"
                            },
                            {
                                "position": "78",
                                "acid": "E"
                            },
                            {
                                "position": "79",
                                "acid": "L"
                            },
                            {
                                "position": "80",
                                "acid": "D"
                            },
                            {
                                "position": "81",
                                "acid": "V"
                            },
                            {
                                "position": "82",
                                "acid": "T"
                            },
                            {
                                "position": "83",
                                "acid": "V"
                            },
                            {
                                "position": "84",
                                "acid": "N"
                            },
                            {
                                "position": "85",
                                "acid": "V"
                            },
                            {
                                "position": "86",
                                "acid": "T"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "I"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            },
                            {
                                "position": "90",
                                "acid": "L"
                            },
                            {
                                "position": "91",
                                "acid": "D"
                            },
                            {
                                "position": "92",
                                "acid": "R"
                            },
                            {
                                "position": "93",
                                "acid": "V"
                            },
                            {
                                "position": "94",
                                "acid": "D"
                            },
                            {
                                "position": "95",
                                "acid": "F"
                            },
                            {
                                "position": "96",
                                "acid": "V"
                            },
                            {
                                "position": "97",
                                "acid": "A"
                            },
                            {
                                "position": "98",
                                "acid": "K"
                            },
                            {
                                "position": "99",
                                "acid": "R"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "1",
                                        "ion_display_position": "76",
                                        "spec_id": "298",
                                        "peak_id": "0",
                                        "peak_charge": "14"
                                    }
                                }
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "2",
                                            "ion_display_position": "75",
                                            "spec_id": "298",
                                            "peak_id": "9",
                                            "peak_charge": "13"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "2",
                                            "ion_display_position": "75",
                                            "spec_id": "298",
                                            "peak_id": "1",
                                            "peak_charge": "14"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "3",
                                        "ion_display_position": "74",
                                        "spec_id": "298",
                                        "peak_id": "3",
                                        "peak_charge": "13"
                                    }
                                }
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "74",
                                        "ion_display_position": "74",
                                        "spec_id": "298",
                                        "peak_id": "4",
                                        "peak_charge": "13"
                                    }
                                }
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "75",
                                            "ion_display_position": "75",
                                            "spec_id": "298",
                                            "peak_id": "9",
                                            "peak_charge": "13"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "75",
                                            "ion_display_position": "75",
                                            "spec_id": "298",
                                            "peak_id": "1",
                                            "peak_charge": "14"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "76",
                                        "ion_display_position": "76",
                                        "spec_id": "298",
                                        "peak_id": "0",
                                        "peak_charge": "14"
                                    }
                                }
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            }
        ]
    }
}
