prsm_data =
{
    "protein": {
        "sequence_id": "9",
        "sequence_name": "sp|P68684|RS21_SALTY",
        "sequence_description": "30S ribosomal protein S21 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpsU PE=3 SV=2",
        "compatible_proteoform_number": "3",
        "compatible_proteoform": [
            {
                "sequence_id": "9",
                "sequence_name": "sp|P68684|RS21_SALTY",
                "sequence_description": "30S ribosomal protein S21 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpsU PE=3 SV=2",
                "proteoform_id": "12",
                "prsm_number": "11",
                "prsm": [
                    {
                        "prsm_id": "55",
                        "p_value": "9.11e-10",
                        "e_value": "9.11e-10",
                        "fdr": "0",
                        "matched_fragment_number": "13",
                        "matched_peak_number": "17",
                        "ms": {
                            "ms_header": {
                                "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                                "ms1_ids": "369",
                                "ms1_scans": "723",
                                "ids": "353",
                                "scans": "724",
                                "precursor_mono_mass": "8420.6381",
                                "precursor_charge": "15",
                                "precursor_mz": "562.3832",
                                "feature_inte": "1.2933e+08"
                            }
                        },
                        "annotated_protein": {
                            "sequence_id": "9",
                            "proteoform_id": "12",
                            "sequence_name": "sp|P68684|RS21_SALTY",
                            "sequence_description": "30S ribosomal protein S21 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpsU PE=3 SV=2",
                            "proteoform_mass": "8420.7075",
                            "n_acetylation": "0",
                            "unexpected_shift_number": "0",
                            "annotation": {
                                "protein_length": "71",
                                "first_residue_position": "1",
                                "last_residue_position": "70",
                                "annotated_seq": "M.PVIKVRENEPFDVALRRFKRS(C)[Carbamidomethylation]EKAGVLAEVRRREFYEKPTTERKRAKASAVKRHAKKLARENARRTRLY.",
                                "residue": [
                                    {
                                        "position": "0",
                                        "acid": "M"
                                    },
                                    {
                                        "position": "1",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "2",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "3",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "4",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "5",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "6",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "7",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "8",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "9",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "10",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "11",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "12",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "13",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "14",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "15",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "16",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "17",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "18",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "19",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "20",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "21",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "22",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "23",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "24",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "25",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "26",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "27",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "28",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "29",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "30",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "31",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "32",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "33",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "34",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "35",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "36",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "37",
                                        "acid": "Y"
                                    },
                                    {
                                        "position": "38",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "39",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "40",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "41",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "42",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "43",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "44",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "45",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "46",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "47",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "48",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "49",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "50",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "51",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "52",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "53",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "54",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "55",
                                        "acid": "H"
                                    },
                                    {
                                        "position": "56",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "57",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "58",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "59",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "60",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "61",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "62",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "63",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "64",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "65",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "66",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "67",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "68",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "69",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "70",
                                        "acid": "Y"
                                    }
                                ],
                                "cleavage": [
                                    {
                                        "position": "0",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "1",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "2",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "3",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "4",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "5",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "6",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "7",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "8",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "9",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "10",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "9",
                                                    "ion_display_position": "9",
                                                    "spec_id": "353",
                                                    "peak_id": "23",
                                                    "peak_charge": "3"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "9",
                                                    "ion_display_position": "61",
                                                    "spec_id": "353",
                                                    "peak_id": "5",
                                                    "peak_charge": "12"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "11",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "10",
                                                    "ion_display_position": "10",
                                                    "spec_id": "353",
                                                    "peak_id": "27",
                                                    "peak_charge": "3"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "10",
                                                    "ion_display_position": "60",
                                                    "spec_id": "353",
                                                    "peak_id": "4",
                                                    "peak_charge": "12"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "10",
                                                    "ion_display_position": "60",
                                                    "spec_id": "353",
                                                    "peak_id": "10",
                                                    "peak_charge": "11"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "12",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "11",
                                                "ion_display_position": "59",
                                                "spec_id": "353",
                                                "peak_id": "1",
                                                "peak_charge": "12"
                                            }
                                        }
                                    },
                                    {
                                        "position": "13",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "12",
                                                    "ion_display_position": "12",
                                                    "spec_id": "353",
                                                    "peak_id": "13",
                                                    "peak_charge": "2"
                                                },
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "12",
                                                    "ion_display_position": "12",
                                                    "spec_id": "353",
                                                    "peak_id": "21",
                                                    "peak_charge": "3"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "12",
                                                    "ion_display_position": "58",
                                                    "spec_id": "353",
                                                    "peak_id": "2",
                                                    "peak_charge": "11"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "12",
                                                    "ion_display_position": "58",
                                                    "spec_id": "353",
                                                    "peak_id": "0",
                                                    "peak_charge": "12"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "14",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "15",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "16",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "17",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "18",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "19",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "20",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "21",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "22",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "23",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "24",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "25",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "24",
                                                "ion_display_position": "46",
                                                "spec_id": "353",
                                                "peak_id": "50",
                                                "peak_charge": "9"
                                            }
                                        }
                                    },
                                    {
                                        "position": "26",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "27",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "28",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "29",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "30",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "31",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "30",
                                                    "ion_display_position": "40",
                                                    "spec_id": "353",
                                                    "peak_id": "8",
                                                    "peak_charge": "8"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "30",
                                                    "ion_display_position": "40",
                                                    "spec_id": "353",
                                                    "peak_id": "3",
                                                    "peak_charge": "10"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "32",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "33",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "34",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "35",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "34",
                                                    "ion_display_position": "34",
                                                    "spec_id": "353",
                                                    "peak_id": "7",
                                                    "peak_charge": "8"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "34",
                                                    "ion_display_position": "36",
                                                    "spec_id": "353",
                                                    "peak_id": "18",
                                                    "peak_charge": "6"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "36",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "37",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "38",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "39",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "40",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "39",
                                                "ion_display_position": "31",
                                                "spec_id": "353",
                                                "peak_id": "40",
                                                "peak_charge": "6"
                                            }
                                        }
                                    },
                                    {
                                        "position": "41",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "42",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "43",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "44",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "45",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "46",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "47",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "48",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "49",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "50",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "51",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "52",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "53",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "54",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "55",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "54",
                                                "ion_display_position": "16",
                                                "spec_id": "353",
                                                "peak_id": "26",
                                                "peak_charge": "3"
                                            }
                                        }
                                    },
                                    {
                                        "position": "56",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "57",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "58",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "59",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "60",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "61",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "62",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "63",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "64",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "65",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "66",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "67",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "68",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "69",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "70",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "71",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    }
                                ],
                                "ptm": {
                                    "ptm_type": "Fixed",
                                    "ptm": {
                                        "abbreviation": "Carbamidomethylation",
                                        "unimod": "-1",
                                        "mono_mass": "57.0214640000"
                                    },
                                    "occurence": {
                                        "left_pos": "22",
                                        "right_pos": "23",
                                        "anno": "C"
                                    }
                                }
                            }
                        }
                    },
                    {
                        "prsm_id": "60",
                        "p_value": "1.26e-09",
                        "e_value": "1.26e-09",
                        "fdr": "0",
                        "matched_fragment_number": "14",
                        "matched_peak_number": "18",
                        "ms": {
                            "ms_header": {
                                "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                                "ms1_ids": "384",
                                "ms1_scans": "753",
                                "ids": "368",
                                "scans": "754",
                                "precursor_mono_mass": "8420.6725",
                                "precursor_charge": "15",
                                "precursor_mz": "562.3854",
                                "feature_inte": "1.1444e+08"
                            }
                        },
                        "annotated_protein": {
                            "sequence_id": "9",
                            "proteoform_id": "12",
                            "sequence_name": "sp|P68684|RS21_SALTY",
                            "sequence_description": "30S ribosomal protein S21 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpsU PE=3 SV=2",
                            "proteoform_mass": "8420.7075",
                            "n_acetylation": "0",
                            "unexpected_shift_number": "0",
                            "annotation": {
                                "protein_length": "71",
                                "first_residue_position": "1",
                                "last_residue_position": "70",
                                "annotated_seq": "M.PVIKVRENEPFDVALRRFKRS(C)[Carbamidomethylation]EKAGVLAEVRRREFYEKPTTERKRAKASAVKRHAKKLARENARRTRLY.",
                                "residue": [
                                    {
                                        "position": "0",
                                        "acid": "M"
                                    },
                                    {
                                        "position": "1",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "2",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "3",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "4",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "5",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "6",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "7",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "8",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "9",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "10",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "11",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "12",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "13",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "14",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "15",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "16",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "17",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "18",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "19",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "20",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "21",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "22",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "23",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "24",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "25",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "26",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "27",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "28",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "29",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "30",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "31",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "32",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "33",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "34",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "35",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "36",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "37",
                                        "acid": "Y"
                                    },
                                    {
                                        "position": "38",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "39",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "40",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "41",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "42",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "43",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "44",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "45",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "46",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "47",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "48",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "49",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "50",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "51",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "52",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "53",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "54",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "55",
                                        "acid": "H"
                                    },
                                    {
                                        "position": "56",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "57",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "58",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "59",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "60",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "61",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "62",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "63",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "64",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "65",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "66",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "67",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "68",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "69",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "70",
                                        "acid": "Y"
                                    }
                                ],
                                "cleavage": [
                                    {
                                        "position": "0",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "1",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "2",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "1",
                                                "ion_display_position": "69",
                                                "spec_id": "368",
                                                "peak_id": "13",
                                                "peak_charge": "14"
                                            }
                                        }
                                    },
                                    {
                                        "position": "3",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "2",
                                                "ion_display_position": "68",
                                                "spec_id": "368",
                                                "peak_id": "2",
                                                "peak_charge": "14"
                                            }
                                        }
                                    },
                                    {
                                        "position": "4",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "5",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "6",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "7",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "8",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "9",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "10",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "9",
                                                    "ion_display_position": "9",
                                                    "spec_id": "368",
                                                    "peak_id": "32",
                                                    "peak_charge": "3"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "9",
                                                    "ion_display_position": "61",
                                                    "spec_id": "368",
                                                    "peak_id": "5",
                                                    "peak_charge": "12"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "11",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "10",
                                                    "ion_display_position": "10",
                                                    "spec_id": "368",
                                                    "peak_id": "29",
                                                    "peak_charge": "3"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "10",
                                                    "ion_display_position": "60",
                                                    "spec_id": "368",
                                                    "peak_id": "48",
                                                    "peak_charge": "11"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "10",
                                                    "ion_display_position": "60",
                                                    "spec_id": "368",
                                                    "peak_id": "1",
                                                    "peak_charge": "12"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "12",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "11",
                                                "ion_display_position": "59",
                                                "spec_id": "368",
                                                "peak_id": "0",
                                                "peak_charge": "12"
                                            }
                                        }
                                    },
                                    {
                                        "position": "13",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "12",
                                                    "ion_display_position": "12",
                                                    "spec_id": "368",
                                                    "peak_id": "28",
                                                    "peak_charge": "3"
                                                },
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "12",
                                                    "ion_display_position": "12",
                                                    "spec_id": "368",
                                                    "peak_id": "16",
                                                    "peak_charge": "2"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "12",
                                                    "ion_display_position": "58",
                                                    "spec_id": "368",
                                                    "peak_id": "3",
                                                    "peak_charge": "12"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "12",
                                                    "ion_display_position": "58",
                                                    "spec_id": "368",
                                                    "peak_id": "9",
                                                    "peak_charge": "11"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "14",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "15",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "16",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "17",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "18",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "19",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "20",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "21",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "22",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "23",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "24",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "25",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "26",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "27",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "28",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "29",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "30",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "31",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "30",
                                                "ion_display_position": "40",
                                                "spec_id": "368",
                                                "peak_id": "6",
                                                "peak_charge": "8"
                                            }
                                        }
                                    },
                                    {
                                        "position": "32",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "33",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "34",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "35",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "34",
                                                    "ion_display_position": "34",
                                                    "spec_id": "368",
                                                    "peak_id": "8",
                                                    "peak_charge": "8"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "34",
                                                    "ion_display_position": "36",
                                                    "spec_id": "368",
                                                    "peak_id": "12",
                                                    "peak_charge": "6"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "36",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "37",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "38",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "39",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "40",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "39",
                                                "ion_display_position": "31",
                                                "spec_id": "368",
                                                "peak_id": "49",
                                                "peak_charge": "6"
                                            }
                                        }
                                    },
                                    {
                                        "position": "41",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "42",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "43",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "44",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "45",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "46",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "47",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "48",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "49",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "50",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "51",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "52",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "53",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "54",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "55",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "54",
                                                    "ion_display_position": "16",
                                                    "spec_id": "368",
                                                    "peak_id": "37",
                                                    "peak_charge": "3"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "54",
                                                    "ion_display_position": "16",
                                                    "spec_id": "368",
                                                    "peak_id": "58",
                                                    "peak_charge": "4"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "56",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "57",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "58",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "59",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "60",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "61",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "62",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "63",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "64",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "65",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "66",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "67",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "68",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "69",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "70",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "71",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    }
                                ],
                                "ptm": {
                                    "ptm_type": "Fixed",
                                    "ptm": {
                                        "abbreviation": "Carbamidomethylation",
                                        "unimod": "-1",
                                        "mono_mass": "57.0214640000"
                                    },
                                    "occurence": {
                                        "left_pos": "22",
                                        "right_pos": "23",
                                        "anno": "C"
                                    }
                                }
                            }
                        }
                    },
                    {
                        "prsm_id": "62",
                        "p_value": "3.00e-08",
                        "e_value": "3.00e-08",
                        "fdr": "0",
                        "matched_fragment_number": "13",
                        "matched_peak_number": "17",
                        "ms": {
                            "ms_header": {
                                "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                                "ms1_ids": "387",
                                "ms1_scans": "759",
                                "ids": "371",
                                "scans": "760",
                                "precursor_mono_mass": "8420.6725",
                                "precursor_charge": "16",
                                "precursor_mz": "527.2993",
                                "feature_inte": "1.1444e+08"
                            }
                        },
                        "annotated_protein": {
                            "sequence_id": "9",
                            "proteoform_id": "12",
                            "sequence_name": "sp|P68684|RS21_SALTY",
                            "sequence_description": "30S ribosomal protein S21 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpsU PE=3 SV=2",
                            "proteoform_mass": "8420.6475",
                            "n_acetylation": "0",
                            "unexpected_shift_number": "1",
                            "annotation": {
                                "protein_length": "71",
                                "first_residue_position": "1",
                                "last_residue_position": "70",
                                "annotated_seq": "M.PVIKVRENEPFDVALRRFKRS(C)[Carbamidomethylation]EKAGV(L)[-0.0600]AEVRRREFYEKPTTERKRAKASAVKRHAKKLARENARRTRLY.",
                                "residue": [
                                    {
                                        "position": "0",
                                        "acid": "M"
                                    },
                                    {
                                        "position": "1",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "2",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "3",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "4",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "5",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "6",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "7",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "8",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "9",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "10",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "11",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "12",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "13",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "14",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "15",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "16",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "17",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "18",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "19",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "20",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "21",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "22",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "23",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "24",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "25",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "26",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "27",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "28",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "29",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "30",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "31",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "32",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "33",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "34",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "35",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "36",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "37",
                                        "acid": "Y"
                                    },
                                    {
                                        "position": "38",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "39",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "40",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "41",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "42",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "43",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "44",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "45",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "46",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "47",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "48",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "49",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "50",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "51",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "52",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "53",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "54",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "55",
                                        "acid": "H"
                                    },
                                    {
                                        "position": "56",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "57",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "58",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "59",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "60",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "61",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "62",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "63",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "64",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "65",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "66",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "67",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "68",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "69",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "70",
                                        "acid": "Y"
                                    }
                                ],
                                "cleavage": [
                                    {
                                        "position": "0",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "1",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "2",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "3",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "4",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "5",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "6",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "7",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "8",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "9",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "10",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "9",
                                                    "ion_display_position": "9",
                                                    "spec_id": "371",
                                                    "peak_id": "30",
                                                    "peak_charge": "3"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "9",
                                                    "ion_display_position": "61",
                                                    "spec_id": "371",
                                                    "peak_id": "4",
                                                    "peak_charge": "13"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "11",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "10",
                                                    "ion_display_position": "10",
                                                    "spec_id": "371",
                                                    "peak_id": "34",
                                                    "peak_charge": "3"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "10",
                                                    "ion_display_position": "60",
                                                    "spec_id": "371",
                                                    "peak_id": "3",
                                                    "peak_charge": "12"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "10",
                                                    "ion_display_position": "60",
                                                    "spec_id": "371",
                                                    "peak_id": "7",
                                                    "peak_charge": "13"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "12",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "11",
                                                "ion_display_position": "59",
                                                "spec_id": "371",
                                                "peak_id": "19",
                                                "peak_charge": "12"
                                            }
                                        }
                                    },
                                    {
                                        "position": "13",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "12",
                                                    "ion_display_position": "12",
                                                    "spec_id": "371",
                                                    "peak_id": "21",
                                                    "peak_charge": "2"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "12",
                                                    "ion_display_position": "58",
                                                    "spec_id": "371",
                                                    "peak_id": "29",
                                                    "peak_charge": "12"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "12",
                                                    "ion_display_position": "58",
                                                    "spec_id": "371",
                                                    "peak_id": "0",
                                                    "peak_charge": "13"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "14",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "15",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "16",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "17",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "18",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "19",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "20",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "21",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "22",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "23",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "24",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "25",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "26",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "27",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "28",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "27",
                                                "ion_display_position": "43",
                                                "spec_id": "371",
                                                "peak_id": "28",
                                                "peak_charge": "9"
                                            }
                                        }
                                    },
                                    {
                                        "position": "29",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "28",
                                                "ion_display_position": "42",
                                                "spec_id": "371",
                                                "peak_id": "50",
                                                "peak_charge": "9"
                                            }
                                        }
                                    },
                                    {
                                        "position": "30",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "31",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "30",
                                                    "ion_display_position": "30",
                                                    "spec_id": "371",
                                                    "peak_id": "36",
                                                    "peak_charge": "6"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "30",
                                                    "ion_display_position": "40",
                                                    "spec_id": "371",
                                                    "peak_id": "9",
                                                    "peak_charge": "9"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "30",
                                                    "ion_display_position": "40",
                                                    "spec_id": "371",
                                                    "peak_id": "2",
                                                    "peak_charge": "10"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "32",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "33",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "34",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "35",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "34",
                                                "ion_display_position": "36",
                                                "spec_id": "371",
                                                "peak_id": "49",
                                                "peak_charge": "7"
                                            }
                                        }
                                    },
                                    {
                                        "position": "36",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "37",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "38",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "39",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "40",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "39",
                                                    "ion_display_position": "31",
                                                    "spec_id": "371",
                                                    "peak_id": "18",
                                                    "peak_charge": "6"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "39",
                                                    "ion_display_position": "31",
                                                    "spec_id": "371",
                                                    "peak_id": "6",
                                                    "peak_charge": "8"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "41",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "42",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "43",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "44",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "45",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "46",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "47",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "48",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "49",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "50",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "51",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "52",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "53",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "54",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "55",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "56",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "57",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "58",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "59",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "60",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "61",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "62",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "63",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "64",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "65",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "66",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "67",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "68",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "69",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "70",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "71",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    }
                                ],
                                "ptm": {
                                    "ptm_type": "Fixed",
                                    "ptm": {
                                        "abbreviation": "Carbamidomethylation",
                                        "unimod": "-1",
                                        "mono_mass": "57.0214640000"
                                    },
                                    "occurence": {
                                        "left_pos": "22",
                                        "right_pos": "23",
                                        "anno": "C"
                                    }
                                },
                                "mass_shift": {
                                    "id": "0",
                                    "left_position": "28",
                                    "right_position": "29",
                                    "shift": "-5.9973276117e-02",
                                    "anno": "-0.0600",
                                    "shift_type": "unexpected"
                                }
                            }
                        }
                    },
                    {
                        "prsm_id": "63",
                        "p_value": "1.53e-07",
                        "e_value": "1.53e-07",
                        "fdr": "0",
                        "matched_fragment_number": "8",
                        "matched_peak_number": "10",
                        "ms": {
                            "ms_header": {
                                "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                                "ms1_ids": "388",
                                "ms1_scans": "761",
                                "ids": "372",
                                "scans": "762",
                                "precursor_mono_mass": "8420.6725",
                                "precursor_charge": "14",
                                "precursor_mz": "602.4839",
                                "feature_inte": "1.1444e+08"
                            }
                        },
                        "annotated_protein": {
                            "sequence_id": "9",
                            "proteoform_id": "12",
                            "sequence_name": "sp|P68684|RS21_SALTY",
                            "sequence_description": "30S ribosomal protein S21 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpsU PE=3 SV=2",
                            "proteoform_mass": "8420.7075",
                            "n_acetylation": "0",
                            "unexpected_shift_number": "0",
                            "annotation": {
                                "protein_length": "71",
                                "first_residue_position": "1",
                                "last_residue_position": "70",
                                "annotated_seq": "M.PVIKVRENEPFDVALRRFKRS(C)[Carbamidomethylation]EKAGVLAEVRRREFYEKPTTERKRAKASAVKRHAKKLARENARRTRLY.",
                                "residue": [
                                    {
                                        "position": "0",
                                        "acid": "M"
                                    },
                                    {
                                        "position": "1",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "2",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "3",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "4",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "5",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "6",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "7",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "8",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "9",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "10",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "11",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "12",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "13",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "14",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "15",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "16",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "17",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "18",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "19",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "20",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "21",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "22",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "23",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "24",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "25",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "26",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "27",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "28",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "29",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "30",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "31",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "32",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "33",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "34",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "35",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "36",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "37",
                                        "acid": "Y"
                                    },
                                    {
                                        "position": "38",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "39",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "40",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "41",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "42",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "43",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "44",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "45",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "46",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "47",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "48",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "49",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "50",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "51",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "52",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "53",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "54",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "55",
                                        "acid": "H"
                                    },
                                    {
                                        "position": "56",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "57",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "58",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "59",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "60",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "61",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "62",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "63",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "64",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "65",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "66",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "67",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "68",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "69",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "70",
                                        "acid": "Y"
                                    }
                                ],
                                "cleavage": [
                                    {
                                        "position": "0",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "1",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "2",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "3",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "2",
                                                "ion_display_position": "68",
                                                "spec_id": "372",
                                                "peak_id": "4",
                                                "peak_charge": "13"
                                            }
                                        }
                                    },
                                    {
                                        "position": "4",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "3",
                                                "ion_display_position": "67",
                                                "spec_id": "372",
                                                "peak_id": "21",
                                                "peak_charge": "12"
                                            }
                                        }
                                    },
                                    {
                                        "position": "5",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "4",
                                                "ion_display_position": "66",
                                                "spec_id": "372",
                                                "peak_id": "16",
                                                "peak_charge": "12"
                                            }
                                        }
                                    },
                                    {
                                        "position": "6",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "7",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "8",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "9",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "10",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "11",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "12",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "13",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "12",
                                                "ion_display_position": "12",
                                                "spec_id": "372",
                                                "peak_id": "10",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "14",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "15",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "16",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "17",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "18",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "19",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "20",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "21",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "22",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "23",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "24",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "25",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "26",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "27",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "28",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "29",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "30",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "31",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "30",
                                                    "ion_display_position": "30",
                                                    "spec_id": "372",
                                                    "peak_id": "6",
                                                    "peak_charge": "5"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "30",
                                                    "ion_display_position": "40",
                                                    "spec_id": "372",
                                                    "peak_id": "0",
                                                    "peak_charge": "9"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "30",
                                                    "ion_display_position": "40",
                                                    "spec_id": "372",
                                                    "peak_id": "2",
                                                    "peak_charge": "8"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "32",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "33",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "34",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "35",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "34",
                                                    "ion_display_position": "36",
                                                    "spec_id": "372",
                                                    "peak_id": "13",
                                                    "peak_charge": "6"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "34",
                                                    "ion_display_position": "36",
                                                    "spec_id": "372",
                                                    "peak_id": "9",
                                                    "peak_charge": "7"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "36",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "37",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "36",
                                                "ion_display_position": "34",
                                                "spec_id": "372",
                                                "peak_id": "23",
                                                "peak_charge": "6"
                                            }
                                        }
                                    },
                                    {
                                        "position": "38",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "39",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "40",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "41",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "42",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "43",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "44",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "45",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "46",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "47",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "48",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "49",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "50",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "51",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "52",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "53",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "54",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "55",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "56",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "57",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "58",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "59",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "60",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "61",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "62",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "63",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "64",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "65",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "66",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "67",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "68",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "69",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "70",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "71",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    }
                                ],
                                "ptm": {
                                    "ptm_type": "Fixed",
                                    "ptm": {
                                        "abbreviation": "Carbamidomethylation",
                                        "unimod": "-1",
                                        "mono_mass": "57.0214640000"
                                    },
                                    "occurence": {
                                        "left_pos": "22",
                                        "right_pos": "23",
                                        "anno": "C"
                                    }
                                }
                            }
                        }
                    },
                    {
                        "prsm_id": "52",
                        "p_value": "4.99e-07",
                        "e_value": "4.99e-07",
                        "fdr": "0",
                        "matched_fragment_number": "13",
                        "matched_peak_number": "15",
                        "ms": {
                            "ms_header": {
                                "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                                "ms1_ids": "360",
                                "ms1_scans": "705",
                                "ids": "344",
                                "scans": "706",
                                "precursor_mono_mass": "8420.6381",
                                "precursor_charge": "14",
                                "precursor_mz": "602.4814",
                                "feature_inte": "1.2933e+08"
                            }
                        },
                        "annotated_protein": {
                            "sequence_id": "9",
                            "proteoform_id": "12",
                            "sequence_name": "sp|P68684|RS21_SALTY",
                            "sequence_description": "30S ribosomal protein S21 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpsU PE=3 SV=2",
                            "proteoform_mass": "8420.6631",
                            "n_acetylation": "0",
                            "unexpected_shift_number": "1",
                            "annotation": {
                                "protein_length": "71",
                                "first_residue_position": "1",
                                "last_residue_position": "70",
                                "annotated_seq": "M.PVIKVRENEPFDVALRRFKRS(C)[Carbamidomethylation]EKAGVLAEVRRREF(YEK)[-0.0443]PTTERKRAKASAVKRHAKKLARENARRTRLY.",
                                "residue": [
                                    {
                                        "position": "0",
                                        "acid": "M"
                                    },
                                    {
                                        "position": "1",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "2",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "3",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "4",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "5",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "6",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "7",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "8",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "9",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "10",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "11",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "12",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "13",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "14",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "15",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "16",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "17",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "18",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "19",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "20",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "21",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "22",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "23",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "24",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "25",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "26",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "27",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "28",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "29",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "30",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "31",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "32",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "33",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "34",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "35",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "36",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "37",
                                        "acid": "Y"
                                    },
                                    {
                                        "position": "38",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "39",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "40",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "41",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "42",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "43",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "44",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "45",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "46",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "47",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "48",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "49",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "50",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "51",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "52",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "53",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "54",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "55",
                                        "acid": "H"
                                    },
                                    {
                                        "position": "56",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "57",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "58",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "59",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "60",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "61",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "62",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "63",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "64",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "65",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "66",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "67",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "68",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "69",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "70",
                                        "acid": "Y"
                                    }
                                ],
                                "cleavage": [
                                    {
                                        "position": "0",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "1",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "2",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "1",
                                                "ion_display_position": "69",
                                                "spec_id": "344",
                                                "peak_id": "28",
                                                "peak_charge": "13"
                                            }
                                        }
                                    },
                                    {
                                        "position": "3",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "2",
                                                "ion_display_position": "68",
                                                "spec_id": "344",
                                                "peak_id": "7",
                                                "peak_charge": "13"
                                            }
                                        }
                                    },
                                    {
                                        "position": "4",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "3",
                                                "ion_display_position": "67",
                                                "spec_id": "344",
                                                "peak_id": "3",
                                                "peak_charge": "12"
                                            }
                                        }
                                    },
                                    {
                                        "position": "5",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "4",
                                                "ion_display_position": "66",
                                                "spec_id": "344",
                                                "peak_id": "2",
                                                "peak_charge": "12"
                                            }
                                        }
                                    },
                                    {
                                        "position": "6",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "7",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "8",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "9",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "10",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "9",
                                                    "ion_display_position": "9",
                                                    "spec_id": "344",
                                                    "peak_id": "33",
                                                    "peak_charge": "1"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "9",
                                                    "ion_display_position": "61",
                                                    "spec_id": "344",
                                                    "peak_id": "21",
                                                    "peak_charge": "11"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "11",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "12",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "13",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "12",
                                                    "ion_display_position": "12",
                                                    "spec_id": "344",
                                                    "peak_id": "26",
                                                    "peak_charge": "2"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "12",
                                                    "ion_display_position": "58",
                                                    "spec_id": "344",
                                                    "peak_id": "1",
                                                    "peak_charge": "11"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "14",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "15",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "16",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "17",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "18",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "19",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "20",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "21",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "22",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "23",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "24",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "25",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "26",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "27",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "28",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "29",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "30",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "31",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "30",
                                                    "ion_display_position": "30",
                                                    "spec_id": "344",
                                                    "peak_id": "20",
                                                    "peak_charge": "5"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "30",
                                                    "ion_display_position": "40",
                                                    "spec_id": "344",
                                                    "peak_id": "5",
                                                    "peak_charge": "9"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "30",
                                                    "ion_display_position": "40",
                                                    "spec_id": "344",
                                                    "peak_id": "4",
                                                    "peak_charge": "8"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "32",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "33",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "34",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "35",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "34",
                                                    "ion_display_position": "36",
                                                    "spec_id": "344",
                                                    "peak_id": "23",
                                                    "peak_charge": "7"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "34",
                                                    "ion_display_position": "36",
                                                    "spec_id": "344",
                                                    "peak_id": "31",
                                                    "peak_charge": "6"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "36",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "37",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "36",
                                                "ion_display_position": "34",
                                                "spec_id": "344",
                                                "peak_id": "61",
                                                "peak_charge": "6"
                                            }
                                        }
                                    },
                                    {
                                        "position": "38",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "39",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "40",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "39",
                                                "ion_display_position": "31",
                                                "spec_id": "344",
                                                "peak_id": "65",
                                                "peak_charge": "6"
                                            }
                                        }
                                    },
                                    {
                                        "position": "41",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "42",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "43",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "44",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "45",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "46",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "47",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "48",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "49",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "50",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "51",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "52",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "53",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "54",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "55",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "56",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "57",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "58",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "59",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "60",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "61",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "62",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "63",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "64",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "65",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "66",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "67",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "68",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "69",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "70",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "71",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    }
                                ],
                                "ptm": {
                                    "ptm_type": "Fixed",
                                    "ptm": {
                                        "abbreviation": "Carbamidomethylation",
                                        "unimod": "-1",
                                        "mono_mass": "57.0214640000"
                                    },
                                    "occurence": {
                                        "left_pos": "22",
                                        "right_pos": "23",
                                        "anno": "C"
                                    }
                                },
                                "mass_shift": {
                                    "id": "0",
                                    "left_position": "37",
                                    "right_position": "40",
                                    "shift": "-4.4343276118e-02",
                                    "anno": "-0.0443",
                                    "shift_type": "unexpected"
                                }
                            }
                        }
                    },
                    {
                        "prsm_id": "64",
                        "p_value": "5.06e-07",
                        "e_value": "5.06e-07",
                        "fdr": "0",
                        "matched_fragment_number": "8",
                        "matched_peak_number": "9",
                        "ms": {
                            "ms_header": {
                                "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                                "ms1_ids": "389",
                                "ms1_scans": "763",
                                "ids": "373",
                                "scans": "764",
                                "precursor_mono_mass": "8420.6764",
                                "precursor_charge": "15",
                                "precursor_mz": "562.3857",
                                "feature_inte": "4.3789e+07"
                            }
                        },
                        "annotated_protein": {
                            "sequence_id": "9",
                            "proteoform_id": "12",
                            "sequence_name": "sp|P68684|RS21_SALTY",
                            "sequence_description": "30S ribosomal protein S21 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpsU PE=3 SV=2",
                            "proteoform_mass": "8420.7075",
                            "n_acetylation": "0",
                            "unexpected_shift_number": "0",
                            "annotation": {
                                "protein_length": "71",
                                "first_residue_position": "1",
                                "last_residue_position": "70",
                                "annotated_seq": "M.PVIKVRENEPFDVALRRFKRS(C)[Carbamidomethylation]EKAGVLAEVRRREFYEKPTTERKRAKASAVKRHAKKLARENARRTRLY.",
                                "residue": [
                                    {
                                        "position": "0",
                                        "acid": "M"
                                    },
                                    {
                                        "position": "1",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "2",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "3",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "4",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "5",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "6",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "7",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "8",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "9",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "10",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "11",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "12",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "13",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "14",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "15",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "16",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "17",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "18",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "19",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "20",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "21",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "22",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "23",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "24",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "25",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "26",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "27",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "28",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "29",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "30",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "31",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "32",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "33",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "34",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "35",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "36",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "37",
                                        "acid": "Y"
                                    },
                                    {
                                        "position": "38",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "39",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "40",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "41",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "42",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "43",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "44",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "45",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "46",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "47",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "48",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "49",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "50",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "51",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "52",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "53",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "54",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "55",
                                        "acid": "H"
                                    },
                                    {
                                        "position": "56",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "57",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "58",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "59",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "60",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "61",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "62",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "63",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "64",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "65",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "66",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "67",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "68",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "69",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "70",
                                        "acid": "Y"
                                    }
                                ],
                                "cleavage": [
                                    {
                                        "position": "0",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "1",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "2",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "3",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "4",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "5",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "6",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "7",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "8",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "9",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "10",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "9",
                                                    "ion_display_position": "9",
                                                    "spec_id": "373",
                                                    "peak_id": "20",
                                                    "peak_charge": "3"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "9",
                                                    "ion_display_position": "61",
                                                    "spec_id": "373",
                                                    "peak_id": "1",
                                                    "peak_charge": "12"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "11",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "10",
                                                    "ion_display_position": "10",
                                                    "spec_id": "373",
                                                    "peak_id": "23",
                                                    "peak_charge": "2"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "10",
                                                    "ion_display_position": "60",
                                                    "spec_id": "373",
                                                    "peak_id": "0",
                                                    "peak_charge": "12"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "12",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "13",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "12",
                                                    "ion_display_position": "12",
                                                    "spec_id": "373",
                                                    "peak_id": "11",
                                                    "peak_charge": "2"
                                                },
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "12",
                                                    "ion_display_position": "12",
                                                    "spec_id": "373",
                                                    "peak_id": "21",
                                                    "peak_charge": "3"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "12",
                                                    "ion_display_position": "58",
                                                    "spec_id": "373",
                                                    "peak_id": "2",
                                                    "peak_charge": "12"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "14",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "15",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "16",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "17",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "18",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "19",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "20",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "21",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "22",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "23",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "24",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "25",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "26",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "27",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "28",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "29",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "30",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "31",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "30",
                                                "ion_display_position": "40",
                                                "spec_id": "373",
                                                "peak_id": "13",
                                                "peak_charge": "8"
                                            }
                                        }
                                    },
                                    {
                                        "position": "32",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "33",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "34",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "35",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "34",
                                                "ion_display_position": "34",
                                                "spec_id": "373",
                                                "peak_id": "7",
                                                "peak_charge": "8"
                                            }
                                        }
                                    },
                                    {
                                        "position": "36",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "37",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "38",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "39",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "40",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "41",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "42",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "43",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "44",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "45",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "46",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "47",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "48",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "49",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "50",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "51",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "52",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "53",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "54",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "55",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "56",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "57",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "58",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "59",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "60",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "61",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "62",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "63",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "64",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "65",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "66",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "67",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "68",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "69",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "70",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "71",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    }
                                ],
                                "ptm": {
                                    "ptm_type": "Fixed",
                                    "ptm": {
                                        "abbreviation": "Carbamidomethylation",
                                        "unimod": "-1",
                                        "mono_mass": "57.0214640000"
                                    },
                                    "occurence": {
                                        "left_pos": "22",
                                        "right_pos": "23",
                                        "anno": "C"
                                    }
                                }
                            }
                        }
                    },
                    {
                        "prsm_id": "53",
                        "p_value": "9.19e-06",
                        "e_value": "9.19e-06",
                        "fdr": "0",
                        "matched_fragment_number": "7",
                        "matched_peak_number": "10",
                        "ms": {
                            "ms_header": {
                                "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                                "ms1_ids": "361",
                                "ms1_scans": "707",
                                "ids": "345",
                                "scans": "708",
                                "precursor_mono_mass": "8420.6381",
                                "precursor_charge": "16",
                                "precursor_mz": "527.2972",
                                "feature_inte": "1.2933e+08"
                            }
                        },
                        "annotated_protein": {
                            "sequence_id": "9",
                            "proteoform_id": "12",
                            "sequence_name": "sp|P68684|RS21_SALTY",
                            "sequence_description": "30S ribosomal protein S21 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpsU PE=3 SV=2",
                            "proteoform_mass": "8420.7075",
                            "n_acetylation": "0",
                            "unexpected_shift_number": "0",
                            "annotation": {
                                "protein_length": "71",
                                "first_residue_position": "1",
                                "last_residue_position": "70",
                                "annotated_seq": "M.PVIKVRENEPFDVALRRFKRS(C)[Carbamidomethylation]EKAGVLAEVRRREFYEKPTTERKRAKASAVKRHAKKLARENARRTRLY.",
                                "residue": [
                                    {
                                        "position": "0",
                                        "acid": "M"
                                    },
                                    {
                                        "position": "1",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "2",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "3",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "4",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "5",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "6",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "7",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "8",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "9",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "10",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "11",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "12",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "13",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "14",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "15",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "16",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "17",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "18",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "19",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "20",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "21",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "22",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "23",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "24",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "25",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "26",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "27",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "28",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "29",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "30",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "31",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "32",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "33",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "34",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "35",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "36",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "37",
                                        "acid": "Y"
                                    },
                                    {
                                        "position": "38",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "39",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "40",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "41",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "42",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "43",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "44",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "45",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "46",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "47",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "48",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "49",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "50",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "51",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "52",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "53",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "54",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "55",
                                        "acid": "H"
                                    },
                                    {
                                        "position": "56",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "57",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "58",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "59",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "60",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "61",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "62",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "63",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "64",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "65",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "66",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "67",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "68",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "69",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "70",
                                        "acid": "Y"
                                    }
                                ],
                                "cleavage": [
                                    {
                                        "position": "0",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "1",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "2",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "3",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "4",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "5",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "6",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "7",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "8",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "9",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "10",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "9",
                                                    "ion_display_position": "9",
                                                    "spec_id": "345",
                                                    "peak_id": "13",
                                                    "peak_charge": "3"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "9",
                                                    "ion_display_position": "61",
                                                    "spec_id": "345",
                                                    "peak_id": "3",
                                                    "peak_charge": "13"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "11",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "10",
                                                    "ion_display_position": "10",
                                                    "spec_id": "345",
                                                    "peak_id": "20",
                                                    "peak_charge": "3"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "10",
                                                    "ion_display_position": "60",
                                                    "spec_id": "345",
                                                    "peak_id": "1",
                                                    "peak_charge": "13"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "10",
                                                    "ion_display_position": "60",
                                                    "spec_id": "345",
                                                    "peak_id": "4",
                                                    "peak_charge": "12"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "12",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "13",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "12",
                                                    "ion_display_position": "12",
                                                    "spec_id": "345",
                                                    "peak_id": "14",
                                                    "peak_charge": "3"
                                                },
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "12",
                                                    "ion_display_position": "12",
                                                    "spec_id": "345",
                                                    "peak_id": "11",
                                                    "peak_charge": "2"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "12",
                                                    "ion_display_position": "58",
                                                    "spec_id": "345",
                                                    "peak_id": "0",
                                                    "peak_charge": "13"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "14",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "15",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "16",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "17",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "18",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "19",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "20",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "21",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "22",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "23",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "24",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "25",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "26",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "27",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "28",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "29",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "30",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "31",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "30",
                                                    "ion_display_position": "40",
                                                    "spec_id": "345",
                                                    "peak_id": "8",
                                                    "peak_charge": "9"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "30",
                                                    "ion_display_position": "40",
                                                    "spec_id": "345",
                                                    "peak_id": "2",
                                                    "peak_charge": "10"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "32",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "33",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "34",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "35",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "36",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "37",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "38",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "39",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "40",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "41",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "42",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "43",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "44",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "45",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "46",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "47",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "48",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "49",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "50",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "51",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "52",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "53",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "54",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "55",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "56",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "57",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "58",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "59",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "60",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "61",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "62",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "63",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "64",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "65",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "66",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "67",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "68",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "69",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "70",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "71",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    }
                                ],
                                "ptm": {
                                    "ptm_type": "Fixed",
                                    "ptm": {
                                        "abbreviation": "Carbamidomethylation",
                                        "unimod": "-1",
                                        "mono_mass": "57.0214640000"
                                    },
                                    "occurence": {
                                        "left_pos": "22",
                                        "right_pos": "23",
                                        "anno": "C"
                                    }
                                }
                            }
                        }
                    },
                    {
                        "prsm_id": "56",
                        "p_value": "3.15e-05",
                        "e_value": "3.15e-05",
                        "fdr": "0",
                        "matched_fragment_number": "7",
                        "matched_peak_number": "8",
                        "ms": {
                            "ms_header": {
                                "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                                "ms1_ids": "373",
                                "ms1_scans": "731",
                                "ids": "357",
                                "scans": "732",
                                "precursor_mono_mass": "8420.6578",
                                "precursor_charge": "14",
                                "precursor_mz": "602.4828",
                                "feature_inte": "1.7663e+08"
                            }
                        },
                        "annotated_protein": {
                            "sequence_id": "9",
                            "proteoform_id": "12",
                            "sequence_name": "sp|P68684|RS21_SALTY",
                            "sequence_description": "30S ribosomal protein S21 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpsU PE=3 SV=2",
                            "proteoform_mass": "8420.6928",
                            "n_acetylation": "0",
                            "unexpected_shift_number": "1",
                            "annotation": {
                                "protein_length": "71",
                                "first_residue_position": "1",
                                "last_residue_position": "70",
                                "annotated_seq": "M.PV(IK)[-0.0147]VRENEPFDVALRRFKRS(C)[Carbamidomethylation]EKAGVLAEVRRREFYEKPTTERKRAKASAVKRHAKKLARENARRTRLY.",
                                "residue": [
                                    {
                                        "position": "0",
                                        "acid": "M"
                                    },
                                    {
                                        "position": "1",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "2",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "3",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "4",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "5",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "6",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "7",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "8",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "9",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "10",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "11",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "12",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "13",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "14",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "15",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "16",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "17",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "18",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "19",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "20",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "21",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "22",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "23",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "24",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "25",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "26",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "27",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "28",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "29",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "30",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "31",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "32",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "33",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "34",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "35",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "36",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "37",
                                        "acid": "Y"
                                    },
                                    {
                                        "position": "38",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "39",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "40",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "41",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "42",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "43",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "44",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "45",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "46",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "47",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "48",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "49",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "50",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "51",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "52",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "53",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "54",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "55",
                                        "acid": "H"
                                    },
                                    {
                                        "position": "56",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "57",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "58",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "59",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "60",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "61",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "62",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "63",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "64",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "65",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "66",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "67",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "68",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "69",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "70",
                                        "acid": "Y"
                                    }
                                ],
                                "cleavage": [
                                    {
                                        "position": "0",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "1",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "2",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "3",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "2",
                                                "ion_display_position": "68",
                                                "spec_id": "357",
                                                "peak_id": "0",
                                                "peak_charge": "13"
                                            }
                                        }
                                    },
                                    {
                                        "position": "4",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "5",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "4",
                                                "ion_display_position": "66",
                                                "spec_id": "357",
                                                "peak_id": "18",
                                                "peak_charge": "12"
                                            }
                                        }
                                    },
                                    {
                                        "position": "6",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "7",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "8",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "9",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "10",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "11",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "12",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "13",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "12",
                                                    "ion_display_position": "12",
                                                    "spec_id": "357",
                                                    "peak_id": "11",
                                                    "peak_charge": "2"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "12",
                                                    "ion_display_position": "58",
                                                    "spec_id": "357",
                                                    "peak_id": "1",
                                                    "peak_charge": "11"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "14",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "15",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "16",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "17",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "18",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "19",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "20",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "21",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "22",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "23",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "24",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "25",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "26",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "27",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "28",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "29",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "30",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "31",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "30",
                                                    "ion_display_position": "30",
                                                    "spec_id": "357",
                                                    "peak_id": "7",
                                                    "peak_charge": "5"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "30",
                                                    "ion_display_position": "40",
                                                    "spec_id": "357",
                                                    "peak_id": "2",
                                                    "peak_charge": "9"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "30",
                                                    "ion_display_position": "40",
                                                    "spec_id": "357",
                                                    "peak_id": "3",
                                                    "peak_charge": "8"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "32",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "33",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "34",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "35",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "34",
                                                "ion_display_position": "36",
                                                "spec_id": "357",
                                                "peak_id": "19",
                                                "peak_charge": "6"
                                            }
                                        }
                                    },
                                    {
                                        "position": "36",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "37",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "38",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "39",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "40",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "41",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "42",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "43",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "44",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "45",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "46",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "47",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "48",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "49",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "50",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "51",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "52",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "53",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "54",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "55",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "56",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "57",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "58",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "59",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "60",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "61",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "62",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "63",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "64",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "65",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "66",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "67",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "68",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "69",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "70",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "71",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    }
                                ],
                                "ptm": {
                                    "ptm_type": "Fixed",
                                    "ptm": {
                                        "abbreviation": "Carbamidomethylation",
                                        "unimod": "-1",
                                        "mono_mass": "57.0214640000"
                                    },
                                    "occurence": {
                                        "left_pos": "22",
                                        "right_pos": "23",
                                        "anno": "C"
                                    }
                                },
                                "mass_shift": {
                                    "id": "0",
                                    "left_position": "3",
                                    "right_position": "5",
                                    "shift": "-1.4703276116e-02",
                                    "anno": "-0.0147",
                                    "shift_type": "unexpected"
                                }
                            }
                        }
                    },
                    {
                        "prsm_id": "58",
                        "p_value": "1.70e-04",
                        "e_value": "1.70e-04",
                        "fdr": "0",
                        "matched_fragment_number": "7",
                        "matched_peak_number": "8",
                        "ms": {
                            "ms_header": {
                                "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                                "ms1_ids": "376",
                                "ms1_scans": "737",
                                "ids": "360",
                                "scans": "738",
                                "precursor_mono_mass": "8420.6578",
                                "precursor_charge": "16",
                                "precursor_mz": "527.2984",
                                "feature_inte": "1.7663e+08"
                            }
                        },
                        "annotated_protein": {
                            "sequence_id": "9",
                            "proteoform_id": "12",
                            "sequence_name": "sp|P68684|RS21_SALTY",
                            "sequence_description": "30S ribosomal protein S21 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpsU PE=3 SV=2",
                            "proteoform_mass": "8420.6628",
                            "n_acetylation": "0",
                            "unexpected_shift_number": "1",
                            "annotation": {
                                "protein_length": "71",
                                "first_residue_position": "1",
                                "last_residue_position": "70",
                                "annotated_seq": "M.PVIKVRENEPFDVALRRFKRS(C)[Carbamidomethylation]EKAGVLAEVRRREFYEK(PTTERKRAKASAVKRHAKKLARENARRTRLY)[-0.0447].",
                                "residue": [
                                    {
                                        "position": "0",
                                        "acid": "M"
                                    },
                                    {
                                        "position": "1",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "2",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "3",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "4",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "5",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "6",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "7",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "8",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "9",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "10",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "11",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "12",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "13",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "14",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "15",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "16",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "17",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "18",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "19",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "20",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "21",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "22",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "23",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "24",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "25",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "26",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "27",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "28",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "29",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "30",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "31",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "32",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "33",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "34",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "35",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "36",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "37",
                                        "acid": "Y"
                                    },
                                    {
                                        "position": "38",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "39",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "40",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "41",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "42",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "43",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "44",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "45",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "46",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "47",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "48",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "49",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "50",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "51",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "52",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "53",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "54",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "55",
                                        "acid": "H"
                                    },
                                    {
                                        "position": "56",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "57",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "58",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "59",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "60",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "61",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "62",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "63",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "64",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "65",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "66",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "67",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "68",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "69",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "70",
                                        "acid": "Y"
                                    }
                                ],
                                "cleavage": [
                                    {
                                        "position": "0",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "1",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "2",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "3",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "4",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "5",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "6",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "7",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "8",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "9",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "10",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "9",
                                                    "ion_display_position": "9",
                                                    "spec_id": "360",
                                                    "peak_id": "14",
                                                    "peak_charge": "3"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "9",
                                                    "ion_display_position": "61",
                                                    "spec_id": "360",
                                                    "peak_id": "2",
                                                    "peak_charge": "13"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "11",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "12",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "13",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "12",
                                                    "ion_display_position": "12",
                                                    "spec_id": "360",
                                                    "peak_id": "10",
                                                    "peak_charge": "3"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "12",
                                                    "ion_display_position": "58",
                                                    "spec_id": "360",
                                                    "peak_id": "0",
                                                    "peak_charge": "13"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "12",
                                                    "ion_display_position": "58",
                                                    "spec_id": "360",
                                                    "peak_id": "19",
                                                    "peak_charge": "12"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "14",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "15",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "16",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "17",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "18",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "19",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "20",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "21",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "22",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "23",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "24",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "25",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "26",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "27",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "28",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "29",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "30",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "31",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "30",
                                                "ion_display_position": "40",
                                                "spec_id": "360",
                                                "peak_id": "5",
                                                "peak_charge": "9"
                                            }
                                        }
                                    },
                                    {
                                        "position": "32",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "33",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "34",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "35",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "34",
                                                "ion_display_position": "36",
                                                "spec_id": "360",
                                                "peak_id": "9",
                                                "peak_charge": "7"
                                            }
                                        }
                                    },
                                    {
                                        "position": "36",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "37",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "38",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "39",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "40",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "39",
                                                "ion_display_position": "31",
                                                "spec_id": "360",
                                                "peak_id": "7",
                                                "peak_charge": "8"
                                            }
                                        }
                                    },
                                    {
                                        "position": "41",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "42",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "43",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "44",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "45",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "46",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "47",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "48",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "49",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "50",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "51",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "52",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "53",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "54",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "55",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "56",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "57",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "58",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "59",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "60",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "61",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "62",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "63",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "64",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "65",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "66",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "67",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "68",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "69",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "70",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "71",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    }
                                ],
                                "ptm": {
                                    "ptm_type": "Fixed",
                                    "ptm": {
                                        "abbreviation": "Carbamidomethylation",
                                        "unimod": "-1",
                                        "mono_mass": "57.0214640000"
                                    },
                                    "occurence": {
                                        "left_pos": "22",
                                        "right_pos": "23",
                                        "anno": "C"
                                    }
                                },
                                "mass_shift": {
                                    "id": "0",
                                    "left_position": "40",
                                    "right_position": "71",
                                    "shift": "-4.4693276118e-02",
                                    "anno": "-0.0447",
                                    "shift_type": "unexpected"
                                }
                            }
                        }
                    },
                    {
                        "prsm_id": "51",
                        "p_value": "2.75e-04",
                        "e_value": "2.75e-04",
                        "fdr": "0",
                        "matched_fragment_number": "7",
                        "matched_peak_number": "8",
                        "ms": {
                            "ms_header": {
                                "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                                "ms1_ids": "357",
                                "ms1_scans": "699",
                                "ids": "341",
                                "scans": "700",
                                "precursor_mono_mass": "8420.6381",
                                "precursor_charge": "16",
                                "precursor_mz": "527.2972",
                                "feature_inte": "1.2933e+08"
                            }
                        },
                        "annotated_protein": {
                            "sequence_id": "9",
                            "proteoform_id": "12",
                            "sequence_name": "sp|P68684|RS21_SALTY",
                            "sequence_description": "30S ribosomal protein S21 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpsU PE=3 SV=2",
                            "proteoform_mass": "8419.6508",
                            "n_acetylation": "0",
                            "unexpected_shift_number": "1",
                            "annotation": {
                                "protein_length": "71",
                                "first_residue_position": "1",
                                "last_residue_position": "70",
                                "annotated_seq": "M.PVIKVRENEPFDVALRRFKRS(C)[Carbamidomethylation]EKAGVLAE(VRRREFYEKPTTERKRAKASAVKRHAKKLARENARRTRLY)[-1.0567].",
                                "residue": [
                                    {
                                        "position": "0",
                                        "acid": "M"
                                    },
                                    {
                                        "position": "1",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "2",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "3",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "4",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "5",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "6",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "7",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "8",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "9",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "10",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "11",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "12",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "13",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "14",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "15",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "16",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "17",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "18",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "19",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "20",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "21",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "22",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "23",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "24",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "25",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "26",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "27",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "28",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "29",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "30",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "31",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "32",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "33",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "34",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "35",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "36",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "37",
                                        "acid": "Y"
                                    },
                                    {
                                        "position": "38",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "39",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "40",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "41",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "42",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "43",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "44",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "45",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "46",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "47",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "48",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "49",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "50",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "51",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "52",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "53",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "54",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "55",
                                        "acid": "H"
                                    },
                                    {
                                        "position": "56",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "57",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "58",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "59",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "60",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "61",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "62",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "63",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "64",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "65",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "66",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "67",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "68",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "69",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "70",
                                        "acid": "Y"
                                    }
                                ],
                                "cleavage": [
                                    {
                                        "position": "0",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "1",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "2",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "3",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "4",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "5",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "6",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "7",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "8",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "9",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "10",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "9",
                                                    "ion_display_position": "9",
                                                    "spec_id": "341",
                                                    "peak_id": "18",
                                                    "peak_charge": "3"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "9",
                                                    "ion_display_position": "61",
                                                    "spec_id": "341",
                                                    "peak_id": "2",
                                                    "peak_charge": "13"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "11",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "10",
                                                "ion_display_position": "10",
                                                "spec_id": "341",
                                                "peak_id": "21",
                                                "peak_charge": "3"
                                            }
                                        }
                                    },
                                    {
                                        "position": "12",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "11",
                                                "ion_display_position": "59",
                                                "spec_id": "341",
                                                "peak_id": "4",
                                                "peak_charge": "12"
                                            }
                                        }
                                    },
                                    {
                                        "position": "13",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "12",
                                                    "ion_display_position": "12",
                                                    "spec_id": "341",
                                                    "peak_id": "17",
                                                    "peak_charge": "2"
                                                },
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "12",
                                                    "ion_display_position": "12",
                                                    "spec_id": "341",
                                                    "peak_id": "15",
                                                    "peak_charge": "3"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "12",
                                                    "ion_display_position": "58",
                                                    "spec_id": "341",
                                                    "peak_id": "1",
                                                    "peak_charge": "13"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "14",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "15",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "16",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "17",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "18",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "19",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "20",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "21",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "22",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "23",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "24",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "25",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "26",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "27",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "28",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "29",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "30",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "31",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "30",
                                                "ion_display_position": "40",
                                                "spec_id": "341",
                                                "peak_id": "9",
                                                "peak_charge": "9"
                                            }
                                        }
                                    },
                                    {
                                        "position": "32",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "33",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "34",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "35",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "36",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "37",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "38",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "39",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "40",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "41",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "42",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "43",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "44",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "45",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "46",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "47",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "48",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "49",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "50",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "51",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "52",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "53",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "54",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "55",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "56",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "57",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "58",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "59",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "60",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "61",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "62",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "63",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "64",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "65",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "66",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "67",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "68",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "69",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "70",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "71",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    }
                                ],
                                "ptm": {
                                    "ptm_type": "Fixed",
                                    "ptm": {
                                        "abbreviation": "Carbamidomethylation",
                                        "unimod": "-1",
                                        "mono_mass": "57.0214640000"
                                    },
                                    "occurence": {
                                        "left_pos": "22",
                                        "right_pos": "23",
                                        "anno": "C"
                                    }
                                },
                                "mass_shift": {
                                    "id": "0",
                                    "left_position": "31",
                                    "right_position": "71",
                                    "shift": "-1.0566932761",
                                    "anno": "-1.0567",
                                    "shift_type": "unexpected"
                                }
                            }
                        }
                    },
                    {
                        "prsm_id": "57",
                        "p_value": "2.55e-03",
                        "e_value": "2.56e-03",
                        "fdr": "0",
                        "matched_fragment_number": "5",
                        "matched_peak_number": "6",
                        "ms": {
                            "ms_header": {
                                "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                                "ms1_ids": "375",
                                "ms1_scans": "735",
                                "ids": "359",
                                "scans": "736",
                                "precursor_mono_mass": "8420.6578",
                                "precursor_charge": "14",
                                "precursor_mz": "602.4828",
                                "feature_inte": "1.7663e+08"
                            }
                        },
                        "annotated_protein": {
                            "sequence_id": "9",
                            "proteoform_id": "12",
                            "sequence_name": "sp|P68684|RS21_SALTY",
                            "sequence_description": "30S ribosomal protein S21 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpsU PE=3 SV=2",
                            "proteoform_mass": "8420.6728",
                            "n_acetylation": "0",
                            "unexpected_shift_number": "1",
                            "annotation": {
                                "protein_length": "71",
                                "first_residue_position": "1",
                                "last_residue_position": "70",
                                "annotated_seq": "M.PVIKVRENEPFD(VALRRFKRS(C)[Carbamidomethylation]EKAGVLAE)[-0.0347]VRRREFYEKPTTERKRAKASAVKRHAKKLARENARRTRLY.",
                                "residue": [
                                    {
                                        "position": "0",
                                        "acid": "M"
                                    },
                                    {
                                        "position": "1",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "2",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "3",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "4",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "5",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "6",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "7",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "8",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "9",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "10",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "11",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "12",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "13",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "14",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "15",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "16",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "17",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "18",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "19",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "20",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "21",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "22",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "23",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "24",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "25",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "26",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "27",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "28",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "29",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "30",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "31",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "32",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "33",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "34",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "35",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "36",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "37",
                                        "acid": "Y"
                                    },
                                    {
                                        "position": "38",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "39",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "40",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "41",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "42",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "43",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "44",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "45",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "46",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "47",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "48",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "49",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "50",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "51",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "52",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "53",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "54",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "55",
                                        "acid": "H"
                                    },
                                    {
                                        "position": "56",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "57",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "58",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "59",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "60",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "61",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "62",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "63",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "64",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "65",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "66",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "67",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "68",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "69",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "70",
                                        "acid": "Y"
                                    }
                                ],
                                "cleavage": [
                                    {
                                        "position": "0",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "1",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "2",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "3",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "4",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "5",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "6",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "7",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "8",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "9",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "10",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "11",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "12",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "13",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "12",
                                                    "ion_display_position": "12",
                                                    "spec_id": "359",
                                                    "peak_id": "6",
                                                    "peak_charge": "2"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "12",
                                                    "ion_display_position": "58",
                                                    "spec_id": "359",
                                                    "peak_id": "20",
                                                    "peak_charge": "11"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "14",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "15",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "16",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "17",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "18",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "19",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "20",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "21",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "22",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "23",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "24",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "25",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "26",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "27",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "28",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "29",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "30",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "31",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "30",
                                                    "ion_display_position": "30",
                                                    "spec_id": "359",
                                                    "peak_id": "4",
                                                    "peak_charge": "5"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "30",
                                                    "ion_display_position": "40",
                                                    "spec_id": "359",
                                                    "peak_id": "0",
                                                    "peak_charge": "9"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "30",
                                                    "ion_display_position": "40",
                                                    "spec_id": "359",
                                                    "peak_id": "2",
                                                    "peak_charge": "8"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "32",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "33",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "34",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "35",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "34",
                                                "ion_display_position": "36",
                                                "spec_id": "359",
                                                "peak_id": "18",
                                                "peak_charge": "6"
                                            }
                                        }
                                    },
                                    {
                                        "position": "36",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "37",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "38",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "39",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "40",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "41",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "42",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "43",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "44",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "45",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "46",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "47",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "48",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "49",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "50",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "51",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "52",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "53",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "54",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "55",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "56",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "57",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "58",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "59",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "60",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "61",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "62",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "63",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "64",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "65",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "66",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "67",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "68",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "69",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "70",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "71",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    }
                                ],
                                "ptm": {
                                    "ptm_type": "Fixed",
                                    "ptm": {
                                        "abbreviation": "Carbamidomethylation",
                                        "unimod": "-1",
                                        "mono_mass": "57.0214640000"
                                    },
                                    "occurence": {
                                        "left_pos": "22",
                                        "right_pos": "23",
                                        "anno": "C"
                                    }
                                },
                                "mass_shift": {
                                    "id": "0",
                                    "left_position": "13",
                                    "right_position": "31",
                                    "shift": "-3.4703276116e-02",
                                    "anno": "-0.0347",
                                    "shift_type": "unexpected"
                                }
                            }
                        }
                    }
                ]
            },
            {
                "sequence_id": "9",
                "sequence_name": "sp|P68684|RS21_SALTY",
                "sequence_description": "30S ribosomal protein S21 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpsU PE=3 SV=2",
                "proteoform_id": "29",
                "prsm_number": "1",
                "prsm": {
                    "prsm_id": "34",
                    "p_value": "8.82e-07",
                    "e_value": "8.82e-07",
                    "fdr": "0",
                    "matched_fragment_number": "11",
                    "matched_peak_number": "14",
                    "ms": {
                        "ms_header": {
                            "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                            "ms1_ids": "284",
                            "ms1_scans": "553",
                            "ids": "268",
                            "scans": "554",
                            "precursor_mono_mass": "2554.4360",
                            "precursor_charge": "5",
                            "precursor_mz": "511.8945",
                            "feature_inte": "1.2455e+07"
                        }
                    },
                    "annotated_protein": {
                        "sequence_id": "9",
                        "proteoform_id": "29",
                        "sequence_name": "sp|P68684|RS21_SALTY",
                        "sequence_description": "30S ribosomal protein S21 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpsU PE=3 SV=2",
                        "proteoform_mass": "2554.4460",
                        "n_acetylation": "0",
                        "unexpected_shift_number": "1",
                        "annotation": {
                            "protein_length": "71",
                            "first_residue_position": "1",
                            "last_residue_position": "21",
                            "annotated_seq": "M.PVIKVRENEPFD(VALRRFKRS)[-0.9988].C",
                            "residue": [
                                {
                                    "position": "0",
                                    "acid": "M"
                                },
                                {
                                    "position": "1",
                                    "acid": "P"
                                },
                                {
                                    "position": "2",
                                    "acid": "V"
                                },
                                {
                                    "position": "3",
                                    "acid": "I"
                                },
                                {
                                    "position": "4",
                                    "acid": "K"
                                },
                                {
                                    "position": "5",
                                    "acid": "V"
                                },
                                {
                                    "position": "6",
                                    "acid": "R"
                                },
                                {
                                    "position": "7",
                                    "acid": "E"
                                },
                                {
                                    "position": "8",
                                    "acid": "N"
                                },
                                {
                                    "position": "9",
                                    "acid": "E"
                                },
                                {
                                    "position": "10",
                                    "acid": "P"
                                },
                                {
                                    "position": "11",
                                    "acid": "F"
                                },
                                {
                                    "position": "12",
                                    "acid": "D"
                                },
                                {
                                    "position": "13",
                                    "acid": "V"
                                },
                                {
                                    "position": "14",
                                    "acid": "A"
                                },
                                {
                                    "position": "15",
                                    "acid": "L"
                                },
                                {
                                    "position": "16",
                                    "acid": "R"
                                },
                                {
                                    "position": "17",
                                    "acid": "R"
                                },
                                {
                                    "position": "18",
                                    "acid": "F"
                                },
                                {
                                    "position": "19",
                                    "acid": "K"
                                },
                                {
                                    "position": "20",
                                    "acid": "R"
                                },
                                {
                                    "position": "21",
                                    "acid": "S"
                                },
                                {
                                    "position": "22",
                                    "acid": "C"
                                },
                                {
                                    "position": "23",
                                    "acid": "E"
                                },
                                {
                                    "position": "24",
                                    "acid": "K"
                                },
                                {
                                    "position": "25",
                                    "acid": "A"
                                },
                                {
                                    "position": "26",
                                    "acid": "G"
                                },
                                {
                                    "position": "27",
                                    "acid": "V"
                                },
                                {
                                    "position": "28",
                                    "acid": "L"
                                },
                                {
                                    "position": "29",
                                    "acid": "A"
                                },
                                {
                                    "position": "30",
                                    "acid": "E"
                                },
                                {
                                    "position": "31",
                                    "acid": "V"
                                },
                                {
                                    "position": "32",
                                    "acid": "R"
                                },
                                {
                                    "position": "33",
                                    "acid": "R"
                                },
                                {
                                    "position": "34",
                                    "acid": "R"
                                },
                                {
                                    "position": "35",
                                    "acid": "E"
                                },
                                {
                                    "position": "36",
                                    "acid": "F"
                                },
                                {
                                    "position": "37",
                                    "acid": "Y"
                                },
                                {
                                    "position": "38",
                                    "acid": "E"
                                },
                                {
                                    "position": "39",
                                    "acid": "K"
                                },
                                {
                                    "position": "40",
                                    "acid": "P"
                                },
                                {
                                    "position": "41",
                                    "acid": "T"
                                },
                                {
                                    "position": "42",
                                    "acid": "T"
                                },
                                {
                                    "position": "43",
                                    "acid": "E"
                                },
                                {
                                    "position": "44",
                                    "acid": "R"
                                },
                                {
                                    "position": "45",
                                    "acid": "K"
                                },
                                {
                                    "position": "46",
                                    "acid": "R"
                                },
                                {
                                    "position": "47",
                                    "acid": "A"
                                },
                                {
                                    "position": "48",
                                    "acid": "K"
                                },
                                {
                                    "position": "49",
                                    "acid": "A"
                                },
                                {
                                    "position": "50",
                                    "acid": "S"
                                },
                                {
                                    "position": "51",
                                    "acid": "A"
                                },
                                {
                                    "position": "52",
                                    "acid": "V"
                                },
                                {
                                    "position": "53",
                                    "acid": "K"
                                },
                                {
                                    "position": "54",
                                    "acid": "R"
                                },
                                {
                                    "position": "55",
                                    "acid": "H"
                                },
                                {
                                    "position": "56",
                                    "acid": "A"
                                },
                                {
                                    "position": "57",
                                    "acid": "K"
                                },
                                {
                                    "position": "58",
                                    "acid": "K"
                                },
                                {
                                    "position": "59",
                                    "acid": "L"
                                },
                                {
                                    "position": "60",
                                    "acid": "A"
                                },
                                {
                                    "position": "61",
                                    "acid": "R"
                                },
                                {
                                    "position": "62",
                                    "acid": "E"
                                },
                                {
                                    "position": "63",
                                    "acid": "N"
                                },
                                {
                                    "position": "64",
                                    "acid": "A"
                                },
                                {
                                    "position": "65",
                                    "acid": "R"
                                },
                                {
                                    "position": "66",
                                    "acid": "R"
                                },
                                {
                                    "position": "67",
                                    "acid": "T"
                                },
                                {
                                    "position": "68",
                                    "acid": "R"
                                },
                                {
                                    "position": "69",
                                    "acid": "L"
                                },
                                {
                                    "position": "70",
                                    "acid": "Y"
                                }
                            ],
                            "cleavage": [
                                {
                                    "position": "0",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "1",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "2",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "1",
                                            "ion_display_position": "20",
                                            "spec_id": "268",
                                            "peak_id": "10",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "3",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "2",
                                            "ion_display_position": "19",
                                            "spec_id": "268",
                                            "peak_id": "9",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "4",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "3",
                                                "ion_display_position": "18",
                                                "spec_id": "268",
                                                "peak_id": "7",
                                                "peak_charge": "4"
                                            },
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "3",
                                                "ion_display_position": "18",
                                                "spec_id": "268",
                                                "peak_id": "1",
                                                "peak_charge": "3"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "5",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "4",
                                                "ion_display_position": "17",
                                                "spec_id": "268",
                                                "peak_id": "14",
                                                "peak_charge": "4"
                                            },
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "4",
                                                "ion_display_position": "17",
                                                "spec_id": "268",
                                                "peak_id": "2",
                                                "peak_charge": "3"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "6",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "7",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "8",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "7",
                                            "ion_display_position": "14",
                                            "spec_id": "268",
                                            "peak_id": "13",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "9",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "10",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "9",
                                                "ion_display_position": "9",
                                                "spec_id": "268",
                                                "peak_id": "25",
                                                "peak_charge": "2"
                                            },
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "9",
                                                "ion_display_position": "12",
                                                "spec_id": "268",
                                                "peak_id": "4",
                                                "peak_charge": "2"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "11",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "10",
                                            "ion_display_position": "11",
                                            "spec_id": "268",
                                            "peak_id": "27",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "12",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "11",
                                            "ion_display_position": "10",
                                            "spec_id": "268",
                                            "peak_id": "16",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "13",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "12",
                                                "ion_display_position": "9",
                                                "spec_id": "268",
                                                "peak_id": "22",
                                                "peak_charge": "2"
                                            },
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "12",
                                                "ion_display_position": "9",
                                                "spec_id": "268",
                                                "peak_id": "17",
                                                "peak_charge": "3"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "12",
                                                "ion_display_position": "12",
                                                "spec_id": "268",
                                                "peak_id": "8",
                                                "peak_charge": "2"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "14",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "15",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "16",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "17",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "18",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "19",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "20",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "21",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "22",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "23",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "24",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "25",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "26",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "27",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "28",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "29",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "30",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "31",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "32",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "33",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "34",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "35",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "36",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "37",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "38",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "39",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "40",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "41",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "42",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "43",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "44",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "45",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "46",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "47",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "48",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "49",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "50",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "51",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "52",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "53",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "54",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "55",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "56",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "57",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "58",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "59",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "60",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "61",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "62",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "63",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "64",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "65",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "66",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "67",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "68",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "69",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "70",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "71",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                }
                            ],
                            "mass_shift": {
                                "id": "0",
                                "left_position": "13",
                                "right_position": "22",
                                "shift": "-9.9882885366e-01",
                                "anno": "-0.9988",
                                "shift_type": "unexpected"
                            }
                        }
                    }
                }
            },
            {
                "sequence_id": "9",
                "sequence_name": "sp|P68684|RS21_SALTY",
                "sequence_description": "30S ribosomal protein S21 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpsU PE=3 SV=2",
                "proteoform_id": "35",
                "prsm_number": "1",
                "prsm": {
                    "prsm_id": "54",
                    "p_value": "4.96e-05",
                    "e_value": "4.96e-05",
                    "fdr": "0",
                    "matched_fragment_number": "8",
                    "matched_peak_number": "8",
                    "ms": {
                        "ms_header": {
                            "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                            "ms1_ids": "363",
                            "ms1_scans": "711",
                            "ids": "347",
                            "scans": "712",
                            "precursor_mono_mass": "2183.2173",
                            "precursor_charge": "4",
                            "precursor_mz": "546.8116",
                            "feature_inte": "1.8850e+06"
                        }
                    },
                    "annotated_protein": {
                        "sequence_id": "9",
                        "proteoform_id": "35",
                        "sequence_name": "sp|P68684|RS21_SALTY",
                        "sequence_description": "30S ribosomal protein S21 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpsU PE=3 SV=2",
                        "proteoform_mass": "2183.2173",
                        "n_acetylation": "0",
                        "unexpected_shift_number": "1",
                        "annotation": {
                            "protein_length": "71",
                            "first_residue_position": "1",
                            "last_residue_position": "21",
                            "annotated_seq": "M.PVIKVRENEPFD(VALRRFKRS)[-372.2275].C",
                            "residue": [
                                {
                                    "position": "0",
                                    "acid": "M"
                                },
                                {
                                    "position": "1",
                                    "acid": "P"
                                },
                                {
                                    "position": "2",
                                    "acid": "V"
                                },
                                {
                                    "position": "3",
                                    "acid": "I"
                                },
                                {
                                    "position": "4",
                                    "acid": "K"
                                },
                                {
                                    "position": "5",
                                    "acid": "V"
                                },
                                {
                                    "position": "6",
                                    "acid": "R"
                                },
                                {
                                    "position": "7",
                                    "acid": "E"
                                },
                                {
                                    "position": "8",
                                    "acid": "N"
                                },
                                {
                                    "position": "9",
                                    "acid": "E"
                                },
                                {
                                    "position": "10",
                                    "acid": "P"
                                },
                                {
                                    "position": "11",
                                    "acid": "F"
                                },
                                {
                                    "position": "12",
                                    "acid": "D"
                                },
                                {
                                    "position": "13",
                                    "acid": "V"
                                },
                                {
                                    "position": "14",
                                    "acid": "A"
                                },
                                {
                                    "position": "15",
                                    "acid": "L"
                                },
                                {
                                    "position": "16",
                                    "acid": "R"
                                },
                                {
                                    "position": "17",
                                    "acid": "R"
                                },
                                {
                                    "position": "18",
                                    "acid": "F"
                                },
                                {
                                    "position": "19",
                                    "acid": "K"
                                },
                                {
                                    "position": "20",
                                    "acid": "R"
                                },
                                {
                                    "position": "21",
                                    "acid": "S"
                                },
                                {
                                    "position": "22",
                                    "acid": "C"
                                },
                                {
                                    "position": "23",
                                    "acid": "E"
                                },
                                {
                                    "position": "24",
                                    "acid": "K"
                                },
                                {
                                    "position": "25",
                                    "acid": "A"
                                },
                                {
                                    "position": "26",
                                    "acid": "G"
                                },
                                {
                                    "position": "27",
                                    "acid": "V"
                                },
                                {
                                    "position": "28",
                                    "acid": "L"
                                },
                                {
                                    "position": "29",
                                    "acid": "A"
                                },
                                {
                                    "position": "30",
                                    "acid": "E"
                                },
                                {
                                    "position": "31",
                                    "acid": "V"
                                },
                                {
                                    "position": "32",
                                    "acid": "R"
                                },
                                {
                                    "position": "33",
                                    "acid": "R"
                                },
                                {
                                    "position": "34",
                                    "acid": "R"
                                },
                                {
                                    "position": "35",
                                    "acid": "E"
                                },
                                {
                                    "position": "36",
                                    "acid": "F"
                                },
                                {
                                    "position": "37",
                                    "acid": "Y"
                                },
                                {
                                    "position": "38",
                                    "acid": "E"
                                },
                                {
                                    "position": "39",
                                    "acid": "K"
                                },
                                {
                                    "position": "40",
                                    "acid": "P"
                                },
                                {
                                    "position": "41",
                                    "acid": "T"
                                },
                                {
                                    "position": "42",
                                    "acid": "T"
                                },
                                {
                                    "position": "43",
                                    "acid": "E"
                                },
                                {
                                    "position": "44",
                                    "acid": "R"
                                },
                                {
                                    "position": "45",
                                    "acid": "K"
                                },
                                {
                                    "position": "46",
                                    "acid": "R"
                                },
                                {
                                    "position": "47",
                                    "acid": "A"
                                },
                                {
                                    "position": "48",
                                    "acid": "K"
                                },
                                {
                                    "position": "49",
                                    "acid": "A"
                                },
                                {
                                    "position": "50",
                                    "acid": "S"
                                },
                                {
                                    "position": "51",
                                    "acid": "A"
                                },
                                {
                                    "position": "52",
                                    "acid": "V"
                                },
                                {
                                    "position": "53",
                                    "acid": "K"
                                },
                                {
                                    "position": "54",
                                    "acid": "R"
                                },
                                {
                                    "position": "55",
                                    "acid": "H"
                                },
                                {
                                    "position": "56",
                                    "acid": "A"
                                },
                                {
                                    "position": "57",
                                    "acid": "K"
                                },
                                {
                                    "position": "58",
                                    "acid": "K"
                                },
                                {
                                    "position": "59",
                                    "acid": "L"
                                },
                                {
                                    "position": "60",
                                    "acid": "A"
                                },
                                {
                                    "position": "61",
                                    "acid": "R"
                                },
                                {
                                    "position": "62",
                                    "acid": "E"
                                },
                                {
                                    "position": "63",
                                    "acid": "N"
                                },
                                {
                                    "position": "64",
                                    "acid": "A"
                                },
                                {
                                    "position": "65",
                                    "acid": "R"
                                },
                                {
                                    "position": "66",
                                    "acid": "R"
                                },
                                {
                                    "position": "67",
                                    "acid": "T"
                                },
                                {
                                    "position": "68",
                                    "acid": "R"
                                },
                                {
                                    "position": "69",
                                    "acid": "L"
                                },
                                {
                                    "position": "70",
                                    "acid": "Y"
                                }
                            ],
                            "cleavage": [
                                {
                                    "position": "0",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "1",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "2",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "1",
                                            "ion_display_position": "20",
                                            "spec_id": "347",
                                            "peak_id": "1",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "3",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "2",
                                            "ion_display_position": "19",
                                            "spec_id": "347",
                                            "peak_id": "0",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "4",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "3",
                                            "ion_display_position": "18",
                                            "spec_id": "347",
                                            "peak_id": "2",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "5",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "4",
                                            "ion_display_position": "17",
                                            "spec_id": "347",
                                            "peak_id": "5",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "6",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "7",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "8",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "7",
                                            "ion_display_position": "14",
                                            "spec_id": "347",
                                            "peak_id": "13",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "9",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "10",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "9",
                                            "ion_display_position": "12",
                                            "spec_id": "347",
                                            "peak_id": "6",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "11",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "12",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "13",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "12",
                                                "ion_display_position": "9",
                                                "spec_id": "347",
                                                "peak_id": "10",
                                                "peak_charge": "2"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "12",
                                                "ion_display_position": "12",
                                                "spec_id": "347",
                                                "peak_id": "3",
                                                "peak_charge": "2"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "14",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "15",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "16",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "17",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "18",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "19",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "20",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "21",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "22",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "23",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "24",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "25",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "26",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "27",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "28",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "29",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "30",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "31",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "32",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "33",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "34",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "35",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "36",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "37",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "38",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "39",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "40",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "41",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "42",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "43",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "44",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "45",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "46",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "47",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "48",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "49",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "50",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "51",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "52",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "53",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "54",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "55",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "56",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "57",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "58",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "59",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "60",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "61",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "62",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "63",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "64",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "65",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "66",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "67",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "68",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "69",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "70",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "71",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                }
                            ],
                            "mass_shift": {
                                "id": "0",
                                "left_position": "13",
                                "right_position": "22",
                                "shift": "-372.2275088537",
                                "anno": "-372.2275",
                                "shift_type": "unexpected"
                            }
                        }
                    }
                }
            }
        ]
    }
}
