prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "5",
        "sequence_name": "sp|P0A7P2|RL33_SALTY",
        "sequence_description": "50S ribosomal protein L33 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmG PE=3 SV=2",
        "proteoform_id": "58",
        "prsm_number": "3",
        "prsm": [
            {
                "prsm_id": "130",
                "p_value": "6.97e-05",
                "e_value": "6.97e-05",
                "fdr": "0",
                "matched_fragment_number": "9",
                "matched_peak_number": "9",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_2_ms2.msalign",
                        "ms1_ids": "1000203",
                        "ms1_scans": "402",
                        "ids": "1000198",
                        "scans": "403",
                        "precursor_mono_mass": "6265.5247",
                        "precursor_charge": "10",
                        "precursor_mz": "627.5597"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "1000198",
                                "peak_id": "0",
                                "monoisotopic_mass": "4443.4717",
                                "monoisotopic_mz": "635.7889",
                                "intensity": "85502.11",
                                "charge": "7"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "1",
                                "monoisotopic_mass": "6036.3812",
                                "monoisotopic_mz": "671.7163",
                                "intensity": "98437.15",
                                "charge": "9"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "2",
                                "monoisotopic_mass": "1807.0657",
                                "monoisotopic_mz": "904.5401",
                                "intensity": "22055.37",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1807.0832",
                                        "ion_position": "40",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0175",
                                        "ppm": "-9.70"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "3",
                                "monoisotopic_mass": "1660.9620",
                                "monoisotopic_mz": "831.4883",
                                "intensity": "93036.18",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "4",
                                "monoisotopic_mass": "2286.2808",
                                "monoisotopic_mz": "763.1009",
                                "intensity": "35925.28",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "5",
                                "monoisotopic_mass": "6164.4673",
                                "monoisotopic_mz": "685.9481",
                                "intensity": "45607.43",
                                "charge": "9"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "6",
                                "monoisotopic_mass": "1789.0552",
                                "monoisotopic_mz": "597.3590",
                                "intensity": "114647.09",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "7",
                                "monoisotopic_mass": "1980.8697",
                                "monoisotopic_mz": "199.0942",
                                "intensity": "25087.80",
                                "charge": "10"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "8",
                                "monoisotopic_mass": "1547.8806",
                                "monoisotopic_mz": "774.9476",
                                "intensity": "58170.72",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "9",
                                "monoisotopic_mass": "4458.4706",
                                "monoisotopic_mz": "637.9316",
                                "intensity": "32659.65",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-102.0652008038",
                                        "theoretical_mass": "4458.4715",
                                        "ion_position": "40",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "B00040",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.20"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "10",
                                "monoisotopic_mass": "2596.4166",
                                "monoisotopic_mz": "866.4795",
                                "intensity": "50247.60",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "11",
                                "monoisotopic_mass": "1660.9658",
                                "monoisotopic_mz": "554.6625",
                                "intensity": "19167.25",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "12",
                                "monoisotopic_mass": "6053.3853",
                                "monoisotopic_mz": "673.6056",
                                "intensity": "61935.66",
                                "charge": "9"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "13",
                                "monoisotopic_mass": "1995.1063",
                                "monoisotopic_mz": "666.0427",
                                "intensity": "22799.47",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "14",
                                "monoisotopic_mass": "928.5545",
                                "monoisotopic_mz": "929.5618",
                                "intensity": "19497.81",
                                "charge": "1"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "15",
                                "monoisotopic_mass": "878.5144",
                                "monoisotopic_mz": "879.5217",
                                "intensity": "28472.43",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "878.5226",
                                        "ion_position": "48",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "48",
                                        "mass_error": "-0.0082",
                                        "ppm": "-9.29"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "16",
                                "monoisotopic_mass": "4737.5927",
                                "monoisotopic_mz": "790.6061",
                                "intensity": "35733.17",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "17",
                                "monoisotopic_mass": "6120.4253",
                                "monoisotopic_mz": "681.0545",
                                "intensity": "66139.17",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-102.0652008038",
                                        "theoretical_mass": "6119.4492",
                                        "ion_position": "54",
                                        "ion_display_position": "54",
                                        "ion_sort_name": "B00054",
                                        "ion_left_position": "54",
                                        "mass_error": "-0.0262",
                                        "ppm": "-4.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "18",
                                "monoisotopic_mass": "815.4694",
                                "monoisotopic_mz": "408.7420",
                                "intensity": "49048.96",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "19",
                                "monoisotopic_mass": "587.3589",
                                "monoisotopic_mz": "588.3662",
                                "intensity": "30044.67",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "587.3643",
                                        "ion_position": "50",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "Y00005",
                                        "ion_left_position": "50",
                                        "mass_error": "-0.0053",
                                        "ppm": "-9.08"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "20",
                                "monoisotopic_mass": "1249.8127",
                                "monoisotopic_mz": "417.6115",
                                "intensity": "24716.61",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "21",
                                "monoisotopic_mass": "991.5985",
                                "monoisotopic_mz": "992.6058",
                                "intensity": "19887.28",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "991.6066",
                                        "ion_position": "47",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0081",
                                        "ppm": "-8.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "22",
                                "monoisotopic_mass": "2449.3428",
                                "monoisotopic_mz": "817.4549",
                                "intensity": "49043.02",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "23",
                                "monoisotopic_mass": "4825.6612",
                                "monoisotopic_mz": "690.3875",
                                "intensity": "70038.71",
                                "charge": "7"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "24",
                                "monoisotopic_mass": "928.5530",
                                "monoisotopic_mz": "465.2838",
                                "intensity": "19678.84",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "25",
                                "monoisotopic_mass": "715.4526",
                                "monoisotopic_mz": "716.4598",
                                "intensity": "13799.41",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "715.4592",
                                        "ion_position": "49",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "49",
                                        "mass_error": "-0.0067",
                                        "ppm": "-9.32"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "26",
                                "monoisotopic_mass": "1037.6609",
                                "monoisotopic_mz": "519.8377",
                                "intensity": "24685.93",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "27",
                                "monoisotopic_mass": "1164.7607",
                                "monoisotopic_mz": "583.3876",
                                "intensity": "22125.00",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "28",
                                "monoisotopic_mass": "1642.9564",
                                "monoisotopic_mz": "822.4855",
                                "intensity": "36522.79",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "29",
                                "monoisotopic_mass": "1316.8156",
                                "monoisotopic_mz": "439.9458",
                                "intensity": "9674.08",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "30",
                                "monoisotopic_mass": "1678.9580",
                                "monoisotopic_mz": "840.4863",
                                "intensity": "23427.58",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "31",
                                "monoisotopic_mass": "4053.2825",
                                "monoisotopic_mz": "676.5544",
                                "intensity": "32780.11",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "32",
                                "monoisotopic_mass": "2046.1752",
                                "monoisotopic_mz": "683.0657",
                                "intensity": "15907.70",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "33",
                                "monoisotopic_mass": "1091.6123",
                                "monoisotopic_mz": "546.8134",
                                "intensity": "13512.76",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "34",
                                "monoisotopic_mass": "4403.4812",
                                "monoisotopic_mz": "734.9208",
                                "intensity": "34187.75",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4403.5209",
                                        "ion_position": "19",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "Y00036",
                                        "ion_left_position": "19",
                                        "mass_error": "-0.0398",
                                        "ppm": "-9.03"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "35",
                                "monoisotopic_mass": "4808.6705",
                                "monoisotopic_mz": "687.9602",
                                "intensity": "22515.61",
                                "charge": "7"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "36",
                                "monoisotopic_mass": "4229.3226",
                                "monoisotopic_mz": "705.8944",
                                "intensity": "28521.93",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "37",
                                "monoisotopic_mass": "4341.3879",
                                "monoisotopic_mz": "724.5719",
                                "intensity": "14255.84",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "38",
                                "monoisotopic_mass": "4442.4699",
                                "monoisotopic_mz": "741.4189",
                                "intensity": "57190.63",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "39",
                                "monoisotopic_mass": "716.4015",
                                "monoisotopic_mz": "359.2080",
                                "intensity": "15054.45",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "40",
                                "monoisotopic_mass": "3019.5980",
                                "monoisotopic_mz": "755.9068",
                                "intensity": "20292.73",
                                "charge": "4"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "41",
                                "monoisotopic_mass": "3192.6644",
                                "monoisotopic_mz": "799.1734",
                                "intensity": "24767.74",
                                "charge": "4"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "42",
                                "monoisotopic_mass": "6148.4605",
                                "monoisotopic_mz": "684.1696",
                                "intensity": "18224.89",
                                "charge": "9"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "43",
                                "monoisotopic_mass": "2068.1555",
                                "monoisotopic_mz": "690.3924",
                                "intensity": "17427.40",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "44",
                                "monoisotopic_mass": "4357.4107",
                                "monoisotopic_mz": "727.2424",
                                "intensity": "26735.60",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "45",
                                "monoisotopic_mass": "4824.6538",
                                "monoisotopic_mz": "805.1162",
                                "intensity": "38292.80",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "46",
                                "monoisotopic_mass": "4255.4169",
                                "monoisotopic_mz": "710.2434",
                                "intensity": "26969.82",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "47",
                                "monoisotopic_mass": "2947.5543",
                                "monoisotopic_mz": "983.5254",
                                "intensity": "21368.73",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "48",
                                "monoisotopic_mass": "2948.5596",
                                "monoisotopic_mz": "738.1472",
                                "intensity": "33820.33",
                                "charge": "4"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "49",
                                "monoisotopic_mass": "4999.7682",
                                "monoisotopic_mz": "715.2599",
                                "intensity": "25010.81",
                                "charge": "7"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "50",
                                "monoisotopic_mass": "4714.1530",
                                "monoisotopic_mz": "674.4577",
                                "intensity": "21656.69",
                                "charge": "7"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "51",
                                "monoisotopic_mass": "3993.2147",
                                "monoisotopic_mz": "666.5431",
                                "intensity": "24657.64",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "52",
                                "monoisotopic_mass": "4753.6184",
                                "monoisotopic_mz": "793.2770",
                                "intensity": "35127.64",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-102.0652008038",
                                        "theoretical_mass": "4753.6610",
                                        "ion_position": "43",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "B00043",
                                        "ion_left_position": "43",
                                        "mass_error": "-0.0426",
                                        "ppm": "-8.97"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "53",
                                "monoisotopic_mass": "4384.4455",
                                "monoisotopic_mz": "731.7482",
                                "intensity": "19592.29",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "54",
                                "monoisotopic_mass": "1359.3220",
                                "monoisotopic_mz": "680.6683",
                                "intensity": "8698.99",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "55",
                                "monoisotopic_mass": "1374.3262",
                                "monoisotopic_mz": "688.1704",
                                "intensity": "16014.51",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "56",
                                "monoisotopic_mass": "1429.1905",
                                "monoisotopic_mz": "715.6025",
                                "intensity": "12078.91",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "57",
                                "monoisotopic_mass": "1452.8369",
                                "monoisotopic_mz": "727.4257",
                                "intensity": "12887.05",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "58",
                                "monoisotopic_mass": "732.4125",
                                "monoisotopic_mz": "733.4198",
                                "intensity": "20368.34",
                                "charge": "1"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "59",
                                "monoisotopic_mass": "3686.4363",
                                "monoisotopic_mz": "738.2945",
                                "intensity": "12742.14",
                                "charge": "5"
                            },
                            {
                                "spec_id": "1000198",
                                "peak_id": "60",
                                "monoisotopic_mass": "682.6080",
                                "monoisotopic_mz": "683.6153",
                                "intensity": "9831.40",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "5",
                    "proteoform_id": "58",
                    "sequence_name": "sp|P0A7P2|RL33_SALTY",
                    "sequence_description": "50S ribosomal protein L33 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmG PE=3 SV=2",
                    "proteoform_mass": "6265.5547",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "55",
                        "first_residue_position": "0",
                        "last_residue_position": "54",
                        "annotated_seq": ".(MAKGIREKIKLVSSAGTGH)[-102.0652]FYTTTKNKRTKPEKLELKKFDPVVRQHVIYKEAKIK.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "G"
                            },
                            {
                                "position": "4",
                                "acid": "I"
                            },
                            {
                                "position": "5",
                                "acid": "R"
                            },
                            {
                                "position": "6",
                                "acid": "E"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "I"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "L"
                            },
                            {
                                "position": "11",
                                "acid": "V"
                            },
                            {
                                "position": "12",
                                "acid": "S"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "T"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "H"
                            },
                            {
                                "position": "19",
                                "acid": "F"
                            },
                            {
                                "position": "20",
                                "acid": "Y"
                            },
                            {
                                "position": "21",
                                "acid": "T"
                            },
                            {
                                "position": "22",
                                "acid": "T"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "K"
                            },
                            {
                                "position": "25",
                                "acid": "N"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "R"
                            },
                            {
                                "position": "28",
                                "acid": "T"
                            },
                            {
                                "position": "29",
                                "acid": "K"
                            },
                            {
                                "position": "30",
                                "acid": "P"
                            },
                            {
                                "position": "31",
                                "acid": "E"
                            },
                            {
                                "position": "32",
                                "acid": "K"
                            },
                            {
                                "position": "33",
                                "acid": "L"
                            },
                            {
                                "position": "34",
                                "acid": "E"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "K"
                            },
                            {
                                "position": "38",
                                "acid": "F"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "V"
                            },
                            {
                                "position": "43",
                                "acid": "R"
                            },
                            {
                                "position": "44",
                                "acid": "Q"
                            },
                            {
                                "position": "45",
                                "acid": "H"
                            },
                            {
                                "position": "46",
                                "acid": "V"
                            },
                            {
                                "position": "47",
                                "acid": "I"
                            },
                            {
                                "position": "48",
                                "acid": "Y"
                            },
                            {
                                "position": "49",
                                "acid": "K"
                            },
                            {
                                "position": "50",
                                "acid": "E"
                            },
                            {
                                "position": "51",
                                "acid": "A"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "I"
                            },
                            {
                                "position": "54",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "19",
                                        "ion_display_position": "36",
                                        "spec_id": "1000198",
                                        "peak_id": "34",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "40",
                                            "ion_display_position": "15",
                                            "spec_id": "1000198",
                                            "peak_id": "2",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "40",
                                            "ion_display_position": "40",
                                            "spec_id": "1000198",
                                            "peak_id": "9",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "43",
                                        "ion_display_position": "43",
                                        "spec_id": "1000198",
                                        "peak_id": "52",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "8",
                                        "spec_id": "1000198",
                                        "peak_id": "21",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "48",
                                        "ion_display_position": "7",
                                        "spec_id": "1000198",
                                        "peak_id": "15",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "49",
                                        "ion_display_position": "6",
                                        "spec_id": "1000198",
                                        "peak_id": "25",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "50",
                                        "ion_display_position": "5",
                                        "spec_id": "1000198",
                                        "peak_id": "19",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "54",
                                        "ion_display_position": "54",
                                        "spec_id": "1000198",
                                        "peak_id": "17",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "19",
                            "shift": "-102.0652008038",
                            "anno": "-102.0652",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "20",
                "p_value": "1.60e-04",
                "e_value": "1.60e-04",
                "fdr": "0",
                "matched_fragment_number": "7",
                "matched_peak_number": "8",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                        "ms1_ids": "218",
                        "ms1_scans": "421",
                        "ids": "202",
                        "scans": "422",
                        "precursor_mono_mass": "6266.5244",
                        "precursor_charge": "12",
                        "precursor_mz": "523.2176"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "202",
                                "peak_id": "0",
                                "monoisotopic_mass": "4425.4578",
                                "monoisotopic_mz": "554.1895",
                                "intensity": "211082.92",
                                "charge": "8"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "1",
                                "monoisotopic_mass": "4737.6140",
                                "monoisotopic_mz": "593.2090",
                                "intensity": "554291.39",
                                "charge": "8"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "2",
                                "monoisotopic_mass": "4443.4681",
                                "monoisotopic_mz": "556.4408",
                                "intensity": "468187.58",
                                "charge": "8"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "3",
                                "monoisotopic_mass": "4755.6233",
                                "monoisotopic_mz": "595.4602",
                                "intensity": "1140416.17",
                                "charge": "8",
                                "matched_ions_num": "2",
                                "matched_ions": {
                                    "matched_ion": [
                                        {
                                            "ion_type": "B",
                                            "match_shift": "-142.1136658038",
                                            "theoretical_mass": "4755.6231",
                                            "ion_position": "43",
                                            "ion_display_position": "43",
                                            "ion_sort_name": "B00043",
                                            "ion_left_position": "43",
                                            "mass_error": "0.0002",
                                            "ppm": "0.03"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "4755.6704",
                                            "ion_position": "15",
                                            "ion_display_position": "40",
                                            "ion_sort_name": "Y00040",
                                            "ion_left_position": "15",
                                            "mass_error": "-0.0471",
                                            "ppm": "-9.91"
                                        }
                                    ]
                                }
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "4",
                                "monoisotopic_mass": "4808.6501",
                                "monoisotopic_mz": "602.0885",
                                "intensity": "139302.50",
                                "charge": "8"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "5",
                                "monoisotopic_mass": "2377.6485",
                                "monoisotopic_mz": "199.1447",
                                "intensity": "82987.71",
                                "charge": "12"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "6",
                                "monoisotopic_mass": "2178.3054",
                                "monoisotopic_mz": "199.0350",
                                "intensity": "26494.31",
                                "charge": "11"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "7",
                                "monoisotopic_mass": "5792.2151",
                                "monoisotopic_mz": "580.2288",
                                "intensity": "81894.35",
                                "charge": "10"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "8",
                                "monoisotopic_mass": "4791.6447",
                                "monoisotopic_mz": "599.9629",
                                "intensity": "85326.08",
                                "charge": "8"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "9",
                                "monoisotopic_mass": "4406.4552",
                                "monoisotopic_mz": "551.8142",
                                "intensity": "63160.65",
                                "charge": "8"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "10",
                                "monoisotopic_mass": "1807.0660",
                                "monoisotopic_mz": "603.3626",
                                "intensity": "445653.34",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1807.0832",
                                        "ion_position": "40",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0172",
                                        "ppm": "-9.54"
                                    }
                                }
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "11",
                                "monoisotopic_mass": "4771.6159",
                                "monoisotopic_mz": "597.4593",
                                "intensity": "196636.76",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-142.1136658038",
                                        "theoretical_mass": "4771.6259",
                                        "ion_position": "13",
                                        "ion_display_position": "42",
                                        "ion_sort_name": "Y00042",
                                        "ion_left_position": "13",
                                        "mass_error": "-0.0100",
                                        "ppm": "-2.10"
                                    }
                                }
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "12",
                                "monoisotopic_mass": "1423.8746",
                                "monoisotopic_mz": "475.6321",
                                "intensity": "265761.51",
                                "charge": "3"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "13",
                                "monoisotopic_mass": "1807.0670",
                                "monoisotopic_mz": "452.7740",
                                "intensity": "391819.48",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1807.0832",
                                        "ion_position": "40",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0162",
                                        "ppm": "-8.97"
                                    }
                                }
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "14",
                                "monoisotopic_mass": "1405.8641",
                                "monoisotopic_mz": "469.6286",
                                "intensity": "172190.93",
                                "charge": "3"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "15",
                                "monoisotopic_mass": "1476.9019",
                                "monoisotopic_mz": "370.2328",
                                "intensity": "33068.54",
                                "charge": "4"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "16",
                                "monoisotopic_mass": "1789.0538",
                                "monoisotopic_mz": "448.2707",
                                "intensity": "136827.75",
                                "charge": "4"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "17",
                                "monoisotopic_mass": "1249.8127",
                                "monoisotopic_mz": "417.6115",
                                "intensity": "85642.31",
                                "charge": "3"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "18",
                                "monoisotopic_mass": "3812.1206",
                                "monoisotopic_mz": "545.5959",
                                "intensity": "41123.91",
                                "charge": "7"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "19",
                                "monoisotopic_mass": "1308.8498",
                                "monoisotopic_mz": "328.2197",
                                "intensity": "21774.20",
                                "charge": "4"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "20",
                                "monoisotopic_mass": "1430.8979",
                                "monoisotopic_mz": "358.7318",
                                "intensity": "24939.00",
                                "charge": "4"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "21",
                                "monoisotopic_mass": "2596.4253",
                                "monoisotopic_mz": "650.1136",
                                "intensity": "27492.64",
                                "charge": "4"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "22",
                                "monoisotopic_mass": "2438.4288",
                                "monoisotopic_mz": "488.6930",
                                "intensity": "44758.49",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2438.4526",
                                        "ion_position": "35",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "Y00020",
                                        "ion_left_position": "35",
                                        "mass_error": "-0.0238",
                                        "ppm": "-9.74"
                                    }
                                }
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "23",
                                "monoisotopic_mass": "1336.8438",
                                "monoisotopic_mz": "446.6219",
                                "intensity": "44635.41",
                                "charge": "3"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "24",
                                "monoisotopic_mass": "2930.5510",
                                "monoisotopic_mz": "733.6450",
                                "intensity": "41534.91",
                                "charge": "4"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "25",
                                "monoisotopic_mass": "1610.9489",
                                "monoisotopic_mz": "537.9902",
                                "intensity": "39297.81",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1610.9620",
                                        "ion_position": "42",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "42",
                                        "mass_error": "-0.0132",
                                        "ppm": "-8.18"
                                    }
                                }
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "26",
                                "monoisotopic_mass": "3001.5871",
                                "monoisotopic_mz": "601.3247",
                                "intensity": "38757.39",
                                "charge": "5"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "27",
                                "monoisotopic_mass": "1494.9108",
                                "monoisotopic_mz": "374.7350",
                                "intensity": "13376.78",
                                "charge": "4"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "28",
                                "monoisotopic_mass": "2930.5489",
                                "monoisotopic_mz": "587.1170",
                                "intensity": "92129.74",
                                "charge": "5"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "29",
                                "monoisotopic_mass": "3794.0789",
                                "monoisotopic_mz": "543.0185",
                                "intensity": "36102.61",
                                "charge": "7"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "30",
                                "monoisotopic_mass": "5131.8792",
                                "monoisotopic_mz": "571.2161",
                                "intensity": "34795.15",
                                "charge": "9"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "31",
                                "monoisotopic_mass": "1371.7802",
                                "monoisotopic_mz": "458.2673",
                                "intensity": "13147.06",
                                "charge": "3"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "32",
                                "monoisotopic_mass": "1387.8551",
                                "monoisotopic_mz": "463.6256",
                                "intensity": "16977.73",
                                "charge": "3"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "33",
                                "monoisotopic_mass": "4698.5965",
                                "monoisotopic_mz": "588.3318",
                                "intensity": "129320.45",
                                "charge": "8"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "34",
                                "monoisotopic_mass": "5159.8807",
                                "monoisotopic_mz": "574.3274",
                                "intensity": "52955.93",
                                "charge": "9"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "35",
                                "monoisotopic_mass": "1249.8082",
                                "monoisotopic_mz": "625.9114",
                                "intensity": "19038.45",
                                "charge": "2"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "36",
                                "monoisotopic_mass": "1338.8210",
                                "monoisotopic_mz": "670.4178",
                                "intensity": "24690.71",
                                "charge": "2"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "37",
                                "monoisotopic_mass": "4682.6091",
                                "monoisotopic_mz": "586.3334",
                                "intensity": "24465.51",
                                "charge": "8"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "38",
                                "monoisotopic_mass": "4755.6223",
                                "monoisotopic_mz": "529.4098",
                                "intensity": "30815.03",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-142.1136658038",
                                        "theoretical_mass": "4755.6231",
                                        "ion_position": "43",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "B00043",
                                        "ion_left_position": "43",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.18"
                                    }
                                }
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "39",
                                "monoisotopic_mass": "4114.5241",
                                "monoisotopic_mz": "588.7964",
                                "intensity": "53091.23",
                                "charge": "7"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "40",
                                "monoisotopic_mass": "4719.6081",
                                "monoisotopic_mz": "590.9583",
                                "intensity": "218156.63",
                                "charge": "8"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "41",
                                "monoisotopic_mass": "1448.9089",
                                "monoisotopic_mz": "363.2345",
                                "intensity": "14035.41",
                                "charge": "4"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "42",
                                "monoisotopic_mass": "5112.8675",
                                "monoisotopic_mz": "569.1037",
                                "intensity": "59082.82",
                                "charge": "9"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "43",
                                "monoisotopic_mass": "2912.5417",
                                "monoisotopic_mz": "583.5156",
                                "intensity": "33362.13",
                                "charge": "5"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "44",
                                "monoisotopic_mass": "1102.6141",
                                "monoisotopic_mz": "552.3143",
                                "intensity": "22619.92",
                                "charge": "2"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "45",
                                "monoisotopic_mass": "4596.5484",
                                "monoisotopic_mz": "657.6570",
                                "intensity": "56991.89",
                                "charge": "7"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "46",
                                "monoisotopic_mass": "2948.5594",
                                "monoisotopic_mz": "590.7192",
                                "intensity": "195542.26",
                                "charge": "5"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "47",
                                "monoisotopic_mass": "2947.5552",
                                "monoisotopic_mz": "737.8961",
                                "intensity": "27251.68",
                                "charge": "4"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "48",
                                "monoisotopic_mass": "879.5184",
                                "monoisotopic_mz": "440.7665",
                                "intensity": "20017.76",
                                "charge": "2"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "49",
                                "monoisotopic_mass": "4092.3538",
                                "monoisotopic_mz": "683.0662",
                                "intensity": "31171.83",
                                "charge": "6"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "50",
                                "monoisotopic_mass": "1475.4964",
                                "monoisotopic_mz": "492.8394",
                                "intensity": "11447.87",
                                "charge": "3"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "51",
                                "monoisotopic_mass": "4596.5419",
                                "monoisotopic_mz": "575.5750",
                                "intensity": "57029.33",
                                "charge": "8"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "52",
                                "monoisotopic_mass": "4735.6084",
                                "monoisotopic_mz": "677.5228",
                                "intensity": "65582.79",
                                "charge": "7"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "53",
                                "monoisotopic_mass": "2983.1006",
                                "monoisotopic_mz": "597.6274",
                                "intensity": "55732.23",
                                "charge": "5"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "54",
                                "monoisotopic_mass": "5713.6249",
                                "monoisotopic_mz": "572.3698",
                                "intensity": "28410.71",
                                "charge": "10"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "55",
                                "monoisotopic_mass": "1318.8326",
                                "monoisotopic_mz": "440.6181",
                                "intensity": "24389.94",
                                "charge": "3"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "56",
                                "monoisotopic_mass": "4093.3549",
                                "monoisotopic_mz": "585.7723",
                                "intensity": "32992.63",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4093.3892",
                                        "ion_position": "21",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "Y00034",
                                        "ion_left_position": "21",
                                        "mass_error": "-0.0343",
                                        "ppm": "-8.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "57",
                                "monoisotopic_mass": "1155.2415",
                                "monoisotopic_mz": "578.6281",
                                "intensity": "17297.83",
                                "charge": "2"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "58",
                                "monoisotopic_mass": "596.3516",
                                "monoisotopic_mz": "597.3589",
                                "intensity": "73786.89",
                                "charge": "1"
                            },
                            {
                                "spec_id": "202",
                                "peak_id": "59",
                                "monoisotopic_mass": "4052.2590",
                                "monoisotopic_mz": "579.9014",
                                "intensity": "15134.89",
                                "charge": "7"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "5",
                    "proteoform_id": "58",
                    "sequence_name": "sp|P0A7P2|RL33_SALTY",
                    "sequence_description": "50S ribosomal protein L33 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmG PE=3 SV=2",
                    "proteoform_mass": "6267.5168",
                    "n_acetylation": "1",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "55",
                        "first_residue_position": "0",
                        "last_residue_position": "54",
                        "annotated_seq": ".[Acetyl]-MAKGIREKIKLVS(SA)[-142.1137]GTGHFYTTTKNKRTKPEKLELKKFDPVVRQHVIYKEAKIK.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "G"
                            },
                            {
                                "position": "4",
                                "acid": "I"
                            },
                            {
                                "position": "5",
                                "acid": "R"
                            },
                            {
                                "position": "6",
                                "acid": "E"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "I"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "L"
                            },
                            {
                                "position": "11",
                                "acid": "V"
                            },
                            {
                                "position": "12",
                                "acid": "S"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "T"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "H"
                            },
                            {
                                "position": "19",
                                "acid": "F"
                            },
                            {
                                "position": "20",
                                "acid": "Y"
                            },
                            {
                                "position": "21",
                                "acid": "T"
                            },
                            {
                                "position": "22",
                                "acid": "T"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "K"
                            },
                            {
                                "position": "25",
                                "acid": "N"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "R"
                            },
                            {
                                "position": "28",
                                "acid": "T"
                            },
                            {
                                "position": "29",
                                "acid": "K"
                            },
                            {
                                "position": "30",
                                "acid": "P"
                            },
                            {
                                "position": "31",
                                "acid": "E"
                            },
                            {
                                "position": "32",
                                "acid": "K"
                            },
                            {
                                "position": "33",
                                "acid": "L"
                            },
                            {
                                "position": "34",
                                "acid": "E"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "K"
                            },
                            {
                                "position": "38",
                                "acid": "F"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "V"
                            },
                            {
                                "position": "43",
                                "acid": "R"
                            },
                            {
                                "position": "44",
                                "acid": "Q"
                            },
                            {
                                "position": "45",
                                "acid": "H"
                            },
                            {
                                "position": "46",
                                "acid": "V"
                            },
                            {
                                "position": "47",
                                "acid": "I"
                            },
                            {
                                "position": "48",
                                "acid": "Y"
                            },
                            {
                                "position": "49",
                                "acid": "K"
                            },
                            {
                                "position": "50",
                                "acid": "E"
                            },
                            {
                                "position": "51",
                                "acid": "A"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "I"
                            },
                            {
                                "position": "54",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "13",
                                        "ion_display_position": "42",
                                        "spec_id": "202",
                                        "peak_id": "11",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "15",
                                        "ion_display_position": "40",
                                        "spec_id": "202",
                                        "peak_id": "3",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "21",
                                        "ion_display_position": "34",
                                        "spec_id": "202",
                                        "peak_id": "56",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "35",
                                        "ion_display_position": "20",
                                        "spec_id": "202",
                                        "peak_id": "22",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "40",
                                            "ion_display_position": "15",
                                            "spec_id": "202",
                                            "peak_id": "10",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "40",
                                            "ion_display_position": "15",
                                            "spec_id": "202",
                                            "peak_id": "13",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "42",
                                        "ion_display_position": "13",
                                        "spec_id": "202",
                                        "peak_id": "25",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "43",
                                            "ion_display_position": "43",
                                            "spec_id": "202",
                                            "peak_id": "38",
                                            "peak_charge": "9"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "43",
                                            "ion_display_position": "43",
                                            "spec_id": "202",
                                            "peak_id": "3",
                                            "peak_charge": "8"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Protein variable",
                            "ptm": {
                                "abbreviation": "Acetyl",
                                "unimod": "1",
                                "mono_mass": "42.0105650000"
                            },
                            "occurence": {
                                "left_pos": "0",
                                "right_pos": "1",
                                "anno": "M"
                            }
                        },
                        "mass_shift": {
                            "id": "0",
                            "left_position": "13",
                            "right_position": "15",
                            "shift": "-142.1136658038",
                            "anno": "-142.1137",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "143",
                "p_value": "0.03",
                "e_value": "0.03",
                "fdr": "7.43e-03",
                "matched_fragment_number": "6",
                "matched_peak_number": "7",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_2_ms2.msalign",
                        "ms1_ids": "1000267",
                        "ms1_scans": "530",
                        "ids": "1000262",
                        "scans": "531",
                        "precursor_mono_mass": "6265.5301",
                        "precursor_charge": "10",
                        "precursor_mz": "627.5603"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "1000262",
                                "peak_id": "0",
                                "monoisotopic_mass": "4443.4725",
                                "monoisotopic_mz": "635.7891",
                                "intensity": "63555.24",
                                "charge": "7"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "1",
                                "monoisotopic_mass": "4443.4722",
                                "monoisotopic_mz": "741.5860",
                                "intensity": "23727.70",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "2",
                                "monoisotopic_mass": "2596.4122",
                                "monoisotopic_mz": "866.4780",
                                "intensity": "15956.22",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "3",
                                "monoisotopic_mass": "6122.4426",
                                "monoisotopic_mz": "681.2787",
                                "intensity": "23161.87",
                                "charge": "9"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "4",
                                "monoisotopic_mass": "4808.6450",
                                "monoisotopic_mz": "802.4481",
                                "intensity": "14533.28",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "5",
                                "monoisotopic_mass": "1660.9621",
                                "monoisotopic_mz": "831.4883",
                                "intensity": "29421.31",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "6",
                                "monoisotopic_mass": "6037.3934",
                                "monoisotopic_mz": "671.8288",
                                "intensity": "39803.30",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6037.4473",
                                        "ion_position": "3",
                                        "ion_display_position": "52",
                                        "ion_sort_name": "Y00052",
                                        "ion_left_position": "3",
                                        "mass_error": "-0.0539",
                                        "ppm": "-8.92"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "7",
                                "monoisotopic_mass": "1642.9563",
                                "monoisotopic_mz": "822.4854",
                                "intensity": "13531.86",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "8",
                                "monoisotopic_mass": "3019.5937",
                                "monoisotopic_mz": "1007.5385",
                                "intensity": "7676.21",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "9",
                                "monoisotopic_mass": "1789.0546",
                                "monoisotopic_mz": "597.3588",
                                "intensity": "67298.21",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "10",
                                "monoisotopic_mass": "6019.3742",
                                "monoisotopic_mz": "669.8266",
                                "intensity": "23340.29",
                                "charge": "9"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "11",
                                "monoisotopic_mass": "4230.3278",
                                "monoisotopic_mz": "706.0619",
                                "intensity": "20210.13",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "12",
                                "monoisotopic_mass": "6164.4713",
                                "monoisotopic_mz": "685.9485",
                                "intensity": "26325.17",
                                "charge": "9"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "13",
                                "monoisotopic_mass": "3193.6594",
                                "monoisotopic_mz": "799.4221",
                                "intensity": "13561.20",
                                "charge": "4"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "14",
                                "monoisotopic_mass": "1660.9645",
                                "monoisotopic_mz": "554.6621",
                                "intensity": "8024.99",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "15",
                                "monoisotopic_mass": "2286.2860",
                                "monoisotopic_mz": "763.1026",
                                "intensity": "8085.45",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "16",
                                "monoisotopic_mass": "1847.0548",
                                "monoisotopic_mz": "462.7710",
                                "intensity": "7749.40",
                                "charge": "4"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "17",
                                "monoisotopic_mass": "1547.8778",
                                "monoisotopic_mz": "774.9462",
                                "intensity": "13613.31",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "18",
                                "monoisotopic_mass": "1678.9713",
                                "monoisotopic_mz": "560.6644",
                                "intensity": "6296.20",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "19",
                                "monoisotopic_mass": "4755.6198",
                                "monoisotopic_mz": "793.6106",
                                "intensity": "14048.07",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "20",
                                "monoisotopic_mass": "2449.3447",
                                "monoisotopic_mz": "817.4555",
                                "intensity": "22767.78",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "21",
                                "monoisotopic_mass": "2185.2352",
                                "monoisotopic_mz": "729.4190",
                                "intensity": "4423.16",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "22",
                                "monoisotopic_mass": "878.5148",
                                "monoisotopic_mz": "879.5221",
                                "intensity": "9057.08",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "878.5226",
                                        "ion_position": "48",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "48",
                                        "mass_error": "-0.0077",
                                        "ppm": "-8.80"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "23",
                                "monoisotopic_mass": "928.5509",
                                "monoisotopic_mz": "929.5582",
                                "intensity": "5835.33",
                                "charge": "1"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "24",
                                "monoisotopic_mass": "716.4022",
                                "monoisotopic_mz": "717.4095",
                                "intensity": "11412.66",
                                "charge": "1"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "25",
                                "monoisotopic_mass": "734.4137",
                                "monoisotopic_mz": "735.4210",
                                "intensity": "6591.49",
                                "charge": "1"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "26",
                                "monoisotopic_mass": "1249.8131",
                                "monoisotopic_mz": "417.6116",
                                "intensity": "10488.12",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "27",
                                "monoisotopic_mass": "2948.5627",
                                "monoisotopic_mz": "983.8615",
                                "intensity": "8766.26",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "28",
                                "monoisotopic_mass": "991.5983",
                                "monoisotopic_mz": "992.6056",
                                "intensity": "6172.08",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "991.6066",
                                        "ion_position": "47",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0083",
                                        "ppm": "-8.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "29",
                                "monoisotopic_mass": "1709.9998",
                                "monoisotopic_mz": "856.0072",
                                "intensity": "11327.42",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "30",
                                "monoisotopic_mass": "4738.6053",
                                "monoisotopic_mz": "790.7748",
                                "intensity": "6929.05",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "31",
                                "monoisotopic_mass": "815.4698",
                                "monoisotopic_mz": "408.7422",
                                "intensity": "16280.64",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "32",
                                "monoisotopic_mass": "4093.3606",
                                "monoisotopic_mz": "683.2340",
                                "intensity": "9664.62",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4093.3892",
                                        "ion_position": "21",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "Y00034",
                                        "ion_left_position": "21",
                                        "mass_error": "-0.0286",
                                        "ppm": "-6.99"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "33",
                                "monoisotopic_mass": "4914.7082",
                                "monoisotopic_mz": "703.1084",
                                "intensity": "5922.38",
                                "charge": "7"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "34",
                                "monoisotopic_mass": "569.3495",
                                "monoisotopic_mz": "570.3568",
                                "intensity": "6498.28",
                                "charge": "1"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "35",
                                "monoisotopic_mass": "1150.7464",
                                "monoisotopic_mz": "576.3805",
                                "intensity": "4675.84",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "36",
                                "monoisotopic_mass": "1037.6629",
                                "monoisotopic_mz": "519.8387",
                                "intensity": "8356.63",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "37",
                                "monoisotopic_mass": "1164.7608",
                                "monoisotopic_mz": "583.3877",
                                "intensity": "8027.96",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "38",
                                "monoisotopic_mass": "4385.4691",
                                "monoisotopic_mz": "731.9188",
                                "intensity": "8042.97",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "39",
                                "monoisotopic_mass": "928.5529",
                                "monoisotopic_mz": "465.2837",
                                "intensity": "8281.87",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "40",
                                "monoisotopic_mass": "5159.8623",
                                "monoisotopic_mz": "738.1305",
                                "intensity": "10437.87",
                                "charge": "7"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "41",
                                "monoisotopic_mass": "1091.6156",
                                "monoisotopic_mz": "546.8151",
                                "intensity": "5889.90",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "42",
                                "monoisotopic_mass": "4358.4053",
                                "monoisotopic_mz": "727.4082",
                                "intensity": "17395.55",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "43",
                                "monoisotopic_mass": "6147.4542",
                                "monoisotopic_mz": "684.0577",
                                "intensity": "20242.20",
                                "charge": "9"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "44",
                                "monoisotopic_mass": "4053.2869",
                                "monoisotopic_mz": "676.5551",
                                "intensity": "14736.48",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "45",
                                "monoisotopic_mass": "4093.3535",
                                "monoisotopic_mz": "819.6780",
                                "intensity": "4659.46",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4093.3892",
                                        "ion_position": "21",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "Y00034",
                                        "ion_left_position": "21",
                                        "mass_error": "-0.0356",
                                        "ppm": "-8.71"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "46",
                                "monoisotopic_mass": "4755.6185",
                                "monoisotopic_mz": "680.3813",
                                "intensity": "11736.36",
                                "charge": "7"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "47",
                                "monoisotopic_mass": "1331.7456",
                                "monoisotopic_mz": "666.8801",
                                "intensity": "3372.88",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "48",
                                "monoisotopic_mass": "2069.1588",
                                "monoisotopic_mz": "690.7269",
                                "intensity": "7684.96",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2069.1786",
                                        "ion_position": "38",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "Y00017",
                                        "ion_left_position": "38",
                                        "mass_error": "-0.0198",
                                        "ppm": "-9.58"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "49",
                                "monoisotopic_mass": "4826.6682",
                                "monoisotopic_mz": "805.4520",
                                "intensity": "11105.71",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4826.7076",
                                        "ion_position": "14",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "Y00041",
                                        "ion_left_position": "14",
                                        "mass_error": "-0.0393",
                                        "ppm": "-8.14"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "50",
                                "monoisotopic_mass": "2028.1441",
                                "monoisotopic_mz": "677.0553",
                                "intensity": "3881.80",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "51",
                                "monoisotopic_mass": "5000.7196",
                                "monoisotopic_mz": "715.3958",
                                "intensity": "8803.70",
                                "charge": "7"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "52",
                                "monoisotopic_mass": "3193.6721",
                                "monoisotopic_mz": "1065.5646",
                                "intensity": "4534.01",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "53",
                                "monoisotopic_mass": "5450.7423",
                                "monoisotopic_mz": "682.3501",
                                "intensity": "5062.61",
                                "charge": "8"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "54",
                                "monoisotopic_mass": "1348.7469",
                                "monoisotopic_mz": "675.3807",
                                "intensity": "3690.71",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "55",
                                "monoisotopic_mass": "1494.9106",
                                "monoisotopic_mz": "499.3108",
                                "intensity": "2718.47",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "56",
                                "monoisotopic_mass": "2196.2502",
                                "monoisotopic_mz": "733.0907",
                                "intensity": "10733.45",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "57",
                                "monoisotopic_mass": "4255.4085",
                                "monoisotopic_mz": "710.2420",
                                "intensity": "13917.88",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "58",
                                "monoisotopic_mass": "5158.8588",
                                "monoisotopic_mz": "860.8171",
                                "intensity": "14336.84",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000262",
                                "peak_id": "59",
                                "monoisotopic_mass": "2949.5729",
                                "monoisotopic_mz": "738.4005",
                                "intensity": "4831.23",
                                "charge": "4"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "5",
                    "proteoform_id": "58",
                    "sequence_name": "sp|P0A7P2|RL33_SALTY",
                    "sequence_description": "50S ribosomal protein L33 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmG PE=3 SV=2",
                    "proteoform_mass": "6265.6551",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "55",
                        "first_residue_position": "0",
                        "last_residue_position": "54",
                        "annotated_seq": ".(MAK)[-101.9648]GIREKIKLVSSAGTGHFYTTTKNKRTKPEKLELKKFDPVVRQHVIYKEAKIK.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "G"
                            },
                            {
                                "position": "4",
                                "acid": "I"
                            },
                            {
                                "position": "5",
                                "acid": "R"
                            },
                            {
                                "position": "6",
                                "acid": "E"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "I"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "L"
                            },
                            {
                                "position": "11",
                                "acid": "V"
                            },
                            {
                                "position": "12",
                                "acid": "S"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "T"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "H"
                            },
                            {
                                "position": "19",
                                "acid": "F"
                            },
                            {
                                "position": "20",
                                "acid": "Y"
                            },
                            {
                                "position": "21",
                                "acid": "T"
                            },
                            {
                                "position": "22",
                                "acid": "T"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "K"
                            },
                            {
                                "position": "25",
                                "acid": "N"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "R"
                            },
                            {
                                "position": "28",
                                "acid": "T"
                            },
                            {
                                "position": "29",
                                "acid": "K"
                            },
                            {
                                "position": "30",
                                "acid": "P"
                            },
                            {
                                "position": "31",
                                "acid": "E"
                            },
                            {
                                "position": "32",
                                "acid": "K"
                            },
                            {
                                "position": "33",
                                "acid": "L"
                            },
                            {
                                "position": "34",
                                "acid": "E"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "K"
                            },
                            {
                                "position": "38",
                                "acid": "F"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "V"
                            },
                            {
                                "position": "43",
                                "acid": "R"
                            },
                            {
                                "position": "44",
                                "acid": "Q"
                            },
                            {
                                "position": "45",
                                "acid": "H"
                            },
                            {
                                "position": "46",
                                "acid": "V"
                            },
                            {
                                "position": "47",
                                "acid": "I"
                            },
                            {
                                "position": "48",
                                "acid": "Y"
                            },
                            {
                                "position": "49",
                                "acid": "K"
                            },
                            {
                                "position": "50",
                                "acid": "E"
                            },
                            {
                                "position": "51",
                                "acid": "A"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "I"
                            },
                            {
                                "position": "54",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "3",
                                        "ion_display_position": "52",
                                        "spec_id": "1000262",
                                        "peak_id": "6",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "14",
                                        "ion_display_position": "41",
                                        "spec_id": "1000262",
                                        "peak_id": "49",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "21",
                                            "ion_display_position": "34",
                                            "spec_id": "1000262",
                                            "peak_id": "45",
                                            "peak_charge": "5"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "21",
                                            "ion_display_position": "34",
                                            "spec_id": "1000262",
                                            "peak_id": "32",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "38",
                                        "ion_display_position": "17",
                                        "spec_id": "1000262",
                                        "peak_id": "48",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "8",
                                        "spec_id": "1000262",
                                        "peak_id": "28",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "48",
                                        "ion_display_position": "7",
                                        "spec_id": "1000262",
                                        "peak_id": "22",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "3",
                            "shift": "-101.9648008038",
                            "anno": "-101.9648",
                            "shift_type": "unexpected"
                        }
                    }
                }
            }
        ]
    }
}
