prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "4",
        "sequence_name": "sp|P66191|RL31_SALTY",
        "sequence_description": "50S ribosomal protein L31 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmE PE=3 SV=1",
        "proteoform_id": "49",
        "prsm_number": "3",
        "prsm": [
            {
                "prsm_id": "165",
                "p_value": "3.81e-06",
                "e_value": "3.81e-06",
                "fdr": "0",
                "matched_fragment_number": "11",
                "matched_peak_number": "12",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_2_ms2.msalign",
                        "ms1_ids": "1000318",
                        "ms1_scans": "632",
                        "ids": "1000313",
                        "scans": "633",
                        "precursor_mono_mass": "7708.7985",
                        "precursor_charge": "11",
                        "precursor_mz": "701.8071"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "1000313",
                                "peak_id": "0",
                                "monoisotopic_mass": "6524.1533",
                                "monoisotopic_mz": "816.5264",
                                "intensity": "13014.57",
                                "charge": "8"
                            },
                            {
                                "spec_id": "1000313",
                                "peak_id": "1",
                                "monoisotopic_mass": "6542.1635",
                                "monoisotopic_mz": "818.7777",
                                "intensity": "33251.98",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-232.1805257115",
                                        "theoretical_mass": "6542.1735",
                                        "ion_position": "10",
                                        "ion_display_position": "60",
                                        "ion_sort_name": "Y00060",
                                        "ion_left_position": "10",
                                        "mass_error": "-0.0100",
                                        "ppm": "-1.53"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000313",
                                "peak_id": "2",
                                "monoisotopic_mass": "6413.1323",
                                "monoisotopic_mz": "802.6488",
                                "intensity": "24887.28",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-232.1805257115",
                                        "theoretical_mass": "6413.1309",
                                        "ion_position": "11",
                                        "ion_display_position": "59",
                                        "ion_sort_name": "Y00059",
                                        "ion_left_position": "11",
                                        "mass_error": "0.0014",
                                        "ppm": "0.22"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000313",
                                "peak_id": "3",
                                "monoisotopic_mass": "6198.9976",
                                "monoisotopic_mz": "775.8820",
                                "intensity": "15780.70",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-232.1805257115",
                                        "theoretical_mass": "6198.9992",
                                        "ion_position": "13",
                                        "ion_display_position": "57",
                                        "ion_sort_name": "Y00057",
                                        "ion_left_position": "13",
                                        "mass_error": "-0.0016",
                                        "ppm": "-0.26"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000313",
                                "peak_id": "4",
                                "monoisotopic_mass": "6300.0483",
                                "monoisotopic_mz": "788.5133",
                                "intensity": "39373.41",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-232.1805257115",
                                        "theoretical_mass": "6300.0469",
                                        "ion_position": "12",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0015",
                                        "ppm": "0.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000313",
                                "peak_id": "5",
                                "monoisotopic_mass": "3309.7526",
                                "monoisotopic_mz": "552.6327",
                                "intensity": "7910.53",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3309.7847",
                                        "ion_position": "41",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "Y00029",
                                        "ion_left_position": "41",
                                        "mass_error": "-0.0320",
                                        "ppm": "-9.68"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000313",
                                "peak_id": "6",
                                "monoisotopic_mass": "6142.9780",
                                "monoisotopic_mz": "768.8795",
                                "intensity": "9382.29",
                                "charge": "8"
                            },
                            {
                                "spec_id": "1000313",
                                "peak_id": "7",
                                "monoisotopic_mass": "6282.0318",
                                "monoisotopic_mz": "786.2612",
                                "intensity": "7899.56",
                                "charge": "8"
                            },
                            {
                                "spec_id": "1000313",
                                "peak_id": "8",
                                "monoisotopic_mass": "2035.0876",
                                "monoisotopic_mz": "509.7792",
                                "intensity": "37498.50",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2035.1075",
                                        "ion_position": "52",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "Y00018",
                                        "ion_left_position": "52",
                                        "mass_error": "-0.0199",
                                        "ppm": "-9.78"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000313",
                                "peak_id": "9",
                                "monoisotopic_mass": "4400.0299",
                                "monoisotopic_mz": "881.0132",
                                "intensity": "7447.06",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-232.1805257115",
                                        "theoretical_mass": "4400.0111",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "0.0187",
                                        "ppm": "4.26"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000313",
                                "peak_id": "10",
                                "monoisotopic_mass": "1888.9854",
                                "monoisotopic_mz": "630.6691",
                                "intensity": "1932.93",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000313",
                                "peak_id": "11",
                                "monoisotopic_mass": "3309.7527",
                                "monoisotopic_mz": "662.9578",
                                "intensity": "4660.79",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3309.7847",
                                        "ion_position": "41",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "Y00029",
                                        "ion_left_position": "41",
                                        "mass_error": "-0.0320",
                                        "ppm": "-9.68"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000313",
                                "peak_id": "12",
                                "monoisotopic_mass": "7476.4690",
                                "monoisotopic_mz": "748.6542",
                                "intensity": "4906.46",
                                "charge": "10"
                            },
                            {
                                "spec_id": "1000313",
                                "peak_id": "13",
                                "monoisotopic_mass": "5675.6952",
                                "monoisotopic_mz": "811.8209",
                                "intensity": "6610.35",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-232.1805257115",
                                        "theoretical_mass": "5674.6883",
                                        "ion_position": "52",
                                        "ion_display_position": "52",
                                        "ion_sort_name": "B00052",
                                        "ion_left_position": "52",
                                        "mass_error": "0.0046",
                                        "ppm": "0.81"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000313",
                                "peak_id": "14",
                                "monoisotopic_mass": "4264.9609",
                                "monoisotopic_mz": "1067.2475",
                                "intensity": "7590.30",
                                "charge": "4"
                            },
                            {
                                "spec_id": "1000313",
                                "peak_id": "15",
                                "monoisotopic_mass": "1296.6532",
                                "monoisotopic_mz": "649.3339",
                                "intensity": "12097.46",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1296.6649",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "-0.0117",
                                        "ppm": "-9.03"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000313",
                                "peak_id": "16",
                                "monoisotopic_mass": "1167.6114",
                                "monoisotopic_mz": "584.8130",
                                "intensity": "3810.26",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1167.6223",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "-0.0109",
                                        "ppm": "-9.30"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000313",
                                "peak_id": "17",
                                "monoisotopic_mass": "1068.5437",
                                "monoisotopic_mz": "535.2791",
                                "intensity": "6995.13",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1068.5539",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "-0.0102",
                                        "ppm": "-9.55"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000313",
                                "peak_id": "18",
                                "monoisotopic_mass": "3066.6298",
                                "monoisotopic_mz": "614.3332",
                                "intensity": "2471.84",
                                "charge": "5"
                            },
                            {
                                "spec_id": "1000313",
                                "peak_id": "19",
                                "monoisotopic_mass": "1274.6634",
                                "monoisotopic_mz": "638.3390",
                                "intensity": "1599.49",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000313",
                                "peak_id": "20",
                                "monoisotopic_mass": "6398.1239",
                                "monoisotopic_mz": "800.7728",
                                "intensity": "2651.88",
                                "charge": "8"
                            },
                            {
                                "spec_id": "1000313",
                                "peak_id": "21",
                                "monoisotopic_mass": "4508.0830",
                                "monoisotopic_mz": "1128.0280",
                                "intensity": "3307.44",
                                "charge": "4"
                            },
                            {
                                "spec_id": "1000313",
                                "peak_id": "22",
                                "monoisotopic_mass": "2179.7026",
                                "monoisotopic_mz": "727.5748",
                                "intensity": "1883.02",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000313",
                                "peak_id": "23",
                                "monoisotopic_mass": "4489.0759",
                                "monoisotopic_mz": "1123.2762",
                                "intensity": "2025.38",
                                "charge": "4"
                            },
                            {
                                "spec_id": "1000313",
                                "peak_id": "24",
                                "monoisotopic_mass": "3494.8626",
                                "monoisotopic_mz": "874.7229",
                                "intensity": "1823.55",
                                "charge": "4"
                            },
                            {
                                "spec_id": "1000313",
                                "peak_id": "25",
                                "monoisotopic_mass": "6505.1226",
                                "monoisotopic_mz": "814.1476",
                                "intensity": "2579.11",
                                "charge": "8"
                            },
                            {
                                "spec_id": "1000313",
                                "peak_id": "26",
                                "monoisotopic_mass": "4378.0494",
                                "monoisotopic_mz": "1095.5196",
                                "intensity": "2730.88",
                                "charge": "4"
                            },
                            {
                                "spec_id": "1000313",
                                "peak_id": "27",
                                "monoisotopic_mass": "1493.1410",
                                "monoisotopic_mz": "747.5778",
                                "intensity": "879.37",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000313",
                                "peak_id": "28",
                                "monoisotopic_mass": "1387.1647",
                                "monoisotopic_mz": "199.1737",
                                "intensity": "1068.98",
                                "charge": "7"
                            },
                            {
                                "spec_id": "1000313",
                                "peak_id": "29",
                                "monoisotopic_mass": "809.9491",
                                "monoisotopic_mz": "810.9564",
                                "intensity": "966.10",
                                "charge": "1"
                            },
                            {
                                "spec_id": "1000313",
                                "peak_id": "30",
                                "monoisotopic_mass": "1041.2271",
                                "monoisotopic_mz": "1042.2344",
                                "intensity": "1225.36",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "4",
                    "proteoform_id": "49",
                    "sequence_name": "sp|P66191|RL31_SALTY",
                    "sequence_description": "50S ribosomal protein L31 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmE PE=3 SV=1",
                    "proteoform_mass": "7709.7958",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "70",
                        "first_residue_position": "0",
                        "last_residue_position": "69",
                        "annotated_seq": ".MKKGIHPNYVEIT(AT(C)[Carbamidomethylation]S(C)[Carbamidomethylation]GNVIKTHSTVGHDLNLDV(C)[Carbamidomethylation]GK(C)[Carbamidomethylation]H)[-232.1805]PFFTGKQRVVDTGGRVERFNKRFSIPGSK.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "K"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "G"
                            },
                            {
                                "position": "4",
                                "acid": "I"
                            },
                            {
                                "position": "5",
                                "acid": "H"
                            },
                            {
                                "position": "6",
                                "acid": "P"
                            },
                            {
                                "position": "7",
                                "acid": "N"
                            },
                            {
                                "position": "8",
                                "acid": "Y"
                            },
                            {
                                "position": "9",
                                "acid": "V"
                            },
                            {
                                "position": "10",
                                "acid": "E"
                            },
                            {
                                "position": "11",
                                "acid": "I"
                            },
                            {
                                "position": "12",
                                "acid": "T"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "T"
                            },
                            {
                                "position": "15",
                                "acid": "C"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "C"
                            },
                            {
                                "position": "18",
                                "acid": "G"
                            },
                            {
                                "position": "19",
                                "acid": "N"
                            },
                            {
                                "position": "20",
                                "acid": "V"
                            },
                            {
                                "position": "21",
                                "acid": "I"
                            },
                            {
                                "position": "22",
                                "acid": "K"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "H"
                            },
                            {
                                "position": "25",
                                "acid": "S"
                            },
                            {
                                "position": "26",
                                "acid": "T"
                            },
                            {
                                "position": "27",
                                "acid": "V"
                            },
                            {
                                "position": "28",
                                "acid": "G"
                            },
                            {
                                "position": "29",
                                "acid": "H"
                            },
                            {
                                "position": "30",
                                "acid": "D"
                            },
                            {
                                "position": "31",
                                "acid": "L"
                            },
                            {
                                "position": "32",
                                "acid": "N"
                            },
                            {
                                "position": "33",
                                "acid": "L"
                            },
                            {
                                "position": "34",
                                "acid": "D"
                            },
                            {
                                "position": "35",
                                "acid": "V"
                            },
                            {
                                "position": "36",
                                "acid": "C"
                            },
                            {
                                "position": "37",
                                "acid": "G"
                            },
                            {
                                "position": "38",
                                "acid": "K"
                            },
                            {
                                "position": "39",
                                "acid": "C"
                            },
                            {
                                "position": "40",
                                "acid": "H"
                            },
                            {
                                "position": "41",
                                "acid": "P"
                            },
                            {
                                "position": "42",
                                "acid": "F"
                            },
                            {
                                "position": "43",
                                "acid": "F"
                            },
                            {
                                "position": "44",
                                "acid": "T"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "K"
                            },
                            {
                                "position": "47",
                                "acid": "Q"
                            },
                            {
                                "position": "48",
                                "acid": "R"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "V"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "T"
                            },
                            {
                                "position": "53",
                                "acid": "G"
                            },
                            {
                                "position": "54",
                                "acid": "G"
                            },
                            {
                                "position": "55",
                                "acid": "R"
                            },
                            {
                                "position": "56",
                                "acid": "V"
                            },
                            {
                                "position": "57",
                                "acid": "E"
                            },
                            {
                                "position": "58",
                                "acid": "R"
                            },
                            {
                                "position": "59",
                                "acid": "F"
                            },
                            {
                                "position": "60",
                                "acid": "N"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "R"
                            },
                            {
                                "position": "63",
                                "acid": "F"
                            },
                            {
                                "position": "64",
                                "acid": "S"
                            },
                            {
                                "position": "65",
                                "acid": "I"
                            },
                            {
                                "position": "66",
                                "acid": "P"
                            },
                            {
                                "position": "67",
                                "acid": "G"
                            },
                            {
                                "position": "68",
                                "acid": "S"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "spec_id": "1000313",
                                        "peak_id": "17",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "10",
                                            "ion_display_position": "10",
                                            "spec_id": "1000313",
                                            "peak_id": "16",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "10",
                                            "ion_display_position": "60",
                                            "spec_id": "1000313",
                                            "peak_id": "1",
                                            "peak_charge": "8"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "11",
                                            "ion_display_position": "11",
                                            "spec_id": "1000313",
                                            "peak_id": "15",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "11",
                                            "ion_display_position": "59",
                                            "spec_id": "1000313",
                                            "peak_id": "2",
                                            "peak_charge": "8"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "12",
                                        "ion_display_position": "58",
                                        "spec_id": "1000313",
                                        "peak_id": "4",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "13",
                                        "ion_display_position": "57",
                                        "spec_id": "1000313",
                                        "peak_id": "3",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "41",
                                            "ion_display_position": "29",
                                            "spec_id": "1000313",
                                            "peak_id": "5",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "41",
                                            "ion_display_position": "29",
                                            "spec_id": "1000313",
                                            "peak_id": "11",
                                            "peak_charge": "5"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "41",
                                            "ion_display_position": "41",
                                            "spec_id": "1000313",
                                            "peak_id": "9",
                                            "peak_charge": "5"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "52",
                                            "ion_display_position": "18",
                                            "spec_id": "1000313",
                                            "peak_id": "8",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "52",
                                            "ion_display_position": "52",
                                            "spec_id": "1000313",
                                            "peak_id": "13",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": [
                                {
                                    "left_pos": "15",
                                    "right_pos": "16",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "17",
                                    "right_pos": "18",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "36",
                                    "right_pos": "37",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "39",
                                    "right_pos": "40",
                                    "anno": "C"
                                }
                            ]
                        },
                        "mass_shift": {
                            "id": "0",
                            "left_position": "13",
                            "right_position": "41",
                            "shift": "-232.1805257115",
                            "anno": "-232.1805",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "45",
                "p_value": "4.27e-05",
                "e_value": "4.27e-05",
                "fdr": "0",
                "matched_fragment_number": "11",
                "matched_peak_number": "13",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                        "ms1_ids": "348",
                        "ms1_scans": "681",
                        "ids": "332",
                        "scans": "682",
                        "precursor_mono_mass": "7709.8175",
                        "precursor_charge": "13",
                        "precursor_mz": "594.0702"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "332",
                                "peak_id": "0",
                                "monoisotopic_mass": "2179.4846",
                                "monoisotopic_mz": "199.1422",
                                "intensity": "2704.50",
                                "charge": "11"
                            },
                            {
                                "spec_id": "332",
                                "peak_id": "1",
                                "monoisotopic_mass": "6200.0050",
                                "monoisotopic_mz": "621.0078",
                                "intensity": "40266.68",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-231.1764757115",
                                        "theoretical_mass": "6200.0033",
                                        "ion_position": "13",
                                        "ion_display_position": "57",
                                        "ion_sort_name": "Y00057",
                                        "ion_left_position": "13",
                                        "mass_error": "0.0017",
                                        "ppm": "0.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "332",
                                "peak_id": "2",
                                "monoisotopic_mass": "6128.9686",
                                "monoisotopic_mz": "613.9041",
                                "intensity": "43878.59",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-231.1764757115",
                                        "theoretical_mass": "6128.9661",
                                        "ion_position": "14",
                                        "ion_display_position": "56",
                                        "ion_sort_name": "Y00056",
                                        "ion_left_position": "14",
                                        "mass_error": "0.0025",
                                        "ppm": "0.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "332",
                                "peak_id": "3",
                                "monoisotopic_mass": "6282.0393",
                                "monoisotopic_mz": "629.2112",
                                "intensity": "32423.15",
                                "charge": "10"
                            },
                            {
                                "spec_id": "332",
                                "peak_id": "4",
                                "monoisotopic_mass": "6162.9886",
                                "monoisotopic_mz": "617.3061",
                                "intensity": "3163.22",
                                "charge": "10"
                            },
                            {
                                "spec_id": "332",
                                "peak_id": "5",
                                "monoisotopic_mass": "6265.0471",
                                "monoisotopic_mz": "627.5120",
                                "intensity": "8475.33",
                                "charge": "10"
                            },
                            {
                                "spec_id": "332",
                                "peak_id": "6",
                                "monoisotopic_mass": "6301.0530",
                                "monoisotopic_mz": "631.1126",
                                "intensity": "28897.51",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-231.1764757115",
                                        "theoretical_mass": "6301.0509",
                                        "ion_position": "12",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0020",
                                        "ppm": "0.32"
                                    }
                                }
                            },
                            {
                                "spec_id": "332",
                                "peak_id": "7",
                                "monoisotopic_mass": "6027.9239",
                                "monoisotopic_mz": "670.7766",
                                "intensity": "14397.08",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-231.1764757115",
                                        "theoretical_mass": "6027.9185",
                                        "ion_position": "15",
                                        "ion_display_position": "55",
                                        "ion_sort_name": "Y00055",
                                        "ion_left_position": "15",
                                        "mass_error": "0.0055",
                                        "ppm": "0.91"
                                    }
                                }
                            },
                            {
                                "spec_id": "332",
                                "peak_id": "8",
                                "monoisotopic_mass": "6506.1607",
                                "monoisotopic_mz": "651.6233",
                                "intensity": "6749.55",
                                "charge": "10"
                            },
                            {
                                "spec_id": "332",
                                "peak_id": "9",
                                "monoisotopic_mass": "6181.9931",
                                "monoisotopic_mz": "619.2066",
                                "intensity": "23343.40",
                                "charge": "10"
                            },
                            {
                                "spec_id": "332",
                                "peak_id": "10",
                                "monoisotopic_mass": "6414.1336",
                                "monoisotopic_mz": "642.4206",
                                "intensity": "5989.57",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-231.1764757115",
                                        "theoretical_mass": "6414.1350",
                                        "ion_position": "11",
                                        "ion_display_position": "59",
                                        "ion_sort_name": "Y00059",
                                        "ion_left_position": "11",
                                        "mass_error": "-0.0014",
                                        "ppm": "-0.22"
                                    }
                                }
                            },
                            {
                                "spec_id": "332",
                                "peak_id": "11",
                                "monoisotopic_mass": "2035.0881",
                                "monoisotopic_mz": "509.7793",
                                "intensity": "31117.46",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2035.1075",
                                        "ion_position": "52",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "Y00018",
                                        "ion_left_position": "52",
                                        "mass_error": "-0.0194",
                                        "ppm": "-9.54"
                                    }
                                }
                            },
                            {
                                "spec_id": "332",
                                "peak_id": "12",
                                "monoisotopic_mass": "4050.0199",
                                "monoisotopic_mz": "676.0106",
                                "intensity": "13741.96",
                                "charge": "6"
                            },
                            {
                                "spec_id": "332",
                                "peak_id": "13",
                                "monoisotopic_mass": "1454.1824",
                                "monoisotopic_mz": "182.7801",
                                "intensity": "977.50",
                                "charge": "8"
                            },
                            {
                                "spec_id": "332",
                                "peak_id": "14",
                                "monoisotopic_mass": "1296.6527",
                                "monoisotopic_mz": "649.3336",
                                "intensity": "35307.10",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1296.6649",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "-0.0122",
                                        "ppm": "-9.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "332",
                                "peak_id": "15",
                                "monoisotopic_mass": "1563.8085",
                                "monoisotopic_mz": "522.2768",
                                "intensity": "6280.29",
                                "charge": "3"
                            },
                            {
                                "spec_id": "332",
                                "peak_id": "16",
                                "monoisotopic_mass": "3835.9195",
                                "monoisotopic_mz": "768.1912",
                                "intensity": "7284.94",
                                "charge": "5"
                            },
                            {
                                "spec_id": "332",
                                "peak_id": "17",
                                "monoisotopic_mass": "1492.7702",
                                "monoisotopic_mz": "498.5973",
                                "intensity": "4929.80",
                                "charge": "3"
                            },
                            {
                                "spec_id": "332",
                                "peak_id": "18",
                                "monoisotopic_mass": "1492.7740",
                                "monoisotopic_mz": "747.3943",
                                "intensity": "3278.14",
                                "charge": "2"
                            },
                            {
                                "spec_id": "332",
                                "peak_id": "19",
                                "monoisotopic_mass": "1409.7354",
                                "monoisotopic_mz": "705.8750",
                                "intensity": "19015.78",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1409.7489",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0135",
                                        "ppm": "-9.57"
                                    }
                                }
                            },
                            {
                                "spec_id": "332",
                                "peak_id": "20",
                                "monoisotopic_mass": "6182.0069",
                                "monoisotopic_mz": "563.0079",
                                "intensity": "2157.98",
                                "charge": "11"
                            },
                            {
                                "spec_id": "332",
                                "peak_id": "21",
                                "monoisotopic_mass": "1510.7826",
                                "monoisotopic_mz": "504.6015",
                                "intensity": "10099.15",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1510.7966",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "-0.0140",
                                        "ppm": "-9.29"
                                    }
                                }
                            },
                            {
                                "spec_id": "332",
                                "peak_id": "22",
                                "monoisotopic_mass": "1068.5434",
                                "monoisotopic_mz": "535.2790",
                                "intensity": "6848.17",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1068.5539",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "-0.0104",
                                        "ppm": "-9.77"
                                    }
                                }
                            },
                            {
                                "spec_id": "332",
                                "peak_id": "23",
                                "monoisotopic_mass": "2035.0848",
                                "monoisotopic_mz": "679.3689",
                                "intensity": "6009.77",
                                "charge": "3"
                            },
                            {
                                "spec_id": "332",
                                "peak_id": "24",
                                "monoisotopic_mass": "6181.0078",
                                "monoisotopic_mz": "687.7859",
                                "intensity": "4535.76",
                                "charge": "9"
                            },
                            {
                                "spec_id": "332",
                                "peak_id": "25",
                                "monoisotopic_mass": "6127.9557",
                                "monoisotopic_mz": "681.8912",
                                "intensity": "28567.74",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-231.1764757115",
                                        "theoretical_mass": "6128.9661",
                                        "ion_position": "14",
                                        "ion_display_position": "56",
                                        "ion_sort_name": "Y00056",
                                        "ion_left_position": "14",
                                        "mass_error": "-0.0081",
                                        "ppm": "-1.32"
                                    }
                                }
                            },
                            {
                                "spec_id": "332",
                                "peak_id": "26",
                                "monoisotopic_mass": "6821.4031",
                                "monoisotopic_mz": "683.1476",
                                "intensity": "3849.09",
                                "charge": "10"
                            },
                            {
                                "spec_id": "332",
                                "peak_id": "27",
                                "monoisotopic_mass": "6198.9845",
                                "monoisotopic_mz": "689.7833",
                                "intensity": "7758.72",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-231.1764757115",
                                        "theoretical_mass": "6200.0033",
                                        "ion_position": "13",
                                        "ion_display_position": "57",
                                        "ion_sort_name": "Y00057",
                                        "ion_left_position": "13",
                                        "mass_error": "-0.0164",
                                        "ppm": "-2.65"
                                    }
                                }
                            },
                            {
                                "spec_id": "332",
                                "peak_id": "28",
                                "monoisotopic_mass": "6915.1549",
                                "monoisotopic_mz": "629.6577",
                                "intensity": "10208.92",
                                "charge": "11"
                            },
                            {
                                "spec_id": "332",
                                "peak_id": "29",
                                "monoisotopic_mass": "4277.1373",
                                "monoisotopic_mz": "713.8635",
                                "intensity": "5669.88",
                                "charge": "6"
                            },
                            {
                                "spec_id": "332",
                                "peak_id": "30",
                                "monoisotopic_mass": "3936.0016",
                                "monoisotopic_mz": "657.0075",
                                "intensity": "5396.48",
                                "charge": "6"
                            },
                            {
                                "spec_id": "332",
                                "peak_id": "31",
                                "monoisotopic_mass": "6110.9595",
                                "monoisotopic_mz": "680.0028",
                                "intensity": "3443.11",
                                "charge": "9"
                            },
                            {
                                "spec_id": "332",
                                "peak_id": "32",
                                "monoisotopic_mass": "4049.0105",
                                "monoisotopic_mz": "810.8094",
                                "intensity": "8517.08",
                                "charge": "5"
                            },
                            {
                                "spec_id": "332",
                                "peak_id": "33",
                                "monoisotopic_mass": "694.3881",
                                "monoisotopic_mz": "695.3953",
                                "intensity": "1887.11",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "694.3949",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "B00006",
                                        "ion_left_position": "6",
                                        "mass_error": "-0.0068",
                                        "ppm": "-9.79"
                                    }
                                }
                            },
                            {
                                "spec_id": "332",
                                "peak_id": "34",
                                "monoisotopic_mass": "1100.5217",
                                "monoisotopic_mz": "551.2681",
                                "intensity": "1578.46",
                                "charge": "2"
                            },
                            {
                                "spec_id": "332",
                                "peak_id": "35",
                                "monoisotopic_mass": "3834.9266",
                                "monoisotopic_mz": "640.1617",
                                "intensity": "4076.60",
                                "charge": "6"
                            },
                            {
                                "spec_id": "332",
                                "peak_id": "36",
                                "monoisotopic_mass": "3933.9952",
                                "monoisotopic_mz": "787.8063",
                                "intensity": "2924.55",
                                "charge": "5"
                            },
                            {
                                "spec_id": "332",
                                "peak_id": "37",
                                "monoisotopic_mass": "1279.6455",
                                "monoisotopic_mz": "640.8300",
                                "intensity": "2047.74",
                                "charge": "2"
                            },
                            {
                                "spec_id": "332",
                                "peak_id": "38",
                                "monoisotopic_mass": "6109.9341",
                                "monoisotopic_mz": "612.0007",
                                "intensity": "7373.74",
                                "charge": "10"
                            },
                            {
                                "spec_id": "332",
                                "peak_id": "39",
                                "monoisotopic_mass": "3063.4357",
                                "monoisotopic_mz": "613.6944",
                                "intensity": "5418.02",
                                "charge": "5"
                            },
                            {
                                "spec_id": "332",
                                "peak_id": "40",
                                "monoisotopic_mass": "3122.0071",
                                "monoisotopic_mz": "625.4087",
                                "intensity": "2318.39",
                                "charge": "5"
                            },
                            {
                                "spec_id": "332",
                                "peak_id": "41",
                                "monoisotopic_mass": "5621.0065",
                                "monoisotopic_mz": "625.5636",
                                "intensity": "3909.41",
                                "charge": "9"
                            },
                            {
                                "spec_id": "332",
                                "peak_id": "42",
                                "monoisotopic_mass": "1387.4436",
                                "monoisotopic_mz": "199.2135",
                                "intensity": "1211.64",
                                "charge": "7"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "4",
                    "proteoform_id": "49",
                    "sequence_name": "sp|P66191|RL31_SALTY",
                    "sequence_description": "50S ribosomal protein L31 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmE PE=3 SV=1",
                    "proteoform_mass": "7710.7999",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "70",
                        "first_residue_position": "0",
                        "last_residue_position": "69",
                        "annotated_seq": ".MKKGIHPNYVEITAT((C)[Carbamidomethylation]S(C)[Carbamidomethylation]GNVIKTHSTVGHDLNLDV(C)[Carbamidomethylation]GK(C)[Carbamidomethylation]HPFFTGKQRVVD)[-231.1765]TGGRVERFNKRFSIPGSK.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "K"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "G"
                            },
                            {
                                "position": "4",
                                "acid": "I"
                            },
                            {
                                "position": "5",
                                "acid": "H"
                            },
                            {
                                "position": "6",
                                "acid": "P"
                            },
                            {
                                "position": "7",
                                "acid": "N"
                            },
                            {
                                "position": "8",
                                "acid": "Y"
                            },
                            {
                                "position": "9",
                                "acid": "V"
                            },
                            {
                                "position": "10",
                                "acid": "E"
                            },
                            {
                                "position": "11",
                                "acid": "I"
                            },
                            {
                                "position": "12",
                                "acid": "T"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "T"
                            },
                            {
                                "position": "15",
                                "acid": "C"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "C"
                            },
                            {
                                "position": "18",
                                "acid": "G"
                            },
                            {
                                "position": "19",
                                "acid": "N"
                            },
                            {
                                "position": "20",
                                "acid": "V"
                            },
                            {
                                "position": "21",
                                "acid": "I"
                            },
                            {
                                "position": "22",
                                "acid": "K"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "H"
                            },
                            {
                                "position": "25",
                                "acid": "S"
                            },
                            {
                                "position": "26",
                                "acid": "T"
                            },
                            {
                                "position": "27",
                                "acid": "V"
                            },
                            {
                                "position": "28",
                                "acid": "G"
                            },
                            {
                                "position": "29",
                                "acid": "H"
                            },
                            {
                                "position": "30",
                                "acid": "D"
                            },
                            {
                                "position": "31",
                                "acid": "L"
                            },
                            {
                                "position": "32",
                                "acid": "N"
                            },
                            {
                                "position": "33",
                                "acid": "L"
                            },
                            {
                                "position": "34",
                                "acid": "D"
                            },
                            {
                                "position": "35",
                                "acid": "V"
                            },
                            {
                                "position": "36",
                                "acid": "C"
                            },
                            {
                                "position": "37",
                                "acid": "G"
                            },
                            {
                                "position": "38",
                                "acid": "K"
                            },
                            {
                                "position": "39",
                                "acid": "C"
                            },
                            {
                                "position": "40",
                                "acid": "H"
                            },
                            {
                                "position": "41",
                                "acid": "P"
                            },
                            {
                                "position": "42",
                                "acid": "F"
                            },
                            {
                                "position": "43",
                                "acid": "F"
                            },
                            {
                                "position": "44",
                                "acid": "T"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "K"
                            },
                            {
                                "position": "47",
                                "acid": "Q"
                            },
                            {
                                "position": "48",
                                "acid": "R"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "V"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "T"
                            },
                            {
                                "position": "53",
                                "acid": "G"
                            },
                            {
                                "position": "54",
                                "acid": "G"
                            },
                            {
                                "position": "55",
                                "acid": "R"
                            },
                            {
                                "position": "56",
                                "acid": "V"
                            },
                            {
                                "position": "57",
                                "acid": "E"
                            },
                            {
                                "position": "58",
                                "acid": "R"
                            },
                            {
                                "position": "59",
                                "acid": "F"
                            },
                            {
                                "position": "60",
                                "acid": "N"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "R"
                            },
                            {
                                "position": "63",
                                "acid": "F"
                            },
                            {
                                "position": "64",
                                "acid": "S"
                            },
                            {
                                "position": "65",
                                "acid": "I"
                            },
                            {
                                "position": "66",
                                "acid": "P"
                            },
                            {
                                "position": "67",
                                "acid": "G"
                            },
                            {
                                "position": "68",
                                "acid": "S"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "spec_id": "332",
                                        "peak_id": "33",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "spec_id": "332",
                                        "peak_id": "22",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "11",
                                            "ion_display_position": "11",
                                            "spec_id": "332",
                                            "peak_id": "14",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "11",
                                            "ion_display_position": "59",
                                            "spec_id": "332",
                                            "peak_id": "10",
                                            "peak_charge": "10"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "332",
                                            "peak_id": "19",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "12",
                                            "ion_display_position": "58",
                                            "spec_id": "332",
                                            "peak_id": "6",
                                            "peak_charge": "10"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "13",
                                            "ion_display_position": "13",
                                            "spec_id": "332",
                                            "peak_id": "21",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "13",
                                            "ion_display_position": "57",
                                            "spec_id": "332",
                                            "peak_id": "27",
                                            "peak_charge": "9"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "13",
                                            "ion_display_position": "57",
                                            "spec_id": "332",
                                            "peak_id": "1",
                                            "peak_charge": "10"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "14",
                                            "ion_display_position": "56",
                                            "spec_id": "332",
                                            "peak_id": "25",
                                            "peak_charge": "9"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "14",
                                            "ion_display_position": "56",
                                            "spec_id": "332",
                                            "peak_id": "2",
                                            "peak_charge": "10"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "15",
                                        "ion_display_position": "55",
                                        "spec_id": "332",
                                        "peak_id": "7",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "52",
                                        "ion_display_position": "18",
                                        "spec_id": "332",
                                        "peak_id": "11",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": [
                                {
                                    "left_pos": "15",
                                    "right_pos": "16",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "17",
                                    "right_pos": "18",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "36",
                                    "right_pos": "37",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "39",
                                    "right_pos": "40",
                                    "anno": "C"
                                }
                            ]
                        },
                        "mass_shift": {
                            "id": "0",
                            "left_position": "15",
                            "right_position": "52",
                            "shift": "-231.1764757115",
                            "anno": "-231.1765",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "164",
                "p_value": "6.67e-04",
                "e_value": "6.68e-04",
                "fdr": "0",
                "matched_fragment_number": "8",
                "matched_peak_number": "8",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_2_ms2.msalign",
                        "ms1_ids": "1000316",
                        "ms1_scans": "628",
                        "ids": "1000311",
                        "scans": "629",
                        "precursor_mono_mass": "7708.7985",
                        "precursor_charge": "11",
                        "precursor_mz": "701.8071"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "1000311",
                                "peak_id": "0",
                                "monoisotopic_mass": "6542.1659",
                                "monoisotopic_mz": "818.7780",
                                "intensity": "14595.46",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-232.1805257115",
                                        "theoretical_mass": "6542.1735",
                                        "ion_position": "10",
                                        "ion_display_position": "60",
                                        "ion_sort_name": "Y00060",
                                        "ion_left_position": "10",
                                        "mass_error": "-0.0076",
                                        "ppm": "-1.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000311",
                                "peak_id": "1",
                                "monoisotopic_mass": "6198.9990",
                                "monoisotopic_mz": "775.8822",
                                "intensity": "7191.76",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-232.1805257115",
                                        "theoretical_mass": "6198.9992",
                                        "ion_position": "13",
                                        "ion_display_position": "57",
                                        "ion_sort_name": "Y00057",
                                        "ion_left_position": "13",
                                        "mass_error": "-0.0002",
                                        "ppm": "-0.03"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000311",
                                "peak_id": "2",
                                "monoisotopic_mass": "6283.0312",
                                "monoisotopic_mz": "786.3862",
                                "intensity": "4871.93",
                                "charge": "8"
                            },
                            {
                                "spec_id": "1000311",
                                "peak_id": "3",
                                "monoisotopic_mass": "2035.0881",
                                "monoisotopic_mz": "509.7793",
                                "intensity": "17791.58",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2035.1075",
                                        "ion_position": "52",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "Y00018",
                                        "ion_left_position": "52",
                                        "mass_error": "-0.0194",
                                        "ppm": "-9.54"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000311",
                                "peak_id": "4",
                                "monoisotopic_mass": "6413.1327",
                                "monoisotopic_mz": "802.6489",
                                "intensity": "9703.87",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-232.1805257115",
                                        "theoretical_mass": "6413.1309",
                                        "ion_position": "11",
                                        "ion_display_position": "59",
                                        "ion_sort_name": "Y00059",
                                        "ion_left_position": "11",
                                        "mass_error": "0.0018",
                                        "ppm": "0.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000311",
                                "peak_id": "5",
                                "monoisotopic_mass": "4925.7610",
                                "monoisotopic_mz": "616.7274",
                                "intensity": "4527.94",
                                "charge": "8"
                            },
                            {
                                "spec_id": "1000311",
                                "peak_id": "6",
                                "monoisotopic_mass": "1296.6528",
                                "monoisotopic_mz": "649.3337",
                                "intensity": "4084.54",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1296.6649",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "-0.0121",
                                        "ppm": "-9.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000311",
                                "peak_id": "7",
                                "monoisotopic_mass": "1906.9978",
                                "monoisotopic_mz": "636.6732",
                                "intensity": "2482.77",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000311",
                                "peak_id": "8",
                                "monoisotopic_mass": "3494.8494",
                                "monoisotopic_mz": "874.7196",
                                "intensity": "4071.05",
                                "charge": "4"
                            },
                            {
                                "spec_id": "1000311",
                                "peak_id": "9",
                                "monoisotopic_mass": "6299.0401",
                                "monoisotopic_mz": "788.3873",
                                "intensity": "19655.51",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-232.1805257115",
                                        "theoretical_mass": "6300.0469",
                                        "ion_position": "12",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0044",
                                        "ppm": "-0.70"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000311",
                                "peak_id": "10",
                                "monoisotopic_mass": "5675.6701",
                                "monoisotopic_mz": "811.8173",
                                "intensity": "2688.11",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-232.1805257115",
                                        "theoretical_mass": "5674.6883",
                                        "ion_position": "52",
                                        "ion_display_position": "52",
                                        "ion_sort_name": "B00052",
                                        "ion_left_position": "52",
                                        "mass_error": "-0.0206",
                                        "ppm": "-3.62"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000311",
                                "peak_id": "11",
                                "monoisotopic_mass": "3309.7438",
                                "monoisotopic_mz": "662.9560",
                                "intensity": "2586.41",
                                "charge": "5"
                            },
                            {
                                "spec_id": "1000311",
                                "peak_id": "12",
                                "monoisotopic_mass": "6180.9688",
                                "monoisotopic_mz": "773.6284",
                                "intensity": "2085.56",
                                "charge": "8"
                            },
                            {
                                "spec_id": "1000311",
                                "peak_id": "13",
                                "monoisotopic_mass": "1167.6068",
                                "monoisotopic_mz": "584.8107",
                                "intensity": "1275.00",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000311",
                                "peak_id": "14",
                                "monoisotopic_mass": "1467.9957",
                                "monoisotopic_mz": "735.0051",
                                "intensity": "949.29",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000311",
                                "peak_id": "15",
                                "monoisotopic_mass": "1312.6465",
                                "monoisotopic_mz": "657.3305",
                                "intensity": "1260.24",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000311",
                                "peak_id": "16",
                                "monoisotopic_mass": "1068.5449",
                                "monoisotopic_mz": "535.2797",
                                "intensity": "2477.87",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1068.5539",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "-0.0090",
                                        "ppm": "-8.40"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000311",
                                "peak_id": "17",
                                "monoisotopic_mass": "6523.2122",
                                "monoisotopic_mz": "816.4088",
                                "intensity": "5624.80",
                                "charge": "8"
                            },
                            {
                                "spec_id": "1000311",
                                "peak_id": "18",
                                "monoisotopic_mass": "3308.7422",
                                "monoisotopic_mz": "552.4643",
                                "intensity": "3049.29",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000311",
                                "peak_id": "19",
                                "monoisotopic_mass": "4264.9610",
                                "monoisotopic_mz": "1067.2475",
                                "intensity": "2174.25",
                                "charge": "4"
                            },
                            {
                                "spec_id": "1000311",
                                "peak_id": "20",
                                "monoisotopic_mass": "3298.7357",
                                "monoisotopic_mz": "825.6912",
                                "intensity": "2442.17",
                                "charge": "4"
                            },
                            {
                                "spec_id": "1000311",
                                "peak_id": "21",
                                "monoisotopic_mass": "7477.2629",
                                "monoisotopic_mz": "748.7336",
                                "intensity": "6793.62",
                                "charge": "10"
                            },
                            {
                                "spec_id": "1000311",
                                "peak_id": "22",
                                "monoisotopic_mass": "4356.3853",
                                "monoisotopic_mz": "727.0715",
                                "intensity": "3030.02",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000311",
                                "peak_id": "23",
                                "monoisotopic_mass": "1432.4586",
                                "monoisotopic_mz": "717.2366",
                                "intensity": "934.38",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000311",
                                "peak_id": "24",
                                "monoisotopic_mass": "4339.3909",
                                "monoisotopic_mz": "724.2391",
                                "intensity": "4595.87",
                                "charge": "6"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "4",
                    "proteoform_id": "49",
                    "sequence_name": "sp|P66191|RL31_SALTY",
                    "sequence_description": "50S ribosomal protein L31 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmE PE=3 SV=1",
                    "proteoform_mass": "7709.7958",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "70",
                        "first_residue_position": "0",
                        "last_residue_position": "69",
                        "annotated_seq": ".MKKGIHPNYVEIT(AT(C)[Carbamidomethylation]S(C)[Carbamidomethylation]GNVIKTHSTVGHDLNLDV(C)[Carbamidomethylation]GK(C)[Carbamidomethylation]HPFFTGKQRVVD)[-232.1805]TGGRVERFNKRFSIPGSK.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "K"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "G"
                            },
                            {
                                "position": "4",
                                "acid": "I"
                            },
                            {
                                "position": "5",
                                "acid": "H"
                            },
                            {
                                "position": "6",
                                "acid": "P"
                            },
                            {
                                "position": "7",
                                "acid": "N"
                            },
                            {
                                "position": "8",
                                "acid": "Y"
                            },
                            {
                                "position": "9",
                                "acid": "V"
                            },
                            {
                                "position": "10",
                                "acid": "E"
                            },
                            {
                                "position": "11",
                                "acid": "I"
                            },
                            {
                                "position": "12",
                                "acid": "T"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "T"
                            },
                            {
                                "position": "15",
                                "acid": "C"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "C"
                            },
                            {
                                "position": "18",
                                "acid": "G"
                            },
                            {
                                "position": "19",
                                "acid": "N"
                            },
                            {
                                "position": "20",
                                "acid": "V"
                            },
                            {
                                "position": "21",
                                "acid": "I"
                            },
                            {
                                "position": "22",
                                "acid": "K"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "H"
                            },
                            {
                                "position": "25",
                                "acid": "S"
                            },
                            {
                                "position": "26",
                                "acid": "T"
                            },
                            {
                                "position": "27",
                                "acid": "V"
                            },
                            {
                                "position": "28",
                                "acid": "G"
                            },
                            {
                                "position": "29",
                                "acid": "H"
                            },
                            {
                                "position": "30",
                                "acid": "D"
                            },
                            {
                                "position": "31",
                                "acid": "L"
                            },
                            {
                                "position": "32",
                                "acid": "N"
                            },
                            {
                                "position": "33",
                                "acid": "L"
                            },
                            {
                                "position": "34",
                                "acid": "D"
                            },
                            {
                                "position": "35",
                                "acid": "V"
                            },
                            {
                                "position": "36",
                                "acid": "C"
                            },
                            {
                                "position": "37",
                                "acid": "G"
                            },
                            {
                                "position": "38",
                                "acid": "K"
                            },
                            {
                                "position": "39",
                                "acid": "C"
                            },
                            {
                                "position": "40",
                                "acid": "H"
                            },
                            {
                                "position": "41",
                                "acid": "P"
                            },
                            {
                                "position": "42",
                                "acid": "F"
                            },
                            {
                                "position": "43",
                                "acid": "F"
                            },
                            {
                                "position": "44",
                                "acid": "T"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "K"
                            },
                            {
                                "position": "47",
                                "acid": "Q"
                            },
                            {
                                "position": "48",
                                "acid": "R"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "V"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "T"
                            },
                            {
                                "position": "53",
                                "acid": "G"
                            },
                            {
                                "position": "54",
                                "acid": "G"
                            },
                            {
                                "position": "55",
                                "acid": "R"
                            },
                            {
                                "position": "56",
                                "acid": "V"
                            },
                            {
                                "position": "57",
                                "acid": "E"
                            },
                            {
                                "position": "58",
                                "acid": "R"
                            },
                            {
                                "position": "59",
                                "acid": "F"
                            },
                            {
                                "position": "60",
                                "acid": "N"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "R"
                            },
                            {
                                "position": "63",
                                "acid": "F"
                            },
                            {
                                "position": "64",
                                "acid": "S"
                            },
                            {
                                "position": "65",
                                "acid": "I"
                            },
                            {
                                "position": "66",
                                "acid": "P"
                            },
                            {
                                "position": "67",
                                "acid": "G"
                            },
                            {
                                "position": "68",
                                "acid": "S"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "spec_id": "1000311",
                                        "peak_id": "16",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "10",
                                        "ion_display_position": "60",
                                        "spec_id": "1000311",
                                        "peak_id": "0",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "11",
                                            "ion_display_position": "11",
                                            "spec_id": "1000311",
                                            "peak_id": "6",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "11",
                                            "ion_display_position": "59",
                                            "spec_id": "1000311",
                                            "peak_id": "4",
                                            "peak_charge": "8"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "12",
                                        "ion_display_position": "58",
                                        "spec_id": "1000311",
                                        "peak_id": "9",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "13",
                                        "ion_display_position": "57",
                                        "spec_id": "1000311",
                                        "peak_id": "1",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "52",
                                            "ion_display_position": "18",
                                            "spec_id": "1000311",
                                            "peak_id": "3",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "52",
                                            "ion_display_position": "52",
                                            "spec_id": "1000311",
                                            "peak_id": "10",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": [
                                {
                                    "left_pos": "15",
                                    "right_pos": "16",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "17",
                                    "right_pos": "18",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "36",
                                    "right_pos": "37",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "39",
                                    "right_pos": "40",
                                    "anno": "C"
                                }
                            ]
                        },
                        "mass_shift": {
                            "id": "0",
                            "left_position": "13",
                            "right_position": "52",
                            "shift": "-232.1805257115",
                            "anno": "-232.1805",
                            "shift_type": "unexpected"
                        }
                    }
                }
            }
        ]
    }
}
