prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "10",
        "sequence_name": "sp|P0A7Q8|RL36_SALTY",
        "sequence_description": "50S ribosomal protein L36 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmJ PE=3 SV=1",
        "proteoform_id": "47",
        "prsm_number": "3",
        "prsm": [
            {
                "prsm_id": "18",
                "p_value": "2.61e-06",
                "e_value": "2.61e-06",
                "fdr": "0",
                "matched_fragment_number": "7",
                "matched_peak_number": "8",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                        "ms1_ids": "216",
                        "ms1_scans": "417",
                        "ids": "200",
                        "scans": "418",
                        "precursor_mono_mass": "4568.4059",
                        "precursor_charge": "8",
                        "precursor_mz": "572.0580"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "200",
                                "peak_id": "0",
                                "monoisotopic_mass": "2178.3394",
                                "monoisotopic_mz": "199.0381",
                                "intensity": "12627.46",
                                "charge": "11"
                            },
                            {
                                "spec_id": "200",
                                "peak_id": "1",
                                "monoisotopic_mass": "4437.3676",
                                "monoisotopic_mz": "634.9169",
                                "intensity": "26040.34",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "35.8967855680",
                                        "theoretical_mass": "4437.3704",
                                        "ion_position": "1",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "Y00037",
                                        "ion_left_position": "1",
                                        "mass_error": "-0.0028",
                                        "ppm": "-0.63"
                                    }
                                }
                            },
                            {
                                "spec_id": "200",
                                "peak_id": "2",
                                "monoisotopic_mass": "4309.2774",
                                "monoisotopic_mz": "616.6183",
                                "intensity": "28382.69",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "35.8967855680",
                                        "theoretical_mass": "4309.2755",
                                        "ion_position": "2",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "Y00036",
                                        "ion_left_position": "2",
                                        "mass_error": "0.0019",
                                        "ppm": "0.45"
                                    }
                                }
                            },
                            {
                                "spec_id": "200",
                                "peak_id": "3",
                                "monoisotopic_mass": "3590.8603",
                                "monoisotopic_mz": "719.1793",
                                "intensity": "32102.99",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "35.8967855680",
                                        "theoretical_mass": "3590.8590",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "0.0013",
                                        "ppm": "0.36"
                                    }
                                }
                            },
                            {
                                "spec_id": "200",
                                "peak_id": "4",
                                "monoisotopic_mass": "2474.3323",
                                "monoisotopic_mz": "619.5903",
                                "intensity": "11763.17",
                                "charge": "4"
                            },
                            {
                                "spec_id": "200",
                                "peak_id": "5",
                                "monoisotopic_mass": "4420.3466",
                                "monoisotopic_mz": "632.4854",
                                "intensity": "52145.13",
                                "charge": "7"
                            },
                            {
                                "spec_id": "200",
                                "peak_id": "6",
                                "monoisotopic_mass": "1807.0642",
                                "monoisotopic_mz": "603.3620",
                                "intensity": "16280.28",
                                "charge": "3"
                            },
                            {
                                "spec_id": "200",
                                "peak_id": "7",
                                "monoisotopic_mass": "977.5423",
                                "monoisotopic_mz": "489.7784",
                                "intensity": "21016.35",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "977.5519",
                                        "ion_position": "30",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0096",
                                        "ppm": "-9.85"
                                    }
                                }
                            },
                            {
                                "spec_id": "200",
                                "peak_id": "8",
                                "monoisotopic_mass": "487.2457",
                                "monoisotopic_mz": "488.2529",
                                "intensity": "15213.74",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "487.2503",
                                        "ion_position": "34",
                                        "ion_display_position": "4",
                                        "ion_sort_name": "Y00004",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0046",
                                        "ppm": "-9.53"
                                    }
                                }
                            },
                            {
                                "spec_id": "200",
                                "peak_id": "9",
                                "monoisotopic_mass": "4403.3203",
                                "monoisotopic_mz": "630.0530",
                                "intensity": "15822.11",
                                "charge": "7"
                            },
                            {
                                "spec_id": "200",
                                "peak_id": "10",
                                "monoisotopic_mass": "977.5427",
                                "monoisotopic_mz": "326.8549",
                                "intensity": "11891.04",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "977.5519",
                                        "ion_position": "30",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0091",
                                        "ppm": "-9.36"
                                    }
                                }
                            },
                            {
                                "spec_id": "200",
                                "peak_id": "11",
                                "monoisotopic_mass": "1463.3791",
                                "monoisotopic_mz": "366.8521",
                                "intensity": "4209.14",
                                "charge": "4"
                            },
                            {
                                "spec_id": "200",
                                "peak_id": "12",
                                "monoisotopic_mass": "752.3978",
                                "monoisotopic_mz": "377.2062",
                                "intensity": "13178.96",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "752.4042",
                                        "ion_position": "32",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "32",
                                        "mass_error": "-0.0064",
                                        "ppm": "-8.47"
                                    }
                                }
                            },
                            {
                                "spec_id": "200",
                                "peak_id": "13",
                                "monoisotopic_mass": "5709.3938",
                                "monoisotopic_mz": "1904.1385",
                                "intensity": "11446.13",
                                "charge": "3"
                            },
                            {
                                "spec_id": "200",
                                "peak_id": "14",
                                "monoisotopic_mass": "615.3388",
                                "monoisotopic_mz": "616.3461",
                                "intensity": "12450.48",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "615.3453",
                                        "ion_position": "33",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "Y00005",
                                        "ion_left_position": "33",
                                        "mass_error": "-0.0064",
                                        "ppm": "-10.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "200",
                                "peak_id": "15",
                                "monoisotopic_mass": "5061.4925",
                                "monoisotopic_mz": "633.6938",
                                "intensity": "6311.14",
                                "charge": "8"
                            },
                            {
                                "spec_id": "200",
                                "peak_id": "16",
                                "monoisotopic_mass": "1188.8341",
                                "monoisotopic_mz": "199.1463",
                                "intensity": "2948.53",
                                "charge": "6"
                            },
                            {
                                "spec_id": "200",
                                "peak_id": "17",
                                "monoisotopic_mass": "1387.2899",
                                "monoisotopic_mz": "199.1915",
                                "intensity": "4766.64",
                                "charge": "7"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "10",
                    "proteoform_id": "47",
                    "sequence_name": "sp|P0A7Q8|RL36_SALTY",
                    "sequence_description": "50S ribosomal protein L36 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmJ PE=3 SV=1",
                    "proteoform_mass": "4568.4109",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "38",
                        "first_residue_position": "0",
                        "last_residue_position": "37",
                        "annotated_seq": ".MK(VRASVKKL(C)[Carbamidomethylation]RN(C)[Carbamidomethylation]KIVKRDGVIRVI(C)[Carbamidomethylation]SAE)[+35.8968]PKHKQRQG.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "K"
                            },
                            {
                                "position": "2",
                                "acid": "V"
                            },
                            {
                                "position": "3",
                                "acid": "R"
                            },
                            {
                                "position": "4",
                                "acid": "A"
                            },
                            {
                                "position": "5",
                                "acid": "S"
                            },
                            {
                                "position": "6",
                                "acid": "V"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "L"
                            },
                            {
                                "position": "10",
                                "acid": "C"
                            },
                            {
                                "position": "11",
                                "acid": "R"
                            },
                            {
                                "position": "12",
                                "acid": "N"
                            },
                            {
                                "position": "13",
                                "acid": "C"
                            },
                            {
                                "position": "14",
                                "acid": "K"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "V"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "R"
                            },
                            {
                                "position": "19",
                                "acid": "D"
                            },
                            {
                                "position": "20",
                                "acid": "G"
                            },
                            {
                                "position": "21",
                                "acid": "V"
                            },
                            {
                                "position": "22",
                                "acid": "I"
                            },
                            {
                                "position": "23",
                                "acid": "R"
                            },
                            {
                                "position": "24",
                                "acid": "V"
                            },
                            {
                                "position": "25",
                                "acid": "I"
                            },
                            {
                                "position": "26",
                                "acid": "C"
                            },
                            {
                                "position": "27",
                                "acid": "S"
                            },
                            {
                                "position": "28",
                                "acid": "A"
                            },
                            {
                                "position": "29",
                                "acid": "E"
                            },
                            {
                                "position": "30",
                                "acid": "P"
                            },
                            {
                                "position": "31",
                                "acid": "K"
                            },
                            {
                                "position": "32",
                                "acid": "H"
                            },
                            {
                                "position": "33",
                                "acid": "K"
                            },
                            {
                                "position": "34",
                                "acid": "Q"
                            },
                            {
                                "position": "35",
                                "acid": "R"
                            },
                            {
                                "position": "36",
                                "acid": "Q"
                            },
                            {
                                "position": "37",
                                "acid": "G"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "1",
                                        "ion_display_position": "37",
                                        "spec_id": "200",
                                        "peak_id": "1",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "2",
                                        "ion_display_position": "36",
                                        "spec_id": "200",
                                        "peak_id": "2",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "30",
                                            "ion_display_position": "8",
                                            "spec_id": "200",
                                            "peak_id": "7",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "30",
                                            "ion_display_position": "8",
                                            "spec_id": "200",
                                            "peak_id": "10",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "30",
                                            "ion_display_position": "30",
                                            "spec_id": "200",
                                            "peak_id": "3",
                                            "peak_charge": "5"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "32",
                                        "ion_display_position": "6",
                                        "spec_id": "200",
                                        "peak_id": "12",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "33",
                                        "ion_display_position": "5",
                                        "spec_id": "200",
                                        "peak_id": "14",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "34",
                                        "ion_display_position": "4",
                                        "spec_id": "200",
                                        "peak_id": "8",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": [
                                {
                                    "left_pos": "10",
                                    "right_pos": "11",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "13",
                                    "right_pos": "14",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "26",
                                    "right_pos": "27",
                                    "anno": "C"
                                }
                            ]
                        },
                        "mass_shift": {
                            "id": "0",
                            "left_position": "2",
                            "right_position": "30",
                            "shift": "35.8967855680",
                            "anno": "+35.8968",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "19",
                "p_value": "3.99e-06",
                "e_value": "3.99e-06",
                "fdr": "0",
                "matched_fragment_number": "8",
                "matched_peak_number": "8",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                        "ms1_ids": "217",
                        "ms1_scans": "419",
                        "ids": "201",
                        "scans": "420",
                        "precursor_mono_mass": "4568.4059",
                        "precursor_charge": "9",
                        "precursor_mz": "508.6079"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "201",
                                "peak_id": "0",
                                "monoisotopic_mass": "4420.3455",
                                "monoisotopic_mz": "553.5505",
                                "intensity": "14991.30",
                                "charge": "8"
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "1",
                                "monoisotopic_mass": "3525.8355",
                                "monoisotopic_mz": "588.6465",
                                "intensity": "6785.16",
                                "charge": "6"
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "2",
                                "monoisotopic_mass": "4402.3135",
                                "monoisotopic_mz": "551.2965",
                                "intensity": "2828.91",
                                "charge": "8"
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "3",
                                "monoisotopic_mass": "3331.7310",
                                "monoisotopic_mz": "667.3535",
                                "intensity": "20442.00",
                                "charge": "5"
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "4",
                                "monoisotopic_mass": "4310.2657",
                                "monoisotopic_mz": "539.7905",
                                "intensity": "3538.31",
                                "charge": "8"
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "5",
                                "monoisotopic_mass": "3442.7964",
                                "monoisotopic_mz": "689.5666",
                                "intensity": "20069.57",
                                "charge": "5"
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "6",
                                "monoisotopic_mass": "3590.8632",
                                "monoisotopic_mz": "599.4845",
                                "intensity": "103417.79",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "35.9017855680",
                                        "theoretical_mass": "3590.8640",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0008",
                                        "ppm": "-0.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "7",
                                "monoisotopic_mass": "3497.8485",
                                "monoisotopic_mz": "583.9820",
                                "intensity": "4914.13",
                                "charge": "6"
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "8",
                                "monoisotopic_mass": "4437.3554",
                                "monoisotopic_mz": "555.6767",
                                "intensity": "7367.44",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "35.9017855680",
                                        "theoretical_mass": "4437.3754",
                                        "ion_position": "1",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "Y00037",
                                        "ion_left_position": "1",
                                        "mass_error": "-0.0201",
                                        "ppm": "-4.52"
                                    }
                                }
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "9",
                                "monoisotopic_mass": "3459.8249",
                                "monoisotopic_mz": "692.9723",
                                "intensity": "22192.11",
                                "charge": "5"
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "10",
                                "monoisotopic_mass": "2692.3320",
                                "monoisotopic_mz": "674.0903",
                                "intensity": "3023.46",
                                "charge": "4"
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "11",
                                "monoisotopic_mass": "3573.8443",
                                "monoisotopic_mz": "596.6480",
                                "intensity": "10965.53",
                                "charge": "6"
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "12",
                                "monoisotopic_mass": "1834.9372",
                                "monoisotopic_mz": "612.6530",
                                "intensity": "2058.99",
                                "charge": "3"
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "13",
                                "monoisotopic_mass": "977.5435",
                                "monoisotopic_mz": "326.8551",
                                "intensity": "59126.82",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "977.5519",
                                        "ion_position": "30",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0084",
                                        "ppm": "-8.61"
                                    }
                                }
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "14",
                                "monoisotopic_mass": "2691.3319",
                                "monoisotopic_mz": "898.1179",
                                "intensity": "3575.02",
                                "charge": "3"
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "15",
                                "monoisotopic_mass": "752.3976",
                                "monoisotopic_mz": "377.2061",
                                "intensity": "14972.91",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "752.4042",
                                        "ion_position": "32",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "32",
                                        "mass_error": "-0.0065",
                                        "ppm": "-8.70"
                                    }
                                }
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "16",
                                "monoisotopic_mass": "3543.8652",
                                "monoisotopic_mz": "591.6515",
                                "intensity": "9010.36",
                                "charge": "6"
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "17",
                                "monoisotopic_mass": "3424.7831",
                                "monoisotopic_mz": "685.9639",
                                "intensity": "4949.61",
                                "charge": "5"
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "18",
                                "monoisotopic_mass": "615.3392",
                                "monoisotopic_mz": "616.3465",
                                "intensity": "5576.98",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "615.3453",
                                        "ion_position": "33",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "Y00005",
                                        "ion_left_position": "33",
                                        "mass_error": "-0.0060",
                                        "ppm": "-9.81"
                                    }
                                }
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "19",
                                "monoisotopic_mass": "2563.2487",
                                "monoisotopic_mz": "855.4235",
                                "intensity": "2889.43",
                                "charge": "3"
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "20",
                                "monoisotopic_mass": "1173.4994",
                                "monoisotopic_mz": "392.1737",
                                "intensity": "1722.62",
                                "charge": "3"
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "21",
                                "monoisotopic_mass": "880.4909",
                                "monoisotopic_mz": "441.2527",
                                "intensity": "4004.87",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "880.4991",
                                        "ion_position": "31",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "31",
                                        "mass_error": "-0.0082",
                                        "ppm": "-9.30"
                                    }
                                }
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "22",
                                "monoisotopic_mass": "1176.6197",
                                "monoisotopic_mz": "589.3171",
                                "intensity": "999.62",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "35.9017855680",
                                        "theoretical_mass": "1176.6183",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0014",
                                        "ppm": "1.20"
                                    }
                                }
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "23",
                                "monoisotopic_mass": "1782.9991",
                                "monoisotopic_mz": "199.1183",
                                "intensity": "3618.39",
                                "charge": "9"
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "24",
                                "monoisotopic_mass": "960.5182",
                                "monoisotopic_mz": "321.1800",
                                "intensity": "1998.21",
                                "charge": "3"
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "25",
                                "monoisotopic_mass": "470.2379",
                                "monoisotopic_mz": "471.2452",
                                "intensity": "2362.90",
                                "charge": "1"
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "26",
                                "monoisotopic_mass": "1125.6726",
                                "monoisotopic_mz": "226.1418",
                                "intensity": "1776.14",
                                "charge": "5"
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "27",
                                "monoisotopic_mass": "3313.7171",
                                "monoisotopic_mz": "663.7507",
                                "intensity": "3543.54",
                                "charge": "5"
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "28",
                                "monoisotopic_mass": "1106.5860",
                                "monoisotopic_mz": "554.3003",
                                "intensity": "1262.48",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1106.5945",
                                        "ion_position": "29",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "29",
                                        "mass_error": "-0.0085",
                                        "ppm": "-7.64"
                                    }
                                }
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "29",
                                "monoisotopic_mass": "1787.9283",
                                "monoisotopic_mz": "596.9834",
                                "intensity": "1948.14",
                                "charge": "3"
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "30",
                                "monoisotopic_mass": "1387.4028",
                                "monoisotopic_mz": "199.2077",
                                "intensity": "1087.99",
                                "charge": "7"
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "31",
                                "monoisotopic_mass": "692.5643",
                                "monoisotopic_mz": "693.5716",
                                "intensity": "2491.94",
                                "charge": "1"
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "32",
                                "monoisotopic_mass": "1188.7846",
                                "monoisotopic_mz": "199.1380",
                                "intensity": "731.41",
                                "charge": "6"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "10",
                    "proteoform_id": "47",
                    "sequence_name": "sp|P0A7Q8|RL36_SALTY",
                    "sequence_description": "50S ribosomal protein L36 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmJ PE=3 SV=1",
                    "proteoform_mass": "4568.4159",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "38",
                        "first_residue_position": "0",
                        "last_residue_position": "37",
                        "annotated_seq": ".M(KVRASVKKL)[+35.9018](C)[Carbamidomethylation]RN(C)[Carbamidomethylation]KIVKRDGVIRVI(C)[Carbamidomethylation]SAEPKHKQRQG.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "K"
                            },
                            {
                                "position": "2",
                                "acid": "V"
                            },
                            {
                                "position": "3",
                                "acid": "R"
                            },
                            {
                                "position": "4",
                                "acid": "A"
                            },
                            {
                                "position": "5",
                                "acid": "S"
                            },
                            {
                                "position": "6",
                                "acid": "V"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "L"
                            },
                            {
                                "position": "10",
                                "acid": "C"
                            },
                            {
                                "position": "11",
                                "acid": "R"
                            },
                            {
                                "position": "12",
                                "acid": "N"
                            },
                            {
                                "position": "13",
                                "acid": "C"
                            },
                            {
                                "position": "14",
                                "acid": "K"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "V"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "R"
                            },
                            {
                                "position": "19",
                                "acid": "D"
                            },
                            {
                                "position": "20",
                                "acid": "G"
                            },
                            {
                                "position": "21",
                                "acid": "V"
                            },
                            {
                                "position": "22",
                                "acid": "I"
                            },
                            {
                                "position": "23",
                                "acid": "R"
                            },
                            {
                                "position": "24",
                                "acid": "V"
                            },
                            {
                                "position": "25",
                                "acid": "I"
                            },
                            {
                                "position": "26",
                                "acid": "C"
                            },
                            {
                                "position": "27",
                                "acid": "S"
                            },
                            {
                                "position": "28",
                                "acid": "A"
                            },
                            {
                                "position": "29",
                                "acid": "E"
                            },
                            {
                                "position": "30",
                                "acid": "P"
                            },
                            {
                                "position": "31",
                                "acid": "K"
                            },
                            {
                                "position": "32",
                                "acid": "H"
                            },
                            {
                                "position": "33",
                                "acid": "K"
                            },
                            {
                                "position": "34",
                                "acid": "Q"
                            },
                            {
                                "position": "35",
                                "acid": "R"
                            },
                            {
                                "position": "36",
                                "acid": "Q"
                            },
                            {
                                "position": "37",
                                "acid": "G"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "1",
                                        "ion_display_position": "37",
                                        "spec_id": "201",
                                        "peak_id": "8",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "201",
                                        "peak_id": "22",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "29",
                                        "ion_display_position": "9",
                                        "spec_id": "201",
                                        "peak_id": "28",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "30",
                                            "ion_display_position": "8",
                                            "spec_id": "201",
                                            "peak_id": "13",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "30",
                                            "ion_display_position": "30",
                                            "spec_id": "201",
                                            "peak_id": "6",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "31",
                                        "ion_display_position": "7",
                                        "spec_id": "201",
                                        "peak_id": "21",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "32",
                                        "ion_display_position": "6",
                                        "spec_id": "201",
                                        "peak_id": "15",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "33",
                                        "ion_display_position": "5",
                                        "spec_id": "201",
                                        "peak_id": "18",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": [
                                {
                                    "left_pos": "10",
                                    "right_pos": "11",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "13",
                                    "right_pos": "14",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "26",
                                    "right_pos": "27",
                                    "anno": "C"
                                }
                            ]
                        },
                        "mass_shift": {
                            "id": "0",
                            "left_position": "1",
                            "right_position": "10",
                            "shift": "35.9017855680",
                            "anno": "+35.9018",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "129",
                "p_value": "4.24e-05",
                "e_value": "4.24e-05",
                "fdr": "0",
                "matched_fragment_number": "8",
                "matched_peak_number": "9",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_2_ms2.msalign",
                        "ms1_ids": "1000201",
                        "ms1_scans": "398",
                        "ids": "1000196",
                        "scans": "399",
                        "precursor_mono_mass": "4568.4050",
                        "precursor_charge": "7",
                        "precursor_mz": "653.6366"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "1000196",
                                "peak_id": "0",
                                "monoisotopic_mass": "3684.9702",
                                "monoisotopic_mz": "922.2498",
                                "intensity": "37090.57",
                                "charge": "4"
                            },
                            {
                                "spec_id": "1000196",
                                "peak_id": "1",
                                "monoisotopic_mass": "3556.8768",
                                "monoisotopic_mz": "890.2265",
                                "intensity": "19939.32",
                                "charge": "4"
                            },
                            {
                                "spec_id": "1000196",
                                "peak_id": "2",
                                "monoisotopic_mass": "3667.9546",
                                "monoisotopic_mz": "917.9959",
                                "intensity": "12603.98",
                                "charge": "4"
                            },
                            {
                                "spec_id": "1000196",
                                "peak_id": "3",
                                "monoisotopic_mass": "4437.3672",
                                "monoisotopic_mz": "740.5685",
                                "intensity": "171509.56",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "35.9008255680",
                                        "theoretical_mass": "4437.3745",
                                        "ion_position": "1",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "Y00037",
                                        "ion_left_position": "1",
                                        "mass_error": "-0.0073",
                                        "ppm": "-1.65"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000196",
                                "peak_id": "4",
                                "monoisotopic_mass": "752.3970",
                                "monoisotopic_mz": "753.4042",
                                "intensity": "26864.88",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "752.4042",
                                        "ion_position": "32",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "32",
                                        "mass_error": "-0.0072",
                                        "ppm": "-9.58"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000196",
                                "peak_id": "5",
                                "monoisotopic_mass": "3331.7267",
                                "monoisotopic_mz": "833.9389",
                                "intensity": "37795.10",
                                "charge": "4"
                            },
                            {
                                "spec_id": "1000196",
                                "peak_id": "6",
                                "monoisotopic_mass": "3459.8245",
                                "monoisotopic_mz": "865.9634",
                                "intensity": "49391.93",
                                "charge": "4"
                            },
                            {
                                "spec_id": "1000196",
                                "peak_id": "7",
                                "monoisotopic_mass": "4293.2604",
                                "monoisotopic_mz": "716.5507",
                                "intensity": "26871.19",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000196",
                                "peak_id": "8",
                                "monoisotopic_mass": "615.3396",
                                "monoisotopic_mz": "616.3469",
                                "intensity": "39077.66",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "615.3453",
                                        "ion_position": "33",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "Y00005",
                                        "ion_left_position": "33",
                                        "mass_error": "-0.0057",
                                        "ppm": "-9.21"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000196",
                                "peak_id": "9",
                                "monoisotopic_mass": "3816.0114",
                                "monoisotopic_mz": "764.2095",
                                "intensity": "33617.34",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "35.9008255680",
                                        "theoretical_mass": "3816.0108",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "ion_sort_name": "B00032",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0006",
                                        "ppm": "0.15"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000196",
                                "peak_id": "10",
                                "monoisotopic_mass": "977.5428",
                                "monoisotopic_mz": "489.7787",
                                "intensity": "50753.18",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "977.5519",
                                        "ion_position": "30",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0091",
                                        "ppm": "-9.35"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000196",
                                "peak_id": "11",
                                "monoisotopic_mass": "3314.7134",
                                "monoisotopic_mz": "829.6856",
                                "intensity": "11611.26",
                                "charge": "4"
                            },
                            {
                                "spec_id": "1000196",
                                "peak_id": "12",
                                "monoisotopic_mass": "3797.9865",
                                "monoisotopic_mz": "760.6046",
                                "intensity": "12881.32",
                                "charge": "5"
                            },
                            {
                                "spec_id": "1000196",
                                "peak_id": "13",
                                "monoisotopic_mass": "4326.4091",
                                "monoisotopic_mz": "619.0657",
                                "intensity": "10564.23",
                                "charge": "7"
                            },
                            {
                                "spec_id": "1000196",
                                "peak_id": "14",
                                "monoisotopic_mass": "752.3977",
                                "monoisotopic_mz": "377.2061",
                                "intensity": "33571.87",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "752.4042",
                                        "ion_position": "32",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "32",
                                        "mass_error": "-0.0065",
                                        "ppm": "-8.62"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000196",
                                "peak_id": "15",
                                "monoisotopic_mass": "487.2459",
                                "monoisotopic_mz": "488.2531",
                                "intensity": "27924.13",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "487.2503",
                                        "ion_position": "34",
                                        "ion_display_position": "4",
                                        "ion_sort_name": "Y00004",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0044",
                                        "ppm": "-9.08"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000196",
                                "peak_id": "16",
                                "monoisotopic_mass": "3936.0675",
                                "monoisotopic_mz": "788.2208",
                                "intensity": "18813.14",
                                "charge": "5"
                            },
                            {
                                "spec_id": "1000196",
                                "peak_id": "17",
                                "monoisotopic_mass": "3441.8089",
                                "monoisotopic_mz": "861.4595",
                                "intensity": "22100.09",
                                "charge": "4"
                            },
                            {
                                "spec_id": "1000196",
                                "peak_id": "18",
                                "monoisotopic_mass": "3705.9416",
                                "monoisotopic_mz": "927.4927",
                                "intensity": "4379.88",
                                "charge": "4"
                            },
                            {
                                "spec_id": "1000196",
                                "peak_id": "19",
                                "monoisotopic_mass": "4195.3719",
                                "monoisotopic_mz": "700.2359",
                                "intensity": "7905.73",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000196",
                                "peak_id": "20",
                                "monoisotopic_mass": "4309.2822",
                                "monoisotopic_mz": "719.2210",
                                "intensity": "140803.15",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "35.9008255680",
                                        "theoretical_mass": "4309.2795",
                                        "ion_position": "2",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "Y00036",
                                        "ion_left_position": "2",
                                        "mass_error": "0.0027",
                                        "ppm": "0.62"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000196",
                                "peak_id": "21",
                                "monoisotopic_mass": "4419.3488",
                                "monoisotopic_mz": "737.5654",
                                "intensity": "53822.25",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000196",
                                "peak_id": "22",
                                "monoisotopic_mass": "1309.7515",
                                "monoisotopic_mz": "437.5911",
                                "intensity": "2686.73",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000196",
                                "peak_id": "23",
                                "monoisotopic_mass": "3590.8601",
                                "monoisotopic_mz": "898.7223",
                                "intensity": "11949.20",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "35.9008255680",
                                        "theoretical_mass": "3590.8631",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0029",
                                        "ppm": "-0.81"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000196",
                                "peak_id": "24",
                                "monoisotopic_mass": "4402.3265",
                                "monoisotopic_mz": "734.7284",
                                "intensity": "14742.96",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000196",
                                "peak_id": "25",
                                "monoisotopic_mass": "2839.4740",
                                "monoisotopic_mz": "710.8758",
                                "intensity": "5813.53",
                                "charge": "4"
                            },
                            {
                                "spec_id": "1000196",
                                "peak_id": "26",
                                "monoisotopic_mass": "469.2359",
                                "monoisotopic_mz": "470.2432",
                                "intensity": "4219.70",
                                "charge": "1"
                            },
                            {
                                "spec_id": "1000196",
                                "peak_id": "27",
                                "monoisotopic_mass": "3592.8685",
                                "monoisotopic_mz": "719.5810",
                                "intensity": "27665.78",
                                "charge": "5"
                            },
                            {
                                "spec_id": "1000196",
                                "peak_id": "28",
                                "monoisotopic_mass": "1349.4305",
                                "monoisotopic_mz": "675.7225",
                                "intensity": "3550.27",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000196",
                                "peak_id": "29",
                                "monoisotopic_mass": "856.9484",
                                "monoisotopic_mz": "857.9557",
                                "intensity": "3365.61",
                                "charge": "1"
                            },
                            {
                                "spec_id": "1000196",
                                "peak_id": "30",
                                "monoisotopic_mass": "3572.8122",
                                "monoisotopic_mz": "715.5697",
                                "intensity": "5103.75",
                                "charge": "5"
                            },
                            {
                                "spec_id": "1000196",
                                "peak_id": "31",
                                "monoisotopic_mass": "1402.7447",
                                "monoisotopic_mz": "702.3796",
                                "intensity": "3727.52",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000196",
                                "peak_id": "32",
                                "monoisotopic_mass": "884.9634",
                                "monoisotopic_mz": "885.9706",
                                "intensity": "3162.22",
                                "charge": "1"
                            },
                            {
                                "spec_id": "1000196",
                                "peak_id": "33",
                                "monoisotopic_mass": "718.1752",
                                "monoisotopic_mz": "719.1824",
                                "intensity": "4470.46",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "10",
                    "proteoform_id": "47",
                    "sequence_name": "sp|P0A7Q8|RL36_SALTY",
                    "sequence_description": "50S ribosomal protein L36 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmJ PE=3 SV=1",
                    "proteoform_mass": "4568.4149",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "38",
                        "first_residue_position": "0",
                        "last_residue_position": "37",
                        "annotated_seq": ".MK(VRASVKKL(C)[Carbamidomethylation]RN(C)[Carbamidomethylation]KIVKRDGVIRVI(C)[Carbamidomethylation]SAE)[+35.9008]PKHKQRQG.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "K"
                            },
                            {
                                "position": "2",
                                "acid": "V"
                            },
                            {
                                "position": "3",
                                "acid": "R"
                            },
                            {
                                "position": "4",
                                "acid": "A"
                            },
                            {
                                "position": "5",
                                "acid": "S"
                            },
                            {
                                "position": "6",
                                "acid": "V"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "L"
                            },
                            {
                                "position": "10",
                                "acid": "C"
                            },
                            {
                                "position": "11",
                                "acid": "R"
                            },
                            {
                                "position": "12",
                                "acid": "N"
                            },
                            {
                                "position": "13",
                                "acid": "C"
                            },
                            {
                                "position": "14",
                                "acid": "K"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "V"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "R"
                            },
                            {
                                "position": "19",
                                "acid": "D"
                            },
                            {
                                "position": "20",
                                "acid": "G"
                            },
                            {
                                "position": "21",
                                "acid": "V"
                            },
                            {
                                "position": "22",
                                "acid": "I"
                            },
                            {
                                "position": "23",
                                "acid": "R"
                            },
                            {
                                "position": "24",
                                "acid": "V"
                            },
                            {
                                "position": "25",
                                "acid": "I"
                            },
                            {
                                "position": "26",
                                "acid": "C"
                            },
                            {
                                "position": "27",
                                "acid": "S"
                            },
                            {
                                "position": "28",
                                "acid": "A"
                            },
                            {
                                "position": "29",
                                "acid": "E"
                            },
                            {
                                "position": "30",
                                "acid": "P"
                            },
                            {
                                "position": "31",
                                "acid": "K"
                            },
                            {
                                "position": "32",
                                "acid": "H"
                            },
                            {
                                "position": "33",
                                "acid": "K"
                            },
                            {
                                "position": "34",
                                "acid": "Q"
                            },
                            {
                                "position": "35",
                                "acid": "R"
                            },
                            {
                                "position": "36",
                                "acid": "Q"
                            },
                            {
                                "position": "37",
                                "acid": "G"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "1",
                                        "ion_display_position": "37",
                                        "spec_id": "1000196",
                                        "peak_id": "3",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "2",
                                        "ion_display_position": "36",
                                        "spec_id": "1000196",
                                        "peak_id": "20",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "30",
                                            "ion_display_position": "8",
                                            "spec_id": "1000196",
                                            "peak_id": "10",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "30",
                                            "ion_display_position": "30",
                                            "spec_id": "1000196",
                                            "peak_id": "23",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "32",
                                            "ion_display_position": "6",
                                            "spec_id": "1000196",
                                            "peak_id": "4",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "32",
                                            "ion_display_position": "6",
                                            "spec_id": "1000196",
                                            "peak_id": "14",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "32",
                                            "ion_display_position": "32",
                                            "spec_id": "1000196",
                                            "peak_id": "9",
                                            "peak_charge": "5"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "33",
                                        "ion_display_position": "5",
                                        "spec_id": "1000196",
                                        "peak_id": "8",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "34",
                                        "ion_display_position": "4",
                                        "spec_id": "1000196",
                                        "peak_id": "15",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": [
                                {
                                    "left_pos": "10",
                                    "right_pos": "11",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "13",
                                    "right_pos": "14",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "26",
                                    "right_pos": "27",
                                    "anno": "C"
                                }
                            ]
                        },
                        "mass_shift": {
                            "id": "0",
                            "left_position": "2",
                            "right_position": "30",
                            "shift": "35.9008255680",
                            "anno": "+35.9008",
                            "shift_type": "unexpected"
                        }
                    }
                }
            }
        ]
    }
}
