prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "19",
        "sequence_name": "sp|P68684|RS21_SALTY",
        "sequence_description": "30S ribosomal protein S21 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpsU PE=3 SV=2",
        "proteoform_id": "41",
        "prsm_number": "2",
        "prsm": [
            {
                "prsm_id": "32",
                "p_value": "8.82e-07",
                "e_value": "8.82e-07",
                "fdr": "0",
                "matched_fragment_number": "11",
                "matched_peak_number": "14",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                        "ms1_ids": "284",
                        "ms1_scans": "553",
                        "ids": "268",
                        "scans": "554",
                        "precursor_mono_mass": "2554.4360",
                        "precursor_charge": "5",
                        "precursor_mz": "511.8945"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "268",
                                "peak_id": "0",
                                "monoisotopic_mass": "1227.6139",
                                "monoisotopic_mz": "1228.6212",
                                "intensity": "8919.78",
                                "charge": "1"
                            },
                            {
                                "spec_id": "268",
                                "peak_id": "1",
                                "monoisotopic_mass": "2245.2346",
                                "monoisotopic_mz": "749.4188",
                                "intensity": "18826.86",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-9.9882885366e-01",
                                        "theoretical_mass": "2245.2408",
                                        "ion_position": "3",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "Y00018",
                                        "ion_left_position": "3",
                                        "mass_error": "-0.0062",
                                        "ppm": "-2.75"
                                    }
                                }
                            },
                            {
                                "spec_id": "268",
                                "peak_id": "2",
                                "monoisotopic_mass": "2117.1421",
                                "monoisotopic_mz": "706.7213",
                                "intensity": "11938.51",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-9.9882885366e-01",
                                        "theoretical_mass": "2117.1458",
                                        "ion_position": "4",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "Y00017",
                                        "ion_left_position": "4",
                                        "mass_error": "-0.0037",
                                        "ppm": "-1.76"
                                    }
                                }
                            },
                            {
                                "spec_id": "268",
                                "peak_id": "3",
                                "monoisotopic_mass": "868.4688",
                                "monoisotopic_mz": "869.4761",
                                "intensity": "8780.14",
                                "charge": "1"
                            },
                            {
                                "spec_id": "268",
                                "peak_id": "4",
                                "monoisotopic_mass": "1489.8489",
                                "monoisotopic_mz": "745.9317",
                                "intensity": "7974.68",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-9.9882885366e-01",
                                        "theoretical_mass": "1489.8482",
                                        "ion_position": "9",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "Y00012",
                                        "ion_left_position": "9",
                                        "mass_error": "0.0007",
                                        "ppm": "0.45"
                                    }
                                }
                            },
                            {
                                "spec_id": "268",
                                "peak_id": "5",
                                "monoisotopic_mass": "2100.1129",
                                "monoisotopic_mz": "701.0449",
                                "intensity": "9655.50",
                                "charge": "3"
                            },
                            {
                                "spec_id": "268",
                                "peak_id": "6",
                                "monoisotopic_mass": "2440.3576",
                                "monoisotopic_mz": "611.0967",
                                "intensity": "6482.17",
                                "charge": "4"
                            },
                            {
                                "spec_id": "268",
                                "peak_id": "7",
                                "monoisotopic_mass": "2245.2331",
                                "monoisotopic_mz": "562.3156",
                                "intensity": "52231.62",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-9.9882885366e-01",
                                        "theoretical_mass": "2245.2408",
                                        "ion_position": "3",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "Y00018",
                                        "ion_left_position": "3",
                                        "mass_error": "-0.0076",
                                        "ppm": "-3.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "268",
                                "peak_id": "8",
                                "monoisotopic_mass": "1423.7319",
                                "monoisotopic_mz": "712.8732",
                                "intensity": "68731.30",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1423.7460",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0141",
                                        "ppm": "-9.87"
                                    }
                                }
                            },
                            {
                                "spec_id": "268",
                                "peak_id": "9",
                                "monoisotopic_mass": "2358.3162",
                                "monoisotopic_mz": "590.5863",
                                "intensity": "285924.99",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-9.9882885366e-01",
                                        "theoretical_mass": "2358.3249",
                                        "ion_position": "2",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "Y00019",
                                        "ion_left_position": "2",
                                        "mass_error": "-0.0087",
                                        "ppm": "-3.69"
                                    }
                                }
                            },
                            {
                                "spec_id": "268",
                                "peak_id": "10",
                                "monoisotopic_mass": "2457.3835",
                                "monoisotopic_mz": "615.3532",
                                "intensity": "65696.23",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-9.9882885366e-01",
                                        "theoretical_mass": "2457.3933",
                                        "ion_position": "1",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "Y00020",
                                        "ion_left_position": "1",
                                        "mass_error": "-0.0097",
                                        "ppm": "-3.96"
                                    }
                                }
                            },
                            {
                                "spec_id": "268",
                                "peak_id": "11",
                                "monoisotopic_mass": "2341.2922",
                                "monoisotopic_mz": "586.3303",
                                "intensity": "25404.58",
                                "charge": "4"
                            },
                            {
                                "spec_id": "268",
                                "peak_id": "12",
                                "monoisotopic_mass": "1472.8247",
                                "monoisotopic_mz": "737.4196",
                                "intensity": "3675.18",
                                "charge": "2"
                            },
                            {
                                "spec_id": "268",
                                "peak_id": "13",
                                "monoisotopic_mass": "1732.9308",
                                "monoisotopic_mz": "578.6509",
                                "intensity": "3287.30",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-9.9882885366e-01",
                                        "theoretical_mass": "1732.9337",
                                        "ion_position": "7",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "7",
                                        "mass_error": "-0.0029",
                                        "ppm": "-1.67"
                                    }
                                }
                            },
                            {
                                "spec_id": "268",
                                "peak_id": "14",
                                "monoisotopic_mass": "2117.1397",
                                "monoisotopic_mz": "530.2922",
                                "intensity": "11516.81",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-9.9882885366e-01",
                                        "theoretical_mass": "2117.1458",
                                        "ion_position": "4",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "Y00017",
                                        "ion_left_position": "4",
                                        "mass_error": "-0.0062",
                                        "ppm": "-2.92"
                                    }
                                }
                            },
                            {
                                "spec_id": "268",
                                "peak_id": "15",
                                "monoisotopic_mass": "1113.6775",
                                "monoisotopic_mz": "372.2331",
                                "intensity": "16590.33",
                                "charge": "3"
                            },
                            {
                                "spec_id": "268",
                                "peak_id": "16",
                                "monoisotopic_mass": "1245.7297",
                                "monoisotopic_mz": "623.8721",
                                "intensity": "3937.72",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-9.9882885366e-01",
                                        "theoretical_mass": "1245.7270",
                                        "ion_position": "11",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "11",
                                        "mass_error": "0.0027",
                                        "ppm": "2.17"
                                    }
                                }
                            },
                            {
                                "spec_id": "268",
                                "peak_id": "17",
                                "monoisotopic_mass": "1130.7048",
                                "monoisotopic_mz": "377.9089",
                                "intensity": "192280.29",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-9.9882885366e-01",
                                        "theoretical_mass": "1130.7001",
                                        "ion_position": "12",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0047",
                                        "ppm": "4.18"
                                    }
                                }
                            },
                            {
                                "spec_id": "268",
                                "peak_id": "18",
                                "monoisotopic_mass": "1114.5308",
                                "monoisotopic_mz": "1115.5381",
                                "intensity": "4431.06",
                                "charge": "1"
                            },
                            {
                                "spec_id": "268",
                                "peak_id": "19",
                                "monoisotopic_mass": "2082.0719",
                                "monoisotopic_mz": "695.0312",
                                "intensity": "2046.83",
                                "charge": "3"
                            },
                            {
                                "spec_id": "268",
                                "peak_id": "20",
                                "monoisotopic_mass": "2323.2881",
                                "monoisotopic_mz": "581.8293",
                                "intensity": "2931.35",
                                "charge": "4"
                            },
                            {
                                "spec_id": "268",
                                "peak_id": "21",
                                "monoisotopic_mass": "535.3188",
                                "monoisotopic_mz": "536.3261",
                                "intensity": "3610.26",
                                "charge": "1"
                            },
                            {
                                "spec_id": "268",
                                "peak_id": "22",
                                "monoisotopic_mass": "1130.7028",
                                "monoisotopic_mz": "566.3587",
                                "intensity": "6863.81",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-9.9882885366e-01",
                                        "theoretical_mass": "1130.7001",
                                        "ion_position": "12",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0028",
                                        "ppm": "2.46"
                                    }
                                }
                            },
                            {
                                "spec_id": "268",
                                "peak_id": "23",
                                "monoisotopic_mass": "1375.7690",
                                "monoisotopic_mz": "688.8918",
                                "intensity": "4966.11",
                                "charge": "2"
                            },
                            {
                                "spec_id": "268",
                                "peak_id": "24",
                                "monoisotopic_mass": "1405.7195",
                                "monoisotopic_mz": "703.8670",
                                "intensity": "1423.73",
                                "charge": "2"
                            },
                            {
                                "spec_id": "268",
                                "peak_id": "25",
                                "monoisotopic_mass": "1064.5903",
                                "monoisotopic_mz": "533.3024",
                                "intensity": "2253.52",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1064.5978",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "-0.0075",
                                        "ppm": "-7.08"
                                    }
                                }
                            },
                            {
                                "spec_id": "268",
                                "peak_id": "26",
                                "monoisotopic_mass": "943.5729",
                                "monoisotopic_mz": "472.7937",
                                "intensity": "4169.22",
                                "charge": "2"
                            },
                            {
                                "spec_id": "268",
                                "peak_id": "27",
                                "monoisotopic_mass": "1392.7967",
                                "monoisotopic_mz": "697.4056",
                                "intensity": "1716.91",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-9.9882885366e-01",
                                        "theoretical_mass": "1392.7954",
                                        "ion_position": "10",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0013",
                                        "ppm": "0.94"
                                    }
                                }
                            },
                            {
                                "spec_id": "268",
                                "peak_id": "28",
                                "monoisotopic_mass": "2228.2090",
                                "monoisotopic_mz": "558.0595",
                                "intensity": "7771.29",
                                "charge": "4"
                            },
                            {
                                "spec_id": "268",
                                "peak_id": "29",
                                "monoisotopic_mass": "1113.6790",
                                "monoisotopic_mz": "557.8468",
                                "intensity": "6239.22",
                                "charge": "2"
                            },
                            {
                                "spec_id": "268",
                                "peak_id": "30",
                                "monoisotopic_mass": "2227.2071",
                                "monoisotopic_mz": "743.4096",
                                "intensity": "8365.05",
                                "charge": "3"
                            },
                            {
                                "spec_id": "268",
                                "peak_id": "31",
                                "monoisotopic_mass": "1227.6141",
                                "monoisotopic_mz": "614.8143",
                                "intensity": "2458.71",
                                "charge": "2"
                            },
                            {
                                "spec_id": "268",
                                "peak_id": "32",
                                "monoisotopic_mass": "593.4209",
                                "monoisotopic_mz": "198.8142",
                                "intensity": "3209.40",
                                "charge": "3"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "19",
                    "proteoform_id": "41",
                    "sequence_name": "sp|P68684|RS21_SALTY",
                    "sequence_description": "30S ribosomal protein S21 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpsU PE=3 SV=2",
                    "proteoform_mass": "2554.4460",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "71",
                        "first_residue_position": "1",
                        "last_residue_position": "21",
                        "annotated_seq": "M.PVIKVRENEPFD(VALRRFKRS)[-0.9988].C",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "P"
                            },
                            {
                                "position": "2",
                                "acid": "V"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "V"
                            },
                            {
                                "position": "6",
                                "acid": "R"
                            },
                            {
                                "position": "7",
                                "acid": "E"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "E"
                            },
                            {
                                "position": "10",
                                "acid": "P"
                            },
                            {
                                "position": "11",
                                "acid": "F"
                            },
                            {
                                "position": "12",
                                "acid": "D"
                            },
                            {
                                "position": "13",
                                "acid": "V"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "R"
                            },
                            {
                                "position": "17",
                                "acid": "R"
                            },
                            {
                                "position": "18",
                                "acid": "F"
                            },
                            {
                                "position": "19",
                                "acid": "K"
                            },
                            {
                                "position": "20",
                                "acid": "R"
                            },
                            {
                                "position": "21",
                                "acid": "S"
                            },
                            {
                                "position": "22",
                                "acid": "C"
                            },
                            {
                                "position": "23",
                                "acid": "E"
                            },
                            {
                                "position": "24",
                                "acid": "K"
                            },
                            {
                                "position": "25",
                                "acid": "A"
                            },
                            {
                                "position": "26",
                                "acid": "G"
                            },
                            {
                                "position": "27",
                                "acid": "V"
                            },
                            {
                                "position": "28",
                                "acid": "L"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "R"
                            },
                            {
                                "position": "33",
                                "acid": "R"
                            },
                            {
                                "position": "34",
                                "acid": "R"
                            },
                            {
                                "position": "35",
                                "acid": "E"
                            },
                            {
                                "position": "36",
                                "acid": "F"
                            },
                            {
                                "position": "37",
                                "acid": "Y"
                            },
                            {
                                "position": "38",
                                "acid": "E"
                            },
                            {
                                "position": "39",
                                "acid": "K"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "T"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "E"
                            },
                            {
                                "position": "44",
                                "acid": "R"
                            },
                            {
                                "position": "45",
                                "acid": "K"
                            },
                            {
                                "position": "46",
                                "acid": "R"
                            },
                            {
                                "position": "47",
                                "acid": "A"
                            },
                            {
                                "position": "48",
                                "acid": "K"
                            },
                            {
                                "position": "49",
                                "acid": "A"
                            },
                            {
                                "position": "50",
                                "acid": "S"
                            },
                            {
                                "position": "51",
                                "acid": "A"
                            },
                            {
                                "position": "52",
                                "acid": "V"
                            },
                            {
                                "position": "53",
                                "acid": "K"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "H"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "K"
                            },
                            {
                                "position": "58",
                                "acid": "K"
                            },
                            {
                                "position": "59",
                                "acid": "L"
                            },
                            {
                                "position": "60",
                                "acid": "A"
                            },
                            {
                                "position": "61",
                                "acid": "R"
                            },
                            {
                                "position": "62",
                                "acid": "E"
                            },
                            {
                                "position": "63",
                                "acid": "N"
                            },
                            {
                                "position": "64",
                                "acid": "A"
                            },
                            {
                                "position": "65",
                                "acid": "R"
                            },
                            {
                                "position": "66",
                                "acid": "R"
                            },
                            {
                                "position": "67",
                                "acid": "T"
                            },
                            {
                                "position": "68",
                                "acid": "R"
                            },
                            {
                                "position": "69",
                                "acid": "L"
                            },
                            {
                                "position": "70",
                                "acid": "Y"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "1",
                                        "ion_display_position": "20",
                                        "spec_id": "268",
                                        "peak_id": "10",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "2",
                                        "ion_display_position": "19",
                                        "spec_id": "268",
                                        "peak_id": "9",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "3",
                                            "ion_display_position": "18",
                                            "spec_id": "268",
                                            "peak_id": "7",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "3",
                                            "ion_display_position": "18",
                                            "spec_id": "268",
                                            "peak_id": "1",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "4",
                                            "ion_display_position": "17",
                                            "spec_id": "268",
                                            "peak_id": "14",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "4",
                                            "ion_display_position": "17",
                                            "spec_id": "268",
                                            "peak_id": "2",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "7",
                                        "ion_display_position": "14",
                                        "spec_id": "268",
                                        "peak_id": "13",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "9",
                                            "ion_display_position": "9",
                                            "spec_id": "268",
                                            "peak_id": "25",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "9",
                                            "ion_display_position": "12",
                                            "spec_id": "268",
                                            "peak_id": "4",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "10",
                                        "ion_display_position": "11",
                                        "spec_id": "268",
                                        "peak_id": "27",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "11",
                                        "ion_display_position": "10",
                                        "spec_id": "268",
                                        "peak_id": "16",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "12",
                                            "ion_display_position": "9",
                                            "spec_id": "268",
                                            "peak_id": "22",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "12",
                                            "ion_display_position": "9",
                                            "spec_id": "268",
                                            "peak_id": "17",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "268",
                                            "peak_id": "8",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "13",
                            "right_position": "22",
                            "shift": "-9.9882885366e-01",
                            "anno": "-0.9988",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "146",
                "p_value": "0.03",
                "e_value": "0.03",
                "fdr": "7.41e-03",
                "matched_fragment_number": "7",
                "matched_peak_number": "9",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_2_ms2.msalign",
                        "ms1_ids": "1000272",
                        "ms1_scans": "540",
                        "ids": "1000267",
                        "scans": "541",
                        "precursor_mono_mass": "2554.4387",
                        "precursor_charge": "4",
                        "precursor_mz": "639.6169",
                        "feature_inte": "1.2828e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "1000267",
                                "peak_id": "0",
                                "monoisotopic_mass": "2358.3149",
                                "monoisotopic_mz": "787.1122",
                                "intensity": "45620.64",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-418.1644139151",
                                        "theoretical_mass": "2358.3275",
                                        "ion_position": "2",
                                        "ion_display_position": "22",
                                        "ion_sort_name": "Y00022",
                                        "ion_left_position": "2",
                                        "mass_error": "-0.0126",
                                        "ppm": "-5.34"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000267",
                                "peak_id": "1",
                                "monoisotopic_mass": "2457.3830",
                                "monoisotopic_mz": "820.1349",
                                "intensity": "7573.00",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-418.1644139151",
                                        "theoretical_mass": "2457.3959",
                                        "ion_position": "1",
                                        "ion_display_position": "23",
                                        "ion_sort_name": "Y00023",
                                        "ion_left_position": "1",
                                        "mass_error": "-0.0129",
                                        "ppm": "-5.24"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000267",
                                "peak_id": "2",
                                "monoisotopic_mass": "2245.2332",
                                "monoisotopic_mz": "749.4183",
                                "intensity": "12490.25",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-418.1644139151",
                                        "theoretical_mass": "2245.2434",
                                        "ion_position": "3",
                                        "ion_display_position": "21",
                                        "ion_sort_name": "Y00021",
                                        "ion_left_position": "3",
                                        "mass_error": "-0.0103",
                                        "ppm": "-4.57"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000267",
                                "peak_id": "3",
                                "monoisotopic_mass": "2440.3573",
                                "monoisotopic_mz": "814.4597",
                                "intensity": "4916.30",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000267",
                                "peak_id": "4",
                                "monoisotopic_mass": "2316.2955",
                                "monoisotopic_mz": "773.1058",
                                "intensity": "5574.69",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000267",
                                "peak_id": "5",
                                "monoisotopic_mass": "1489.8484",
                                "monoisotopic_mz": "745.9315",
                                "intensity": "7333.70",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-418.1644139151",
                                        "theoretical_mass": "1489.8508",
                                        "ion_position": "9",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "9",
                                        "mass_error": "-0.0024",
                                        "ppm": "-1.64"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000267",
                                "peak_id": "6",
                                "monoisotopic_mass": "2227.2200",
                                "monoisotopic_mz": "743.4139",
                                "intensity": "5977.58",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000267",
                                "peak_id": "7",
                                "monoisotopic_mass": "1789.0513",
                                "monoisotopic_mz": "597.3577",
                                "intensity": "2769.32",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000267",
                                "peak_id": "8",
                                "monoisotopic_mass": "1489.8479",
                                "monoisotopic_mz": "497.6232",
                                "intensity": "6551.84",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-418.1644139151",
                                        "theoretical_mass": "1489.8508",
                                        "ion_position": "9",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "9",
                                        "mass_error": "-0.0029",
                                        "ppm": "-1.98"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000267",
                                "peak_id": "9",
                                "monoisotopic_mass": "1227.6095",
                                "monoisotopic_mz": "1228.6168",
                                "intensity": "2821.99",
                                "charge": "1"
                            },
                            {
                                "spec_id": "1000267",
                                "peak_id": "10",
                                "monoisotopic_mass": "2099.1046",
                                "monoisotopic_mz": "700.7088",
                                "intensity": "2162.85",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000267",
                                "peak_id": "11",
                                "monoisotopic_mass": "1423.7320",
                                "monoisotopic_mz": "712.8733",
                                "intensity": "3123.01",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1423.7460",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0139",
                                        "ppm": "-9.79"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000267",
                                "peak_id": "12",
                                "monoisotopic_mass": "1130.7032",
                                "monoisotopic_mz": "566.3589",
                                "intensity": "10911.82",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-418.1644139151",
                                        "theoretical_mass": "1130.7027",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "Y00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0005",
                                        "ppm": "0.47"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000267",
                                "peak_id": "13",
                                "monoisotopic_mass": "868.4676",
                                "monoisotopic_mz": "869.4749",
                                "intensity": "2784.89",
                                "charge": "1"
                            },
                            {
                                "spec_id": "1000267",
                                "peak_id": "14",
                                "monoisotopic_mass": "2340.2957",
                                "monoisotopic_mz": "781.1058",
                                "intensity": "22143.47",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000267",
                                "peak_id": "15",
                                "monoisotopic_mass": "1807.0651",
                                "monoisotopic_mz": "603.3623",
                                "intensity": "4674.59",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000267",
                                "peak_id": "16",
                                "monoisotopic_mass": "1113.6749",
                                "monoisotopic_mz": "557.8447",
                                "intensity": "3998.28",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000267",
                                "peak_id": "17",
                                "monoisotopic_mass": "1130.7038",
                                "monoisotopic_mz": "377.9085",
                                "intensity": "4299.40",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-418.1644139151",
                                        "theoretical_mass": "1130.7027",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "Y00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0011",
                                        "ppm": "0.98"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000267",
                                "peak_id": "18",
                                "monoisotopic_mass": "1064.5874",
                                "monoisotopic_mz": "1065.5947",
                                "intensity": "2141.51",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1064.5978",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "-0.0104",
                                        "ppm": "-9.76"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000267",
                                "peak_id": "19",
                                "monoisotopic_mass": "1471.8360",
                                "monoisotopic_mz": "736.9253",
                                "intensity": "2222.27",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000267",
                                "peak_id": "20",
                                "monoisotopic_mass": "1088.6821",
                                "monoisotopic_mz": "545.3483",
                                "intensity": "1794.80",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000267",
                                "peak_id": "21",
                                "monoisotopic_mass": "1114.5289",
                                "monoisotopic_mz": "1115.5361",
                                "intensity": "897.97",
                                "charge": "1"
                            },
                            {
                                "spec_id": "1000267",
                                "peak_id": "22",
                                "monoisotopic_mass": "724.3943",
                                "monoisotopic_mz": "725.4016",
                                "intensity": "985.91",
                                "charge": "1"
                            },
                            {
                                "spec_id": "1000267",
                                "peak_id": "23",
                                "monoisotopic_mass": "2357.3119",
                                "monoisotopic_mz": "590.3352",
                                "intensity": "3359.32",
                                "charge": "4"
                            },
                            {
                                "spec_id": "1000267",
                                "peak_id": "24",
                                "monoisotopic_mass": "2297.2810",
                                "monoisotopic_mz": "766.7676",
                                "intensity": "2124.60",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000267",
                                "peak_id": "25",
                                "monoisotopic_mass": "2116.1326",
                                "monoisotopic_mz": "706.3848",
                                "intensity": "4765.49",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000267",
                                "peak_id": "26",
                                "monoisotopic_mass": "1445.3764",
                                "monoisotopic_mz": "723.6955",
                                "intensity": "2139.55",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "19",
                    "proteoform_id": "41",
                    "sequence_name": "sp|P68684|RS21_SALTY",
                    "sequence_description": "30S ribosomal protein S21 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpsU PE=3 SV=2",
                    "proteoform_mass": "2554.4486",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "71",
                        "first_residue_position": "1",
                        "last_residue_position": "24",
                        "annotated_seq": "M.PVIKVRENEPFD(VALRRFKRS(C)[Carbamidomethylation]EK)[-418.1644].A",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "P"
                            },
                            {
                                "position": "2",
                                "acid": "V"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "V"
                            },
                            {
                                "position": "6",
                                "acid": "R"
                            },
                            {
                                "position": "7",
                                "acid": "E"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "E"
                            },
                            {
                                "position": "10",
                                "acid": "P"
                            },
                            {
                                "position": "11",
                                "acid": "F"
                            },
                            {
                                "position": "12",
                                "acid": "D"
                            },
                            {
                                "position": "13",
                                "acid": "V"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "R"
                            },
                            {
                                "position": "17",
                                "acid": "R"
                            },
                            {
                                "position": "18",
                                "acid": "F"
                            },
                            {
                                "position": "19",
                                "acid": "K"
                            },
                            {
                                "position": "20",
                                "acid": "R"
                            },
                            {
                                "position": "21",
                                "acid": "S"
                            },
                            {
                                "position": "22",
                                "acid": "C"
                            },
                            {
                                "position": "23",
                                "acid": "E"
                            },
                            {
                                "position": "24",
                                "acid": "K"
                            },
                            {
                                "position": "25",
                                "acid": "A"
                            },
                            {
                                "position": "26",
                                "acid": "G"
                            },
                            {
                                "position": "27",
                                "acid": "V"
                            },
                            {
                                "position": "28",
                                "acid": "L"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "R"
                            },
                            {
                                "position": "33",
                                "acid": "R"
                            },
                            {
                                "position": "34",
                                "acid": "R"
                            },
                            {
                                "position": "35",
                                "acid": "E"
                            },
                            {
                                "position": "36",
                                "acid": "F"
                            },
                            {
                                "position": "37",
                                "acid": "Y"
                            },
                            {
                                "position": "38",
                                "acid": "E"
                            },
                            {
                                "position": "39",
                                "acid": "K"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "T"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "E"
                            },
                            {
                                "position": "44",
                                "acid": "R"
                            },
                            {
                                "position": "45",
                                "acid": "K"
                            },
                            {
                                "position": "46",
                                "acid": "R"
                            },
                            {
                                "position": "47",
                                "acid": "A"
                            },
                            {
                                "position": "48",
                                "acid": "K"
                            },
                            {
                                "position": "49",
                                "acid": "A"
                            },
                            {
                                "position": "50",
                                "acid": "S"
                            },
                            {
                                "position": "51",
                                "acid": "A"
                            },
                            {
                                "position": "52",
                                "acid": "V"
                            },
                            {
                                "position": "53",
                                "acid": "K"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "H"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "K"
                            },
                            {
                                "position": "58",
                                "acid": "K"
                            },
                            {
                                "position": "59",
                                "acid": "L"
                            },
                            {
                                "position": "60",
                                "acid": "A"
                            },
                            {
                                "position": "61",
                                "acid": "R"
                            },
                            {
                                "position": "62",
                                "acid": "E"
                            },
                            {
                                "position": "63",
                                "acid": "N"
                            },
                            {
                                "position": "64",
                                "acid": "A"
                            },
                            {
                                "position": "65",
                                "acid": "R"
                            },
                            {
                                "position": "66",
                                "acid": "R"
                            },
                            {
                                "position": "67",
                                "acid": "T"
                            },
                            {
                                "position": "68",
                                "acid": "R"
                            },
                            {
                                "position": "69",
                                "acid": "L"
                            },
                            {
                                "position": "70",
                                "acid": "Y"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "1",
                                        "ion_display_position": "23",
                                        "spec_id": "1000267",
                                        "peak_id": "1",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "2",
                                        "ion_display_position": "22",
                                        "spec_id": "1000267",
                                        "peak_id": "0",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "3",
                                        "ion_display_position": "21",
                                        "spec_id": "1000267",
                                        "peak_id": "2",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "9",
                                            "ion_display_position": "9",
                                            "spec_id": "1000267",
                                            "peak_id": "18",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "9",
                                            "ion_display_position": "15",
                                            "spec_id": "1000267",
                                            "peak_id": "8",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "9",
                                            "ion_display_position": "15",
                                            "spec_id": "1000267",
                                            "peak_id": "5",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "1000267",
                                            "peak_id": "12",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "1000267",
                                            "peak_id": "17",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "1000267",
                                            "peak_id": "11",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": {
                                "left_pos": "22",
                                "right_pos": "23",
                                "anno": "C"
                            }
                        },
                        "mass_shift": {
                            "id": "0",
                            "left_position": "13",
                            "right_position": "25",
                            "shift": "-418.1644139151",
                            "anno": "-418.1644",
                            "shift_type": "unexpected"
                        }
                    }
                }
            }
        ]
    }
}
