prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "37",
        "sequence_name": "sp|P66431|RS15_SALTY",
        "sequence_description": "30S ribosomal protein S15 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpsO PE=3 SV=2",
        "proteoform_id": "60",
        "prsm_number": "3",
        "prsm": [
            {
                "prsm_id": "95",
                "p_value": "1.21e-04",
                "e_value": "1.21e-04",
                "fdr": "0",
                "matched_fragment_number": "9",
                "matched_peak_number": "11",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                        "ms1_ids": "500",
                        "ms1_scans": "985",
                        "ids": "484",
                        "scans": "986",
                        "precursor_mono_mass": "10158.3107",
                        "precursor_charge": "17",
                        "precursor_mz": "598.5550"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "484",
                                "peak_id": "0",
                                "monoisotopic_mass": "6996.8633",
                                "monoisotopic_mz": "637.0858",
                                "intensity": "1366750.30",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6996.9291",
                                        "ion_position": "30",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0658",
                                        "ppm": "-9.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "1",
                                "monoisotopic_mass": "7736.9359",
                                "monoisotopic_mz": "645.7519",
                                "intensity": "774624.75",
                                "charge": "12"
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "2",
                                "monoisotopic_mass": "7109.9362",
                                "monoisotopic_mz": "647.3651",
                                "intensity": "1005892.23",
                                "charge": "11"
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "3",
                                "monoisotopic_mass": "2179.7208",
                                "monoisotopic_mz": "199.1637",
                                "intensity": "351948.79",
                                "charge": "11"
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "4",
                                "monoisotopic_mass": "7208.9181",
                                "monoisotopic_mz": "656.3635",
                                "intensity": "537484.17",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "98.9042319721",
                                        "theoretical_mass": "7208.9174",
                                        "ion_position": "29",
                                        "ion_display_position": "59",
                                        "ion_sort_name": "Y00059",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0007",
                                        "ppm": "0.10"
                                    }
                                }
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "5",
                                "monoisotopic_mass": "6883.7778",
                                "monoisotopic_mz": "689.3851",
                                "intensity": "961008.21",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6883.8451",
                                        "ion_position": "31",
                                        "ion_display_position": "57",
                                        "ion_sort_name": "Y00057",
                                        "ion_left_position": "31",
                                        "mass_error": "-0.0673",
                                        "ppm": "-9.77"
                                    }
                                }
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "6",
                                "monoisotopic_mass": "6979.8625",
                                "monoisotopic_mz": "635.5402",
                                "intensity": "396225.07",
                                "charge": "11"
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "7",
                                "monoisotopic_mass": "6866.7902",
                                "monoisotopic_mz": "625.2609",
                                "intensity": "230034.08",
                                "charge": "11"
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "8",
                                "monoisotopic_mass": "9921.1817",
                                "monoisotopic_mz": "621.0811",
                                "intensity": "249567.02",
                                "charge": "16"
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "9",
                                "monoisotopic_mass": "6883.7837",
                                "monoisotopic_mz": "626.8058",
                                "intensity": "1448436.41",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6883.8451",
                                        "ion_position": "31",
                                        "ion_display_position": "57",
                                        "ion_sort_name": "Y00057",
                                        "ion_left_position": "31",
                                        "mass_error": "-0.0613",
                                        "ppm": "-8.91"
                                    }
                                }
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "10",
                                "monoisotopic_mass": "6694.6769",
                                "monoisotopic_mz": "670.4750",
                                "intensity": "586855.72",
                                "charge": "10"
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "11",
                                "monoisotopic_mass": "6782.7187",
                                "monoisotopic_mz": "679.2791",
                                "intensity": "514884.74",
                                "charge": "10"
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "12",
                                "monoisotopic_mass": "2535.1530",
                                "monoisotopic_mz": "846.0583",
                                "intensity": "314404.21",
                                "charge": "3"
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "13",
                                "monoisotopic_mass": "6782.7400",
                                "monoisotopic_mz": "617.6200",
                                "intensity": "365203.92",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6782.7974",
                                        "ion_position": "32",
                                        "ion_display_position": "56",
                                        "ion_sort_name": "Y00056",
                                        "ion_left_position": "32",
                                        "mass_error": "-0.0574",
                                        "ppm": "-8.46"
                                    }
                                }
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "14",
                                "monoisotopic_mass": "6997.8725",
                                "monoisotopic_mz": "700.7945",
                                "intensity": "446113.93",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6996.9291",
                                        "ion_position": "30",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0590",
                                        "ppm": "-8.43"
                                    }
                                }
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "15",
                                "monoisotopic_mass": "2589.5122",
                                "monoisotopic_mz": "518.9097",
                                "intensity": "104920.30",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2589.5343",
                                        "ion_position": "67",
                                        "ion_display_position": "21",
                                        "ion_sort_name": "Y00021",
                                        "ion_left_position": "67",
                                        "mass_error": "-0.0222",
                                        "ppm": "-8.55"
                                    }
                                }
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "16",
                                "monoisotopic_mass": "2744.2659",
                                "monoisotopic_mz": "687.0737",
                                "intensity": "187775.76",
                                "charge": "4"
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "17",
                                "monoisotopic_mass": "7278.9356",
                                "monoisotopic_mz": "662.7287",
                                "intensity": "246834.24",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "98.9042319721",
                                        "theoretical_mass": "7279.9545",
                                        "ion_position": "28",
                                        "ion_display_position": "60",
                                        "ion_sort_name": "Y00060",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0166",
                                        "ppm": "-2.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "18",
                                "monoisotopic_mass": "2175.0222",
                                "monoisotopic_mz": "544.7628",
                                "intensity": "128700.83",
                                "charge": "4"
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "19",
                                "monoisotopic_mass": "7967.3123",
                                "monoisotopic_mz": "613.8775",
                                "intensity": "168315.94",
                                "charge": "13",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "98.9042319721",
                                        "theoretical_mass": "7966.2781",
                                        "ion_position": "21",
                                        "ion_display_position": "67",
                                        "ion_sort_name": "Y00067",
                                        "ion_left_position": "21",
                                        "mass_error": "0.0319",
                                        "ppm": "4.01"
                                    }
                                }
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "20",
                                "monoisotopic_mass": "7108.9268",
                                "monoisotopic_mz": "711.9000",
                                "intensity": "149796.26",
                                "charge": "10"
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "21",
                                "monoisotopic_mass": "7378.0104",
                                "monoisotopic_mz": "671.7355",
                                "intensity": "339767.37",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "98.9042319721",
                                        "theoretical_mass": "7379.0230",
                                        "ion_position": "27",
                                        "ion_display_position": "61",
                                        "ion_sort_name": "Y00061",
                                        "ion_left_position": "27",
                                        "mass_error": "-0.0102",
                                        "ppm": "-1.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "22",
                                "monoisotopic_mass": "2335.0347",
                                "monoisotopic_mz": "779.3522",
                                "intensity": "292487.69",
                                "charge": "3"
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "23",
                                "monoisotopic_mass": "2193.0288",
                                "monoisotopic_mz": "549.2645",
                                "intensity": "289437.06",
                                "charge": "4"
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "24",
                                "monoisotopic_mass": "709.9850",
                                "monoisotopic_mz": "710.9923",
                                "intensity": "78944.12",
                                "charge": "1"
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "25",
                                "monoisotopic_mass": "6085.6903",
                                "monoisotopic_mz": "609.5763",
                                "intensity": "123860.29",
                                "charge": "10"
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "26",
                                "monoisotopic_mass": "1463.6908",
                                "monoisotopic_mz": "732.8527",
                                "intensity": "53411.62",
                                "charge": "2"
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "27",
                                "monoisotopic_mass": "674.7384",
                                "monoisotopic_mz": "675.7457",
                                "intensity": "94884.80",
                                "charge": "1"
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "28",
                                "monoisotopic_mass": "691.0803",
                                "monoisotopic_mz": "692.0876",
                                "intensity": "81825.46",
                                "charge": "1"
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "29",
                                "monoisotopic_mass": "3917.0945",
                                "monoisotopic_mz": "653.8564",
                                "intensity": "335620.12",
                                "charge": "6"
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "30",
                                "monoisotopic_mass": "6510.4263",
                                "monoisotopic_mz": "652.0499",
                                "intensity": "174492.16",
                                "charge": "10"
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "31",
                                "monoisotopic_mass": "3690.0089",
                                "monoisotopic_mz": "616.0088",
                                "intensity": "273351.84",
                                "charge": "6"
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "32",
                                "monoisotopic_mass": "793.3908",
                                "monoisotopic_mz": "199.3550",
                                "intensity": "80628.53",
                                "charge": "4"
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "33",
                                "monoisotopic_mass": "1422.9911",
                                "monoisotopic_mz": "712.5028",
                                "intensity": "40372.18",
                                "charge": "2"
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "34",
                                "monoisotopic_mass": "1259.0724",
                                "monoisotopic_mz": "630.5435",
                                "intensity": "107765.49",
                                "charge": "2"
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "35",
                                "monoisotopic_mass": "4929.8357",
                                "monoisotopic_mz": "617.2367",
                                "intensity": "233572.37",
                                "charge": "8"
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "36",
                                "monoisotopic_mass": "6583.6363",
                                "monoisotopic_mz": "659.3709",
                                "intensity": "213671.78",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6583.7017",
                                        "ion_position": "34",
                                        "ion_display_position": "54",
                                        "ion_sort_name": "Y00054",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0654",
                                        "ppm": "-9.94"
                                    }
                                }
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "37",
                                "monoisotopic_mass": "3355.8434",
                                "monoisotopic_mz": "672.1760",
                                "intensity": "204658.85",
                                "charge": "5"
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "38",
                                "monoisotopic_mass": "1130.7923",
                                "monoisotopic_mz": "566.4034",
                                "intensity": "63158.68",
                                "charge": "2"
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "39",
                                "monoisotopic_mass": "653.2712",
                                "monoisotopic_mz": "654.2785",
                                "intensity": "132180.11",
                                "charge": "1"
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "40",
                                "monoisotopic_mass": "4385.3281",
                                "monoisotopic_mz": "627.4827",
                                "intensity": "188926.62",
                                "charge": "7"
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "41",
                                "monoisotopic_mass": "635.0685",
                                "monoisotopic_mz": "636.0758",
                                "intensity": "81927.16",
                                "charge": "1"
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "42",
                                "monoisotopic_mass": "5927.5439",
                                "monoisotopic_mz": "659.6233",
                                "intensity": "125177.44",
                                "charge": "9"
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "43",
                                "monoisotopic_mass": "6825.1792",
                                "monoisotopic_mz": "683.5252",
                                "intensity": "75723.64",
                                "charge": "10"
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "44",
                                "monoisotopic_mass": "3895.9239",
                                "monoisotopic_mz": "650.3279",
                                "intensity": "64268.03",
                                "charge": "6"
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "45",
                                "monoisotopic_mass": "4542.1313",
                                "monoisotopic_mz": "649.8832",
                                "intensity": "98628.46",
                                "charge": "7"
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "46",
                                "monoisotopic_mass": "1220.6590",
                                "monoisotopic_mz": "611.3368",
                                "intensity": "74415.98",
                                "charge": "2"
                            },
                            {
                                "spec_id": "484",
                                "peak_id": "47",
                                "monoisotopic_mass": "6341.3751",
                                "monoisotopic_mz": "635.1448",
                                "intensity": "86249.82",
                                "charge": "10"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "37",
                    "proteoform_id": "60",
                    "sequence_name": "sp|P66431|RS15_SALTY",
                    "sequence_description": "30S ribosomal protein S15 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpsO PE=3 SV=2",
                    "proteoform_mass": "10159.3330",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "89",
                        "first_residue_position": "1",
                        "last_residue_position": "88",
                        "annotated_seq": "M.SLSTEATAKIVSEFGRDANDTGSTDVQVA(L)[+98.9042]LTAQINHLQGHFAEHKKDHHSRRGLLRMVSQRRKLLDYLKRKDVARYTALIERLGLRR.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "L"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "T"
                            },
                            {
                                "position": "5",
                                "acid": "E"
                            },
                            {
                                "position": "6",
                                "acid": "A"
                            },
                            {
                                "position": "7",
                                "acid": "T"
                            },
                            {
                                "position": "8",
                                "acid": "A"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "V"
                            },
                            {
                                "position": "12",
                                "acid": "S"
                            },
                            {
                                "position": "13",
                                "acid": "E"
                            },
                            {
                                "position": "14",
                                "acid": "F"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "R"
                            },
                            {
                                "position": "17",
                                "acid": "D"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "N"
                            },
                            {
                                "position": "20",
                                "acid": "D"
                            },
                            {
                                "position": "21",
                                "acid": "T"
                            },
                            {
                                "position": "22",
                                "acid": "G"
                            },
                            {
                                "position": "23",
                                "acid": "S"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "V"
                            },
                            {
                                "position": "27",
                                "acid": "Q"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "L"
                            },
                            {
                                "position": "31",
                                "acid": "L"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "A"
                            },
                            {
                                "position": "34",
                                "acid": "Q"
                            },
                            {
                                "position": "35",
                                "acid": "I"
                            },
                            {
                                "position": "36",
                                "acid": "N"
                            },
                            {
                                "position": "37",
                                "acid": "H"
                            },
                            {
                                "position": "38",
                                "acid": "L"
                            },
                            {
                                "position": "39",
                                "acid": "Q"
                            },
                            {
                                "position": "40",
                                "acid": "G"
                            },
                            {
                                "position": "41",
                                "acid": "H"
                            },
                            {
                                "position": "42",
                                "acid": "F"
                            },
                            {
                                "position": "43",
                                "acid": "A"
                            },
                            {
                                "position": "44",
                                "acid": "E"
                            },
                            {
                                "position": "45",
                                "acid": "H"
                            },
                            {
                                "position": "46",
                                "acid": "K"
                            },
                            {
                                "position": "47",
                                "acid": "K"
                            },
                            {
                                "position": "48",
                                "acid": "D"
                            },
                            {
                                "position": "49",
                                "acid": "H"
                            },
                            {
                                "position": "50",
                                "acid": "H"
                            },
                            {
                                "position": "51",
                                "acid": "S"
                            },
                            {
                                "position": "52",
                                "acid": "R"
                            },
                            {
                                "position": "53",
                                "acid": "R"
                            },
                            {
                                "position": "54",
                                "acid": "G"
                            },
                            {
                                "position": "55",
                                "acid": "L"
                            },
                            {
                                "position": "56",
                                "acid": "L"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "M"
                            },
                            {
                                "position": "59",
                                "acid": "V"
                            },
                            {
                                "position": "60",
                                "acid": "S"
                            },
                            {
                                "position": "61",
                                "acid": "Q"
                            },
                            {
                                "position": "62",
                                "acid": "R"
                            },
                            {
                                "position": "63",
                                "acid": "R"
                            },
                            {
                                "position": "64",
                                "acid": "K"
                            },
                            {
                                "position": "65",
                                "acid": "L"
                            },
                            {
                                "position": "66",
                                "acid": "L"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "Y"
                            },
                            {
                                "position": "69",
                                "acid": "L"
                            },
                            {
                                "position": "70",
                                "acid": "K"
                            },
                            {
                                "position": "71",
                                "acid": "R"
                            },
                            {
                                "position": "72",
                                "acid": "K"
                            },
                            {
                                "position": "73",
                                "acid": "D"
                            },
                            {
                                "position": "74",
                                "acid": "V"
                            },
                            {
                                "position": "75",
                                "acid": "A"
                            },
                            {
                                "position": "76",
                                "acid": "R"
                            },
                            {
                                "position": "77",
                                "acid": "Y"
                            },
                            {
                                "position": "78",
                                "acid": "T"
                            },
                            {
                                "position": "79",
                                "acid": "A"
                            },
                            {
                                "position": "80",
                                "acid": "L"
                            },
                            {
                                "position": "81",
                                "acid": "I"
                            },
                            {
                                "position": "82",
                                "acid": "E"
                            },
                            {
                                "position": "83",
                                "acid": "R"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "G"
                            },
                            {
                                "position": "86",
                                "acid": "L"
                            },
                            {
                                "position": "87",
                                "acid": "R"
                            },
                            {
                                "position": "88",
                                "acid": "R"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "21",
                                        "ion_display_position": "67",
                                        "spec_id": "484",
                                        "peak_id": "19",
                                        "peak_charge": "13"
                                    }
                                }
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "27",
                                        "ion_display_position": "61",
                                        "spec_id": "484",
                                        "peak_id": "21",
                                        "peak_charge": "11"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "28",
                                        "ion_display_position": "60",
                                        "spec_id": "484",
                                        "peak_id": "17",
                                        "peak_charge": "11"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "29",
                                        "ion_display_position": "59",
                                        "spec_id": "484",
                                        "peak_id": "4",
                                        "peak_charge": "11"
                                    }
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "30",
                                            "ion_display_position": "58",
                                            "spec_id": "484",
                                            "peak_id": "0",
                                            "peak_charge": "11"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "30",
                                            "ion_display_position": "58",
                                            "spec_id": "484",
                                            "peak_id": "14",
                                            "peak_charge": "10"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "31",
                                            "ion_display_position": "57",
                                            "spec_id": "484",
                                            "peak_id": "5",
                                            "peak_charge": "10"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "31",
                                            "ion_display_position": "57",
                                            "spec_id": "484",
                                            "peak_id": "9",
                                            "peak_charge": "11"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "32",
                                        "ion_display_position": "56",
                                        "spec_id": "484",
                                        "peak_id": "13",
                                        "peak_charge": "11"
                                    }
                                }
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "34",
                                        "ion_display_position": "54",
                                        "spec_id": "484",
                                        "peak_id": "36",
                                        "peak_charge": "10"
                                    }
                                }
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "67",
                                        "ion_display_position": "21",
                                        "spec_id": "484",
                                        "peak_id": "15",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "30",
                            "right_position": "31",
                            "shift": "98.9042319721",
                            "anno": "+98.9042",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "213",
                "p_value": "0.02",
                "e_value": "0.02",
                "fdr": "7.52e-03",
                "matched_fragment_number": "7",
                "matched_peak_number": "9",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_2_ms2.msalign",
                        "ms1_ids": "1000482",
                        "ms1_scans": "960",
                        "ids": "1000477",
                        "scans": "961",
                        "precursor_mono_mass": "10157.3065",
                        "precursor_charge": "15",
                        "precursor_mz": "678.1610"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "1000477",
                                "peak_id": "0",
                                "monoisotopic_mass": "7831.2729",
                                "monoisotopic_mz": "712.9412",
                                "intensity": "637294.65",
                                "charge": "11"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "1",
                                "monoisotopic_mass": "6883.7760",
                                "monoisotopic_mz": "689.3849",
                                "intensity": "1015403.91",
                                "charge": "10"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "2",
                                "monoisotopic_mass": "6996.8696",
                                "monoisotopic_mz": "778.4372",
                                "intensity": "600298.41",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6996.9291",
                                        "ion_position": "30",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0596",
                                        "ppm": "-8.51"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "3",
                                "monoisotopic_mass": "7109.9388",
                                "monoisotopic_mz": "712.0012",
                                "intensity": "1287468.48",
                                "charge": "10"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "4",
                                "monoisotopic_mass": "6883.7774",
                                "monoisotopic_mz": "765.8714",
                                "intensity": "1084757.08",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6883.8451",
                                        "ion_position": "31",
                                        "ion_display_position": "57",
                                        "ion_sort_name": "Y00057",
                                        "ion_left_position": "31",
                                        "mass_error": "-0.0676",
                                        "ppm": "-9.82"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "5",
                                "monoisotopic_mass": "7929.2376",
                                "monoisotopic_mz": "721.8471",
                                "intensity": "1023613.66",
                                "charge": "11"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "6",
                                "monoisotopic_mass": "6996.8682",
                                "monoisotopic_mz": "700.6941",
                                "intensity": "1128621.83",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6996.9291",
                                        "ion_position": "30",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0610",
                                        "ppm": "-8.72"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "7",
                                "monoisotopic_mass": "7180.9806",
                                "monoisotopic_mz": "719.1053",
                                "intensity": "727385.04",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7181.0503",
                                        "ion_position": "28",
                                        "ion_display_position": "60",
                                        "ion_sort_name": "Y00060",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0697",
                                        "ppm": "-9.70"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "8",
                                "monoisotopic_mass": "2535.1446",
                                "monoisotopic_mz": "846.0555",
                                "intensity": "200789.85",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "9",
                                "monoisotopic_mass": "2562.1537",
                                "monoisotopic_mz": "855.0585",
                                "intensity": "165446.61",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "10",
                                "monoisotopic_mass": "7109.9507",
                                "monoisotopic_mz": "791.0018",
                                "intensity": "328843.61",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7110.0132",
                                        "ion_position": "29",
                                        "ion_display_position": "59",
                                        "ion_sort_name": "Y00059",
                                        "ion_left_position": "29",
                                        "mass_error": "-0.0625",
                                        "ppm": "-8.79"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "11",
                                "monoisotopic_mass": "8129.6022",
                                "monoisotopic_mz": "740.0620",
                                "intensity": "217275.53",
                                "charge": "11"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "12",
                                "monoisotopic_mass": "7091.9516",
                                "monoisotopic_mz": "710.2024",
                                "intensity": "647763.01",
                                "charge": "10"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "13",
                                "monoisotopic_mass": "2193.0366",
                                "monoisotopic_mz": "549.2664",
                                "intensity": "114813.03",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2193.0550",
                                        "ion_position": "21",
                                        "ion_display_position": "21",
                                        "ion_sort_name": "B00021",
                                        "ion_left_position": "21",
                                        "mass_error": "-0.0183",
                                        "ppm": "-8.36"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "14",
                                "monoisotopic_mass": "7279.0409",
                                "monoisotopic_mz": "728.9114",
                                "intensity": "320708.59",
                                "charge": "10"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "15",
                                "monoisotopic_mass": "8266.5625",
                                "monoisotopic_mz": "636.8967",
                                "intensity": "131976.83",
                                "charge": "13"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "16",
                                "monoisotopic_mass": "6781.7258",
                                "monoisotopic_mz": "754.5324",
                                "intensity": "368692.51",
                                "charge": "9"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "17",
                                "monoisotopic_mass": "2193.0351",
                                "monoisotopic_mz": "732.0190",
                                "intensity": "93008.38",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2193.0550",
                                        "ion_position": "21",
                                        "ion_display_position": "21",
                                        "ion_sort_name": "B00021",
                                        "ion_left_position": "21",
                                        "mass_error": "-0.0199",
                                        "ppm": "-9.05"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "18",
                                "monoisotopic_mass": "2179.3433",
                                "monoisotopic_mz": "199.1294",
                                "intensity": "66117.46",
                                "charge": "11"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "19",
                                "monoisotopic_mass": "6711.6886",
                                "monoisotopic_mz": "746.7504",
                                "intensity": "290676.01",
                                "charge": "9"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "20",
                                "monoisotopic_mass": "7907.2283",
                                "monoisotopic_mz": "719.8462",
                                "intensity": "202110.90",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "97.8800419721",
                                        "theoretical_mass": "7908.2324",
                                        "ion_position": "22",
                                        "ion_display_position": "66",
                                        "ion_sort_name": "Y00066",
                                        "ion_left_position": "22",
                                        "mass_error": "-0.0018",
                                        "ppm": "-0.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "21",
                                "monoisotopic_mass": "5949.6162",
                                "monoisotopic_mz": "744.7093",
                                "intensity": "198997.42",
                                "charge": "8"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "22",
                                "monoisotopic_mass": "1415.5938",
                                "monoisotopic_mz": "708.8042",
                                "intensity": "88805.07",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "23",
                                "monoisotopic_mass": "7947.2502",
                                "monoisotopic_mz": "723.4846",
                                "intensity": "124538.38",
                                "charge": "11"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "24",
                                "monoisotopic_mass": "3581.4812",
                                "monoisotopic_mz": "717.3035",
                                "intensity": "264050.08",
                                "charge": "5"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "25",
                                "monoisotopic_mass": "6445.9344",
                                "monoisotopic_mz": "645.6007",
                                "intensity": "93371.53",
                                "charge": "10"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "26",
                                "monoisotopic_mass": "724.0258",
                                "monoisotopic_mz": "725.0330",
                                "intensity": "55843.19",
                                "charge": "1"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "27",
                                "monoisotopic_mass": "2810.9599",
                                "monoisotopic_mz": "703.7473",
                                "intensity": "61050.91",
                                "charge": "4"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "28",
                                "monoisotopic_mass": "4901.5973",
                                "monoisotopic_mz": "701.2355",
                                "intensity": "349884.04",
                                "charge": "7"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "29",
                                "monoisotopic_mass": "7965.2374",
                                "monoisotopic_mz": "725.1198",
                                "intensity": "188104.34",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "97.8800419721",
                                        "theoretical_mass": "7965.2539",
                                        "ion_position": "21",
                                        "ion_display_position": "67",
                                        "ion_sort_name": "Y00067",
                                        "ion_left_position": "21",
                                        "mass_error": "-0.0165",
                                        "ppm": "-2.07"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "30",
                                "monoisotopic_mass": "9129.4013",
                                "monoisotopic_mz": "703.2689",
                                "intensity": "105599.23",
                                "charge": "13"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "31",
                                "monoisotopic_mass": "6327.7285",
                                "monoisotopic_mz": "704.0882",
                                "intensity": "228955.97",
                                "charge": "9"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "32",
                                "monoisotopic_mass": "6978.8402",
                                "monoisotopic_mz": "698.8913",
                                "intensity": "104051.31",
                                "charge": "10"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "33",
                                "monoisotopic_mass": "6583.6342",
                                "monoisotopic_mz": "732.5222",
                                "intensity": "91896.34",
                                "charge": "9"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "34",
                                "monoisotopic_mass": "3181.1292",
                                "monoisotopic_mz": "637.2331",
                                "intensity": "94787.11",
                                "charge": "5"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "35",
                                "monoisotopic_mass": "6638.8122",
                                "monoisotopic_mz": "738.6531",
                                "intensity": "120277.59",
                                "charge": "9"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "36",
                                "monoisotopic_mass": "3910.5930",
                                "monoisotopic_mz": "783.1259",
                                "intensity": "77604.38",
                                "charge": "5"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "37",
                                "monoisotopic_mass": "2097.3180",
                                "monoisotopic_mz": "700.1133",
                                "intensity": "98784.71",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "38",
                                "monoisotopic_mass": "9921.1639",
                                "monoisotopic_mz": "709.6618",
                                "intensity": "401642.59",
                                "charge": "14"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "39",
                                "monoisotopic_mass": "7849.2305",
                                "monoisotopic_mz": "714.5737",
                                "intensity": "84457.08",
                                "charge": "11"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "40",
                                "monoisotopic_mass": "6202.1110",
                                "monoisotopic_mz": "776.2711",
                                "intensity": "102558.22",
                                "charge": "8"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "41",
                                "monoisotopic_mass": "3511.2349",
                                "monoisotopic_mz": "703.2543",
                                "intensity": "53767.79",
                                "charge": "5"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "42",
                                "monoisotopic_mass": "6304.2059",
                                "monoisotopic_mz": "701.4746",
                                "intensity": "216176.59",
                                "charge": "9"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "43",
                                "monoisotopic_mass": "1437.6011",
                                "monoisotopic_mz": "719.8078",
                                "intensity": "88212.46",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "44",
                                "monoisotopic_mass": "920.7590",
                                "monoisotopic_mz": "921.7663",
                                "intensity": "70525.85",
                                "charge": "1"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "45",
                                "monoisotopic_mass": "3604.9123",
                                "monoisotopic_mz": "721.9897",
                                "intensity": "309935.80",
                                "charge": "5"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "46",
                                "monoisotopic_mass": "4202.5445",
                                "monoisotopic_mz": "701.4314",
                                "intensity": "157920.87",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "47",
                                "monoisotopic_mass": "778.3451",
                                "monoisotopic_mz": "779.3524",
                                "intensity": "64626.09",
                                "charge": "1"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "48",
                                "monoisotopic_mass": "2335.0348",
                                "monoisotopic_mz": "779.3522",
                                "intensity": "76296.21",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "49",
                                "monoisotopic_mass": "9824.2098",
                                "monoisotopic_mz": "702.7365",
                                "intensity": "372339.52",
                                "charge": "14"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "50",
                                "monoisotopic_mass": "2792.7651",
                                "monoisotopic_mz": "699.1986",
                                "intensity": "65225.58",
                                "charge": "4"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "51",
                                "monoisotopic_mass": "8518.7120",
                                "monoisotopic_mz": "710.8999",
                                "intensity": "227934.49",
                                "charge": "12"
                            },
                            {
                                "spec_id": "1000477",
                                "peak_id": "52",
                                "monoisotopic_mass": "710.6616",
                                "monoisotopic_mz": "711.6689",
                                "intensity": "72577.72",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "37",
                    "proteoform_id": "60",
                    "sequence_name": "sp|P66431|RS15_SALTY",
                    "sequence_description": "30S ribosomal protein S15 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpsO PE=3 SV=2",
                    "proteoform_mass": "10158.3088",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "89",
                        "first_residue_position": "1",
                        "last_residue_position": "88",
                        "annotated_seq": "M.SLSTEATAKIVSEFGRDANDTG(STDVQV)[+97.8800]ALLTAQINHLQGHFAEHKKDHHSRRGLLRMVSQRRKLLDYLKRKDVARYTALIERLGLRR.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "L"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "T"
                            },
                            {
                                "position": "5",
                                "acid": "E"
                            },
                            {
                                "position": "6",
                                "acid": "A"
                            },
                            {
                                "position": "7",
                                "acid": "T"
                            },
                            {
                                "position": "8",
                                "acid": "A"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "V"
                            },
                            {
                                "position": "12",
                                "acid": "S"
                            },
                            {
                                "position": "13",
                                "acid": "E"
                            },
                            {
                                "position": "14",
                                "acid": "F"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "R"
                            },
                            {
                                "position": "17",
                                "acid": "D"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "N"
                            },
                            {
                                "position": "20",
                                "acid": "D"
                            },
                            {
                                "position": "21",
                                "acid": "T"
                            },
                            {
                                "position": "22",
                                "acid": "G"
                            },
                            {
                                "position": "23",
                                "acid": "S"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "V"
                            },
                            {
                                "position": "27",
                                "acid": "Q"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "L"
                            },
                            {
                                "position": "31",
                                "acid": "L"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "A"
                            },
                            {
                                "position": "34",
                                "acid": "Q"
                            },
                            {
                                "position": "35",
                                "acid": "I"
                            },
                            {
                                "position": "36",
                                "acid": "N"
                            },
                            {
                                "position": "37",
                                "acid": "H"
                            },
                            {
                                "position": "38",
                                "acid": "L"
                            },
                            {
                                "position": "39",
                                "acid": "Q"
                            },
                            {
                                "position": "40",
                                "acid": "G"
                            },
                            {
                                "position": "41",
                                "acid": "H"
                            },
                            {
                                "position": "42",
                                "acid": "F"
                            },
                            {
                                "position": "43",
                                "acid": "A"
                            },
                            {
                                "position": "44",
                                "acid": "E"
                            },
                            {
                                "position": "45",
                                "acid": "H"
                            },
                            {
                                "position": "46",
                                "acid": "K"
                            },
                            {
                                "position": "47",
                                "acid": "K"
                            },
                            {
                                "position": "48",
                                "acid": "D"
                            },
                            {
                                "position": "49",
                                "acid": "H"
                            },
                            {
                                "position": "50",
                                "acid": "H"
                            },
                            {
                                "position": "51",
                                "acid": "S"
                            },
                            {
                                "position": "52",
                                "acid": "R"
                            },
                            {
                                "position": "53",
                                "acid": "R"
                            },
                            {
                                "position": "54",
                                "acid": "G"
                            },
                            {
                                "position": "55",
                                "acid": "L"
                            },
                            {
                                "position": "56",
                                "acid": "L"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "M"
                            },
                            {
                                "position": "59",
                                "acid": "V"
                            },
                            {
                                "position": "60",
                                "acid": "S"
                            },
                            {
                                "position": "61",
                                "acid": "Q"
                            },
                            {
                                "position": "62",
                                "acid": "R"
                            },
                            {
                                "position": "63",
                                "acid": "R"
                            },
                            {
                                "position": "64",
                                "acid": "K"
                            },
                            {
                                "position": "65",
                                "acid": "L"
                            },
                            {
                                "position": "66",
                                "acid": "L"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "Y"
                            },
                            {
                                "position": "69",
                                "acid": "L"
                            },
                            {
                                "position": "70",
                                "acid": "K"
                            },
                            {
                                "position": "71",
                                "acid": "R"
                            },
                            {
                                "position": "72",
                                "acid": "K"
                            },
                            {
                                "position": "73",
                                "acid": "D"
                            },
                            {
                                "position": "74",
                                "acid": "V"
                            },
                            {
                                "position": "75",
                                "acid": "A"
                            },
                            {
                                "position": "76",
                                "acid": "R"
                            },
                            {
                                "position": "77",
                                "acid": "Y"
                            },
                            {
                                "position": "78",
                                "acid": "T"
                            },
                            {
                                "position": "79",
                                "acid": "A"
                            },
                            {
                                "position": "80",
                                "acid": "L"
                            },
                            {
                                "position": "81",
                                "acid": "I"
                            },
                            {
                                "position": "82",
                                "acid": "E"
                            },
                            {
                                "position": "83",
                                "acid": "R"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "G"
                            },
                            {
                                "position": "86",
                                "acid": "L"
                            },
                            {
                                "position": "87",
                                "acid": "R"
                            },
                            {
                                "position": "88",
                                "acid": "R"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "21",
                                            "ion_display_position": "21",
                                            "spec_id": "1000477",
                                            "peak_id": "17",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "21",
                                            "ion_display_position": "21",
                                            "spec_id": "1000477",
                                            "peak_id": "13",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "21",
                                            "ion_display_position": "67",
                                            "spec_id": "1000477",
                                            "peak_id": "29",
                                            "peak_charge": "11"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "22",
                                        "ion_display_position": "66",
                                        "spec_id": "1000477",
                                        "peak_id": "20",
                                        "peak_charge": "11"
                                    }
                                }
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "28",
                                        "ion_display_position": "60",
                                        "spec_id": "1000477",
                                        "peak_id": "7",
                                        "peak_charge": "10"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "29",
                                        "ion_display_position": "59",
                                        "spec_id": "1000477",
                                        "peak_id": "10",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "30",
                                            "ion_display_position": "58",
                                            "spec_id": "1000477",
                                            "peak_id": "6",
                                            "peak_charge": "10"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "30",
                                            "ion_display_position": "58",
                                            "spec_id": "1000477",
                                            "peak_id": "2",
                                            "peak_charge": "9"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "31",
                                        "ion_display_position": "57",
                                        "spec_id": "1000477",
                                        "peak_id": "4",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "23",
                            "right_position": "29",
                            "shift": "97.8800419721",
                            "anno": "+97.8800",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "94",
                "p_value": "0.06",
                "e_value": "0.06",
                "fdr": "7.25e-03",
                "matched_fragment_number": "5",
                "matched_peak_number": "5",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                        "ms1_ids": "497",
                        "ms1_scans": "979",
                        "ids": "481",
                        "scans": "980",
                        "precursor_mono_mass": "10158.3107",
                        "precursor_charge": "18",
                        "precursor_mz": "565.3579"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "481",
                                "peak_id": "0",
                                "monoisotopic_mass": "6883.7759",
                                "monoisotopic_mz": "574.6553",
                                "intensity": "356283.62",
                                "charge": "12"
                            },
                            {
                                "spec_id": "481",
                                "peak_id": "1",
                                "monoisotopic_mass": "7208.9148",
                                "monoisotopic_mz": "601.7502",
                                "intensity": "610853.56",
                                "charge": "12",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "97.9218819721",
                                        "theoretical_mass": "7207.9351",
                                        "ion_position": "29",
                                        "ion_display_position": "59",
                                        "ion_sort_name": "Y00059",
                                        "ion_left_position": "29",
                                        "mass_error": "-0.0226",
                                        "ppm": "-3.14"
                                    }
                                }
                            },
                            {
                                "spec_id": "481",
                                "peak_id": "2",
                                "monoisotopic_mass": "6883.7723",
                                "monoisotopic_mz": "626.8048",
                                "intensity": "780380.12",
                                "charge": "11"
                            },
                            {
                                "spec_id": "481",
                                "peak_id": "3",
                                "monoisotopic_mass": "7378.0390",
                                "monoisotopic_mz": "615.8439",
                                "intensity": "331266.26",
                                "charge": "12",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "97.9218819721",
                                        "theoretical_mass": "7378.0406",
                                        "ion_position": "27",
                                        "ion_display_position": "61",
                                        "ion_sort_name": "Y00061",
                                        "ion_left_position": "27",
                                        "mass_error": "-0.0016",
                                        "ppm": "-0.22"
                                    }
                                }
                            },
                            {
                                "spec_id": "481",
                                "peak_id": "4",
                                "monoisotopic_mass": "7109.9412",
                                "monoisotopic_mz": "593.5024",
                                "intensity": "622665.58",
                                "charge": "12"
                            },
                            {
                                "spec_id": "481",
                                "peak_id": "5",
                                "monoisotopic_mass": "6996.8615",
                                "monoisotopic_mz": "584.0791",
                                "intensity": "639778.63",
                                "charge": "12",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6996.9291",
                                        "ion_position": "30",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0676",
                                        "ppm": "-9.66"
                                    }
                                }
                            },
                            {
                                "spec_id": "481",
                                "peak_id": "6",
                                "monoisotopic_mass": "7091.9503",
                                "monoisotopic_mz": "592.0031",
                                "intensity": "702650.35",
                                "charge": "12"
                            },
                            {
                                "spec_id": "481",
                                "peak_id": "7",
                                "monoisotopic_mass": "6361.4124",
                                "monoisotopic_mz": "637.1485",
                                "intensity": "488686.55",
                                "charge": "10"
                            },
                            {
                                "spec_id": "481",
                                "peak_id": "8",
                                "monoisotopic_mass": "1981.4889",
                                "monoisotopic_mz": "199.1562",
                                "intensity": "99683.18",
                                "charge": "10"
                            },
                            {
                                "spec_id": "481",
                                "peak_id": "9",
                                "monoisotopic_mass": "7278.9721",
                                "monoisotopic_mz": "607.5883",
                                "intensity": "185773.01",
                                "charge": "12",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "97.9218819721",
                                        "theoretical_mass": "7278.9722",
                                        "ion_position": "28",
                                        "ion_display_position": "60",
                                        "ion_sort_name": "Y00060",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0001",
                                        "ppm": "-0.02"
                                    }
                                }
                            },
                            {
                                "spec_id": "481",
                                "peak_id": "10",
                                "monoisotopic_mass": "2535.1450",
                                "monoisotopic_mz": "634.7935",
                                "intensity": "73308.06",
                                "charge": "4"
                            },
                            {
                                "spec_id": "481",
                                "peak_id": "11",
                                "monoisotopic_mass": "9006.3443",
                                "monoisotopic_mz": "601.4302",
                                "intensity": "104452.81",
                                "charge": "15"
                            },
                            {
                                "spec_id": "481",
                                "peak_id": "12",
                                "monoisotopic_mass": "4812.5315",
                                "monoisotopic_mz": "602.5737",
                                "intensity": "109883.81",
                                "charge": "8"
                            },
                            {
                                "spec_id": "481",
                                "peak_id": "13",
                                "monoisotopic_mass": "6982.7427",
                                "monoisotopic_mz": "635.8021",
                                "intensity": "294780.93",
                                "charge": "11"
                            },
                            {
                                "spec_id": "481",
                                "peak_id": "14",
                                "monoisotopic_mass": "7189.8809",
                                "monoisotopic_mz": "600.1640",
                                "intensity": "223974.04",
                                "charge": "12"
                            },
                            {
                                "spec_id": "481",
                                "peak_id": "15",
                                "monoisotopic_mass": "1486.8638",
                                "monoisotopic_mz": "496.6285",
                                "intensity": "59753.24",
                                "charge": "3"
                            },
                            {
                                "spec_id": "481",
                                "peak_id": "16",
                                "monoisotopic_mass": "4127.7111",
                                "monoisotopic_mz": "516.9712",
                                "intensity": "69955.77",
                                "charge": "8"
                            },
                            {
                                "spec_id": "481",
                                "peak_id": "17",
                                "monoisotopic_mass": "2179.8472",
                                "monoisotopic_mz": "199.1752",
                                "intensity": "66892.63",
                                "charge": "11"
                            },
                            {
                                "spec_id": "481",
                                "peak_id": "18",
                                "monoisotopic_mass": "3226.1072",
                                "monoisotopic_mz": "646.2287",
                                "intensity": "112443.34",
                                "charge": "5"
                            },
                            {
                                "spec_id": "481",
                                "peak_id": "19",
                                "monoisotopic_mass": "2517.1226",
                                "monoisotopic_mz": "630.2879",
                                "intensity": "129048.53",
                                "charge": "4"
                            },
                            {
                                "spec_id": "481",
                                "peak_id": "20",
                                "monoisotopic_mass": "8539.6777",
                                "monoisotopic_mz": "610.9843",
                                "intensity": "260450.23",
                                "charge": "14"
                            },
                            {
                                "spec_id": "481",
                                "peak_id": "21",
                                "monoisotopic_mass": "6977.8485",
                                "monoisotopic_mz": "582.4947",
                                "intensity": "185347.69",
                                "charge": "12"
                            },
                            {
                                "spec_id": "481",
                                "peak_id": "22",
                                "monoisotopic_mass": "3652.3613",
                                "monoisotopic_mz": "609.7342",
                                "intensity": "62870.90",
                                "charge": "6"
                            },
                            {
                                "spec_id": "481",
                                "peak_id": "23",
                                "monoisotopic_mass": "6692.6729",
                                "monoisotopic_mz": "609.4321",
                                "intensity": "108514.48",
                                "charge": "11"
                            },
                            {
                                "spec_id": "481",
                                "peak_id": "24",
                                "monoisotopic_mass": "5897.3616",
                                "monoisotopic_mz": "590.7434",
                                "intensity": "61740.34",
                                "charge": "10"
                            },
                            {
                                "spec_id": "481",
                                "peak_id": "25",
                                "monoisotopic_mass": "2534.1441",
                                "monoisotopic_mz": "845.7220",
                                "intensity": "109868.50",
                                "charge": "3"
                            },
                            {
                                "spec_id": "481",
                                "peak_id": "26",
                                "monoisotopic_mass": "6884.7921",
                                "monoisotopic_mz": "689.4865",
                                "intensity": "62429.47",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6883.8451",
                                        "ion_position": "31",
                                        "ion_display_position": "57",
                                        "ion_sort_name": "Y00057",
                                        "ion_left_position": "31",
                                        "mass_error": "-0.0554",
                                        "ppm": "-8.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "481",
                                "peak_id": "27",
                                "monoisotopic_mass": "1293.2647",
                                "monoisotopic_mz": "647.6396",
                                "intensity": "47080.96",
                                "charge": "2"
                            },
                            {
                                "spec_id": "481",
                                "peak_id": "28",
                                "monoisotopic_mass": "6783.7217",
                                "monoisotopic_mz": "679.3794",
                                "intensity": "64347.85",
                                "charge": "10"
                            },
                            {
                                "spec_id": "481",
                                "peak_id": "29",
                                "monoisotopic_mass": "1386.9891",
                                "monoisotopic_mz": "199.1486",
                                "intensity": "44900.88",
                                "charge": "7"
                            },
                            {
                                "spec_id": "481",
                                "peak_id": "30",
                                "monoisotopic_mass": "583.3184",
                                "monoisotopic_mz": "584.3257",
                                "intensity": "89724.89",
                                "charge": "1"
                            },
                            {
                                "spec_id": "481",
                                "peak_id": "31",
                                "monoisotopic_mass": "3806.2907",
                                "monoisotopic_mz": "635.3891",
                                "intensity": "73874.71",
                                "charge": "6"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "37",
                    "proteoform_id": "60",
                    "sequence_name": "sp|P66431|RS15_SALTY",
                    "sequence_description": "30S ribosomal protein S15 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpsO PE=3 SV=2",
                    "proteoform_mass": "10158.3507",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "89",
                        "first_residue_position": "1",
                        "last_residue_position": "88",
                        "annotated_seq": "M.SLSTEATAKIVSEFGRDANDTGSTDVQVA(L)[+97.9219]LTAQINHLQGHFAEHKKDHHSRRGLLRMVSQRRKLLDYLKRKDVARYTALIERLGLRR.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "L"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "T"
                            },
                            {
                                "position": "5",
                                "acid": "E"
                            },
                            {
                                "position": "6",
                                "acid": "A"
                            },
                            {
                                "position": "7",
                                "acid": "T"
                            },
                            {
                                "position": "8",
                                "acid": "A"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "V"
                            },
                            {
                                "position": "12",
                                "acid": "S"
                            },
                            {
                                "position": "13",
                                "acid": "E"
                            },
                            {
                                "position": "14",
                                "acid": "F"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "R"
                            },
                            {
                                "position": "17",
                                "acid": "D"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "N"
                            },
                            {
                                "position": "20",
                                "acid": "D"
                            },
                            {
                                "position": "21",
                                "acid": "T"
                            },
                            {
                                "position": "22",
                                "acid": "G"
                            },
                            {
                                "position": "23",
                                "acid": "S"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "V"
                            },
                            {
                                "position": "27",
                                "acid": "Q"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "L"
                            },
                            {
                                "position": "31",
                                "acid": "L"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "A"
                            },
                            {
                                "position": "34",
                                "acid": "Q"
                            },
                            {
                                "position": "35",
                                "acid": "I"
                            },
                            {
                                "position": "36",
                                "acid": "N"
                            },
                            {
                                "position": "37",
                                "acid": "H"
                            },
                            {
                                "position": "38",
                                "acid": "L"
                            },
                            {
                                "position": "39",
                                "acid": "Q"
                            },
                            {
                                "position": "40",
                                "acid": "G"
                            },
                            {
                                "position": "41",
                                "acid": "H"
                            },
                            {
                                "position": "42",
                                "acid": "F"
                            },
                            {
                                "position": "43",
                                "acid": "A"
                            },
                            {
                                "position": "44",
                                "acid": "E"
                            },
                            {
                                "position": "45",
                                "acid": "H"
                            },
                            {
                                "position": "46",
                                "acid": "K"
                            },
                            {
                                "position": "47",
                                "acid": "K"
                            },
                            {
                                "position": "48",
                                "acid": "D"
                            },
                            {
                                "position": "49",
                                "acid": "H"
                            },
                            {
                                "position": "50",
                                "acid": "H"
                            },
                            {
                                "position": "51",
                                "acid": "S"
                            },
                            {
                                "position": "52",
                                "acid": "R"
                            },
                            {
                                "position": "53",
                                "acid": "R"
                            },
                            {
                                "position": "54",
                                "acid": "G"
                            },
                            {
                                "position": "55",
                                "acid": "L"
                            },
                            {
                                "position": "56",
                                "acid": "L"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "M"
                            },
                            {
                                "position": "59",
                                "acid": "V"
                            },
                            {
                                "position": "60",
                                "acid": "S"
                            },
                            {
                                "position": "61",
                                "acid": "Q"
                            },
                            {
                                "position": "62",
                                "acid": "R"
                            },
                            {
                                "position": "63",
                                "acid": "R"
                            },
                            {
                                "position": "64",
                                "acid": "K"
                            },
                            {
                                "position": "65",
                                "acid": "L"
                            },
                            {
                                "position": "66",
                                "acid": "L"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "Y"
                            },
                            {
                                "position": "69",
                                "acid": "L"
                            },
                            {
                                "position": "70",
                                "acid": "K"
                            },
                            {
                                "position": "71",
                                "acid": "R"
                            },
                            {
                                "position": "72",
                                "acid": "K"
                            },
                            {
                                "position": "73",
                                "acid": "D"
                            },
                            {
                                "position": "74",
                                "acid": "V"
                            },
                            {
                                "position": "75",
                                "acid": "A"
                            },
                            {
                                "position": "76",
                                "acid": "R"
                            },
                            {
                                "position": "77",
                                "acid": "Y"
                            },
                            {
                                "position": "78",
                                "acid": "T"
                            },
                            {
                                "position": "79",
                                "acid": "A"
                            },
                            {
                                "position": "80",
                                "acid": "L"
                            },
                            {
                                "position": "81",
                                "acid": "I"
                            },
                            {
                                "position": "82",
                                "acid": "E"
                            },
                            {
                                "position": "83",
                                "acid": "R"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "G"
                            },
                            {
                                "position": "86",
                                "acid": "L"
                            },
                            {
                                "position": "87",
                                "acid": "R"
                            },
                            {
                                "position": "88",
                                "acid": "R"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "27",
                                        "ion_display_position": "61",
                                        "spec_id": "481",
                                        "peak_id": "3",
                                        "peak_charge": "12"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "28",
                                        "ion_display_position": "60",
                                        "spec_id": "481",
                                        "peak_id": "9",
                                        "peak_charge": "12"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "29",
                                        "ion_display_position": "59",
                                        "spec_id": "481",
                                        "peak_id": "1",
                                        "peak_charge": "12"
                                    }
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "30",
                                        "ion_display_position": "58",
                                        "spec_id": "481",
                                        "peak_id": "5",
                                        "peak_charge": "12"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "31",
                                        "ion_display_position": "57",
                                        "spec_id": "481",
                                        "peak_id": "26",
                                        "peak_charge": "10"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "30",
                            "right_position": "31",
                            "shift": "97.9218819721",
                            "anno": "+97.9219",
                            "shift_type": "unexpected"
                        }
                    }
                }
            }
        ]
    }
}
