prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "4",
        "sequence_name": "sp|P66191|RL31_SALTY",
        "sequence_description": "50S ribosomal protein L31 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmE PE=3 SV=1",
        "proteoform_id": "35",
        "prsm_number": "3",
        "prsm": [
            {
                "prsm_id": "159",
                "p_value": "5.47e-08",
                "e_value": "5.47e-08",
                "fdr": "0",
                "matched_fragment_number": "14",
                "matched_peak_number": "16",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_2_ms2.msalign",
                        "ms1_ids": "1000310",
                        "ms1_scans": "616",
                        "ids": "1000305",
                        "scans": "617",
                        "precursor_mono_mass": "8093.9032",
                        "precursor_charge": "13",
                        "precursor_mz": "623.6152"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "1000305",
                                "peak_id": "0",
                                "monoisotopic_mass": "6512.0774",
                                "monoisotopic_mz": "652.2150",
                                "intensity": "258594.97",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "151.9368842885",
                                        "theoretical_mass": "6512.0795",
                                        "ion_position": "14",
                                        "ion_display_position": "56",
                                        "ion_sort_name": "Y00056",
                                        "ion_left_position": "14",
                                        "mass_error": "-0.0021",
                                        "ppm": "-0.32"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000305",
                                "peak_id": "1",
                                "monoisotopic_mass": "6684.1507",
                                "monoisotopic_mz": "669.4224",
                                "intensity": "168981.80",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "151.9368842885",
                                        "theoretical_mass": "6684.1643",
                                        "ion_position": "12",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0135",
                                        "ppm": "-2.03"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000305",
                                "peak_id": "2",
                                "monoisotopic_mass": "6583.1114",
                                "monoisotopic_mz": "659.3184",
                                "intensity": "257414.17",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "151.9368842885",
                                        "theoretical_mass": "6583.1166",
                                        "ion_position": "13",
                                        "ion_display_position": "57",
                                        "ion_sort_name": "Y00057",
                                        "ion_left_position": "13",
                                        "mass_error": "-0.0053",
                                        "ppm": "-0.80"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000305",
                                "peak_id": "3",
                                "monoisotopic_mass": "6411.0377",
                                "monoisotopic_mz": "642.1110",
                                "intensity": "60261.40",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "151.9368842885",
                                        "theoretical_mass": "6411.0318",
                                        "ion_position": "15",
                                        "ion_display_position": "55",
                                        "ion_sort_name": "Y00055",
                                        "ion_left_position": "15",
                                        "mass_error": "0.0059",
                                        "ppm": "0.92"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000305",
                                "peak_id": "4",
                                "monoisotopic_mass": "1981.0031",
                                "monoisotopic_mz": "199.1076",
                                "intensity": "22315.64",
                                "charge": "10"
                            },
                            {
                                "spec_id": "1000305",
                                "peak_id": "5",
                                "monoisotopic_mass": "6797.2293",
                                "monoisotopic_mz": "680.7302",
                                "intensity": "39162.73",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "151.9368842885",
                                        "theoretical_mass": "6797.2484",
                                        "ion_position": "11",
                                        "ion_display_position": "59",
                                        "ion_sort_name": "Y00059",
                                        "ion_left_position": "11",
                                        "mass_error": "-0.0190",
                                        "ppm": "-2.80"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000305",
                                "peak_id": "6",
                                "monoisotopic_mass": "3309.7530",
                                "monoisotopic_mz": "552.6328",
                                "intensity": "135996.72",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3309.7847",
                                        "ion_position": "41",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "Y00029",
                                        "ion_left_position": "41",
                                        "mass_error": "-0.0317",
                                        "ppm": "-9.57"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000305",
                                "peak_id": "7",
                                "monoisotopic_mass": "2035.0878",
                                "monoisotopic_mz": "509.7792",
                                "intensity": "172179.70",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2035.1075",
                                        "ion_position": "52",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "Y00018",
                                        "ion_left_position": "52",
                                        "mass_error": "-0.0198",
                                        "ppm": "-9.71"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000305",
                                "peak_id": "8",
                                "monoisotopic_mass": "6666.1465",
                                "monoisotopic_mz": "667.6219",
                                "intensity": "74958.14",
                                "charge": "10"
                            },
                            {
                                "spec_id": "1000305",
                                "peak_id": "9",
                                "monoisotopic_mass": "1510.7839",
                                "monoisotopic_mz": "756.3992",
                                "intensity": "16230.69",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1510.7966",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "-0.0127",
                                        "ppm": "-8.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000305",
                                "peak_id": "10",
                                "monoisotopic_mass": "1409.7351",
                                "monoisotopic_mz": "705.8748",
                                "intensity": "75030.14",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1409.7489",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0139",
                                        "ppm": "-9.83"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000305",
                                "peak_id": "11",
                                "monoisotopic_mass": "6565.1010",
                                "monoisotopic_mz": "657.5174",
                                "intensity": "52467.49",
                                "charge": "10"
                            },
                            {
                                "spec_id": "1000305",
                                "peak_id": "12",
                                "monoisotopic_mass": "4051.0529",
                                "monoisotopic_mz": "579.7291",
                                "intensity": "32069.32",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4051.0897",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "ion_sort_name": "Y00035",
                                        "ion_left_position": "35",
                                        "mass_error": "-0.0368",
                                        "ppm": "-9.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000305",
                                "peak_id": "13",
                                "monoisotopic_mass": "1296.6533",
                                "monoisotopic_mz": "649.3339",
                                "intensity": "95004.22",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1296.6649",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "-0.0116",
                                        "ppm": "-8.94"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000305",
                                "peak_id": "14",
                                "monoisotopic_mass": "1510.7822",
                                "monoisotopic_mz": "504.6013",
                                "intensity": "33678.81",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1510.7966",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "-0.0144",
                                        "ppm": "-9.53"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000305",
                                "peak_id": "15",
                                "monoisotopic_mass": "1563.8065",
                                "monoisotopic_mz": "522.2761",
                                "intensity": "28261.39",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000305",
                                "peak_id": "16",
                                "monoisotopic_mass": "6495.0401",
                                "monoisotopic_mz": "650.5113",
                                "intensity": "36914.12",
                                "charge": "10"
                            },
                            {
                                "spec_id": "1000305",
                                "peak_id": "17",
                                "monoisotopic_mass": "1492.7716",
                                "monoisotopic_mz": "498.5978",
                                "intensity": "23416.13",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000305",
                                "peak_id": "18",
                                "monoisotopic_mass": "1068.5436",
                                "monoisotopic_mz": "535.2791",
                                "intensity": "26022.51",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1068.5539",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "-0.0103",
                                        "ppm": "-9.66"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000305",
                                "peak_id": "19",
                                "monoisotopic_mass": "2035.0905",
                                "monoisotopic_mz": "679.3708",
                                "intensity": "25712.27",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2035.1075",
                                        "ion_position": "52",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "Y00018",
                                        "ion_left_position": "52",
                                        "mass_error": "-0.0170",
                                        "ppm": "-8.36"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000305",
                                "peak_id": "20",
                                "monoisotopic_mass": "6889.2800",
                                "monoisotopic_mz": "689.9353",
                                "intensity": "16653.59",
                                "charge": "10"
                            },
                            {
                                "spec_id": "1000305",
                                "peak_id": "21",
                                "monoisotopic_mass": "1492.7724",
                                "monoisotopic_mz": "747.3935",
                                "intensity": "19403.57",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000305",
                                "peak_id": "22",
                                "monoisotopic_mass": "5850.9496",
                                "monoisotopic_mz": "651.1128",
                                "intensity": "12168.59",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5852.0016",
                                        "ion_position": "18",
                                        "ion_display_position": "52",
                                        "ion_sort_name": "Y00052",
                                        "ion_left_position": "18",
                                        "mass_error": "-0.0497",
                                        "ppm": "-8.49"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000305",
                                "peak_id": "23",
                                "monoisotopic_mass": "1361.0530",
                                "monoisotopic_mz": "681.5338",
                                "intensity": "7162.71",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000305",
                                "peak_id": "24",
                                "monoisotopic_mass": "1167.6116",
                                "monoisotopic_mz": "584.8131",
                                "intensity": "11343.60",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1167.6223",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "-0.0107",
                                        "ppm": "-9.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000305",
                                "peak_id": "25",
                                "monoisotopic_mass": "3310.7501",
                                "monoisotopic_mz": "663.1573",
                                "intensity": "14156.85",
                                "charge": "5"
                            },
                            {
                                "spec_id": "1000305",
                                "peak_id": "26",
                                "monoisotopic_mass": "1274.6672",
                                "monoisotopic_mz": "638.3409",
                                "intensity": "13573.97",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000305",
                                "peak_id": "27",
                                "monoisotopic_mass": "2575.5241",
                                "monoisotopic_mz": "199.1245",
                                "intensity": "20690.12",
                                "charge": "13"
                            },
                            {
                                "spec_id": "1000305",
                                "peak_id": "28",
                                "monoisotopic_mass": "2960.7571",
                                "monoisotopic_mz": "593.1587",
                                "intensity": "18780.61",
                                "charge": "5"
                            },
                            {
                                "spec_id": "1000305",
                                "peak_id": "29",
                                "monoisotopic_mass": "1464.7312",
                                "monoisotopic_mz": "733.3729",
                                "intensity": "8388.29",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000305",
                                "peak_id": "30",
                                "monoisotopic_mass": "1388.7807",
                                "monoisotopic_mz": "695.3976",
                                "intensity": "8955.17",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000305",
                                "peak_id": "31",
                                "monoisotopic_mass": "2171.0210",
                                "monoisotopic_mz": "724.6810",
                                "intensity": "10308.49",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000305",
                                "peak_id": "32",
                                "monoisotopic_mass": "4737.1247",
                                "monoisotopic_mz": "677.7394",
                                "intensity": "10460.09",
                                "charge": "7"
                            },
                            {
                                "spec_id": "1000305",
                                "peak_id": "33",
                                "monoisotopic_mass": "6908.2741",
                                "monoisotopic_mz": "691.8347",
                                "intensity": "20022.03",
                                "charge": "10"
                            },
                            {
                                "spec_id": "1000305",
                                "peak_id": "34",
                                "monoisotopic_mass": "3463.1446",
                                "monoisotopic_mz": "693.6362",
                                "intensity": "9604.76",
                                "charge": "5"
                            },
                            {
                                "spec_id": "1000305",
                                "peak_id": "35",
                                "monoisotopic_mass": "1975.9546",
                                "monoisotopic_mz": "659.6588",
                                "intensity": "8281.84",
                                "charge": "3"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "4",
                    "proteoform_id": "35",
                    "sequence_name": "sp|P66191|RL31_SALTY",
                    "sequence_description": "50S ribosomal protein L31 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmE PE=3 SV=1",
                    "proteoform_mass": "8093.9132",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "70",
                        "first_residue_position": "0",
                        "last_residue_position": "69",
                        "annotated_seq": ".MKKGIHPNYVEITAT((C)[Carbamidomethylation]S(C)[Carbamidomethylation])[+151.9369]GNVIKTHSTVGHDLNLDV(C)[Carbamidomethylation]GK(C)[Carbamidomethylation]HPFFTGKQRVVDTGGRVERFNKRFSIPGSK.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "K"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "G"
                            },
                            {
                                "position": "4",
                                "acid": "I"
                            },
                            {
                                "position": "5",
                                "acid": "H"
                            },
                            {
                                "position": "6",
                                "acid": "P"
                            },
                            {
                                "position": "7",
                                "acid": "N"
                            },
                            {
                                "position": "8",
                                "acid": "Y"
                            },
                            {
                                "position": "9",
                                "acid": "V"
                            },
                            {
                                "position": "10",
                                "acid": "E"
                            },
                            {
                                "position": "11",
                                "acid": "I"
                            },
                            {
                                "position": "12",
                                "acid": "T"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "T"
                            },
                            {
                                "position": "15",
                                "acid": "C"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "C"
                            },
                            {
                                "position": "18",
                                "acid": "G"
                            },
                            {
                                "position": "19",
                                "acid": "N"
                            },
                            {
                                "position": "20",
                                "acid": "V"
                            },
                            {
                                "position": "21",
                                "acid": "I"
                            },
                            {
                                "position": "22",
                                "acid": "K"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "H"
                            },
                            {
                                "position": "25",
                                "acid": "S"
                            },
                            {
                                "position": "26",
                                "acid": "T"
                            },
                            {
                                "position": "27",
                                "acid": "V"
                            },
                            {
                                "position": "28",
                                "acid": "G"
                            },
                            {
                                "position": "29",
                                "acid": "H"
                            },
                            {
                                "position": "30",
                                "acid": "D"
                            },
                            {
                                "position": "31",
                                "acid": "L"
                            },
                            {
                                "position": "32",
                                "acid": "N"
                            },
                            {
                                "position": "33",
                                "acid": "L"
                            },
                            {
                                "position": "34",
                                "acid": "D"
                            },
                            {
                                "position": "35",
                                "acid": "V"
                            },
                            {
                                "position": "36",
                                "acid": "C"
                            },
                            {
                                "position": "37",
                                "acid": "G"
                            },
                            {
                                "position": "38",
                                "acid": "K"
                            },
                            {
                                "position": "39",
                                "acid": "C"
                            },
                            {
                                "position": "40",
                                "acid": "H"
                            },
                            {
                                "position": "41",
                                "acid": "P"
                            },
                            {
                                "position": "42",
                                "acid": "F"
                            },
                            {
                                "position": "43",
                                "acid": "F"
                            },
                            {
                                "position": "44",
                                "acid": "T"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "K"
                            },
                            {
                                "position": "47",
                                "acid": "Q"
                            },
                            {
                                "position": "48",
                                "acid": "R"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "V"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "T"
                            },
                            {
                                "position": "53",
                                "acid": "G"
                            },
                            {
                                "position": "54",
                                "acid": "G"
                            },
                            {
                                "position": "55",
                                "acid": "R"
                            },
                            {
                                "position": "56",
                                "acid": "V"
                            },
                            {
                                "position": "57",
                                "acid": "E"
                            },
                            {
                                "position": "58",
                                "acid": "R"
                            },
                            {
                                "position": "59",
                                "acid": "F"
                            },
                            {
                                "position": "60",
                                "acid": "N"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "R"
                            },
                            {
                                "position": "63",
                                "acid": "F"
                            },
                            {
                                "position": "64",
                                "acid": "S"
                            },
                            {
                                "position": "65",
                                "acid": "I"
                            },
                            {
                                "position": "66",
                                "acid": "P"
                            },
                            {
                                "position": "67",
                                "acid": "G"
                            },
                            {
                                "position": "68",
                                "acid": "S"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "spec_id": "1000305",
                                        "peak_id": "18",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "1000305",
                                        "peak_id": "24",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "11",
                                            "ion_display_position": "11",
                                            "spec_id": "1000305",
                                            "peak_id": "13",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "11",
                                            "ion_display_position": "59",
                                            "spec_id": "1000305",
                                            "peak_id": "5",
                                            "peak_charge": "10"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "1000305",
                                            "peak_id": "10",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "12",
                                            "ion_display_position": "58",
                                            "spec_id": "1000305",
                                            "peak_id": "1",
                                            "peak_charge": "10"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "13",
                                            "ion_display_position": "13",
                                            "spec_id": "1000305",
                                            "peak_id": "14",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "13",
                                            "ion_display_position": "13",
                                            "spec_id": "1000305",
                                            "peak_id": "9",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "13",
                                            "ion_display_position": "57",
                                            "spec_id": "1000305",
                                            "peak_id": "2",
                                            "peak_charge": "10"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "14",
                                        "ion_display_position": "56",
                                        "spec_id": "1000305",
                                        "peak_id": "0",
                                        "peak_charge": "10"
                                    }
                                }
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "15",
                                        "ion_display_position": "55",
                                        "spec_id": "1000305",
                                        "peak_id": "3",
                                        "peak_charge": "10"
                                    }
                                }
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "18",
                                        "ion_display_position": "52",
                                        "spec_id": "1000305",
                                        "peak_id": "22",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "spec_id": "1000305",
                                        "peak_id": "12",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "41",
                                        "ion_display_position": "29",
                                        "spec_id": "1000305",
                                        "peak_id": "6",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "52",
                                            "ion_display_position": "18",
                                            "spec_id": "1000305",
                                            "peak_id": "7",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "52",
                                            "ion_display_position": "18",
                                            "spec_id": "1000305",
                                            "peak_id": "19",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": [
                                {
                                    "left_pos": "15",
                                    "right_pos": "16",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "17",
                                    "right_pos": "18",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "36",
                                    "right_pos": "37",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "39",
                                    "right_pos": "40",
                                    "anno": "C"
                                }
                            ]
                        },
                        "mass_shift": {
                            "id": "0",
                            "left_position": "15",
                            "right_position": "18",
                            "shift": "151.9368842885",
                            "anno": "+151.9369",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "42",
                "p_value": "5.63e-07",
                "e_value": "5.63e-07",
                "fdr": "0",
                "matched_fragment_number": "15",
                "matched_peak_number": "19",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                        "ms1_ids": "323",
                        "ms1_scans": "631",
                        "ids": "307",
                        "scans": "632",
                        "precursor_mono_mass": "8093.9087",
                        "precursor_charge": "14",
                        "precursor_mz": "579.1436"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "307",
                                "peak_id": "0",
                                "monoisotopic_mass": "6512.0813",
                                "monoisotopic_mz": "593.0147",
                                "intensity": "153464.44",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "151.9374042885",
                                        "theoretical_mass": "6512.0800",
                                        "ion_position": "14",
                                        "ion_display_position": "56",
                                        "ion_sort_name": "Y00056",
                                        "ion_left_position": "14",
                                        "mass_error": "0.0012",
                                        "ppm": "0.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "1",
                                "monoisotopic_mass": "6797.2373",
                                "monoisotopic_mz": "618.9379",
                                "intensity": "47888.02",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "151.9374042885",
                                        "theoretical_mass": "6797.2489",
                                        "ion_position": "11",
                                        "ion_display_position": "59",
                                        "ion_sort_name": "Y00059",
                                        "ion_left_position": "11",
                                        "mass_error": "-0.0116",
                                        "ppm": "-1.71"
                                    }
                                }
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "2",
                                "monoisotopic_mass": "6925.2915",
                                "monoisotopic_mz": "630.5792",
                                "intensity": "19667.80",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "151.9374042885",
                                        "theoretical_mass": "6926.2915",
                                        "ion_position": "10",
                                        "ion_display_position": "60",
                                        "ion_sort_name": "Y00060",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0024",
                                        "ppm": "0.34"
                                    }
                                }
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "3",
                                "monoisotopic_mass": "6351.3490",
                                "monoisotopic_mz": "636.1422",
                                "intensity": "58396.93",
                                "charge": "10"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "4",
                                "monoisotopic_mass": "6512.0774",
                                "monoisotopic_mz": "652.2150",
                                "intensity": "133813.33",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "151.9374042885",
                                        "theoretical_mass": "6512.0800",
                                        "ion_position": "14",
                                        "ion_display_position": "56",
                                        "ion_sort_name": "Y00056",
                                        "ion_left_position": "14",
                                        "mass_error": "-0.0026",
                                        "ppm": "-0.40"
                                    }
                                }
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "5",
                                "monoisotopic_mass": "7381.4971",
                                "monoisotopic_mz": "616.1320",
                                "intensity": "42502.87",
                                "charge": "12"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "6",
                                "monoisotopic_mass": "6684.1630",
                                "monoisotopic_mz": "608.6585",
                                "intensity": "112944.65",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "151.9374042885",
                                        "theoretical_mass": "6684.1648",
                                        "ion_position": "12",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0018",
                                        "ppm": "-0.26"
                                    }
                                }
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "7",
                                "monoisotopic_mass": "6583.1113",
                                "monoisotopic_mz": "599.4719",
                                "intensity": "187362.15",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "151.9374042885",
                                        "theoretical_mass": "6583.1171",
                                        "ion_position": "13",
                                        "ion_display_position": "57",
                                        "ion_sort_name": "Y00057",
                                        "ion_left_position": "13",
                                        "mass_error": "-0.0058",
                                        "ppm": "-0.88"
                                    }
                                }
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "8",
                                "monoisotopic_mass": "6666.1462",
                                "monoisotopic_mz": "667.6219",
                                "intensity": "49349.47",
                                "charge": "10"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "9",
                                "monoisotopic_mass": "6566.1171",
                                "monoisotopic_mz": "597.9270",
                                "intensity": "36513.31",
                                "charge": "11"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "10",
                                "monoisotopic_mass": "6583.1199",
                                "monoisotopic_mz": "659.3193",
                                "intensity": "65260.58",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "151.9374042885",
                                        "theoretical_mass": "6583.1171",
                                        "ion_position": "13",
                                        "ion_display_position": "57",
                                        "ion_sort_name": "Y00057",
                                        "ion_left_position": "13",
                                        "mass_error": "0.0028",
                                        "ppm": "0.42"
                                    }
                                }
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "11",
                                "monoisotopic_mass": "6666.1551",
                                "monoisotopic_mz": "607.0214",
                                "intensity": "59116.28",
                                "charge": "11"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "12",
                                "monoisotopic_mass": "6874.2486",
                                "monoisotopic_mz": "625.9390",
                                "intensity": "36842.93",
                                "charge": "11"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "13",
                                "monoisotopic_mass": "6891.2576",
                                "monoisotopic_mz": "627.4852",
                                "intensity": "107805.42",
                                "charge": "11"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "14",
                                "monoisotopic_mass": "7763.0299",
                                "monoisotopic_mz": "706.7373",
                                "intensity": "18287.21",
                                "charge": "11"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "15",
                                "monoisotopic_mass": "2035.0893",
                                "monoisotopic_mz": "509.7796",
                                "intensity": "222700.20",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2035.1075",
                                        "ion_position": "52",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "Y00018",
                                        "ion_left_position": "52",
                                        "mass_error": "-0.0182",
                                        "ppm": "-8.94"
                                    }
                                }
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "16",
                                "monoisotopic_mass": "6565.1115",
                                "monoisotopic_mz": "657.5184",
                                "intensity": "39298.49",
                                "charge": "10"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "17",
                                "monoisotopic_mass": "1296.6534",
                                "monoisotopic_mz": "649.3340",
                                "intensity": "85460.87",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1296.6649",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "-0.0115",
                                        "ppm": "-8.84"
                                    }
                                }
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "18",
                                "monoisotopic_mass": "1409.7362",
                                "monoisotopic_mz": "705.8754",
                                "intensity": "55439.32",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1409.7489",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0128",
                                        "ppm": "-9.05"
                                    }
                                }
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "19",
                                "monoisotopic_mass": "3065.6346",
                                "monoisotopic_mz": "614.1342",
                                "intensity": "46795.08",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3065.6635",
                                        "ion_position": "43",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "Y00027",
                                        "ion_left_position": "43",
                                        "mass_error": "-0.0289",
                                        "ppm": "-9.43"
                                    }
                                }
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "20",
                                "monoisotopic_mass": "1563.8096",
                                "monoisotopic_mz": "522.2772",
                                "intensity": "27076.77",
                                "charge": "3"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "21",
                                "monoisotopic_mass": "1510.7826",
                                "monoisotopic_mz": "504.6015",
                                "intensity": "32966.78",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1510.7966",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "-0.0140",
                                        "ppm": "-9.29"
                                    }
                                }
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "22",
                                "monoisotopic_mass": "1492.7714",
                                "monoisotopic_mz": "498.5977",
                                "intensity": "22854.21",
                                "charge": "3"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "23",
                                "monoisotopic_mass": "1492.7743",
                                "monoisotopic_mz": "747.3944",
                                "intensity": "14612.76",
                                "charge": "2"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "24",
                                "monoisotopic_mass": "1068.5443",
                                "monoisotopic_mz": "535.2794",
                                "intensity": "91242.95",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1068.5539",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "-0.0096",
                                        "ppm": "-8.98"
                                    }
                                }
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "25",
                                "monoisotopic_mass": "1274.6642",
                                "monoisotopic_mz": "638.3394",
                                "intensity": "32920.30",
                                "charge": "2"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "26",
                                "monoisotopic_mass": "6496.0693",
                                "monoisotopic_mz": "591.5590",
                                "intensity": "17084.36",
                                "charge": "11"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "27",
                                "monoisotopic_mass": "2179.5388",
                                "monoisotopic_mz": "199.1472",
                                "intensity": "9450.38",
                                "charge": "11"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "28",
                                "monoisotopic_mass": "1122.5933",
                                "monoisotopic_mz": "375.2050",
                                "intensity": "5613.82",
                                "charge": "3"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "29",
                                "monoisotopic_mass": "4393.2056",
                                "monoisotopic_mz": "628.6081",
                                "intensity": "40767.91",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4393.2437",
                                        "ion_position": "32",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "Y00038",
                                        "ion_left_position": "32",
                                        "mass_error": "-0.0381",
                                        "ppm": "-8.67"
                                    }
                                }
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "30",
                                "monoisotopic_mass": "694.3900",
                                "monoisotopic_mz": "348.2023",
                                "intensity": "17028.62",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "694.3949",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "B00006",
                                        "ion_left_position": "6",
                                        "mass_error": "-0.0049",
                                        "ppm": "-7.00"
                                    }
                                }
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "31",
                                "monoisotopic_mass": "2035.0894",
                                "monoisotopic_mz": "679.3704",
                                "intensity": "19208.59",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2035.1075",
                                        "ion_position": "52",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "Y00018",
                                        "ion_left_position": "52",
                                        "mass_error": "-0.0181",
                                        "ppm": "-8.90"
                                    }
                                }
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "32",
                                "monoisotopic_mass": "7365.4618",
                                "monoisotopic_mz": "614.7958",
                                "intensity": "22240.28",
                                "charge": "12"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "33",
                                "monoisotopic_mass": "7646.9457",
                                "monoisotopic_mz": "638.2528",
                                "intensity": "5933.68",
                                "charge": "12"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "34",
                                "monoisotopic_mass": "1296.6552",
                                "monoisotopic_mz": "433.2257",
                                "intensity": "6953.30",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1296.6649",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "-0.0097",
                                        "ppm": "-7.46"
                                    }
                                }
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "35",
                                "monoisotopic_mass": "905.4831",
                                "monoisotopic_mz": "453.7488",
                                "intensity": "8192.81",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "905.4905",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "B00008",
                                        "ion_left_position": "8",
                                        "mass_error": "-0.0074",
                                        "ppm": "-8.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "36",
                                "monoisotopic_mass": "6781.2126",
                                "monoisotopic_mz": "617.4811",
                                "intensity": "7973.85",
                                "charge": "11"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "37",
                                "monoisotopic_mass": "7867.8708",
                                "monoisotopic_mz": "606.2281",
                                "intensity": "18542.10",
                                "charge": "13"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "38",
                                "monoisotopic_mass": "6412.0271",
                                "monoisotopic_mz": "642.2100",
                                "intensity": "57925.20",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "151.9374042885",
                                        "theoretical_mass": "6411.0323",
                                        "ion_position": "15",
                                        "ion_display_position": "55",
                                        "ion_sort_name": "Y00055",
                                        "ion_left_position": "15",
                                        "mass_error": "-0.0076",
                                        "ppm": "-1.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "39",
                                "monoisotopic_mass": "5048.3543",
                                "monoisotopic_mz": "632.0516",
                                "intensity": "19854.91",
                                "charge": "8"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "40",
                                "monoisotopic_mass": "6231.6760",
                                "monoisotopic_mz": "624.1749",
                                "intensity": "9205.17",
                                "charge": "10"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "41",
                                "monoisotopic_mass": "6910.2666",
                                "monoisotopic_mz": "629.2133",
                                "intensity": "10527.12",
                                "charge": "11"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "42",
                                "monoisotopic_mass": "6955.7600",
                                "monoisotopic_mz": "696.5833",
                                "intensity": "20745.26",
                                "charge": "10"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "43",
                                "monoisotopic_mass": "6465.4290",
                                "monoisotopic_mz": "647.5502",
                                "intensity": "17949.68",
                                "charge": "10"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "44",
                                "monoisotopic_mass": "1782.9721",
                                "monoisotopic_mz": "199.1153",
                                "intensity": "8292.94",
                                "charge": "9"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "45",
                                "monoisotopic_mass": "6647.1194",
                                "monoisotopic_mz": "665.7192",
                                "intensity": "22564.23",
                                "charge": "10"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "46",
                                "monoisotopic_mass": "3308.7515",
                                "monoisotopic_mz": "662.7576",
                                "intensity": "18730.46",
                                "charge": "5"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "47",
                                "monoisotopic_mass": "6101.0080",
                                "monoisotopic_mz": "611.1081",
                                "intensity": "13682.08",
                                "charge": "10"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "48",
                                "monoisotopic_mass": "6464.3974",
                                "monoisotopic_mz": "588.6798",
                                "intensity": "16378.08",
                                "charge": "11"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "49",
                                "monoisotopic_mass": "5847.0839",
                                "monoisotopic_mz": "650.6833",
                                "intensity": "10460.15",
                                "charge": "9"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "50",
                                "monoisotopic_mass": "3005.4843",
                                "monoisotopic_mz": "602.1041",
                                "intensity": "11047.32",
                                "charge": "5"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "51",
                                "monoisotopic_mass": "606.7435",
                                "monoisotopic_mz": "607.7507",
                                "intensity": "11641.01",
                                "charge": "1"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "52",
                                "monoisotopic_mass": "7624.9654",
                                "monoisotopic_mz": "636.4211",
                                "intensity": "15498.63",
                                "charge": "12"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "53",
                                "monoisotopic_mass": "7456.5184",
                                "monoisotopic_mz": "678.8726",
                                "intensity": "9247.44",
                                "charge": "11"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "54",
                                "monoisotopic_mass": "1050.5346",
                                "monoisotopic_mz": "526.2746",
                                "intensity": "5720.11",
                                "charge": "2"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "55",
                                "monoisotopic_mass": "6353.3570",
                                "monoisotopic_mz": "530.4537",
                                "intensity": "11706.58",
                                "charge": "12"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "56",
                                "monoisotopic_mass": "5392.4210",
                                "monoisotopic_mz": "600.1652",
                                "intensity": "5850.56",
                                "charge": "9"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "57",
                                "monoisotopic_mass": "1219.8512",
                                "monoisotopic_mz": "610.9329",
                                "intensity": "4795.07",
                                "charge": "2"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "58",
                                "monoisotopic_mass": "7688.6802",
                                "monoisotopic_mz": "641.7306",
                                "intensity": "40005.22",
                                "charge": "12"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "59",
                                "monoisotopic_mass": "3570.7838",
                                "monoisotopic_mz": "596.1379",
                                "intensity": "7321.37",
                                "charge": "6"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "60",
                                "monoisotopic_mass": "1952.3137",
                                "monoisotopic_mz": "651.7785",
                                "intensity": "8625.12",
                                "charge": "3"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "61",
                                "monoisotopic_mass": "6492.0492",
                                "monoisotopic_mz": "650.2122",
                                "intensity": "17900.71",
                                "charge": "10"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "62",
                                "monoisotopic_mass": "1232.7755",
                                "monoisotopic_mz": "617.3950",
                                "intensity": "4738.80",
                                "charge": "2"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "63",
                                "monoisotopic_mass": "3540.3015",
                                "monoisotopic_mz": "591.0575",
                                "intensity": "6904.77",
                                "charge": "6"
                            },
                            {
                                "spec_id": "307",
                                "peak_id": "64",
                                "monoisotopic_mass": "3633.0536",
                                "monoisotopic_mz": "606.5162",
                                "intensity": "6240.46",
                                "charge": "6"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "4",
                    "proteoform_id": "35",
                    "sequence_name": "sp|P66191|RL31_SALTY",
                    "sequence_description": "50S ribosomal protein L31 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmE PE=3 SV=1",
                    "proteoform_mass": "8093.9137",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "70",
                        "first_residue_position": "0",
                        "last_residue_position": "69",
                        "annotated_seq": ".MKKGIHPNYVEITAT((C)[Carbamidomethylation]S(C)[Carbamidomethylation]GNVIKTHSTVGHDL)[+151.9374]NLDV(C)[Carbamidomethylation]GK(C)[Carbamidomethylation]HPFFTGKQRVVDTGGRVERFNKRFSIPGSK.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "K"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "G"
                            },
                            {
                                "position": "4",
                                "acid": "I"
                            },
                            {
                                "position": "5",
                                "acid": "H"
                            },
                            {
                                "position": "6",
                                "acid": "P"
                            },
                            {
                                "position": "7",
                                "acid": "N"
                            },
                            {
                                "position": "8",
                                "acid": "Y"
                            },
                            {
                                "position": "9",
                                "acid": "V"
                            },
                            {
                                "position": "10",
                                "acid": "E"
                            },
                            {
                                "position": "11",
                                "acid": "I"
                            },
                            {
                                "position": "12",
                                "acid": "T"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "T"
                            },
                            {
                                "position": "15",
                                "acid": "C"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "C"
                            },
                            {
                                "position": "18",
                                "acid": "G"
                            },
                            {
                                "position": "19",
                                "acid": "N"
                            },
                            {
                                "position": "20",
                                "acid": "V"
                            },
                            {
                                "position": "21",
                                "acid": "I"
                            },
                            {
                                "position": "22",
                                "acid": "K"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "H"
                            },
                            {
                                "position": "25",
                                "acid": "S"
                            },
                            {
                                "position": "26",
                                "acid": "T"
                            },
                            {
                                "position": "27",
                                "acid": "V"
                            },
                            {
                                "position": "28",
                                "acid": "G"
                            },
                            {
                                "position": "29",
                                "acid": "H"
                            },
                            {
                                "position": "30",
                                "acid": "D"
                            },
                            {
                                "position": "31",
                                "acid": "L"
                            },
                            {
                                "position": "32",
                                "acid": "N"
                            },
                            {
                                "position": "33",
                                "acid": "L"
                            },
                            {
                                "position": "34",
                                "acid": "D"
                            },
                            {
                                "position": "35",
                                "acid": "V"
                            },
                            {
                                "position": "36",
                                "acid": "C"
                            },
                            {
                                "position": "37",
                                "acid": "G"
                            },
                            {
                                "position": "38",
                                "acid": "K"
                            },
                            {
                                "position": "39",
                                "acid": "C"
                            },
                            {
                                "position": "40",
                                "acid": "H"
                            },
                            {
                                "position": "41",
                                "acid": "P"
                            },
                            {
                                "position": "42",
                                "acid": "F"
                            },
                            {
                                "position": "43",
                                "acid": "F"
                            },
                            {
                                "position": "44",
                                "acid": "T"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "K"
                            },
                            {
                                "position": "47",
                                "acid": "Q"
                            },
                            {
                                "position": "48",
                                "acid": "R"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "V"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "T"
                            },
                            {
                                "position": "53",
                                "acid": "G"
                            },
                            {
                                "position": "54",
                                "acid": "G"
                            },
                            {
                                "position": "55",
                                "acid": "R"
                            },
                            {
                                "position": "56",
                                "acid": "V"
                            },
                            {
                                "position": "57",
                                "acid": "E"
                            },
                            {
                                "position": "58",
                                "acid": "R"
                            },
                            {
                                "position": "59",
                                "acid": "F"
                            },
                            {
                                "position": "60",
                                "acid": "N"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "R"
                            },
                            {
                                "position": "63",
                                "acid": "F"
                            },
                            {
                                "position": "64",
                                "acid": "S"
                            },
                            {
                                "position": "65",
                                "acid": "I"
                            },
                            {
                                "position": "66",
                                "acid": "P"
                            },
                            {
                                "position": "67",
                                "acid": "G"
                            },
                            {
                                "position": "68",
                                "acid": "S"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "spec_id": "307",
                                        "peak_id": "30",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "spec_id": "307",
                                        "peak_id": "35",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "spec_id": "307",
                                        "peak_id": "24",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "10",
                                        "ion_display_position": "60",
                                        "spec_id": "307",
                                        "peak_id": "2",
                                        "peak_charge": "11"
                                    }
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "11",
                                            "ion_display_position": "11",
                                            "spec_id": "307",
                                            "peak_id": "17",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "11",
                                            "ion_display_position": "11",
                                            "spec_id": "307",
                                            "peak_id": "34",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "11",
                                            "ion_display_position": "59",
                                            "spec_id": "307",
                                            "peak_id": "1",
                                            "peak_charge": "11"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "307",
                                            "peak_id": "18",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "12",
                                            "ion_display_position": "58",
                                            "spec_id": "307",
                                            "peak_id": "6",
                                            "peak_charge": "11"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "13",
                                            "ion_display_position": "13",
                                            "spec_id": "307",
                                            "peak_id": "21",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "13",
                                            "ion_display_position": "57",
                                            "spec_id": "307",
                                            "peak_id": "7",
                                            "peak_charge": "11"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "13",
                                            "ion_display_position": "57",
                                            "spec_id": "307",
                                            "peak_id": "10",
                                            "peak_charge": "10"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "14",
                                            "ion_display_position": "56",
                                            "spec_id": "307",
                                            "peak_id": "4",
                                            "peak_charge": "10"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "14",
                                            "ion_display_position": "56",
                                            "spec_id": "307",
                                            "peak_id": "0",
                                            "peak_charge": "11"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "15",
                                        "ion_display_position": "55",
                                        "spec_id": "307",
                                        "peak_id": "38",
                                        "peak_charge": "10"
                                    }
                                }
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "32",
                                        "ion_display_position": "38",
                                        "spec_id": "307",
                                        "peak_id": "29",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "27",
                                        "spec_id": "307",
                                        "peak_id": "19",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "52",
                                            "ion_display_position": "18",
                                            "spec_id": "307",
                                            "peak_id": "15",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "52",
                                            "ion_display_position": "18",
                                            "spec_id": "307",
                                            "peak_id": "31",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": [
                                {
                                    "left_pos": "15",
                                    "right_pos": "16",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "17",
                                    "right_pos": "18",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "36",
                                    "right_pos": "37",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "39",
                                    "right_pos": "40",
                                    "anno": "C"
                                }
                            ]
                        },
                        "mass_shift": {
                            "id": "0",
                            "left_position": "15",
                            "right_position": "32",
                            "shift": "151.9374042885",
                            "anno": "+151.9374",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "157",
                "p_value": "3.18e-05",
                "e_value": "3.18e-05",
                "fdr": "0",
                "matched_fragment_number": "9",
                "matched_peak_number": "9",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_2_ms2.msalign",
                        "ms1_ids": "1000308",
                        "ms1_scans": "612",
                        "ids": "1000303",
                        "scans": "613",
                        "precursor_mono_mass": "8093.9032",
                        "precursor_charge": "12",
                        "precursor_mz": "675.4992"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "1000303",
                                "peak_id": "0",
                                "monoisotopic_mass": "6583.1064",
                                "monoisotopic_mz": "732.4635",
                                "intensity": "73878.44",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "150.9395342885",
                                        "theoretical_mass": "6582.1193",
                                        "ion_position": "13",
                                        "ion_display_position": "57",
                                        "ion_sort_name": "Y00057",
                                        "ion_left_position": "13",
                                        "mass_error": "-0.0152",
                                        "ppm": "-2.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000303",
                                "peak_id": "1",
                                "monoisotopic_mass": "6411.0287",
                                "monoisotopic_mz": "713.3438",
                                "intensity": "58597.97",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "150.9395342885",
                                        "theoretical_mass": "6410.0345",
                                        "ion_position": "15",
                                        "ion_display_position": "55",
                                        "ion_sort_name": "Y00055",
                                        "ion_left_position": "15",
                                        "mass_error": "-0.0081",
                                        "ppm": "-1.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000303",
                                "peak_id": "2",
                                "monoisotopic_mass": "6512.0738",
                                "monoisotopic_mz": "724.5710",
                                "intensity": "96107.47",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "150.9395342885",
                                        "theoretical_mass": "6511.0821",
                                        "ion_position": "14",
                                        "ion_display_position": "56",
                                        "ion_sort_name": "Y00056",
                                        "ion_left_position": "14",
                                        "mass_error": "-0.0107",
                                        "ppm": "-1.65"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000303",
                                "peak_id": "3",
                                "monoisotopic_mass": "2035.0879",
                                "monoisotopic_mz": "509.7792",
                                "intensity": "69568.27",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2035.1075",
                                        "ion_position": "52",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "Y00018",
                                        "ion_left_position": "52",
                                        "mass_error": "-0.0197",
                                        "ppm": "-9.66"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000303",
                                "peak_id": "4",
                                "monoisotopic_mass": "3309.7567",
                                "monoisotopic_mz": "552.6334",
                                "intensity": "21806.81",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3309.7847",
                                        "ion_position": "41",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "Y00029",
                                        "ion_left_position": "41",
                                        "mass_error": "-0.0280",
                                        "ppm": "-8.46"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000303",
                                "peak_id": "5",
                                "monoisotopic_mass": "1492.7727",
                                "monoisotopic_mz": "747.3936",
                                "intensity": "11650.18",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000303",
                                "peak_id": "6",
                                "monoisotopic_mass": "1581.8197",
                                "monoisotopic_mz": "791.9171",
                                "intensity": "10950.90",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1581.8337",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "B00014",
                                        "ion_left_position": "14",
                                        "mass_error": "-0.0141",
                                        "ppm": "-8.88"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000303",
                                "peak_id": "7",
                                "monoisotopic_mass": "6251.0051",
                                "monoisotopic_mz": "695.5634",
                                "intensity": "14126.32",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "150.9395342885",
                                        "theoretical_mass": "6250.0038",
                                        "ion_position": "16",
                                        "ion_display_position": "54",
                                        "ion_sort_name": "Y00054",
                                        "ion_left_position": "16",
                                        "mass_error": "-0.0010",
                                        "ppm": "-0.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000303",
                                "peak_id": "8",
                                "monoisotopic_mass": "1409.7346",
                                "monoisotopic_mz": "705.8746",
                                "intensity": "20303.73",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000303",
                                "peak_id": "9",
                                "monoisotopic_mass": "4051.0482",
                                "monoisotopic_mz": "579.7284",
                                "intensity": "9630.62",
                                "charge": "7"
                            },
                            {
                                "spec_id": "1000303",
                                "peak_id": "10",
                                "monoisotopic_mass": "3065.6386",
                                "monoisotopic_mz": "614.1350",
                                "intensity": "8723.41",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3065.6635",
                                        "ion_position": "43",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "Y00027",
                                        "ion_left_position": "43",
                                        "mass_error": "-0.0249",
                                        "ppm": "-8.13"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000303",
                                "peak_id": "11",
                                "monoisotopic_mass": "1492.7729",
                                "monoisotopic_mz": "498.5982",
                                "intensity": "8553.10",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000303",
                                "peak_id": "12",
                                "monoisotopic_mass": "2179.1595",
                                "monoisotopic_mz": "199.1127",
                                "intensity": "9348.45",
                                "charge": "11"
                            },
                            {
                                "spec_id": "1000303",
                                "peak_id": "13",
                                "monoisotopic_mass": "1274.6657",
                                "monoisotopic_mz": "638.3401",
                                "intensity": "4551.02",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000303",
                                "peak_id": "14",
                                "monoisotopic_mass": "1510.7776",
                                "monoisotopic_mz": "756.3961",
                                "intensity": "9883.37",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000303",
                                "peak_id": "15",
                                "monoisotopic_mass": "6564.0953",
                                "monoisotopic_mz": "730.3512",
                                "intensity": "13433.41",
                                "charge": "9"
                            },
                            {
                                "spec_id": "1000303",
                                "peak_id": "16",
                                "monoisotopic_mass": "4202.0429",
                                "monoisotopic_mz": "601.2991",
                                "intensity": "8162.82",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "150.9395342885",
                                        "theoretical_mass": "4202.0293",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "ion_sort_name": "Y00035",
                                        "ion_left_position": "35",
                                        "mass_error": "0.0136",
                                        "ppm": "3.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000303",
                                "peak_id": "17",
                                "monoisotopic_mass": "1388.7794",
                                "monoisotopic_mz": "695.3970",
                                "intensity": "7314.92",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000303",
                                "peak_id": "18",
                                "monoisotopic_mass": "6681.1540",
                                "monoisotopic_mz": "743.3577",
                                "intensity": "9172.73",
                                "charge": "9"
                            },
                            {
                                "spec_id": "1000303",
                                "peak_id": "19",
                                "monoisotopic_mass": "6039.7887",
                                "monoisotopic_mz": "755.9809",
                                "intensity": "12502.87",
                                "charge": "8"
                            },
                            {
                                "spec_id": "1000303",
                                "peak_id": "20",
                                "monoisotopic_mass": "1387.2161",
                                "monoisotopic_mz": "199.1810",
                                "intensity": "2621.30",
                                "charge": "7"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "4",
                    "proteoform_id": "35",
                    "sequence_name": "sp|P66191|RL31_SALTY",
                    "sequence_description": "50S ribosomal protein L31 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmE PE=3 SV=1",
                    "proteoform_mass": "8092.9159",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "70",
                        "first_residue_position": "0",
                        "last_residue_position": "69",
                        "annotated_seq": ".MKKGIHPNYVEITAT(C)[Carbamidomethylation]S(C)[Carbamidomethylation]GNVIKTHSTVGHDLNLD(V(C)[Carbamidomethylation]GK(C)[Carbamidomethylation]H)[+150.9395]PFFTGKQRVVDTGGRVERFNKRFSIPGSK.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "K"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "G"
                            },
                            {
                                "position": "4",
                                "acid": "I"
                            },
                            {
                                "position": "5",
                                "acid": "H"
                            },
                            {
                                "position": "6",
                                "acid": "P"
                            },
                            {
                                "position": "7",
                                "acid": "N"
                            },
                            {
                                "position": "8",
                                "acid": "Y"
                            },
                            {
                                "position": "9",
                                "acid": "V"
                            },
                            {
                                "position": "10",
                                "acid": "E"
                            },
                            {
                                "position": "11",
                                "acid": "I"
                            },
                            {
                                "position": "12",
                                "acid": "T"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "T"
                            },
                            {
                                "position": "15",
                                "acid": "C"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "C"
                            },
                            {
                                "position": "18",
                                "acid": "G"
                            },
                            {
                                "position": "19",
                                "acid": "N"
                            },
                            {
                                "position": "20",
                                "acid": "V"
                            },
                            {
                                "position": "21",
                                "acid": "I"
                            },
                            {
                                "position": "22",
                                "acid": "K"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "H"
                            },
                            {
                                "position": "25",
                                "acid": "S"
                            },
                            {
                                "position": "26",
                                "acid": "T"
                            },
                            {
                                "position": "27",
                                "acid": "V"
                            },
                            {
                                "position": "28",
                                "acid": "G"
                            },
                            {
                                "position": "29",
                                "acid": "H"
                            },
                            {
                                "position": "30",
                                "acid": "D"
                            },
                            {
                                "position": "31",
                                "acid": "L"
                            },
                            {
                                "position": "32",
                                "acid": "N"
                            },
                            {
                                "position": "33",
                                "acid": "L"
                            },
                            {
                                "position": "34",
                                "acid": "D"
                            },
                            {
                                "position": "35",
                                "acid": "V"
                            },
                            {
                                "position": "36",
                                "acid": "C"
                            },
                            {
                                "position": "37",
                                "acid": "G"
                            },
                            {
                                "position": "38",
                                "acid": "K"
                            },
                            {
                                "position": "39",
                                "acid": "C"
                            },
                            {
                                "position": "40",
                                "acid": "H"
                            },
                            {
                                "position": "41",
                                "acid": "P"
                            },
                            {
                                "position": "42",
                                "acid": "F"
                            },
                            {
                                "position": "43",
                                "acid": "F"
                            },
                            {
                                "position": "44",
                                "acid": "T"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "K"
                            },
                            {
                                "position": "47",
                                "acid": "Q"
                            },
                            {
                                "position": "48",
                                "acid": "R"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "V"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "T"
                            },
                            {
                                "position": "53",
                                "acid": "G"
                            },
                            {
                                "position": "54",
                                "acid": "G"
                            },
                            {
                                "position": "55",
                                "acid": "R"
                            },
                            {
                                "position": "56",
                                "acid": "V"
                            },
                            {
                                "position": "57",
                                "acid": "E"
                            },
                            {
                                "position": "58",
                                "acid": "R"
                            },
                            {
                                "position": "59",
                                "acid": "F"
                            },
                            {
                                "position": "60",
                                "acid": "N"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "R"
                            },
                            {
                                "position": "63",
                                "acid": "F"
                            },
                            {
                                "position": "64",
                                "acid": "S"
                            },
                            {
                                "position": "65",
                                "acid": "I"
                            },
                            {
                                "position": "66",
                                "acid": "P"
                            },
                            {
                                "position": "67",
                                "acid": "G"
                            },
                            {
                                "position": "68",
                                "acid": "S"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "13",
                                        "ion_display_position": "57",
                                        "spec_id": "1000303",
                                        "peak_id": "0",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "14",
                                            "ion_display_position": "14",
                                            "spec_id": "1000303",
                                            "peak_id": "6",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "14",
                                            "ion_display_position": "56",
                                            "spec_id": "1000303",
                                            "peak_id": "2",
                                            "peak_charge": "9"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "15",
                                        "ion_display_position": "55",
                                        "spec_id": "1000303",
                                        "peak_id": "1",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "16",
                                        "ion_display_position": "54",
                                        "spec_id": "1000303",
                                        "peak_id": "7",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "spec_id": "1000303",
                                        "peak_id": "16",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "41",
                                        "ion_display_position": "29",
                                        "spec_id": "1000303",
                                        "peak_id": "4",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "27",
                                        "spec_id": "1000303",
                                        "peak_id": "10",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "52",
                                        "ion_display_position": "18",
                                        "spec_id": "1000303",
                                        "peak_id": "3",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": [
                                {
                                    "left_pos": "15",
                                    "right_pos": "16",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "17",
                                    "right_pos": "18",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "36",
                                    "right_pos": "37",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "39",
                                    "right_pos": "40",
                                    "anno": "C"
                                }
                            ]
                        },
                        "mass_shift": {
                            "id": "0",
                            "left_position": "35",
                            "right_position": "41",
                            "shift": "150.9395342885",
                            "anno": "+150.9395",
                            "shift_type": "unexpected"
                        }
                    }
                }
            }
        ]
    }
}
