prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "10",
        "sequence_name": "sp|P0A7Q8|RL36_SALTY",
        "sequence_description": "50S ribosomal protein L36 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmJ PE=3 SV=1",
        "proteoform_id": "12",
        "prsm_number": "7",
        "prsm": [
            {
                "prsm_id": "0",
                "p_value": "4.01e-14",
                "e_value": "4.01e-14",
                "fdr": "0",
                "matched_fragment_number": "17",
                "matched_peak_number": "19",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                        "ms1_ids": "172",
                        "ms1_scans": "330",
                        "ids": "157",
                        "scans": "331",
                        "precursor_mono_mass": "4532.4737",
                        "precursor_charge": "8",
                        "precursor_mz": "567.5665"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "157",
                                "peak_id": "0",
                                "monoisotopic_mass": "4256.3156",
                                "monoisotopic_mz": "609.0524",
                                "intensity": "160487.24",
                                "charge": "7"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "1",
                                "monoisotopic_mass": "4401.4327",
                                "monoisotopic_mz": "629.7834",
                                "intensity": "2300854.92",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4401.4736",
                                        "ion_position": "1",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "Y00037",
                                        "ion_left_position": "1",
                                        "mass_error": "-0.0410",
                                        "ppm": "-9.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "2",
                                "monoisotopic_mass": "4273.3379",
                                "monoisotopic_mz": "611.4841",
                                "intensity": "1896920.75",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4273.3787",
                                        "ion_position": "2",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "Y00036",
                                        "ion_left_position": "2",
                                        "mass_error": "-0.0408",
                                        "ppm": "-9.55"
                                    }
                                }
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "3",
                                "monoisotopic_mass": "3554.9265",
                                "monoisotopic_mz": "711.9926",
                                "intensity": "804916.06",
                                "charge": "5"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "4",
                                "monoisotopic_mass": "3632.9370",
                                "monoisotopic_mz": "727.5947",
                                "intensity": "395123.16",
                                "charge": "5"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "5",
                                "monoisotopic_mass": "3424.8895",
                                "monoisotopic_mz": "857.2296",
                                "intensity": "598546.66",
                                "charge": "4"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "6",
                                "monoisotopic_mass": "3406.8587",
                                "monoisotopic_mz": "852.7220",
                                "intensity": "190415.85",
                                "charge": "4"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "7",
                                "monoisotopic_mass": "3336.8385",
                                "monoisotopic_mz": "668.3750",
                                "intensity": "400238.47",
                                "charge": "5"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "8",
                                "monoisotopic_mass": "3768.0836",
                                "monoisotopic_mz": "629.0212",
                                "intensity": "199624.49",
                                "charge": "6"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "9",
                                "monoisotopic_mass": "752.3976",
                                "monoisotopic_mz": "753.4048",
                                "intensity": "470945.40",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "752.4042",
                                        "ion_position": "32",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "32",
                                        "mass_error": "-0.0066",
                                        "ppm": "-8.77"
                                    }
                                }
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "10",
                                "monoisotopic_mass": "2527.3007",
                                "monoisotopic_mz": "843.4408",
                                "intensity": "191060.24",
                                "charge": "3"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "11",
                                "monoisotopic_mass": "2062.1037",
                                "monoisotopic_mz": "688.3752",
                                "intensity": "165668.93",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2062.1218",
                                        "ion_position": "20",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "Y00018",
                                        "ion_left_position": "20",
                                        "mass_error": "-0.0181",
                                        "ppm": "-8.78"
                                    }
                                }
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "12",
                                "monoisotopic_mass": "3354.8484",
                                "monoisotopic_mz": "671.9770",
                                "intensity": "576322.99",
                                "charge": "5"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "13",
                                "monoisotopic_mass": "4384.4082",
                                "monoisotopic_mz": "627.3513",
                                "intensity": "726018.17",
                                "charge": "7"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "14",
                                "monoisotopic_mass": "3308.8454",
                                "monoisotopic_mz": "662.7764",
                                "intensity": "143721.69",
                                "charge": "5"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "15",
                                "monoisotopic_mass": "3267.8215",
                                "monoisotopic_mz": "654.5716",
                                "intensity": "208679.81",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3267.8505",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "B00027",
                                        "ion_left_position": "27",
                                        "mass_error": "-0.0290",
                                        "ppm": "-8.87"
                                    }
                                }
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "16",
                                "monoisotopic_mass": "3504.8487",
                                "monoisotopic_mz": "701.9770",
                                "intensity": "551135.60",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3504.8817",
                                        "ion_position": "9",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "Y00029",
                                        "ion_left_position": "9",
                                        "mass_error": "-0.0330",
                                        "ppm": "-9.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "17",
                                "monoisotopic_mass": "2655.4022",
                                "monoisotopic_mz": "886.1413",
                                "intensity": "186445.73",
                                "charge": "3"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "18",
                                "monoisotopic_mass": "615.3404",
                                "monoisotopic_mz": "616.3477",
                                "intensity": "565026.75",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "615.3453",
                                        "ion_position": "33",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "Y00005",
                                        "ion_left_position": "33",
                                        "mass_error": "-0.0049",
                                        "ppm": "-7.93"
                                    }
                                }
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "19",
                                "monoisotopic_mass": "3632.9408",
                                "monoisotopic_mz": "606.4974",
                                "intensity": "277590.87",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3632.9766",
                                        "ion_position": "8",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "Y00030",
                                        "ion_left_position": "8",
                                        "mass_error": "-0.0358",
                                        "ppm": "-9.86"
                                    }
                                }
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "20",
                                "monoisotopic_mass": "3407.8702",
                                "monoisotopic_mz": "682.5813",
                                "intensity": "265068.76",
                                "charge": "5"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "21",
                                "monoisotopic_mass": "3295.7860",
                                "monoisotopic_mz": "660.1645",
                                "intensity": "168313.50",
                                "charge": "5"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "22",
                                "monoisotopic_mass": "1859.0035",
                                "monoisotopic_mz": "620.6751",
                                "intensity": "103523.43",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1859.0168",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "B00015",
                                        "ion_left_position": "15",
                                        "mass_error": "-0.0133",
                                        "ppm": "-7.17"
                                    }
                                }
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "23",
                                "monoisotopic_mass": "3425.8869",
                                "monoisotopic_mz": "686.1847",
                                "intensity": "933166.19",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3425.9196",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "-0.0327",
                                        "ppm": "-9.56"
                                    }
                                }
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "24",
                                "monoisotopic_mass": "3354.8516",
                                "monoisotopic_mz": "839.7202",
                                "intensity": "172995.38",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3354.8825",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0310",
                                        "ppm": "-9.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "25",
                                "monoisotopic_mass": "771.4331",
                                "monoisotopic_mz": "772.4404",
                                "intensity": "51889.22",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "771.4425",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "B00007",
                                        "ion_left_position": "7",
                                        "mass_error": "-0.0094",
                                        "ppm": "-12.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "26",
                                "monoisotopic_mass": "977.5431",
                                "monoisotopic_mz": "489.7788",
                                "intensity": "1426250.04",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "977.5519",
                                        "ion_position": "30",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0088",
                                        "ppm": "-8.97"
                                    }
                                }
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "27",
                                "monoisotopic_mass": "4046.2348",
                                "monoisotopic_mz": "579.0408",
                                "intensity": "61404.92",
                                "charge": "7"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "28",
                                "monoisotopic_mass": "3166.7651",
                                "monoisotopic_mz": "792.6986",
                                "intensity": "160582.07",
                                "charge": "4"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "29",
                                "monoisotopic_mass": "2673.4729",
                                "monoisotopic_mz": "669.3755",
                                "intensity": "272942.90",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2673.4973",
                                        "ion_position": "15",
                                        "ion_display_position": "23",
                                        "ion_sort_name": "Y00023",
                                        "ion_left_position": "15",
                                        "mass_error": "-0.0244",
                                        "ppm": "-9.13"
                                    }
                                }
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "30",
                                "monoisotopic_mass": "3336.8389",
                                "monoisotopic_mz": "835.2170",
                                "intensity": "180999.44",
                                "charge": "4"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "31",
                                "monoisotopic_mass": "752.3977",
                                "monoisotopic_mz": "377.2061",
                                "intensity": "603323.47",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "752.4042",
                                        "ion_position": "32",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "32",
                                        "mass_error": "-0.0064",
                                        "ppm": "-8.55"
                                    }
                                }
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "32",
                                "monoisotopic_mass": "3295.7849",
                                "monoisotopic_mz": "824.9535",
                                "intensity": "245196.09",
                                "charge": "4"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "33",
                                "monoisotopic_mass": "487.2461",
                                "monoisotopic_mz": "488.2534",
                                "intensity": "416110.11",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "487.2503",
                                        "ion_position": "34",
                                        "ion_display_position": "4",
                                        "ion_sort_name": "Y00004",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0042",
                                        "ppm": "-8.59"
                                    }
                                }
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "34",
                                "monoisotopic_mass": "3487.8283",
                                "monoisotopic_mz": "698.5729",
                                "intensity": "61299.18",
                                "charge": "5"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "35",
                                "monoisotopic_mass": "3177.8104",
                                "monoisotopic_mz": "636.5694",
                                "intensity": "105156.10",
                                "charge": "5"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "36",
                                "monoisotopic_mass": "977.5435",
                                "monoisotopic_mz": "326.8551",
                                "intensity": "109213.96",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "977.5519",
                                        "ion_position": "30",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0084",
                                        "ppm": "-8.61"
                                    }
                                }
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "37",
                                "monoisotopic_mass": "3554.9298",
                                "monoisotopic_mz": "889.7397",
                                "intensity": "121031.33",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3554.9622",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0324",
                                        "ppm": "-9.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "38",
                                "monoisotopic_mass": "768.4892",
                                "monoisotopic_mz": "385.2519",
                                "intensity": "51742.00",
                                "charge": "2"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "39",
                                "monoisotopic_mass": "2560.3896",
                                "monoisotopic_mz": "641.1047",
                                "intensity": "193287.06",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2560.4132",
                                        "ion_position": "16",
                                        "ion_display_position": "22",
                                        "ion_sort_name": "Y00022",
                                        "ion_left_position": "16",
                                        "mass_error": "-0.0236",
                                        "ppm": "-9.22"
                                    }
                                }
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "40",
                                "monoisotopic_mass": "1582.8482",
                                "monoisotopic_mz": "792.4314",
                                "intensity": "61814.31",
                                "charge": "2"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "41",
                                "monoisotopic_mass": "3899.1348",
                                "monoisotopic_mz": "650.8631",
                                "intensity": "129476.23",
                                "charge": "6"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "42",
                                "monoisotopic_mass": "4367.3773",
                                "monoisotopic_mz": "624.9183",
                                "intensity": "129839.19",
                                "charge": "7"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "43",
                                "monoisotopic_mass": "1234.6891",
                                "monoisotopic_mz": "618.3518",
                                "intensity": "25187.76",
                                "charge": "2"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "44",
                                "monoisotopic_mass": "2999.5765",
                                "monoisotopic_mz": "750.9014",
                                "intensity": "64375.92",
                                "charge": "4"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "45",
                                "monoisotopic_mass": "2176.1302",
                                "monoisotopic_mz": "726.3840",
                                "intensity": "103218.76",
                                "charge": "3"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "46",
                                "monoisotopic_mass": "1264.6439",
                                "monoisotopic_mz": "633.3292",
                                "intensity": "33129.61",
                                "charge": "2"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "47",
                                "monoisotopic_mass": "3614.9016",
                                "monoisotopic_mz": "603.4909",
                                "intensity": "72985.94",
                                "charge": "6"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "48",
                                "monoisotopic_mass": "848.4657",
                                "monoisotopic_mz": "849.4730",
                                "intensity": "64127.02",
                                "charge": "1"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "49",
                                "monoisotopic_mass": "640.3962",
                                "monoisotopic_mz": "641.4034",
                                "intensity": "128542.67",
                                "charge": "1"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "50",
                                "monoisotopic_mass": "3245.8353",
                                "monoisotopic_mz": "650.1743",
                                "intensity": "81539.31",
                                "charge": "5"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "51",
                                "monoisotopic_mass": "1213.6657",
                                "monoisotopic_mz": "607.8401",
                                "intensity": "62627.99",
                                "charge": "2"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "52",
                                "monoisotopic_mass": "1386.7575",
                                "monoisotopic_mz": "199.1155",
                                "intensity": "32138.72",
                                "charge": "7"
                            },
                            {
                                "spec_id": "157",
                                "peak_id": "53",
                                "monoisotopic_mass": "685.1734",
                                "monoisotopic_mz": "686.1807",
                                "intensity": "95396.12",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "10",
                    "proteoform_id": "12",
                    "sequence_name": "sp|P0A7Q8|RL36_SALTY",
                    "sequence_description": "50S ribosomal protein L36 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmJ PE=3 SV=1",
                    "proteoform_mass": "4532.5141",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "38",
                        "first_residue_position": "0",
                        "last_residue_position": "37",
                        "annotated_seq": ".MKVRASVKKL(C)[Carbamidomethylation]RN(C)[Carbamidomethylation]KIVKRDGVIRVI(C)[Carbamidomethylation]SAEPKHKQRQG.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "K"
                            },
                            {
                                "position": "2",
                                "acid": "V"
                            },
                            {
                                "position": "3",
                                "acid": "R"
                            },
                            {
                                "position": "4",
                                "acid": "A"
                            },
                            {
                                "position": "5",
                                "acid": "S"
                            },
                            {
                                "position": "6",
                                "acid": "V"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "L"
                            },
                            {
                                "position": "10",
                                "acid": "C"
                            },
                            {
                                "position": "11",
                                "acid": "R"
                            },
                            {
                                "position": "12",
                                "acid": "N"
                            },
                            {
                                "position": "13",
                                "acid": "C"
                            },
                            {
                                "position": "14",
                                "acid": "K"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "V"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "R"
                            },
                            {
                                "position": "19",
                                "acid": "D"
                            },
                            {
                                "position": "20",
                                "acid": "G"
                            },
                            {
                                "position": "21",
                                "acid": "V"
                            },
                            {
                                "position": "22",
                                "acid": "I"
                            },
                            {
                                "position": "23",
                                "acid": "R"
                            },
                            {
                                "position": "24",
                                "acid": "V"
                            },
                            {
                                "position": "25",
                                "acid": "I"
                            },
                            {
                                "position": "26",
                                "acid": "C"
                            },
                            {
                                "position": "27",
                                "acid": "S"
                            },
                            {
                                "position": "28",
                                "acid": "A"
                            },
                            {
                                "position": "29",
                                "acid": "E"
                            },
                            {
                                "position": "30",
                                "acid": "P"
                            },
                            {
                                "position": "31",
                                "acid": "K"
                            },
                            {
                                "position": "32",
                                "acid": "H"
                            },
                            {
                                "position": "33",
                                "acid": "K"
                            },
                            {
                                "position": "34",
                                "acid": "Q"
                            },
                            {
                                "position": "35",
                                "acid": "R"
                            },
                            {
                                "position": "36",
                                "acid": "Q"
                            },
                            {
                                "position": "37",
                                "acid": "G"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "1",
                                        "ion_display_position": "37",
                                        "spec_id": "157",
                                        "peak_id": "1",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "2",
                                        "ion_display_position": "36",
                                        "spec_id": "157",
                                        "peak_id": "2",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "spec_id": "157",
                                        "peak_id": "25",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "8",
                                        "ion_display_position": "30",
                                        "spec_id": "157",
                                        "peak_id": "19",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "9",
                                        "ion_display_position": "29",
                                        "spec_id": "157",
                                        "peak_id": "16",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "15",
                                            "ion_display_position": "15",
                                            "spec_id": "157",
                                            "peak_id": "22",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "15",
                                            "ion_display_position": "23",
                                            "spec_id": "157",
                                            "peak_id": "29",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "16",
                                        "ion_display_position": "22",
                                        "spec_id": "157",
                                        "peak_id": "39",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "20",
                                        "ion_display_position": "18",
                                        "spec_id": "157",
                                        "peak_id": "11",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "spec_id": "157",
                                        "peak_id": "15",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "157",
                                        "peak_id": "24",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "spec_id": "157",
                                        "peak_id": "23",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "30",
                                            "ion_display_position": "8",
                                            "spec_id": "157",
                                            "peak_id": "26",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "30",
                                            "ion_display_position": "8",
                                            "spec_id": "157",
                                            "peak_id": "36",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "30",
                                            "ion_display_position": "30",
                                            "spec_id": "157",
                                            "peak_id": "37",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "32",
                                            "ion_display_position": "6",
                                            "spec_id": "157",
                                            "peak_id": "9",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "32",
                                            "ion_display_position": "6",
                                            "spec_id": "157",
                                            "peak_id": "31",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "33",
                                        "ion_display_position": "5",
                                        "spec_id": "157",
                                        "peak_id": "18",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "34",
                                        "ion_display_position": "4",
                                        "spec_id": "157",
                                        "peak_id": "33",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": [
                                {
                                    "left_pos": "10",
                                    "right_pos": "11",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "13",
                                    "right_pos": "14",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "26",
                                    "right_pos": "27",
                                    "anno": "C"
                                }
                            ]
                        }
                    }
                }
            },
            {
                "prsm_id": "133",
                "p_value": "3.71e-13",
                "e_value": "3.71e-13",
                "fdr": "0",
                "matched_fragment_number": "20",
                "matched_peak_number": "23",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_2_ms2.msalign",
                        "ms1_ids": "1000219",
                        "ms1_scans": "434",
                        "ids": "1000214",
                        "scans": "435",
                        "precursor_mono_mass": "6250.5424",
                        "precursor_charge": "9",
                        "precursor_mz": "695.5120"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "1000214",
                                "peak_id": "0",
                                "monoisotopic_mass": "4443.4733",
                                "monoisotopic_mz": "889.7019",
                                "intensity": "73585.26",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0374908038",
                                        "theoretical_mass": "4443.4992",
                                        "ion_position": "40",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "B00040",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0259",
                                        "ppm": "-5.82"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "1",
                                "monoisotopic_mass": "6037.3834",
                                "monoisotopic_mz": "755.6802",
                                "intensity": "122243.21",
                                "charge": "8"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "2",
                                "monoisotopic_mass": "6147.4634",
                                "monoisotopic_mz": "769.4402",
                                "intensity": "56384.41",
                                "charge": "8"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "3",
                                "monoisotopic_mass": "4443.4715",
                                "monoisotopic_mz": "741.5859",
                                "intensity": "898301.35",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0374908038",
                                        "theoretical_mass": "4443.4992",
                                        "ion_position": "40",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "B00040",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0276",
                                        "ppm": "-6.22"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "4",
                                "monoisotopic_mass": "4755.6220",
                                "monoisotopic_mz": "793.6109",
                                "intensity": "48086.56",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "5",
                                "monoisotopic_mass": "6165.4825",
                                "monoisotopic_mz": "771.6926",
                                "intensity": "69312.60",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6165.5423",
                                        "ion_position": "2",
                                        "ion_display_position": "53",
                                        "ion_sort_name": "Y00053",
                                        "ion_left_position": "2",
                                        "mass_error": "-0.0598",
                                        "ppm": "-9.70"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "6",
                                "monoisotopic_mass": "3193.6607",
                                "monoisotopic_mz": "1065.5608",
                                "intensity": "71638.75",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "7",
                                "monoisotopic_mass": "2596.4135",
                                "monoisotopic_mz": "866.4784",
                                "intensity": "77215.37",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "8",
                                "monoisotopic_mass": "1807.0674",
                                "monoisotopic_mz": "904.5410",
                                "intensity": "108953.34",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1807.0832",
                                        "ion_position": "40",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0158",
                                        "ppm": "-8.75"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "9",
                                "monoisotopic_mass": "1678.9747",
                                "monoisotopic_mz": "840.4946",
                                "intensity": "25944.78",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "10",
                                "monoisotopic_mass": "5159.8711",
                                "monoisotopic_mz": "860.9858",
                                "intensity": "82026.34",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0374908038",
                                        "theoretical_mass": "5159.9074",
                                        "ion_position": "46",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "B00046",
                                        "ion_left_position": "46",
                                        "mass_error": "-0.0362",
                                        "ppm": "-7.03"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "11",
                                "monoisotopic_mass": "1642.9514",
                                "monoisotopic_mz": "822.4830",
                                "intensity": "39020.09",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "12",
                                "monoisotopic_mass": "6122.4516",
                                "monoisotopic_mz": "766.3137",
                                "intensity": "62255.28",
                                "charge": "8"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "13",
                                "monoisotopic_mass": "1710.0003",
                                "monoisotopic_mz": "856.0074",
                                "intensity": "60075.94",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0374908038",
                                        "theoretical_mass": "1710.0025",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "B00018",
                                        "ion_left_position": "18",
                                        "mass_error": "-0.0022",
                                        "ppm": "-1.29"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "14",
                                "monoisotopic_mass": "4256.4062",
                                "monoisotopic_mz": "852.2885",
                                "intensity": "119961.74",
                                "charge": "5"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "15",
                                "monoisotopic_mass": "878.5146",
                                "monoisotopic_mz": "879.5219",
                                "intensity": "44123.76",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "878.5226",
                                        "ion_position": "48",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "48",
                                        "mass_error": "-0.0079",
                                        "ppm": "-9.01"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "16",
                                "monoisotopic_mass": "1547.8795",
                                "monoisotopic_mz": "774.9470",
                                "intensity": "47499.65",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "17",
                                "monoisotopic_mass": "1789.0570",
                                "monoisotopic_mz": "597.3596",
                                "intensity": "235158.57",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "18",
                                "monoisotopic_mass": "4358.4158",
                                "monoisotopic_mz": "872.6904",
                                "intensity": "51631.20",
                                "charge": "5"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "19",
                                "monoisotopic_mass": "1807.0671",
                                "monoisotopic_mz": "603.3630",
                                "intensity": "519955.06",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1807.0832",
                                        "ion_position": "40",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0161",
                                        "ppm": "-8.93"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "20",
                                "monoisotopic_mass": "3812.1063",
                                "monoisotopic_mz": "763.4285",
                                "intensity": "88495.24",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0374908038",
                                        "theoretical_mass": "3812.1298",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "ion_sort_name": "B00035",
                                        "ion_left_position": "35",
                                        "mass_error": "-0.0235",
                                        "ppm": "-6.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "21",
                                "monoisotopic_mass": "3106.6299",
                                "monoisotopic_mz": "1036.5506",
                                "intensity": "40244.14",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "22",
                                "monoisotopic_mass": "6019.3575",
                                "monoisotopic_mz": "753.4270",
                                "intensity": "64349.49",
                                "charge": "8"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "23",
                                "monoisotopic_mass": "5000.7257",
                                "monoisotopic_mz": "834.4616",
                                "intensity": "80877.53",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5000.7716",
                                        "ion_position": "12",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "Y00043",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0459",
                                        "ppm": "-9.18"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "24",
                                "monoisotopic_mass": "2438.4268",
                                "monoisotopic_mz": "610.6140",
                                "intensity": "45020.32",
                                "charge": "4"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "25",
                                "monoisotopic_mass": "1150.7445",
                                "monoisotopic_mz": "576.3795",
                                "intensity": "29934.11",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0374908038",
                                        "theoretical_mass": "1150.7424",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "0.0021",
                                        "ppm": "1.84"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "26",
                                "monoisotopic_mass": "1249.8120",
                                "monoisotopic_mz": "625.9133",
                                "intensity": "45351.61",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0374908038",
                                        "theoretical_mass": "1249.8108",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0012",
                                        "ppm": "0.98"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "27",
                                "monoisotopic_mass": "2948.5583",
                                "monoisotopic_mz": "983.8600",
                                "intensity": "46136.90",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "28",
                                "monoisotopic_mass": "3175.6483",
                                "monoisotopic_mz": "1059.5567",
                                "intensity": "23188.75",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "29",
                                "monoisotopic_mass": "1660.9636",
                                "monoisotopic_mz": "831.4891",
                                "intensity": "87584.13",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "30",
                                "monoisotopic_mass": "4426.4658",
                                "monoisotopic_mz": "738.7516",
                                "intensity": "111092.14",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "31",
                                "monoisotopic_mass": "1847.0573",
                                "monoisotopic_mz": "616.6930",
                                "intensity": "56713.59",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0374908038",
                                        "theoretical_mass": "1847.0615",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "B00019",
                                        "ion_left_position": "19",
                                        "mass_error": "-0.0041",
                                        "ppm": "-2.25"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "32",
                                "monoisotopic_mass": "3569.9881",
                                "monoisotopic_mz": "715.0049",
                                "intensity": "45703.55",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0374908038",
                                        "theoretical_mass": "3570.0032",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "ion_sort_name": "B00033",
                                        "ion_left_position": "33",
                                        "mass_error": "-0.0150",
                                        "ppm": "-4.21"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "33",
                                "monoisotopic_mass": "1132.7347",
                                "monoisotopic_mz": "567.3746",
                                "intensity": "27581.36",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "34",
                                "monoisotopic_mass": "4230.3378",
                                "monoisotopic_mz": "847.0748",
                                "intensity": "87741.98",
                                "charge": "5"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "35",
                                "monoisotopic_mass": "928.5528",
                                "monoisotopic_mz": "929.5601",
                                "intensity": "15494.93",
                                "charge": "1"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "36",
                                "monoisotopic_mass": "1037.6620",
                                "monoisotopic_mz": "519.8383",
                                "intensity": "39712.53",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0374908038",
                                        "theoretical_mass": "1037.6583",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0037",
                                        "ppm": "3.53"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "37",
                                "monoisotopic_mass": "5992.3448",
                                "monoisotopic_mz": "750.0504",
                                "intensity": "19674.05",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0374908038",
                                        "theoretical_mass": "5991.3928",
                                        "ion_position": "53",
                                        "ion_display_position": "53",
                                        "ion_sort_name": "B00053",
                                        "ion_left_position": "53",
                                        "mass_error": "-0.0504",
                                        "ppm": "-8.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "38",
                                "monoisotopic_mass": "1494.9116",
                                "monoisotopic_mz": "748.4631",
                                "intensity": "18449.90",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0374908038",
                                        "theoretical_mass": "1494.9119",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "B00015",
                                        "ion_left_position": "15",
                                        "mass_error": "-0.0004",
                                        "ppm": "-0.24"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "39",
                                "monoisotopic_mass": "716.4020",
                                "monoisotopic_mz": "717.4092",
                                "intensity": "30024.57",
                                "charge": "1"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "40",
                                "monoisotopic_mass": "796.4863",
                                "monoisotopic_mz": "797.4936",
                                "intensity": "15733.79",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0374908038",
                                        "theoretical_mass": "796.4793",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "B00008",
                                        "ion_left_position": "8",
                                        "mass_error": "0.0070",
                                        "ppm": "8.84"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "41",
                                "monoisotopic_mass": "991.5992",
                                "monoisotopic_mz": "992.6065",
                                "intensity": "24152.10",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "991.6066",
                                        "ion_position": "47",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0074",
                                        "ppm": "-7.45"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "42",
                                "monoisotopic_mass": "4403.4787",
                                "monoisotopic_mz": "881.7030",
                                "intensity": "56635.94",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4403.5209",
                                        "ion_position": "19",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "Y00036",
                                        "ion_left_position": "19",
                                        "mass_error": "-0.0423",
                                        "ppm": "-9.60"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "43",
                                "monoisotopic_mass": "2449.3467",
                                "monoisotopic_mz": "817.4562",
                                "intensity": "62456.00",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "44",
                                "monoisotopic_mass": "569.3484",
                                "monoisotopic_mz": "570.3557",
                                "intensity": "16166.04",
                                "charge": "1"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "45",
                                "monoisotopic_mass": "4404.4827",
                                "monoisotopic_mz": "735.0877",
                                "intensity": "33698.87",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "46",
                                "monoisotopic_mass": "815.4705",
                                "monoisotopic_mz": "408.7425",
                                "intensity": "29305.85",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "47",
                                "monoisotopic_mass": "1164.7604",
                                "monoisotopic_mz": "583.3875",
                                "intensity": "18641.89",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "48",
                                "monoisotopic_mass": "928.5533",
                                "monoisotopic_mz": "465.2839",
                                "intensity": "13573.03",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "49",
                                "monoisotopic_mass": "2197.2533",
                                "monoisotopic_mz": "733.4250",
                                "intensity": "53743.12",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2197.2735",
                                        "ion_position": "37",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "Y00018",
                                        "ion_left_position": "37",
                                        "mass_error": "-0.0202",
                                        "ppm": "-9.21"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "50",
                                "monoisotopic_mass": "1249.8135",
                                "monoisotopic_mz": "417.6118",
                                "intensity": "13097.71",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0374908038",
                                        "theoretical_mass": "1249.8108",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0028",
                                        "ppm": "2.21"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "51",
                                "monoisotopic_mass": "1065.6875",
                                "monoisotopic_mz": "533.8510",
                                "intensity": "8221.87",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "52",
                                "monoisotopic_mass": "1419.7875",
                                "monoisotopic_mz": "710.9010",
                                "intensity": "11244.26",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "53",
                                "monoisotopic_mass": "4093.3493",
                                "monoisotopic_mz": "819.6771",
                                "intensity": "59493.44",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4093.3892",
                                        "ion_position": "21",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "Y00034",
                                        "ion_left_position": "21",
                                        "mass_error": "-0.0399",
                                        "ppm": "-9.75"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "54",
                                "monoisotopic_mass": "4825.6618",
                                "monoisotopic_mz": "966.1396",
                                "intensity": "18259.63",
                                "charge": "5"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "55",
                                "monoisotopic_mass": "4739.6168",
                                "monoisotopic_mz": "790.9434",
                                "intensity": "24486.39",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "56",
                                "monoisotopic_mass": "3192.6561",
                                "monoisotopic_mz": "799.1713",
                                "intensity": "36227.45",
                                "charge": "4"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "57",
                                "monoisotopic_mass": "4341.4271",
                                "monoisotopic_mz": "869.2927",
                                "intensity": "11949.19",
                                "charge": "5"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "58",
                                "monoisotopic_mass": "4052.2767",
                                "monoisotopic_mz": "811.4626",
                                "intensity": "16432.73",
                                "charge": "5"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "59",
                                "monoisotopic_mass": "1221.7113",
                                "monoisotopic_mz": "611.8629",
                                "intensity": "4114.87",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "60",
                                "monoisotopic_mass": "4756.6315",
                                "monoisotopic_mz": "952.3336",
                                "intensity": "14375.25",
                                "charge": "5"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "61",
                                "monoisotopic_mass": "848.2711",
                                "monoisotopic_mz": "849.2784",
                                "intensity": "7690.90",
                                "charge": "1"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "62",
                                "monoisotopic_mass": "5132.8971",
                                "monoisotopic_mz": "734.2783",
                                "intensity": "11943.61",
                                "charge": "7"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "63",
                                "monoisotopic_mass": "1092.6152",
                                "monoisotopic_mz": "1093.6224",
                                "intensity": "10902.95",
                                "charge": "1"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "64",
                                "monoisotopic_mass": "4386.4667",
                                "monoisotopic_mz": "732.0851",
                                "intensity": "23252.09",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "65",
                                "monoisotopic_mass": "4384.4694",
                                "monoisotopic_mz": "877.9012",
                                "intensity": "33370.85",
                                "charge": "5"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "66",
                                "monoisotopic_mass": "4913.6840",
                                "monoisotopic_mz": "819.9546",
                                "intensity": "37605.41",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "67",
                                "monoisotopic_mass": "3018.5968",
                                "monoisotopic_mz": "1007.2062",
                                "intensity": "24503.20",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "68",
                                "monoisotopic_mass": "593.2908",
                                "monoisotopic_mz": "198.7709",
                                "intensity": "15797.17",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "69",
                                "monoisotopic_mass": "4826.6581",
                                "monoisotopic_mz": "805.4503",
                                "intensity": "25311.67",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "70",
                                "monoisotopic_mass": "2595.4021",
                                "monoisotopic_mz": "1298.7083",
                                "intensity": "13327.50",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000214",
                                "peak_id": "71",
                                "monoisotopic_mass": "1188.6491",
                                "monoisotopic_mz": "199.1155",
                                "intensity": "8453.70",
                                "charge": "6"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "5",
                    "proteoform_id": "12",
                    "sequence_name": "sp|P0A7P2|RL33_SALTY",
                    "sequence_description": "50S ribosomal protein L33 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmG PE=3 SV=2",
                    "proteoform_mass": "6250.5824",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "55",
                        "first_residue_position": "0",
                        "last_residue_position": "54",
                        "annotated_seq": ".(MA)[-117.0375]KGIREKIKLVSSAGTGHFYTTTKNKRTKPEKLELKKFDPVVRQHVIYKEAKIK.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "G"
                            },
                            {
                                "position": "4",
                                "acid": "I"
                            },
                            {
                                "position": "5",
                                "acid": "R"
                            },
                            {
                                "position": "6",
                                "acid": "E"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "I"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "L"
                            },
                            {
                                "position": "11",
                                "acid": "V"
                            },
                            {
                                "position": "12",
                                "acid": "S"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "T"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "H"
                            },
                            {
                                "position": "19",
                                "acid": "F"
                            },
                            {
                                "position": "20",
                                "acid": "Y"
                            },
                            {
                                "position": "21",
                                "acid": "T"
                            },
                            {
                                "position": "22",
                                "acid": "T"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "K"
                            },
                            {
                                "position": "25",
                                "acid": "N"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "R"
                            },
                            {
                                "position": "28",
                                "acid": "T"
                            },
                            {
                                "position": "29",
                                "acid": "K"
                            },
                            {
                                "position": "30",
                                "acid": "P"
                            },
                            {
                                "position": "31",
                                "acid": "E"
                            },
                            {
                                "position": "32",
                                "acid": "K"
                            },
                            {
                                "position": "33",
                                "acid": "L"
                            },
                            {
                                "position": "34",
                                "acid": "E"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "K"
                            },
                            {
                                "position": "38",
                                "acid": "F"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "V"
                            },
                            {
                                "position": "43",
                                "acid": "R"
                            },
                            {
                                "position": "44",
                                "acid": "Q"
                            },
                            {
                                "position": "45",
                                "acid": "H"
                            },
                            {
                                "position": "46",
                                "acid": "V"
                            },
                            {
                                "position": "47",
                                "acid": "I"
                            },
                            {
                                "position": "48",
                                "acid": "Y"
                            },
                            {
                                "position": "49",
                                "acid": "K"
                            },
                            {
                                "position": "50",
                                "acid": "E"
                            },
                            {
                                "position": "51",
                                "acid": "A"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "I"
                            },
                            {
                                "position": "54",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "2",
                                        "ion_display_position": "53",
                                        "spec_id": "1000214",
                                        "peak_id": "5",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "spec_id": "1000214",
                                        "peak_id": "40",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "1000214",
                                        "peak_id": "36",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "spec_id": "1000214",
                                        "peak_id": "25",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "1000214",
                                            "peak_id": "26",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "1000214",
                                            "peak_id": "50",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "12",
                                            "ion_display_position": "43",
                                            "spec_id": "1000214",
                                            "peak_id": "23",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "spec_id": "1000214",
                                        "peak_id": "38",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "spec_id": "1000214",
                                        "peak_id": "13",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "19",
                                            "ion_display_position": "19",
                                            "spec_id": "1000214",
                                            "peak_id": "31",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "19",
                                            "ion_display_position": "36",
                                            "spec_id": "1000214",
                                            "peak_id": "42",
                                            "peak_charge": "5"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "21",
                                        "ion_display_position": "34",
                                        "spec_id": "1000214",
                                        "peak_id": "53",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "spec_id": "1000214",
                                        "peak_id": "32",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "spec_id": "1000214",
                                        "peak_id": "20",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "37",
                                        "ion_display_position": "18",
                                        "spec_id": "1000214",
                                        "peak_id": "49",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "40",
                                            "ion_display_position": "15",
                                            "spec_id": "1000214",
                                            "peak_id": "19",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "40",
                                            "ion_display_position": "15",
                                            "spec_id": "1000214",
                                            "peak_id": "8",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "40",
                                            "ion_display_position": "40",
                                            "spec_id": "1000214",
                                            "peak_id": "3",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "40",
                                            "ion_display_position": "40",
                                            "spec_id": "1000214",
                                            "peak_id": "0",
                                            "peak_charge": "5"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "46",
                                        "ion_display_position": "46",
                                        "spec_id": "1000214",
                                        "peak_id": "10",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "8",
                                        "spec_id": "1000214",
                                        "peak_id": "41",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "48",
                                        "ion_display_position": "7",
                                        "spec_id": "1000214",
                                        "peak_id": "15",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "53",
                                        "ion_display_position": "53",
                                        "spec_id": "1000214",
                                        "peak_id": "37",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "2",
                            "shift": "-117.0374908038",
                            "anno": "-117.0375",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "132",
                "p_value": "1.44e-12",
                "e_value": "1.44e-12",
                "fdr": "0",
                "matched_fragment_number": "19",
                "matched_peak_number": "24",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_2_ms2.msalign",
                        "ms1_ids": "1000206",
                        "ms1_scans": "408",
                        "ids": "1000201",
                        "scans": "409",
                        "precursor_mono_mass": "6250.5424",
                        "precursor_charge": "10",
                        "precursor_mz": "626.0615"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "1000201",
                                "peak_id": "0",
                                "monoisotopic_mass": "4443.4828",
                                "monoisotopic_mz": "635.7905",
                                "intensity": "3164988.86",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0424808038",
                                        "theoretical_mass": "4443.4942",
                                        "ion_position": "40",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "B00040",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0114",
                                        "ppm": "-2.56"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "1",
                                "monoisotopic_mass": "991.5999",
                                "monoisotopic_mz": "992.6072",
                                "intensity": "297255.92",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "991.6066",
                                        "ion_position": "47",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0067",
                                        "ppm": "-6.77"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "2",
                                "monoisotopic_mass": "6037.4062",
                                "monoisotopic_mz": "671.8302",
                                "intensity": "1167706.32",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6037.4473",
                                        "ion_position": "3",
                                        "ion_display_position": "52",
                                        "ion_sort_name": "Y00052",
                                        "ion_left_position": "3",
                                        "mass_error": "-0.0411",
                                        "ppm": "-6.81"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "3",
                                "monoisotopic_mass": "4443.4803",
                                "monoisotopic_mz": "741.5873",
                                "intensity": "820616.17",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0424808038",
                                        "theoretical_mass": "4443.4942",
                                        "ion_position": "40",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "B00040",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0139",
                                        "ppm": "-3.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "4",
                                "monoisotopic_mass": "6165.4947",
                                "monoisotopic_mz": "686.0622",
                                "intensity": "667565.10",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6165.5423",
                                        "ion_position": "2",
                                        "ion_display_position": "53",
                                        "ion_sort_name": "Y00053",
                                        "ion_left_position": "2",
                                        "mass_error": "-0.0476",
                                        "ppm": "-7.71"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "5",
                                "monoisotopic_mass": "2596.4186",
                                "monoisotopic_mz": "866.4802",
                                "intensity": "562587.71",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "6",
                                "monoisotopic_mass": "6122.4486",
                                "monoisotopic_mz": "681.2793",
                                "intensity": "687762.74",
                                "charge": "9"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "7",
                                "monoisotopic_mass": "878.5163",
                                "monoisotopic_mz": "879.5236",
                                "intensity": "483936.14",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "878.5226",
                                        "ion_position": "48",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "48",
                                        "mass_error": "-0.0063",
                                        "ppm": "-7.14"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "8",
                                "monoisotopic_mass": "4053.2883",
                                "monoisotopic_mz": "676.5553",
                                "intensity": "433802.11",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0424808038",
                                        "theoretical_mass": "4053.3039",
                                        "ion_position": "37",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "B00037",
                                        "ion_left_position": "37",
                                        "mass_error": "-0.0156",
                                        "ppm": "-3.84"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "9",
                                "monoisotopic_mass": "1660.9643",
                                "monoisotopic_mz": "831.4894",
                                "intensity": "1483149.74",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "10",
                                "monoisotopic_mass": "6019.3908",
                                "monoisotopic_mz": "669.8285",
                                "intensity": "893288.08",
                                "charge": "9"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "11",
                                "monoisotopic_mass": "1710.0034",
                                "monoisotopic_mz": "856.0090",
                                "intensity": "506917.04",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0424808038",
                                        "theoretical_mass": "1709.9976",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "B00018",
                                        "ion_left_position": "18",
                                        "mass_error": "0.0058",
                                        "ppm": "3.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "12",
                                "monoisotopic_mass": "3106.6335",
                                "monoisotopic_mz": "777.6657",
                                "intensity": "267981.35",
                                "charge": "4"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "13",
                                "monoisotopic_mass": "1642.9564",
                                "monoisotopic_mz": "822.4855",
                                "intensity": "630485.52",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "14",
                                "monoisotopic_mass": "4230.3344",
                                "monoisotopic_mz": "706.0630",
                                "intensity": "588631.64",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "15",
                                "monoisotopic_mass": "1807.0701",
                                "monoisotopic_mz": "904.5423",
                                "intensity": "466144.34",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1807.0832",
                                        "ion_position": "40",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0131",
                                        "ppm": "-7.26"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "16",
                                "monoisotopic_mass": "3019.5992",
                                "monoisotopic_mz": "1007.5403",
                                "intensity": "343109.37",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "17",
                                "monoisotopic_mass": "5159.8795",
                                "monoisotopic_mz": "860.9872",
                                "intensity": "571634.05",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0424808038",
                                        "theoretical_mass": "5159.9024",
                                        "ion_position": "46",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "B00046",
                                        "ion_left_position": "46",
                                        "mass_error": "-0.0229",
                                        "ppm": "-4.43"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "18",
                                "monoisotopic_mass": "1547.8827",
                                "monoisotopic_mz": "774.9486",
                                "intensity": "681300.96",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "19",
                                "monoisotopic_mass": "4999.7314",
                                "monoisotopic_mz": "715.2546",
                                "intensity": "404086.08",
                                "charge": "7"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "20",
                                "monoisotopic_mass": "1678.9743",
                                "monoisotopic_mz": "840.4944",
                                "intensity": "395405.39",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "21",
                                "monoisotopic_mass": "2286.2902",
                                "monoisotopic_mz": "763.1040",
                                "intensity": "400928.17",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "22",
                                "monoisotopic_mass": "1710.0042",
                                "monoisotopic_mz": "571.0087",
                                "intensity": "125423.81",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0424808038",
                                        "theoretical_mass": "1709.9976",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "B00018",
                                        "ion_left_position": "18",
                                        "mass_error": "0.0066",
                                        "ppm": "3.87"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "23",
                                "monoisotopic_mass": "3193.6611",
                                "monoisotopic_mz": "799.4226",
                                "intensity": "471915.85",
                                "charge": "4"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "24",
                                "monoisotopic_mass": "1660.9652",
                                "monoisotopic_mz": "554.6624",
                                "intensity": "209782.82",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "25",
                                "monoisotopic_mass": "3193.6721",
                                "monoisotopic_mz": "1065.5646",
                                "intensity": "162929.43",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "26",
                                "monoisotopic_mass": "2449.3487",
                                "monoisotopic_mz": "817.4568",
                                "intensity": "706152.40",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "27",
                                "monoisotopic_mass": "6148.4719",
                                "monoisotopic_mz": "684.1708",
                                "intensity": "616499.39",
                                "charge": "9"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "28",
                                "monoisotopic_mass": "1249.8152",
                                "monoisotopic_mz": "417.6123",
                                "intensity": "222280.08",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0424808038",
                                        "theoretical_mass": "1249.8058",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0094",
                                        "ppm": "7.52"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "29",
                                "monoisotopic_mass": "928.5547",
                                "monoisotopic_mz": "929.5620",
                                "intensity": "236923.21",
                                "charge": "1"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "30",
                                "monoisotopic_mass": "1330.7415",
                                "monoisotopic_mz": "666.3781",
                                "intensity": "342851.22",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "31",
                                "monoisotopic_mass": "1091.6163",
                                "monoisotopic_mz": "546.8154",
                                "intensity": "216508.85",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "32",
                                "monoisotopic_mass": "4808.6545",
                                "monoisotopic_mz": "802.4497",
                                "intensity": "474992.21",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "33",
                                "monoisotopic_mass": "1164.7618",
                                "monoisotopic_mz": "583.3882",
                                "intensity": "295742.40",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "34",
                                "monoisotopic_mass": "2197.2602",
                                "monoisotopic_mz": "550.3223",
                                "intensity": "114545.06",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2197.2735",
                                        "ion_position": "37",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "Y00018",
                                        "ion_left_position": "37",
                                        "mass_error": "-0.0133",
                                        "ppm": "-6.05"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "35",
                                "monoisotopic_mass": "973.5871",
                                "monoisotopic_mz": "974.5944",
                                "intensity": "93393.23",
                                "charge": "1"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "36",
                                "monoisotopic_mass": "2948.5649",
                                "monoisotopic_mz": "983.8622",
                                "intensity": "361298.16",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "37",
                                "monoisotopic_mass": "4340.4020",
                                "monoisotopic_mz": "724.4076",
                                "intensity": "203972.06",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "38",
                                "monoisotopic_mass": "2596.4140",
                                "monoisotopic_mz": "650.1108",
                                "intensity": "114544.57",
                                "charge": "4"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "39",
                                "monoisotopic_mass": "4385.4764",
                                "monoisotopic_mz": "731.9200",
                                "intensity": "363123.81",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "40",
                                "monoisotopic_mass": "587.3594",
                                "monoisotopic_mz": "588.3667",
                                "intensity": "278148.34",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "587.3643",
                                        "ion_position": "50",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "Y00005",
                                        "ion_left_position": "50",
                                        "mass_error": "-0.0048",
                                        "ppm": "-8.24"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "41",
                                "monoisotopic_mass": "1037.6665",
                                "monoisotopic_mz": "519.8405",
                                "intensity": "249807.31",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "42",
                                "monoisotopic_mass": "716.4032",
                                "monoisotopic_mz": "717.4105",
                                "intensity": "529199.72",
                                "charge": "1"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "43",
                                "monoisotopic_mass": "1783.6991",
                                "monoisotopic_mz": "199.1961",
                                "intensity": "205096.69",
                                "charge": "9"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "44",
                                "monoisotopic_mass": "4425.4607",
                                "monoisotopic_mz": "633.2159",
                                "intensity": "384902.51",
                                "charge": "7"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "45",
                                "monoisotopic_mass": "928.5537",
                                "monoisotopic_mz": "465.2841",
                                "intensity": "309467.55",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "46",
                                "monoisotopic_mass": "5371.0343",
                                "monoisotopic_mz": "768.2979",
                                "intensity": "110104.44",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0424808038",
                                        "theoretical_mass": "5372.0548",
                                        "ion_position": "48",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "B00048",
                                        "ion_left_position": "48",
                                        "mass_error": "-0.0182",
                                        "ppm": "-3.39"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "47",
                                "monoisotopic_mass": "4809.6558",
                                "monoisotopic_mz": "688.1010",
                                "intensity": "93693.86",
                                "charge": "7"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "48",
                                "monoisotopic_mass": "569.3499",
                                "monoisotopic_mz": "570.3572",
                                "intensity": "275776.26",
                                "charge": "1"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "49",
                                "monoisotopic_mass": "815.4716",
                                "monoisotopic_mz": "408.7431",
                                "intensity": "569809.08",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "50",
                                "monoisotopic_mass": "4403.4943",
                                "monoisotopic_mz": "734.9230",
                                "intensity": "493093.81",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4403.5209",
                                        "ion_position": "19",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "Y00036",
                                        "ion_left_position": "19",
                                        "mass_error": "-0.0266",
                                        "ppm": "-6.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "51",
                                "monoisotopic_mass": "697.4440",
                                "monoisotopic_mz": "698.4513",
                                "intensity": "119405.48",
                                "charge": "1"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "52",
                                "monoisotopic_mass": "4358.4031",
                                "monoisotopic_mz": "727.4078",
                                "intensity": "585252.43",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "53",
                                "monoisotopic_mass": "1132.7364",
                                "monoisotopic_mz": "567.3755",
                                "intensity": "131031.88",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "54",
                                "monoisotopic_mass": "1496.8531",
                                "monoisotopic_mz": "749.4338",
                                "intensity": "88031.65",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "55",
                                "monoisotopic_mass": "2069.1600",
                                "monoisotopic_mz": "1035.5873",
                                "intensity": "111421.17",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2069.1786",
                                        "ion_position": "38",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "Y00017",
                                        "ion_left_position": "38",
                                        "mass_error": "-0.0185",
                                        "ppm": "-8.96"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "56",
                                "monoisotopic_mass": "2069.1628",
                                "monoisotopic_mz": "690.7282",
                                "intensity": "301692.85",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2069.1786",
                                        "ion_position": "38",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "Y00017",
                                        "ion_left_position": "38",
                                        "mass_error": "-0.0158",
                                        "ppm": "-7.64"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "57",
                                "monoisotopic_mass": "688.4085",
                                "monoisotopic_mz": "345.2115",
                                "intensity": "115608.67",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "58",
                                "monoisotopic_mass": "991.5981",
                                "monoisotopic_mz": "496.8063",
                                "intensity": "88157.34",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "991.6066",
                                        "ion_position": "47",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0085",
                                        "ppm": "-8.57"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "59",
                                "monoisotopic_mass": "787.4773",
                                "monoisotopic_mz": "394.7459",
                                "intensity": "137246.09",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "60",
                                "monoisotopic_mass": "4754.6321",
                                "monoisotopic_mz": "793.4460",
                                "intensity": "453536.40",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "61",
                                "monoisotopic_mass": "3019.6042",
                                "monoisotopic_mz": "755.9083",
                                "intensity": "267347.05",
                                "charge": "4"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "62",
                                "monoisotopic_mass": "4256.4112",
                                "monoisotopic_mz": "710.4091",
                                "intensity": "513214.41",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4256.4525",
                                        "ion_position": "20",
                                        "ion_display_position": "35",
                                        "ion_sort_name": "Y00035",
                                        "ion_left_position": "20",
                                        "mass_error": "-0.0413",
                                        "ppm": "-9.71"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "63",
                                "monoisotopic_mass": "716.4032",
                                "monoisotopic_mz": "359.2089",
                                "intensity": "189886.41",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "64",
                                "monoisotopic_mass": "3381.0120",
                                "monoisotopic_mz": "677.2097",
                                "intensity": "102159.66",
                                "charge": "5"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "65",
                                "monoisotopic_mass": "1981.8310",
                                "monoisotopic_mz": "199.1904",
                                "intensity": "73874.81",
                                "charge": "10"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "66",
                                "monoisotopic_mass": "4737.6066",
                                "monoisotopic_mz": "790.6084",
                                "intensity": "359607.59",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "67",
                                "monoisotopic_mass": "824.5173",
                                "monoisotopic_mz": "825.5246",
                                "intensity": "137274.84",
                                "charge": "1"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "68",
                                "monoisotopic_mass": "1150.7441",
                                "monoisotopic_mz": "576.3793",
                                "intensity": "146990.05",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0424808038",
                                        "theoretical_mass": "1150.7374",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "0.0067",
                                        "ppm": "5.86"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "69",
                                "monoisotopic_mass": "1092.6202",
                                "monoisotopic_mz": "1093.6274",
                                "intensity": "124758.89",
                                "charge": "1"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "70",
                                "monoisotopic_mass": "5159.8799",
                                "monoisotopic_mz": "738.1330",
                                "intensity": "398112.11",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0424808038",
                                        "theoretical_mass": "5159.9024",
                                        "ion_position": "46",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "B00046",
                                        "ion_left_position": "46",
                                        "mass_error": "-0.0225",
                                        "ppm": "-4.36"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "71",
                                "monoisotopic_mass": "4738.6196",
                                "monoisotopic_mz": "677.9529",
                                "intensity": "146184.72",
                                "charge": "7"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "72",
                                "monoisotopic_mass": "1348.7481",
                                "monoisotopic_mz": "675.3813",
                                "intensity": "131943.01",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "73",
                                "monoisotopic_mass": "4826.6680",
                                "monoisotopic_mz": "805.4519",
                                "intensity": "530525.13",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4826.7076",
                                        "ion_position": "14",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "Y00041",
                                        "ion_left_position": "14",
                                        "mass_error": "-0.0396",
                                        "ppm": "-8.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "74",
                                "monoisotopic_mass": "2948.5727",
                                "monoisotopic_mz": "738.1505",
                                "intensity": "288451.32",
                                "charge": "4"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "75",
                                "monoisotopic_mass": "4755.6049",
                                "monoisotopic_mz": "680.3794",
                                "intensity": "246038.36",
                                "charge": "7"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "76",
                                "monoisotopic_mass": "5130.8788",
                                "monoisotopic_mz": "733.9900",
                                "intensity": "188343.02",
                                "charge": "7"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "77",
                                "monoisotopic_mass": "2431.3326",
                                "monoisotopic_mz": "811.4515",
                                "intensity": "118442.38",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "78",
                                "monoisotopic_mass": "2930.5467",
                                "monoisotopic_mz": "977.8562",
                                "intensity": "139352.19",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "79",
                                "monoisotopic_mass": "1818.0622",
                                "monoisotopic_mz": "455.5228",
                                "intensity": "131698.01",
                                "charge": "4"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "80",
                                "monoisotopic_mass": "2196.2513",
                                "monoisotopic_mz": "733.0910",
                                "intensity": "444332.76",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "81",
                                "monoisotopic_mass": "4092.3626",
                                "monoisotopic_mz": "683.0677",
                                "intensity": "178743.82",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "82",
                                "monoisotopic_mass": "1846.0566",
                                "monoisotopic_mz": "462.5214",
                                "intensity": "150079.81",
                                "charge": "4"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "83",
                                "monoisotopic_mass": "3126.2823",
                                "monoisotopic_mz": "626.2637",
                                "intensity": "1655257.40",
                                "charge": "5"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "84",
                                "monoisotopic_mass": "4092.3585",
                                "monoisotopic_mz": "819.4790",
                                "intensity": "159916.06",
                                "charge": "5"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "85",
                                "monoisotopic_mass": "3812.1226",
                                "monoisotopic_mz": "636.3611",
                                "intensity": "183516.11",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0424808038",
                                        "theoretical_mass": "3812.1248",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "ion_sort_name": "B00035",
                                        "ion_left_position": "35",
                                        "mass_error": "-0.0022",
                                        "ppm": "-0.57"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "86",
                                "monoisotopic_mass": "5672.2375",
                                "monoisotopic_mz": "710.0370",
                                "intensity": "155127.93",
                                "charge": "8"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "87",
                                "monoisotopic_mass": "4424.4688",
                                "monoisotopic_mz": "738.4187",
                                "intensity": "143332.12",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000201",
                                "peak_id": "88",
                                "monoisotopic_mass": "4075.3276",
                                "monoisotopic_mz": "680.2285",
                                "intensity": "88129.31",
                                "charge": "6"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "5",
                    "proteoform_id": "12",
                    "sequence_name": "sp|P0A7P2|RL33_SALTY",
                    "sequence_description": "50S ribosomal protein L33 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmG PE=3 SV=2",
                    "proteoform_mass": "6250.5774",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "55",
                        "first_residue_position": "0",
                        "last_residue_position": "54",
                        "annotated_seq": ".(MA)[-117.0425]KGIREKIKLVSSAGTGHFYTTTKNKRTKPEKLELKKFDPVVRQHVIYKEAKIK.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "G"
                            },
                            {
                                "position": "4",
                                "acid": "I"
                            },
                            {
                                "position": "5",
                                "acid": "R"
                            },
                            {
                                "position": "6",
                                "acid": "E"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "I"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "L"
                            },
                            {
                                "position": "11",
                                "acid": "V"
                            },
                            {
                                "position": "12",
                                "acid": "S"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "T"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "H"
                            },
                            {
                                "position": "19",
                                "acid": "F"
                            },
                            {
                                "position": "20",
                                "acid": "Y"
                            },
                            {
                                "position": "21",
                                "acid": "T"
                            },
                            {
                                "position": "22",
                                "acid": "T"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "K"
                            },
                            {
                                "position": "25",
                                "acid": "N"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "R"
                            },
                            {
                                "position": "28",
                                "acid": "T"
                            },
                            {
                                "position": "29",
                                "acid": "K"
                            },
                            {
                                "position": "30",
                                "acid": "P"
                            },
                            {
                                "position": "31",
                                "acid": "E"
                            },
                            {
                                "position": "32",
                                "acid": "K"
                            },
                            {
                                "position": "33",
                                "acid": "L"
                            },
                            {
                                "position": "34",
                                "acid": "E"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "K"
                            },
                            {
                                "position": "38",
                                "acid": "F"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "V"
                            },
                            {
                                "position": "43",
                                "acid": "R"
                            },
                            {
                                "position": "44",
                                "acid": "Q"
                            },
                            {
                                "position": "45",
                                "acid": "H"
                            },
                            {
                                "position": "46",
                                "acid": "V"
                            },
                            {
                                "position": "47",
                                "acid": "I"
                            },
                            {
                                "position": "48",
                                "acid": "Y"
                            },
                            {
                                "position": "49",
                                "acid": "K"
                            },
                            {
                                "position": "50",
                                "acid": "E"
                            },
                            {
                                "position": "51",
                                "acid": "A"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "I"
                            },
                            {
                                "position": "54",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "2",
                                        "ion_display_position": "53",
                                        "spec_id": "1000201",
                                        "peak_id": "4",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "3",
                                        "ion_display_position": "52",
                                        "spec_id": "1000201",
                                        "peak_id": "2",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "spec_id": "1000201",
                                        "peak_id": "68",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "spec_id": "1000201",
                                        "peak_id": "28",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "14",
                                        "ion_display_position": "41",
                                        "spec_id": "1000201",
                                        "peak_id": "73",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "18",
                                            "ion_display_position": "18",
                                            "spec_id": "1000201",
                                            "peak_id": "11",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "18",
                                            "ion_display_position": "18",
                                            "spec_id": "1000201",
                                            "peak_id": "22",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "19",
                                        "ion_display_position": "36",
                                        "spec_id": "1000201",
                                        "peak_id": "50",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "20",
                                        "ion_display_position": "35",
                                        "spec_id": "1000201",
                                        "peak_id": "62",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "spec_id": "1000201",
                                        "peak_id": "85",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "37",
                                            "ion_display_position": "18",
                                            "spec_id": "1000201",
                                            "peak_id": "34",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "37",
                                            "ion_display_position": "37",
                                            "spec_id": "1000201",
                                            "peak_id": "8",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "38",
                                            "ion_display_position": "17",
                                            "spec_id": "1000201",
                                            "peak_id": "55",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "38",
                                            "ion_display_position": "17",
                                            "spec_id": "1000201",
                                            "peak_id": "56",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "40",
                                            "ion_display_position": "15",
                                            "spec_id": "1000201",
                                            "peak_id": "15",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "40",
                                            "ion_display_position": "40",
                                            "spec_id": "1000201",
                                            "peak_id": "3",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "40",
                                            "ion_display_position": "40",
                                            "spec_id": "1000201",
                                            "peak_id": "0",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "46",
                                            "ion_display_position": "46",
                                            "spec_id": "1000201",
                                            "peak_id": "17",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "46",
                                            "ion_display_position": "46",
                                            "spec_id": "1000201",
                                            "peak_id": "70",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "47",
                                            "ion_display_position": "8",
                                            "spec_id": "1000201",
                                            "peak_id": "58",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "47",
                                            "ion_display_position": "8",
                                            "spec_id": "1000201",
                                            "peak_id": "1",
                                            "peak_charge": "1"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "48",
                                            "ion_display_position": "7",
                                            "spec_id": "1000201",
                                            "peak_id": "7",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "48",
                                            "ion_display_position": "48",
                                            "spec_id": "1000201",
                                            "peak_id": "46",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "50",
                                        "ion_display_position": "5",
                                        "spec_id": "1000201",
                                        "peak_id": "40",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "2",
                            "shift": "-117.0424808038",
                            "anno": "-117.0425",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "2",
                "p_value": "1.61e-11",
                "e_value": "1.61e-11",
                "fdr": "0",
                "matched_fragment_number": "13",
                "matched_peak_number": "17",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                        "ms1_ids": "175",
                        "ms1_scans": "336",
                        "ids": "160",
                        "scans": "337",
                        "precursor_mono_mass": "4532.4737",
                        "precursor_charge": "8",
                        "precursor_mz": "567.5665"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "160",
                                "peak_id": "0",
                                "monoisotopic_mass": "3354.8524",
                                "monoisotopic_mz": "839.7204",
                                "intensity": "366356.03",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-3.0464431981e-02",
                                        "theoretical_mass": "3354.8521",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "0.0003",
                                        "ppm": "0.10"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "1",
                                "monoisotopic_mass": "4384.4031",
                                "monoisotopic_mz": "627.3506",
                                "intensity": "1058548.32",
                                "charge": "7"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "2",
                                "monoisotopic_mass": "3555.9315",
                                "monoisotopic_mz": "889.9901",
                                "intensity": "251659.20",
                                "charge": "4"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "3",
                                "monoisotopic_mass": "4401.4301",
                                "monoisotopic_mz": "629.7830",
                                "intensity": "4198343.15",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-3.0464431981e-02",
                                        "theoretical_mass": "4401.4432",
                                        "ion_position": "1",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "Y00037",
                                        "ion_left_position": "1",
                                        "mass_error": "-0.0131",
                                        "ppm": "-2.97"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "4",
                                "monoisotopic_mass": "3554.9247",
                                "monoisotopic_mz": "711.9922",
                                "intensity": "1251123.77",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-3.0464431981e-02",
                                        "theoretical_mass": "3554.9318",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0071",
                                        "ppm": "-2.00"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "5",
                                "monoisotopic_mass": "3336.8363",
                                "monoisotopic_mz": "835.2163",
                                "intensity": "359299.85",
                                "charge": "4"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "6",
                                "monoisotopic_mass": "3632.9445",
                                "monoisotopic_mz": "606.4980",
                                "intensity": "380658.61",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-3.0464431981e-02",
                                        "theoretical_mass": "3632.9462",
                                        "ion_position": "8",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "Y00030",
                                        "ion_left_position": "8",
                                        "mass_error": "-0.0017",
                                        "ppm": "-0.46"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "7",
                                "monoisotopic_mass": "2062.1011",
                                "monoisotopic_mz": "688.3743",
                                "intensity": "195996.50",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-3.0464431981e-02",
                                        "theoretical_mass": "2062.0913",
                                        "ion_position": "20",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "Y00018",
                                        "ion_left_position": "20",
                                        "mass_error": "0.0098",
                                        "ppm": "4.74"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "8",
                                "monoisotopic_mass": "3424.8900",
                                "monoisotopic_mz": "857.2298",
                                "intensity": "823405.30",
                                "charge": "4"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "9",
                                "monoisotopic_mass": "3267.8218",
                                "monoisotopic_mz": "654.5716",
                                "intensity": "308943.44",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-3.0464431981e-02",
                                        "theoretical_mass": "3267.8200",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "B00027",
                                        "ion_left_position": "27",
                                        "mass_error": "0.0018",
                                        "ppm": "0.55"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "10",
                                "monoisotopic_mass": "3632.9355",
                                "monoisotopic_mz": "727.5944",
                                "intensity": "498561.40",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-3.0464431981e-02",
                                        "theoretical_mass": "3632.9462",
                                        "ion_position": "8",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "Y00030",
                                        "ion_left_position": "8",
                                        "mass_error": "-0.0106",
                                        "ppm": "-2.93"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "11",
                                "monoisotopic_mass": "4273.3374",
                                "monoisotopic_mz": "611.4841",
                                "intensity": "3113557.67",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-3.0464431981e-02",
                                        "theoretical_mass": "4273.3482",
                                        "ion_position": "2",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "Y00036",
                                        "ion_left_position": "2",
                                        "mass_error": "-0.0108",
                                        "ppm": "-2.52"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "12",
                                "monoisotopic_mass": "3354.8487",
                                "monoisotopic_mz": "671.9770",
                                "intensity": "933423.52",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-3.0464431981e-02",
                                        "theoretical_mass": "3354.8521",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0034",
                                        "ppm": "-1.00"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "13",
                                "monoisotopic_mass": "2177.1203",
                                "monoisotopic_mz": "726.7140",
                                "intensity": "101843.52",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-3.0464431981e-02",
                                        "theoretical_mass": "2177.1183",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "Y00019",
                                        "ion_left_position": "19",
                                        "mass_error": "0.0020",
                                        "ppm": "0.92"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "14",
                                "monoisotopic_mass": "752.3971",
                                "monoisotopic_mz": "753.4044",
                                "intensity": "577405.52",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "752.4042",
                                        "ion_position": "32",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "32",
                                        "mass_error": "-0.0071",
                                        "ppm": "-9.42"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "15",
                                "monoisotopic_mass": "1858.9953",
                                "monoisotopic_mz": "620.6724",
                                "intensity": "185865.94",
                                "charge": "3"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "16",
                                "monoisotopic_mass": "3768.0748",
                                "monoisotopic_mz": "629.0197",
                                "intensity": "195378.50",
                                "charge": "6"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "17",
                                "monoisotopic_mass": "615.3400",
                                "monoisotopic_mz": "616.3473",
                                "intensity": "766599.25",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "615.3453",
                                        "ion_position": "33",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "Y00005",
                                        "ion_left_position": "33",
                                        "mass_error": "-0.0052",
                                        "ppm": "-8.53"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "18",
                                "monoisotopic_mass": "3336.8418",
                                "monoisotopic_mz": "668.3756",
                                "intensity": "541735.35",
                                "charge": "5"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "19",
                                "monoisotopic_mass": "1194.1198",
                                "monoisotopic_mz": "299.5372",
                                "intensity": "55925.82",
                                "charge": "4"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "20",
                                "monoisotopic_mass": "4256.3087",
                                "monoisotopic_mz": "609.0514",
                                "intensity": "335465.52",
                                "charge": "7"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "21",
                                "monoisotopic_mass": "1354.7359",
                                "monoisotopic_mz": "339.6913",
                                "intensity": "56701.23",
                                "charge": "4"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "22",
                                "monoisotopic_mass": "3407.8687",
                                "monoisotopic_mz": "682.5810",
                                "intensity": "469567.71",
                                "charge": "5"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "23",
                                "monoisotopic_mass": "977.5428",
                                "monoisotopic_mz": "489.7787",
                                "intensity": "2160503.75",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "977.5519",
                                        "ion_position": "30",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0091",
                                        "ppm": "-9.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "24",
                                "monoisotopic_mass": "3425.8835",
                                "monoisotopic_mz": "686.1840",
                                "intensity": "1619530.26",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-3.0464431981e-02",
                                        "theoretical_mass": "3425.8892",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "-0.0056",
                                        "ppm": "-1.64"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "25",
                                "monoisotopic_mass": "2674.4675",
                                "monoisotopic_mz": "669.6242",
                                "intensity": "287416.18",
                                "charge": "4"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "26",
                                "monoisotopic_mass": "3166.7717",
                                "monoisotopic_mz": "792.7002",
                                "intensity": "178323.23",
                                "charge": "4"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "27",
                                "monoisotopic_mass": "752.3976",
                                "monoisotopic_mz": "377.2061",
                                "intensity": "903082.61",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "752.4042",
                                        "ion_position": "32",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "32",
                                        "mass_error": "-0.0066",
                                        "ppm": "-8.78"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "28",
                                "monoisotopic_mass": "977.5433",
                                "monoisotopic_mz": "326.8550",
                                "intensity": "173492.58",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "977.5519",
                                        "ion_position": "30",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0086",
                                        "ppm": "-8.79"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "29",
                                "monoisotopic_mass": "3296.7981",
                                "monoisotopic_mz": "660.3669",
                                "intensity": "209385.75",
                                "charge": "5"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "30",
                                "monoisotopic_mass": "1300.7052",
                                "monoisotopic_mz": "651.3599",
                                "intensity": "95668.09",
                                "charge": "2"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "31",
                                "monoisotopic_mass": "2560.3869",
                                "monoisotopic_mz": "641.1040",
                                "intensity": "326128.94",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-3.0464431981e-02",
                                        "theoretical_mass": "2560.3828",
                                        "ion_position": "16",
                                        "ion_display_position": "22",
                                        "ion_sort_name": "Y00022",
                                        "ion_left_position": "16",
                                        "mass_error": "0.0042",
                                        "ppm": "1.63"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "32",
                                "monoisotopic_mass": "3616.9264",
                                "monoisotopic_mz": "603.8283",
                                "intensity": "94151.58",
                                "charge": "6"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "33",
                                "monoisotopic_mass": "3503.8442",
                                "monoisotopic_mz": "701.7761",
                                "intensity": "765480.83",
                                "charge": "5"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "34",
                                "monoisotopic_mass": "629.6355",
                                "monoisotopic_mz": "630.6428",
                                "intensity": "262117.91",
                                "charge": "1"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "35",
                                "monoisotopic_mass": "3244.8203",
                                "monoisotopic_mz": "649.9713",
                                "intensity": "223384.58",
                                "charge": "5"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "36",
                                "monoisotopic_mass": "960.5369",
                                "monoisotopic_mz": "481.2757",
                                "intensity": "80175.81",
                                "charge": "2"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "37",
                                "monoisotopic_mass": "4366.3835",
                                "monoisotopic_mz": "624.7763",
                                "intensity": "136843.07",
                                "charge": "7"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "38",
                                "monoisotopic_mass": "3396.8884",
                                "monoisotopic_mz": "850.2294",
                                "intensity": "183219.77",
                                "charge": "4"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "39",
                                "monoisotopic_mass": "2672.4673",
                                "monoisotopic_mz": "535.5007",
                                "intensity": "149008.30",
                                "charge": "5"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "40",
                                "monoisotopic_mass": "3486.8322",
                                "monoisotopic_mz": "698.3737",
                                "intensity": "99723.02",
                                "charge": "5"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "41",
                                "monoisotopic_mass": "4017.1495",
                                "monoisotopic_mz": "670.5322",
                                "intensity": "89927.81",
                                "charge": "6"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "42",
                                "monoisotopic_mass": "2527.2945",
                                "monoisotopic_mz": "843.4388",
                                "intensity": "194027.67",
                                "charge": "3"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "43",
                                "monoisotopic_mass": "653.7655",
                                "monoisotopic_mz": "654.7728",
                                "intensity": "40268.85",
                                "charge": "1"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "44",
                                "monoisotopic_mass": "2654.3958",
                                "monoisotopic_mz": "885.8059",
                                "intensity": "194557.64",
                                "charge": "3"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "45",
                                "monoisotopic_mass": "851.7181",
                                "monoisotopic_mz": "852.7253",
                                "intensity": "71447.58",
                                "charge": "1"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "46",
                                "monoisotopic_mass": "685.7803",
                                "monoisotopic_mz": "686.7876",
                                "intensity": "201635.52",
                                "charge": "1"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "47",
                                "monoisotopic_mass": "670.9701",
                                "monoisotopic_mz": "671.9774",
                                "intensity": "55431.90",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "10",
                    "proteoform_id": "12",
                    "sequence_name": "sp|P0A7Q8|RL36_SALTY",
                    "sequence_description": "50S ribosomal protein L36 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmJ PE=3 SV=1",
                    "proteoform_mass": "4532.4837",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "38",
                        "first_residue_position": "0",
                        "last_residue_position": "37",
                        "annotated_seq": ".MKVRASVKKL(C)[Carbamidomethylation]RN(C)[Carbamidomethylation]KIVKRD(GVIRVI(C)[Carbamidomethylation])[-0.0305]SAEPKHKQRQG.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "K"
                            },
                            {
                                "position": "2",
                                "acid": "V"
                            },
                            {
                                "position": "3",
                                "acid": "R"
                            },
                            {
                                "position": "4",
                                "acid": "A"
                            },
                            {
                                "position": "5",
                                "acid": "S"
                            },
                            {
                                "position": "6",
                                "acid": "V"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "L"
                            },
                            {
                                "position": "10",
                                "acid": "C"
                            },
                            {
                                "position": "11",
                                "acid": "R"
                            },
                            {
                                "position": "12",
                                "acid": "N"
                            },
                            {
                                "position": "13",
                                "acid": "C"
                            },
                            {
                                "position": "14",
                                "acid": "K"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "V"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "R"
                            },
                            {
                                "position": "19",
                                "acid": "D"
                            },
                            {
                                "position": "20",
                                "acid": "G"
                            },
                            {
                                "position": "21",
                                "acid": "V"
                            },
                            {
                                "position": "22",
                                "acid": "I"
                            },
                            {
                                "position": "23",
                                "acid": "R"
                            },
                            {
                                "position": "24",
                                "acid": "V"
                            },
                            {
                                "position": "25",
                                "acid": "I"
                            },
                            {
                                "position": "26",
                                "acid": "C"
                            },
                            {
                                "position": "27",
                                "acid": "S"
                            },
                            {
                                "position": "28",
                                "acid": "A"
                            },
                            {
                                "position": "29",
                                "acid": "E"
                            },
                            {
                                "position": "30",
                                "acid": "P"
                            },
                            {
                                "position": "31",
                                "acid": "K"
                            },
                            {
                                "position": "32",
                                "acid": "H"
                            },
                            {
                                "position": "33",
                                "acid": "K"
                            },
                            {
                                "position": "34",
                                "acid": "Q"
                            },
                            {
                                "position": "35",
                                "acid": "R"
                            },
                            {
                                "position": "36",
                                "acid": "Q"
                            },
                            {
                                "position": "37",
                                "acid": "G"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "1",
                                        "ion_display_position": "37",
                                        "spec_id": "160",
                                        "peak_id": "3",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "2",
                                        "ion_display_position": "36",
                                        "spec_id": "160",
                                        "peak_id": "11",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "8",
                                            "ion_display_position": "30",
                                            "spec_id": "160",
                                            "peak_id": "10",
                                            "peak_charge": "5"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "8",
                                            "ion_display_position": "30",
                                            "spec_id": "160",
                                            "peak_id": "6",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "16",
                                        "ion_display_position": "22",
                                        "spec_id": "160",
                                        "peak_id": "31",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "spec_id": "160",
                                        "peak_id": "13",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "20",
                                        "ion_display_position": "18",
                                        "spec_id": "160",
                                        "peak_id": "7",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "spec_id": "160",
                                        "peak_id": "9",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "28",
                                            "ion_display_position": "28",
                                            "spec_id": "160",
                                            "peak_id": "12",
                                            "peak_charge": "5"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "28",
                                            "ion_display_position": "28",
                                            "spec_id": "160",
                                            "peak_id": "0",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "spec_id": "160",
                                        "peak_id": "24",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "30",
                                            "ion_display_position": "8",
                                            "spec_id": "160",
                                            "peak_id": "23",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "30",
                                            "ion_display_position": "8",
                                            "spec_id": "160",
                                            "peak_id": "28",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "30",
                                            "ion_display_position": "30",
                                            "spec_id": "160",
                                            "peak_id": "4",
                                            "peak_charge": "5"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "32",
                                            "ion_display_position": "6",
                                            "spec_id": "160",
                                            "peak_id": "14",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "32",
                                            "ion_display_position": "6",
                                            "spec_id": "160",
                                            "peak_id": "27",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "33",
                                        "ion_display_position": "5",
                                        "spec_id": "160",
                                        "peak_id": "17",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": [
                                {
                                    "left_pos": "10",
                                    "right_pos": "11",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "13",
                                    "right_pos": "14",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "26",
                                    "right_pos": "27",
                                    "anno": "C"
                                }
                            ]
                        },
                        "mass_shift": {
                            "id": "0",
                            "left_position": "20",
                            "right_position": "27",
                            "shift": "-3.0464431981e-02",
                            "anno": "-0.0305",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "114",
                "p_value": "2.30e-09",
                "e_value": "2.30e-09",
                "fdr": "0",
                "matched_fragment_number": "10",
                "matched_peak_number": "12",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_2_ms2.msalign",
                        "ms1_ids": "1000164",
                        "ms1_scans": "324",
                        "ids": "1000159",
                        "scans": "325",
                        "precursor_mono_mass": "4532.4646",
                        "precursor_charge": "7",
                        "precursor_mz": "648.5022",
                        "feature_inte": "2.9882e+09"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "1000159",
                                "peak_id": "0",
                                "monoisotopic_mass": "3632.9386",
                                "monoisotopic_mz": "727.5950",
                                "intensity": "171578.24",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-3.9494431981e-02",
                                        "theoretical_mass": "3632.9371",
                                        "ion_position": "8",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "Y00030",
                                        "ion_left_position": "8",
                                        "mass_error": "0.0014",
                                        "ppm": "0.39"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000159",
                                "peak_id": "1",
                                "monoisotopic_mass": "3554.9210",
                                "monoisotopic_mz": "711.9915",
                                "intensity": "272526.70",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-3.9494431981e-02",
                                        "theoretical_mass": "3554.9227",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0017",
                                        "ppm": "-0.48"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000159",
                                "peak_id": "2",
                                "monoisotopic_mass": "2655.3866",
                                "monoisotopic_mz": "886.1362",
                                "intensity": "72780.55",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000159",
                                "peak_id": "3",
                                "monoisotopic_mass": "3425.8812",
                                "monoisotopic_mz": "857.4776",
                                "intensity": "250997.92",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-3.9494431981e-02",
                                        "theoretical_mass": "3425.8801",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0010",
                                        "ppm": "0.30"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000159",
                                "peak_id": "4",
                                "monoisotopic_mass": "3554.9307",
                                "monoisotopic_mz": "889.7400",
                                "intensity": "324683.78",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-3.9494431981e-02",
                                        "theoretical_mass": "3554.9227",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "0.0080",
                                        "ppm": "2.25"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000159",
                                "peak_id": "5",
                                "monoisotopic_mass": "977.5425",
                                "monoisotopic_mz": "489.7785",
                                "intensity": "268153.05",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "977.5519",
                                        "ion_position": "30",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0094",
                                        "ppm": "-9.60"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000159",
                                "peak_id": "6",
                                "monoisotopic_mass": "752.3961",
                                "monoisotopic_mz": "753.4034",
                                "intensity": "144019.56",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "752.4042",
                                        "ion_position": "32",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "32",
                                        "mass_error": "-0.0081",
                                        "ppm": "-10.72"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000159",
                                "peak_id": "7",
                                "monoisotopic_mass": "4401.4274",
                                "monoisotopic_mz": "734.5785",
                                "intensity": "101843.86",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-3.9494431981e-02",
                                        "theoretical_mass": "4401.4341",
                                        "ion_position": "1",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "Y00037",
                                        "ion_left_position": "1",
                                        "mass_error": "-0.0067",
                                        "ppm": "-1.53"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000159",
                                "peak_id": "8",
                                "monoisotopic_mass": "615.3398",
                                "monoisotopic_mz": "616.3470",
                                "intensity": "189054.43",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "615.3453",
                                        "ion_position": "33",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "Y00005",
                                        "ion_left_position": "33",
                                        "mass_error": "-0.0055",
                                        "ppm": "-8.92"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000159",
                                "peak_id": "9",
                                "monoisotopic_mass": "487.2455",
                                "monoisotopic_mz": "488.2528",
                                "intensity": "97480.15",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "487.2503",
                                        "ion_position": "34",
                                        "ion_display_position": "4",
                                        "ion_sort_name": "Y00004",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0048",
                                        "ppm": "-9.84"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000159",
                                "peak_id": "10",
                                "monoisotopic_mass": "899.5296",
                                "monoisotopic_mz": "900.5369",
                                "intensity": "65956.64",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "899.5375",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "B00008",
                                        "ion_left_position": "8",
                                        "mass_error": "-0.0079",
                                        "ppm": "-8.78"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000159",
                                "peak_id": "11",
                                "monoisotopic_mass": "4273.3422",
                                "monoisotopic_mz": "713.2310",
                                "intensity": "178237.51",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-3.9494431981e-02",
                                        "theoretical_mass": "4273.3392",
                                        "ion_position": "2",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "Y00036",
                                        "ion_left_position": "2",
                                        "mass_error": "0.0030",
                                        "ppm": "0.71"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000159",
                                "peak_id": "12",
                                "monoisotopic_mass": "3397.8819",
                                "monoisotopic_mz": "850.4778",
                                "intensity": "79548.05",
                                "charge": "4"
                            },
                            {
                                "spec_id": "1000159",
                                "peak_id": "13",
                                "monoisotopic_mass": "752.3977",
                                "monoisotopic_mz": "377.2061",
                                "intensity": "130866.69",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "752.4042",
                                        "ion_position": "32",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "32",
                                        "mass_error": "-0.0064",
                                        "ppm": "-8.55"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000159",
                                "peak_id": "14",
                                "monoisotopic_mass": "593.2753",
                                "monoisotopic_mz": "198.7657",
                                "intensity": "50240.47",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000159",
                                "peak_id": "15",
                                "monoisotopic_mass": "1387.1142",
                                "monoisotopic_mz": "199.1664",
                                "intensity": "29809.64",
                                "charge": "7"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "10",
                    "proteoform_id": "12",
                    "sequence_name": "sp|P0A7Q8|RL36_SALTY",
                    "sequence_description": "50S ribosomal protein L36 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmJ PE=3 SV=1",
                    "proteoform_mass": "4532.4746",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "38",
                        "first_residue_position": "0",
                        "last_residue_position": "37",
                        "annotated_seq": ".MKVRASVK(KL(C)[Carbamidomethylation]RN(C)[Carbamidomethylation]KIVKRDGVIRVI(C)[Carbamidomethylation]SA)[-0.0395]EPKHKQRQG.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "K"
                            },
                            {
                                "position": "2",
                                "acid": "V"
                            },
                            {
                                "position": "3",
                                "acid": "R"
                            },
                            {
                                "position": "4",
                                "acid": "A"
                            },
                            {
                                "position": "5",
                                "acid": "S"
                            },
                            {
                                "position": "6",
                                "acid": "V"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "L"
                            },
                            {
                                "position": "10",
                                "acid": "C"
                            },
                            {
                                "position": "11",
                                "acid": "R"
                            },
                            {
                                "position": "12",
                                "acid": "N"
                            },
                            {
                                "position": "13",
                                "acid": "C"
                            },
                            {
                                "position": "14",
                                "acid": "K"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "V"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "R"
                            },
                            {
                                "position": "19",
                                "acid": "D"
                            },
                            {
                                "position": "20",
                                "acid": "G"
                            },
                            {
                                "position": "21",
                                "acid": "V"
                            },
                            {
                                "position": "22",
                                "acid": "I"
                            },
                            {
                                "position": "23",
                                "acid": "R"
                            },
                            {
                                "position": "24",
                                "acid": "V"
                            },
                            {
                                "position": "25",
                                "acid": "I"
                            },
                            {
                                "position": "26",
                                "acid": "C"
                            },
                            {
                                "position": "27",
                                "acid": "S"
                            },
                            {
                                "position": "28",
                                "acid": "A"
                            },
                            {
                                "position": "29",
                                "acid": "E"
                            },
                            {
                                "position": "30",
                                "acid": "P"
                            },
                            {
                                "position": "31",
                                "acid": "K"
                            },
                            {
                                "position": "32",
                                "acid": "H"
                            },
                            {
                                "position": "33",
                                "acid": "K"
                            },
                            {
                                "position": "34",
                                "acid": "Q"
                            },
                            {
                                "position": "35",
                                "acid": "R"
                            },
                            {
                                "position": "36",
                                "acid": "Q"
                            },
                            {
                                "position": "37",
                                "acid": "G"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "1",
                                        "ion_display_position": "37",
                                        "spec_id": "1000159",
                                        "peak_id": "7",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "2",
                                        "ion_display_position": "36",
                                        "spec_id": "1000159",
                                        "peak_id": "11",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "8",
                                            "ion_display_position": "8",
                                            "spec_id": "1000159",
                                            "peak_id": "10",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "8",
                                            "ion_display_position": "30",
                                            "spec_id": "1000159",
                                            "peak_id": "0",
                                            "peak_charge": "5"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "spec_id": "1000159",
                                        "peak_id": "3",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "30",
                                            "ion_display_position": "8",
                                            "spec_id": "1000159",
                                            "peak_id": "5",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "30",
                                            "ion_display_position": "30",
                                            "spec_id": "1000159",
                                            "peak_id": "1",
                                            "peak_charge": "5"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "30",
                                            "ion_display_position": "30",
                                            "spec_id": "1000159",
                                            "peak_id": "4",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "32",
                                            "ion_display_position": "6",
                                            "spec_id": "1000159",
                                            "peak_id": "6",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "32",
                                            "ion_display_position": "6",
                                            "spec_id": "1000159",
                                            "peak_id": "13",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "33",
                                        "ion_display_position": "5",
                                        "spec_id": "1000159",
                                        "peak_id": "8",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "34",
                                        "ion_display_position": "4",
                                        "spec_id": "1000159",
                                        "peak_id": "9",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": [
                                {
                                    "left_pos": "10",
                                    "right_pos": "11",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "13",
                                    "right_pos": "14",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "26",
                                    "right_pos": "27",
                                    "anno": "C"
                                }
                            ]
                        },
                        "mass_shift": {
                            "id": "0",
                            "left_position": "8",
                            "right_position": "29",
                            "shift": "-3.9494431981e-02",
                            "anno": "-0.0395",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "1",
                "p_value": "3.26e-09",
                "e_value": "3.26e-09",
                "fdr": "0",
                "matched_fragment_number": "10",
                "matched_peak_number": "13",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_1_ms2.msalign",
                        "ms1_ids": "173",
                        "ms1_scans": "332",
                        "ids": "158",
                        "scans": "333",
                        "precursor_mono_mass": "4532.4737",
                        "precursor_charge": "9",
                        "precursor_mz": "504.6155"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "158",
                                "peak_id": "0",
                                "monoisotopic_mass": "4384.4020",
                                "monoisotopic_mz": "549.0575",
                                "intensity": "1247462.32",
                                "charge": "8"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "1",
                                "monoisotopic_mass": "4401.4289",
                                "monoisotopic_mz": "551.1859",
                                "intensity": "712796.43",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-3.5464431981e-02",
                                        "theoretical_mass": "4401.4382",
                                        "ion_position": "1",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "Y00037",
                                        "ion_left_position": "1",
                                        "mass_error": "-0.0093",
                                        "ppm": "-2.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "2",
                                "monoisotopic_mass": "4273.3380",
                                "monoisotopic_mz": "535.1745",
                                "intensity": "1020521.30",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-3.5464431981e-02",
                                        "theoretical_mass": "4273.3432",
                                        "ion_position": "2",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "Y00036",
                                        "ion_left_position": "2",
                                        "mass_error": "-0.0053",
                                        "ppm": "-1.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "3",
                                "monoisotopic_mass": "1782.9766",
                                "monoisotopic_mz": "199.1158",
                                "intensity": "274330.21",
                                "charge": "9"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "4",
                                "monoisotopic_mass": "3354.8490",
                                "monoisotopic_mz": "671.9771",
                                "intensity": "1227614.89",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-3.5464431981e-02",
                                        "theoretical_mass": "3354.8471",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "0.0020",
                                        "ppm": "0.58"
                                    }
                                }
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "5",
                                "monoisotopic_mass": "3504.8461",
                                "monoisotopic_mz": "585.1483",
                                "intensity": "379329.18",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-3.5464431981e-02",
                                        "theoretical_mass": "3504.8462",
                                        "ion_position": "9",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "Y00029",
                                        "ion_left_position": "9",
                                        "mass_error": "-0.0001",
                                        "ppm": "-0.03"
                                    }
                                }
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "6",
                                "monoisotopic_mass": "3245.8247",
                                "monoisotopic_mz": "650.1722",
                                "intensity": "263251.79",
                                "charge": "5"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "7",
                                "monoisotopic_mass": "3425.8848",
                                "monoisotopic_mz": "686.1842",
                                "intensity": "1489383.25",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-3.5464431981e-02",
                                        "theoretical_mass": "3425.8842",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0006",
                                        "ppm": "0.17"
                                    }
                                }
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "8",
                                "monoisotopic_mass": "4367.3864",
                                "monoisotopic_mz": "546.9306",
                                "intensity": "139062.18",
                                "charge": "8"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "9",
                                "monoisotopic_mass": "752.3971",
                                "monoisotopic_mz": "753.4044",
                                "intensity": "362750.12",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "752.4042",
                                        "ion_position": "32",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "32",
                                        "mass_error": "-0.0071",
                                        "ppm": "-9.42"
                                    }
                                }
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "10",
                                "monoisotopic_mass": "3176.8074",
                                "monoisotopic_mz": "636.3688",
                                "intensity": "272771.04",
                                "charge": "5"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "11",
                                "monoisotopic_mass": "3267.8069",
                                "monoisotopic_mz": "545.6418",
                                "intensity": "162393.31",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-3.5464431981e-02",
                                        "theoretical_mass": "3267.8150",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "B00027",
                                        "ion_left_position": "27",
                                        "mass_error": "-0.0082",
                                        "ppm": "-2.50"
                                    }
                                }
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "12",
                                "monoisotopic_mass": "3899.1144",
                                "monoisotopic_mz": "558.0236",
                                "intensity": "83147.39",
                                "charge": "7"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "13",
                                "monoisotopic_mass": "3267.8229",
                                "monoisotopic_mz": "654.5719",
                                "intensity": "552144.15",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-3.5464431981e-02",
                                        "theoretical_mass": "3267.8150",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "B00027",
                                        "ion_left_position": "27",
                                        "mass_error": "0.0078",
                                        "ppm": "2.40"
                                    }
                                }
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "14",
                                "monoisotopic_mass": "3245.8346",
                                "monoisotopic_mz": "541.9797",
                                "intensity": "259289.72",
                                "charge": "6"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "15",
                                "monoisotopic_mass": "3337.8406",
                                "monoisotopic_mz": "835.4674",
                                "intensity": "188334.51",
                                "charge": "4"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "16",
                                "monoisotopic_mass": "977.5432",
                                "monoisotopic_mz": "326.8550",
                                "intensity": "1869212.03",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "977.5519",
                                        "ion_position": "30",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0087",
                                        "ppm": "-8.90"
                                    }
                                }
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "17",
                                "monoisotopic_mass": "752.3974",
                                "monoisotopic_mz": "377.2060",
                                "intensity": "645633.96",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "752.4042",
                                        "ion_position": "32",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "32",
                                        "mass_error": "-0.0067",
                                        "ppm": "-8.96"
                                    }
                                }
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "18",
                                "monoisotopic_mass": "861.4527",
                                "monoisotopic_mz": "862.4600",
                                "intensity": "58991.98",
                                "charge": "1"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "19",
                                "monoisotopic_mass": "615.3402",
                                "monoisotopic_mz": "616.3475",
                                "intensity": "287429.09",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "615.3453",
                                        "ion_position": "33",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "Y00005",
                                        "ion_left_position": "33",
                                        "mass_error": "-0.0051",
                                        "ppm": "-8.22"
                                    }
                                }
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "20",
                                "monoisotopic_mass": "880.4910",
                                "monoisotopic_mz": "441.2528",
                                "intensity": "174573.48",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "880.4991",
                                        "ion_position": "31",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "31",
                                        "mass_error": "-0.0081",
                                        "ppm": "-9.24"
                                    }
                                }
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "21",
                                "monoisotopic_mass": "960.5159",
                                "monoisotopic_mz": "321.1793",
                                "intensity": "73239.98",
                                "charge": "3"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "22",
                                "monoisotopic_mass": "615.3399",
                                "monoisotopic_mz": "308.6772",
                                "intensity": "167469.84",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "615.3453",
                                        "ion_position": "33",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "Y00005",
                                        "ion_left_position": "33",
                                        "mass_error": "-0.0053",
                                        "ppm": "-8.64"
                                    }
                                }
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "23",
                                "monoisotopic_mass": "3327.8575",
                                "monoisotopic_mz": "555.6502",
                                "intensity": "85849.59",
                                "charge": "6"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "24",
                                "monoisotopic_mass": "1088.5731",
                                "monoisotopic_mz": "545.2938",
                                "intensity": "220139.11",
                                "charge": "2"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "25",
                                "monoisotopic_mass": "3108.7955",
                                "monoisotopic_mz": "622.7664",
                                "intensity": "120795.75",
                                "charge": "5"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "26",
                                "monoisotopic_mass": "3176.7994",
                                "monoisotopic_mz": "530.4738",
                                "intensity": "119520.83",
                                "charge": "6"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "27",
                                "monoisotopic_mass": "640.3968",
                                "monoisotopic_mz": "641.4041",
                                "intensity": "92539.02",
                                "charge": "1"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "28",
                                "monoisotopic_mass": "3556.9316",
                                "monoisotopic_mz": "593.8292",
                                "intensity": "78929.94",
                                "charge": "6"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "29",
                                "monoisotopic_mass": "658.3643",
                                "monoisotopic_mz": "659.3716",
                                "intensity": "71847.35",
                                "charge": "1"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "30",
                                "monoisotopic_mass": "1186.6452",
                                "monoisotopic_mz": "594.3299",
                                "intensity": "25940.40",
                                "charge": "2"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "31",
                                "monoisotopic_mass": "3406.8719",
                                "monoisotopic_mz": "682.3816",
                                "intensity": "440088.75",
                                "charge": "5"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "32",
                                "monoisotopic_mass": "3007.6752",
                                "monoisotopic_mz": "602.5423",
                                "intensity": "96467.89",
                                "charge": "5"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "33",
                                "monoisotopic_mass": "3336.8340",
                                "monoisotopic_mz": "668.3741",
                                "intensity": "761138.69",
                                "charge": "5"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "34",
                                "monoisotopic_mass": "3222.8137",
                                "monoisotopic_mz": "645.5700",
                                "intensity": "116743.09",
                                "charge": "5"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "35",
                                "monoisotopic_mass": "469.2348",
                                "monoisotopic_mz": "470.2420",
                                "intensity": "135871.79",
                                "charge": "1"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "36",
                                "monoisotopic_mass": "538.9560",
                                "monoisotopic_mz": "539.9633",
                                "intensity": "79874.00",
                                "charge": "1"
                            },
                            {
                                "spec_id": "158",
                                "peak_id": "37",
                                "monoisotopic_mass": "685.7804",
                                "monoisotopic_mz": "686.7877",
                                "intensity": "132195.27",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "10",
                    "proteoform_id": "12",
                    "sequence_name": "sp|P0A7Q8|RL36_SALTY",
                    "sequence_description": "50S ribosomal protein L36 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmJ PE=3 SV=1",
                    "proteoform_mass": "4532.4787",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "38",
                        "first_residue_position": "0",
                        "last_residue_position": "37",
                        "annotated_seq": ".MKVRASVKK(L(C)[Carbamidomethylation]RN(C)[Carbamidomethylation]KIVKRDGVIRVI(C)[Carbamidomethylation])[-0.0355]SAEPKHKQRQG.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "K"
                            },
                            {
                                "position": "2",
                                "acid": "V"
                            },
                            {
                                "position": "3",
                                "acid": "R"
                            },
                            {
                                "position": "4",
                                "acid": "A"
                            },
                            {
                                "position": "5",
                                "acid": "S"
                            },
                            {
                                "position": "6",
                                "acid": "V"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "L"
                            },
                            {
                                "position": "10",
                                "acid": "C"
                            },
                            {
                                "position": "11",
                                "acid": "R"
                            },
                            {
                                "position": "12",
                                "acid": "N"
                            },
                            {
                                "position": "13",
                                "acid": "C"
                            },
                            {
                                "position": "14",
                                "acid": "K"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "V"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "R"
                            },
                            {
                                "position": "19",
                                "acid": "D"
                            },
                            {
                                "position": "20",
                                "acid": "G"
                            },
                            {
                                "position": "21",
                                "acid": "V"
                            },
                            {
                                "position": "22",
                                "acid": "I"
                            },
                            {
                                "position": "23",
                                "acid": "R"
                            },
                            {
                                "position": "24",
                                "acid": "V"
                            },
                            {
                                "position": "25",
                                "acid": "I"
                            },
                            {
                                "position": "26",
                                "acid": "C"
                            },
                            {
                                "position": "27",
                                "acid": "S"
                            },
                            {
                                "position": "28",
                                "acid": "A"
                            },
                            {
                                "position": "29",
                                "acid": "E"
                            },
                            {
                                "position": "30",
                                "acid": "P"
                            },
                            {
                                "position": "31",
                                "acid": "K"
                            },
                            {
                                "position": "32",
                                "acid": "H"
                            },
                            {
                                "position": "33",
                                "acid": "K"
                            },
                            {
                                "position": "34",
                                "acid": "Q"
                            },
                            {
                                "position": "35",
                                "acid": "R"
                            },
                            {
                                "position": "36",
                                "acid": "Q"
                            },
                            {
                                "position": "37",
                                "acid": "G"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "1",
                                        "ion_display_position": "37",
                                        "spec_id": "158",
                                        "peak_id": "1",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "2",
                                        "ion_display_position": "36",
                                        "spec_id": "158",
                                        "peak_id": "2",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "9",
                                        "ion_display_position": "29",
                                        "spec_id": "158",
                                        "peak_id": "5",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "27",
                                            "ion_display_position": "27",
                                            "spec_id": "158",
                                            "peak_id": "11",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "27",
                                            "ion_display_position": "27",
                                            "spec_id": "158",
                                            "peak_id": "13",
                                            "peak_charge": "5"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "158",
                                        "peak_id": "4",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "spec_id": "158",
                                        "peak_id": "7",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "30",
                                        "ion_display_position": "8",
                                        "spec_id": "158",
                                        "peak_id": "16",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "31",
                                        "ion_display_position": "7",
                                        "spec_id": "158",
                                        "peak_id": "20",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "32",
                                            "ion_display_position": "6",
                                            "spec_id": "158",
                                            "peak_id": "9",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "32",
                                            "ion_display_position": "6",
                                            "spec_id": "158",
                                            "peak_id": "17",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "33",
                                            "ion_display_position": "5",
                                            "spec_id": "158",
                                            "peak_id": "22",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "33",
                                            "ion_display_position": "5",
                                            "spec_id": "158",
                                            "peak_id": "19",
                                            "peak_charge": "1"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": [
                                {
                                    "left_pos": "10",
                                    "right_pos": "11",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "13",
                                    "right_pos": "14",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "26",
                                    "right_pos": "27",
                                    "anno": "C"
                                }
                            ]
                        },
                        "mass_shift": {
                            "id": "0",
                            "left_position": "9",
                            "right_position": "27",
                            "shift": "-3.5464431981e-02",
                            "anno": "-0.0355",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "130",
                "p_value": "7.77e-05",
                "e_value": "7.77e-05",
                "fdr": "0",
                "matched_fragment_number": "5",
                "matched_peak_number": "5",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_1/st_2_ms2.msalign",
                        "ms1_ids": "1000204",
                        "ms1_scans": "404",
                        "ids": "1000199",
                        "scans": "405",
                        "precursor_mono_mass": "6250.5424",
                        "precursor_charge": "9",
                        "precursor_mz": "695.5120"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "1000199",
                                "peak_id": "0",
                                "monoisotopic_mass": "4443.4730",
                                "monoisotopic_mz": "741.5861",
                                "intensity": "817328.89",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0324908038",
                                        "theoretical_mass": "4443.5042",
                                        "ion_position": "40",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "B00040",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0312",
                                        "ppm": "-7.02"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000199",
                                "peak_id": "1",
                                "monoisotopic_mass": "1807.0645",
                                "monoisotopic_mz": "904.5395",
                                "intensity": "83353.97",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000199",
                                "peak_id": "2",
                                "monoisotopic_mass": "1807.0669",
                                "monoisotopic_mz": "603.3629",
                                "intensity": "446895.09",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1807.0832",
                                        "ion_position": "40",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0163",
                                        "ppm": "-9.03"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000199",
                                "peak_id": "3",
                                "monoisotopic_mass": "1789.0548",
                                "monoisotopic_mz": "597.3589",
                                "intensity": "222195.31",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000199",
                                "peak_id": "4",
                                "monoisotopic_mass": "1847.0608",
                                "monoisotopic_mz": "616.6942",
                                "intensity": "47035.76",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0324908038",
                                        "theoretical_mass": "1847.0665",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "B00019",
                                        "ion_left_position": "19",
                                        "mass_error": "-0.0057",
                                        "ppm": "-3.07"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000199",
                                "peak_id": "5",
                                "monoisotopic_mass": "1783.6804",
                                "monoisotopic_mz": "199.1940",
                                "intensity": "82750.00",
                                "charge": "9"
                            },
                            {
                                "spec_id": "1000199",
                                "peak_id": "6",
                                "monoisotopic_mass": "878.5159",
                                "monoisotopic_mz": "879.5231",
                                "intensity": "47506.82",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "878.5226",
                                        "ion_position": "48",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "48",
                                        "mass_error": "-0.0067",
                                        "ppm": "-7.62"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000199",
                                "peak_id": "7",
                                "monoisotopic_mass": "3193.6603",
                                "monoisotopic_mz": "1065.5607",
                                "intensity": "86353.19",
                                "charge": "3"
                            },
                            {
                                "spec_id": "1000199",
                                "peak_id": "8",
                                "monoisotopic_mass": "1660.9629",
                                "monoisotopic_mz": "831.4887",
                                "intensity": "76521.88",
                                "charge": "2"
                            },
                            {
                                "spec_id": "1000199",
                                "peak_id": "9",
                                "monoisotopic_mass": "1249.8143",
                                "monoisotopic_mz": "625.9144",
                                "intensity": "25871.00",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-117.0324908038",
                                        "theoretical_mass": "1249.8158",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0015",
                                        "ppm": "-1.18"
                                    }
                                }
                            },
                            {
                                "spec_id": "1000199",
                                "peak_id": "10",
                                "monoisotopic_mass": "4427.4593",
                                "monoisotopic_mz": "738.9172",
                                "intensity": "78193.62",
                                "charge": "6"
                            },
                            {
                                "spec_id": "1000199",
                                "peak_id": "11",
                                "monoisotopic_mass": "741.5808",
                                "monoisotopic_mz": "742.5880",
                                "intensity": "31941.14",
                                "charge": "1"
                            },
                            {
                                "spec_id": "1000199",
                                "peak_id": "12",
                                "monoisotopic_mass": "6037.3849",
                                "monoisotopic_mz": "755.6804",
                                "intensity": "75755.93",
                                "charge": "8"
                            },
                            {
                                "spec_id": "1000199",
                                "peak_id": "13",
                                "monoisotopic_mass": "4255.4219",
                                "monoisotopic_mz": "852.0916",
                                "intensity": "39930.05",
                                "charge": "5"
                            },
                            {
                                "spec_id": "1000199",
                                "peak_id": "14",
                                "monoisotopic_mass": "990.4746",
                                "monoisotopic_mz": "199.1022",
                                "intensity": "25217.23",
                                "charge": "5"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "5",
                    "proteoform_id": "12",
                    "sequence_name": "sp|P0A7P2|RL33_SALTY",
                    "sequence_description": "50S ribosomal protein L33 OS=Salmonella typhimurium (strain LT2 / SGSC1412 / ATCC 700720) OX=99287 GN=rpmG PE=3 SV=2",
                    "proteoform_mass": "6250.5874",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "55",
                        "first_residue_position": "0",
                        "last_residue_position": "54",
                        "annotated_seq": ".(MAKGIREKIKLV)[-117.0325]SSAGTGHFYTTTKNKRTKPEKLELKKFDPVVRQHVIYKEAKIK.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "G"
                            },
                            {
                                "position": "4",
                                "acid": "I"
                            },
                            {
                                "position": "5",
                                "acid": "R"
                            },
                            {
                                "position": "6",
                                "acid": "E"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "I"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "L"
                            },
                            {
                                "position": "11",
                                "acid": "V"
                            },
                            {
                                "position": "12",
                                "acid": "S"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "T"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "H"
                            },
                            {
                                "position": "19",
                                "acid": "F"
                            },
                            {
                                "position": "20",
                                "acid": "Y"
                            },
                            {
                                "position": "21",
                                "acid": "T"
                            },
                            {
                                "position": "22",
                                "acid": "T"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "K"
                            },
                            {
                                "position": "25",
                                "acid": "N"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "R"
                            },
                            {
                                "position": "28",
                                "acid": "T"
                            },
                            {
                                "position": "29",
                                "acid": "K"
                            },
                            {
                                "position": "30",
                                "acid": "P"
                            },
                            {
                                "position": "31",
                                "acid": "E"
                            },
                            {
                                "position": "32",
                                "acid": "K"
                            },
                            {
                                "position": "33",
                                "acid": "L"
                            },
                            {
                                "position": "34",
                                "acid": "E"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "K"
                            },
                            {
                                "position": "38",
                                "acid": "F"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "V"
                            },
                            {
                                "position": "43",
                                "acid": "R"
                            },
                            {
                                "position": "44",
                                "acid": "Q"
                            },
                            {
                                "position": "45",
                                "acid": "H"
                            },
                            {
                                "position": "46",
                                "acid": "V"
                            },
                            {
                                "position": "47",
                                "acid": "I"
                            },
                            {
                                "position": "48",
                                "acid": "Y"
                            },
                            {
                                "position": "49",
                                "acid": "K"
                            },
                            {
                                "position": "50",
                                "acid": "E"
                            },
                            {
                                "position": "51",
                                "acid": "A"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "I"
                            },
                            {
                                "position": "54",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "spec_id": "1000199",
                                        "peak_id": "9",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "spec_id": "1000199",
                                        "peak_id": "4",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "40",
                                            "ion_display_position": "15",
                                            "spec_id": "1000199",
                                            "peak_id": "2",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "40",
                                            "ion_display_position": "40",
                                            "spec_id": "1000199",
                                            "peak_id": "0",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "48",
                                        "ion_display_position": "7",
                                        "spec_id": "1000199",
                                        "peak_id": "6",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "12",
                            "shift": "-117.0324908038",
                            "anno": "-117.0325",
                            "shift_type": "unexpected"
                        }
                    }
                }
            }
        ]
    }
}
